
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_notify.h"
#include "librpc/gen_ndr/ndr_notify_ejs.h"


_PUBLIC_ NTSTATUS ejs_push_notify_entry(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct notify_entry *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_server_id(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_push_uint32(ejs, v, "filter", &r->filter));
	NDR_CHECK(ejs_push_uint32(ejs, v, "subdir_filter", &r->subdir_filter));
	NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	NDR_CHECK(ejs_push_uint32(ejs, v, "path_len", &r->path_len));
	NDR_CHECK(ejs_push_pointer(ejs, v, "private_data", &r->private_data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_notify_entry(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct notify_entry *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_server_id(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "filter", &r->filter));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "subdir_filter", &r->subdir_filter));
	NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "path_len", &r->path_len));
	NDR_CHECK(ejs_pull_pointer(ejs, v, "private_data", &r->private_data));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_notify_depth(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct notify_depth *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_mask", &r->max_mask));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_mask_subdir", &r->max_mask_subdir));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_entries", &r->num_entries));
	{
		uint32_t i;
		for (i=0;i<r->num_entries;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_push_notify_entry(ejs, v, id, &r->entries[i]));
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_notify_depth(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct notify_depth *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_mask", &r->max_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_mask_subdir", &r->max_mask_subdir));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_entries", &r->num_entries));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->entries, r->num_entries);
		for (i=0;i<r->num_entries;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_pull_notify_entry(ejs, v, id, &r->entries[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_notify_array(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct notify_array *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_depths", &r->num_depths));
	{
		uint32_t i;
		for (i=0;i<r->num_depths;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "depth", i);
			NDR_CHECK(ejs_push_notify_depth(ejs, v, id, &r->depth[i]));
		}
		ejs_push_uint32(ejs, v, "depth" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_notify_array(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct notify_array *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_depths", &r->num_depths));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->depth, r->num_depths);
		for (i=0;i<r->num_depths;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "depth", i);
			NDR_CHECK(ejs_pull_notify_depth(ejs, v, id, &r->depth[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "depth" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_notify_event(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct notify_event *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "action", &r->action));
	NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	NDR_CHECK(ejs_push_pointer(ejs, v, "private_data", &r->private_data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_notify_event(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct notify_event *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "action", &r->action));
	NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	NDR_CHECK(ejs_pull_pointer(ejs, v, "private_data", &r->private_data));
	return NT_STATUS_OK;
}

static int ejs_notify_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "notify", argc, argv);
	return ejs_rpc_init(obj, "notify");
}

NTSTATUS ejs_init_notify(void)
{
	ejsDefineCFunction(-1, "notify_init", ejs_notify_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
