
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_nbt.h"
#include "librpc/gen_ndr/ndr_nbt_ejs.h"


static NTSTATUS ejs_push_nbt_operation(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint16_t *r)
{
	return ejs_push_uint16(ejs, v, name, r);
}
static NTSTATUS ejs_pull_nbt_operation(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint16_t *r)
{
	return ejs_pull_uint16(ejs, v, name, r);
}
static NTSTATUS ejs_push_nbt_name_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum nbt_name_type *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_name_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbt_name_type *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_nbt_name(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_name *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	NDR_CHECK(ejs_push_string(ejs, v, "scope", r->scope));
	NDR_CHECK(ejs_push_nbt_name_type(ejs, v, "type", &r->type));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nbt_name(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_name *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_string(ejs, v, "scope", &r->scope));
	NDR_CHECK(ejs_pull_nbt_name_type(ejs, v, "type", &r->type));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_qclass(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum nbt_qclass *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_qclass(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbt_qclass *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_qtype(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum nbt_qtype *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_qtype(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbt_qtype *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_name_question(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_name_question *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_nbt_name(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_nbt_qtype(ejs, v, "question_type", &r->question_type));
	NDR_CHECK(ejs_push_nbt_qclass(ejs, v, "question_class", &r->question_class));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_name_question(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_name_question *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_nbt_name(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_nbt_qtype(ejs, v, "question_type", &r->question_type));
	NDR_CHECK(ejs_pull_nbt_qclass(ejs, v, "question_class", &r->question_class));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nb_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint16_t *r)
{
	return ejs_push_uint16(ejs, v, name, r);
}
static NTSTATUS ejs_pull_nb_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint16_t *r)
{
	return ejs_pull_uint16(ejs, v, name, r);
}
static NTSTATUS ejs_push_nbt_rdata_address(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_rdata_address *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_nb_flags(ejs, v, "nb_flags", &r->nb_flags));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "ipaddr", r->ipaddr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_rdata_address(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_rdata_address *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_nb_flags(ejs, v, "nb_flags", &r->nb_flags));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "ipaddr", &r->ipaddr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_rdata_netbios(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_rdata_netbios *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	{
		uint32_t i;
		for (i=0;i<r->length / 6;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "addresses", i);
			NDR_CHECK(ejs_push_nbt_rdata_address(ejs, v, id, &r->addresses[i]));
		}
		ejs_push_uint32(ejs, v, "addresses" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_rdata_netbios(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_rdata_netbios *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "length", &r->length));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->addresses, r->length / 6);
		for (i=0;i<r->length / 6;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "addresses", i);
			NDR_CHECK(ejs_pull_nbt_rdata_address(ejs, v, id, &r->addresses[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "addresses" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_statistics(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_statistics *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	ejs_push_array_uint8(ejs, v, "unit_id", r->unit_id, 6);
	NDR_CHECK(ejs_push_uint8(ejs, v, "jumpers", &r->jumpers));
	NDR_CHECK(ejs_push_uint8(ejs, v, "test_result", &r->test_result));
	NDR_CHECK(ejs_push_uint16(ejs, v, "version_number", &r->version_number));
	NDR_CHECK(ejs_push_uint16(ejs, v, "period_of_statistics", &r->period_of_statistics));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_of_crcs", &r->number_of_crcs));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_alignment_errors", &r->number_alignment_errors));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_of_collisions", &r->number_of_collisions));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_send_aborts", &r->number_send_aborts));
	NDR_CHECK(ejs_push_uint32(ejs, v, "number_good_sends", &r->number_good_sends));
	NDR_CHECK(ejs_push_uint32(ejs, v, "number_good_receives", &r->number_good_receives));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_retransmits", &r->number_retransmits));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_no_resource_conditions", &r->number_no_resource_conditions));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_free_command_blocks", &r->number_free_command_blocks));
	NDR_CHECK(ejs_push_uint16(ejs, v, "total_number_command_blocks", &r->total_number_command_blocks));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_total_number_command_blocks", &r->max_total_number_command_blocks));
	NDR_CHECK(ejs_push_uint16(ejs, v, "number_pending_sessions", &r->number_pending_sessions));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_number_pending_sessions", &r->max_number_pending_sessions));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_total_sessions_possible", &r->max_total_sessions_possible));
	NDR_CHECK(ejs_push_uint16(ejs, v, "session_data_packet_size", &r->session_data_packet_size));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_statistics(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_statistics *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "unit_id", r->unit_id, 6);
	NDR_CHECK(ejs_pull_uint8(ejs, v, "jumpers", &r->jumpers));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "test_result", &r->test_result));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "version_number", &r->version_number));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "period_of_statistics", &r->period_of_statistics));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_of_crcs", &r->number_of_crcs));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_alignment_errors", &r->number_alignment_errors));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_of_collisions", &r->number_of_collisions));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_send_aborts", &r->number_send_aborts));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "number_good_sends", &r->number_good_sends));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "number_good_receives", &r->number_good_receives));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_retransmits", &r->number_retransmits));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_no_resource_conditions", &r->number_no_resource_conditions));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_free_command_blocks", &r->number_free_command_blocks));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "total_number_command_blocks", &r->total_number_command_blocks));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_total_number_command_blocks", &r->max_total_number_command_blocks));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "number_pending_sessions", &r->number_pending_sessions));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_number_pending_sessions", &r->max_number_pending_sessions));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_total_sessions_possible", &r->max_total_sessions_possible));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "session_data_packet_size", &r->session_data_packet_size));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_status_name(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_status_name *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	NDR_CHECK(ejs_push_nbt_name_type(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_nb_flags(ejs, v, "nb_flags", &r->nb_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_status_name(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_status_name *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_nbt_name_type(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_nb_flags(ejs, v, "nb_flags", &r->nb_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_rdata_status(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_rdata_status *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint8(ejs, v, "num_names", &r->num_names));
	{
		uint32_t i;
		for (i=0;i<r->num_names;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_push_nbt_status_name(ejs, v, id, &r->names[i]));
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	NDR_CHECK(ejs_push_nbt_statistics(ejs, v, "statistics", &r->statistics));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_rdata_status(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_rdata_status *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "num_names", &r->num_names));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->names, r->num_names);
		for (i=0;i<r->num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_nbt_status_name(ejs, v, id, &r->names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	NDR_CHECK(ejs_pull_nbt_statistics(ejs, v, "statistics", &r->statistics));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_rdata_data(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_rdata_data *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	ejs_push_array_uint8(ejs, v, "data", r->data, r->length);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_rdata_data(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_rdata_data *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "length", &r->length));
	EJS_ALLOC_N(ejs, r->data, r->length);
	ejs_pull_array_uint8(ejs, v, "data", r->data, r->length);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_rdata(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union nbt_rdata *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NBT_QTYPE_NETBIOS:
			NDR_CHECK(ejs_push_nbt_rdata_netbios(ejs, v, "netbios", &r->netbios));
			break;
		case NBT_QTYPE_STATUS:
			NDR_CHECK(ejs_push_nbt_rdata_status(ejs, v, "status", &r->status));
			break;
		default:
			NDR_CHECK(ejs_push_nbt_rdata_data(ejs, v, "data", &r->data));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_nbt_rdata(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union nbt_rdata *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NBT_QTYPE_NETBIOS:
			NDR_CHECK(ejs_pull_nbt_rdata_netbios(ejs, v, "netbios", &r->netbios));
			break;
		case NBT_QTYPE_STATUS:
			NDR_CHECK(ejs_pull_nbt_rdata_status(ejs, v, "status", &r->status));
			break;
		default:
			NDR_CHECK(ejs_pull_nbt_rdata_data(ejs, v, "data", &r->data));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_nbt_res_rec(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_res_rec *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_nbt_name(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_nbt_qtype(ejs, v, "rr_type", &r->rr_type));
	NDR_CHECK(ejs_push_nbt_qclass(ejs, v, "rr_class", &r->rr_class));
	NDR_CHECK(ejs_push_uint32(ejs, v, "ttl", &r->ttl));
	ejs_set_switch(ejs, ((((r->rr_type) == NBT_QTYPE_NETBIOS) && talloc_check_name(ndr, "struct ndr_push") && ((r->rdata).data.length == 2))?0:r->rr_type));
	NDR_CHECK(ejs_push_nbt_rdata(ejs, v, "rdata", &r->rdata));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_res_rec(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_res_rec *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_nbt_name(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_nbt_qtype(ejs, v, "rr_type", &r->rr_type));
	NDR_CHECK(ejs_pull_nbt_qclass(ejs, v, "rr_class", &r->rr_class));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ttl", &r->ttl));
	ejs_set_switch(ejs, ((((r->rr_type) == NBT_QTYPE_NETBIOS) && talloc_check_name(ndr, "struct ndr_push") && ((r->rdata).data.length == 2))?0:r->rr_type));
	NDR_CHECK(ejs_pull_nbt_rdata(ejs, v, "rdata", &r->rdata));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_nbt_name_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_name_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "name_trn_id", &r->name_trn_id));
	NDR_CHECK(ejs_push_nbt_operation(ejs, v, "operation", &r->operation));
	NDR_CHECK(ejs_push_uint16(ejs, v, "qdcount", &r->qdcount));
	NDR_CHECK(ejs_push_uint16(ejs, v, "ancount", &r->ancount));
	NDR_CHECK(ejs_push_uint16(ejs, v, "nscount", &r->nscount));
	NDR_CHECK(ejs_push_uint16(ejs, v, "arcount", &r->arcount));
	{
		uint32_t i;
		for (i=0;i<r->qdcount;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "questions", i);
			NDR_CHECK(ejs_push_nbt_name_question(ejs, v, id, &r->questions[i]));
		}
		ejs_push_uint32(ejs, v, "questions" ".length", &i);
	}
	{
		uint32_t i;
		for (i=0;i<r->ancount;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "answers", i);
			NDR_CHECK(ejs_push_nbt_res_rec(ejs, v, id, &r->answers[i]));
		}
		ejs_push_uint32(ejs, v, "answers" ".length", &i);
	}
	{
		uint32_t i;
		for (i=0;i<r->nscount;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "nsrecs", i);
			NDR_CHECK(ejs_push_nbt_res_rec(ejs, v, id, &r->nsrecs[i]));
		}
		ejs_push_uint32(ejs, v, "nsrecs" ".length", &i);
	}
	{
		uint32_t i;
		for (i=0;i<r->arcount;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "additional", i);
			NDR_CHECK(ejs_push_nbt_res_rec(ejs, v, id, &r->additional[i]));
		}
		ejs_push_uint32(ejs, v, "additional" ".length", &i);
	}
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "padding", &r->padding));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nbt_name_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_name_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "name_trn_id", &r->name_trn_id));
	NDR_CHECK(ejs_pull_nbt_operation(ejs, v, "operation", &r->operation));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "qdcount", &r->qdcount));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "ancount", &r->ancount));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "nscount", &r->nscount));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "arcount", &r->arcount));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->questions, r->qdcount);
		for (i=0;i<r->qdcount;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "questions", i);
			NDR_CHECK(ejs_pull_nbt_name_question(ejs, v, id, &r->questions[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "questions" ".length", &i);
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->answers, r->ancount);
		for (i=0;i<r->ancount;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "answers", i);
			NDR_CHECK(ejs_pull_nbt_res_rec(ejs, v, id, &r->answers[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "answers" ".length", &i);
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->nsrecs, r->nscount);
		for (i=0;i<r->nscount;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "nsrecs", i);
			NDR_CHECK(ejs_pull_nbt_res_rec(ejs, v, id, &r->nsrecs[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "nsrecs" ".length", &i);
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->additional, r->arcount);
		for (i=0;i<r->arcount;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "additional", i);
			NDR_CHECK(ejs_pull_nbt_res_rec(ejs, v, id, &r->additional[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "additional" ".length", &i);
	}
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "padding", &r->padding));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dgram_msg_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dgram_msg_type *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dgram_msg_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum dgram_msg_type *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dgram_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint8_t *r)
{
	return ejs_push_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_pull_dgram_flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint8_t *r)
{
	return ejs_pull_uint8(ejs, v, name, r);
}
static NTSTATUS ejs_push_smb_command(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum smb_command *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_smb_command(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum smb_command *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smb_trans_body(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct smb_trans_body *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "wct", &r->wct));
	NDR_CHECK(ejs_push_uint16(ejs, v, "total_param_count", &r->total_param_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "total_data_count", &r->total_data_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_param_count", &r->max_param_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_data_count", &r->max_data_count));
	NDR_CHECK(ejs_push_uint8(ejs, v, "max_setup_count", &r->max_setup_count));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pad", &r->pad));
	NDR_CHECK(ejs_push_uint16(ejs, v, "trans_flags", &r->trans_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_push_uint16(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_push_uint16(ejs, v, "param_count", &r->param_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "param_offset", &r->param_offset));
	NDR_CHECK(ejs_push_uint16(ejs, v, "data_count", &r->data_count));
	NDR_CHECK(ejs_push_uint16(ejs, v, "data_offset", &r->data_offset));
	NDR_CHECK(ejs_push_uint8(ejs, v, "setup_count", &r->setup_count));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pad2", &r->pad2));
	NDR_CHECK(ejs_push_uint16(ejs, v, "opcode", &r->opcode));
	NDR_CHECK(ejs_push_uint16(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_push_uint16(ejs, v, "class", &r->class));
	NDR_CHECK(ejs_push_uint16(ejs, v, "byte_count", &r->byte_count));
	NDR_CHECK(ejs_push_string(ejs, v, "mailslot_name", r->mailslot_name));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_smb_trans_body(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct smb_trans_body *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "total_param_count", &r->total_param_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "total_data_count", &r->total_data_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_param_count", &r->max_param_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_data_count", &r->max_data_count));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "max_setup_count", &r->max_setup_count));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pad", &r->pad));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "trans_flags", &r->trans_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timeout", &r->timeout));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "param_count", &r->param_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "param_offset", &r->param_offset));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "data_count", &r->data_count));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "data_offset", &r->data_offset));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pad2", &r->pad2));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "opcode", &r->opcode));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "priority", &r->priority));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "class", &r->class));
	NDR_CHECK(ejs_pull_string(ejs, v, "mailslot_name", &r->mailslot_name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_smb_body(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union smb_body *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SMB_TRANSACTION:
			NDR_CHECK(ejs_push_smb_trans_body(ejs, v, "trans", &r->trans));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_smb_body(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union smb_body *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case SMB_TRANSACTION:
			NDR_CHECK(ejs_pull_smb_trans_body(ejs, v, "trans", &r->trans));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_dgram_smb_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dgram_smb_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_smb_command(ejs, v, "smb_command", &r->smb_command));
	NDR_CHECK(ejs_push_uint8(ejs, v, "err_class", &r->err_class));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pad", &r->pad));
	NDR_CHECK(ejs_push_uint16(ejs, v, "err_code", &r->err_code));
	NDR_CHECK(ejs_push_uint8(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint16(ejs, v, "flags2", &r->flags2));
	NDR_CHECK(ejs_push_uint16(ejs, v, "pid_high", &r->pid_high));
	ejs_push_array_uint8(ejs, v, "signature", r->signature, 8);
	NDR_CHECK(ejs_push_uint16(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_push_uint16(ejs, v, "tid", &r->tid));
	NDR_CHECK(ejs_push_uint16(ejs, v, "pid", &r->pid));
	NDR_CHECK(ejs_push_uint16(ejs, v, "vuid", &r->vuid));
	NDR_CHECK(ejs_push_uint16(ejs, v, "mid", &r->mid));
	ejs_set_switch(ejs, r->smb_command);
	NDR_CHECK(ejs_push_smb_body(ejs, v, "body", &r->body));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dgram_smb_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dgram_smb_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_smb_command(ejs, v, "smb_command", &r->smb_command));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "err_class", &r->err_class));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pad", &r->pad));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "err_code", &r->err_code));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "flags2", &r->flags2));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "pid_high", &r->pid_high));
	ejs_pull_array_uint8(ejs, v, "signature", r->signature, 8);
	NDR_CHECK(ejs_pull_uint16(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "tid", &r->tid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "pid", &r->pid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "vuid", &r->vuid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "mid", &r->mid));
	ejs_set_switch(ejs, r->smb_command);
	NDR_CHECK(ejs_pull_smb_body(ejs, v, "body", &r->body));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dgram_message_body(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dgram_message_body *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DGRAM_SMB:
			NDR_CHECK(ejs_push_dgram_smb_packet(ejs, v, "smb", &r->smb));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dgram_message_body(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dgram_message_body *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DGRAM_SMB:
			NDR_CHECK(ejs_pull_dgram_smb_packet(ejs, v, "smb", &r->smb));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_dgram_message(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dgram_message *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "offset", &r->offset));
	NDR_CHECK(ejs_push_nbt_name(ejs, v, "source_name", &r->source_name));
	NDR_CHECK(ejs_push_nbt_name(ejs, v, "dest_name", &r->dest_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "dgram_body_type", &r->dgram_body_type));
	ejs_set_switch(ejs, r->dgram_body_type);
	NDR_CHECK(ejs_push_dgram_message_body(ejs, v, "body", &r->body));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dgram_message(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dgram_message *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "offset", &r->offset));
	NDR_CHECK(ejs_pull_nbt_name(ejs, v, "source_name", &r->source_name));
	NDR_CHECK(ejs_pull_nbt_name(ejs, v, "dest_name", &r->dest_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dgram_body_type", &r->dgram_body_type));
	ejs_set_switch(ejs, r->dgram_body_type);
	NDR_CHECK(ejs_pull_dgram_message_body(ejs, v, "body", &r->body));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dgram_err_code(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dgram_err_code *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dgram_err_code(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum dgram_err_code *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dgram_data(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dgram_data *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DGRAM_DIRECT_UNIQUE:
			NDR_CHECK(ejs_push_dgram_message(ejs, v, "msg", &r->msg));
			break;
		case DGRAM_DIRECT_GROUP:
			NDR_CHECK(ejs_push_dgram_message(ejs, v, "msg", &r->msg));
			break;
		case DGRAM_BCAST:
			NDR_CHECK(ejs_push_dgram_message(ejs, v, "msg", &r->msg));
			break;
		case DGRAM_ERROR:
			NDR_CHECK(ejs_push_dgram_err_code(ejs, v, "error", &r->error));
			break;
		case DGRAM_QUERY:
			NDR_CHECK(ejs_push_nbt_name(ejs, v, "dest_name", &r->dest_name));
			break;
		case DGRAM_QUERY_POSITIVE:
			NDR_CHECK(ejs_push_nbt_name(ejs, v, "dest_name", &r->dest_name));
			break;
		case DGRAM_QUERY_NEGATIVE:
			NDR_CHECK(ejs_push_nbt_name(ejs, v, "dest_name", &r->dest_name));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dgram_data(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dgram_data *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DGRAM_DIRECT_UNIQUE:
			NDR_CHECK(ejs_pull_dgram_message(ejs, v, "msg", &r->msg));
			break;
		case DGRAM_DIRECT_GROUP:
			NDR_CHECK(ejs_pull_dgram_message(ejs, v, "msg", &r->msg));
			break;
		case DGRAM_BCAST:
			NDR_CHECK(ejs_pull_dgram_message(ejs, v, "msg", &r->msg));
			break;
		case DGRAM_ERROR:
			NDR_CHECK(ejs_pull_dgram_err_code(ejs, v, "error", &r->error));
			break;
		case DGRAM_QUERY:
			NDR_CHECK(ejs_pull_nbt_name(ejs, v, "dest_name", &r->dest_name));
			break;
		case DGRAM_QUERY_POSITIVE:
			NDR_CHECK(ejs_pull_nbt_name(ejs, v, "dest_name", &r->dest_name));
			break;
		case DGRAM_QUERY_NEGATIVE:
			NDR_CHECK(ejs_pull_nbt_name(ejs, v, "dest_name", &r->dest_name));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_nbt_dgram_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_dgram_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_dgram_msg_type(ejs, v, "msg_type", &r->msg_type));
	NDR_CHECK(ejs_push_dgram_flags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint16(ejs, v, "dgram_id", &r->dgram_id));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "src_addr", r->src_addr));
	NDR_CHECK(ejs_push_uint16(ejs, v, "src_port", &r->src_port));
	ejs_set_switch(ejs, r->msg_type);
	NDR_CHECK(ejs_push_dgram_data(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nbt_dgram_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_dgram_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_dgram_msg_type(ejs, v, "msg_type", &r->msg_type));
	NDR_CHECK(ejs_pull_dgram_flags(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "dgram_id", &r->dgram_id));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "src_addr", &r->src_addr));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "src_port", &r->src_port));
	ejs_set_switch(ejs, r->msg_type);
	NDR_CHECK(ejs_pull_dgram_data(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_netlogon_command(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum nbt_netlogon_command *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_netlogon_command(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbt_netlogon_command *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_netlogon_query_for_pdc(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_netlogon_query_for_pdc *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "computer_name", r->computer_name));
	NDR_CHECK(ejs_push_string(ejs, v, "mailslot_name", r->mailslot_name));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_string(ejs, v, "unicode_name", r->unicode_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_netlogon_query_for_pdc(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_netlogon_query_for_pdc *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->computer_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "mailslot_name", &r->mailslot_name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_string(ejs, v, "unicode_name", &r->unicode_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_netlogon_query_for_pdc2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_netlogon_query_for_pdc2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "request_count", &r->request_count));
	NDR_CHECK(ejs_push_string(ejs, v, "computer_name", r->computer_name));
	NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_string(ejs, v, "mailslot_name", r->mailslot_name));
	{
		uint32_t i;
		for (i=0;i<2;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown[i]));
		}
		ejs_push_uint32(ejs, v, "unknown" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_netlogon_query_for_pdc2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_netlogon_query_for_pdc2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "request_count", &r->request_count));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->computer_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "mailslot_name", &r->mailslot_name));
	{
		uint32_t i;
		for (i=0;i<2;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "unknown", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->unknown[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "unknown" ".length", &i);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_netlogon_response_from_pdc(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_netlogon_response_from_pdc *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_string(ejs, v, "unicode_pdc_name", r->unicode_pdc_name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_netlogon_response_from_pdc(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_netlogon_response_from_pdc *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_string(ejs, v, "unicode_pdc_name", &r->unicode_pdc_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_server_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_nbt_server_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_nbt_netlogon_response_from_pdc2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_netlogon_response_from_pdc2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "forest", r->forest));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "dns_domain", r->dns_domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_dns_name", r->pdc_dns_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "server_site", r->server_site));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "client_site", r->client_site));
	NDR_CHECK(ejs_push_uint8(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "pdc_ip", r->pdc_ip));
	{
		uint32_t i;
		for (i=0;i<2;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown3", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown3[i]));
		}
		ejs_push_uint32(ejs, v, "unknown3" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_netlogon_response_from_pdc2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_netlogon_response_from_pdc2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "dns_domain", &r->dns_domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_dns_name", &r->pdc_dns_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "server_site", &r->server_site));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "client_site", &r->client_site));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "pdc_ip", &r->pdc_ip));
	{
		uint32_t i;
		for (i=0;i<2;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "unknown3", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->unknown3[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "unknown3" ".length", &i);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_db_change(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_db_change *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_netr_SamDatabaseID(ejs, v, "db_index", &r->db_index));
	NDR_CHECK(ejs_push_hyper(ejs, v, "serial", &r->serial));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "timestamp", &r->timestamp));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_db_change(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_db_change *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_netr_SamDatabaseID(ejs, v, "db_index", &r->db_index));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "serial", &r->serial));
	NDR_CHECK(ejs_pull_NTTIME(ejs, v, "timestamp", &r->timestamp));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_netlogon_announce_uas(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_netlogon_announce_uas *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "serial_lo", &r->serial_lo));
	NDR_CHECK(ejs_push_time_t(ejs, v, "timestamp", &r->timestamp));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pulse", &r->pulse));
	NDR_CHECK(ejs_push_uint32(ejs, v, "random", &r->random));
	NDR_CHECK(ejs_push_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_string(ejs, v, "unicode_pdc_name", r->unicode_pdc_name));
	NDR_CHECK(ejs_push_string(ejs, v, "unicode_domain", r->unicode_domain));
	NDR_CHECK(ejs_push_uint32(ejs, v, "db_count", &r->db_count));
	{
		uint32_t i;
		for (i=0;i<r->db_count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "dbchange", i);
			NDR_CHECK(ejs_push_nbt_db_change(ejs, v, id, &r->dbchange[i]));
		}
		ejs_push_uint32(ejs, v, "dbchange" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_size", &r->sid_size));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad2", &r->_pad2));
	NDR_CHECK(ejs_push_dom_sid(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_netlogon_announce_uas(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_netlogon_announce_uas *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "serial_lo", &r->serial_lo));
	NDR_CHECK(ejs_pull_time_t(ejs, v, "timestamp", &r->timestamp));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pulse", &r->pulse));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "random", &r->random));
	NDR_CHECK(ejs_pull_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_string(ejs, v, "unicode_pdc_name", &r->unicode_pdc_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "unicode_domain", &r->unicode_domain));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "db_count", &r->db_count));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->dbchange, r->db_count);
		for (i=0;i<r->db_count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "dbchange", i);
			NDR_CHECK(ejs_pull_nbt_db_change(ejs, v, id, &r->dbchange[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "dbchange" ".length", &i);
	}
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad2", &r->_pad2));
	NDR_CHECK(ejs_pull_dom_sid(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_netlogon_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union nbt_netlogon_request *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NETLOGON_QUERY_FOR_PDC:
			NDR_CHECK(ejs_push_nbt_netlogon_query_for_pdc(ejs, v, "pdc", &r->pdc));
			break;
		case NETLOGON_QUERY_FOR_PDC2:
			NDR_CHECK(ejs_push_nbt_netlogon_query_for_pdc2(ejs, v, "pdc2", &r->pdc2));
			break;
		case NETLOGON_ANNOUNCE_UAS:
			NDR_CHECK(ejs_push_nbt_netlogon_announce_uas(ejs, v, "uas", &r->uas));
			break;
		case NETLOGON_RESPONSE_FROM_PDC:
			NDR_CHECK(ejs_push_nbt_netlogon_response_from_pdc(ejs, v, "response", &r->response));
			break;
		case NETLOGON_RESPONSE_FROM_PDC2:
			NDR_CHECK(ejs_push_nbt_netlogon_response_from_pdc2(ejs, v, "response2", &r->response2));
			break;
		case NETLOGON_RESPONSE_FROM_PDC_USER:
			NDR_CHECK(ejs_push_nbt_netlogon_response_from_pdc2(ejs, v, "response2", &r->response2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_nbt_netlogon_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union nbt_netlogon_request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NETLOGON_QUERY_FOR_PDC:
			NDR_CHECK(ejs_pull_nbt_netlogon_query_for_pdc(ejs, v, "pdc", &r->pdc));
			break;
		case NETLOGON_QUERY_FOR_PDC2:
			NDR_CHECK(ejs_pull_nbt_netlogon_query_for_pdc2(ejs, v, "pdc2", &r->pdc2));
			break;
		case NETLOGON_ANNOUNCE_UAS:
			NDR_CHECK(ejs_pull_nbt_netlogon_announce_uas(ejs, v, "uas", &r->uas));
			break;
		case NETLOGON_RESPONSE_FROM_PDC:
			NDR_CHECK(ejs_pull_nbt_netlogon_response_from_pdc(ejs, v, "response", &r->response));
			break;
		case NETLOGON_RESPONSE_FROM_PDC2:
			NDR_CHECK(ejs_pull_nbt_netlogon_response_from_pdc2(ejs, v, "response2", &r->response2));
			break;
		case NETLOGON_RESPONSE_FROM_PDC_USER:
			NDR_CHECK(ejs_pull_nbt_netlogon_response_from_pdc2(ejs, v, "response2", &r->response2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_nbt_netlogon_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_netlogon_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_nbt_netlogon_command(ejs, v, "command", &r->command));
	ejs_set_switch(ejs, r->command);
	NDR_CHECK(ejs_push_nbt_netlogon_request(ejs, v, "req", &r->req));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nbt_netlogon_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_netlogon_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_nbt_netlogon_command(ejs, v, "command", &r->command));
	ejs_set_switch(ejs, r->command);
	NDR_CHECK(ejs_pull_nbt_netlogon_request(ejs, v, "req", &r->req));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_cldap_netlogon_1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_cldap_netlogon_1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_cldap_netlogon_1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_cldap_netlogon_1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_cldap_netlogon_3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_cldap_netlogon_3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "unknown_uuid", &r->unknown_uuid));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "forest", r->forest));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "dns_domain", r->dns_domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_dns_name", r->pdc_dns_name));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "pdc_ip", r->pdc_ip));
	NDR_CHECK(ejs_push_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_cldap_netlogon_3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_cldap_netlogon_3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "unknown_uuid", &r->unknown_uuid));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "dns_domain", &r->dns_domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_dns_name", &r->pdc_dns_name));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "pdc_ip", &r->pdc_ip));
	NDR_CHECK(ejs_pull_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_cldap_netlogon_5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_cldap_netlogon_5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "forest", r->forest));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "dns_domain", r->dns_domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_dns_name", r->pdc_dns_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "server_site", r->server_site));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "client_site", r->client_site));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_cldap_netlogon_5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_cldap_netlogon_5 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "dns_domain", &r->dns_domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_dns_name", &r->pdc_dns_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "server_site", &r->server_site));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "client_site", &r->client_site));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_cldap_netlogon_13(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_cldap_netlogon_13 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_push_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "forest", r->forest));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "dns_domain", r->dns_domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_dns_name", r->pdc_dns_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "pdc_name", r->pdc_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "server_site", r->server_site));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "client_site", r->client_site));
	NDR_CHECK(ejs_push_uint8(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_ipv4address(ejs, v, "pdc_ip", r->pdc_ip));
	{
		uint32_t i;
		for (i=0;i<2;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "unknown3", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->unknown3[i]));
		}
		ejs_push_uint32(ejs, v, "unknown3" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_cldap_netlogon_13(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_cldap_netlogon_13 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "type", &r->type));
	NDR_CHECK(ejs_pull_nbt_server_type(ejs, v, "server_type", &r->server_type));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "domain_uuid", &r->domain_uuid));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "forest", &r->forest));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "dns_domain", &r->dns_domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_dns_name", &r->pdc_dns_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "pdc_name", &r->pdc_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "server_site", &r->server_site));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "client_site", &r->client_site));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_ipv4address(ejs, v, "pdc_ip", &r->pdc_ip));
	{
		uint32_t i;
		for (i=0;i<2;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "unknown3", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->unknown3[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "unknown3" ".length", &i);
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_nbt_cldap_netlogon(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union nbt_cldap_netlogon *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_1(ejs, v, "logon1", &r->logon1));
			break;
		case 1:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_1(ejs, v, "logon1", &r->logon1));
			break;
		case 2:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_3(ejs, v, "logon3", &r->logon3));
			break;
		case 3:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_3(ejs, v, "logon3", &r->logon3));
			break;
		case 4:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		case 5:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		case 6:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		case 7:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		default:
			NDR_CHECK(ejs_push_nbt_cldap_netlogon_13(ejs, v, "logon13", &r->logon13));
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_pull_nbt_cldap_netlogon(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union nbt_cldap_netlogon *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_1(ejs, v, "logon1", &r->logon1));
			break;
		case 1:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_1(ejs, v, "logon1", &r->logon1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_3(ejs, v, "logon3", &r->logon3));
			break;
		case 3:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_3(ejs, v, "logon3", &r->logon3));
			break;
		case 4:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		case 5:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		case 6:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		case 7:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_5(ejs, v, "logon5", &r->logon5));
			break;
		default:
			NDR_CHECK(ejs_pull_nbt_cldap_netlogon_13(ejs, v, "logon13", &r->logon13));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_nbt_ntlogon_command(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum nbt_ntlogon_command *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_ntlogon_command(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbt_ntlogon_command *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_ntlogon_sam_logon(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_ntlogon_sam_logon *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "request_count", &r->request_count));
	NDR_CHECK(ejs_push_string(ejs, v, "computer_name", r->computer_name));
	NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_string(ejs, v, "mailslot_name", r->mailslot_name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "acct_control", &r->acct_control));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_size", &r->sid_size));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_dom_sid(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_ntlogon_sam_logon(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_ntlogon_sam_logon *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "request_count", &r->request_count));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->computer_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "mailslot_name", &r->mailslot_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "acct_control", &r->acct_control));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_dom_sid(ejs, v, "sid", &r->sid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_ntlogon_sam_logon_reply(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_ntlogon_sam_logon_reply *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "server", r->server));
	NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_push_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_ntlogon_sam_logon_reply(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_ntlogon_sam_logon_reply *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "server", &r->server));
	NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "nt_version", &r->nt_version));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lmnt_token", &r->lmnt_token));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "lm20_token", &r->lm20_token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_ntlogon_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union nbt_ntlogon_request *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NTLOGON_SAM_LOGON:
			NDR_CHECK(ejs_push_nbt_ntlogon_sam_logon(ejs, v, "logon", &r->logon));
			break;
		case NTLOGON_SAM_LOGON_REPLY:
			NDR_CHECK(ejs_push_nbt_ntlogon_sam_logon_reply(ejs, v, "reply", &r->reply));
			break;
		case NTLOGON_SAM_LOGON_REPLY15:
			NDR_CHECK(ejs_push_nbt_ntlogon_sam_logon_reply(ejs, v, "reply", &r->reply));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_nbt_ntlogon_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union nbt_ntlogon_request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case NTLOGON_SAM_LOGON:
			NDR_CHECK(ejs_pull_nbt_ntlogon_sam_logon(ejs, v, "logon", &r->logon));
			break;
		case NTLOGON_SAM_LOGON_REPLY:
			NDR_CHECK(ejs_pull_nbt_ntlogon_sam_logon_reply(ejs, v, "reply", &r->reply));
			break;
		case NTLOGON_SAM_LOGON_REPLY15:
			NDR_CHECK(ejs_pull_nbt_ntlogon_sam_logon_reply(ejs, v, "reply", &r->reply));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_nbt_ntlogon_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_ntlogon_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_nbt_ntlogon_command(ejs, v, "command", &r->command));
	ejs_set_switch(ejs, r->command);
	NDR_CHECK(ejs_push_nbt_ntlogon_request(ejs, v, "req", &r->req));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nbt_ntlogon_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_ntlogon_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_nbt_ntlogon_command(ejs, v, "command", &r->command));
	ejs_set_switch(ejs, r->command);
	NDR_CHECK(ejs_pull_nbt_ntlogon_request(ejs, v, "req", &r->req));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_opcode(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum nbt_browse_opcode *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_opcode(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum nbt_browse_opcode *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_host_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_host_announcement *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "UpdateCount", &r->UpdateCount));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Periodicity", &r->Periodicity));
	NDR_CHECK(ejs_push_string(ejs, v, "ServerName", r->ServerName));
	NDR_CHECK(ejs_push_uint8(ejs, v, "OSMajor", &r->OSMajor));
	NDR_CHECK(ejs_push_uint8(ejs, v, "OSMinor", &r->OSMinor));
	NDR_CHECK(ejs_push_svcctl_ServerType(ejs, v, "ServerType", &r->ServerType));
	NDR_CHECK(ejs_push_uint8(ejs, v, "BroMajorVer", &r->BroMajorVer));
	NDR_CHECK(ejs_push_uint8(ejs, v, "BroMinorVer", &r->BroMinorVer));
	NDR_CHECK(ejs_push_uint16(ejs, v, "Signature", &r->Signature));
	NDR_CHECK(ejs_push_string(ejs, v, "Comment", r->Comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_host_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_host_announcement *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "UpdateCount", &r->UpdateCount));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Periodicity", &r->Periodicity));
	NDR_CHECK(ejs_pull_string(ejs, v, "ServerName", &r->ServerName));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "OSMajor", &r->OSMajor));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "OSMinor", &r->OSMinor));
	NDR_CHECK(ejs_pull_svcctl_ServerType(ejs, v, "ServerType", &r->ServerType));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "BroMajorVer", &r->BroMajorVer));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "BroMinorVer", &r->BroMinorVer));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "Signature", &r->Signature));
	NDR_CHECK(ejs_pull_string(ejs, v, "Comment", &r->Comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_announcement_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_announcement_request *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "Unused", &r->Unused));
	NDR_CHECK(ejs_push_string(ejs, v, "ResponseName", r->ResponseName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_announcement_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_announcement_request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "Unused", &r->Unused));
	NDR_CHECK(ejs_pull_string(ejs, v, "ResponseName", &r->ResponseName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_election_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_election_request *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "Version", &r->Version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Criteria", &r->Criteria));
	NDR_CHECK(ejs_push_uint32(ejs, v, "UpTime", &r->UpTime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Reserved", &r->Reserved));
	NDR_CHECK(ejs_push_string(ejs, v, "ServerName", r->ServerName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_election_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_election_request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "Version", &r->Version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Criteria", &r->Criteria));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "UpTime", &r->UpTime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Reserved", &r->Reserved));
	NDR_CHECK(ejs_pull_string(ejs, v, "ServerName", &r->ServerName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_backup_list_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_backup_list_request *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "ReqCount", &r->ReqCount));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Token", &r->Token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_backup_list_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_backup_list_request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "ReqCount", &r->ReqCount));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Token", &r->Token));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_backup_list_response(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_backup_list_response *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "BackupCount", &r->BackupCount));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Token", &r->Token));
	{
		uint32_t i;
		for (i=0;i<r->BackupCount;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "BackupServerList", i);
			NDR_CHECK(ejs_push_nbt_name(ejs, v, id, &r->BackupServerList[i]));
		}
		ejs_push_uint32(ejs, v, "BackupServerList" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_backup_list_response(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_backup_list_response *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "BackupCount", &r->BackupCount));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Token", &r->Token));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->BackupServerList, r->BackupCount);
		for (i=0;i<r->BackupCount;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "BackupServerList", i);
			NDR_CHECK(ejs_pull_nbt_name(ejs, v, id, &r->BackupServerList[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "BackupServerList" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_become_backup(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_become_backup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "BrowserName", r->BrowserName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_become_backup(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_become_backup *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "BrowserName", &r->BrowserName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_domain_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_domain_announcement *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "UpdateCount", &r->UpdateCount));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Periodicity", &r->Periodicity));
	NDR_CHECK(ejs_push_string(ejs, v, "ServerName", r->ServerName));
	NDR_CHECK(ejs_push_uint8(ejs, v, "OSMajor", &r->OSMajor));
	NDR_CHECK(ejs_push_uint8(ejs, v, "OSMinor", &r->OSMinor));
	NDR_CHECK(ejs_push_svcctl_ServerType(ejs, v, "ServerType", &r->ServerType));
	NDR_CHECK(ejs_push_uint32(ejs, v, "MysteriousField", &r->MysteriousField));
	NDR_CHECK(ejs_push_string(ejs, v, "Comment", r->Comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_domain_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_domain_announcement *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "UpdateCount", &r->UpdateCount));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Periodicity", &r->Periodicity));
	NDR_CHECK(ejs_pull_string(ejs, v, "ServerName", &r->ServerName));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "OSMajor", &r->OSMajor));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "OSMinor", &r->OSMinor));
	NDR_CHECK(ejs_pull_svcctl_ServerType(ejs, v, "ServerType", &r->ServerType));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "MysteriousField", &r->MysteriousField));
	NDR_CHECK(ejs_pull_string(ejs, v, "Comment", &r->Comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_master_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_master_announcement *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "ServerName", r->ServerName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_master_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_master_announcement *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "ServerName", &r->ServerName));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_reset_state(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_reset_state *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "Command", &r->Command));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_reset_state(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_reset_state *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "Command", &r->Command));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_local_master_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_local_master_announcement *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "UpdateCount", &r->UpdateCount));
	NDR_CHECK(ejs_push_uint32(ejs, v, "Periodicity", &r->Periodicity));
	NDR_CHECK(ejs_push_string(ejs, v, "ServerName", r->ServerName));
	NDR_CHECK(ejs_push_uint8(ejs, v, "OSMajor", &r->OSMajor));
	NDR_CHECK(ejs_push_uint8(ejs, v, "OSMinor", &r->OSMinor));
	NDR_CHECK(ejs_push_svcctl_ServerType(ejs, v, "ServerType", &r->ServerType));
	NDR_CHECK(ejs_push_uint8(ejs, v, "BroMajorVer", &r->BroMajorVer));
	NDR_CHECK(ejs_push_uint8(ejs, v, "BroMinorVer", &r->BroMinorVer));
	NDR_CHECK(ejs_push_uint16(ejs, v, "Signature", &r->Signature));
	NDR_CHECK(ejs_push_string(ejs, v, "Comment", r->Comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nbt_browse_local_master_announcement(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_local_master_announcement *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "UpdateCount", &r->UpdateCount));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Periodicity", &r->Periodicity));
	NDR_CHECK(ejs_pull_string(ejs, v, "ServerName", &r->ServerName));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "OSMajor", &r->OSMajor));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "OSMinor", &r->OSMinor));
	NDR_CHECK(ejs_pull_svcctl_ServerType(ejs, v, "ServerType", &r->ServerType));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "BroMajorVer", &r->BroMajorVer));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "BroMinorVer", &r->BroMinorVer));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "Signature", &r->Signature));
	NDR_CHECK(ejs_pull_string(ejs, v, "Comment", &r->Comment));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_nbt_browse_payload(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union nbt_browse_payload *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case HostAnnouncement:
			NDR_CHECK(ejs_push_nbt_browse_host_announcement(ejs, v, "host_annoucement", &r->host_annoucement));
			break;
		case AnnouncementRequest:
			NDR_CHECK(ejs_push_nbt_browse_announcement_request(ejs, v, "announcement_request", &r->announcement_request));
			break;
		case Election:
			NDR_CHECK(ejs_push_nbt_browse_election_request(ejs, v, "election_request", &r->election_request));
			break;
		case GetBackupListReq:
			NDR_CHECK(ejs_push_nbt_browse_backup_list_request(ejs, v, "backup_list_request", &r->backup_list_request));
			break;
		case GetBackupListResp:
			NDR_CHECK(ejs_push_nbt_browse_backup_list_response(ejs, v, "backup_list_response", &r->backup_list_response));
			break;
		case BecomeBackup:
			NDR_CHECK(ejs_push_nbt_browse_become_backup(ejs, v, "become_backup", &r->become_backup));
			break;
		case DomainAnnouncement:
			NDR_CHECK(ejs_push_nbt_browse_domain_announcement(ejs, v, "domain_announcement", &r->domain_announcement));
			break;
		case MasterAnnouncement:
			NDR_CHECK(ejs_push_nbt_browse_master_announcement(ejs, v, "master_announcement", &r->master_announcement));
			break;
		case ResetBrowserState:
			NDR_CHECK(ejs_push_nbt_browse_reset_state(ejs, v, "reset_browser_state", &r->reset_browser_state));
			break;
		case LocalMasterAnnouncement:
			NDR_CHECK(ejs_push_nbt_browse_local_master_announcement(ejs, v, "local_master_announcement", &r->local_master_announcement));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_nbt_browse_payload(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union nbt_browse_payload *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case HostAnnouncement:
			NDR_CHECK(ejs_pull_nbt_browse_host_announcement(ejs, v, "host_annoucement", &r->host_annoucement));
			break;
		case AnnouncementRequest:
			NDR_CHECK(ejs_pull_nbt_browse_announcement_request(ejs, v, "announcement_request", &r->announcement_request));
			break;
		case Election:
			NDR_CHECK(ejs_pull_nbt_browse_election_request(ejs, v, "election_request", &r->election_request));
			break;
		case GetBackupListReq:
			NDR_CHECK(ejs_pull_nbt_browse_backup_list_request(ejs, v, "backup_list_request", &r->backup_list_request));
			break;
		case GetBackupListResp:
			NDR_CHECK(ejs_pull_nbt_browse_backup_list_response(ejs, v, "backup_list_response", &r->backup_list_response));
			break;
		case BecomeBackup:
			NDR_CHECK(ejs_pull_nbt_browse_become_backup(ejs, v, "become_backup", &r->become_backup));
			break;
		case DomainAnnouncement:
			NDR_CHECK(ejs_pull_nbt_browse_domain_announcement(ejs, v, "domain_announcement", &r->domain_announcement));
			break;
		case MasterAnnouncement:
			NDR_CHECK(ejs_pull_nbt_browse_master_announcement(ejs, v, "master_announcement", &r->master_announcement));
			break;
		case ResetBrowserState:
			NDR_CHECK(ejs_pull_nbt_browse_reset_state(ejs, v, "reset_browser_state", &r->reset_browser_state));
			break;
		case LocalMasterAnnouncement:
			NDR_CHECK(ejs_pull_nbt_browse_local_master_announcement(ejs, v, "local_master_announcement", &r->local_master_announcement));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_nbt_browse_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nbt_browse_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_nbt_browse_opcode(ejs, v, "opcode", &r->opcode));
	ejs_set_switch(ejs, r->opcode);
	NDR_CHECK(ejs_push_nbt_browse_payload(ejs, v, "payload", &r->payload));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nbt_browse_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nbt_browse_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_nbt_browse_opcode(ejs, v, "opcode", &r->opcode));
	ejs_set_switch(ejs, r->opcode);
	NDR_CHECK(ejs_pull_nbt_browse_payload(ejs, v, "payload", &r->payload));
	return NT_STATUS_OK;
}

static int ejs_nbt_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "nbt", argc, argv);
	mprSetVar(obj, "NBT_SERVER_CLOSEST", mprCreateNumberVar(( 0x00000080 )));
	mprSetVar(obj, "GetBackupListResp", mprCreateNumberVar(10));
	mprSetVar(obj, "NBT_SERVER_GOOD_TIMESERV", mprCreateNumberVar(( 0x00000200 )));
	mprSetVar(obj, "NBT_SERVER_DS", mprCreateNumberVar(( 0x00000010 )));
	mprSetVar(obj, "MasterAnnouncement", mprCreateNumberVar(13));
	mprSetVar(obj, "BecomeBackup", mprCreateNumberVar(11));
	mprSetVar(obj, "NBT_FLAG_BROADCAST", mprCreateNumberVar(( 0x0010 )));
	mprSetVar(obj, "Election", mprCreateNumberVar(8));
	mprSetVar(obj, "NBT_QTYPE_NETBIOS", mprCreateNumberVar(0x0020));
	mprSetVar(obj, "NBT_FLAG_TRUNCATION", mprCreateNumberVar(( 0x0200 )));
	mprSetVar(obj, "NBT_FLAG_RECURSION_DESIRED", mprCreateNumberVar(( 0x0100 )));
	mprSetVar(obj, "NBT_SERVER_PDC", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "DGRAM_FLAG_FIRST", mprCreateNumberVar(( 0x02 )));
	mprSetVar(obj, "NBT_SERVER_KDC", mprCreateNumberVar(( 0x00000020 )));
	mprSetVar(obj, "NBT_FLAG_RECURSION_AVAIL", mprCreateNumberVar(( 0x0080 )));
	mprSetVar(obj, "DGRAM_ERROR_INVALID_SOURCE", mprCreateNumberVar(0x83));
	mprSetVar(obj, "DGRAM_BCAST", mprCreateNumberVar(0x12));
	mprSetVar(obj, "NBT_SERVER_GC", mprCreateNumberVar(( 0x00000004 )));
	mprSetVar(obj, "DGRAM_QUERY_NEGATIVE", mprCreateNumberVar(0x16));
	mprSetVar(obj, "NTLOGON_SAM_LOGON_REPLY15", mprCreateNumberVar(0x15));
	mprSetVar(obj, "NBT_NAME_CLIENT", mprCreateNumberVar(0x00));
	mprSetVar(obj, "NBT_OPCODE", mprCreateNumberVar(( 0x7800 )));
	mprSetVar(obj, "DGRAM_SMB", mprCreateNumberVar(0xff534d42));
	mprSetVar(obj, "NBT_NM_PERMANENT", mprCreateNumberVar(( 0x0200 )));
	mprSetVar(obj, "DGRAM_ERROR", mprCreateNumberVar(0x13));
	mprSetVar(obj, "ResetBrowserState", mprCreateNumberVar(14));
	mprSetVar(obj, "NBT_MAILSLOT_GETDC", mprString("\\MAILSLOT\\NET\\GETDC"));
	mprSetVar(obj, "NETLOGON_ANNOUNCE_UAS", mprCreateNumberVar(0xa));
	mprSetVar(obj, "HostAnnouncement", mprCreateNumberVar(1));
	mprSetVar(obj, "NTLOGON_SAM_LOGON_REPLY", mprCreateNumberVar(0x13));
	mprSetVar(obj, "AnnouncementRequest", mprCreateNumberVar(2));
	mprSetVar(obj, "NBT_QTYPE_ADDRESS", mprCreateNumberVar(0x0001));
	mprSetVar(obj, "NBT_QTYPE_STATUS", mprCreateNumberVar(0x0021));
	mprSetVar(obj, "NBT_MAILSLOT_BROWSE", mprString("\\MAILSLOT\\BROWSE"));
	mprSetVar(obj, "NBT_NAME_USER", mprCreateNumberVar(0x03));
	mprSetVar(obj, "DGRAM_ERROR_INVALID_DEST", mprCreateNumberVar(0x84));
	mprSetVar(obj, "NBT_DGRAM_SERVICE_PORT", mprCreateNumberVar(138));
	mprSetVar(obj, "DGRAM_QUERY_POSITIVE", mprCreateNumberVar(0x15));
	mprSetVar(obj, "NBT_SERVER_TIMESERV", mprCreateNumberVar(( 0x00000040 )));
	mprSetVar(obj, "NBT_NM_GROUP", mprCreateNumberVar(( 0x8000 )));
	mprSetVar(obj, "NBT_QCLASS_IP", mprCreateNumberVar(0x01));
	mprSetVar(obj, "NBT_NAME_BROWSER", mprCreateNumberVar(0x1E));
	mprSetVar(obj, "DomainAnnouncement", mprCreateNumberVar(12));
	mprSetVar(obj, "NBT_NAME_PDC", mprCreateNumberVar(0x1B));
	mprSetVar(obj, "DGRAM_DIRECT_GROUP", mprCreateNumberVar(0x11));
	mprSetVar(obj, "NBT_FLAG_REPLY", mprCreateNumberVar(( 0x8000 )));
	mprSetVar(obj, "DGRAM_FLAG_NODE_TYPE", mprCreateNumberVar(( 0x0C )));
	mprSetVar(obj, "NETLOGON_RESPONSE_FROM_PDC_USER", mprCreateNumberVar(0x19));
	mprSetVar(obj, "NETLOGON_QUERY_FOR_PDC2", mprCreateNumberVar(0x12));
	mprSetVar(obj, "SMB_TRANSACTION", mprCreateNumberVar(0x25));
	mprSetVar(obj, "NBT_NAME_SERVICE_PORT", mprCreateNumberVar(137));
	mprSetVar(obj, "DGRAM_DIRECT_UNIQUE", mprCreateNumberVar(0x10));
	mprSetVar(obj, "NBT_SERVER_LDAP", mprCreateNumberVar(( 0x00000008 )));
	mprSetVar(obj, "NBT_NAME_LOGON", mprCreateNumberVar(0x1C));
	mprSetVar(obj, "NETLOGON_RESPONSE_FROM_PDC", mprCreateNumberVar(0xc));
	mprSetVar(obj, "NBT_QTYPE_NULL", mprCreateNumberVar(0x000A));
	mprSetVar(obj, "NBT_NAME_SERVER", mprCreateNumberVar(0x20));
	mprSetVar(obj, "NBT_NAME_MS", mprCreateNumberVar(0x01));
	mprSetVar(obj, "NTLOGON_SAM_LOGON", mprCreateNumberVar(0x12));
	mprSetVar(obj, "NBT_NM_OWNER_TYPE", mprCreateNumberVar(( 0x6000 )));
	mprSetVar(obj, "DGRAM_ERROR_NAME_NOT_PRESENT", mprCreateNumberVar(0x82));
	mprSetVar(obj, "NBT_NM_ACTIVE", mprCreateNumberVar(( 0x0400 )));
	mprSetVar(obj, "NBT_QTYPE_NAMESERVICE", mprCreateNumberVar(0x0002));
	mprSetVar(obj, "NBT_NM_CONFLICT", mprCreateNumberVar(( 0x0800 )));
	mprSetVar(obj, "LocalMasterAnnouncement", mprCreateNumberVar(15));
	mprSetVar(obj, "NBT_NM_DEREGISTER", mprCreateNumberVar(( 0x1000 )));
	mprSetVar(obj, "DGRAM_FLAG_MORE", mprCreateNumberVar(( 0x01 )));
	mprSetVar(obj, "NBT_MAILSLOT_NTLOGON", mprString("\\MAILSLOT\\NET\\NTLOGON"));
	mprSetVar(obj, "NBT_SERVER_WRITABLE", mprCreateNumberVar(( 0x00000100 )));
	mprSetVar(obj, "DGRAM_QUERY", mprCreateNumberVar(0x14));
	mprSetVar(obj, "NBT_FLAG_AUTHORITIVE", mprCreateNumberVar(( 0x0400 )));
	mprSetVar(obj, "NETLOGON_QUERY_FOR_PDC", mprCreateNumberVar(0x7));
	mprSetVar(obj, "GetBackupListReq", mprCreateNumberVar(9));
	mprSetVar(obj, "NETLOGON_RESPONSE_FROM_PDC2", mprCreateNumberVar(0x17));
	mprSetVar(obj, "NBT_RCODE", mprCreateNumberVar(( 0x000F )));
	mprSetVar(obj, "NBT_NAME_MASTER", mprCreateNumberVar(0x1D));
	mprSetVar(obj, "NBT_MAILSLOT_NETLOGON", mprString("\\MAILSLOT\\NET\\NETLOGON"));
	return ejs_rpc_init(obj, "nbt");
}

NTSTATUS ejs_init_nbt(void)
{
	ejsDefineCFunction(-1, "nbt_init", ejs_nbt_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
