/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_msgsvc.h"

/* msgsvc - dcerpc server boilerplate generated by pidl */


static NTSTATUS msgsvc__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_MSGSVC_BIND
	return DCESRV_INTERFACE_MSGSVC_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void msgsvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_MSGSVC_UNBIND
	DCESRV_INTERFACE_MSGSVC_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS msgsvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_msgsvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_msgsvc.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_msgsvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_msgsvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS msgsvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct NetrMessageNameAdd *r2 = (struct NetrMessageNameAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameAdd, NDR_IN, r2);
		}
		dcesrv_NetrMessageNameAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameAdd will reply async\n"));
		}
		break;
	}
	case 1: {
		struct NetrMessageNameEnum *r2 = (struct NetrMessageNameEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameEnum, NDR_IN, r2);
		}
		dcesrv_NetrMessageNameEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameEnum will reply async\n"));
		}
		break;
	}
	case 2: {
		struct NetrMessageNameGetInfo *r2 = (struct NetrMessageNameGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameGetInfo, NDR_IN, r2);
		}
		dcesrv_NetrMessageNameGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameGetInfo will reply async\n"));
		}
		break;
	}
	case 3: {
		struct NetrMessageNameDel *r2 = (struct NetrMessageNameDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameDel, NDR_IN, r2);
		}
		dcesrv_NetrMessageNameDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameDel will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_msgsvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS msgsvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct NetrMessageNameAdd *r2 = (struct NetrMessageNameAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrMessageNameAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct NetrMessageNameEnum *r2 = (struct NetrMessageNameEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrMessageNameEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct NetrMessageNameGetInfo *r2 = (struct NetrMessageNameGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrMessageNameGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct NetrMessageNameDel *r2 = (struct NetrMessageNameDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrMessageNameDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrMessageNameDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrMessageNameDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_msgsvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS msgsvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_msgsvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_msgsvc_interface = {
	.name		= "msgsvc",
	.syntax_id  = {{0x17fdd703,0x1827,0x4e34,{0x79,0xd4},{0x24,0xa5,0x5c,0x53,0xbb,0x37}},1.0},
	.bind		= msgsvc__op_bind,
	.unbind		= msgsvc__op_unbind,
	.ndr_pull	= msgsvc__op_ndr_pull,
	.dispatch	= msgsvc__op_dispatch,
	.reply		= msgsvc__op_reply,
	.ndr_push	= msgsvc__op_ndr_push
};


static NTSTATUS msgsvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_msgsvc.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_msgsvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_msgsvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("msgsvc_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL msgsvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_msgsvc_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_msgsvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_msgsvc_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL msgsvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_msgsvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_msgsvc_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_msgsvc_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "msgsvc";

	/* fill in all the operations */
	ep_server.init_server = msgsvc__op_init_server;

	ep_server.interface_by_uuid = msgsvc__op_interface_by_uuid;
	ep_server.interface_by_name = msgsvc__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'msgsvc' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* msgsvcsend - dcerpc server boilerplate generated by pidl */


static NTSTATUS msgsvcsend__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_MSGSVCSEND_BIND
	return DCESRV_INTERFACE_MSGSVCSEND_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void msgsvcsend__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_MSGSVCSEND_UNBIND
	DCESRV_INTERFACE_MSGSVCSEND_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS msgsvcsend__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_msgsvcsend.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_msgsvcsend.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_msgsvcsend.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_msgsvcsend, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS msgsvcsend__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct NetrSendMessage *r2 = (struct NetrSendMessage *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrSendMessage, NDR_IN, r2);
		}
		dcesrv_NetrSendMessage(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrSendMessage will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_msgsvcsend, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS msgsvcsend__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct NetrSendMessage *r2 = (struct NetrSendMessage *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrSendMessage replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrSendMessage, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrSendMessage\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_msgsvcsend, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS msgsvcsend__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_msgsvcsend.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_msgsvcsend_interface = {
	.name		= "msgsvcsend",
	.syntax_id  = {{0x5a7b91f8,0xff00,0x11d0,{0xa9,0xb2},{0x00,0xc0,0x4f,0xb6,0xe6,0xfc}},1.0},
	.bind		= msgsvcsend__op_bind,
	.unbind		= msgsvcsend__op_unbind,
	.ndr_pull	= msgsvcsend__op_ndr_pull,
	.dispatch	= msgsvcsend__op_dispatch,
	.reply		= msgsvcsend__op_reply,
	.ndr_push	= msgsvcsend__op_ndr_push
};


static NTSTATUS msgsvcsend__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_msgsvcsend.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_msgsvcsend.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_msgsvcsend_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("msgsvcsend_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL msgsvcsend__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_msgsvcsend_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_msgsvcsend_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_msgsvcsend_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL msgsvcsend__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_msgsvcsend_interface.name, name)==0) {
		memcpy(iface, &dcesrv_msgsvcsend_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_msgsvcsend_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "msgsvcsend";

	/* fill in all the operations */
	ep_server.init_server = msgsvcsend__op_init_server;

	ep_server.interface_by_uuid = msgsvcsend__op_interface_by_uuid;
	ep_server.interface_by_name = msgsvcsend__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'msgsvcsend' endpoint server!\n"));
		return ret;
	}

	return ret;
}

