
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_lsa_ejs.h"


_PUBLIC_ NTSTATUS ejs_push_lsa_StringLarge(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_StringLarge *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	if (NULL == r->string) {
		NDR_CHECK(ejs_push_null(ejs, v, "string"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "string", r->string));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_lsa_StringLarge(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_StringLarge *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "string")) {
		r->string = NULL;
	} else {
		EJS_ALLOC(ejs, r->string);
		NDR_CHECK(ejs_pull_string(ejs, v, "string", &r->string));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_lsa_Strings(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_Strings *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->names) {
		NDR_CHECK(ejs_push_null(ejs, v, "names"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_push_lsa_String(ejs, v, id, &r->names[i]));
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_lsa_Strings(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_Strings *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "names")) {
		r->names = NULL;
	} else {
		EJS_ALLOC(ejs, r->names);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->names, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_pull_lsa_String(ejs, v, id, &r->names[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_lsa_AsciiString(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_AsciiString *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "size", &r->size));
	if (NULL == r->string) {
		NDR_CHECK(ejs_push_null(ejs, v, "string"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "string", r->string));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_lsa_AsciiString(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_AsciiString *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "string")) {
		r->string = NULL;
	} else {
		EJS_ALLOC(ejs, r->string);
		NDR_CHECK(ejs_pull_string(ejs, v, "string", &r->string));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_LUID(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_LUID *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "low", &r->low));
	NDR_CHECK(ejs_push_uint32(ejs, v, "high", &r->high));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_LUID(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_LUID *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "low", &r->low));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "high", &r->high));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_PrivEntry(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_PrivEntry *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_lsa_LUID(ejs, v, "luid", &r->luid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_PrivArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_PrivArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->privs) {
		NDR_CHECK(ejs_push_null(ejs, v, "privs"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "privs", i);
				NDR_CHECK(ejs_push_lsa_PrivEntry(ejs, v, id, &r->privs[i]));
			}
			ejs_push_uint32(ejs, v, "privs" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_QosInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_QosInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "len", &r->len));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "impersonation_level", &r->impersonation_level));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "context_mode", &r->context_mode));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "effective_only", &r->effective_only));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_ObjectAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_ObjectAttribute *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "len", &r->len));
	if (ejs_pull_null(ejs, v, "root_dir")) {
		r->root_dir = NULL;
	} else {
		EJS_ALLOC(ejs, r->root_dir);
		NDR_CHECK(ejs_pull_uint8(ejs, v, "root_dir", r->root_dir));
	}
	if (ejs_pull_null(ejs, v, "object_name")) {
		r->object_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->object_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "object_name", &r->object_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "attributes", &r->attributes));
	if (ejs_pull_null(ejs, v, "sec_desc")) {
		r->sec_desc = NULL;
	} else {
		EJS_ALLOC(ejs, r->sec_desc);
		NDR_CHECK(ejs_pull_security_descriptor(ejs, v, "sec_desc", r->sec_desc));
	}
	if (ejs_pull_null(ejs, v, "sec_qos")) {
		r->sec_qos = NULL;
	} else {
		EJS_ALLOC(ejs, r->sec_qos);
		NDR_CHECK(ejs_pull_lsa_QosInfo(ejs, v, "sec_qos", r->sec_qos));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_AuditLogInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_AuditLogInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "percent_full", &r->percent_full));
	NDR_CHECK(ejs_push_uint32(ejs, v, "log_size", &r->log_size));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "retention_time", &r->retention_time));
	NDR_CHECK(ejs_push_uint8(ejs, v, "shutdown_in_progress", &r->shutdown_in_progress));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "time_to_shutdown", &r->time_to_shutdown));
	NDR_CHECK(ejs_push_uint32(ejs, v, "next_audit_record", &r->next_audit_record));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_AuditEventsInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_AuditEventsInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "auditing_mode", &r->auditing_mode));
	if (NULL == r->settings) {
		NDR_CHECK(ejs_push_null(ejs, v, "settings"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "settings", i);
				NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->settings[i]));
			}
			ejs_push_uint32(ejs, v, "settings" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "name", &r->name));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_DomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_DomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, "name", &r->name));
	if (ejs_pull_null(ejs, v, "sid")) {
		r->sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_PDAccountInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_PDAccountInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_ServerRole(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_ServerRole *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_push_uint16(ejs, v, "role", &r->role));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_ReplicaSourceInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_ReplicaSourceInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "source", &r->source));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "account", &r->account));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DefaultQuotaInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DefaultQuotaInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "paged_pool", &r->paged_pool));
	NDR_CHECK(ejs_push_uint32(ejs, v, "non_paged_pool", &r->non_paged_pool));
	NDR_CHECK(ejs_push_uint32(ejs, v, "min_wss", &r->min_wss));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_wss", &r->max_wss));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pagefile", &r->pagefile));
	NDR_CHECK(ejs_push_hyper(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_ModificationInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_ModificationInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "modified_id", &r->modified_id));
	NDR_CHECK(ejs_push_NTTIME(ejs, v, "db_create_time", &r->db_create_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_AuditFullSetInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_AuditFullSetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "shutdown_on_full", &r->shutdown_on_full));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_AuditFullQueryInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_AuditFullQueryInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "unknown", &r->unknown));
	NDR_CHECK(ejs_push_uint8(ejs, v, "shutdown_on_full", &r->shutdown_on_full));
	NDR_CHECK(ejs_push_uint8(ejs, v, "log_is_full", &r->log_is_full));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DnsDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DnsDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "dns_domain", &r->dns_domain));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "dns_forest", &r->dns_forest));
	NDR_CHECK(ejs_push_GUID(ejs, v, "domain_guid", &r->domain_guid));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_PolicyInformation(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union lsa_PolicyInformation *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case LSA_POLICY_INFO_AUDIT_LOG:
			NDR_CHECK(ejs_push_lsa_AuditLogInfo(ejs, v, "audit_log", &r->audit_log));
			break;
		case LSA_POLICY_INFO_AUDIT_EVENTS:
			NDR_CHECK(ejs_push_lsa_AuditEventsInfo(ejs, v, "audit_events", &r->audit_events));
			break;
		case LSA_POLICY_INFO_DOMAIN:
			NDR_CHECK(ejs_push_lsa_DomainInfo(ejs, v, "domain", &r->domain));
			break;
		case LSA_POLICY_INFO_PD:
			NDR_CHECK(ejs_push_lsa_PDAccountInfo(ejs, v, "pd", &r->pd));
			break;
		case LSA_POLICY_INFO_ACCOUNT_DOMAIN:
			NDR_CHECK(ejs_push_lsa_DomainInfo(ejs, v, "account_domain", &r->account_domain));
			break;
		case LSA_POLICY_INFO_ROLE:
			NDR_CHECK(ejs_push_lsa_ServerRole(ejs, v, "role", &r->role));
			break;
		case LSA_POLICY_INFO_REPLICA:
			NDR_CHECK(ejs_push_lsa_ReplicaSourceInfo(ejs, v, "replica", &r->replica));
			break;
		case LSA_POLICY_INFO_QUOTA:
			NDR_CHECK(ejs_push_lsa_DefaultQuotaInfo(ejs, v, "quota", &r->quota));
			break;
		case LSA_POLICY_INFO_DB:
			NDR_CHECK(ejs_push_lsa_ModificationInfo(ejs, v, "db", &r->db));
			break;
		case LSA_POLICY_INFO_AUDIT_FULL_SET:
			NDR_CHECK(ejs_push_lsa_AuditFullSetInfo(ejs, v, "auditfullset", &r->auditfullset));
			break;
		case LSA_POLICY_INFO_AUDIT_FULL_QUERY:
			NDR_CHECK(ejs_push_lsa_AuditFullQueryInfo(ejs, v, "auditfullquery", &r->auditfullquery));
			break;
		case LSA_POLICY_INFO_DNS:
			NDR_CHECK(ejs_push_lsa_DnsDomainInfo(ejs, v, "dns", &r->dns));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_lsa_SidPtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_SidPtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_SidPtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_SidPtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "sid")) {
		r->sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_lsa_SidArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_SidArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_sids", &r->num_sids));
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->num_sids;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_push_lsa_SidPtr(ejs, v, id, &r->sids[i]));
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_lsa_SidArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_SidArray *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_sids", &r->num_sids));
	if (ejs_pull_null(ejs, v, "sids")) {
		r->sids = NULL;
	} else {
		EJS_ALLOC(ejs, r->sids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->sids, r->num_sids);
			for (i=0;i<r->num_sids;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_pull_lsa_SidPtr(ejs, v, id, &r->sids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DomainList(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DomainList *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "domains", i);
				NDR_CHECK(ejs_push_lsa_DomainInfo(ejs, v, id, &r->domains[i]));
			}
			ejs_push_uint32(ejs, v, "domains" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_SidType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum lsa_SidType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_SidType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum lsa_SidType *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TranslatedSid(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TranslatedSid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_index", &r->sid_index));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TranslatedSid(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TranslatedSid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_index", &r->sid_index));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TransSidArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TransSidArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_push_lsa_TranslatedSid(ejs, v, id, &r->sids[i]));
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TransSidArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TransSidArray *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "sids")) {
		r->sids = NULL;
	} else {
		EJS_ALLOC(ejs, r->sids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->sids, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_pull_lsa_TranslatedSid(ejs, v, id, &r->sids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_RefDomainList(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_RefDomainList *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "domains", i);
				NDR_CHECK(ejs_push_lsa_DomainInfo(ejs, v, id, &r->domains[i]));
			}
			ejs_push_uint32(ejs, v, "domains" ".length", &i);
		}
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_size", &r->max_size));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TranslatedName(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TranslatedName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_index", &r->sid_index));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TranslatedName(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TranslatedName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_index", &r->sid_index));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TransNameArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TransNameArray *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->names) {
		NDR_CHECK(ejs_push_null(ejs, v, "names"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_push_lsa_TranslatedName(ejs, v, id, &r->names[i]));
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TransNameArray(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TransNameArray *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "names")) {
		r->names = NULL;
	} else {
		EJS_ALLOC(ejs, r->names);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->names, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_pull_lsa_TranslatedName(ejs, v, id, &r->names[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_LUIDAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_LUIDAttribute *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_LUID(ejs, v, "luid", &r->luid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "attribute", &r->attribute));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_LUIDAttribute(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_LUIDAttribute *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_LUID(ejs, v, "luid", &r->luid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "attribute", &r->attribute));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_PrivilegeSet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_PrivilegeSet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	{
		uint32_t i;
		for (i=0;i<r->count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "set", i);
			NDR_CHECK(ejs_push_lsa_LUIDAttribute(ejs, v, id, &r->set[i]));
		}
		ejs_push_uint32(ejs, v, "set" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_PrivilegeSet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_PrivilegeSet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->set, r->count);
		for (i=0;i<r->count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "set", i);
			NDR_CHECK(ejs_pull_lsa_LUIDAttribute(ejs, v, id, &r->set[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "set" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DATA_BUF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DATA_BUF *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	if (NULL == r->data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		ejs_push_array_uint8(ejs, v, "data", r->data, r->length);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_DATA_BUF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_DATA_BUF *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "length", &r->length));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		EJS_ALLOC_N(ejs, r->data, r->size);
		ejs_pull_array_uint8(ejs, v, "data", r->data, r->length);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DATA_BUF2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DATA_BUF2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	if (NULL == r->data) {
		NDR_CHECK(ejs_push_null(ejs, v, "data"));
	} else {
		ejs_push_array_uint8(ejs, v, "data", r->data, r->size);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_DATA_BUF2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_DATA_BUF2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	if (ejs_pull_null(ejs, v, "data")) {
		r->data = NULL;
	} else {
		EJS_ALLOC(ejs, r->data);
		EJS_ALLOC_N(ejs, r->data, r->size);
		ejs_pull_array_uint8(ejs, v, "data", r->data, r->size);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomInfoEnum(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum lsa_TrustDomInfoEnum *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoName(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "netbios_name", &r->netbios_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoName(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, "netbios_name", &r->netbios_name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoPosixOffset(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoPosixOffset *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "posix_offset", &r->posix_offset));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoPosixOffset(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoPosixOffset *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "posix_offset", &r->posix_offset));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoPassword(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoPassword *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->password) {
		NDR_CHECK(ejs_push_null(ejs, v, "password"));
	} else {
		NDR_CHECK(ejs_push_lsa_DATA_BUF(ejs, v, "password", r->password));
	}
	if (NULL == r->old_password) {
		NDR_CHECK(ejs_push_null(ejs, v, "old_password"));
	} else {
		NDR_CHECK(ejs_push_lsa_DATA_BUF(ejs, v, "old_password", r->old_password));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoPassword(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoPassword *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "password")) {
		r->password = NULL;
	} else {
		EJS_ALLOC(ejs, r->password);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF(ejs, v, "password", r->password));
	}
	if (ejs_pull_null(ejs, v, "old_password")) {
		r->old_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->old_password);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF(ejs, v, "old_password", r->old_password));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoBasic(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoBasic *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "netbios_name", &r->netbios_name));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoBasic(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoBasic *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "netbios_name", &r->netbios_name));
	if (ejs_pull_null(ejs, v, "sid")) {
		r->sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoInfoEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoInfoEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "netbios_name", &r->netbios_name));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "trust_direction", &r->trust_direction));
	NDR_CHECK(ejs_push_uint32(ejs, v, "trust_type", &r->trust_type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "trust_attributes", &r->trust_attributes));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoInfoEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoInfoEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, "domain_name", &r->domain_name));
	NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, "netbios_name", &r->netbios_name));
	if (ejs_pull_null(ejs, v, "sid")) {
		r->sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "trust_direction", &r->trust_direction));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "trust_type", &r->trust_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "trust_attributes", &r->trust_attributes));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoBuffer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoBuffer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NTTIME_hyper(ejs, v, "last_update_time", &r->last_update_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "secret_type", &r->secret_type));
	NDR_CHECK(ejs_push_lsa_DATA_BUF2(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoBuffer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoBuffer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NTTIME_hyper(ejs, v, "last_update_time", &r->last_update_time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "secret_type", &r->secret_type));
	NDR_CHECK(ejs_pull_lsa_DATA_BUF2(ejs, v, "data", &r->data));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoAuthInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoAuthInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "incoming_count", &r->incoming_count));
	if (NULL == r->incoming_current_auth_info) {
		NDR_CHECK(ejs_push_null(ejs, v, "incoming_current_auth_info"));
	} else {
		NDR_CHECK(ejs_push_lsa_TrustDomainInfoBuffer(ejs, v, "incoming_current_auth_info", r->incoming_current_auth_info));
	}
	if (NULL == r->incoming_previous_auth_info) {
		NDR_CHECK(ejs_push_null(ejs, v, "incoming_previous_auth_info"));
	} else {
		NDR_CHECK(ejs_push_lsa_TrustDomainInfoBuffer(ejs, v, "incoming_previous_auth_info", r->incoming_previous_auth_info));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "outgoing_count", &r->outgoing_count));
	if (NULL == r->outgoing_current_auth_info) {
		NDR_CHECK(ejs_push_null(ejs, v, "outgoing_current_auth_info"));
	} else {
		NDR_CHECK(ejs_push_lsa_TrustDomainInfoBuffer(ejs, v, "outgoing_current_auth_info", r->outgoing_current_auth_info));
	}
	if (NULL == r->outgoing_previous_auth_info) {
		NDR_CHECK(ejs_push_null(ejs, v, "outgoing_previous_auth_info"));
	} else {
		NDR_CHECK(ejs_push_lsa_TrustDomainInfoBuffer(ejs, v, "outgoing_previous_auth_info", r->outgoing_previous_auth_info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoAuthInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoAuthInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "incoming_count", &r->incoming_count));
	if (ejs_pull_null(ejs, v, "incoming_current_auth_info")) {
		r->incoming_current_auth_info = NULL;
	} else {
		EJS_ALLOC(ejs, r->incoming_current_auth_info);
		NDR_CHECK(ejs_pull_lsa_TrustDomainInfoBuffer(ejs, v, "incoming_current_auth_info", r->incoming_current_auth_info));
	}
	if (ejs_pull_null(ejs, v, "incoming_previous_auth_info")) {
		r->incoming_previous_auth_info = NULL;
	} else {
		EJS_ALLOC(ejs, r->incoming_previous_auth_info);
		NDR_CHECK(ejs_pull_lsa_TrustDomainInfoBuffer(ejs, v, "incoming_previous_auth_info", r->incoming_previous_auth_info));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "outgoing_count", &r->outgoing_count));
	if (ejs_pull_null(ejs, v, "outgoing_current_auth_info")) {
		r->outgoing_current_auth_info = NULL;
	} else {
		EJS_ALLOC(ejs, r->outgoing_current_auth_info);
		NDR_CHECK(ejs_pull_lsa_TrustDomainInfoBuffer(ejs, v, "outgoing_current_auth_info", r->outgoing_current_auth_info));
	}
	if (ejs_pull_null(ejs, v, "outgoing_previous_auth_info")) {
		r->outgoing_previous_auth_info = NULL;
	} else {
		EJS_ALLOC(ejs, r->outgoing_previous_auth_info);
		NDR_CHECK(ejs_pull_lsa_TrustDomainInfoBuffer(ejs, v, "outgoing_previous_auth_info", r->outgoing_previous_auth_info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoFullInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoFullInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoPosixOffset(ejs, v, "posix_offset", &r->posix_offset));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoAuthInfo(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoFullInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoFullInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoPosixOffset(ejs, v, "posix_offset", &r->posix_offset));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoAuthInfo(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfo11(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfo11 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
	NDR_CHECK(ejs_push_lsa_DATA_BUF2(ejs, v, "data1", &r->data1));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfo11(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfo11 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
	NDR_CHECK(ejs_pull_lsa_DATA_BUF2(ejs, v, "data1", &r->data1));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustDomainInfoInfoAll(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TrustDomainInfoInfoAll *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
	NDR_CHECK(ejs_push_lsa_DATA_BUF2(ejs, v, "data1", &r->data1));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoPosixOffset(ejs, v, "posix_offset", &r->posix_offset));
	NDR_CHECK(ejs_push_lsa_TrustDomainInfoAuthInfo(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TrustDomainInfoInfoAll(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TrustDomainInfoInfoAll *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
	NDR_CHECK(ejs_pull_lsa_DATA_BUF2(ejs, v, "data1", &r->data1));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoPosixOffset(ejs, v, "posix_offset", &r->posix_offset));
	NDR_CHECK(ejs_pull_lsa_TrustDomainInfoAuthInfo(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TrustedDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union lsa_TrustedDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoName(ejs, v, "name", &r->name));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoPosixOffset(ejs, v, "posix_offset", &r->posix_offset));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoPassword(ejs, v, "password", &r->password));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoBasic(ejs, v, "info_basic", &r->info_basic));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoAuthInfo(ejs, v, "auth_info", &r->auth_info));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoFullInfo(ejs, v, "full_info", &r->full_info));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_11:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfo11(ejs, v, "info11", &r->info11));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL:
			NDR_CHECK(ejs_push_lsa_TrustDomainInfoInfoAll(ejs, v, "info_all", &r->info_all));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_lsa_TrustedDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union lsa_TrustedDomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case LSA_TRUSTED_DOMAIN_INFO_NAME:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoName(ejs, v, "name", &r->name));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoPosixOffset(ejs, v, "posix_offset", &r->posix_offset));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_PASSWORD:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoPassword(ejs, v, "password", &r->password));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_BASIC:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoBasic(ejs, v, "info_basic", &r->info_basic));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_EX:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoInfoEx(ejs, v, "info_ex", &r->info_ex));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoAuthInfo(ejs, v, "auth_info", &r->auth_info));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_FULL_INFO:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoFullInfo(ejs, v, "full_info", &r->full_info));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_11:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfo11(ejs, v, "info11", &r->info11));
			break;
		case LSA_TRUSTED_DOMAIN_INFO_INFO_ALL:
			NDR_CHECK(ejs_pull_lsa_TrustDomainInfoInfoAll(ejs, v, "info_all", &r->info_all));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_lsa_DATA_BUF_PTR(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DATA_BUF_PTR *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->buf) {
		NDR_CHECK(ejs_push_null(ejs, v, "buf"));
	} else {
		NDR_CHECK(ejs_push_lsa_DATA_BUF(ejs, v, "buf", r->buf));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_DATA_BUF_PTR(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_DATA_BUF_PTR *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "buf")) {
		r->buf = NULL;
	} else {
		EJS_ALLOC(ejs, r->buf);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF(ejs, v, "buf", r->buf));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_RightSet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_RightSet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->names) {
		NDR_CHECK(ejs_push_null(ejs, v, "names"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, id, &r->names[i]));
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_RightSet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_RightSet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "names")) {
		r->names = NULL;
	} else {
		EJS_ALLOC(ejs, r->names);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->names, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_pull_lsa_StringLarge(ejs, v, id, &r->names[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_StringPointer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_StringPointer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->string) {
		NDR_CHECK(ejs_push_null(ejs, v, "string"));
	} else {
		NDR_CHECK(ejs_push_lsa_String(ejs, v, "string", r->string));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_StringPointer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_StringPointer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "string")) {
		r->string = NULL;
	} else {
		EJS_ALLOC(ejs, r->string);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "string", r->string));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DomainListEx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DomainListEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "domains", i);
				NDR_CHECK(ejs_push_lsa_TrustDomainInfoInfoEx(ejs, v, id, &r->domains[i]));
			}
			ejs_push_uint32(ejs, v, "domains" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DomainInfoKerberos(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DomainInfoKerberos *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enforce_restrictions", &r->enforce_restrictions));
	NDR_CHECK(ejs_push_hyper(ejs, v, "service_tkt_lifetime", &r->service_tkt_lifetime));
	NDR_CHECK(ejs_push_hyper(ejs, v, "user_tkt_lifetime", &r->user_tkt_lifetime));
	NDR_CHECK(ejs_push_hyper(ejs, v, "user_tkt_renewaltime", &r->user_tkt_renewaltime));
	NDR_CHECK(ejs_push_hyper(ejs, v, "clock_skew", &r->clock_skew));
	NDR_CHECK(ejs_push_hyper(ejs, v, "unknown6", &r->unknown6));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_DomainInfoKerberos(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_DomainInfoKerberos *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enforce_restrictions", &r->enforce_restrictions));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "service_tkt_lifetime", &r->service_tkt_lifetime));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "user_tkt_lifetime", &r->user_tkt_lifetime));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "user_tkt_renewaltime", &r->user_tkt_renewaltime));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "clock_skew", &r->clock_skew));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "unknown6", &r->unknown6));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DomainInfoEfs(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_DomainInfoEfs *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "blob_size", &r->blob_size));
	if (NULL == r->efs_blob) {
		NDR_CHECK(ejs_push_null(ejs, v, "efs_blob"));
	} else {
		ejs_push_array_uint8(ejs, v, "efs_blob", r->efs_blob, r->blob_size);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_DomainInfoEfs(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_DomainInfoEfs *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "blob_size", &r->blob_size));
	if (ejs_pull_null(ejs, v, "efs_blob")) {
		r->efs_blob = NULL;
	} else {
		EJS_ALLOC(ejs, r->efs_blob);
		EJS_ALLOC_N(ejs, r->efs_blob, r->blob_size);
		ejs_pull_array_uint8(ejs, v, "efs_blob", r->efs_blob, r->blob_size);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_DomainInformationPolicy(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union lsa_DomainInformationPolicy *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case LSA_DOMAIN_INFO_POLICY_EFS:
			NDR_CHECK(ejs_push_lsa_DomainInfoEfs(ejs, v, "efs_info", &r->efs_info));
			break;
		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			NDR_CHECK(ejs_push_lsa_DomainInfoKerberos(ejs, v, "kerberos_info", &r->kerberos_info));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_lsa_DomainInformationPolicy(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union lsa_DomainInformationPolicy *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case LSA_DOMAIN_INFO_POLICY_EFS:
			NDR_CHECK(ejs_pull_lsa_DomainInfoEfs(ejs, v, "efs_info", &r->efs_info));
			break;
		case LSA_DOMAIN_INFO_POLICY_KERBEROS:
			NDR_CHECK(ejs_pull_lsa_DomainInfoKerberos(ejs, v, "kerberos_info", &r->kerberos_info));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_lsa_TranslatedName2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TranslatedName2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_push_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_index", &r->sid_index));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TranslatedName2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TranslatedName2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_index", &r->sid_index));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TransNameArray2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TransNameArray2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->names) {
		NDR_CHECK(ejs_push_null(ejs, v, "names"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_push_lsa_TranslatedName2(ejs, v, id, &r->names[i]));
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TransNameArray2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TransNameArray2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "names")) {
		r->names = NULL;
	} else {
		EJS_ALLOC(ejs, r->names);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->names, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
				NDR_CHECK(ejs_pull_lsa_TranslatedName2(ejs, v, id, &r->names[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "names" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TranslatedSid2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TranslatedSid2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_index", &r->sid_index));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TranslatedSid2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TranslatedSid2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rid", &r->rid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_index", &r->sid_index));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TransSidArray2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TransSidArray2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_push_lsa_TranslatedSid2(ejs, v, id, &r->sids[i]));
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TransSidArray2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TransSidArray2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "sids")) {
		r->sids = NULL;
	} else {
		EJS_ALLOC(ejs, r->sids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->sids, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_pull_lsa_TranslatedSid2(ejs, v, id, &r->sids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TranslatedSid3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TranslatedSid3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	if (NULL == r->sid) {
		NDR_CHECK(ejs_push_null(ejs, v, "sid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "sid_index", &r->sid_index));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TranslatedSid3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TranslatedSid3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_lsa_SidType(ejs, v, "sid_type", &r->sid_type));
	if (ejs_pull_null(ejs, v, "sid")) {
		r->sid = NULL;
	} else {
		EJS_ALLOC(ejs, r->sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sid_index", &r->sid_index));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_lsa_TransSidArray3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct lsa_TransSidArray3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->sids) {
		NDR_CHECK(ejs_push_null(ejs, v, "sids"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_push_lsa_TranslatedSid3(ejs, v, id, &r->sids[i]));
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_lsa_TransSidArray3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct lsa_TransSidArray3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "sids")) {
		r->sids = NULL;
	} else {
		EJS_ALLOC(ejs, r->sids);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->sids, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "sids", i);
				NDR_CHECK(ejs_pull_lsa_TranslatedSid3(ejs, v, id, &r->sids[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "sids" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_lsa_Close(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_Close *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_Close(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_Close *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_Close(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CLOSE, (ejs_pull_function_t)ejs_pull_lsa_Close, (ejs_push_function_t)ejs_push_lsa_Close);
}


static NTSTATUS ejs_pull_lsa_Delete(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_Delete *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_Delete(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_Delete *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_Delete(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_DELETE, (ejs_pull_function_t)ejs_pull_lsa_Delete, (ejs_push_function_t)ejs_push_lsa_Delete);
}


static NTSTATUS ejs_pull_lsa_EnumPrivs(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumPrivs *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_count", &r->in.max_count));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumPrivs(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumPrivs *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.privs) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_PrivArray(ejs, v, "privs", r->out.privs));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumPrivs(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMPRIVS, (ejs_pull_function_t)ejs_pull_lsa_EnumPrivs, (ejs_push_function_t)ejs_push_lsa_EnumPrivs);
}


static NTSTATUS ejs_pull_lsa_QuerySecurity(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QuerySecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_security_secinfo(ejs, v, "sec_info", &r->in.sec_info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QuerySecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QuerySecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sdbuf) {
		NDR_CHECK(ejs_push_null(ejs, v, "sdbuf"));
	} else {
		NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sdbuf", r->out.sdbuf));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QuerySecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYSECURITY, (ejs_pull_function_t)ejs_pull_lsa_QuerySecurity, (ejs_push_function_t)ejs_push_lsa_QuerySecurity);
}


static NTSTATUS ejs_pull_lsa_SetSecObj(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetSecObj *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetSecObj(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetSecObj *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetSecObj(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETSECOBJ, (ejs_pull_function_t)ejs_pull_lsa_SetSecObj, (ejs_push_function_t)ejs_push_lsa_SetSecObj);
}


static NTSTATUS ejs_pull_lsa_ChangePassword(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_ChangePassword *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_ChangePassword(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_ChangePassword *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_ChangePassword(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CHANGEPASSWORD, (ejs_pull_function_t)ejs_pull_lsa_ChangePassword, (ejs_push_function_t)ejs_push_lsa_ChangePassword);
}


static NTSTATUS ejs_pull_lsa_OpenPolicy(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_OpenPolicy *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "system_name", r->in.system_name));
	}
	if (ejs_pull_null(ejs, v, "attr")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.attr);
		NDR_CHECK(ejs_pull_lsa_ObjectAttribute(ejs, v, "attr", r->in.attr));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_OpenPolicy(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_OpenPolicy *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_OpenPolicy(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_OPENPOLICY, (ejs_pull_function_t)ejs_pull_lsa_OpenPolicy, (ejs_push_function_t)ejs_push_lsa_OpenPolicy);
}


static NTSTATUS ejs_pull_lsa_QueryInfoPolicy(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QueryInfoPolicy *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QueryInfoPolicy(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QueryInfoPolicy *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_lsa_PolicyInformation(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QueryInfoPolicy(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYINFOPOLICY, (ejs_pull_function_t)ejs_pull_lsa_QueryInfoPolicy, (ejs_push_function_t)ejs_push_lsa_QueryInfoPolicy);
}


static NTSTATUS ejs_pull_lsa_SetInfoPolicy(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetInfoPolicy *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetInfoPolicy(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetInfoPolicy *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetInfoPolicy(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETINFOPOLICY, (ejs_pull_function_t)ejs_pull_lsa_SetInfoPolicy, (ejs_push_function_t)ejs_push_lsa_SetInfoPolicy);
}


static NTSTATUS ejs_pull_lsa_ClearAuditLog(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_ClearAuditLog *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_ClearAuditLog(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_ClearAuditLog *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_ClearAuditLog(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CLEARAUDITLOG, (ejs_pull_function_t)ejs_pull_lsa_ClearAuditLog, (ejs_push_function_t)ejs_push_lsa_ClearAuditLog);
}


static NTSTATUS ejs_pull_lsa_CreateAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CreateAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CreateAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CreateAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.acct_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "acct_handle", r->out.acct_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CreateAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREATEACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_CreateAccount, (ejs_push_function_t)ejs_push_lsa_CreateAccount);
}


static NTSTATUS ejs_pull_lsa_EnumAccounts(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumAccounts *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_entries", &r->in.num_entries));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumAccounts(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumAccounts *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_SidArray(ejs, v, "sids", r->out.sids));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumAccounts(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMACCOUNTS, (ejs_pull_function_t)ejs_pull_lsa_EnumAccounts, (ejs_push_function_t)ejs_push_lsa_EnumAccounts);
}


static NTSTATUS ejs_pull_lsa_CreateTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CreateTrustedDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		NDR_CHECK(ejs_pull_lsa_DomainInfo(ejs, v, "info", r->in.info));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CreateTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CreateTrustedDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.trustdom_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "trustdom_handle", r->out.trustdom_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CreateTrustedDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREATETRUSTEDDOMAIN, (ejs_pull_function_t)ejs_pull_lsa_CreateTrustedDomain, (ejs_push_function_t)ejs_push_lsa_CreateTrustedDomain);
}


static NTSTATUS ejs_pull_lsa_EnumTrustDom(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumTrustDom *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_size", &r->in.max_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumTrustDom(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumTrustDom *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.domains) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_DomainList(ejs, v, "domains", r->out.domains));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumTrustDom(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMTRUSTDOM, (ejs_pull_function_t)ejs_pull_lsa_EnumTrustDom, (ejs_push_function_t)ejs_push_lsa_EnumTrustDom);
}


static NTSTATUS ejs_pull_lsa_LookupNames(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupNames *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_names", &r->in.num_names));
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_TransSidArray(ejs, v, "sids", r->in.sids));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.names, r->in.num_names);
		for (i=0;i<r->in.num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, id, &r->in.names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupNames(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupNames *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransSidArray(ejs, v, "sids", r->out.sids));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupNames(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPNAMES, (ejs_pull_function_t)ejs_pull_lsa_LookupNames, (ejs_push_function_t)ejs_push_lsa_LookupNames);
}


static NTSTATUS ejs_pull_lsa_LookupSids(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupSids *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_SidArray(ejs, v, "sids", r->in.sids));
	}
	if (ejs_pull_null(ejs, v, "names")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.names);
		NDR_CHECK(ejs_pull_lsa_TransNameArray(ejs, v, "names", r->in.names));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupSids(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupSids *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.names) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransNameArray(ejs, v, "names", r->out.names));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupSids(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPSIDS, (ejs_pull_function_t)ejs_pull_lsa_LookupSids, (ejs_push_function_t)ejs_push_lsa_LookupSids);
}


static NTSTATUS ejs_pull_lsa_CreateSecret(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CreateSecret *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->in.name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CreateSecret(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CreateSecret *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sec_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "sec_handle", r->out.sec_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CreateSecret(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREATESECRET, (ejs_pull_function_t)ejs_pull_lsa_CreateSecret, (ejs_push_function_t)ejs_push_lsa_CreateSecret);
}


static NTSTATUS ejs_pull_lsa_OpenAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_OpenAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_OpenAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_OpenAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.acct_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "acct_handle", r->out.acct_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_OpenAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_OPENACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_OpenAccount, (ejs_push_function_t)ejs_push_lsa_OpenAccount);
}


static NTSTATUS ejs_pull_lsa_EnumPrivsAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumPrivsAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumPrivsAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumPrivsAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.privs) {
		NDR_CHECK(ejs_push_null(ejs, v, "privs"));
	} else {
		NDR_CHECK(ejs_push_lsa_PrivilegeSet(ejs, v, "privs", r->out.privs));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumPrivsAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMPRIVSACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_EnumPrivsAccount, (ejs_push_function_t)ejs_push_lsa_EnumPrivsAccount);
}


static NTSTATUS ejs_pull_lsa_AddPrivilegesToAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_AddPrivilegesToAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "privs")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.privs);
		NDR_CHECK(ejs_pull_lsa_PrivilegeSet(ejs, v, "privs", r->in.privs));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_AddPrivilegesToAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_AddPrivilegesToAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_AddPrivilegesToAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ADDPRIVILEGESTOACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_AddPrivilegesToAccount, (ejs_push_function_t)ejs_push_lsa_AddPrivilegesToAccount);
}


static NTSTATUS ejs_pull_lsa_RemovePrivilegesFromAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_RemovePrivilegesFromAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint8(ejs, v, "remove_all", &r->in.remove_all));
	if (ejs_pull_null(ejs, v, "privs")) {
		r->in.privs = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.privs);
		NDR_CHECK(ejs_pull_lsa_PrivilegeSet(ejs, v, "privs", r->in.privs));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_RemovePrivilegesFromAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_RemovePrivilegesFromAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_RemovePrivilegesFromAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_REMOVEPRIVILEGESFROMACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_RemovePrivilegesFromAccount, (ejs_push_function_t)ejs_push_lsa_RemovePrivilegesFromAccount);
}


static NTSTATUS ejs_pull_lsa_GetQuotasForAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_GetQuotasForAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_GetQuotasForAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_GetQuotasForAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_GetQuotasForAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_GETQUOTASFORACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_GetQuotasForAccount, (ejs_push_function_t)ejs_push_lsa_GetQuotasForAccount);
}


static NTSTATUS ejs_pull_lsa_SetQuotasForAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetQuotasForAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetQuotasForAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetQuotasForAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetQuotasForAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETQUOTASFORACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_SetQuotasForAccount, (ejs_push_function_t)ejs_push_lsa_SetQuotasForAccount);
}


static NTSTATUS ejs_pull_lsa_GetSystemAccessAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_GetSystemAccessAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_GetSystemAccessAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_GetSystemAccessAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_GetSystemAccessAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_GETSYSTEMACCESSACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_GetSystemAccessAccount, (ejs_push_function_t)ejs_push_lsa_GetSystemAccessAccount);
}


static NTSTATUS ejs_pull_lsa_SetSystemAccessAccount(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetSystemAccessAccount *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetSystemAccessAccount(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetSystemAccessAccount *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetSystemAccessAccount(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETSYSTEMACCESSACCOUNT, (ejs_pull_function_t)ejs_pull_lsa_SetSystemAccessAccount, (ejs_push_function_t)ejs_push_lsa_SetSystemAccessAccount);
}


static NTSTATUS ejs_pull_lsa_OpenTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_OpenTrustedDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_OpenTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_OpenTrustedDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.trustdom_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "trustdom_handle", r->out.trustdom_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_OpenTrustedDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_OPENTRUSTEDDOMAIN, (ejs_pull_function_t)ejs_pull_lsa_OpenTrustedDomain, (ejs_push_function_t)ejs_push_lsa_OpenTrustedDomain);
}


static NTSTATUS ejs_pull_lsa_QueryTrustedDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QueryTrustedDomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "trustdom_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.trustdom_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "trustdom_handle", r->in.trustdom_handle));
	}
	NDR_CHECK(ejs_pull_lsa_TrustDomInfoEnum(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QueryTrustedDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QueryTrustedDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_lsa_TrustedDomainInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QueryTrustedDomainInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYTRUSTEDDOMAININFO, (ejs_pull_function_t)ejs_pull_lsa_QueryTrustedDomainInfo, (ejs_push_function_t)ejs_push_lsa_QueryTrustedDomainInfo);
}


static NTSTATUS ejs_pull_lsa_SetInformationTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetInformationTrustedDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetInformationTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetInformationTrustedDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetInformationTrustedDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETINFORMATIONTRUSTEDDOMAIN, (ejs_pull_function_t)ejs_pull_lsa_SetInformationTrustedDomain, (ejs_push_function_t)ejs_push_lsa_SetInformationTrustedDomain);
}


static NTSTATUS ejs_pull_lsa_OpenSecret(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_OpenSecret *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->in.name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_OpenSecret(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_OpenSecret *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sec_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "sec_handle", r->out.sec_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_OpenSecret(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_OPENSECRET, (ejs_pull_function_t)ejs_pull_lsa_OpenSecret, (ejs_push_function_t)ejs_push_lsa_OpenSecret);
}


static NTSTATUS ejs_pull_lsa_SetSecret(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetSecret *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "sec_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sec_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "sec_handle", r->in.sec_handle));
	}
	if (ejs_pull_null(ejs, v, "new_val")) {
		r->in.new_val = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.new_val);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF(ejs, v, "new_val", r->in.new_val));
	}
	if (ejs_pull_null(ejs, v, "old_val")) {
		r->in.old_val = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.old_val);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF(ejs, v, "old_val", r->in.old_val));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetSecret(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetSecret *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetSecret(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETSECRET, (ejs_pull_function_t)ejs_pull_lsa_SetSecret, (ejs_push_function_t)ejs_push_lsa_SetSecret);
}


static NTSTATUS ejs_pull_lsa_QuerySecret(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QuerySecret *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "sec_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sec_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "sec_handle", r->in.sec_handle));
	}
	if (ejs_pull_null(ejs, v, "new_val")) {
		r->in.new_val = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.new_val);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF_PTR(ejs, v, "new_val", r->in.new_val));
	}
	if (ejs_pull_null(ejs, v, "new_mtime")) {
		r->in.new_mtime = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.new_mtime);
		NDR_CHECK(ejs_pull_NTTIME_hyper(ejs, v, "new_mtime", r->in.new_mtime));
	}
	if (ejs_pull_null(ejs, v, "old_val")) {
		r->in.old_val = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.old_val);
		NDR_CHECK(ejs_pull_lsa_DATA_BUF_PTR(ejs, v, "old_val", r->in.old_val));
	}
	if (ejs_pull_null(ejs, v, "old_mtime")) {
		r->in.old_mtime = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.old_mtime);
		NDR_CHECK(ejs_pull_NTTIME_hyper(ejs, v, "old_mtime", r->in.old_mtime));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QuerySecret(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QuerySecret *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.new_val) {
		NDR_CHECK(ejs_push_null(ejs, v, "new_val"));
	} else {
		NDR_CHECK(ejs_push_lsa_DATA_BUF_PTR(ejs, v, "new_val", r->out.new_val));
	}
	if (NULL == r->out.new_mtime) {
		NDR_CHECK(ejs_push_null(ejs, v, "new_mtime"));
	} else {
		NDR_CHECK(ejs_push_NTTIME_hyper(ejs, v, "new_mtime", r->out.new_mtime));
	}
	if (NULL == r->out.old_val) {
		NDR_CHECK(ejs_push_null(ejs, v, "old_val"));
	} else {
		NDR_CHECK(ejs_push_lsa_DATA_BUF_PTR(ejs, v, "old_val", r->out.old_val));
	}
	if (NULL == r->out.old_mtime) {
		NDR_CHECK(ejs_push_null(ejs, v, "old_mtime"));
	} else {
		NDR_CHECK(ejs_push_NTTIME_hyper(ejs, v, "old_mtime", r->out.old_mtime));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QuerySecret(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYSECRET, (ejs_pull_function_t)ejs_pull_lsa_QuerySecret, (ejs_push_function_t)ejs_push_lsa_QuerySecret);
}


static NTSTATUS ejs_pull_lsa_LookupPrivValue(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupPrivValue *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", r->in.name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupPrivValue(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupPrivValue *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.luid) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_LUID(ejs, v, "luid", r->out.luid));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupPrivValue(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPPRIVVALUE, (ejs_pull_function_t)ejs_pull_lsa_LookupPrivValue, (ejs_push_function_t)ejs_push_lsa_LookupPrivValue);
}


static NTSTATUS ejs_pull_lsa_LookupPrivName(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupPrivName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "luid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.luid);
		NDR_CHECK(ejs_pull_lsa_LUID(ejs, v, "luid", r->in.luid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupPrivName(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupPrivName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "name", r->out.name));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupPrivName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPPRIVNAME, (ejs_pull_function_t)ejs_pull_lsa_LookupPrivName, (ejs_push_function_t)ejs_push_lsa_LookupPrivName);
}


static NTSTATUS ejs_pull_lsa_LookupPrivDisplayName(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupPrivDisplayName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", r->in.name));
	}
	if (ejs_pull_null(ejs, v, "language_id")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.language_id);
		NDR_CHECK(ejs_pull_uint16(ejs, v, "language_id", r->in.language_id));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "unknown", &r->in.unknown));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupPrivDisplayName(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupPrivDisplayName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.disp_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "disp_name"));
	} else {
		NDR_CHECK(ejs_push_lsa_StringLarge(ejs, v, "disp_name", r->out.disp_name));
	}
	if (NULL == r->out.language_id) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint16(ejs, v, "language_id", r->out.language_id));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupPrivDisplayName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPPRIVDISPLAYNAME, (ejs_pull_function_t)ejs_pull_lsa_LookupPrivDisplayName, (ejs_push_function_t)ejs_push_lsa_LookupPrivDisplayName);
}


static NTSTATUS ejs_pull_lsa_DeleteObject(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_DeleteObject *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_DeleteObject(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_DeleteObject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_DeleteObject(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_DELETEOBJECT, (ejs_pull_function_t)ejs_pull_lsa_DeleteObject, (ejs_push_function_t)ejs_push_lsa_DeleteObject);
}


static NTSTATUS ejs_pull_lsa_EnumAccountsWithUserRight(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumAccountsWithUserRight *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "name")) {
		r->in.name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", r->in.name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumAccountsWithUserRight(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumAccountsWithUserRight *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_SidArray(ejs, v, "sids", r->out.sids));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumAccountsWithUserRight(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMACCOUNTSWITHUSERRIGHT, (ejs_pull_function_t)ejs_pull_lsa_EnumAccountsWithUserRight, (ejs_push_function_t)ejs_push_lsa_EnumAccountsWithUserRight);
}


static NTSTATUS ejs_pull_lsa_EnumAccountRights(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumAccountRights *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumAccountRights(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumAccountRights *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.rights) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_RightSet(ejs, v, "rights", r->out.rights));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumAccountRights(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMACCOUNTRIGHTS, (ejs_pull_function_t)ejs_pull_lsa_EnumAccountRights, (ejs_push_function_t)ejs_push_lsa_EnumAccountRights);
}


static NTSTATUS ejs_pull_lsa_AddAccountRights(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_AddAccountRights *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	if (ejs_pull_null(ejs, v, "rights")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.rights);
		NDR_CHECK(ejs_pull_lsa_RightSet(ejs, v, "rights", r->in.rights));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_AddAccountRights(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_AddAccountRights *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_AddAccountRights(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ADDACCOUNTRIGHTS, (ejs_pull_function_t)ejs_pull_lsa_AddAccountRights, (ejs_push_function_t)ejs_push_lsa_AddAccountRights);
}


static NTSTATUS ejs_pull_lsa_RemoveAccountRights(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_RemoveAccountRights *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "sid", r->in.sid));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->in.unknown));
	if (ejs_pull_null(ejs, v, "rights")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.rights);
		NDR_CHECK(ejs_pull_lsa_RightSet(ejs, v, "rights", r->in.rights));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_RemoveAccountRights(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_RemoveAccountRights *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_RemoveAccountRights(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_REMOVEACCOUNTRIGHTS, (ejs_pull_function_t)ejs_pull_lsa_RemoveAccountRights, (ejs_push_function_t)ejs_push_lsa_RemoveAccountRights);
}


static NTSTATUS ejs_pull_lsa_QueryTrustedDomainInfoBySid(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QueryTrustedDomainInfoBySid *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "dom_sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.dom_sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "dom_sid", r->in.dom_sid));
	}
	NDR_CHECK(ejs_pull_lsa_TrustDomInfoEnum(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QueryTrustedDomainInfoBySid(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QueryTrustedDomainInfoBySid *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_lsa_TrustedDomainInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QueryTrustedDomainInfoBySid(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYTRUSTEDDOMAININFOBYSID, (ejs_pull_function_t)ejs_pull_lsa_QueryTrustedDomainInfoBySid, (ejs_push_function_t)ejs_push_lsa_QueryTrustedDomainInfoBySid);
}


static NTSTATUS ejs_pull_lsa_SetTrustedDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetTrustedDomainInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetTrustedDomainInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetTrustedDomainInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetTrustedDomainInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETTRUSTEDDOMAININFO, (ejs_pull_function_t)ejs_pull_lsa_SetTrustedDomainInfo, (ejs_push_function_t)ejs_push_lsa_SetTrustedDomainInfo);
}


static NTSTATUS ejs_pull_lsa_DeleteTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_DeleteTrustedDomain *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "dom_sid")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.dom_sid);
		NDR_CHECK(ejs_pull_dom_sid2(ejs, v, "dom_sid", r->in.dom_sid));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_DeleteTrustedDomain(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_DeleteTrustedDomain *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_DeleteTrustedDomain(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_DELETETRUSTEDDOMAIN, (ejs_pull_function_t)ejs_pull_lsa_DeleteTrustedDomain, (ejs_push_function_t)ejs_push_lsa_DeleteTrustedDomain);
}


static NTSTATUS ejs_pull_lsa_StorePrivateData(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_StorePrivateData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_StorePrivateData(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_StorePrivateData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_StorePrivateData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_STOREPRIVATEDATA, (ejs_pull_function_t)ejs_pull_lsa_StorePrivateData, (ejs_push_function_t)ejs_push_lsa_StorePrivateData);
}


static NTSTATUS ejs_pull_lsa_RetrievePrivateData(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_RetrievePrivateData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_RetrievePrivateData(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_RetrievePrivateData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_RetrievePrivateData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_RETRIEVEPRIVATEDATA, (ejs_pull_function_t)ejs_pull_lsa_RetrievePrivateData, (ejs_push_function_t)ejs_push_lsa_RetrievePrivateData);
}


static NTSTATUS ejs_pull_lsa_OpenPolicy2(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_OpenPolicy2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "system_name", &r->in.system_name));
	}
	if (ejs_pull_null(ejs, v, "attr")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.attr);
		NDR_CHECK(ejs_pull_lsa_ObjectAttribute(ejs, v, "attr", r->in.attr));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_OpenPolicy2(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_OpenPolicy2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_OpenPolicy2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_OPENPOLICY2, (ejs_pull_function_t)ejs_pull_lsa_OpenPolicy2, (ejs_push_function_t)ejs_push_lsa_OpenPolicy2);
}


static NTSTATUS ejs_pull_lsa_GetUserName(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_GetUserName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "system_name")) {
		r->in.system_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.system_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "system_name", &r->in.system_name));
	}
	if (ejs_pull_null(ejs, v, "account_name")) {
		r->in.account_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.account_name);
		NDR_CHECK(ejs_pull_lsa_String(ejs, v, "account_name", r->in.account_name));
	}
	if (ejs_pull_null(ejs, v, "authority_name")) {
		r->in.authority_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.authority_name);
		NDR_CHECK(ejs_pull_lsa_StringPointer(ejs, v, "authority_name", r->in.authority_name));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_GetUserName(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_GetUserName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.account_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "account_name"));
	} else {
		NDR_CHECK(ejs_push_lsa_String(ejs, v, "account_name", r->out.account_name));
	}
	if (NULL == r->out.authority_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "authority_name"));
	} else {
		NDR_CHECK(ejs_push_lsa_StringPointer(ejs, v, "authority_name", r->out.authority_name));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_GetUserName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_GETUSERNAME, (ejs_pull_function_t)ejs_pull_lsa_GetUserName, (ejs_push_function_t)ejs_push_lsa_GetUserName);
}


static NTSTATUS ejs_pull_lsa_QueryInfoPolicy2(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QueryInfoPolicy2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QueryInfoPolicy2(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QueryInfoPolicy2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_lsa_PolicyInformation(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QueryInfoPolicy2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYINFOPOLICY2, (ejs_pull_function_t)ejs_pull_lsa_QueryInfoPolicy2, (ejs_push_function_t)ejs_push_lsa_QueryInfoPolicy2);
}


static NTSTATUS ejs_pull_lsa_SetInfoPolicy2(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetInfoPolicy2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetInfoPolicy2(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetInfoPolicy2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetInfoPolicy2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETINFOPOLICY2, (ejs_pull_function_t)ejs_pull_lsa_SetInfoPolicy2, (ejs_push_function_t)ejs_push_lsa_SetInfoPolicy2);
}


static NTSTATUS ejs_pull_lsa_QueryTrustedDomainInfoByName(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QueryTrustedDomainInfoByName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "trusted_domain", &r->in.trusted_domain));
	NDR_CHECK(ejs_pull_lsa_TrustDomInfoEnum(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QueryTrustedDomainInfoByName(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QueryTrustedDomainInfoByName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_lsa_TrustedDomainInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QueryTrustedDomainInfoByName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYTRUSTEDDOMAININFOBYNAME, (ejs_pull_function_t)ejs_pull_lsa_QueryTrustedDomainInfoByName, (ejs_push_function_t)ejs_push_lsa_QueryTrustedDomainInfoByName);
}


static NTSTATUS ejs_pull_lsa_SetTrustedDomainInfoByName(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetTrustedDomainInfoByName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "trusted_domain", &r->in.trusted_domain));
	NDR_CHECK(ejs_pull_lsa_TrustDomInfoEnum(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_lsa_TrustedDomainInfo(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetTrustedDomainInfoByName(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetTrustedDomainInfoByName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetTrustedDomainInfoByName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETTRUSTEDDOMAININFOBYNAME, (ejs_pull_function_t)ejs_pull_lsa_SetTrustedDomainInfoByName, (ejs_push_function_t)ejs_push_lsa_SetTrustedDomainInfoByName);
}


static NTSTATUS ejs_pull_lsa_EnumTrustedDomainsEx(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_EnumTrustedDomainsEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_size", &r->in.max_size));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_EnumTrustedDomainsEx(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_EnumTrustedDomainsEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.resume_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	if (NULL == r->out.domains) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_DomainListEx(ejs, v, "domains", r->out.domains));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_EnumTrustedDomainsEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_ENUMTRUSTEDDOMAINSEX, (ejs_pull_function_t)ejs_pull_lsa_EnumTrustedDomainsEx, (ejs_push_function_t)ejs_push_lsa_EnumTrustedDomainsEx);
}


static NTSTATUS ejs_pull_lsa_CreateTrustedDomainEx(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CreateTrustedDomainEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CreateTrustedDomainEx(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CreateTrustedDomainEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CreateTrustedDomainEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREATETRUSTEDDOMAINEX, (ejs_pull_function_t)ejs_pull_lsa_CreateTrustedDomainEx, (ejs_push_function_t)ejs_push_lsa_CreateTrustedDomainEx);
}


static NTSTATUS ejs_pull_lsa_CloseTrustedDomainEx(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CloseTrustedDomainEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CloseTrustedDomainEx(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CloseTrustedDomainEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "handle", r->out.handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CloseTrustedDomainEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CLOSETRUSTEDDOMAINEX, (ejs_pull_function_t)ejs_pull_lsa_CloseTrustedDomainEx, (ejs_push_function_t)ejs_push_lsa_CloseTrustedDomainEx);
}


static NTSTATUS ejs_pull_lsa_QueryDomainInformationPolicy(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_QueryDomainInformationPolicy *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_QueryDomainInformationPolicy(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_QueryDomainInformationPolicy *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_lsa_DomainInformationPolicy(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_QueryDomainInformationPolicy(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_QUERYDOMAININFORMATIONPOLICY, (ejs_pull_function_t)ejs_pull_lsa_QueryDomainInformationPolicy, (ejs_push_function_t)ejs_push_lsa_QueryDomainInformationPolicy);
}


static NTSTATUS ejs_pull_lsa_SetDomainInformationPolicy(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_SetDomainInformationPolicy *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		r->in.info = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_lsa_DomainInformationPolicy(ejs, v, "info", r->in.info));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_SetDomainInformationPolicy(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_SetDomainInformationPolicy *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_SetDomainInformationPolicy(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_SETDOMAININFORMATIONPOLICY, (ejs_pull_function_t)ejs_pull_lsa_SetDomainInformationPolicy, (ejs_push_function_t)ejs_push_lsa_SetDomainInformationPolicy);
}


static NTSTATUS ejs_pull_lsa_OpenTrustedDomainByName(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_OpenTrustedDomainByName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_lsa_String(ejs, v, "name", &r->in.name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "access_mask", &r->in.access_mask));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_OpenTrustedDomainByName(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_OpenTrustedDomainByName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.trustdom_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "trustdom_handle", r->out.trustdom_handle));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_OpenTrustedDomainByName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_OPENTRUSTEDDOMAINBYNAME, (ejs_pull_function_t)ejs_pull_lsa_OpenTrustedDomainByName, (ejs_push_function_t)ejs_push_lsa_OpenTrustedDomainByName);
}


static NTSTATUS ejs_pull_lsa_TestCall(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_TestCall *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_TestCall(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_TestCall *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_TestCall(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_TESTCALL, (ejs_pull_function_t)ejs_pull_lsa_TestCall, (ejs_push_function_t)ejs_push_lsa_TestCall);
}


static NTSTATUS ejs_pull_lsa_LookupSids2(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupSids2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_SidArray(ejs, v, "sids", r->in.sids));
	}
	if (ejs_pull_null(ejs, v, "names")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.names);
		NDR_CHECK(ejs_pull_lsa_TransNameArray2(ejs, v, "names", r->in.names));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupSids2(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupSids2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.names) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransNameArray2(ejs, v, "names", r->out.names));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupSids2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPSIDS2, (ejs_pull_function_t)ejs_pull_lsa_LookupSids2, (ejs_push_function_t)ejs_push_lsa_LookupSids2);
}


static NTSTATUS ejs_pull_lsa_LookupNames2(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupNames2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_names", &r->in.num_names));
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_TransSidArray2(ejs, v, "sids", r->in.sids));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.names, r->in.num_names);
		for (i=0;i<r->in.num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, id, &r->in.names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupNames2(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupNames2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransSidArray2(ejs, v, "sids", r->out.sids));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupNames2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPNAMES2, (ejs_pull_function_t)ejs_pull_lsa_LookupNames2, (ejs_push_function_t)ejs_push_lsa_LookupNames2);
}


static NTSTATUS ejs_pull_lsa_CreateTrustedDomainEx2(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CreateTrustedDomainEx2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CreateTrustedDomainEx2(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CreateTrustedDomainEx2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CreateTrustedDomainEx2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREATETRUSTEDDOMAINEX2, (ejs_pull_function_t)ejs_pull_lsa_CreateTrustedDomainEx2, (ejs_push_function_t)ejs_push_lsa_CreateTrustedDomainEx2);
}


static NTSTATUS ejs_pull_lsa_CREDRWRITE(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRWRITE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRWRITE(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRWRITE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRWRITE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRWRITE, (ejs_pull_function_t)ejs_pull_lsa_CREDRWRITE, (ejs_push_function_t)ejs_push_lsa_CREDRWRITE);
}


static NTSTATUS ejs_pull_lsa_CREDRREAD(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRREAD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRREAD(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRREAD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRREAD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRREAD, (ejs_pull_function_t)ejs_pull_lsa_CREDRREAD, (ejs_push_function_t)ejs_push_lsa_CREDRREAD);
}


static NTSTATUS ejs_pull_lsa_CREDRENUMERATE(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRENUMERATE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRENUMERATE(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRENUMERATE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRENUMERATE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRENUMERATE, (ejs_pull_function_t)ejs_pull_lsa_CREDRENUMERATE, (ejs_push_function_t)ejs_push_lsa_CREDRENUMERATE);
}


static NTSTATUS ejs_pull_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRWRITEDOMAINCREDENTIALS(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRWRITEDOMAINCREDENTIALS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRWRITEDOMAINCREDENTIALS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRWRITEDOMAINCREDENTIALS, (ejs_pull_function_t)ejs_pull_lsa_CREDRWRITEDOMAINCREDENTIALS, (ejs_push_function_t)ejs_push_lsa_CREDRWRITEDOMAINCREDENTIALS);
}


static NTSTATUS ejs_pull_lsa_CREDRREADDOMAINCREDENTIALS(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRREADDOMAINCREDENTIALS(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRREADDOMAINCREDENTIALS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRREADDOMAINCREDENTIALS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRREADDOMAINCREDENTIALS, (ejs_pull_function_t)ejs_pull_lsa_CREDRREADDOMAINCREDENTIALS, (ejs_push_function_t)ejs_push_lsa_CREDRREADDOMAINCREDENTIALS);
}


static NTSTATUS ejs_pull_lsa_CREDRDELETE(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRDELETE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRDELETE(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRDELETE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRDELETE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRDELETE, (ejs_pull_function_t)ejs_pull_lsa_CREDRDELETE, (ejs_push_function_t)ejs_push_lsa_CREDRDELETE);
}


static NTSTATUS ejs_pull_lsa_CREDRGETTARGETINFO(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRGETTARGETINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRGETTARGETINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRGETTARGETINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRGETTARGETINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRGETTARGETINFO, (ejs_pull_function_t)ejs_pull_lsa_CREDRGETTARGETINFO, (ejs_push_function_t)ejs_push_lsa_CREDRGETTARGETINFO);
}


static NTSTATUS ejs_pull_lsa_CREDRPROFILELOADED(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRPROFILELOADED *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRPROFILELOADED(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRPROFILELOADED *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRPROFILELOADED(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRPROFILELOADED, (ejs_pull_function_t)ejs_pull_lsa_CREDRPROFILELOADED, (ejs_push_function_t)ejs_push_lsa_CREDRPROFILELOADED);
}


static NTSTATUS ejs_pull_lsa_LookupNames3(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupNames3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "handle", r->in.handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_names", &r->in.num_names));
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_TransSidArray3(ejs, v, "sids", r->in.sids));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.names, r->in.num_names);
		for (i=0;i<r->in.num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, id, &r->in.names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupNames3(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupNames3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransSidArray3(ejs, v, "sids", r->out.sids));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupNames3(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPNAMES3, (ejs_pull_function_t)ejs_pull_lsa_LookupNames3, (ejs_push_function_t)ejs_push_lsa_LookupNames3);
}


static NTSTATUS ejs_pull_lsa_CREDRGETSESSIONTYPES(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRGETSESSIONTYPES *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRGETSESSIONTYPES(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRGETSESSIONTYPES *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRGETSESSIONTYPES(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRGETSESSIONTYPES, (ejs_pull_function_t)ejs_pull_lsa_CREDRGETSESSIONTYPES, (ejs_push_function_t)ejs_push_lsa_CREDRGETSESSIONTYPES);
}


static NTSTATUS ejs_pull_lsa_LSARREGISTERAUDITEVENT(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARREGISTERAUDITEVENT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARREGISTERAUDITEVENT(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARREGISTERAUDITEVENT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARREGISTERAUDITEVENT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARREGISTERAUDITEVENT, (ejs_pull_function_t)ejs_pull_lsa_LSARREGISTERAUDITEVENT, (ejs_push_function_t)ejs_push_lsa_LSARREGISTERAUDITEVENT);
}


static NTSTATUS ejs_pull_lsa_LSARGENAUDITEVENT(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARGENAUDITEVENT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARGENAUDITEVENT(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARGENAUDITEVENT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARGENAUDITEVENT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARGENAUDITEVENT, (ejs_pull_function_t)ejs_pull_lsa_LSARGENAUDITEVENT, (ejs_push_function_t)ejs_push_lsa_LSARGENAUDITEVENT);
}


static NTSTATUS ejs_pull_lsa_LSARUNREGISTERAUDITEVENT(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARUNREGISTERAUDITEVENT(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARUNREGISTERAUDITEVENT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARUNREGISTERAUDITEVENT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARUNREGISTERAUDITEVENT, (ejs_pull_function_t)ejs_pull_lsa_LSARUNREGISTERAUDITEVENT, (ejs_push_function_t)ejs_push_lsa_LSARUNREGISTERAUDITEVENT);
}


static NTSTATUS ejs_pull_lsa_LSARQUERYFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARQUERYFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARQUERYFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARQUERYFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARQUERYFORESTTRUSTINFORMATION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARQUERYFORESTTRUSTINFORMATION, (ejs_pull_function_t)ejs_pull_lsa_LSARQUERYFORESTTRUSTINFORMATION, (ejs_push_function_t)ejs_push_lsa_LSARQUERYFORESTTRUSTINFORMATION);
}


static NTSTATUS ejs_pull_lsa_LSARSETFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARSETFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARSETFORESTTRUSTINFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARSETFORESTTRUSTINFORMATION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARSETFORESTTRUSTINFORMATION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARSETFORESTTRUSTINFORMATION, (ejs_pull_function_t)ejs_pull_lsa_LSARSETFORESTTRUSTINFORMATION, (ejs_push_function_t)ejs_push_lsa_LSARSETFORESTTRUSTINFORMATION);
}


static NTSTATUS ejs_pull_lsa_CREDRRENAME(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_CREDRRENAME *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_CREDRRENAME(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_CREDRRENAME *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_CREDRRENAME(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_CREDRRENAME, (ejs_pull_function_t)ejs_pull_lsa_CREDRRENAME, (ejs_push_function_t)ejs_push_lsa_CREDRRENAME);
}


static NTSTATUS ejs_pull_lsa_LookupSids3(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupSids3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_SidArray(ejs, v, "sids", r->in.sids));
	}
	if (ejs_pull_null(ejs, v, "names")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.names);
		NDR_CHECK(ejs_pull_lsa_TransNameArray2(ejs, v, "names", r->in.names));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupSids3(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupSids3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.names) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransNameArray2(ejs, v, "names", r->out.names));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupSids3(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPSIDS3, (ejs_pull_function_t)ejs_pull_lsa_LookupSids3, (ejs_push_function_t)ejs_push_lsa_LookupSids3);
}


static NTSTATUS ejs_pull_lsa_LookupNames4(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LookupNames4 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_names", &r->in.num_names));
	if (ejs_pull_null(ejs, v, "sids")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.sids);
		NDR_CHECK(ejs_pull_lsa_TransSidArray3(ejs, v, "sids", r->in.sids));
	}
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "count")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.count);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "count", r->in.count));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->in.unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->in.unknown2));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.names, r->in.num_names);
		for (i=0;i<r->in.num_names;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "names", i);
			NDR_CHECK(ejs_pull_lsa_String(ejs, v, id, &r->in.names[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "names" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LookupNames4(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LookupNames4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "domains"));
	} else {
		NDR_CHECK(ejs_push_lsa_RefDomainList(ejs, v, "domains", r->out.domains));
	}
	if (NULL == r->out.sids) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_lsa_TransSidArray3(ejs, v, "sids", r->out.sids));
	}
	if (NULL == r->out.count) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "count", r->out.count));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LookupNames4(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LOOKUPNAMES4, (ejs_pull_function_t)ejs_pull_lsa_LookupNames4, (ejs_push_function_t)ejs_push_lsa_LookupNames4);
}


static NTSTATUS ejs_pull_lsa_LSAROPENPOLICYSCE(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSAROPENPOLICYSCE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSAROPENPOLICYSCE(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSAROPENPOLICYSCE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSAROPENPOLICYSCE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSAROPENPOLICYSCE, (ejs_pull_function_t)ejs_pull_lsa_LSAROPENPOLICYSCE, (ejs_push_function_t)ejs_push_lsa_LSAROPENPOLICYSCE);
}


static NTSTATUS ejs_pull_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARADTREGISTERSECURITYEVENTSOURCE, (ejs_pull_function_t)ejs_pull_lsa_LSARADTREGISTERSECURITYEVENTSOURCE, (ejs_push_function_t)ejs_push_lsa_LSARADTREGISTERSECURITYEVENTSOURCE);
}


static NTSTATUS ejs_pull_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE, (ejs_pull_function_t)ejs_pull_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, (ejs_push_function_t)ejs_push_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE);
}


static NTSTATUS ejs_pull_lsa_LSARADTREPORTSECURITYEVENT(struct ejs_rpc *ejs, struct MprVar *v, struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_lsa_LSARADTREPORTSECURITYEVENT(struct ejs_rpc *ejs, struct MprVar *v, const struct lsa_LSARADTREPORTSECURITYEVENT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_lsa_LSARADTREPORTSECURITYEVENT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_lsarpc, DCERPC_LSA_LSARADTREPORTSECURITYEVENT, (ejs_pull_function_t)ejs_pull_lsa_LSARADTREPORTSECURITYEVENT, (ejs_push_function_t)ejs_push_lsa_LSARADTREPORTSECURITYEVENT);
}

static int ejs_lsarpc_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "lsarpc", argc, argv);
	mprSetCFunction(obj, "lsa_Close", ejs_lsa_Close);
	mprSetCFunction(obj, "lsa_Delete", ejs_lsa_Delete);
	mprSetCFunction(obj, "lsa_EnumPrivs", ejs_lsa_EnumPrivs);
	mprSetCFunction(obj, "lsa_QuerySecurity", ejs_lsa_QuerySecurity);
	mprSetCFunction(obj, "lsa_SetSecObj", ejs_lsa_SetSecObj);
	mprSetCFunction(obj, "lsa_ChangePassword", ejs_lsa_ChangePassword);
	mprSetCFunction(obj, "lsa_OpenPolicy", ejs_lsa_OpenPolicy);
	mprSetCFunction(obj, "lsa_QueryInfoPolicy", ejs_lsa_QueryInfoPolicy);
	mprSetCFunction(obj, "lsa_SetInfoPolicy", ejs_lsa_SetInfoPolicy);
	mprSetCFunction(obj, "lsa_ClearAuditLog", ejs_lsa_ClearAuditLog);
	mprSetCFunction(obj, "lsa_CreateAccount", ejs_lsa_CreateAccount);
	mprSetCFunction(obj, "lsa_EnumAccounts", ejs_lsa_EnumAccounts);
	mprSetCFunction(obj, "lsa_CreateTrustedDomain", ejs_lsa_CreateTrustedDomain);
	mprSetCFunction(obj, "lsa_EnumTrustDom", ejs_lsa_EnumTrustDom);
	mprSetCFunction(obj, "lsa_LookupNames", ejs_lsa_LookupNames);
	mprSetCFunction(obj, "lsa_LookupSids", ejs_lsa_LookupSids);
	mprSetCFunction(obj, "lsa_CreateSecret", ejs_lsa_CreateSecret);
	mprSetCFunction(obj, "lsa_OpenAccount", ejs_lsa_OpenAccount);
	mprSetCFunction(obj, "lsa_EnumPrivsAccount", ejs_lsa_EnumPrivsAccount);
	mprSetCFunction(obj, "lsa_AddPrivilegesToAccount", ejs_lsa_AddPrivilegesToAccount);
	mprSetCFunction(obj, "lsa_RemovePrivilegesFromAccount", ejs_lsa_RemovePrivilegesFromAccount);
	mprSetCFunction(obj, "lsa_GetQuotasForAccount", ejs_lsa_GetQuotasForAccount);
	mprSetCFunction(obj, "lsa_SetQuotasForAccount", ejs_lsa_SetQuotasForAccount);
	mprSetCFunction(obj, "lsa_GetSystemAccessAccount", ejs_lsa_GetSystemAccessAccount);
	mprSetCFunction(obj, "lsa_SetSystemAccessAccount", ejs_lsa_SetSystemAccessAccount);
	mprSetCFunction(obj, "lsa_OpenTrustedDomain", ejs_lsa_OpenTrustedDomain);
	mprSetCFunction(obj, "lsa_QueryTrustedDomainInfo", ejs_lsa_QueryTrustedDomainInfo);
	mprSetCFunction(obj, "lsa_SetInformationTrustedDomain", ejs_lsa_SetInformationTrustedDomain);
	mprSetCFunction(obj, "lsa_OpenSecret", ejs_lsa_OpenSecret);
	mprSetCFunction(obj, "lsa_SetSecret", ejs_lsa_SetSecret);
	mprSetCFunction(obj, "lsa_QuerySecret", ejs_lsa_QuerySecret);
	mprSetCFunction(obj, "lsa_LookupPrivValue", ejs_lsa_LookupPrivValue);
	mprSetCFunction(obj, "lsa_LookupPrivName", ejs_lsa_LookupPrivName);
	mprSetCFunction(obj, "lsa_LookupPrivDisplayName", ejs_lsa_LookupPrivDisplayName);
	mprSetCFunction(obj, "lsa_DeleteObject", ejs_lsa_DeleteObject);
	mprSetCFunction(obj, "lsa_EnumAccountsWithUserRight", ejs_lsa_EnumAccountsWithUserRight);
	mprSetCFunction(obj, "lsa_EnumAccountRights", ejs_lsa_EnumAccountRights);
	mprSetCFunction(obj, "lsa_AddAccountRights", ejs_lsa_AddAccountRights);
	mprSetCFunction(obj, "lsa_RemoveAccountRights", ejs_lsa_RemoveAccountRights);
	mprSetCFunction(obj, "lsa_QueryTrustedDomainInfoBySid", ejs_lsa_QueryTrustedDomainInfoBySid);
	mprSetCFunction(obj, "lsa_SetTrustedDomainInfo", ejs_lsa_SetTrustedDomainInfo);
	mprSetCFunction(obj, "lsa_DeleteTrustedDomain", ejs_lsa_DeleteTrustedDomain);
	mprSetCFunction(obj, "lsa_StorePrivateData", ejs_lsa_StorePrivateData);
	mprSetCFunction(obj, "lsa_RetrievePrivateData", ejs_lsa_RetrievePrivateData);
	mprSetCFunction(obj, "lsa_OpenPolicy2", ejs_lsa_OpenPolicy2);
	mprSetCFunction(obj, "lsa_GetUserName", ejs_lsa_GetUserName);
	mprSetCFunction(obj, "lsa_QueryInfoPolicy2", ejs_lsa_QueryInfoPolicy2);
	mprSetCFunction(obj, "lsa_SetInfoPolicy2", ejs_lsa_SetInfoPolicy2);
	mprSetCFunction(obj, "lsa_QueryTrustedDomainInfoByName", ejs_lsa_QueryTrustedDomainInfoByName);
	mprSetCFunction(obj, "lsa_SetTrustedDomainInfoByName", ejs_lsa_SetTrustedDomainInfoByName);
	mprSetCFunction(obj, "lsa_EnumTrustedDomainsEx", ejs_lsa_EnumTrustedDomainsEx);
	mprSetCFunction(obj, "lsa_CreateTrustedDomainEx", ejs_lsa_CreateTrustedDomainEx);
	mprSetCFunction(obj, "lsa_CloseTrustedDomainEx", ejs_lsa_CloseTrustedDomainEx);
	mprSetCFunction(obj, "lsa_QueryDomainInformationPolicy", ejs_lsa_QueryDomainInformationPolicy);
	mprSetCFunction(obj, "lsa_SetDomainInformationPolicy", ejs_lsa_SetDomainInformationPolicy);
	mprSetCFunction(obj, "lsa_OpenTrustedDomainByName", ejs_lsa_OpenTrustedDomainByName);
	mprSetCFunction(obj, "lsa_TestCall", ejs_lsa_TestCall);
	mprSetCFunction(obj, "lsa_LookupSids2", ejs_lsa_LookupSids2);
	mprSetCFunction(obj, "lsa_LookupNames2", ejs_lsa_LookupNames2);
	mprSetCFunction(obj, "lsa_CreateTrustedDomainEx2", ejs_lsa_CreateTrustedDomainEx2);
	mprSetCFunction(obj, "lsa_CREDRWRITE", ejs_lsa_CREDRWRITE);
	mprSetCFunction(obj, "lsa_CREDRREAD", ejs_lsa_CREDRREAD);
	mprSetCFunction(obj, "lsa_CREDRENUMERATE", ejs_lsa_CREDRENUMERATE);
	mprSetCFunction(obj, "lsa_CREDRWRITEDOMAINCREDENTIALS", ejs_lsa_CREDRWRITEDOMAINCREDENTIALS);
	mprSetCFunction(obj, "lsa_CREDRREADDOMAINCREDENTIALS", ejs_lsa_CREDRREADDOMAINCREDENTIALS);
	mprSetCFunction(obj, "lsa_CREDRDELETE", ejs_lsa_CREDRDELETE);
	mprSetCFunction(obj, "lsa_CREDRGETTARGETINFO", ejs_lsa_CREDRGETTARGETINFO);
	mprSetCFunction(obj, "lsa_CREDRPROFILELOADED", ejs_lsa_CREDRPROFILELOADED);
	mprSetCFunction(obj, "lsa_LookupNames3", ejs_lsa_LookupNames3);
	mprSetCFunction(obj, "lsa_CREDRGETSESSIONTYPES", ejs_lsa_CREDRGETSESSIONTYPES);
	mprSetCFunction(obj, "lsa_LSARREGISTERAUDITEVENT", ejs_lsa_LSARREGISTERAUDITEVENT);
	mprSetCFunction(obj, "lsa_LSARGENAUDITEVENT", ejs_lsa_LSARGENAUDITEVENT);
	mprSetCFunction(obj, "lsa_LSARUNREGISTERAUDITEVENT", ejs_lsa_LSARUNREGISTERAUDITEVENT);
	mprSetCFunction(obj, "lsa_LSARQUERYFORESTTRUSTINFORMATION", ejs_lsa_LSARQUERYFORESTTRUSTINFORMATION);
	mprSetCFunction(obj, "lsa_LSARSETFORESTTRUSTINFORMATION", ejs_lsa_LSARSETFORESTTRUSTINFORMATION);
	mprSetCFunction(obj, "lsa_CREDRRENAME", ejs_lsa_CREDRRENAME);
	mprSetCFunction(obj, "lsa_LookupSids3", ejs_lsa_LookupSids3);
	mprSetCFunction(obj, "lsa_LookupNames4", ejs_lsa_LookupNames4);
	mprSetCFunction(obj, "lsa_LSAROPENPOLICYSCE", ejs_lsa_LSAROPENPOLICYSCE);
	mprSetCFunction(obj, "lsa_LSARADTREGISTERSECURITYEVENTSOURCE", ejs_lsa_LSARADTREGISTERSECURITYEVENTSOURCE);
	mprSetCFunction(obj, "lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE", ejs_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE);
	mprSetCFunction(obj, "lsa_LSARADTREPORTSECURITYEVENT", ejs_lsa_LSARADTREPORTSECURITYEVENT);
	mprSetVar(obj, "LSA_REF_DOMAIN_LIST_MULTIPLIER", mprCreateNumberVar(32));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO", mprCreateNumberVar(7));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS_INFO", mprCreateNumberVar(2));
	mprSetVar(obj, "SID_NAME_ALIAS", mprCreateNumberVar(4));
	mprSetVar(obj, "SID_NAME_DELETED", mprCreateNumberVar(6));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_BASIC", mprCreateNumberVar(5));
	mprSetVar(obj, "SID_NAME_DOM_GRP", mprCreateNumberVar(2));
	mprSetVar(obj, "LSA_ENUM_TRUST_DOMAIN_EX_MULTIPLIER", mprCreateNumberVar(82));
	mprSetVar(obj, "LSA_ENUM_TRUST_DOMAIN_MULTIPLIER", mprCreateNumberVar(60));
	mprSetVar(obj, "SID_NAME_INVALID", mprCreateNumberVar(7));
	mprSetVar(obj, "SID_NAME_UNKNOWN", mprCreateNumberVar(8));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET", mprCreateNumberVar(3));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_11", mprCreateNumberVar(11));
	mprSetVar(obj, "SID_NAME_USER", mprCreateNumberVar(1));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_NAME", mprCreateNumberVar(1));
	mprSetVar(obj, "SID_NAME_USE_NONE", mprCreateNumberVar(0));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_INFO_EX", mprCreateNumberVar(6));
	mprSetVar(obj, "SID_NAME_DOMAIN", mprCreateNumberVar(3));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_PASSWORD", mprCreateNumberVar(4));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_INFO_ALL", mprCreateNumberVar(12));
	mprSetVar(obj, "LSA_TRUSTED_DOMAIN_INFO_FULL_INFO", mprCreateNumberVar(8));
	mprSetVar(obj, "SID_NAME_COMPUTER", mprCreateNumberVar(9));
	mprSetVar(obj, "SID_NAME_WKN_GRP", mprCreateNumberVar(5));
	return ejs_rpc_init(obj, "lsarpc");
}

NTSTATUS ejs_init_lsarpc(void)
{
	ejsDefineCFunction(-1, "lsarpc_init", ejs_lsarpc_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
