
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_epmapper.h"
#include "librpc/gen_ndr/ndr_epmapper_ejs.h"


static NTSTATUS ejs_push_epm_twr_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct epm_twr_t *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "tower_length", &r->tower_length));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_epm_twr_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct epm_twr_t *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_epm_entry_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct epm_entry_t *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "object", &r->object));
	if (NULL == r->tower) {
		NDR_CHECK(ejs_push_null(ejs, v, "tower"));
	} else {
		NDR_CHECK(ejs_push_epm_twr_t(ejs, v, "tower", r->tower));
	}
	NDR_CHECK(ejs_push_string(ejs, v, "annotation", r->annotation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_epm_entry_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct epm_entry_t *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "object", &r->object));
	if (ejs_pull_null(ejs, v, "tower")) {
		r->tower = NULL;
	} else {
		EJS_ALLOC(ejs, r->tower);
		NDR_CHECK(ejs_pull_epm_twr_t(ejs, v, "tower", r->tower));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "annotation", &r->annotation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_rpc_if_id_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct rpc_if_id_t *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "uuid", &r->uuid));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "vers_major", &r->vers_major));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "vers_minor", &r->vers_minor));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_epm_twr_p_t(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct epm_twr_p_t *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->twr) {
		NDR_CHECK(ejs_push_null(ejs, v, "twr"));
	} else {
		NDR_CHECK(ejs_push_epm_twr_t(ejs, v, "twr", r->twr));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_epm_Insert(struct ejs_rpc *ejs, struct MprVar *v, struct epm_Insert *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_ents", &r->in.num_ents));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "replace", &r->in.replace));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.entries, r->in.num_ents);
		for (i=0;i<r->in.num_ents;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_pull_epm_entry_t(ejs, v, id, &r->in.entries[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_Insert(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_Insert *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_Insert(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_INSERT, (ejs_pull_function_t)ejs_pull_epm_Insert, (ejs_push_function_t)ejs_push_epm_Insert);
}


static NTSTATUS ejs_pull_epm_Delete(struct ejs_rpc *ejs, struct MprVar *v, struct epm_Delete *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_ents", &r->in.num_ents));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->in.entries, r->in.num_ents);
		for (i=0;i<r->in.num_ents;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_pull_epm_entry_t(ejs, v, id, &r->in.entries[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_Delete(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_Delete *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_Delete(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_DELETE, (ejs_pull_function_t)ejs_pull_epm_Delete, (ejs_push_function_t)ejs_push_epm_Delete);
}


static NTSTATUS ejs_pull_epm_Lookup(struct ejs_rpc *ejs, struct MprVar *v, struct epm_Lookup *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "inquiry_type", &r->in.inquiry_type));
	if (ejs_pull_null(ejs, v, "object")) {
		r->in.object = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.object);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "object", r->in.object));
	}
	if (ejs_pull_null(ejs, v, "interface_id")) {
		r->in.interface_id = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.interface_id);
		NDR_CHECK(ejs_pull_rpc_if_id_t(ejs, v, "interface_id", r->in.interface_id));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "vers_option", &r->in.vers_option));
	if (ejs_pull_null(ejs, v, "entry_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.entry_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "entry_handle", r->in.entry_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_ents", &r->in.max_ents));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_Lookup(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_Lookup *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.entry_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "entry_handle", r->out.entry_handle));
	}
	if (NULL == r->out.num_ents) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "num_ents", r->out.num_ents));
	}
	{
		uint32_t i;
		for (i=0;i<*r->out.num_ents;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "entries", i);
			NDR_CHECK(ejs_push_epm_entry_t(ejs, v, id, &r->out.entries[i]));
		}
		ejs_push_uint32(ejs, v, "entries" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_Lookup(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_LOOKUP, (ejs_pull_function_t)ejs_pull_epm_Lookup, (ejs_push_function_t)ejs_push_epm_Lookup);
}


static NTSTATUS ejs_pull_epm_Map(struct ejs_rpc *ejs, struct MprVar *v, struct epm_Map *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "object")) {
		r->in.object = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.object);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "object", r->in.object));
	}
	if (ejs_pull_null(ejs, v, "map_tower")) {
		r->in.map_tower = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.map_tower);
		NDR_CHECK(ejs_pull_epm_twr_t(ejs, v, "map_tower", r->in.map_tower));
	}
	if (ejs_pull_null(ejs, v, "entry_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.entry_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "entry_handle", r->in.entry_handle));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_towers", &r->in.max_towers));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_Map(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_Map *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.entry_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "entry_handle", r->out.entry_handle));
	}
	if (NULL == r->out.num_towers) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "num_towers", r->out.num_towers));
	}
	{
		uint32_t i;
		for (i=0;i<*r->out.num_towers;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "towers", i);
			NDR_CHECK(ejs_push_epm_twr_p_t(ejs, v, id, &r->out.towers[i]));
		}
		ejs_push_uint32(ejs, v, "towers" ".length", &i);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_Map(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_MAP, (ejs_pull_function_t)ejs_pull_epm_Map, (ejs_push_function_t)ejs_push_epm_Map);
}


static NTSTATUS ejs_pull_epm_LookupHandleFree(struct ejs_rpc *ejs, struct MprVar *v, struct epm_LookupHandleFree *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "entry_handle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.entry_handle);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "entry_handle", r->in.entry_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_LookupHandleFree(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_LookupHandleFree *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.entry_handle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "entry_handle", r->out.entry_handle));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_LookupHandleFree(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_LOOKUPHANDLEFREE, (ejs_pull_function_t)ejs_pull_epm_LookupHandleFree, (ejs_push_function_t)ejs_push_epm_LookupHandleFree);
}


static NTSTATUS ejs_pull_epm_InqObject(struct ejs_rpc *ejs, struct MprVar *v, struct epm_InqObject *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "epm_object")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.epm_object);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "epm_object", r->in.epm_object));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_InqObject(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_InqObject *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_InqObject(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_INQOBJECT, (ejs_pull_function_t)ejs_pull_epm_InqObject, (ejs_push_function_t)ejs_push_epm_InqObject);
}


static NTSTATUS ejs_pull_epm_MgmtDelete(struct ejs_rpc *ejs, struct MprVar *v, struct epm_MgmtDelete *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "object_speced", &r->in.object_speced));
	if (ejs_pull_null(ejs, v, "object")) {
		r->in.object = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.object);
		NDR_CHECK(ejs_pull_GUID(ejs, v, "object", r->in.object));
	}
	if (ejs_pull_null(ejs, v, "tower")) {
		r->in.tower = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.tower);
		NDR_CHECK(ejs_pull_epm_twr_t(ejs, v, "tower", r->in.tower));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_MgmtDelete(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_MgmtDelete *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_MgmtDelete(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_MGMTDELETE, (ejs_pull_function_t)ejs_pull_epm_MgmtDelete, (ejs_push_function_t)ejs_push_epm_MgmtDelete);
}


static NTSTATUS ejs_pull_epm_MapAuth(struct ejs_rpc *ejs, struct MprVar *v, struct epm_MapAuth *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_epm_MapAuth(struct ejs_rpc *ejs, struct MprVar *v, const struct epm_MapAuth *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_epm_MapAuth(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_epmapper, DCERPC_EPM_MAPAUTH, (ejs_pull_function_t)ejs_pull_epm_MapAuth, (ejs_push_function_t)ejs_push_epm_MapAuth);
}

static int ejs_epmapper_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "epmapper", argc, argv);
	mprSetCFunction(obj, "epm_Insert", ejs_epm_Insert);
	mprSetCFunction(obj, "epm_Delete", ejs_epm_Delete);
	mprSetCFunction(obj, "epm_Lookup", ejs_epm_Lookup);
	mprSetCFunction(obj, "epm_Map", ejs_epm_Map);
	mprSetCFunction(obj, "epm_LookupHandleFree", ejs_epm_LookupHandleFree);
	mprSetCFunction(obj, "epm_InqObject", ejs_epm_InqObject);
	mprSetCFunction(obj, "epm_MgmtDelete", ejs_epm_MgmtDelete);
	mprSetCFunction(obj, "epm_MapAuth", ejs_epm_MapAuth);
	mprSetVar(obj, "EPMAPPER_STATUS_NO_MORE_ENTRIES", mprCreateNumberVar(0x16c9a0d6));
	mprSetVar(obj, "EPMAPPER_STATUS_OK", mprCreateNumberVar(0));
	mprSetVar(obj, "EPMAPPER_STATUS_NO_MEMORY", mprCreateNumberVar(0x16C9A012));
	return ejs_rpc_init(obj, "epmapper");
}

NTSTATUS ejs_init_epmapper(void)
{
	ejsDefineCFunction(-1, "epmapper_init", ejs_epmapper_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
