/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_drsuapi.h"

#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_samr.h"
#include "librpc/ndr/ndr_compression.h"
static NTSTATUS ndr_push_drsuapi_SupportedExtensions(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_SupportedExtensions(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_SupportedExtensions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_BASE", DRSUAPI_SUPPORTED_EXTENSION_BASE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION", DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI", DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2", DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS", DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1", DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION", DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_00000080", DRSUAPI_SUPPORTED_EXTENSION_00000080, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE", DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2", DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION", DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2", DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD", DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND", DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO", DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION", DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01", DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP", DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY", DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3", DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_00100000", DRSUAPI_SUPPORTED_EXTENSION_00100000, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2", DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS", DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3", DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT", DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS", DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_20000000", DRSUAPI_SUPPORTED_EXTENSION_20000000, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_40000000", DRSUAPI_SUPPORTED_EXTENSION_40000000, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_80000000", DRSUAPI_SUPPORTED_EXTENSION_80000000, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsBindInfo24(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsBindInfo24 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->site_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsBindInfo24(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsBindInfo24 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->site_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo24(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo24 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo24");
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "u1", r->u1);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsBindInfo28(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsBindInfo28 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->repl_epoch));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->site_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsBindInfo28(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsBindInfo28 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->repl_epoch));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->site_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo28(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo28 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo28");
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "repl_epoch", r->repl_epoch);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsBindInfoFallBack(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsBindInfoFallBack *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsBindInfoFallBack(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsBindInfoFallBack *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfoFallBack(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfoFallBack *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfoFallBack");
	ndr->depth++;
	ndr_print_DATA_BLOB(ndr, "info", r->info);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsBindInfo(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsBindInfo *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 24:
				{
					struct ndr_push *_ndr_info24;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info24, 4, -1));
					NDR_CHECK(ndr_push_drsuapi_DsBindInfo24(_ndr_info24, NDR_SCALARS|NDR_BUFFERS, &r->info24));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info24, 4, -1));
				}
			break;

			case 28:
				{
					struct ndr_push *_ndr_info28;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info28, 4, -1));
					NDR_CHECK(ndr_push_drsuapi_DsBindInfo28(_ndr_info28, NDR_SCALARS|NDR_BUFFERS, &r->info28));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info28, 4, -1));
				}
			break;

			default:
				{
					struct ndr_push *_ndr_FallBack;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_FallBack, 4, -1));
					NDR_CHECK(ndr_push_drsuapi_DsBindInfoFallBack(_ndr_FallBack, NDR_SCALARS, &r->FallBack));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_FallBack, 4, -1));
				}
			break;

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 24:
			break;

			case 28:
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsBindInfo(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsBindInfo *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 24: {
				{
					struct ndr_pull *_ndr_info24;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info24, 4, -1));
					NDR_CHECK(ndr_pull_drsuapi_DsBindInfo24(_ndr_info24, NDR_SCALARS|NDR_BUFFERS, &r->info24));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info24, 4, -1));
				}
			break; }

			case 28: {
				{
					struct ndr_pull *_ndr_info28;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info28, 4, -1));
					NDR_CHECK(ndr_pull_drsuapi_DsBindInfo28(_ndr_info28, NDR_SCALARS|NDR_BUFFERS, &r->info28));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info28, 4, -1));
				}
			break; }

			default: {
				{
					struct ndr_pull *_ndr_FallBack;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_FallBack, 4, -1));
					NDR_CHECK(ndr_pull_drsuapi_DsBindInfoFallBack(_ndr_FallBack, NDR_SCALARS, &r->FallBack));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_FallBack, 4, -1));
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 24:
			break;

			case 28:
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsBindInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsBindInfo");
	switch (level) {
		case 24:
			ndr_print_drsuapi_DsBindInfo24(ndr, "info24", &r->info24);
		break;

		case 28:
			ndr_print_drsuapi_DsBindInfo28(ndr, "info28", &r->info28);
		break;

		default:
			ndr_print_drsuapi_DsBindInfoFallBack(ndr, "FallBack", &r->FallBack);
		break;

	}
}

static NTSTATUS ndr_push_drsuapi_DsBindInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsBindInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->length));
		NDR_CHECK(ndr_push_drsuapi_DsBindInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsBindInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsBindInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsBindInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		if (r->length < 1 || r->length > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->length));
		NDR_CHECK(ndr_pull_drsuapi_DsBindInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsBindInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfoCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfoCtr *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_set_switch_value(ndr, &r->info, r->length);
	ndr_print_drsuapi_DsBindInfo(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaObjectIdentifier(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier *r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_string_array_size(ndr, r->dn)));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsReplicaObjectIdentifier(r, ndr->flags) - 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid28(&r->sid, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_CHARLEN|LIBNDR_FLAG_STR_CONFORMANT);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dn));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaObjectIdentifier(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjectIdentifier *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->dn));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_sid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_CHARLEN|LIBNDR_FLAG_STR_CONFORMANT);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dn));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier");
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaObjectIdentifier(r, ndr->flags) - 4:r->__ndr_size);
	ndr_print_uint32(ndr, "__ndr_size_sid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid28(&r->sid, ndr->flags):r->__ndr_size_sid);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr_print_string(ndr, "dn", r->dn);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsReplicaObjectIdentifier(const struct drsuapi_DsReplicaObjectIdentifier *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier);
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaSyncOptions(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaSyncOptions(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSyncOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION", DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_WRITEABLE", DRSUAPI_DS_REPLICA_SYNC_WRITEABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_PERIODIC", DRSUAPI_DS_REPLICA_SYNC_PERIODIC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING", DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES", DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_FULL", DRSUAPI_DS_REPLICA_SYNC_FULL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_URGENT", DRSUAPI_DS_REPLICA_SYNC_URGENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD", DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_FORCE", DRSUAPI_DS_REPLICA_SYNC_FORCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE", DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED", DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_TWO_WAY", DRSUAPI_DS_REPLICA_SYNC_TWO_WAY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY", DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_INITIAL", DRSUAPI_DS_REPLICA_SYNC_INITIAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION", DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_ABANDONED", DRSUAPI_DS_REPLICA_SYNC_ABANDONED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS", DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET", DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_REQUEUE", DRSUAPI_DS_REPLICA_SYNC_REQUEUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION", DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA", DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_CRITICAL", DRSUAPI_DS_REPLICA_SYNC_CRITICAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS", DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_SYNC_PREEMPTED", DRSUAPI_DS_REPLICA_SYNC_PREEMPTED, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaSyncRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaSyncRequest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid1));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->string1));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncOptions(ndr, NDR_SCALARS, r->options));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid1));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->string1) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string1));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaSyncRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaSyncRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0;
	uint32_t _ptr_string1;
	TALLOC_CTX *_mem_save_string1_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid1));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string1));
			if (_ptr_string1) {
				NDR_PULL_ALLOC(ndr, r->string1);
			} else {
				r->string1 = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncOptions(ndr, NDR_SCALARS, &r->options));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context) {
			_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid1));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->string1) {
				_mem_save_string1_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->string1, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string1_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSyncRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaSyncRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaSyncRequest1");
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	if (r->naming_context) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "guid1", &r->guid1);
	ndr_print_ptr(ndr, "string1", r->string1);
	ndr->depth++;
	if (r->string1) {
		ndr_print_string(ndr, "string1", r->string1);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaSyncOptions(ndr, "options", r->options);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaSyncRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsReplicaSyncRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaSyncRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsReplicaSyncRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsReplicaSyncRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSyncRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaSyncRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaSyncRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaSyncRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaHighWaterMark(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaHighWaterMark *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->tmp_highest_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->reserved_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaHighWaterMark(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaHighWaterMark *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->tmp_highest_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->reserved_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaHighWaterMark(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaHighWaterMark *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaHighWaterMark");
	ndr->depth++;
	ndr_print_hyper(ndr, "tmp_highest_usn", r->tmp_highest_usn);
	ndr_print_hyper(ndr, "reserved_usn", r->reserved_usn);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaCursor(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursor *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaCursor(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursor *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor");
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaCursorCtrEx(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursorCtrEx *r)
{
	uint32_t cntr_cursors_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor(ndr, NDR_BUFFERS, &r->cursors[cntr_cursors_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaCursorCtrEx(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursorCtrEx *r)
{
	uint32_t cntr_cursors_0;
	TALLOC_CTX *_mem_save_cursors_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->cursors));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 0x100000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_PULL_ALLOC_N(ndr, r->cursors, ndr_get_array_size(ndr, &r->cursors));
		_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
		if (r->cursors) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->cursors, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor(ndr, NDR_BUFFERS, &r->cursors[cntr_cursors_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursorCtrEx(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursorCtrEx *r)
{
	uint32_t cntr_cursors_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursorCtrEx");
	ndr->depth++;
	ndr_print_uint32(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr->print(ndr, "%s: ARRAY(%d)", "cursors", r->count);
	ndr->depth++;
	for (cntr_cursors_0=0;cntr_cursors_0<r->count;cntr_cursors_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_cursors_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaCursor(ndr, "cursors", &r->cursors[cntr_cursors_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaNeighbourFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaNeighbourFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaNeighbourFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_WRITEABLE", DRSUAPI_DS_REPLICA_NEIGHBOUR_WRITEABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_SYNC_ON_STARTUP", DRSUAPI_DS_REPLICA_NEIGHBOUR_SYNC_ON_STARTUP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_DO_SCHEDULED_SYNCS", DRSUAPI_DS_REPLICA_NEIGHBOUR_DO_SCHEDULED_SYNCS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_USE_ASYNC_INTERSIDE_TRANSPORT", DRSUAPI_DS_REPLICA_NEIGHBOUR_USE_ASYNC_INTERSIDE_TRANSPORT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_TWO_WAY_SYNC", DRSUAPI_DS_REPLICA_NEIGHBOUR_TWO_WAY_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_RETURN_OBJECT_PARENTS", DRSUAPI_DS_REPLICA_NEIGHBOUR_RETURN_OBJECT_PARENTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_IN_PROGRESS", DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_IN_PROGRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_NEXT_PACKET", DRSUAPI_DS_REPLICA_NEIGHBOUR_FULL_NEXT_PACKET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_NEVER_SYNCED", DRSUAPI_DS_REPLICA_NEIGHBOUR_NEVER_SYNCED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_PREEMPTED", DRSUAPI_DS_REPLICA_NEIGHBOUR_PREEMPTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_IGNORE_CHANGE_NOTIFICATIONS", DRSUAPI_DS_REPLICA_NEIGHBOUR_IGNORE_CHANGE_NOTIFICATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_DISABLE_SCHEDULED_SYNC", DRSUAPI_DS_REPLICA_NEIGHBOUR_DISABLE_SCHEDULED_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_COMPRESS_CHANGES", DRSUAPI_DS_REPLICA_NEIGHBOUR_COMPRESS_CHANGES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_NO_CHANGE_NOTIFICATIONS", DRSUAPI_DS_REPLICA_NEIGHBOUR_NO_CHANGE_NOTIFICATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_NEIGHBOUR_PARTIAL_ATTRIBUTE_SET", DRSUAPI_DS_REPLICA_NEIGHBOUR_PARTIAL_ATTRIBUTE_SET, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesRequest5(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesRequest5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		if (r->naming_context == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourFlags(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_ndr_size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->h1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesRequest5(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesRequest5 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourFlags(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->h1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, LIBNDR_FLAG_REF_ALLOC);
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest5(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesRequest5 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesRequest5");
	ndr->depth++;
	ndr_print_GUID(ndr, "destination_dsa_guid", &r->destination_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "highwatermark", &r->highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaNeighbourFlags(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "max_object_count", r->max_object_count);
	ndr_print_uint32(ndr, "max_ndr_size", r->max_ndr_size);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr_print_hyper(ndr, "h1", r->h1);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOID(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOID *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOID");
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaOID_oid(r->oid, 0):r->__ndr_size);
	ndr_print_ptr(ndr, "oid", r->oid);
	ndr->depth++;
	if (r->oid) {
		ndr_print_string(ndr, "oid", r->oid);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaOIDMapping(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaOIDMapping *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id_prefix));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOID(ndr, NDR_SCALARS, &r->oid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOID(ndr, NDR_BUFFERS, &r->oid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaOIDMapping(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaOIDMapping *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id_prefix));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOID(ndr, NDR_SCALARS, &r->oid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOID(ndr, NDR_BUFFERS, &r->oid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOIDMapping(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOIDMapping *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOIDMapping");
	ndr->depth++;
	ndr_print_uint32(ndr, "id_prefix", r->id_prefix);
	ndr_print_drsuapi_DsReplicaOID(ndr, "oid", &r->oid);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	uint32_t cntr_mappings_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_mappings));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->mappings));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->mappings) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_mappings));
			for (cntr_mappings_1 = 0; cntr_mappings_1 < r->num_mappings; cntr_mappings_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping(ndr, NDR_SCALARS, &r->mappings[cntr_mappings_1]));
			}
			for (cntr_mappings_1 = 0; cntr_mappings_1 < r->num_mappings; cntr_mappings_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping(ndr, NDR_BUFFERS, &r->mappings[cntr_mappings_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	uint32_t _ptr_mappings;
	uint32_t cntr_mappings_1;
	TALLOC_CTX *_mem_save_mappings_0;
	TALLOC_CTX *_mem_save_mappings_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_mappings));
		if (r->num_mappings < 0 || r->num_mappings > 0x100000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_mappings));
		if (_ptr_mappings) {
			NDR_PULL_ALLOC(ndr, r->mappings);
		} else {
			r->mappings = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->mappings) {
			_mem_save_mappings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->mappings, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->mappings));
			NDR_PULL_ALLOC_N(ndr, r->mappings, ndr_get_array_size(ndr, &r->mappings));
			_mem_save_mappings_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->mappings, 0);
			for (cntr_mappings_1 = 0; cntr_mappings_1 < r->num_mappings; cntr_mappings_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping(ndr, NDR_SCALARS, &r->mappings[cntr_mappings_1]));
			}
			for (cntr_mappings_1 = 0; cntr_mappings_1 < r->num_mappings; cntr_mappings_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping(ndr, NDR_BUFFERS, &r->mappings[cntr_mappings_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_mappings_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_mappings_0, 0);
		}
		if (r->mappings) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->mappings, r->num_mappings));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	uint32_t cntr_mappings_1;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOIDMapping_Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_mappings", r->num_mappings);
	ndr_print_ptr(ndr, "mappings", r->mappings);
	ndr->depth++;
	if (r->mappings) {
		ndr->print(ndr, "%s: ARRAY(%d)", "mappings", r->num_mappings);
		ndr->depth++;
		for (cntr_mappings_1=0;cntr_mappings_1<r->num_mappings;cntr_mappings_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_mappings_1);
			if (idx_1) {
				ndr_print_drsuapi_DsReplicaOIDMapping(ndr, "mappings", &r->mappings[cntr_mappings_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsAttributeId(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsAttributeId r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsAttributeId(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsAttributeId *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAttributeId(struct ndr_print *ndr, const char *name, enum drsuapi_DsAttributeId r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case DRSUAPI_ATTRIBUTE_objectClass: val = "DRSUAPI_ATTRIBUTE_objectClass"; break;
			case DRSUAPI_ATTRIBUTE_description: val = "DRSUAPI_ATTRIBUTE_description"; break;
			case DRSUAPI_ATTRIBUTE_member: val = "DRSUAPI_ATTRIBUTE_member"; break;
			case DRSUAPI_ATTRIBUTE_instanceType: val = "DRSUAPI_ATTRIBUTE_instanceType"; break;
			case DRSUAPI_ATTRIBUTE_whenCreated: val = "DRSUAPI_ATTRIBUTE_whenCreated"; break;
			case DRSUAPI_ATTRIBUTE_hasMasterNCs: val = "DRSUAPI_ATTRIBUTE_hasMasterNCs"; break;
			case DRSUAPI_ATTRIBUTE_governsID: val = "DRSUAPI_ATTRIBUTE_governsID"; break;
			case DRSUAPI_ATTRIBUTE_attributeID: val = "DRSUAPI_ATTRIBUTE_attributeID"; break;
			case DRSUAPI_ATTRIBUTE_attributeSyntax: val = "DRSUAPI_ATTRIBUTE_attributeSyntax"; break;
			case DRSUAPI_ATTRIBUTE_isSingleValued: val = "DRSUAPI_ATTRIBUTE_isSingleValued"; break;
			case DRSUAPI_ATTRIBUTE_rangeLower: val = "DRSUAPI_ATTRIBUTE_rangeLower"; break;
			case DRSUAPI_ATTRIBUTE_rangeUpper: val = "DRSUAPI_ATTRIBUTE_rangeUpper"; break;
			case DRSUAPI_ATTRIBUTE_dMDLocation: val = "DRSUAPI_ATTRIBUTE_dMDLocation"; break;
			case DRSUAPI_ATTRIBUTE_objectVersion: val = "DRSUAPI_ATTRIBUTE_objectVersion"; break;
			case DRSUAPI_ATTRIBUTE_invocationId: val = "DRSUAPI_ATTRIBUTE_invocationId"; break;
			case DRSUAPI_ATTRIBUTE_showInAdvancedViewOnly: val = "DRSUAPI_ATTRIBUTE_showInAdvancedViewOnly"; break;
			case DRSUAPI_ATTRIBUTE_adminDisplayName: val = "DRSUAPI_ATTRIBUTE_adminDisplayName"; break;
			case DRSUAPI_ATTRIBUTE_adminDescription: val = "DRSUAPI_ATTRIBUTE_adminDescription"; break;
			case DRSUAPI_ATTRIBUTE_oMSyntax: val = "DRSUAPI_ATTRIBUTE_oMSyntax"; break;
			case DRSUAPI_ATTRIBUTE_ntSecurityDescriptor: val = "DRSUAPI_ATTRIBUTE_ntSecurityDescriptor"; break;
			case DRSUAPI_ATTRIBUTE_searchFlags: val = "DRSUAPI_ATTRIBUTE_searchFlags"; break;
			case DRSUAPI_ATTRIBUTE_lDAPDisplayName: val = "DRSUAPI_ATTRIBUTE_lDAPDisplayName"; break;
			case DRSUAPI_ATTRIBUTE_name: val = "DRSUAPI_ATTRIBUTE_name"; break;
			case DRSUAPI_ATTRIBUTE_currentValue: val = "DRSUAPI_ATTRIBUTE_currentValue"; break;
			case DRSUAPI_ATTRIBUTE_objectSid: val = "DRSUAPI_ATTRIBUTE_objectSid"; break;
			case DRSUAPI_ATTRIBUTE_schemaIDGUID: val = "DRSUAPI_ATTRIBUTE_schemaIDGUID"; break;
			case DRSUAPI_ATTRIBUTE_dBCSPwd: val = "DRSUAPI_ATTRIBUTE_dBCSPwd"; break;
			case DRSUAPI_ATTRIBUTE_unicodePwd: val = "DRSUAPI_ATTRIBUTE_unicodePwd"; break;
			case DRSUAPI_ATTRIBUTE_ntPwdHistory: val = "DRSUAPI_ATTRIBUTE_ntPwdHistory"; break;
			case DRSUAPI_ATTRIBUTE_priorValue: val = "DRSUAPI_ATTRIBUTE_priorValue"; break;
			case DRSUAPI_ATTRIBUTE_supplementalCredentials: val = "DRSUAPI_ATTRIBUTE_supplementalCredentials"; break;
			case DRSUAPI_ATTRIBUTE_trustAuthIncoming: val = "DRSUAPI_ATTRIBUTE_trustAuthIncoming"; break;
			case DRSUAPI_ATTRIBUTE_trustAuthOutgoing: val = "DRSUAPI_ATTRIBUTE_trustAuthOutgoing"; break;
			case DRSUAPI_ATTRIBUTE_lmPwdHistory: val = "DRSUAPI_ATTRIBUTE_lmPwdHistory"; break;
			case DRSUAPI_ATTRIBUTE_sAMAccountName: val = "DRSUAPI_ATTRIBUTE_sAMAccountName"; break;
			case DRSUAPI_ATTRIBUTE_fSMORoleOwner: val = "DRSUAPI_ATTRIBUTE_fSMORoleOwner"; break;
			case DRSUAPI_ATTRIBUTE_systemFlags: val = "DRSUAPI_ATTRIBUTE_systemFlags"; break;
			case DRSUAPI_ATTRIBUTE_serverReference: val = "DRSUAPI_ATTRIBUTE_serverReference"; break;
			case DRSUAPI_ATTRIBUTE_serverReferenceBL: val = "DRSUAPI_ATTRIBUTE_serverReferenceBL"; break;
			case DRSUAPI_ATTRIBUTE_initialAuthIncoming: val = "DRSUAPI_ATTRIBUTE_initialAuthIncoming"; break;
			case DRSUAPI_ATTRIBUTE_initialAuthOutgoing: val = "DRSUAPI_ATTRIBUTE_initialAuthOutgoing"; break;
			case DRSUAPI_ATTRIBUTE_wellKnownObjects: val = "DRSUAPI_ATTRIBUTE_wellKnownObjects"; break;
			case DRSUAPI_ATTRIBUTE_isMemberOfPartialAttributeSet: val = "DRSUAPI_ATTRIBUTE_isMemberOfPartialAttributeSet"; break;
			case DRSUAPI_ATTRIBUTE_objectCategory: val = "DRSUAPI_ATTRIBUTE_objectCategory"; break;
			case DRSUAPI_ATTRIBUTE_gPLink: val = "DRSUAPI_ATTRIBUTE_gPLink"; break;
			case DRSUAPI_ATTRIBUTE_msDS_Behavior_Version: val = "DRSUAPI_ATTRIBUTE_msDS_Behavior_Version"; break;
			case DRSUAPI_ATTRIBUTE_msDS_KeyVersionNumber: val = "DRSUAPI_ATTRIBUTE_msDS_KeyVersionNumber"; break;
			case DRSUAPI_ATTRIBUTE_msDS_HasDomainNCs: val = "DRSUAPI_ATTRIBUTE_msDS_HasDomainNCs"; break;
			case DRSUAPI_ATTRIBUTE_msDS_hasMasterNCs: val = "DRSUAPI_ATTRIBUTE_msDS_hasMasterNCs"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesRequest8(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesRequest8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		if (r->naming_context == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourFlags(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_ndr_size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->h1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unique_ptr1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unique_ptr2));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesRequest8(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesRequest8 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourFlags(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->h1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unique_ptr1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unique_ptr2));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, LIBNDR_FLAG_REF_ALLOC);
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest8(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesRequest8 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesRequest8");
	ndr->depth++;
	ndr_print_GUID(ndr, "destination_dsa_guid", &r->destination_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "highwatermark", &r->highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaNeighbourFlags(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "max_object_count", r->max_object_count);
	ndr_print_uint32(ndr, "max_ndr_size", r->max_ndr_size);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr_print_hyper(ndr, "h1", r->h1);
	ndr_print_uint32(ndr, "unique_ptr1", r->unique_ptr1);
	ndr_print_uint32(ndr, "unique_ptr2", r->unique_ptr2);
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetNCChangesRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 5:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest5(ndr, NDR_SCALARS, &r->req5));
			break;

			case 8:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest8(ndr, NDR_SCALARS, &r->req8));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 5:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest5(ndr, NDR_BUFFERS, &r->req5));
			break;

			case 8:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest8(ndr, NDR_BUFFERS, &r->req8));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetNCChangesRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetNCChangesRequest", _level);
		}
		switch (level) {
			case 5: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest5(ndr, NDR_SCALARS, &r->req5));
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest8(ndr, NDR_SCALARS, &r->req8));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 5:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest5(ndr, NDR_BUFFERS, &r->req5));
			break;

			case 8:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest8(ndr, NDR_BUFFERS, &r->req8));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNCChangesRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNCChangesRequest");
	switch (level) {
		case 5:
			ndr_print_drsuapi_DsGetNCChangesRequest5(ndr, "req5", &r->req5);
		break;

		case 8:
			ndr_print_drsuapi_DsGetNCChangesRequest8(ndr, "req8", &r->req8);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaCursor2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursor2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_sync_success));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaCursor2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursor2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_sync_success));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor2");
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr_print_NTTIME(ndr, "last_sync_success", r->last_sync_success);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaCursor2CtrEx(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	uint32_t cntr_cursors_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2(ndr, NDR_BUFFERS, &r->cursors[cntr_cursors_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaCursor2CtrEx(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	uint32_t cntr_cursors_0;
	TALLOC_CTX *_mem_save_cursors_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->cursors));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 0x100000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_PULL_ALLOC_N(ndr, r->cursors, ndr_get_array_size(ndr, &r->cursors));
		_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
		if (r->cursors) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->cursors, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
		for (cntr_cursors_0 = 0; cntr_cursors_0 < r->count; cntr_cursors_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2(ndr, NDR_BUFFERS, &r->cursors[cntr_cursors_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor2CtrEx(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	uint32_t cntr_cursors_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor2CtrEx");
	ndr->depth++;
	ndr_print_uint32(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr->print(ndr, "%s: ARRAY(%d)", "cursors", r->count);
	ndr->depth++;
	for (cntr_cursors_0=0;cntr_cursors_0<r->count;cntr_cursors_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_cursors_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaCursor2(ndr, "cursors", &r->cursors[cntr_cursors_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAttributeValue(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAttributeValue *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_DATA_BLOB(0, r->blob, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->blob));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->blob) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->blob));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAttributeValue(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAttributeValue *r)
{
	uint32_t _ptr_blob;
	TALLOC_CTX *_mem_save_blob_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		if (r->__ndr_size < 0 || r->__ndr_size > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_blob));
		if (_ptr_blob) {
			NDR_PULL_ALLOC(ndr, r->blob);
		} else {
			r->blob = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->blob) {
			_mem_save_blob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->blob, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->blob));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_blob_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAttributeValue(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAttributeValue *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAttributeValue");
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DATA_BLOB(0, r->blob, 0):r->__ndr_size);
	ndr_print_ptr(ndr, "blob", r->blob);
	ndr->depth++;
	if (r->blob) {
		ndr_print_DATA_BLOB(ndr, "blob", *r->blob);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAttributeValueCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAttributeValueCtr *r)
{
	uint32_t cntr_values_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_values));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->values));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_values));
			for (cntr_values_1 = 0; cntr_values_1 < r->num_values; cntr_values_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->values[cntr_values_1]));
			}
			for (cntr_values_1 = 0; cntr_values_1 < r->num_values; cntr_values_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->values[cntr_values_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAttributeValueCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAttributeValueCtr *r)
{
	uint32_t _ptr_values;
	uint32_t cntr_values_1;
	TALLOC_CTX *_mem_save_values_0;
	TALLOC_CTX *_mem_save_values_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_values));
		if (r->num_values < 0 || r->num_values > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_values));
		if (_ptr_values) {
			NDR_PULL_ALLOC(ndr, r->values);
		} else {
			r->values = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->values));
			NDR_PULL_ALLOC_N(ndr, r->values, ndr_get_array_size(ndr, &r->values));
			_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			for (cntr_values_1 = 0; cntr_values_1 < r->num_values; cntr_values_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->values[cntr_values_1]));
			}
			for (cntr_values_1 = 0; cntr_values_1 < r->num_values; cntr_values_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->values[cntr_values_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, 0);
		}
		if (r->values) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->values, r->num_values));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAttributeValueCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAttributeValueCtr *r)
{
	uint32_t cntr_values_1;
	ndr_print_struct(ndr, name, "drsuapi_DsAttributeValueCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_values", r->num_values);
	ndr_print_ptr(ndr, "values", r->values);
	ndr->depth++;
	if (r->values) {
		ndr->print(ndr, "%s: ARRAY(%d)", "values", r->num_values);
		ndr->depth++;
		for (cntr_values_1=0;cntr_values_1<r->num_values;cntr_values_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_values_1);
			if (idx_1) {
				ndr_print_drsuapi_DsAttributeValue(ndr, "values", &r->values[cntr_values_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaObjectIdentifier3(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsReplicaObjectIdentifier3(r, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid28(&r->sid, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_CHARLEN);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dn));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaObjectIdentifier3(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_sid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_CHARLEN);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dn));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier3");
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaObjectIdentifier3(r, ndr->flags):r->__ndr_size);
	ndr_print_uint32(ndr, "__ndr_size_sid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid28(&r->sid, ndr->flags):r->__ndr_size_sid);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr_print_string(ndr, "dn", r->dn);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsReplicaObjectIdentifier3(const struct drsuapi_DsReplicaObjectIdentifier3 *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier3);
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsReplicaObjectIdentifier3Binary(r, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid28(&r->sid, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_CHARLEN);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dn));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->binary.length + 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_sid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_CHARLEN);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dn));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_binary));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->binary));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier3Binary");
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaObjectIdentifier3Binary(r, ndr->flags):r->__ndr_size);
	ndr_print_uint32(ndr, "__ndr_size_sid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid28(&r->sid, ndr->flags):r->__ndr_size_sid);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr_print_string(ndr, "dn", r->dn);
	ndr_print_uint32(ndr, "__ndr_size_binary", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->binary.length + 4:r->__ndr_size_binary);
	ndr_print_DATA_BLOB(ndr, "binary", r->binary);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsReplicaObjectIdentifier3Binary(const struct drsuapi_DsReplicaObjectIdentifier3Binary *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier3Binary);
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaAttribute(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attid));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValueCtr(ndr, NDR_SCALARS, &r->value_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValueCtr(ndr, NDR_BUFFERS, &r->value_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaAttribute(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attid));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValueCtr(ndr, NDR_SCALARS, &r->value_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValueCtr(ndr, NDR_BUFFERS, &r->value_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttribute(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttribute *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttribute");
	ndr->depth++;
	ndr_print_drsuapi_DsAttributeId(ndr, "attid", r->attid);
	ndr_print_drsuapi_DsAttributeValueCtr(ndr, "value_ctr", &r->value_ctr);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaAttributeCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaAttributeCtr *r)
{
	uint32_t cntr_attributes_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_attributes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attributes) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_attributes));
			for (cntr_attributes_1 = 0; cntr_attributes_1 < r->num_attributes; cntr_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAttribute(ndr, NDR_SCALARS, &r->attributes[cntr_attributes_1]));
			}
			for (cntr_attributes_1 = 0; cntr_attributes_1 < r->num_attributes; cntr_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAttribute(ndr, NDR_BUFFERS, &r->attributes[cntr_attributes_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaAttributeCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaAttributeCtr *r)
{
	uint32_t _ptr_attributes;
	uint32_t cntr_attributes_1;
	TALLOC_CTX *_mem_save_attributes_0;
	TALLOC_CTX *_mem_save_attributes_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_attributes));
		if (r->num_attributes < 0 || r->num_attributes > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attributes));
		if (_ptr_attributes) {
			NDR_PULL_ALLOC(ndr, r->attributes);
		} else {
			r->attributes = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attributes) {
			_mem_save_attributes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attributes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attributes));
			NDR_PULL_ALLOC_N(ndr, r->attributes, ndr_get_array_size(ndr, &r->attributes));
			_mem_save_attributes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attributes, 0);
			for (cntr_attributes_1 = 0; cntr_attributes_1 < r->num_attributes; cntr_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttribute(ndr, NDR_SCALARS, &r->attributes[cntr_attributes_1]));
			}
			for (cntr_attributes_1 = 0; cntr_attributes_1 < r->num_attributes; cntr_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttribute(ndr, NDR_BUFFERS, &r->attributes[cntr_attributes_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attributes_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attributes_0, 0);
		}
		if (r->attributes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->attributes, r->num_attributes));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttributeCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttributeCtr *r)
{
	uint32_t cntr_attributes_1;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttributeCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_attributes", r->num_attributes);
	ndr_print_ptr(ndr, "attributes", r->attributes);
	ndr->depth++;
	if (r->attributes) {
		ndr->print(ndr, "%s: ARRAY(%d)", "attributes", r->num_attributes);
		ndr->depth++;
		for (cntr_attributes_1=0;cntr_attributes_1<r->num_attributes;cntr_attributes_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_attributes_1);
			if (idx_1) {
				ndr_print_drsuapi_DsReplicaAttribute(ndr, "attributes", &r->attributes[cntr_attributes_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaObject(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObject *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->identifier));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaAttributeCtr(ndr, NDR_SCALARS, &r->attribute_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaAttributeCtr(ndr, NDR_BUFFERS, &r->attribute_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaObject(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObject *r)
{
	uint32_t _ptr_identifier;
	TALLOC_CTX *_mem_save_identifier_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_identifier));
		if (_ptr_identifier) {
			NDR_PULL_ALLOC(ndr, r->identifier);
		} else {
			r->identifier = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttributeCtr(ndr, NDR_SCALARS, &r->attribute_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			_mem_save_identifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->identifier, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_identifier_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttributeCtr(ndr, NDR_BUFFERS, &r->attribute_ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObject(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObject *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObject");
	ndr->depth++;
	ndr_print_ptr(ndr, "identifier", r->identifier);
	ndr->depth++;
	if (r->identifier) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "identifier", r->identifier);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_drsuapi_DsReplicaAttributeCtr(ndr, "attribute_ctr", &r->attribute_ctr);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaMetaData(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaMetaData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME_1sec(ndr, NDR_SCALARS, r->orginating_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->orginating_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->orginating_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->orginating_invocation_id));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaMetaData(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaMetaData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME_1sec(ndr, NDR_SCALARS, &r->orginating_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->orginating_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->orginating_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->orginating_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaMetaData(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaMetaData *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaMetaData");
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME_1sec(ndr, "orginating_time", r->orginating_time);
	ndr_print_GUID(ndr, "orginating_invocation_id", &r->orginating_invocation_id);
	ndr_print_hyper(ndr, "orginating_usn", r->orginating_usn);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaMetaDataCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaMetaDataCtr *r)
{
	uint32_t cntr_meta_data_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_meta_data_0 = 0; cntr_meta_data_0 < r->count; cntr_meta_data_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data[cntr_meta_data_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_meta_data_0 = 0; cntr_meta_data_0 < r->count; cntr_meta_data_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaData(ndr, NDR_BUFFERS, &r->meta_data[cntr_meta_data_0]));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaMetaDataCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaMetaDataCtr *r)
{
	uint32_t cntr_meta_data_0;
	TALLOC_CTX *_mem_save_meta_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->meta_data));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->meta_data, ndr_get_array_size(ndr, &r->meta_data));
		_mem_save_meta_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->meta_data, 0);
		for (cntr_meta_data_0 = 0; cntr_meta_data_0 < r->count; cntr_meta_data_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data[cntr_meta_data_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_meta_data_0, 0);
		if (r->meta_data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->meta_data, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_meta_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->meta_data, 0);
		for (cntr_meta_data_0 = 0; cntr_meta_data_0 < r->count; cntr_meta_data_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaData(ndr, NDR_BUFFERS, &r->meta_data[cntr_meta_data_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_meta_data_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaMetaDataCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaMetaDataCtr *r)
{
	uint32_t cntr_meta_data_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaMetaDataCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%d)", "meta_data", r->count);
	ndr->depth++;
	for (cntr_meta_data_0=0;cntr_meta_data_0<r->count;cntr_meta_data_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_meta_data_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaMetaData(ndr, "meta_data", &r->meta_data[cntr_meta_data_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaObjectListItemEx(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjectListItemEx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next_object));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->parent_object_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->meta_data_ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
		if (r->parent_object_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->parent_object_guid));
		}
		if (r->meta_data_ctr) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->meta_data_ctr));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaObjectListItemEx(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjectListItemEx *r)
{
	uint32_t _ptr_next_object;
	TALLOC_CTX *_mem_save_next_object_0;
	uint32_t _ptr_parent_object_guid;
	TALLOC_CTX *_mem_save_parent_object_guid_0;
	uint32_t _ptr_meta_data_ctr;
	TALLOC_CTX *_mem_save_meta_data_ctr_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next_object));
		if (_ptr_next_object) {
			NDR_PULL_ALLOC(ndr, r->next_object);
		} else {
			r->next_object = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_object_guid));
		if (_ptr_parent_object_guid) {
			NDR_PULL_ALLOC(ndr, r->parent_object_guid);
		} else {
			r->parent_object_guid = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_meta_data_ctr));
		if (_ptr_meta_data_ctr) {
			NDR_PULL_ALLOC(ndr, r->meta_data_ctr);
		} else {
			r->meta_data_ctr = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			_mem_save_next_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next_object, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_object_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
		if (r->parent_object_guid) {
			_mem_save_parent_object_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->parent_object_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->parent_object_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_object_guid_0, 0);
		}
		if (r->meta_data_ctr) {
			_mem_save_meta_data_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->meta_data_ctr, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->meta_data_ctr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_meta_data_ctr_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsGetNCChangesCtr1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesCtr1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsGetNCChangesCtr1(r, ndr->flags) + 55));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->first_object));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		if (r->naming_context) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		}
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCtr1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesCtr1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0;
	uint32_t _ptr_first_object;
	TALLOC_CTX *_mem_save_first_object_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_first_object));
		if (_ptr_first_object) {
			NDR_PULL_ALLOC(ndr, r->first_object);
		} else {
			r->first_object = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		if (r->naming_context) {
			_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		}
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			_mem_save_first_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->first_object, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_first_object_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr1");
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	if (r->naming_context) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "old_highwatermark", &r->old_highwatermark);
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "new_highwatermark", &r->new_highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr_print_uint32(ndr, "total_object_count", r->total_object_count);
	ndr_print_uint32(ndr, "object_count", r->object_count);
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsGetNCChangesCtr1(r, ndr->flags) + 55:r->__ndr_size);
	ndr_print_ptr(ndr, "first_object", r->first_object);
	ndr->depth++;
	if (r->first_object) {
		ndr_print_drsuapi_DsReplicaObjectListItemEx(ndr, "first_object", r->first_object);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsGetNCChangesCtr1(const struct drsuapi_DsGetNCChangesCtr1 *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr1);
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsLinkedAttributeFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsLinkedAttributeFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsLinkedAttributeFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_LINKED_ATTRIBUTE_FLAG_ACTIVE", DRSUAPI_DS_LINKED_ATTRIBUTE_FLAG_ACTIVE, r);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaLinkedAttribute(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaLinkedAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->identifier));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attid));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_push_drsuapi_DsLinkedAttributeFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_NTTIME_1sec(ndr, NDR_SCALARS, r->orginating_add_time));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
		}
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->value));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaData(ndr, NDR_BUFFERS, &r->meta_data));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaLinkedAttribute(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaLinkedAttribute *r)
{
	uint32_t _ptr_identifier;
	TALLOC_CTX *_mem_save_identifier_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_identifier));
		if (_ptr_identifier) {
			NDR_PULL_ALLOC(ndr, r->identifier);
		} else {
			r->identifier = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attid));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_drsuapi_DsLinkedAttributeFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_NTTIME_1sec(ndr, NDR_SCALARS, &r->orginating_add_time));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			_mem_save_identifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->identifier, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_identifier_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->value));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaData(ndr, NDR_BUFFERS, &r->meta_data));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaLinkedAttribute(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaLinkedAttribute *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaLinkedAttribute");
	ndr->depth++;
	ndr_print_ptr(ndr, "identifier", r->identifier);
	ndr->depth++;
	if (r->identifier) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "identifier", r->identifier);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsAttributeId(ndr, "attid", r->attid);
	ndr_print_drsuapi_DsAttributeValue(ndr, "value", &r->value);
	ndr_print_drsuapi_DsLinkedAttributeFlags(ndr, "flags", r->flags);
	ndr_print_NTTIME_1sec(ndr, "orginating_add_time", r->orginating_add_time);
	ndr_print_drsuapi_DsReplicaMetaData(ndr, "meta_data", &r->meta_data);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsGetNCChangesCtr6(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesCtr6 *r)
{
	uint32_t cntr_linked_attributes_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsGetNCChangesCtr6(r, ndr->flags) + 55));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->first_object));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->linked_attributes_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->linked_attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		if (r->naming_context) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		}
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2CtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
		}
		if (r->linked_attributes) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->linked_attributes_count));
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < r->linked_attributes_count; cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_SCALARS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < r->linked_attributes_count; cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_BUFFERS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCtr6(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesCtr6 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0;
	uint32_t _ptr_first_object;
	TALLOC_CTX *_mem_save_first_object_0;
	uint32_t _ptr_linked_attributes;
	uint32_t cntr_linked_attributes_1;
	TALLOC_CTX *_mem_save_linked_attributes_0;
	TALLOC_CTX *_mem_save_linked_attributes_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_first_object));
		if (_ptr_first_object) {
			NDR_PULL_ALLOC(ndr, r->first_object);
		} else {
			r->first_object = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->linked_attributes_count));
		if (r->linked_attributes_count < 0 || r->linked_attributes_count > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_linked_attributes));
		if (_ptr_linked_attributes) {
			NDR_PULL_ALLOC(ndr, r->linked_attributes);
		} else {
			r->linked_attributes = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		if (r->naming_context) {
			_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		}
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2CtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			_mem_save_first_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->first_object, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_first_object_0, 0);
		}
		if (r->linked_attributes) {
			_mem_save_linked_attributes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->linked_attributes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->linked_attributes));
			NDR_PULL_ALLOC_N(ndr, r->linked_attributes, ndr_get_array_size(ndr, &r->linked_attributes));
			_mem_save_linked_attributes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->linked_attributes, 0);
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < r->linked_attributes_count; cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_SCALARS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < r->linked_attributes_count; cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_BUFFERS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_linked_attributes_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_linked_attributes_0, 0);
		}
		if (r->linked_attributes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->linked_attributes, r->linked_attributes_count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr6(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr6 *r)
{
	uint32_t cntr_linked_attributes_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr6");
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	if (r->naming_context) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "old_highwatermark", &r->old_highwatermark);
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "new_highwatermark", &r->new_highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursor2CtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr_print_uint32(ndr, "total_object_count", r->total_object_count);
	ndr_print_uint32(ndr, "object_count", r->object_count);
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsGetNCChangesCtr6(r, ndr->flags) + 55:r->__ndr_size);
	ndr_print_ptr(ndr, "first_object", r->first_object);
	ndr->depth++;
	if (r->first_object) {
		ndr_print_drsuapi_DsReplicaObjectListItemEx(ndr, "first_object", r->first_object);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "linked_attributes_count", r->linked_attributes_count);
	ndr_print_ptr(ndr, "linked_attributes", r->linked_attributes);
	ndr->depth++;
	if (r->linked_attributes) {
		ndr->print(ndr, "%s: ARRAY(%d)", "linked_attributes", r->linked_attributes_count);
		ndr->depth++;
		for (cntr_linked_attributes_1=0;cntr_linked_attributes_1<r->linked_attributes_count;cntr_linked_attributes_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_linked_attributes_1);
			if (idx_1) {
				ndr_print_drsuapi_DsReplicaLinkedAttribute(ndr, "linked_attributes", &r->linked_attributes[cntr_linked_attributes_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsGetNCChangesCtr6(const struct drsuapi_DsGetNCChangesCtr6 *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr6);
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesMSZIPCtr1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->decompressed_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->compressed_length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ctr1) {
			{
				struct ndr_push *_ndr_ctr1;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_ctr1, 4, r->compressed_length));
				{
					struct ndr_push *_ndr_ctr1_compressed;
					NDR_CHECK(ndr_push_compression_start(_ndr_ctr1, &_ndr_ctr1_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr1(_ndr_ctr1_compressed, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_CHECK(ndr_push_compression_end(_ndr_ctr1, _ndr_ctr1_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
				}
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_ctr1, 4, r->compressed_length));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesMSZIPCtr1 *r)
{
	uint32_t _ptr_ctr1;
	TALLOC_CTX *_mem_save_ctr1_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
		if (_ptr_ctr1) {
			NDR_PULL_ALLOC(ndr, r->ctr1);
		} else {
			r->ctr1 = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ctr1) {
			_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
			{
				struct ndr_pull *_ndr_ctr1;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ctr1, 4, r->compressed_length));
				{
					struct ndr_pull *_ndr_ctr1_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_ctr1, &_ndr_ctr1_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1(_ndr_ctr1_compressed, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_CHECK(ndr_pull_compression_end(_ndr_ctr1, _ndr_ctr1_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ctr1, 4, r->compressed_length));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesMSZIPCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesMSZIPCtr1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesMSZIPCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "ctr1", r->ctr1);
	ndr->depth++;
	if (r->ctr1) {
		ndr_print_drsuapi_DsGetNCChangesCtr1(ndr, "ctr1", r->ctr1);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesMSZIPCtr6(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesMSZIPCtr6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->decompressed_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->compressed_length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr6));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ctr6) {
			{
				struct ndr_push *_ndr_ctr6;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_ctr6, 4, r->compressed_length));
				{
					struct ndr_push *_ndr_ctr6_compressed;
					NDR_CHECK(ndr_push_compression_start(_ndr_ctr6, &_ndr_ctr6_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr6(_ndr_ctr6_compressed, NDR_SCALARS|NDR_BUFFERS, r->ctr6));
					NDR_CHECK(ndr_push_compression_end(_ndr_ctr6, _ndr_ctr6_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
				}
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_ctr6, 4, r->compressed_length));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr6(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesMSZIPCtr6 *r)
{
	uint32_t _ptr_ctr6;
	TALLOC_CTX *_mem_save_ctr6_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr6));
		if (_ptr_ctr6) {
			NDR_PULL_ALLOC(ndr, r->ctr6);
		} else {
			r->ctr6 = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ctr6) {
			_mem_save_ctr6_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ctr6, 0);
			{
				struct ndr_pull *_ndr_ctr6;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ctr6, 4, r->compressed_length));
				{
					struct ndr_pull *_ndr_ctr6_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_ctr6, &_ndr_ctr6_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6(_ndr_ctr6_compressed, NDR_SCALARS|NDR_BUFFERS, r->ctr6));
					NDR_CHECK(ndr_pull_compression_end(_ndr_ctr6, _ndr_ctr6_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ctr6, 4, r->compressed_length));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr6_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesMSZIPCtr6(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesMSZIPCtr6 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesMSZIPCtr6");
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "ctr6", r->ctr6);
	ndr->depth++;
	if (r->ctr6) {
		ndr_print_drsuapi_DsGetNCChangesCtr6(ndr, "ctr6", r->ctr6);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesXPRESSCtr1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesXPRESSCtr1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->decompressed_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->compressed_length));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->decompressed));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			if (r->decompressed) {
				{
					struct ndr_push *_ndr_decompressed;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_decompressed, 4, r->compressed_length));
					{
						struct ndr_push *_ndr_decompressed_compressed;
						NDR_CHECK(ndr_push_compression_start(_ndr_decompressed, &_ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
						NDR_CHECK(ndr_push_DATA_BLOB(_ndr_decompressed_compressed, NDR_SCALARS, *r->decompressed));
						NDR_CHECK(ndr_push_compression_end(_ndr_decompressed, _ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
					}
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_decompressed, 4, r->compressed_length));
				}
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesXPRESSCtr1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesXPRESSCtr1 *r)
{
	uint32_t _ptr_decompressed;
	TALLOC_CTX *_mem_save_decompressed_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_decompressed));
			if (_ptr_decompressed) {
				NDR_PULL_ALLOC(ndr, r->decompressed);
			} else {
				r->decompressed = NULL;
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			if (r->decompressed) {
				_mem_save_decompressed_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->decompressed, 0);
				{
					struct ndr_pull *_ndr_decompressed;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_decompressed, 4, r->compressed_length));
					{
						struct ndr_pull *_ndr_decompressed_compressed;
						NDR_CHECK(ndr_pull_compression_start(_ndr_decompressed, &_ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
						NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_decompressed_compressed, NDR_SCALARS, r->decompressed));
						NDR_CHECK(ndr_pull_compression_end(_ndr_decompressed, _ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
					}
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_decompressed, 4, r->compressed_length));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_decompressed_0, 0);
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesXPRESSCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesXPRESSCtr1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesXPRESSCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "decompressed", r->decompressed);
	ndr->depth++;
	if (r->decompressed) {
		ndr_print_DATA_BLOB(ndr, "decompressed", *r->decompressed);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesXPRESSCtr6(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesXPRESSCtr6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->decompressed_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->compressed_length));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->decompressed));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			if (r->decompressed) {
				{
					struct ndr_push *_ndr_decompressed;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_decompressed, 4, r->compressed_length));
					{
						struct ndr_push *_ndr_decompressed_compressed;
						NDR_CHECK(ndr_push_compression_start(_ndr_decompressed, &_ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
						NDR_CHECK(ndr_push_DATA_BLOB(_ndr_decompressed_compressed, NDR_SCALARS, *r->decompressed));
						NDR_CHECK(ndr_push_compression_end(_ndr_decompressed, _ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
					}
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_decompressed, 4, r->compressed_length));
				}
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesXPRESSCtr6(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesXPRESSCtr6 *r)
{
	uint32_t _ptr_decompressed;
	TALLOC_CTX *_mem_save_decompressed_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_decompressed));
			if (_ptr_decompressed) {
				NDR_PULL_ALLOC(ndr, r->decompressed);
			} else {
				r->decompressed = NULL;
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			if (r->decompressed) {
				_mem_save_decompressed_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->decompressed, 0);
				{
					struct ndr_pull *_ndr_decompressed;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_decompressed, 4, r->compressed_length));
					{
						struct ndr_pull *_ndr_decompressed_compressed;
						NDR_CHECK(ndr_pull_compression_start(_ndr_decompressed, &_ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
						NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_decompressed_compressed, NDR_SCALARS, r->decompressed));
						NDR_CHECK(ndr_pull_compression_end(_ndr_decompressed, _ndr_decompressed_compressed, NDR_COMPRESSION_XPRESS, r->decompressed_length));
					}
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_decompressed, 4, r->compressed_length));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_decompressed_0, 0);
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesXPRESSCtr6(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesXPRESSCtr6 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesXPRESSCtr6");
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "decompressed", r->decompressed);
	ndr->depth++;
	if (r->decompressed) {
		ndr_print_DATA_BLOB(ndr, "decompressed", *r->decompressed);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesCompressionType(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsGetNCChangesCompressionType r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCompressionType(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsGetNCChangesCompressionType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCompressionType(struct ndr_print *ndr, const char *name, enum drsuapi_DsGetNCChangesCompressionType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_COMPRESSION_TYPE_MSZIP: val = "DRSUAPI_COMPRESSION_TYPE_MSZIP"; break;
		case DRSUAPI_COMPRESSION_TYPE_XPRESS: val = "DRSUAPI_COMPRESSION_TYPE_XPRESS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesCompressedCtr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		level = ndr_push_get_switch_value(ndr, r);
		if (ndr_flags & NDR_SCALARS) {
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_SCALARS, &r->mszip1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_SCALARS, &r->mszip6));
				break;

				case 1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesXPRESSCtr1(ndr, NDR_SCALARS, &r->xpress1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesXPRESSCtr6(ndr, NDR_SCALARS, &r->xpress6));
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_BUFFERS, &r->mszip1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_BUFFERS, &r->mszip6));
				break;

				case 1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesXPRESSCtr1(ndr, NDR_BUFFERS, &r->xpress1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesXPRESSCtr6(ndr, NDR_BUFFERS, &r->xpress6));
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		level = ndr_pull_get_switch_value(ndr, r);
		if (ndr_flags & NDR_SCALARS) {
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_SCALARS, &r->mszip1));
				break; }

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_SCALARS, &r->mszip6));
				break; }

				case 1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesXPRESSCtr1(ndr, NDR_SCALARS, &r->xpress1));
				break; }

				case 6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesXPRESSCtr6(ndr, NDR_SCALARS, &r->xpress6));
				break; }

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_BUFFERS, &r->mszip1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_BUFFERS, &r->mszip6));
				break;

				case 1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesXPRESSCtr1(ndr, NDR_BUFFERS, &r->xpress1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesXPRESSCtr6(ndr, NDR_BUFFERS, &r->xpress6));
				break;

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCompressedCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		level = ndr_print_get_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "drsuapi_DsGetNCChangesCompressedCtr");
		switch (level) {
			case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
				ndr_print_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, "mszip1", &r->mszip1);
			break;

			case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
				ndr_print_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, "mszip6", &r->mszip6);
			break;

			case 1|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
				ndr_print_drsuapi_DsGetNCChangesXPRESSCtr1(ndr, "xpress1", &r->xpress1);
			break;

			case 6|(DRSUAPI_COMPRESSION_TYPE_XPRESS<<16):
				ndr_print_drsuapi_DsGetNCChangesXPRESSCtr6(ndr, "xpress6", &r->xpress6);
			break;

			default:
				ndr_print_bad_level(ndr, name, level);
		}
		ndr->flags = _flags_save_UNION;
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesCtr2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesCtr2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, 1 | (DRSUAPI_COMPRESSION_TYPE_MSZIP << 16)));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_SCALARS, &r->ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCtr2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesCtr2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, 1 | (DRSUAPI_COMPRESSION_TYPE_MSZIP << 16)));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_SCALARS, &r->ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr2");
	ndr->depth++;
	ndr_print_set_switch_value(ndr, &r->ctr, 1 | (DRSUAPI_COMPRESSION_TYPE_MSZIP << 16));
	ndr_print_drsuapi_DsGetNCChangesCompressedCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesCtr7(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNCChangesCtr7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressionType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16)));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_SCALARS, &r->ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCtr7(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNCChangesCtr7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->level));
		if (r->level < 0 || r->level > 6) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressionType(ndr, NDR_SCALARS, &r->type));
		if (r->type < 2 || r->type > 3) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16)));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_SCALARS, &r->ctr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr7(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr7 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr7");
	ndr->depth++;
	ndr_print_int32(ndr, "level", r->level);
	ndr_print_drsuapi_DsGetNCChangesCompressionType(ndr, "type", r->type);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16));
	ndr_print_drsuapi_DsGetNCChangesCompressedCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChangesCtr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetNCChangesCtr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break;

			case 6:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr6(ndr, NDR_SCALARS, &r->ctr6));
			break;

			case 7:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr7(ndr, NDR_SCALARS, &r->ctr7));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 6:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr6(ndr, NDR_BUFFERS, &r->ctr6));
			break;

			case 7:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr7(ndr, NDR_BUFFERS, &r->ctr7));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChangesCtr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetNCChangesCtr *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetNCChangesCtr", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6(ndr, NDR_SCALARS, &r->ctr6));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr7(ndr, NDR_SCALARS, &r->ctr7));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 6:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6(ndr, NDR_BUFFERS, &r->ctr6));
			break;

			case 7:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr7(ndr, NDR_BUFFERS, &r->ctr7));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNCChangesCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNCChangesCtr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetNCChangesCtr1(ndr, "ctr1", &r->ctr1);
		break;

		case 2:
			ndr_print_drsuapi_DsGetNCChangesCtr2(ndr, "ctr2", &r->ctr2);
		break;

		case 6:
			ndr_print_drsuapi_DsGetNCChangesCtr6(ndr, "ctr6", &r->ctr6);
		break;

		case 7:
			ndr_print_drsuapi_DsGetNCChangesCtr7(ndr, "ctr7", &r->ctr7);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsReplicaUpdateRefsOptions(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaUpdateRefsOptions(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefsOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION", DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE", DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE", DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE", DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_UPDATE_0x00000010", DRSUAPI_DS_REPLICA_UPDATE_0x00000010, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaUpdateRefsRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		if (r->naming_context == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		if (r->dest_dsa_dns_name == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->dest_dsa_guid));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsOptions(ndr, NDR_SCALARS, r->options));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dest_dsa_dns_name, CH_DOS)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dest_dsa_dns_name, CH_DOS)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dest_dsa_dns_name, ndr_charset_length(r->dest_dsa_dns_name, CH_DOS), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->dest_dsa_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaUpdateRefsRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0;
	uint32_t _ptr_dest_dsa_dns_name;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		}
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_dest_dsa_dns_name));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->dest_dsa_guid));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsOptions(ndr, NDR_SCALARS, &r->options));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->dest_dsa_dns_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->dest_dsa_dns_name));
		if (ndr_get_array_length(ndr, &r->dest_dsa_dns_name) > ndr_get_array_size(ndr, &r->dest_dsa_dns_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->dest_dsa_dns_name), ndr_get_array_length(ndr, &r->dest_dsa_dns_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->dest_dsa_dns_name), sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dest_dsa_dns_name, ndr_get_array_length(ndr, &r->dest_dsa_dns_name), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->dest_dsa_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefsRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaUpdateRefsRequest1");
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_ptr(ndr, "dest_dsa_dns_name", r->dest_dsa_dns_name);
	ndr->depth++;
	ndr_print_string(ndr, "dest_dsa_dns_name", r->dest_dsa_dns_name);
	ndr->depth--;
	ndr_print_GUID(ndr, "dest_dsa_guid", &r->dest_dsa_guid);
	ndr_print_drsuapi_DsReplicaUpdateRefsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaUpdateRefsRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaUpdateRefsRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsReplicaUpdateRefsRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefsRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaUpdateRefsRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaUpdateRefsRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsReplicaAddOptions(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaAddOptions(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAddOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION", DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_ADD_WRITEABLE", DRSUAPI_DS_REPLICA_ADD_WRITEABLE, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaDeleteOptions(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaDeleteOptions(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaDeleteOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION", DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_DELETE_WRITEABLE", DRSUAPI_DS_REPLICA_DELETE_WRITEABLE, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaModifyOptions(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaModifyOptions(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaModifyOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION", DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE", DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE, r);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsMembershipType(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsMembershipType r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsMembershipType(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsMembershipType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsMembershipType(struct ndr_print *ndr, const char *name, enum drsuapi_DsMembershipType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsGetMembershipsCtr1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetMembershipsCtr1 *r)
{
	uint32_t cntr_info_array_1;
	uint32_t cntr_group_attrs_1;
	uint32_t cntr_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_memberships));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->group_attrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_memberships));
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->num_memberships; cntr_info_array_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array[cntr_info_array_1]));
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->num_memberships; cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
				}
			}
		}
		if (r->group_attrs) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_memberships));
			for (cntr_group_attrs_1 = 0; cntr_group_attrs_1 < r->num_memberships; cntr_group_attrs_1++) {
				NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->group_attrs[cntr_group_attrs_1]));
			}
		}
		if (r->sids) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				if (r->sids[cntr_sids_1]) {
					NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS|NDR_BUFFERS, r->sids[cntr_sids_1]));
				}
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMembershipsCtr1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetMembershipsCtr1 *r)
{
	uint32_t _ptr_info_array;
	uint32_t cntr_info_array_1;
	TALLOC_CTX *_mem_save_info_array_0;
	TALLOC_CTX *_mem_save_info_array_1;
	TALLOC_CTX *_mem_save_info_array_2;
	uint32_t _ptr_group_attrs;
	uint32_t cntr_group_attrs_1;
	TALLOC_CTX *_mem_save_group_attrs_0;
	TALLOC_CTX *_mem_save_group_attrs_1;
	uint32_t _ptr_sids;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	TALLOC_CTX *_mem_save_sids_2;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_memberships));
		if (r->num_memberships < 0 || r->num_memberships > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		if (r->num_sids < 0 || r->num_sids > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
		if (_ptr_info_array) {
			NDR_PULL_ALLOC(ndr, r->info_array);
		} else {
			r->info_array = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_attrs));
		if (_ptr_group_attrs) {
			NDR_PULL_ALLOC(ndr, r->group_attrs);
		} else {
			r->group_attrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			_mem_save_info_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->info_array));
			NDR_PULL_ALLOC_N(ndr, r->info_array, ndr_get_array_size(ndr, &r->info_array));
			_mem_save_info_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->num_memberships; cntr_info_array_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
				if (_ptr_info_array) {
					NDR_PULL_ALLOC(ndr, r->info_array[cntr_info_array_1]);
				} else {
					r->info_array[cntr_info_array_1] = NULL;
				}
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->num_memberships; cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					_mem_save_info_array_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info_array[cntr_info_array_1], 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_0, 0);
		}
		if (r->group_attrs) {
			_mem_save_group_attrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->group_attrs, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->group_attrs));
			NDR_PULL_ALLOC_N(ndr, r->group_attrs, ndr_get_array_size(ndr, &r->group_attrs));
			_mem_save_group_attrs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->group_attrs, 0);
			for (cntr_group_attrs_1 = 0; cntr_group_attrs_1 < r->num_memberships; cntr_group_attrs_1++) {
				NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->group_attrs[cntr_group_attrs_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_attrs_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_attrs_0, 0);
		}
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_PULL_ALLOC_N(ndr, r->sids, ndr_get_array_size(ndr, &r->sids));
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
				if (_ptr_sids) {
					NDR_PULL_ALLOC(ndr, r->sids[cntr_sids_1]);
				} else {
					r->sids[cntr_sids_1] = NULL;
				}
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->num_sids; cntr_sids_1++) {
				if (r->sids[cntr_sids_1]) {
					_mem_save_sids_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sids[cntr_sids_1], 0);
					NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS|NDR_BUFFERS, r->sids[cntr_sids_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->info_array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->info_array, r->num_memberships));
		}
		if (r->group_attrs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->group_attrs, r->num_memberships));
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetMembershipsCtr1 *r)
{
	uint32_t cntr_info_array_1;
	uint32_t cntr_group_attrs_1;
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetMembershipsCtr1");
	ndr->depth++;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_uint32(ndr, "num_memberships", r->num_memberships);
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr_print_ptr(ndr, "info_array", r->info_array);
	ndr->depth++;
	if (r->info_array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "info_array", r->num_memberships);
		ndr->depth++;
		for (cntr_info_array_1=0;cntr_info_array_1<r->num_memberships;cntr_info_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_info_array_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "info_array", r->info_array[cntr_info_array_1]);
				ndr->depth++;
				if (r->info_array[cntr_info_array_1]) {
					ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "info_array", r->info_array[cntr_info_array_1]);
				}
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "group_attrs", r->group_attrs);
	ndr->depth++;
	if (r->group_attrs) {
		ndr->print(ndr, "%s: ARRAY(%d)", "group_attrs", r->num_memberships);
		ndr->depth++;
		for (cntr_group_attrs_1=0;cntr_group_attrs_1<r->num_memberships;cntr_group_attrs_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_group_attrs_1);
			if (idx_1) {
				ndr_print_samr_GroupAttrs(ndr, "group_attrs", r->group_attrs[cntr_group_attrs_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", r->num_sids);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->num_sids;cntr_sids_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_sids_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "sids", r->sids[cntr_sids_1]);
				ndr->depth++;
				if (r->sids[cntr_sids_1]) {
					ndr_print_dom_sid28(ndr, "sids", r->sids[cntr_sids_1]);
				}
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetMembershipsCtr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetMembershipsCtr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMembershipsCtr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetMembershipsCtr *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetMembershipsCtr", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMembershipsCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMembershipsCtr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMembershipsCtr1(ndr, "ctr1", &r->ctr1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetMembershipsRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetMembershipsRequest1 *r)
{
	uint32_t cntr_info_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_drsuapi_DsMembershipType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->count; cntr_info_array_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array[cntr_info_array_1]));
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->count; cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
				}
			}
		}
		if (r->domain) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMembershipsRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetMembershipsRequest1 *r)
{
	uint32_t _ptr_info_array;
	uint32_t cntr_info_array_1;
	TALLOC_CTX *_mem_save_info_array_0;
	TALLOC_CTX *_mem_save_info_array_1;
	TALLOC_CTX *_mem_save_info_array_2;
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 1 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
		if (_ptr_info_array) {
			NDR_PULL_ALLOC(ndr, r->info_array);
		} else {
			r->info_array = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_drsuapi_DsMembershipType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			_mem_save_info_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->info_array));
			NDR_PULL_ALLOC_N(ndr, r->info_array, ndr_get_array_size(ndr, &r->info_array));
			_mem_save_info_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->count; cntr_info_array_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
				if (_ptr_info_array) {
					NDR_PULL_ALLOC(ndr, r->info_array[cntr_info_array_1]);
				} else {
					r->info_array[cntr_info_array_1] = NULL;
				}
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < r->count; cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					_mem_save_info_array_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info_array[cntr_info_array_1], 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_0, 0);
		}
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		if (r->info_array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->info_array, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetMembershipsRequest1 *r)
{
	uint32_t cntr_info_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetMembershipsRequest1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "info_array", r->info_array);
	ndr->depth++;
	if (r->info_array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "info_array", r->count);
		ndr->depth++;
		for (cntr_info_array_1=0;cntr_info_array_1<r->count;cntr_info_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_info_array_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "info_array", r->info_array[cntr_info_array_1]);
				ndr->depth++;
				if (r->info_array[cntr_info_array_1]) {
					ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "info_array", r->info_array[cntr_info_array_1]);
				}
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_drsuapi_DsMembershipType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetMembershipsRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetMembershipsRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMembershipsRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetMembershipsRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetMembershipsRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMembershipsRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMembershipsRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMembershipsRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetNT4ChangeLogRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNT4ChangeLogRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		if (r->length < 0 || r->length > 0x00A00000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			NDR_PULL_ALLOC_N(ndr, r->data, ndr_get_array_size(ndr, &r->data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, ndr_get_array_size(ndr, &r->data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->length));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNT4ChangeLogRequest1");
	ndr->depth++;
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_array_uint8(ndr, "data", r->data, r->length);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNT4ChangeLogRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNT4ChangeLogRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetNT4ChangeLogRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNT4ChangeLogRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetNT4ChangeLogRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetNT4ChangeLogInfo1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length2));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->time2));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unknown3));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->time4));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->time6));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data2));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data1) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data1, r->length1));
		}
		if (r->data2) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length2));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data2, r->length2));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNT4ChangeLogInfo1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	uint32_t _ptr_data1;
	TALLOC_CTX *_mem_save_data1_0;
	uint32_t _ptr_data2;
	TALLOC_CTX *_mem_save_data2_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length1));
		if (r->length1 < 0 || r->length1 > 0x00A00000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length2));
		if (r->length2 < 0 || r->length2 > 0x00A00000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->time2));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->time4));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->time6));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data1));
		if (_ptr_data1) {
			NDR_PULL_ALLOC(ndr, r->data1);
		} else {
			r->data1 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data2));
		if (_ptr_data2) {
			NDR_PULL_ALLOC(ndr, r->data2);
		} else {
			r->data2 = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data1) {
			_mem_save_data1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data1));
			NDR_PULL_ALLOC_N(ndr, r->data1, ndr_get_array_size(ndr, &r->data1));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data1, ndr_get_array_size(ndr, &r->data1)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data1_0, 0);
		}
		if (r->data2) {
			_mem_save_data2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data2, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data2));
			NDR_PULL_ALLOC_N(ndr, r->data2, ndr_get_array_size(ndr, &r->data2));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data2, ndr_get_array_size(ndr, &r->data2)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data2_0, 0);
		}
		if (r->data1) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data1, r->length1));
		}
		if (r->data2) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data2, r->length2));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNT4ChangeLogInfo1");
	ndr->depth++;
	ndr_print_uint32(ndr, "length1", r->length1);
	ndr_print_uint32(ndr, "length2", r->length2);
	ndr_print_hyper(ndr, "unknown1", r->unknown1);
	ndr_print_NTTIME(ndr, "time2", r->time2);
	ndr_print_hyper(ndr, "unknown3", r->unknown3);
	ndr_print_NTTIME(ndr, "time4", r->time4);
	ndr_print_hyper(ndr, "unknown5", r->unknown5);
	ndr_print_NTTIME(ndr, "time6", r->time6);
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_ptr(ndr, "data1", r->data1);
	ndr->depth++;
	if (r->data1) {
		ndr_print_array_uint8(ndr, "data1", r->data1, r->length1);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data2", r->data2);
	ndr->depth++;
	if (r->data2) {
		ndr_print_array_uint8(ndr, "data2", r->data2, r->length2);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNT4ChangeLogInfo(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_SCALARS, &r->info1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNT4ChangeLogInfo(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetNT4ChangeLogInfo", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNT4ChangeLogInfo");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetNT4ChangeLogInfo1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsNameStatus(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsNameStatus r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameStatus(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsNameStatus *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameStatus(struct ndr_print *ndr, const char *name, enum drsuapi_DsNameStatus r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_NAME_STATUS_OK: val = "DRSUAPI_DS_NAME_STATUS_OK"; break;
		case DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR: val = "DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR"; break;
		case DRSUAPI_DS_NAME_STATUS_NOT_FOUND: val = "DRSUAPI_DS_NAME_STATUS_NOT_FOUND"; break;
		case DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE: val = "DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE"; break;
		case DRSUAPI_DS_NAME_STATUS_NO_MAPPING: val = "DRSUAPI_DS_NAME_STATUS_NO_MAPPING"; break;
		case DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY: val = "DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY"; break;
		case DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING: val = "DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING"; break;
		case DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL: val = "DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsNameFlags(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsNameFlags r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameFlags(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsNameFlags *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameFlags(struct ndr_print *ndr, const char *name, enum drsuapi_DsNameFlags r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_NAME_FLAG_NO_FLAGS: val = "DRSUAPI_DS_NAME_FLAG_NO_FLAGS"; break;
		case DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY: val = "DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY"; break;
		case DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC: val = "DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC"; break;
		case DRSUAPI_DS_NAME_FLAG_GCVERIFY: val = "DRSUAPI_DS_NAME_FLAG_GCVERIFY"; break;
		case DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL: val = "DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsNameFormat(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsNameFormat r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameFormat(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsNameFormat *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameFormat(struct ndr_print *ndr, const char *name, enum drsuapi_DsNameFormat r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_NAME_FORMAT_UKNOWN: val = "DRSUAPI_DS_NAME_FORMAT_UKNOWN"; break;
		case DRSUAPI_DS_NAME_FORMAT_FQDN_1779: val = "DRSUAPI_DS_NAME_FORMAT_FQDN_1779"; break;
		case DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT: val = "DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT"; break;
		case DRSUAPI_DS_NAME_FORMAT_DISPLAY: val = "DRSUAPI_DS_NAME_FORMAT_DISPLAY"; break;
		case DRSUAPI_DS_NAME_FORMAT_GUID: val = "DRSUAPI_DS_NAME_FORMAT_GUID"; break;
		case DRSUAPI_DS_NAME_FORMAT_CANONICAL: val = "DRSUAPI_DS_NAME_FORMAT_CANONICAL"; break;
		case DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL: val = "DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL"; break;
		case DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX: val = "DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX"; break;
		case DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL: val = "DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL"; break;
		case DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY: val = "DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY"; break;
		case DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN: val = "DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsNameString(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsNameString *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->str));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->str, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->str, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->str, ndr_charset_length(r->str, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameString(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsNameString *r)
{
	uint32_t _ptr_str;
	TALLOC_CTX *_mem_save_str_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_str));
		if (_ptr_str) {
			NDR_PULL_ALLOC(ndr, r->str);
		} else {
			r->str = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str) {
			_mem_save_str_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->str, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->str));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->str));
			if (ndr_get_array_length(ndr, &r->str) > ndr_get_array_size(ndr, &r->str)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->str), ndr_get_array_length(ndr, &r->str));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->str), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->str, ndr_get_array_length(ndr, &r->str), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_str_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameString(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameString *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsNameString");
	ndr->depth++;
	ndr_print_ptr(ndr, "str", r->str);
	ndr->depth++;
	if (r->str) {
		ndr_print_string(ndr, "str", r->str);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsNameRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsNameRequest1 *r)
{
	uint32_t cntr_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->codepage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->language));
		NDR_CHECK(ndr_push_drsuapi_DsNameFlags(ndr, NDR_SCALARS, r->format_flags));
		NDR_CHECK(ndr_push_drsuapi_DsNameFormat(ndr, NDR_SCALARS, r->format_offered));
		NDR_CHECK(ndr_push_drsuapi_DsNameFormat(ndr, NDR_SCALARS, r->format_desired));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsNameRequest1 *r)
{
	uint32_t _ptr_names;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->codepage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->language));
		NDR_CHECK(ndr_pull_drsuapi_DsNameFlags(ndr, NDR_SCALARS, &r->format_flags));
		NDR_CHECK(ndr_pull_drsuapi_DsNameFormat(ndr, NDR_SCALARS, &r->format_offered));
		NDR_CHECK(ndr_pull_drsuapi_DsNameFormat(ndr, NDR_SCALARS, &r->format_desired));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 1 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_PULL_ALLOC_N(ndr, r->names, ndr_get_array_size(ndr, &r->names));
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameRequest1 *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "drsuapi_DsNameRequest1");
	ndr->depth++;
	ndr_print_uint32(ndr, "codepage", r->codepage);
	ndr_print_uint32(ndr, "language", r->language);
	ndr_print_drsuapi_DsNameFlags(ndr, "format_flags", r->format_flags);
	ndr_print_drsuapi_DsNameFormat(ndr, "format_offered", r->format_offered);
	ndr_print_drsuapi_DsNameFormat(ndr, "format_desired", r->format_desired);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "names", r->count);
		ndr->depth++;
		for (cntr_names_1=0;cntr_names_1<r->count;cntr_names_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_names_1);
			if (idx_1) {
				ndr_print_drsuapi_DsNameString(ndr, "names", &r->names[cntr_names_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsNameRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsNameRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsNameRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsNameRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsNameRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsNameRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsNameRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsNameRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsNameRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsNameRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsNameRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsNameInfo1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsNameInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsNameStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->result_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dns_domain_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_domain_name, ndr_charset_length(r->dns_domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->result_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->result_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->result_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->result_name, ndr_charset_length(r->result_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameInfo1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsNameInfo1 *r)
{
	uint32_t _ptr_dns_domain_name;
	TALLOC_CTX *_mem_save_dns_domain_name_0;
	uint32_t _ptr_result_name;
	TALLOC_CTX *_mem_save_result_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsNameStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_domain_name));
		if (_ptr_dns_domain_name) {
			NDR_PULL_ALLOC(ndr, r->dns_domain_name);
		} else {
			r->dns_domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_result_name));
		if (_ptr_result_name) {
			NDR_PULL_ALLOC(ndr, r->result_name);
		} else {
			r->result_name = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dns_domain_name) {
			_mem_save_dns_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_domain_name));
			if (ndr_get_array_length(ndr, &r->dns_domain_name) > ndr_get_array_size(ndr, &r->dns_domain_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->dns_domain_name), ndr_get_array_length(ndr, &r->dns_domain_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->dns_domain_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_domain_name, ndr_get_array_length(ndr, &r->dns_domain_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_domain_name_0, 0);
		}
		if (r->result_name) {
			_mem_save_result_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->result_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->result_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->result_name));
			if (ndr_get_array_length(ndr, &r->result_name) > ndr_get_array_size(ndr, &r->result_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->result_name), ndr_get_array_length(ndr, &r->result_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->result_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->result_name, ndr_get_array_length(ndr, &r->result_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_result_name_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsNameInfo1");
	ndr->depth++;
	ndr_print_drsuapi_DsNameStatus(ndr, "status", r->status);
	ndr_print_ptr(ndr, "dns_domain_name", r->dns_domain_name);
	ndr->depth++;
	if (r->dns_domain_name) {
		ndr_print_string(ndr, "dns_domain_name", r->dns_domain_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "result_name", r->result_name);
	ndr->depth++;
	if (r->result_name) {
		ndr_print_string(ndr, "result_name", r->result_name);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsNameCtr1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsNameCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameCtr1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsNameCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsNameCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_array_1);
			if (idx_1) {
				ndr_print_drsuapi_DsNameInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsNameCtr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsNameCtr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_drsuapi_DsNameCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsNameCtr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsNameCtr *r)
{
	int level;
	int32_t _level;
	TALLOC_CTX *_mem_save_ctr1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsNameCtr", _level);
		}
		switch (level) {
			case 1: {
				uint32_t _ptr_ctr1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsNameCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsNameCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsNameCtr");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_drsuapi_DsNameCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsSpnOperation(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsSpnOperation r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsSpnOperation(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsSpnOperation *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsSpnOperation(struct ndr_print *ndr, const char *name, enum drsuapi_DsSpnOperation r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_SPN_OPERATION_ADD: val = "DRSUAPI_DS_SPN_OPERATION_ADD"; break;
		case DRSUAPI_DS_SPN_OPERATION_REPLACE: val = "DRSUAPI_DS_SPN_OPERATION_REPLACE"; break;
		case DRSUAPI_DS_SPN_OPERATION_DELETE: val = "DRSUAPI_DS_SPN_OPERATION_DELETE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsWriteAccountSpnRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	uint32_t cntr_spn_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsSpnOperation(ndr, NDR_SCALARS, r->operation));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->spn_names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->spn_names) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < r->count; cntr_spn_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->spn_names[cntr_spn_names_1]));
			}
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < r->count; cntr_spn_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->spn_names[cntr_spn_names_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsWriteAccountSpnRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	uint32_t _ptr_object_dn;
	TALLOC_CTX *_mem_save_object_dn_0;
	uint32_t _ptr_spn_names;
	uint32_t cntr_spn_names_1;
	TALLOC_CTX *_mem_save_spn_names_0;
	TALLOC_CTX *_mem_save_spn_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsSpnOperation(ndr, NDR_SCALARS, &r->operation));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_spn_names));
		if (_ptr_spn_names) {
			NDR_PULL_ALLOC(ndr, r->spn_names);
		} else {
			r->spn_names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			if (ndr_get_array_length(ndr, &r->object_dn) > ndr_get_array_size(ndr, &r->object_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->object_dn), ndr_get_array_length(ndr, &r->object_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->spn_names) {
			_mem_save_spn_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->spn_names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->spn_names));
			NDR_PULL_ALLOC_N(ndr, r->spn_names, ndr_get_array_size(ndr, &r->spn_names));
			_mem_save_spn_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->spn_names, 0);
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < r->count; cntr_spn_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->spn_names[cntr_spn_names_1]));
			}
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < r->count; cntr_spn_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->spn_names[cntr_spn_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_spn_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_spn_names_0, 0);
		}
		if (r->spn_names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->spn_names, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	uint32_t cntr_spn_names_1;
	ndr_print_struct(ndr, name, "drsuapi_DsWriteAccountSpnRequest1");
	ndr->depth++;
	ndr_print_drsuapi_DsSpnOperation(ndr, "operation", r->operation);
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "spn_names", r->spn_names);
	ndr->depth++;
	if (r->spn_names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "spn_names", r->count);
		ndr->depth++;
		for (cntr_spn_names_1=0;cntr_spn_names_1<r->count;cntr_spn_names_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_spn_names_1);
			if (idx_1) {
				ndr_print_drsuapi_DsNameString(ndr, "spn_names", &r->spn_names[cntr_spn_names_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsWriteAccountSpnRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsWriteAccountSpnRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsWriteAccountSpnRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsWriteAccountSpnRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsWriteAccountSpnRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsWriteAccountSpnRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsWriteAccountSpnRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsWriteAccountSpnRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsWriteAccountSpnResult1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsWriteAccountSpnResult1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnResult1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsWriteAccountSpnResult1");
	ndr->depth++;
	ndr_print_WERROR(ndr, "status", r->status);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsWriteAccountSpnResult(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsWriteAccountSpnResult *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnResult1(ndr, NDR_SCALARS, &r->res1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsWriteAccountSpnResult(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsWriteAccountSpnResult *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsWriteAccountSpnResult", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnResult1(ndr, NDR_SCALARS, &r->res1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnResult(struct ndr_print *ndr, const char *name, const union drsuapi_DsWriteAccountSpnResult *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsWriteAccountSpnResult");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsWriteAccountSpnResult1(ndr, "res1", &r->res1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsRemoveDSServerRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_dn, ndr_charset_length(r->domain_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsRemoveDSServerRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	uint32_t _ptr_server_dn;
	TALLOC_CTX *_mem_save_server_dn_0;
	uint32_t _ptr_domain_dn;
	TALLOC_CTX *_mem_save_domain_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_dn));
		if (_ptr_domain_dn) {
			NDR_PULL_ALLOC(ndr, r->domain_dn);
		} else {
			r->domain_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			if (ndr_get_array_length(ndr, &r->server_dn) > ndr_get_array_size(ndr, &r->server_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_dn), ndr_get_array_length(ndr, &r->server_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, ndr_get_array_length(ndr, &r->server_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
		if (r->domain_dn) {
			_mem_save_domain_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_dn));
			if (ndr_get_array_length(ndr, &r->domain_dn) > ndr_get_array_size(ndr, &r->domain_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain_dn), ndr_get_array_length(ndr, &r->domain_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_dn, ndr_get_array_length(ndr, &r->domain_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_dn_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsRemoveDSServerRequest1");
	ndr->depth++;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain_dn", r->domain_dn);
	ndr->depth++;
	if (r->domain_dn) {
		ndr_print_string(ndr, "domain_dn", r->domain_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsRemoveDSServerRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsRemoveDSServerRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsRemoveDSServerRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsRemoveDSServerRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsRemoveDSServerRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsRemoveDSServerRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsRemoveDSServerRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsRemoveDSServerRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsRemoveDSServerResult1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsRemoveDSServerResult1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsRemoveDSServerResult1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsRemoveDSServerResult1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerResult1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsRemoveDSServerResult1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsRemoveDSServerResult1");
	ndr->depth++;
	ndr_print_WERROR(ndr, "status", r->status);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsRemoveDSServerResult(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsRemoveDSServerResult *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerResult1(ndr, NDR_SCALARS, &r->res1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsRemoveDSServerResult(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsRemoveDSServerResult *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsRemoveDSServerResult", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerResult1(ndr, NDR_SCALARS, &r->res1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerResult(struct ndr_print *ndr, const char *name, const union drsuapi_DsRemoveDSServerResult *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsRemoveDSServerResult");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsRemoveDSServerResult1(ndr, "res1", &r->res1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfoRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCInfoRequest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->level));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfoRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCInfoRequest1 *r)
{
	uint32_t _ptr_domain_name;
	TALLOC_CTX *_mem_save_domain_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->level));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			if (ndr_get_array_length(ndr, &r->domain_name) > ndr_get_array_size(ndr, &r->domain_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->domain_name), ndr_get_array_length(ndr, &r->domain_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, ndr_get_array_length(ndr, &r->domain_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoRequest1");
	ndr->depth++;
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_int32(ndr, "level", r->level);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfoRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetDCInfoRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfoRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetDCInfoRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetDCInfoRequest", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetDCInfoRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetDCInfoRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetDCInfoRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfo1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_pdc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_enabled));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->netbios_name, ndr_charset_length(r->netbios_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dns_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_name, ndr_charset_length(r->dns_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_name, ndr_charset_length(r->site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->computer_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_dn, ndr_charset_length(r->computer_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfo1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCInfo1 *r)
{
	uint32_t _ptr_netbios_name;
	TALLOC_CTX *_mem_save_netbios_name_0;
	uint32_t _ptr_dns_name;
	TALLOC_CTX *_mem_save_dns_name_0;
	uint32_t _ptr_site_name;
	TALLOC_CTX *_mem_save_site_name_0;
	uint32_t _ptr_computer_dn;
	TALLOC_CTX *_mem_save_computer_dn_0;
	uint32_t _ptr_server_dn;
	TALLOC_CTX *_mem_save_server_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_name));
		if (_ptr_netbios_name) {
			NDR_PULL_ALLOC(ndr, r->netbios_name);
		} else {
			r->netbios_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_name));
		if (_ptr_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dns_name);
		} else {
			r->dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->site_name);
		} else {
			r->site_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_dn));
		if (_ptr_computer_dn) {
			NDR_PULL_ALLOC(ndr, r->computer_dn);
		} else {
			r->computer_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_pdc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_enabled));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			_mem_save_netbios_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->netbios_name));
			if (ndr_get_array_length(ndr, &r->netbios_name) > ndr_get_array_size(ndr, &r->netbios_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->netbios_name), ndr_get_array_length(ndr, &r->netbios_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->netbios_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->netbios_name, ndr_get_array_length(ndr, &r->netbios_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_name_0, 0);
		}
		if (r->dns_name) {
			_mem_save_dns_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_name));
			if (ndr_get_array_length(ndr, &r->dns_name) > ndr_get_array_size(ndr, &r->dns_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->dns_name), ndr_get_array_length(ndr, &r->dns_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->dns_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_name, ndr_get_array_length(ndr, &r->dns_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_name_0, 0);
		}
		if (r->site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_name));
			if (ndr_get_array_length(ndr, &r->site_name) > ndr_get_array_size(ndr, &r->site_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->site_name), ndr_get_array_length(ndr, &r->site_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->site_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_name, ndr_get_array_length(ndr, &r->site_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		if (r->computer_dn) {
			_mem_save_computer_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_dn));
			if (ndr_get_array_length(ndr, &r->computer_dn) > ndr_get_array_size(ndr, &r->computer_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->computer_dn), ndr_get_array_length(ndr, &r->computer_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->computer_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_dn, ndr_get_array_length(ndr, &r->computer_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_dn_0, 0);
		}
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			if (ndr_get_array_length(ndr, &r->server_dn) > ndr_get_array_size(ndr, &r->server_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_dn), ndr_get_array_length(ndr, &r->server_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, ndr_get_array_length(ndr, &r->server_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "netbios_name", r->netbios_name);
	ndr->depth++;
	if (r->netbios_name) {
		ndr_print_string(ndr, "netbios_name", r->netbios_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_name", r->dns_name);
	ndr->depth++;
	if (r->dns_name) {
		ndr_print_string(ndr, "dns_name", r->dns_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_name", r->site_name);
	ndr->depth++;
	if (r->site_name) {
		ndr_print_string(ndr, "site_name", r->site_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "computer_dn", r->computer_dn);
	ndr->depth++;
	if (r->computer_dn) {
		ndr_print_string(ndr, "computer_dn", r->computer_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "is_pdc", r->is_pdc);
	ndr_print_uint32(ndr, "is_enabled", r->is_enabled);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfoCtr1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCInfoCtr1 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfoCtr1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCInfoCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoCtr1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_array_1);
			if (idx_1) {
				ndr_print_drsuapi_DsGetDCInfo1(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfo2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ntds_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_pdc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_enabled));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_gc));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->computer_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->server_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->ntds_guid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->netbios_name, ndr_charset_length(r->netbios_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dns_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_name, ndr_charset_length(r->dns_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_name, ndr_charset_length(r->site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->site_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->site_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_dn, ndr_charset_length(r->site_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->computer_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_dn, ndr_charset_length(r->computer_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->ntds_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->ntds_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->ntds_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ntds_dn, ndr_charset_length(r->ntds_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->site_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->computer_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->server_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->ntds_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfo2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCInfo2 *r)
{
	uint32_t _ptr_netbios_name;
	TALLOC_CTX *_mem_save_netbios_name_0;
	uint32_t _ptr_dns_name;
	TALLOC_CTX *_mem_save_dns_name_0;
	uint32_t _ptr_site_name;
	TALLOC_CTX *_mem_save_site_name_0;
	uint32_t _ptr_site_dn;
	TALLOC_CTX *_mem_save_site_dn_0;
	uint32_t _ptr_computer_dn;
	TALLOC_CTX *_mem_save_computer_dn_0;
	uint32_t _ptr_server_dn;
	TALLOC_CTX *_mem_save_server_dn_0;
	uint32_t _ptr_ntds_dn;
	TALLOC_CTX *_mem_save_ntds_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_name));
		if (_ptr_netbios_name) {
			NDR_PULL_ALLOC(ndr, r->netbios_name);
		} else {
			r->netbios_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_name));
		if (_ptr_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dns_name);
		} else {
			r->dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->site_name);
		} else {
			r->site_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_dn));
		if (_ptr_site_dn) {
			NDR_PULL_ALLOC(ndr, r->site_dn);
		} else {
			r->site_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_dn));
		if (_ptr_computer_dn) {
			NDR_PULL_ALLOC(ndr, r->computer_dn);
		} else {
			r->computer_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ntds_dn));
		if (_ptr_ntds_dn) {
			NDR_PULL_ALLOC(ndr, r->ntds_dn);
		} else {
			r->ntds_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_pdc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_enabled));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_gc));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->computer_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->server_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->ntds_guid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			_mem_save_netbios_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->netbios_name));
			if (ndr_get_array_length(ndr, &r->netbios_name) > ndr_get_array_size(ndr, &r->netbios_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->netbios_name), ndr_get_array_length(ndr, &r->netbios_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->netbios_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->netbios_name, ndr_get_array_length(ndr, &r->netbios_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_name_0, 0);
		}
		if (r->dns_name) {
			_mem_save_dns_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_name));
			if (ndr_get_array_length(ndr, &r->dns_name) > ndr_get_array_size(ndr, &r->dns_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->dns_name), ndr_get_array_length(ndr, &r->dns_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->dns_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_name, ndr_get_array_length(ndr, &r->dns_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_name_0, 0);
		}
		if (r->site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_name));
			if (ndr_get_array_length(ndr, &r->site_name) > ndr_get_array_size(ndr, &r->site_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->site_name), ndr_get_array_length(ndr, &r->site_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->site_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_name, ndr_get_array_length(ndr, &r->site_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		if (r->site_dn) {
			_mem_save_site_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_dn));
			if (ndr_get_array_length(ndr, &r->site_dn) > ndr_get_array_size(ndr, &r->site_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->site_dn), ndr_get_array_length(ndr, &r->site_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->site_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_dn, ndr_get_array_length(ndr, &r->site_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_dn_0, 0);
		}
		if (r->computer_dn) {
			_mem_save_computer_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_dn));
			if (ndr_get_array_length(ndr, &r->computer_dn) > ndr_get_array_size(ndr, &r->computer_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->computer_dn), ndr_get_array_length(ndr, &r->computer_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->computer_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_dn, ndr_get_array_length(ndr, &r->computer_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_dn_0, 0);
		}
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			if (ndr_get_array_length(ndr, &r->server_dn) > ndr_get_array_size(ndr, &r->server_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_dn), ndr_get_array_length(ndr, &r->server_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, ndr_get_array_length(ndr, &r->server_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
		if (r->ntds_dn) {
			_mem_save_ntds_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ntds_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ntds_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->ntds_dn));
			if (ndr_get_array_length(ndr, &r->ntds_dn) > ndr_get_array_size(ndr, &r->ntds_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->ntds_dn), ndr_get_array_length(ndr, &r->ntds_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->ntds_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ntds_dn, ndr_get_array_length(ndr, &r->ntds_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ntds_dn_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->site_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->computer_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->server_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->ntds_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfo2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfo2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "netbios_name", r->netbios_name);
	ndr->depth++;
	if (r->netbios_name) {
		ndr_print_string(ndr, "netbios_name", r->netbios_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_name", r->dns_name);
	ndr->depth++;
	if (r->dns_name) {
		ndr_print_string(ndr, "dns_name", r->dns_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_name", r->site_name);
	ndr->depth++;
	if (r->site_name) {
		ndr_print_string(ndr, "site_name", r->site_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_dn", r->site_dn);
	ndr->depth++;
	if (r->site_dn) {
		ndr_print_string(ndr, "site_dn", r->site_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "computer_dn", r->computer_dn);
	ndr->depth++;
	if (r->computer_dn) {
		ndr_print_string(ndr, "computer_dn", r->computer_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "ntds_dn", r->ntds_dn);
	ndr->depth++;
	if (r->ntds_dn) {
		ndr_print_string(ndr, "ntds_dn", r->ntds_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "is_pdc", r->is_pdc);
	ndr_print_uint32(ndr, "is_enabled", r->is_enabled);
	ndr_print_uint32(ndr, "is_gc", r->is_gc);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_GUID(ndr, "computer_guid", &r->computer_guid);
	ndr_print_GUID(ndr, "server_guid", &r->server_guid);
	ndr_print_GUID(ndr, "ntds_guid", &r->ntds_guid);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfoCtr2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCInfoCtr2 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfoCtr2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCInfoCtr2 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoCtr2 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoCtr2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_array_1);
			if (idx_1) {
				ndr_print_drsuapi_DsGetDCInfo2(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCConnection01(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCConnection01 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->connection_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_account));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client_account) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client_account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client_account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_account, ndr_charset_length(r->client_account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCConnection01(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCConnection01 *r)
{
	uint32_t _ptr_client_account;
	TALLOC_CTX *_mem_save_client_account_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->connection_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_account));
		if (_ptr_client_account) {
			NDR_PULL_ALLOC(ndr, r->client_account);
		} else {
			r->client_account = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client_account) {
			_mem_save_client_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_account));
			if (ndr_get_array_length(ndr, &r->client_account) > ndr_get_array_size(ndr, &r->client_account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client_account), ndr_get_array_length(ndr, &r->client_account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client_account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_account, ndr_get_array_length(ndr, &r->client_account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_account_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCConnection01(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCConnection01 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCConnection01");
	ndr->depth++;
	ndr_print_ipv4address(ndr, "client_ip_address", r->client_ip_address);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "connection_time", r->connection_time);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_ptr(ndr, "client_account", r->client_account);
	ndr->depth++;
	if (r->client_account) {
		ndr_print_string(ndr, "client_account", r->client_account);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCConnectionCtr01(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnection01(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnection01(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCConnectionCtr01(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	uint32_t _ptr_array;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnection01(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnection01(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCConnectionCtr01(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCConnectionCtr01");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_array_1);
			if (idx_1) {
				ndr_print_drsuapi_DsGetDCConnection01(ndr, "array", &r->array[cntr_array_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDCInfoCtr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetDCInfoCtr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break;

			case DRSUAPI_DC_INFO_CTR_2:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break;

			case DRSUAPI_DC_CONNECTION_CTR_01:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_SCALARS, &r->ctr01));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case DRSUAPI_DC_INFO_CTR_2:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case DRSUAPI_DC_CONNECTION_CTR_01:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_BUFFERS, &r->ctr01));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDCInfoCtr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetDCInfoCtr *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetDCInfoCtr", _level);
		}
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case DRSUAPI_DC_INFO_CTR_2: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case DRSUAPI_DC_CONNECTION_CTR_01: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_SCALARS, &r->ctr01));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case DRSUAPI_DC_INFO_CTR_2:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case DRSUAPI_DC_CONNECTION_CTR_01:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_BUFFERS, &r->ctr01));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetDCInfoCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetDCInfoCtr");
	switch (level) {
		case DRSUAPI_DC_INFO_CTR_1:
			ndr_print_drsuapi_DsGetDCInfoCtr1(ndr, "ctr1", &r->ctr1);
		break;

		case DRSUAPI_DC_INFO_CTR_2:
			ndr_print_drsuapi_DsGetDCInfoCtr2(ndr, "ctr2", &r->ctr2);
		break;

		case DRSUAPI_DC_CONNECTION_CTR_01:
			ndr_print_drsuapi_DsGetDCConnectionCtr01(ndr, "ctr01", &r->ctr01);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ NTSTATUS ndr_push_drsuapi_DsReplicaObjectListItem(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjectListItem *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next_object));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_drsuapi_DsReplicaObjectListItem(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjectListItem *r)
{
	uint32_t _ptr_next_object;
	TALLOC_CTX *_mem_save_next_object_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next_object));
		if (_ptr_next_object) {
			NDR_PULL_ALLOC(ndr, r->next_object);
		} else {
			r->next_object = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			_mem_save_next_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next_object, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_object_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryRequest2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryRequest2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS, &r->first_object));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_BUFFERS, &r->first_object));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryRequest2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryRequest2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS, &r->first_object));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_BUFFERS, &r->first_object));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryRequest2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryRequest2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryRequest2");
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectListItem(ndr, "first_object", &r->first_object);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsAddEntryRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest2(ndr, NDR_SCALARS, &r->req2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsAddEntryRequest *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsAddEntryRequest", _level);
		}
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryRequest");
	switch (level) {
		case 2:
			ndr_print_drsuapi_DsAddEntryRequest2(ndr, "req2", &r->req2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryErrorInfoX(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryErrorInfoX *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryErrorInfoX(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryErrorInfoX *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfoX(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorInfoX *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorInfoX");
	ndr->depth++;
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_WERROR(ndr, "status", r->status);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint16(ndr, "unknown3", r->unknown3);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryExtraErrorBuffer(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryExtraErrorBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->size));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryExtraErrorBuffer(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryExtraErrorBuffer *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		if (r->size < 0 || r->size > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			NDR_PULL_ALLOC_N(ndr, r->data, ndr_get_array_size(ndr, &r->data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, ndr_get_array_size(ndr, &r->data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->size));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryExtraErrorBuffer(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryExtraErrorBuffer *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryExtraErrorBuffer");
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_array_uint8(ndr, "data", r->data, r->size);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryExtraError1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryExtraError1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryExtraErrorBuffer(ndr, NDR_SCALARS, &r->buffer));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryExtraErrorBuffer(ndr, NDR_BUFFERS, &r->buffer));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryExtraError1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryExtraError1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryExtraErrorBuffer(ndr, NDR_SCALARS, &r->buffer));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryExtraErrorBuffer(ndr, NDR_BUFFERS, &r->buffer));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryExtraError1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryExtraError1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryExtraError1");
	ndr->depth++;
	ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "error", &r->error);
	ndr_print_drsuapi_DsAttributeId(ndr, "attid", r->attid);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_drsuapi_DsAddEntryExtraErrorBuffer(ndr, "buffer", &r->buffer);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryErrorListItem1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryErrorListItem1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryExtraError1(ndr, NDR_SCALARS, &r->error));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next) {
			NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorListItem1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
		}
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryExtraError1(ndr, NDR_BUFFERS, &r->error));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryErrorListItem1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryErrorListItem1 *r)
{
	uint32_t _ptr_next;
	TALLOC_CTX *_mem_save_next_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next));
		if (_ptr_next) {
			NDR_PULL_ALLOC(ndr, r->next);
		} else {
			r->next = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryExtraError1(ndr, NDR_SCALARS, &r->error));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next) {
			_mem_save_next_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorListItem1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryExtraError1(ndr, NDR_BUFFERS, &r->error));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorListItem1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorListItem1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorListItem1");
	ndr->depth++;
	ndr_print_ptr(ndr, "next", r->next);
	ndr->depth++;
	if (r->next) {
		ndr_print_drsuapi_DsAddEntryErrorListItem1(ndr, "next", r->next);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsAddEntryExtraError1(ndr, "error", &r->error);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryErrorInfo1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryErrorInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorListItem1(ndr, NDR_SCALARS, &r->first));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
		}
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorListItem1(ndr, NDR_BUFFERS, &r->first));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryErrorInfo1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryErrorInfo1 *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorListItem1(ndr, NDR_SCALARS, &r->first));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorListItem1(ndr, NDR_BUFFERS, &r->first));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_WERROR(ndr, "status", r->status);
	ndr_print_drsuapi_DsAddEntryErrorListItem1(ndr, "first", &r->first);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryErrorInfo(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsAddEntryErrorInfo *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo1(ndr, NDR_SCALARS, &r->error1));
			break;

			case 4:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break;

			case 5:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break;

			case 6:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break;

			case 7:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo1(ndr, NDR_BUFFERS, &r->error1));
			break;

			case 4:
			break;

			case 5:
			break;

			case 6:
			break;

			case 7:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryErrorInfo(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsAddEntryErrorInfo *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsAddEntryErrorInfo", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo1(ndr, NDR_SCALARS, &r->error1));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->errorX));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo1(ndr, NDR_BUFFERS, &r->error1));
			break;

			case 4:
			break;

			case 5:
			break;

			case 6:
			break;

			case 7:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryErrorInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryErrorInfo");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsAddEntryErrorInfo1(ndr, "error1", &r->error1);
		break;

		case 4:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "errorX", &r->errorX);
		break;

		case 5:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "errorX", &r->errorX);
		break;

		case 6:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "errorX", &r->errorX);
		break;

		case 7:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "errorX", &r->errorX);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryError1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryError1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->info, r->level));
			NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryError1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryError1 *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->info, r->level));
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryError1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryError1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryError1");
	ndr->depth++;
	ndr_print_WERROR(ndr, "status", r->status);
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_set_switch_value(ndr, r->info, r->level);
		ndr_print_drsuapi_DsAddEntryErrorInfo(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryError(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsAddEntryError *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryError1(ndr, NDR_SCALARS, &r->info1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryError1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryError(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsAddEntryError *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsAddEntryError", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryError1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryError1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryError(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryError *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryError");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsAddEntryError1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsReplicaObjectIdentifier2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaObjectIdentifier2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier2");
	ndr->depth++;
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryCtr2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryCtr2 *r)
{
	uint32_t cntr_objects_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->objects));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
		}
		if (r->objects) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryCtr2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryCtr2 *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0;
	uint32_t _ptr_objects;
	uint32_t cntr_objects_1;
	TALLOC_CTX *_mem_save_objects_0;
	TALLOC_CTX *_mem_save_objects_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objects));
		if (_ptr_objects) {
			NDR_PULL_ALLOC(ndr, r->objects);
		} else {
			r->objects = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		if (r->objects) {
			_mem_save_objects_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->objects));
			NDR_PULL_ALLOC_N(ndr, r->objects, ndr_get_array_size(ndr, &r->objects));
			_mem_save_objects_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_0, 0);
		}
		if (r->objects) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->objects, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryCtr2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryCtr2 *r)
{
	uint32_t cntr_objects_1;
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryCtr2");
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "error", &r->error);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "objects", r->objects);
	ndr->depth++;
	if (r->objects) {
		ndr->print(ndr, "%s: ARRAY(%d)", "objects", r->count);
		ndr->depth++;
		for (cntr_objects_1=0;cntr_objects_1<r->count;cntr_objects_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_objects_1);
			if (idx_1) {
				ndr_print_drsuapi_DsReplicaObjectIdentifier2(ndr, "objects", &r->objects[cntr_objects_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryCtr3(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsAddEntryCtr3 *r)
{
	uint32_t cntr_objects_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->error));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->objects));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
		}
		if (r->error) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->error, r->level));
			NDR_CHECK(ndr_push_drsuapi_DsAddEntryError(ndr, NDR_SCALARS|NDR_BUFFERS, r->error));
		}
		if (r->objects) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryCtr3(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsAddEntryCtr3 *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0;
	uint32_t _ptr_error;
	TALLOC_CTX *_mem_save_error_0;
	uint32_t _ptr_objects;
	uint32_t cntr_objects_1;
	TALLOC_CTX *_mem_save_objects_0;
	TALLOC_CTX *_mem_save_objects_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_error));
		if (_ptr_error) {
			NDR_PULL_ALLOC(ndr, r->error);
		} else {
			r->error = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objects));
		if (_ptr_objects) {
			NDR_PULL_ALLOC(ndr, r->objects);
		} else {
			r->objects = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		if (r->error) {
			_mem_save_error_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->error, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->error, r->level));
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntryError(ndr, NDR_SCALARS|NDR_BUFFERS, r->error));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_error_0, 0);
		}
		if (r->objects) {
			_mem_save_objects_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->objects));
			NDR_PULL_ALLOC_N(ndr, r->objects, ndr_get_array_size(ndr, &r->objects));
			_mem_save_objects_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < r->count; cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_0, 0);
		}
		if (r->objects) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->objects, r->count));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryCtr3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryCtr3 *r)
{
	uint32_t cntr_objects_1;
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryCtr3");
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_ptr(ndr, "error", r->error);
	ndr->depth++;
	if (r->error) {
		ndr_print_set_switch_value(ndr, r->error, r->level);
		ndr_print_drsuapi_DsAddEntryError(ndr, "error", r->error);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "objects", r->objects);
	ndr->depth++;
	if (r->objects) {
		ndr->print(ndr, "%s: ARRAY(%d)", "objects", r->count);
		ndr->depth++;
		for (cntr_objects_1=0;cntr_objects_1<r->count;cntr_objects_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_objects_1);
			if (idx_1) {
				ndr_print_drsuapi_DsReplicaObjectIdentifier2(ndr, "objects", &r->objects[cntr_objects_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntryCtr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsAddEntryCtr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr3(ndr, NDR_SCALARS, &r->ctr3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr3(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntryCtr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsAddEntryCtr *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsAddEntryCtr", _level);
		}
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr3(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr3(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryCtr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryCtr");
	switch (level) {
		case 2:
			ndr_print_drsuapi_DsAddEntryCtr2(ndr, "ctr2", &r->ctr2);
		break;

		case 3:
			ndr_print_drsuapi_DsAddEntryCtr3(ndr, "ctr3", &r->ctr3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsReplicaGetInfoLevel(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsReplicaGetInfoLevel r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaGetInfoLevel(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsReplicaGetInfoLevel *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoLevel(struct ndr_print *ndr, const char *name, enum drsuapi_DsReplicaGetInfoLevel r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_REPLICA_GET_INFO: val = "DRSUAPI_DS_REPLICA_GET_INFO"; break;
		case DRSUAPI_DS_REPLICA_GET_INFO2: val = "DRSUAPI_DS_REPLICA_GET_INFO2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsReplicaInfoType(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsReplicaInfoType r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaInfoType(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsReplicaInfoType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaInfoType(struct ndr_print *ndr, const char *name, enum drsuapi_DsReplicaInfoType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS: val = "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS"; break;
		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA: val = "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA"; break;
		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES: val = "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES"; break;
		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES: val = "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES"; break;
		case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS: val = "DRSUAPI_DS_REPLICA_INFO_PENDING_OPS"; break;
		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA: val = "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS2: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS2"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS3: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS3"; break;
		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2: val = "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2"; break;
		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2: val = "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2"; break;
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02: val = "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02"; break;
		case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04: val = "DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS05: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS05"; break;
		case DRSUAPI_DS_REPLICA_INFO_06: val = "DRSUAPI_DS_REPLICA_INFO_06"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsReplicaGetInfoRequest1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, r->info_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid1));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaGetInfoRequest1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	uint32_t _ptr_object_dn;
	TALLOC_CTX *_mem_save_object_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, &r->info_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid1));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			if (ndr_get_array_length(ndr, &r->object_dn) > ndr_get_array_size(ndr, &r->object_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->object_dn), ndr_get_array_length(ndr, &r->object_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid1));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaGetInfoRequest1");
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaInfoType(ndr, "info_type", r->info_type);
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "guid1", &r->guid1);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaGetInfoRequest2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, r->info_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->guid1));
		if (r->string1) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->string1, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->string1, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string1, ndr_charset_length(r->string1, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->string2) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->string2, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->string2, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string2, ndr_charset_length(r->string2, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaGetInfoRequest2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	uint32_t _ptr_object_dn;
	TALLOC_CTX *_mem_save_object_dn_0;
	uint32_t _ptr_string1;
	TALLOC_CTX *_mem_save_string1_0;
	uint32_t _ptr_string2;
	TALLOC_CTX *_mem_save_string2_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, &r->info_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string1));
		if (_ptr_string1) {
			NDR_PULL_ALLOC(ndr, r->string1);
		} else {
			r->string1 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string2));
		if (_ptr_string2) {
			NDR_PULL_ALLOC(ndr, r->string2);
		} else {
			r->string2 = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			if (ndr_get_array_length(ndr, &r->object_dn) > ndr_get_array_size(ndr, &r->object_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->object_dn), ndr_get_array_length(ndr, &r->object_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->guid1));
		if (r->string1) {
			_mem_save_string1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string1));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string1));
			if (ndr_get_array_length(ndr, &r->string1) > ndr_get_array_size(ndr, &r->string1)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->string1), ndr_get_array_length(ndr, &r->string1));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->string1), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string1, ndr_get_array_length(ndr, &r->string1), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string1_0, 0);
		}
		if (r->string2) {
			_mem_save_string2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string2, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string2));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string2));
			if (ndr_get_array_length(ndr, &r->string2) > ndr_get_array_size(ndr, &r->string2)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->string2), ndr_get_array_length(ndr, &r->string2));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->string2), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string2, ndr_get_array_length(ndr, &r->string2), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string2_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoRequest2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaGetInfoRequest2");
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaInfoType(ndr, "info_type", r->info_type);
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "guid1", &r->guid1);
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_ptr(ndr, "string1", r->string1);
	ndr->depth++;
	if (r->string1) {
		ndr_print_string(ndr, "string1", r->string1);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "string2", r->string2);
	ndr->depth++;
	if (r->string2) {
		ndr_print_string(ndr, "string2", r->string2);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaGetInfoRequest(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsReplicaGetInfoRequest *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoLevel(ndr, NDR_SCALARS, level));
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break;

			case DRSUAPI_DS_REPLICA_GET_INFO2:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_SCALARS, &r->req2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case DRSUAPI_DS_REPLICA_GET_INFO2:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaGetInfoRequest(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsReplicaGetInfoRequest *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsReplicaGetInfoRequest", _level);
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case DRSUAPI_DS_REPLICA_GET_INFO2: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case DRSUAPI_DS_REPLICA_GET_INFO2:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaGetInfoRequest *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaGetInfoRequest");
	switch (level) {
		case DRSUAPI_DS_REPLICA_GET_INFO:
			ndr_print_drsuapi_DsReplicaGetInfoRequest1(ndr, "req1", &r->req1);
		break;

		case DRSUAPI_DS_REPLICA_GET_INFO2:
			ndr_print_drsuapi_DsReplicaGetInfoRequest2(ndr, "req2", &r->req2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsReplicaNeighbour(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaNeighbour *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_obj_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_address));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->transport_obj_dn));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourFlags(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->naming_context_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->transport_obj_guid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->tmp_highest_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_success));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_attempt));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->result_last_attempt));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->consecutive_sync_failures));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->naming_context_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->naming_context_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->naming_context_dn, ndr_charset_length(r->naming_context_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->source_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_obj_dn, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->source_dsa_address) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_address, ndr_charset_length(r->source_dsa_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->transport_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->transport_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->transport_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->transport_obj_dn, ndr_charset_length(r->transport_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->naming_context_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->transport_obj_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaNeighbour(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaNeighbour *r)
{
	uint32_t _ptr_naming_context_dn;
	TALLOC_CTX *_mem_save_naming_context_dn_0;
	uint32_t _ptr_source_dsa_obj_dn;
	TALLOC_CTX *_mem_save_source_dsa_obj_dn_0;
	uint32_t _ptr_source_dsa_address;
	TALLOC_CTX *_mem_save_source_dsa_address_0;
	uint32_t _ptr_transport_obj_dn;
	TALLOC_CTX *_mem_save_transport_obj_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context_dn));
		if (_ptr_naming_context_dn) {
			NDR_PULL_ALLOC(ndr, r->naming_context_dn);
		} else {
			r->naming_context_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_obj_dn));
		if (_ptr_source_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_obj_dn);
		} else {
			r->source_dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_address));
		if (_ptr_source_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_address);
		} else {
			r->source_dsa_address = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transport_obj_dn));
		if (_ptr_transport_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->transport_obj_dn);
		} else {
			r->transport_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourFlags(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->naming_context_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->transport_obj_guid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->tmp_highest_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_success));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_attempt));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->result_last_attempt));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->consecutive_sync_failures));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context_dn) {
			_mem_save_naming_context_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->naming_context_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->naming_context_dn));
			if (ndr_get_array_length(ndr, &r->naming_context_dn) > ndr_get_array_size(ndr, &r->naming_context_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->naming_context_dn), ndr_get_array_length(ndr, &r->naming_context_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->naming_context_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->naming_context_dn, ndr_get_array_length(ndr, &r->naming_context_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_dn_0, 0);
		}
		if (r->source_dsa_obj_dn) {
			_mem_save_source_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_obj_dn));
			if (ndr_get_array_length(ndr, &r->source_dsa_obj_dn) > ndr_get_array_size(ndr, &r->source_dsa_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->source_dsa_obj_dn), ndr_get_array_length(ndr, &r->source_dsa_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->source_dsa_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_obj_dn, ndr_get_array_length(ndr, &r->source_dsa_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_obj_dn_0, 0);
		}
		if (r->source_dsa_address) {
			_mem_save_source_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_address));
			if (ndr_get_array_length(ndr, &r->source_dsa_address) > ndr_get_array_size(ndr, &r->source_dsa_address)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->source_dsa_address), ndr_get_array_length(ndr, &r->source_dsa_address));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->source_dsa_address), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_address, ndr_get_array_length(ndr, &r->source_dsa_address), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_address_0, 0);
		}
		if (r->transport_obj_dn) {
			_mem_save_transport_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->transport_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->transport_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->transport_obj_dn));
			if (ndr_get_array_length(ndr, &r->transport_obj_dn) > ndr_get_array_size(ndr, &r->transport_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->transport_obj_dn), ndr_get_array_length(ndr, &r->transport_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->transport_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->transport_obj_dn, ndr_get_array_length(ndr, &r->transport_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transport_obj_dn_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->naming_context_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->transport_obj_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaNeighbour(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaNeighbour *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaNeighbour");
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context_dn", r->naming_context_dn);
	ndr->depth++;
	if (r->naming_context_dn) {
		ndr_print_string(ndr, "naming_context_dn", r->naming_context_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	ndr->depth++;
	if (r->source_dsa_obj_dn) {
		ndr_print_string(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_address", r->source_dsa_address);
	ndr->depth++;
	if (r->source_dsa_address) {
		ndr_print_string(ndr, "source_dsa_address", r->source_dsa_address);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "transport_obj_dn", r->transport_obj_dn);
	ndr->depth++;
	if (r->transport_obj_dn) {
		ndr_print_string(ndr, "transport_obj_dn", r->transport_obj_dn);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaNeighbourFlags(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_GUID(ndr, "naming_context_obj_guid", &r->naming_context_obj_guid);
	ndr_print_GUID(ndr, "source_dsa_obj_guid", &r->source_dsa_obj_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_GUID(ndr, "transport_obj_guid", &r->transport_obj_guid);
	ndr_print_hyper(ndr, "tmp_highest_usn", r->tmp_highest_usn);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr_print_NTTIME(ndr, "last_success", r->last_success);
	ndr_print_NTTIME(ndr, "last_attempt", r->last_attempt);
	ndr_print_WERROR(ndr, "result_last_attempt", r->result_last_attempt);
	ndr_print_uint32(ndr, "consecutive_sync_failures", r->consecutive_sync_failures);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaNeighbourCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaNeighbourCtr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbour(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbour(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaNeighbourCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaNeighbourCtr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbour(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbour(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaNeighbourCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaNeighbourCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaNeighbourCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaNeighbour(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaCursorCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursorCtr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaCursorCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursorCtr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursorCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursorCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursorCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaCursor(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaObjMetaData(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjMetaData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_last_changed));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaObjMetaData(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjMetaData *r)
{
	uint32_t _ptr_attribute_name;
	TALLOC_CTX *_mem_save_attribute_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_last_changed));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			if (ndr_get_array_length(ndr, &r->attribute_name) > ndr_get_array_size(ndr, &r->attribute_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->attribute_name), ndr_get_array_length(ndr, &r->attribute_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaData(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaData *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaData");
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_last_changed", r->originating_last_changed);
	ndr_print_GUID(ndr, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaObjMetaDataCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaObjMetaDataCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaDataCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaDataCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaObjMetaData(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaKccDsaFailure(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaKccDsaFailure *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dsa_obj_dn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->dsa_obj_guid));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->first_failure));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_failures));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->last_result));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dsa_obj_dn, ndr_charset_length(r->dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->dsa_obj_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaKccDsaFailure(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaKccDsaFailure *r)
{
	uint32_t _ptr_dsa_obj_dn;
	TALLOC_CTX *_mem_save_dsa_obj_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dsa_obj_dn));
		if (_ptr_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->dsa_obj_dn);
		} else {
			r->dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->dsa_obj_guid));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->first_failure));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_failures));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->last_result));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dsa_obj_dn) {
			_mem_save_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dsa_obj_dn));
			if (ndr_get_array_length(ndr, &r->dsa_obj_dn) > ndr_get_array_size(ndr, &r->dsa_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->dsa_obj_dn), ndr_get_array_length(ndr, &r->dsa_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->dsa_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dsa_obj_dn, ndr_get_array_length(ndr, &r->dsa_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dsa_obj_dn_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->dsa_obj_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaKccDsaFailure(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaKccDsaFailure *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaKccDsaFailure");
	ndr->depth++;
	ndr_print_ptr(ndr, "dsa_obj_dn", r->dsa_obj_dn);
	ndr->depth++;
	if (r->dsa_obj_dn) {
		ndr_print_string(ndr, "dsa_obj_dn", r->dsa_obj_dn);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "dsa_obj_guid", &r->dsa_obj_guid);
	ndr_print_NTTIME(ndr, "first_failure", r->first_failure);
	ndr_print_uint32(ndr, "num_failures", r->num_failures);
	ndr_print_WERROR(ndr, "last_result", r->last_result);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaKccDsaFailuresCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaKccDsaFailuresCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaKccDsaFailuresCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaKccDsaFailuresCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaKccDsaFailure(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaOpType(struct ndr_push *ndr, int ndr_flags, enum drsuapi_DsReplicaOpType r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaOpType(struct ndr_pull *ndr, int ndr_flags, enum drsuapi_DsReplicaOpType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOpType(struct ndr_print *ndr, const char *name, enum drsuapi_DsReplicaOpType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC: val = "DRSUAPI_DS_REPLICA_OP_TYPE_SYNC"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_ADD: val = "DRSUAPI_DS_REPLICA_OP_TYPE_ADD"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE: val = "DRSUAPI_DS_REPLICA_OP_TYPE_DELETE"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY: val = "DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS: val = "DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_drsuapi_DsRplicaOpOptions(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsRplicaOpOptions *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOpType(ndr, NDR_SCALARS, level));
		switch (level) {
			case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncOptions(ndr, NDR_SCALARS, r->sync));
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_ADD:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAddOptions(ndr, NDR_SCALARS, r->add));
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaDeleteOptions(ndr, NDR_SCALARS, r->delete));
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaModifyOptions(ndr, NDR_SCALARS, r->modify));
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsOptions(ndr, NDR_SCALARS, r->update_refs));
			break;

			default:
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
			break;

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_ADD:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS:
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsRplicaOpOptions(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsRplicaOpOptions *r)
{
	int level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsRplicaOpOptions", _level);
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncOptions(ndr, NDR_SCALARS, &r->sync));
			break; }

			case DRSUAPI_DS_REPLICA_OP_TYPE_ADD: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAddOptions(ndr, NDR_SCALARS, &r->add));
			break; }

			case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaDeleteOptions(ndr, NDR_SCALARS, &r->delete));
			break; }

			case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaModifyOptions(ndr, NDR_SCALARS, &r->modify));
			break; }

			case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsOptions(ndr, NDR_SCALARS, &r->update_refs));
			break; }

			default: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_ADD:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY:
			break;

			case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS:
			break;

			default:
			break;

		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsRplicaOpOptions(struct ndr_print *ndr, const char *name, const union drsuapi_DsRplicaOpOptions *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsRplicaOpOptions");
	switch (level) {
		case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC:
			ndr_print_drsuapi_DsReplicaSyncOptions(ndr, "sync", r->sync);
		break;

		case DRSUAPI_DS_REPLICA_OP_TYPE_ADD:
			ndr_print_drsuapi_DsReplicaAddOptions(ndr, "add", r->add);
		break;

		case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE:
			ndr_print_drsuapi_DsReplicaDeleteOptions(ndr, "delete", r->delete);
		break;

		case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY:
			ndr_print_drsuapi_DsReplicaModifyOptions(ndr, "modify", r->modify);
		break;

		case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS:
			ndr_print_drsuapi_DsReplicaUpdateRefsOptions(ndr, "update_refs", r->update_refs);
		break;

		default:
			ndr_print_uint32(ndr, "unknown", r->unknown);
		break;

	}
}

static NTSTATUS ndr_push_drsuapi_DsReplicaOp(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaOp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->operation_start));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial_num));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOpType(ndr, NDR_SCALARS, r->operation_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->options, r->operation_type));
		NDR_CHECK(ndr_push_drsuapi_DsRplicaOpOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->nc_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->remote_dsa_obj_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->remote_dsa_address));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->nc_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->remote_dsa_obj_guid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->nc_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->nc_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->nc_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->nc_dn, ndr_charset_length(r->nc_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->remote_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_dsa_obj_dn, ndr_charset_length(r->remote_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->remote_dsa_address) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_dsa_address, ndr_charset_length(r->remote_dsa_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->nc_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->remote_dsa_obj_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaOp(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaOp *r)
{
	uint32_t _ptr_nc_dn;
	TALLOC_CTX *_mem_save_nc_dn_0;
	uint32_t _ptr_remote_dsa_obj_dn;
	TALLOC_CTX *_mem_save_remote_dsa_obj_dn_0;
	uint32_t _ptr_remote_dsa_address;
	TALLOC_CTX *_mem_save_remote_dsa_address_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->operation_start));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial_num));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOpType(ndr, NDR_SCALARS, &r->operation_type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->options, r->operation_type));
		NDR_CHECK(ndr_pull_drsuapi_DsRplicaOpOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nc_dn));
		if (_ptr_nc_dn) {
			NDR_PULL_ALLOC(ndr, r->nc_dn);
		} else {
			r->nc_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_remote_dsa_obj_dn));
		if (_ptr_remote_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->remote_dsa_obj_dn);
		} else {
			r->remote_dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_remote_dsa_address));
		if (_ptr_remote_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->remote_dsa_address);
		} else {
			r->remote_dsa_address = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->nc_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->remote_dsa_obj_guid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->nc_dn) {
			_mem_save_nc_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->nc_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->nc_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->nc_dn));
			if (ndr_get_array_length(ndr, &r->nc_dn) > ndr_get_array_size(ndr, &r->nc_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->nc_dn), ndr_get_array_length(ndr, &r->nc_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->nc_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->nc_dn, ndr_get_array_length(ndr, &r->nc_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nc_dn_0, 0);
		}
		if (r->remote_dsa_obj_dn) {
			_mem_save_remote_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->remote_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_dsa_obj_dn));
			if (ndr_get_array_length(ndr, &r->remote_dsa_obj_dn) > ndr_get_array_size(ndr, &r->remote_dsa_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->remote_dsa_obj_dn), ndr_get_array_length(ndr, &r->remote_dsa_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->remote_dsa_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_dsa_obj_dn, ndr_get_array_length(ndr, &r->remote_dsa_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_remote_dsa_obj_dn_0, 0);
		}
		if (r->remote_dsa_address) {
			_mem_save_remote_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->remote_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_dsa_address));
			if (ndr_get_array_length(ndr, &r->remote_dsa_address) > ndr_get_array_size(ndr, &r->remote_dsa_address)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->remote_dsa_address), ndr_get_array_length(ndr, &r->remote_dsa_address));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->remote_dsa_address), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_dsa_address, ndr_get_array_length(ndr, &r->remote_dsa_address), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_remote_dsa_address_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->nc_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->remote_dsa_obj_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOp(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOp *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOp");
	ndr->depth++;
	ndr_print_NTTIME(ndr, "operation_start", r->operation_start);
	ndr_print_uint32(ndr, "serial_num", r->serial_num);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_drsuapi_DsReplicaOpType(ndr, "operation_type", r->operation_type);
	ndr_print_set_switch_value(ndr, &r->options, r->operation_type);
	ndr_print_drsuapi_DsRplicaOpOptions(ndr, "options", &r->options);
	ndr_print_ptr(ndr, "nc_dn", r->nc_dn);
	ndr->depth++;
	if (r->nc_dn) {
		ndr_print_string(ndr, "nc_dn", r->nc_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "remote_dsa_obj_dn", r->remote_dsa_obj_dn);
	ndr->depth++;
	if (r->remote_dsa_obj_dn) {
		ndr_print_string(ndr, "remote_dsa_obj_dn", r->remote_dsa_obj_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "remote_dsa_address", r->remote_dsa_address);
	ndr->depth++;
	if (r->remote_dsa_address) {
		ndr_print_string(ndr, "remote_dsa_address", r->remote_dsa_address);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "nc_obj_guid", &r->nc_obj_guid);
	ndr_print_GUID(ndr, "remote_dsa_obj_guid", &r->remote_dsa_obj_guid);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaOpCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaOpCtr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaOp(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaOp(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaOpCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaOpCtr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaOp(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaOp(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOpCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOpCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOpCtr");
	ndr->depth++;
	ndr_print_NTTIME(ndr, "time", r->time);
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaOp(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaAttrValMetaData(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaAttrValMetaData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_DATA_BLOB(0, r->binary, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->binary));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->deleted));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->created));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_last_changed));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->binary) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->binary));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaAttrValMetaData(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaAttrValMetaData *r)
{
	uint32_t _ptr_attribute_name;
	TALLOC_CTX *_mem_save_attribute_name_0;
	uint32_t _ptr_object_dn;
	TALLOC_CTX *_mem_save_object_dn_0;
	uint32_t _ptr_binary;
	TALLOC_CTX *_mem_save_binary_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_binary));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary));
		if (_ptr_binary) {
			NDR_PULL_ALLOC(ndr, r->binary);
		} else {
			r->binary = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->deleted));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->created));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_last_changed));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			if (ndr_get_array_length(ndr, &r->attribute_name) > ndr_get_array_size(ndr, &r->attribute_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->attribute_name), ndr_get_array_length(ndr, &r->attribute_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			if (ndr_get_array_length(ndr, &r->object_dn) > ndr_get_array_size(ndr, &r->object_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->object_dn), ndr_get_array_length(ndr, &r->object_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->binary) {
			_mem_save_binary_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->binary, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaData(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaData *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaData");
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "__ndr_size_binary", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DATA_BLOB(0, r->binary, 0):r->__ndr_size_binary);
	ndr_print_ptr(ndr, "binary", r->binary);
	ndr->depth++;
	if (r->binary) {
		ndr_print_DATA_BLOB(ndr, "binary", *r->binary);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "deleted", r->deleted);
	ndr_print_NTTIME(ndr, "created", r->created);
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_last_changed", r->originating_last_changed);
	ndr_print_GUID(ndr, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaAttrValMetaDataCtr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaAttrValMetaDataCtr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaDataCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaDataCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_int32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaAttrValMetaData(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaCursor2Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursor2Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaCursor2Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursor2Ctr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor2Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor2Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor2Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_int32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaCursor2(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaCursor3(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursor3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_sync_success));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_obj_dn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		if (r->source_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_obj_dn, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaCursor3(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursor3 *r)
{
	uint32_t _ptr_source_dsa_obj_dn;
	TALLOC_CTX *_mem_save_source_dsa_obj_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_sync_success));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_obj_dn));
		if (_ptr_source_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_obj_dn);
		} else {
			r->source_dsa_obj_dn = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->source_dsa_invocation_id));
		if (r->source_dsa_obj_dn) {
			_mem_save_source_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_obj_dn));
			if (ndr_get_array_length(ndr, &r->source_dsa_obj_dn) > ndr_get_array_size(ndr, &r->source_dsa_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->source_dsa_obj_dn), ndr_get_array_length(ndr, &r->source_dsa_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->source_dsa_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_obj_dn, ndr_get_array_length(ndr, &r->source_dsa_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_obj_dn_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor3 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor3");
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr_print_NTTIME(ndr, "last_sync_success", r->last_sync_success);
	ndr_print_ptr(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	ndr->depth++;
	if (r->source_dsa_obj_dn) {
		ndr_print_string(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaCursor3Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaCursor3Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor3(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor3(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaCursor3Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaCursor3Ctr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor3(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor3(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor3Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor3Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor3Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_int32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaCursor3(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaObjMetaData2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjMetaData2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_last_changed));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->originating_dsa_obj_dn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
		if (r->originating_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->originating_dsa_obj_dn, ndr_charset_length(r->originating_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaObjMetaData2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjMetaData2 *r)
{
	uint32_t _ptr_attribute_name;
	TALLOC_CTX *_mem_save_attribute_name_0;
	uint32_t _ptr_originating_dsa_obj_dn;
	TALLOC_CTX *_mem_save_originating_dsa_obj_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_last_changed));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_originating_dsa_obj_dn));
		if (_ptr_originating_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->originating_dsa_obj_dn);
		} else {
			r->originating_dsa_obj_dn = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			if (ndr_get_array_length(ndr, &r->attribute_name) > ndr_get_array_size(ndr, &r->attribute_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->attribute_name), ndr_get_array_length(ndr, &r->attribute_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
		if (r->originating_dsa_obj_dn) {
			_mem_save_originating_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->originating_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->originating_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->originating_dsa_obj_dn));
			if (ndr_get_array_length(ndr, &r->originating_dsa_obj_dn) > ndr_get_array_size(ndr, &r->originating_dsa_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->originating_dsa_obj_dn), ndr_get_array_length(ndr, &r->originating_dsa_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->originating_dsa_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->originating_dsa_obj_dn, ndr_get_array_length(ndr, &r->originating_dsa_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_originating_dsa_obj_dn_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaData2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaData2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaData2");
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_last_changed", r->originating_last_changed);
	ndr_print_GUID(ndr, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr_print_ptr(ndr, "originating_dsa_obj_dn", r->originating_dsa_obj_dn);
	ndr->depth++;
	if (r->originating_dsa_obj_dn) {
		ndr_print_string(ndr, "originating_dsa_obj_dn", r->originating_dsa_obj_dn);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaObjMetaData2Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaObjMetaData2Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaData2Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaData2Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_int32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaObjMetaData2(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaAttrValMetaData2(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_DATA_BLOB(0, r->binary, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->binary));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->deleted));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->created));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_last_changed));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->originating_dsa_obj_dn));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->binary) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->binary));
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
		if (r->originating_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->originating_dsa_obj_dn, ndr_charset_length(r->originating_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaAttrValMetaData2(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	uint32_t _ptr_attribute_name;
	TALLOC_CTX *_mem_save_attribute_name_0;
	uint32_t _ptr_object_dn;
	TALLOC_CTX *_mem_save_object_dn_0;
	uint32_t _ptr_binary;
	TALLOC_CTX *_mem_save_binary_0;
	uint32_t _ptr_originating_dsa_obj_dn;
	TALLOC_CTX *_mem_save_originating_dsa_obj_dn_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_binary));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary));
		if (_ptr_binary) {
			NDR_PULL_ALLOC(ndr, r->binary);
		} else {
			r->binary = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->deleted));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->created));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_last_changed));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_originating_dsa_obj_dn));
		if (_ptr_originating_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->originating_dsa_obj_dn);
		} else {
			r->originating_dsa_obj_dn = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			if (ndr_get_array_length(ndr, &r->attribute_name) > ndr_get_array_size(ndr, &r->attribute_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->attribute_name), ndr_get_array_length(ndr, &r->attribute_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, ndr_get_array_length(ndr, &r->attribute_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			if (ndr_get_array_length(ndr, &r->object_dn) > ndr_get_array_size(ndr, &r->object_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->object_dn), ndr_get_array_length(ndr, &r->object_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, ndr_get_array_length(ndr, &r->object_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->binary) {
			_mem_save_binary_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->binary, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_0, 0);
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->originating_dsa_invocation_id));
		if (r->originating_dsa_obj_dn) {
			_mem_save_originating_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->originating_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->originating_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->originating_dsa_obj_dn));
			if (ndr_get_array_length(ndr, &r->originating_dsa_obj_dn) > ndr_get_array_size(ndr, &r->originating_dsa_obj_dn)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->originating_dsa_obj_dn), ndr_get_array_length(ndr, &r->originating_dsa_obj_dn));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->originating_dsa_obj_dn), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->originating_dsa_obj_dn, ndr_get_array_length(ndr, &r->originating_dsa_obj_dn), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_originating_dsa_obj_dn_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaData2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaData2");
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "__ndr_size_binary", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DATA_BLOB(0, r->binary, 0):r->__ndr_size_binary);
	ndr_print_ptr(ndr, "binary", r->binary);
	ndr->depth++;
	if (r->binary) {
		ndr_print_DATA_BLOB(ndr, "binary", *r->binary);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "deleted", r->deleted);
	ndr_print_NTTIME(ndr, "created", r->created);
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_last_changed", r->originating_last_changed);
	ndr_print_GUID(ndr, "originating_dsa_invocation_id", &r->originating_dsa_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr_print_ptr(ndr, "originating_dsa_obj_dn", r->originating_dsa_obj_dn);
	ndr->depth++;
	if (r->originating_dsa_obj_dn) {
		ndr_print_string(ndr, "originating_dsa_obj_dn", r->originating_dsa_obj_dn);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaData2Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_int32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaAttrValMetaData2(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaConnection04(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaConnection04 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->bind_guid));
		NDR_CHECK(ndr_push_NTTIME_1sec(ndr, NDR_SCALARS, r->bind_time));
		{
			uint32_t _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->bind_guid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaConnection04(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaConnection04 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->bind_guid));
		NDR_CHECK(ndr_pull_NTTIME_1sec(ndr, NDR_SCALARS, &r->bind_time));
		{
			uint32_t _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->bind_guid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaConnection04(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaConnection04 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaConnection04");
	ndr->depth++;
	ndr_print_hyper(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr_print_GUID(ndr, "bind_guid", &r->bind_guid);
	ndr_print_NTTIME_1sec(ndr, "bind_time", r->bind_time);
	ndr_print_ipv4address(ndr, "client_ip_address", r->client_ip_address);
	ndr_print_uint32(ndr, "u5", r->u5);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaConnection04Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplicaConnection04Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaConnection04(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaConnection04(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaConnection04Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplicaConnection04Ctr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaConnection04(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaConnection04(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaConnection04Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaConnection04Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaConnection04Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplicaConnection04(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplica06(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplica06 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->str1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u5));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->u6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u7));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str1) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->str1, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->str1, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->str1, ndr_charset_length(r->str1, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplica06(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplica06 *r)
{
	uint32_t _ptr_str1;
	TALLOC_CTX *_mem_save_str1_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_str1));
		if (_ptr_str1) {
			NDR_PULL_ALLOC(ndr, r->str1);
		} else {
			r->str1 = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u5));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->u6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u7));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str1) {
			_mem_save_str1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->str1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->str1));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->str1));
			if (ndr_get_array_length(ndr, &r->str1) > ndr_get_array_size(ndr, &r->str1)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->str1), ndr_get_array_length(ndr, &r->str1));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->str1), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->str1, ndr_get_array_length(ndr, &r->str1), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_str1_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplica06(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplica06 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplica06");
	ndr->depth++;
	ndr_print_ptr(ndr, "str1", r->str1);
	ndr->depth++;
	if (r->str1) {
		ndr_print_string(ndr, "str1", r->str1);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr_print_uint32(ndr, "u4", r->u4);
	ndr_print_uint32(ndr, "u5", r->u5);
	ndr_print_hyper(ndr, "u6", r->u6);
	ndr_print_uint32(ndr, "u7", r->u7);
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplica06Ctr(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsReplica06Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplica06(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplica06(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplica06Ctr(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsReplica06Ctr *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 0 || r->count > 256) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_PULL_ALLOC_N(ndr, r->array, ndr_get_array_size(ndr, &r->array));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplica06(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < r->count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplica06(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplica06Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplica06Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplica06Ctr");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%d)", "array", r->count);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<r->count;cntr_array_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_array_0);
		if (idx_0) {
			ndr_print_drsuapi_DsReplica06(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaInfo(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsReplicaInfo *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, level));
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->neighbours));
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors));
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->objmetadata));
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->connectfailures));
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->linkfailures));
			break;

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pendingops));
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->attrvalmetadata));
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors2));
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors3));
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->objmetadata2));
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->attrvalmetadata2));
			break;

			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->neighbours02));
			break;

			case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->connections04));
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS05:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors05));
			break;

			case DRSUAPI_DS_REPLICA_INFO_06:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->i06));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
				if (r->neighbours) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->neighbours));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS:
				if (r->cursors) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
				if (r->objmetadata) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
				if (r->connectfailures) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->connectfailures));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
				if (r->linkfailures) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->linkfailures));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
				if (r->pendingops) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaOpCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->pendingops));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
				if (r->attrvalmetadata) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
				if (r->cursors2) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors2));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
				if (r->cursors3) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor3Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors3));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
				if (r->objmetadata2) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata2));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
				if (r->attrvalmetadata2) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata2));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02:
				if (r->neighbours02) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->neighbours02));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04:
				if (r->connections04) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaConnection04Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->connections04));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS05:
				if (r->cursors05) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors05));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_06:
				if (r->i06) {
					NDR_CHECK(ndr_push_drsuapi_DsReplica06Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->i06));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaInfo(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsReplicaInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_neighbours_0;
	TALLOC_CTX *_mem_save_cursors_0;
	TALLOC_CTX *_mem_save_objmetadata_0;
	TALLOC_CTX *_mem_save_connectfailures_0;
	TALLOC_CTX *_mem_save_linkfailures_0;
	TALLOC_CTX *_mem_save_pendingops_0;
	TALLOC_CTX *_mem_save_attrvalmetadata_0;
	TALLOC_CTX *_mem_save_cursors2_0;
	TALLOC_CTX *_mem_save_cursors3_0;
	TALLOC_CTX *_mem_save_objmetadata2_0;
	TALLOC_CTX *_mem_save_attrvalmetadata2_0;
	TALLOC_CTX *_mem_save_neighbours02_0;
	TALLOC_CTX *_mem_save_connections04_0;
	TALLOC_CTX *_mem_save_cursors05_0;
	TALLOC_CTX *_mem_save_i06_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsReplicaInfo", _level);
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS: {
				uint32_t _ptr_neighbours;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_neighbours));
				if (_ptr_neighbours) {
					NDR_PULL_ALLOC(ndr, r->neighbours);
				} else {
					r->neighbours = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS: {
				uint32_t _ptr_cursors;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors));
				if (_ptr_cursors) {
					NDR_PULL_ALLOC(ndr, r->cursors);
				} else {
					r->cursors = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA: {
				uint32_t _ptr_objmetadata;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objmetadata));
				if (_ptr_objmetadata) {
					NDR_PULL_ALLOC(ndr, r->objmetadata);
				} else {
					r->objmetadata = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES: {
				uint32_t _ptr_connectfailures;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_connectfailures));
				if (_ptr_connectfailures) {
					NDR_PULL_ALLOC(ndr, r->connectfailures);
				} else {
					r->connectfailures = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES: {
				uint32_t _ptr_linkfailures;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_linkfailures));
				if (_ptr_linkfailures) {
					NDR_PULL_ALLOC(ndr, r->linkfailures);
				} else {
					r->linkfailures = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS: {
				uint32_t _ptr_pendingops;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pendingops));
				if (_ptr_pendingops) {
					NDR_PULL_ALLOC(ndr, r->pendingops);
				} else {
					r->pendingops = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA: {
				uint32_t _ptr_attrvalmetadata;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attrvalmetadata));
				if (_ptr_attrvalmetadata) {
					NDR_PULL_ALLOC(ndr, r->attrvalmetadata);
				} else {
					r->attrvalmetadata = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2: {
				uint32_t _ptr_cursors2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors2));
				if (_ptr_cursors2) {
					NDR_PULL_ALLOC(ndr, r->cursors2);
				} else {
					r->cursors2 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3: {
				uint32_t _ptr_cursors3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors3));
				if (_ptr_cursors3) {
					NDR_PULL_ALLOC(ndr, r->cursors3);
				} else {
					r->cursors3 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2: {
				uint32_t _ptr_objmetadata2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objmetadata2));
				if (_ptr_objmetadata2) {
					NDR_PULL_ALLOC(ndr, r->objmetadata2);
				} else {
					r->objmetadata2 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2: {
				uint32_t _ptr_attrvalmetadata2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attrvalmetadata2));
				if (_ptr_attrvalmetadata2) {
					NDR_PULL_ALLOC(ndr, r->attrvalmetadata2);
				} else {
					r->attrvalmetadata2 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02: {
				uint32_t _ptr_neighbours02;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_neighbours02));
				if (_ptr_neighbours02) {
					NDR_PULL_ALLOC(ndr, r->neighbours02);
				} else {
					r->neighbours02 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04: {
				uint32_t _ptr_connections04;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_connections04));
				if (_ptr_connections04) {
					NDR_PULL_ALLOC(ndr, r->connections04);
				} else {
					r->connections04 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS05: {
				uint32_t _ptr_cursors05;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors05));
				if (_ptr_cursors05) {
					NDR_PULL_ALLOC(ndr, r->cursors05);
				} else {
					r->cursors05 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_06: {
				uint32_t _ptr_i06;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_i06));
				if (_ptr_i06) {
					NDR_PULL_ALLOC(ndr, r->i06);
				} else {
					r->i06 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
				if (r->neighbours) {
					_mem_save_neighbours_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->neighbours, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->neighbours));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_neighbours_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS:
				if (r->cursors) {
					_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
				if (r->objmetadata) {
					_mem_save_objmetadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->objmetadata, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objmetadata_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
				if (r->connectfailures) {
					_mem_save_connectfailures_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->connectfailures, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->connectfailures));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connectfailures_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
				if (r->linkfailures) {
					_mem_save_linkfailures_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->linkfailures, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->linkfailures));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_linkfailures_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
				if (r->pendingops) {
					_mem_save_pendingops_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pendingops, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaOpCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->pendingops));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pendingops_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
				if (r->attrvalmetadata) {
					_mem_save_attrvalmetadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->attrvalmetadata, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attrvalmetadata_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
				if (r->cursors2) {
					_mem_save_cursors2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors2, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors2_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
				if (r->cursors3) {
					_mem_save_cursors3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors3, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor3Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors3_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
				if (r->objmetadata2) {
					_mem_save_objmetadata2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->objmetadata2, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objmetadata2_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
				if (r->attrvalmetadata2) {
					_mem_save_attrvalmetadata2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->attrvalmetadata2, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attrvalmetadata2_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02:
				if (r->neighbours02) {
					_mem_save_neighbours02_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->neighbours02, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->neighbours02));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_neighbours02_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04:
				if (r->connections04) {
					_mem_save_connections04_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->connections04, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaConnection04Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->connections04));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connections04_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS05:
				if (r->cursors05) {
					_mem_save_cursors05_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors05, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors05));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors05_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_06:
				if (r->i06) {
					_mem_save_i06_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->i06, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplica06Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->i06));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_i06_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaInfo");
	switch (level) {
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
			ndr_print_ptr(ndr, "neighbours", r->neighbours);
			ndr->depth++;
			if (r->neighbours) {
				ndr_print_drsuapi_DsReplicaNeighbourCtr(ndr, "neighbours", r->neighbours);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS:
			ndr_print_ptr(ndr, "cursors", r->cursors);
			ndr->depth++;
			if (r->cursors) {
				ndr_print_drsuapi_DsReplicaCursorCtr(ndr, "cursors", r->cursors);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
			ndr_print_ptr(ndr, "objmetadata", r->objmetadata);
			ndr->depth++;
			if (r->objmetadata) {
				ndr_print_drsuapi_DsReplicaObjMetaDataCtr(ndr, "objmetadata", r->objmetadata);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
			ndr_print_ptr(ndr, "connectfailures", r->connectfailures);
			ndr->depth++;
			if (r->connectfailures) {
				ndr_print_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, "connectfailures", r->connectfailures);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
			ndr_print_ptr(ndr, "linkfailures", r->linkfailures);
			ndr->depth++;
			if (r->linkfailures) {
				ndr_print_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, "linkfailures", r->linkfailures);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
			ndr_print_ptr(ndr, "pendingops", r->pendingops);
			ndr->depth++;
			if (r->pendingops) {
				ndr_print_drsuapi_DsReplicaOpCtr(ndr, "pendingops", r->pendingops);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
			ndr_print_ptr(ndr, "attrvalmetadata", r->attrvalmetadata);
			ndr->depth++;
			if (r->attrvalmetadata) {
				ndr_print_drsuapi_DsReplicaAttrValMetaDataCtr(ndr, "attrvalmetadata", r->attrvalmetadata);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
			ndr_print_ptr(ndr, "cursors2", r->cursors2);
			ndr->depth++;
			if (r->cursors2) {
				ndr_print_drsuapi_DsReplicaCursor2Ctr(ndr, "cursors2", r->cursors2);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
			ndr_print_ptr(ndr, "cursors3", r->cursors3);
			ndr->depth++;
			if (r->cursors3) {
				ndr_print_drsuapi_DsReplicaCursor3Ctr(ndr, "cursors3", r->cursors3);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
			ndr_print_ptr(ndr, "objmetadata2", r->objmetadata2);
			ndr->depth++;
			if (r->objmetadata2) {
				ndr_print_drsuapi_DsReplicaObjMetaData2Ctr(ndr, "objmetadata2", r->objmetadata2);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
			ndr_print_ptr(ndr, "attrvalmetadata2", r->attrvalmetadata2);
			ndr->depth++;
			if (r->attrvalmetadata2) {
				ndr_print_drsuapi_DsReplicaAttrValMetaData2Ctr(ndr, "attrvalmetadata2", r->attrvalmetadata2);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02:
			ndr_print_ptr(ndr, "neighbours02", r->neighbours02);
			ndr->depth++;
			if (r->neighbours02) {
				ndr_print_drsuapi_DsReplicaNeighbourCtr(ndr, "neighbours02", r->neighbours02);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04:
			ndr_print_ptr(ndr, "connections04", r->connections04);
			ndr->depth++;
			if (r->connections04) {
				ndr_print_drsuapi_DsReplicaConnection04Ctr(ndr, "connections04", r->connections04);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS05:
			ndr_print_ptr(ndr, "cursors05", r->cursors05);
			ndr->depth++;
			if (r->cursors05) {
				ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "cursors05", r->cursors05);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_06:
			ndr_print_ptr(ndr, "i06", r->i06);
			ndr->depth++;
			if (r->i06) {
				ndr_print_drsuapi_DsReplica06Ctr(ndr, "i06", r->i06);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetMemberships2Ctr(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetMemberships2Ctr *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMemberships2Ctr(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetMemberships2Ctr *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetMemberships2Ctr", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2Ctr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMemberships2Ctr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMemberships2Ctr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMembershipsCtr1(ndr, "ctr1", &r->ctr1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsGetMemberships2Request1(struct ndr_push *ndr, int ndr_flags, const struct drsuapi_DsGetMemberships2Request1 *r)
{
	uint32_t cntr_req_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_req));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->req_array));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->req_array) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_req));
			for (cntr_req_array_1 = 0; cntr_req_array_1 < r->num_req; cntr_req_array_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->req_array[cntr_req_array_1]));
			}
			for (cntr_req_array_1 = 0; cntr_req_array_1 < r->num_req; cntr_req_array_1++) {
				if (r->req_array[cntr_req_array_1]) {
					NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS|NDR_BUFFERS, r->req_array[cntr_req_array_1]));
				}
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMemberships2Request1(struct ndr_pull *ndr, int ndr_flags, struct drsuapi_DsGetMemberships2Request1 *r)
{
	uint32_t _ptr_req_array;
	uint32_t cntr_req_array_1;
	TALLOC_CTX *_mem_save_req_array_0;
	TALLOC_CTX *_mem_save_req_array_1;
	TALLOC_CTX *_mem_save_req_array_2;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_req));
		if (r->num_req < 1 || r->num_req > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_req_array));
		if (_ptr_req_array) {
			NDR_PULL_ALLOC(ndr, r->req_array);
		} else {
			r->req_array = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->req_array) {
			_mem_save_req_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->req_array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->req_array));
			NDR_PULL_ALLOC_N(ndr, r->req_array, ndr_get_array_size(ndr, &r->req_array));
			_mem_save_req_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->req_array, 0);
			for (cntr_req_array_1 = 0; cntr_req_array_1 < r->num_req; cntr_req_array_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_req_array));
				if (_ptr_req_array) {
					NDR_PULL_ALLOC(ndr, r->req_array[cntr_req_array_1]);
				} else {
					r->req_array[cntr_req_array_1] = NULL;
				}
			}
			for (cntr_req_array_1 = 0; cntr_req_array_1 < r->num_req; cntr_req_array_1++) {
				if (r->req_array[cntr_req_array_1]) {
					_mem_save_req_array_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->req_array[cntr_req_array_1], 0);
					NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS|NDR_BUFFERS, r->req_array[cntr_req_array_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_array_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_array_0, 0);
		}
		if (r->req_array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->req_array, r->num_req));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2Request1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetMemberships2Request1 *r)
{
	uint32_t cntr_req_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetMemberships2Request1");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_req", r->num_req);
	ndr_print_ptr(ndr, "req_array", r->req_array);
	ndr->depth++;
	if (r->req_array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "req_array", r->num_req);
		ndr->depth++;
		for (cntr_req_array_1=0;cntr_req_array_1<r->num_req;cntr_req_array_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_req_array_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "req_array", r->req_array[cntr_req_array_1]);
				ndr->depth++;
				if (r->req_array[cntr_req_array_1]) {
					ndr_print_drsuapi_DsGetMembershipsRequest1(ndr, "req_array", r->req_array[cntr_req_array_1]);
				}
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetMemberships2Request(struct ndr_push *ndr, int ndr_flags, const union drsuapi_DsGetMemberships2Request *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Request1(ndr, NDR_SCALARS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Request1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMemberships2Request(struct ndr_pull *ndr, int ndr_flags, union drsuapi_DsGetMemberships2Request *r)
{
	int level;
	int32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for drsuapi_DsGetMemberships2Request", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Request1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Request1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2Request(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMemberships2Request *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMemberships2Request");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMemberships2Request1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_drsuapi_DsBind(struct ndr_push *ndr, int flags, const struct drsuapi_DsBind *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.bind_guid));
		if (r->in.bind_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.bind_info));
		if (r->in.bind_info) {
			NDR_CHECK(ndr_push_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.bind_info));
		if (r->out.bind_info) {
			NDR_CHECK(ndr_push_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.bind_info));
		}
		if (r->out.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.bind_handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsBind(struct ndr_pull *ndr, int flags, struct drsuapi_DsBind *r)
{
	uint32_t _ptr_bind_guid;
	uint32_t _ptr_bind_info;
	TALLOC_CTX *_mem_save_bind_guid_0;
	TALLOC_CTX *_mem_save_bind_info_0;
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bind_guid));
		if (_ptr_bind_guid) {
			NDR_PULL_ALLOC(ndr, r->in.bind_guid);
		} else {
			r->in.bind_guid = NULL;
		}
		if (r->in.bind_guid) {
			_mem_save_bind_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bind_info));
		if (_ptr_bind_info) {
			NDR_PULL_ALLOC(ndr, r->in.bind_info);
		} else {
			r->in.bind_info = NULL;
		}
		if (r->in.bind_info) {
			_mem_save_bind_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_info, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_info_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		ZERO_STRUCTP(r->out.bind_handle);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bind_info));
		if (_ptr_bind_info) {
			NDR_PULL_ALLOC(ndr, r->out.bind_info);
		} else {
			r->out.bind_info = NULL;
		}
		if (r->out.bind_info) {
			_mem_save_bind_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.bind_info, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.bind_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsBind(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsBind *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBind");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsBind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_guid", r->in.bind_guid);
		ndr->depth++;
		if (r->in.bind_guid) {
			ndr_print_GUID(ndr, "bind_guid", r->in.bind_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "bind_info", r->in.bind_info);
		ndr->depth++;
		if (r->in.bind_info) {
			ndr_print_drsuapi_DsBindInfoCtr(ndr, "bind_info", r->in.bind_info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsBind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_info", r->out.bind_info);
		ndr->depth++;
		if (r->out.bind_info) {
			ndr_print_drsuapi_DsBindInfoCtr(ndr, "bind_info", r->out.bind_info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsUnbind(struct ndr_push *ndr, int flags, const struct drsuapi_DsUnbind *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.bind_handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsUnbind(struct ndr_pull *ndr, int flags, struct drsuapi_DsUnbind *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		*r->out.bind_handle = *r->in.bind_handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsUnbind(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsUnbind *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsUnbind");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsUnbind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsUnbind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaSync(struct ndr_push *ndr, int flags, const struct drsuapi_DsReplicaSync *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaSync(struct ndr_pull *ndr, int flags, struct drsuapi_DsReplicaSync *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSync(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsReplicaSync *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaSync");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaSync");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaSyncRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaSync");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNCChanges(struct ndr_push *ndr, int flags, const struct drsuapi_DsGetNCChanges *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		if (r->in.level == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, *r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, *r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, *r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.ctr, *r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNCChanges(struct ndr_pull *ndr, int flags, struct drsuapi_DsGetNCChanges *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	TALLOC_CTX *_mem_save_level_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.level);
		}
		_mem_save_level_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.level, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, *r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
		NDR_PULL_ALLOC(ndr, r->out.level);
		*r->out.level = *r->in.level;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level);
		}
		_mem_save_level_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.ctr, *r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChanges(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsGetNCChanges *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChanges");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetNCChanges");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "level", r->in.level);
		ndr->depth++;
		ndr_print_int32(ndr, "level", *r->in.level);
		ndr->depth--;
		ndr_print_set_switch_value(ndr, &r->in.req, *r->in.level);
		ndr_print_drsuapi_DsGetNCChangesRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetNCChanges");
		ndr->depth++;
		ndr_print_ptr(ndr, "level", r->out.level);
		ndr->depth++;
		ndr_print_int32(ndr, "level", *r->out.level);
		ndr->depth--;
		ndr_print_set_switch_value(ndr, &r->out.ctr, *r->out.level);
		ndr_print_drsuapi_DsGetNCChangesCtr(ndr, "ctr", &r->out.ctr);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaUpdateRefs(struct ndr_push *ndr, int flags, const struct drsuapi_DsReplicaUpdateRefs *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaUpdateRefs(struct ndr_pull *ndr, int flags, struct drsuapi_DsReplicaUpdateRefs *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefs(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsReplicaUpdateRefs *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaUpdateRefs");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaUpdateRefs");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaUpdateRefsRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaUpdateRefs");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_REPLICA_ADD(struct ndr_push *ndr, int flags, const struct DRSUAPI_REPLICA_ADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_REPLICA_ADD(struct ndr_pull *ndr, int flags, struct DRSUAPI_REPLICA_ADD *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_REPLICA_ADD(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_REPLICA_ADD *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REPLICA_ADD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REPLICA_ADD");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REPLICA_ADD");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_REPLICA_DEL(struct ndr_push *ndr, int flags, const struct DRSUAPI_REPLICA_DEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_REPLICA_DEL(struct ndr_pull *ndr, int flags, struct DRSUAPI_REPLICA_DEL *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_REPLICA_DEL(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_REPLICA_DEL *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REPLICA_DEL");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REPLICA_DEL");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REPLICA_DEL");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_REPLICA_MODIFY(struct ndr_push *ndr, int flags, const struct DRSUAPI_REPLICA_MODIFY *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_REPLICA_MODIFY(struct ndr_pull *ndr, int flags, struct DRSUAPI_REPLICA_MODIFY *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_REPLICA_MODIFY(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_REPLICA_MODIFY *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REPLICA_MODIFY");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REPLICA_MODIFY");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REPLICA_MODIFY");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_VERIFY_NAMES(struct ndr_push *ndr, int flags, const struct DRSUAPI_VERIFY_NAMES *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_VERIFY_NAMES(struct ndr_pull *ndr, int flags, struct DRSUAPI_VERIFY_NAMES *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_VERIFY_NAMES(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_VERIFY_NAMES *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_VERIFY_NAMES");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_VERIFY_NAMES");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_VERIFY_NAMES");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetMemberships(struct ndr_push *ndr, int flags, const struct drsuapi_DsGetMemberships *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMemberships(struct ndr_pull *ndr, int flags, struct drsuapi_DsGetMemberships *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsGetMemberships *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetMemberships");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetMemberships");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetMembershipsRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetMemberships");
		ndr->depth++;
		ndr_print_int32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.ctr, r->out.level);
		ndr_print_drsuapi_DsGetMembershipsCtr(ndr, "ctr", &r->out.ctr);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_INTER_DOMAIN_MOVE(struct ndr_push *ndr, int flags, const struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_INTER_DOMAIN_MOVE(struct ndr_pull *ndr, int flags, struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_INTER_DOMAIN_MOVE(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_INTER_DOMAIN_MOVE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_INTER_DOMAIN_MOVE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_INTER_DOMAIN_MOVE");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetNT4ChangeLog(struct ndr_push *ndr, int flags, const struct drsuapi_DsGetNT4ChangeLog *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetNT4ChangeLog(struct ndr_pull *ndr, int flags, struct drsuapi_DsGetNT4ChangeLog *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLog(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsGetNT4ChangeLog *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNT4ChangeLog");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetNT4ChangeLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetNT4ChangeLogRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetNT4ChangeLog");
		ndr->depth++;
		ndr_print_uint32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.info, r->out.level);
		ndr_print_drsuapi_DsGetNT4ChangeLogInfo(ndr, "info", &r->out.info);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsCrackNames(struct ndr_push *ndr, int flags, const struct drsuapi_DsCrackNames *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsNameRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsNameCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsCrackNames(struct ndr_pull *ndr, int flags, struct drsuapi_DsCrackNames *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsNameRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsNameCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsCrackNames(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsCrackNames *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsCrackNames");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsCrackNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsNameRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsCrackNames");
		ndr->depth++;
		ndr_print_int32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.ctr, r->out.level);
		ndr_print_drsuapi_DsNameCtr(ndr, "ctr", &r->out.ctr);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsWriteAccountSpn(struct ndr_push *ndr, int flags, const struct drsuapi_DsWriteAccountSpn *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.res, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnResult(ndr, NDR_SCALARS, &r->out.res));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsWriteAccountSpn(struct ndr_pull *ndr, int flags, struct drsuapi_DsWriteAccountSpn *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.res, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnResult(ndr, NDR_SCALARS, &r->out.res));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpn(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsWriteAccountSpn *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsWriteAccountSpn");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsWriteAccountSpn");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsWriteAccountSpnRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsWriteAccountSpn");
		ndr->depth++;
		ndr_print_int32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.res, r->out.level);
		ndr_print_drsuapi_DsWriteAccountSpnResult(ndr, "res", &r->out.res);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsRemoveDSServer(struct ndr_push *ndr, int flags, const struct drsuapi_DsRemoveDSServer *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.res, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerResult(ndr, NDR_SCALARS, &r->out.res));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsRemoveDSServer(struct ndr_pull *ndr, int flags, struct drsuapi_DsRemoveDSServer *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.res, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerResult(ndr, NDR_SCALARS, &r->out.res));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServer(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsRemoveDSServer *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsRemoveDSServer");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsRemoveDSServer");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsRemoveDSServerRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsRemoveDSServer");
		ndr->depth++;
		ndr_print_int32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.res, r->out.level);
		ndr_print_drsuapi_DsRemoveDSServerResult(ndr, "res", &r->out.res);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_REMOVE_DS_DOMAIN(struct ndr_push *ndr, int flags, const struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_REMOVE_DS_DOMAIN(struct ndr_pull *ndr, int flags, struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_REMOVE_DS_DOMAIN(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REMOVE_DS_DOMAIN");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REMOVE_DS_DOMAIN");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REMOVE_DS_DOMAIN");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetDomainControllerInfo(struct ndr_push *ndr, int flags, const struct drsuapi_DsGetDomainControllerInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.ctr, r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetDomainControllerInfo(struct ndr_pull *ndr, int flags, struct drsuapi_DsGetDomainControllerInfo *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level_out));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.ctr, r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDomainControllerInfo(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsGetDomainControllerInfo *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDomainControllerInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetDomainControllerInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetDCInfoRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetDomainControllerInfo");
		ndr->depth++;
		ndr_print_int32(ndr, "level_out", r->out.level_out);
		ndr_print_set_switch_value(ndr, &r->out.ctr, r->out.level_out);
		ndr_print_drsuapi_DsGetDCInfoCtr(ndr, "ctr", &r->out.ctr);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsAddEntry(struct ndr_push *ndr, int flags, const struct drsuapi_DsAddEntry *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsAddEntry(struct ndr_pull *ndr, int flags, struct drsuapi_DsAddEntry *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsAddEntry *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntry");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsAddEntry");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsAddEntryRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsAddEntry");
		ndr->depth++;
		ndr_print_int32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.ctr, r->out.level);
		ndr_print_drsuapi_DsAddEntryCtr(ndr, "ctr", &r->out.ctr);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_EXECUTE_KCC(struct ndr_push *ndr, int flags, const struct DRSUAPI_EXECUTE_KCC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_EXECUTE_KCC(struct ndr_pull *ndr, int flags, struct DRSUAPI_EXECUTE_KCC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_EXECUTE_KCC(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_EXECUTE_KCC *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_EXECUTE_KCC");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_EXECUTE_KCC");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_EXECUTE_KCC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsReplicaGetInfo(struct ndr_push *ndr, int flags, const struct drsuapi_DsReplicaGetInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, r->out.info_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->out.info_type));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsReplicaGetInfo(struct ndr_pull *ndr, int flags, struct drsuapi_DsReplicaGetInfo *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoLevel(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, &r->out.info_type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->out.info_type));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsReplicaGetInfo *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_drsuapi_DsReplicaGetInfoLevel(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaGetInfoRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaGetInfo");
		ndr->depth++;
		ndr_print_drsuapi_DsReplicaInfoType(ndr, "info_type", r->out.info_type);
		ndr_print_set_switch_value(ndr, &r->out.info, r->out.info_type);
		ndr_print_drsuapi_DsReplicaInfo(ndr, "info", &r->out.info);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_ADD_SID_HISTORY(struct ndr_push *ndr, int flags, const struct DRSUAPI_ADD_SID_HISTORY *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_ADD_SID_HISTORY(struct ndr_pull *ndr, int flags, struct DRSUAPI_ADD_SID_HISTORY *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_ADD_SID_HISTORY(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_ADD_SID_HISTORY *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_ADD_SID_HISTORY");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_ADD_SID_HISTORY");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_ADD_SID_HISTORY");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_drsuapi_DsGetMemberships2(struct ndr_push *ndr, int flags, const struct drsuapi_DsGetMemberships2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Request(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->out.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_drsuapi_DsGetMemberships2(struct ndr_pull *ndr, int flags, struct drsuapi_DsGetMemberships2 *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Request(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->out.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.ctr, r->out.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.ctr));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2(struct ndr_print *ndr, const char *name, int flags, const struct drsuapi_DsGetMemberships2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetMemberships2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetMemberships2");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_int32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetMemberships2Request(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetMemberships2");
		ndr->depth++;
		ndr_print_int32(ndr, "level", r->out.level);
		ndr_print_set_switch_value(ndr, &r->out.ctr, r->out.level);
		ndr_print_drsuapi_DsGetMemberships2Ctr(ndr, "ctr", &r->out.ctr);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ndr_push *ndr, int flags, const struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ndr_pull *ndr, int flags, struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REPLICA_VERIFY_OBJECTS");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REPLICA_VERIFY_OBJECTS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REPLICA_VERIFY_OBJECTS");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_GET_OBJECT_EXISTENCE(struct ndr_push *ndr, int flags, const struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_GET_OBJECT_EXISTENCE(struct ndr_pull *ndr, int flags, struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_GET_OBJECT_EXISTENCE(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_GET_OBJECT_EXISTENCE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_GET_OBJECT_EXISTENCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_GET_OBJECT_EXISTENCE");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_DRSUAPI_QUERY_SITES_BY_COST(struct ndr_push *ndr, int flags, const struct DRSUAPI_QUERY_SITES_BY_COST *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DRSUAPI_QUERY_SITES_BY_COST(struct ndr_pull *ndr, int flags, struct DRSUAPI_QUERY_SITES_BY_COST *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DRSUAPI_QUERY_SITES_BY_COST(struct ndr_print *ndr, const char *name, int flags, const struct DRSUAPI_QUERY_SITES_BY_COST *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_QUERY_SITES_BY_COST");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_QUERY_SITES_BY_COST");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_QUERY_SITES_BY_COST");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call drsuapi_calls[] = {
	{
		"drsuapi_DsBind",
		sizeof(struct drsuapi_DsBind),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsBind,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBind,
		(ndr_print_function_t) ndr_print_drsuapi_DsBind,
		False,
	},
	{
		"drsuapi_DsUnbind",
		sizeof(struct drsuapi_DsUnbind),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsUnbind,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsUnbind,
		(ndr_print_function_t) ndr_print_drsuapi_DsUnbind,
		False,
	},
	{
		"drsuapi_DsReplicaSync",
		sizeof(struct drsuapi_DsReplicaSync),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaSync,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaSync,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaSync,
		False,
	},
	{
		"drsuapi_DsGetNCChanges",
		sizeof(struct drsuapi_DsGetNCChanges),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChanges,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChanges,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetNCChanges,
		False,
	},
	{
		"drsuapi_DsReplicaUpdateRefs",
		sizeof(struct drsuapi_DsReplicaUpdateRefs),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaUpdateRefs,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaUpdateRefs,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaUpdateRefs,
		False,
	},
	{
		"DRSUAPI_REPLICA_ADD",
		sizeof(struct DRSUAPI_REPLICA_ADD),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REPLICA_ADD,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REPLICA_ADD,
		(ndr_print_function_t) ndr_print_DRSUAPI_REPLICA_ADD,
		False,
	},
	{
		"DRSUAPI_REPLICA_DEL",
		sizeof(struct DRSUAPI_REPLICA_DEL),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REPLICA_DEL,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REPLICA_DEL,
		(ndr_print_function_t) ndr_print_DRSUAPI_REPLICA_DEL,
		False,
	},
	{
		"DRSUAPI_REPLICA_MODIFY",
		sizeof(struct DRSUAPI_REPLICA_MODIFY),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REPLICA_MODIFY,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REPLICA_MODIFY,
		(ndr_print_function_t) ndr_print_DRSUAPI_REPLICA_MODIFY,
		False,
	},
	{
		"DRSUAPI_VERIFY_NAMES",
		sizeof(struct DRSUAPI_VERIFY_NAMES),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_VERIFY_NAMES,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_VERIFY_NAMES,
		(ndr_print_function_t) ndr_print_DRSUAPI_VERIFY_NAMES,
		False,
	},
	{
		"drsuapi_DsGetMemberships",
		sizeof(struct drsuapi_DsGetMemberships),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetMemberships,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetMemberships,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetMemberships,
		False,
	},
	{
		"DRSUAPI_INTER_DOMAIN_MOVE",
		sizeof(struct DRSUAPI_INTER_DOMAIN_MOVE),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_INTER_DOMAIN_MOVE,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_INTER_DOMAIN_MOVE,
		(ndr_print_function_t) ndr_print_DRSUAPI_INTER_DOMAIN_MOVE,
		False,
	},
	{
		"drsuapi_DsGetNT4ChangeLog",
		sizeof(struct drsuapi_DsGetNT4ChangeLog),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNT4ChangeLog,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNT4ChangeLog,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetNT4ChangeLog,
		False,
	},
	{
		"drsuapi_DsCrackNames",
		sizeof(struct drsuapi_DsCrackNames),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsCrackNames,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsCrackNames,
		(ndr_print_function_t) ndr_print_drsuapi_DsCrackNames,
		False,
	},
	{
		"drsuapi_DsWriteAccountSpn",
		sizeof(struct drsuapi_DsWriteAccountSpn),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsWriteAccountSpn,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsWriteAccountSpn,
		(ndr_print_function_t) ndr_print_drsuapi_DsWriteAccountSpn,
		False,
	},
	{
		"drsuapi_DsRemoveDSServer",
		sizeof(struct drsuapi_DsRemoveDSServer),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsRemoveDSServer,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsRemoveDSServer,
		(ndr_print_function_t) ndr_print_drsuapi_DsRemoveDSServer,
		False,
	},
	{
		"DRSUAPI_REMOVE_DS_DOMAIN",
		sizeof(struct DRSUAPI_REMOVE_DS_DOMAIN),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REMOVE_DS_DOMAIN,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REMOVE_DS_DOMAIN,
		(ndr_print_function_t) ndr_print_DRSUAPI_REMOVE_DS_DOMAIN,
		False,
	},
	{
		"drsuapi_DsGetDomainControllerInfo",
		sizeof(struct drsuapi_DsGetDomainControllerInfo),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetDomainControllerInfo,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetDomainControllerInfo,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetDomainControllerInfo,
		False,
	},
	{
		"drsuapi_DsAddEntry",
		sizeof(struct drsuapi_DsAddEntry),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsAddEntry,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsAddEntry,
		(ndr_print_function_t) ndr_print_drsuapi_DsAddEntry,
		False,
	},
	{
		"DRSUAPI_EXECUTE_KCC",
		sizeof(struct DRSUAPI_EXECUTE_KCC),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_EXECUTE_KCC,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_EXECUTE_KCC,
		(ndr_print_function_t) ndr_print_DRSUAPI_EXECUTE_KCC,
		False,
	},
	{
		"drsuapi_DsReplicaGetInfo",
		sizeof(struct drsuapi_DsReplicaGetInfo),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaGetInfo,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaGetInfo,
		False,
	},
	{
		"DRSUAPI_ADD_SID_HISTORY",
		sizeof(struct DRSUAPI_ADD_SID_HISTORY),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_ADD_SID_HISTORY,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_ADD_SID_HISTORY,
		(ndr_print_function_t) ndr_print_DRSUAPI_ADD_SID_HISTORY,
		False,
	},
	{
		"drsuapi_DsGetMemberships2",
		sizeof(struct drsuapi_DsGetMemberships2),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetMemberships2,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetMemberships2,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetMemberships2,
		False,
	},
	{
		"DRSUAPI_REPLICA_VERIFY_OBJECTS",
		sizeof(struct DRSUAPI_REPLICA_VERIFY_OBJECTS),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REPLICA_VERIFY_OBJECTS,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REPLICA_VERIFY_OBJECTS,
		(ndr_print_function_t) ndr_print_DRSUAPI_REPLICA_VERIFY_OBJECTS,
		False,
	},
	{
		"DRSUAPI_GET_OBJECT_EXISTENCE",
		sizeof(struct DRSUAPI_GET_OBJECT_EXISTENCE),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_GET_OBJECT_EXISTENCE,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_GET_OBJECT_EXISTENCE,
		(ndr_print_function_t) ndr_print_DRSUAPI_GET_OBJECT_EXISTENCE,
		False,
	},
	{
		"DRSUAPI_QUERY_SITES_BY_COST",
		sizeof(struct DRSUAPI_QUERY_SITES_BY_COST),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_QUERY_SITES_BY_COST,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_QUERY_SITES_BY_COST,
		(ndr_print_function_t) ndr_print_DRSUAPI_QUERY_SITES_BY_COST,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const drsuapi_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\lsass]", 
	"ncacn_np:[\\pipe\\protected_storage]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct dcerpc_endpoint_list drsuapi_endpoints = {
	.count	= 4,
	.names	= drsuapi_endpoint_strings
};

static const char * const drsuapi_authservice_strings[] = {
	"ldap", 
};

static const struct dcerpc_authservice_list drsuapi_authservices = {
	.count	= 4,
	.names	= drsuapi_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_drsuapi = {
	.name		= "drsuapi",
	.syntax_id	= {
		{0xe3514235,0x4b06,0x11d1,{0xab,0x04},{0x00,0xc0,0x4f,0xc2,0xdc,0xd2}},
		DCERPC_DRSUAPI_VERSION
	},
	.helpstring	= DCERPC_DRSUAPI_HELPSTRING,
	.num_calls	= 25,
	.calls		= drsuapi_calls,
	.endpoints	= &drsuapi_endpoints,
	.authservices	= &drsuapi_authservices
};

