/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_dcom.h"

/* dcom_Unknown - dcerpc server boilerplate generated by pidl */


static NTSTATUS dcom_Unknown__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_DCOM_UNKNOWN_BIND
	return DCESRV_INTERFACE_DCOM_UNKNOWN_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void dcom_Unknown__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_DCOM_UNKNOWN_UNBIND
	DCESRV_INTERFACE_DCOM_UNKNOWN_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS dcom_Unknown__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_dcom_Unknown.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_dcom_Unknown.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_dcom_Unknown.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_dcom_Unknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS dcom_Unknown__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct UseProtSeq *r2 = (struct UseProtSeq *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(UseProtSeq, NDR_IN, r2);
		}
		dcesrv_UseProtSeq(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function UseProtSeq will reply async\n"));
		}
		break;
	}
	case 1: {
		struct GetCustomProtseqInfo *r2 = (struct GetCustomProtseqInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetCustomProtseqInfo, NDR_IN, r2);
		}
		dcesrv_GetCustomProtseqInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetCustomProtseqInfo will reply async\n"));
		}
		break;
	}
	case 2: {
		struct UpdateResolverBindings *r2 = (struct UpdateResolverBindings *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(UpdateResolverBindings, NDR_IN, r2);
		}
		dcesrv_UpdateResolverBindings(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function UpdateResolverBindings will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_dcom_Unknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS dcom_Unknown__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct UseProtSeq *r2 = (struct UseProtSeq *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function UseProtSeq replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(UseProtSeq, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in UseProtSeq\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct GetCustomProtseqInfo *r2 = (struct GetCustomProtseqInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetCustomProtseqInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetCustomProtseqInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetCustomProtseqInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct UpdateResolverBindings *r2 = (struct UpdateResolverBindings *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function UpdateResolverBindings replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(UpdateResolverBindings, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in UpdateResolverBindings\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_dcom_Unknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS dcom_Unknown__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_dcom_Unknown.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_dcom_Unknown_interface = {
	.name		= "dcom_Unknown",
	.syntax_id  = {{0x18f70770,0x8e64,0x11cf,{0x9a,0xf1},{0x00,0x20,0xaf,0x6e,0x72,0xf4}},0.0},
	.bind		= dcom_Unknown__op_bind,
	.unbind		= dcom_Unknown__op_unbind,
	.ndr_pull	= dcom_Unknown__op_ndr_pull,
	.dispatch	= dcom_Unknown__op_dispatch,
	.reply		= dcom_Unknown__op_reply,
	.ndr_push	= dcom_Unknown__op_ndr_push
};


static NTSTATUS dcom_Unknown__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_dcom_Unknown.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_dcom_Unknown.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_dcom_Unknown_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("dcom_Unknown_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL dcom_Unknown__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_dcom_Unknown_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_dcom_Unknown_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_dcom_Unknown_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL dcom_Unknown__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_dcom_Unknown_interface.name, name)==0) {
		memcpy(iface, &dcesrv_dcom_Unknown_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_dcom_Unknown_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "dcom_Unknown";

	/* fill in all the operations */
	ep_server.init_server = dcom_Unknown__op_init_server;

	ep_server.interface_by_uuid = dcom_Unknown__op_interface_by_uuid;
	ep_server.interface_by_name = dcom_Unknown__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'dcom_Unknown' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* IMachineLocalActivator - dcerpc server boilerplate generated by pidl */


static NTSTATUS IMachineLocalActivator__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IMACHINELOCALACTIVATOR_BIND
	return DCESRV_INTERFACE_IMACHINELOCALACTIVATOR_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IMachineLocalActivator__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IMACHINELOCALACTIVATOR_UNBIND
	DCESRV_INTERFACE_IMACHINELOCALACTIVATOR_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IMachineLocalActivator__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IMachineLocalActivator.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IMachineLocalActivator.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IMachineLocalActivator.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IMachineLocalActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IMachineLocalActivator__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct IMachineLocalActivator_foo *r2 = (struct IMachineLocalActivator_foo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(IMachineLocalActivator_foo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_IMachineLocalActivator_foo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function IMachineLocalActivator_foo will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IMachineLocalActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IMachineLocalActivator__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct IMachineLocalActivator_foo *r2 = (struct IMachineLocalActivator_foo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function IMachineLocalActivator_foo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(IMachineLocalActivator_foo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in IMachineLocalActivator_foo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IMachineLocalActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IMachineLocalActivator__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IMachineLocalActivator.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_IMachineLocalActivator_interface = {
	.name		= "IMachineLocalActivator",
	.syntax_id  = {{0xc6f3ee72,0xce7e,0x11d1,{0xb7,0x1e},{0x00,0xc0,0x4f,0xc3,0x11,0x1a}},0.0},
	.bind		= IMachineLocalActivator__op_bind,
	.unbind		= IMachineLocalActivator__op_unbind,
	.ndr_pull	= IMachineLocalActivator__op_ndr_pull,
	.dispatch	= IMachineLocalActivator__op_dispatch,
	.reply		= IMachineLocalActivator__op_reply,
	.ndr_push	= IMachineLocalActivator__op_ndr_push
};


static NTSTATUS IMachineLocalActivator__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IMachineLocalActivator.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IMachineLocalActivator.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_IMachineLocalActivator_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IMachineLocalActivator_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IMachineLocalActivator__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_IMachineLocalActivator_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_IMachineLocalActivator_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_IMachineLocalActivator_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IMachineLocalActivator__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_IMachineLocalActivator_interface.name, name)==0) {
		memcpy(iface, &dcesrv_IMachineLocalActivator_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IMachineLocalActivator_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IMachineLocalActivator";

	/* fill in all the operations */
	ep_server.init_server = IMachineLocalActivator__op_init_server;

	ep_server.interface_by_uuid = IMachineLocalActivator__op_interface_by_uuid;
	ep_server.interface_by_name = IMachineLocalActivator__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IMachineLocalActivator' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* ILocalObjectExporter - dcerpc server boilerplate generated by pidl */


static NTSTATUS ILocalObjectExporter__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ILOCALOBJECTEXPORTER_BIND
	return DCESRV_INTERFACE_ILOCALOBJECTEXPORTER_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ILocalObjectExporter__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ILOCALOBJECTEXPORTER_UNBIND
	DCESRV_INTERFACE_ILOCALOBJECTEXPORTER_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ILocalObjectExporter__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_ILocalObjectExporter.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_ILocalObjectExporter.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_ILocalObjectExporter.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_ILocalObjectExporter, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ILocalObjectExporter__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct ILocalObjectExporter_Foo *r2 = (struct ILocalObjectExporter_Foo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(ILocalObjectExporter_Foo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_ILocalObjectExporter_Foo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ILocalObjectExporter_Foo will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ILocalObjectExporter, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ILocalObjectExporter__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct ILocalObjectExporter_Foo *r2 = (struct ILocalObjectExporter_Foo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ILocalObjectExporter_Foo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ILocalObjectExporter_Foo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ILocalObjectExporter_Foo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ILocalObjectExporter, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ILocalObjectExporter__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_ILocalObjectExporter.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_ILocalObjectExporter_interface = {
	.name		= "ILocalObjectExporter",
	.syntax_id  = {{0xe60c73e6,0x88f9,0x11cf,{0x9a,0xf1},{0x00,0x20,0xaf,0x6e,0x72,0xf4}},0.0},
	.bind		= ILocalObjectExporter__op_bind,
	.unbind		= ILocalObjectExporter__op_unbind,
	.ndr_pull	= ILocalObjectExporter__op_ndr_pull,
	.dispatch	= ILocalObjectExporter__op_dispatch,
	.reply		= ILocalObjectExporter__op_reply,
	.ndr_push	= ILocalObjectExporter__op_ndr_push
};


static NTSTATUS ILocalObjectExporter__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_ILocalObjectExporter.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_ILocalObjectExporter.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_ILocalObjectExporter_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ILocalObjectExporter_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL ILocalObjectExporter__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_ILocalObjectExporter_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_ILocalObjectExporter_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_ILocalObjectExporter_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL ILocalObjectExporter__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_ILocalObjectExporter_interface.name, name)==0) {
		memcpy(iface, &dcesrv_ILocalObjectExporter_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_ILocalObjectExporter_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ILocalObjectExporter";

	/* fill in all the operations */
	ep_server.init_server = ILocalObjectExporter__op_init_server;

	ep_server.interface_by_uuid = ILocalObjectExporter__op_interface_by_uuid;
	ep_server.interface_by_name = ILocalObjectExporter__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ILocalObjectExporter' endpoint server!\n"));
		return ret;
	}

	return ret;
}

