/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_dcom.h"

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_UseProtSeq(struct ndr_push *ndr, int flags, const struct UseProtSeq *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_UseProtSeq(struct ndr_pull *ndr, int flags, struct UseProtSeq *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_UseProtSeq(struct ndr_print *ndr, const char *name, int flags, const struct UseProtSeq *r)
{
	ndr_print_struct(ndr, name, "UseProtSeq");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "UseProtSeq");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "UseProtSeq");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_GetCustomProtseqInfo(struct ndr_push *ndr, int flags, const struct GetCustomProtseqInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_GetCustomProtseqInfo(struct ndr_pull *ndr, int flags, struct GetCustomProtseqInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_GetCustomProtseqInfo(struct ndr_print *ndr, const char *name, int flags, const struct GetCustomProtseqInfo *r)
{
	ndr_print_struct(ndr, name, "GetCustomProtseqInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetCustomProtseqInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetCustomProtseqInfo");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_UpdateResolverBindings(struct ndr_push *ndr, int flags, const struct UpdateResolverBindings *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_UpdateResolverBindings(struct ndr_pull *ndr, int flags, struct UpdateResolverBindings *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_UpdateResolverBindings(struct ndr_print *ndr, const char *name, int flags, const struct UpdateResolverBindings *r)
{
	ndr_print_struct(ndr, name, "UpdateResolverBindings");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "UpdateResolverBindings");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "UpdateResolverBindings");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call dcom_Unknown_calls[] = {
	{
		"UseProtSeq",
		sizeof(struct UseProtSeq),
		(ndr_push_flags_fn_t) ndr_push_UseProtSeq,
		(ndr_pull_flags_fn_t) ndr_pull_UseProtSeq,
		(ndr_print_function_t) ndr_print_UseProtSeq,
		False,
	},
	{
		"GetCustomProtseqInfo",
		sizeof(struct GetCustomProtseqInfo),
		(ndr_push_flags_fn_t) ndr_push_GetCustomProtseqInfo,
		(ndr_pull_flags_fn_t) ndr_pull_GetCustomProtseqInfo,
		(ndr_print_function_t) ndr_print_GetCustomProtseqInfo,
		False,
	},
	{
		"UpdateResolverBindings",
		sizeof(struct UpdateResolverBindings),
		(ndr_push_flags_fn_t) ndr_push_UpdateResolverBindings,
		(ndr_pull_flags_fn_t) ndr_pull_UpdateResolverBindings,
		(ndr_print_function_t) ndr_print_UpdateResolverBindings,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const dcom_Unknown_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\dcom_Unknown]", 
};

static const struct dcerpc_endpoint_list dcom_Unknown_endpoints = {
	.count	= 1,
	.names	= dcom_Unknown_endpoint_strings
};

static const char * const dcom_Unknown_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list dcom_Unknown_authservices = {
	.count	= 1,
	.names	= dcom_Unknown_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_dcom_Unknown = {
	.name		= "dcom_Unknown",
	.syntax_id	= {
		{0x18f70770,0x8e64,0x11cf,{0x9a,0xf1},{0x00,0x20,0xaf,0x6e,0x72,0xf4}},
		DCERPC_DCOM_UNKNOWN_VERSION
	},
	.helpstring	= DCERPC_DCOM_UNKNOWN_HELPSTRING,
	.num_calls	= 3,
	.calls		= dcom_Unknown_calls,
	.endpoints	= &dcom_Unknown_endpoints,
	.authservices	= &dcom_Unknown_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_QueryInterface(struct ndr_push *ndr, int flags, const struct QueryInterface *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.iid));
		if (r->in.iid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.iid));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.data == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.data == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.data));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_QueryInterface(struct ndr_pull *ndr, int flags, struct QueryInterface *r)
{
	uint32_t _ptr_iid;
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_iid_0;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_data_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_iid));
		if (_ptr_iid) {
			NDR_PULL_ALLOC(ndr, r->in.iid);
		} else {
			r->in.iid = NULL;
		}
		if (r->in.iid) {
			_mem_save_iid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.iid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.iid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iid_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.data);
		ZERO_STRUCTP(r->out.data);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_data));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.data);
		}
		_mem_save_data_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_QueryInterface(struct ndr_print *ndr, const char *name, int flags, const struct QueryInterface *r)
{
	ndr_print_struct(ndr, name, "QueryInterface");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "QueryInterface");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "iid", r->in.iid);
		ndr->depth++;
		if (r->in.iid) {
			ndr_print_GUID(ndr, "iid", r->in.iid);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "QueryInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_ptr(ndr, "data", *r->out.data);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "data", *r->out.data);
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_AddRef(struct ndr_push *ndr, int flags, const struct AddRef *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_AddRef(struct ndr_pull *ndr, int flags, struct AddRef *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_AddRef(struct ndr_print *ndr, const char *name, int flags, const struct AddRef *r)
{
	ndr_print_struct(ndr, name, "AddRef");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "AddRef");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "AddRef");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_Release(struct ndr_push *ndr, int flags, const struct Release *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_Release(struct ndr_pull *ndr, int flags, struct Release *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_Release(struct ndr_print *ndr, const char *name, int flags, const struct Release *r)
{
	ndr_print_struct(ndr, name, "Release");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Release");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Release");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IUnknown_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IUnknown_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IUnknown]", 
};

static const struct dcerpc_endpoint_list IUnknown_endpoints = {
	.count	= 1,
	.names	= IUnknown_endpoint_strings
};

static const char * const IUnknown_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IUnknown_authservices = {
	.count	= 1,
	.names	= IUnknown_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IUnknown = {
	.name		= "IUnknown",
	.syntax_id	= {
		{0x00000000,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_IUNKNOWN_VERSION
	},
	.helpstring	= DCERPC_IUNKNOWN_HELPSTRING,
	.num_calls	= 3,
	.calls		= IUnknown_calls,
	.endpoints	= &IUnknown_endpoints,
	.authservices	= &IUnknown_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_CreateInstance(struct ndr_push *ndr, int flags, const struct CreateInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pUnknown));
		if (r->in.pUnknown) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pUnknown));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.iid));
		if (r->in.iid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.iid));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppv == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.ppv == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppv));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_CreateInstance(struct ndr_pull *ndr, int flags, struct CreateInstance *r)
{
	uint32_t _ptr_pUnknown;
	uint32_t _ptr_iid;
	uint32_t _ptr_ppv;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pUnknown_0;
	TALLOC_CTX *_mem_save_iid_0;
	TALLOC_CTX *_mem_save_ppv_0;
	TALLOC_CTX *_mem_save_ppv_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pUnknown));
		if (_ptr_pUnknown) {
			NDR_PULL_ALLOC(ndr, r->in.pUnknown);
		} else {
			r->in.pUnknown = NULL;
		}
		if (r->in.pUnknown) {
			_mem_save_pUnknown_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pUnknown, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pUnknown));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUnknown_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_iid));
		if (_ptr_iid) {
			NDR_PULL_ALLOC(ndr, r->in.iid);
		} else {
			r->in.iid = NULL;
		}
		if (r->in.iid) {
			_mem_save_iid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.iid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.iid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iid_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppv);
		ZERO_STRUCTP(r->out.ppv);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppv);
		}
		_mem_save_ppv_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppv, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_ppv));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.ppv);
		}
		_mem_save_ppv_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppv, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppv));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppv_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppv_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_CreateInstance(struct ndr_print *ndr, const char *name, int flags, const struct CreateInstance *r)
{
	ndr_print_struct(ndr, name, "CreateInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "CreateInstance");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "pUnknown", r->in.pUnknown);
		ndr->depth++;
		if (r->in.pUnknown) {
			ndr_print_MInterfacePointer(ndr, "pUnknown", r->in.pUnknown);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "iid", r->in.iid);
		ndr->depth++;
		if (r->in.iid) {
			ndr_print_GUID(ndr, "iid", r->in.iid);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "CreateInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppv", r->out.ppv);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppv", *r->out.ppv);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "ppv", *r->out.ppv);
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_RemoteCreateInstance(struct ndr_push *ndr, int flags, const struct RemoteCreateInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_RemoteCreateInstance(struct ndr_pull *ndr, int flags, struct RemoteCreateInstance *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_RemoteCreateInstance(struct ndr_print *ndr, const char *name, int flags, const struct RemoteCreateInstance *r)
{
	ndr_print_struct(ndr, name, "RemoteCreateInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemoteCreateInstance");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemoteCreateInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_LockServer(struct ndr_push *ndr, int flags, const struct LockServer *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.lock));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_LockServer(struct ndr_pull *ndr, int flags, struct LockServer *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.lock));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_LockServer(struct ndr_print *ndr, const char *name, int flags, const struct LockServer *r)
{
	ndr_print_struct(ndr, name, "LockServer");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "LockServer");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint8(ndr, "lock", r->in.lock);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "LockServer");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_RemoteLockServer(struct ndr_push *ndr, int flags, const struct RemoteLockServer *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_RemoteLockServer(struct ndr_pull *ndr, int flags, struct RemoteLockServer *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_RemoteLockServer(struct ndr_print *ndr, const char *name, int flags, const struct RemoteLockServer *r)
{
	ndr_print_struct(ndr, name, "RemoteLockServer");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemoteLockServer");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemoteLockServer");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IClassFactory_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"CreateInstance",
		sizeof(struct CreateInstance),
		(ndr_push_flags_fn_t) ndr_push_CreateInstance,
		(ndr_pull_flags_fn_t) ndr_pull_CreateInstance,
		(ndr_print_function_t) ndr_print_CreateInstance,
		False,
	},
	{
		"RemoteCreateInstance",
		sizeof(struct RemoteCreateInstance),
		(ndr_push_flags_fn_t) ndr_push_RemoteCreateInstance,
		(ndr_pull_flags_fn_t) ndr_pull_RemoteCreateInstance,
		(ndr_print_function_t) ndr_print_RemoteCreateInstance,
		False,
	},
	{
		"LockServer",
		sizeof(struct LockServer),
		(ndr_push_flags_fn_t) ndr_push_LockServer,
		(ndr_pull_flags_fn_t) ndr_pull_LockServer,
		(ndr_print_function_t) ndr_print_LockServer,
		False,
	},
	{
		"RemoteLockServer",
		sizeof(struct RemoteLockServer),
		(ndr_push_flags_fn_t) ndr_push_RemoteLockServer,
		(ndr_pull_flags_fn_t) ndr_pull_RemoteLockServer,
		(ndr_print_function_t) ndr_print_RemoteLockServer,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IClassFactory_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IClassFactory]", 
};

static const struct dcerpc_endpoint_list IClassFactory_endpoints = {
	.count	= 1,
	.names	= IClassFactory_endpoint_strings
};

static const char * const IClassFactory_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IClassFactory_authservices = {
	.count	= 1,
	.names	= IClassFactory_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IClassFactory = {
	.name		= "IClassFactory",
	.syntax_id	= {
		{0x00000001,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_ICLASSFACTORY_VERSION
	},
	.helpstring	= DCERPC_ICLASSFACTORY_HELPSTRING,
	.num_calls	= 7,
	.calls		= IClassFactory_calls,
	.endpoints	= &IClassFactory_endpoints,
	.authservices	= &IClassFactory_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
_PUBLIC_ NTSTATUS ndr_push_REMQIRESULT(struct ndr_push *ndr, int ndr_flags, const struct REMQIRESULT *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->hResult));
		NDR_CHECK(ndr_push_STDOBJREF(ndr, NDR_SCALARS, &r->std));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_STDOBJREF(ndr, NDR_BUFFERS, &r->std));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_REMQIRESULT(struct ndr_pull *ndr, int ndr_flags, struct REMQIRESULT *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->hResult));
		NDR_CHECK(ndr_pull_STDOBJREF(ndr, NDR_SCALARS, &r->std));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_STDOBJREF(ndr, NDR_BUFFERS, &r->std));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_REMQIRESULT(struct ndr_print *ndr, const char *name, const struct REMQIRESULT *r)
{
	ndr_print_struct(ndr, name, "REMQIRESULT");
	ndr->depth++;
	ndr_print_WERROR(ndr, "hResult", r->hResult);
	ndr_print_STDOBJREF(ndr, "std", &r->std);
	ndr->depth--;
}

static NTSTATUS ndr_push_REMINTERFACEREF(struct ndr_push *ndr, int ndr_flags, const struct REMINTERFACEREF *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->ipid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cPublicRefs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cPrivateRefs));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->ipid));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_REMINTERFACEREF(struct ndr_pull *ndr, int ndr_flags, struct REMINTERFACEREF *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->ipid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cPublicRefs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cPrivateRefs));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->ipid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_REMINTERFACEREF(struct ndr_print *ndr, const char *name, const struct REMINTERFACEREF *r)
{
	ndr_print_struct(ndr, name, "REMINTERFACEREF");
	ndr->depth++;
	ndr_print_GUID(ndr, "ipid", &r->ipid);
	ndr_print_uint32(ndr, "cPublicRefs", r->cPublicRefs);
	ndr_print_uint32(ndr, "cPrivateRefs", r->cPrivateRefs);
	ndr->depth--;
}

static NTSTATUS ndr_push_RemQueryInterface(struct ndr_push *ndr, int flags, const struct RemQueryInterface *r)
{
	uint32_t cntr_iids_1;
	uint32_t cntr_ip_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ripid));
		if (r->in.ripid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ripid));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cRefs));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.cIids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.iids));
		if (r->in.iids) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cIids));
			for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
				NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.iids[cntr_iids_1]));
			}
			for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
				NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->in.iids[cntr_iids_1]));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ip == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cIids));
		for (cntr_ip_1 = 0; cntr_ip_1 < r->in.cIids; cntr_ip_1++) {
			if (r->out.ip[cntr_ip_1] == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
			NDR_CHECK(ndr_push_ref_ptr(ndr));
		}
		for (cntr_ip_1 = 0; cntr_ip_1 < r->in.cIids; cntr_ip_1++) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ip[cntr_ip_1]));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_RemQueryInterface(struct ndr_pull *ndr, int flags, struct RemQueryInterface *r)
{
	uint32_t _ptr_ripid;
	uint32_t _ptr_iids;
	uint32_t cntr_iids_1;
	uint32_t _ptr_ip;
	uint32_t cntr_ip_1;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ripid_0;
	TALLOC_CTX *_mem_save_iids_0;
	TALLOC_CTX *_mem_save_iids_1;
	TALLOC_CTX *_mem_save_ip_1;
	TALLOC_CTX *_mem_save_ip_2;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ripid));
		if (_ptr_ripid) {
			NDR_PULL_ALLOC(ndr, r->in.ripid);
		} else {
			r->in.ripid = NULL;
		}
		if (r->in.ripid) {
			_mem_save_ripid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ripid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ripid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ripid_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cRefs));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.cIids));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_iids));
		if (_ptr_iids) {
			NDR_PULL_ALLOC(ndr, r->in.iids);
		} else {
			r->in.iids = NULL;
		}
		if (r->in.iids) {
			_mem_save_iids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.iids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.iids));
			NDR_PULL_ALLOC_N(ndr, r->in.iids, ndr_get_array_size(ndr, &r->in.iids));
			_mem_save_iids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.iids, 0);
			for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
				NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.iids[cntr_iids_1]));
			}
			for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
				NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->in.iids[cntr_iids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iids_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC_N(ndr, r->out.ip, r->in.cIids);
		memset(r->out.ip, 0, r->in.cIids * sizeof(*r->out.ip));
		if (r->in.iids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.iids, r->in.cIids));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ip));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.ip, ndr_get_array_size(ndr, &r->out.ip));
		}
		_mem_save_ip_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ip, 0);
		for (cntr_ip_1 = 0; cntr_ip_1 < r->in.cIids; cntr_ip_1++) {
			NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_ip));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->out.ip[cntr_ip_1]);
			}
		}
		for (cntr_ip_1 = 0; cntr_ip_1 < r->in.cIids; cntr_ip_1++) {
			_mem_save_ip_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ip[cntr_ip_1], LIBNDR_FLAG_REF_ALLOC);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ip[cntr_ip_1]));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ip_2, LIBNDR_FLAG_REF_ALLOC);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ip_1, 0);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.ip) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.ip, r->in.cIids));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_RemQueryInterface(struct ndr_print *ndr, const char *name, int flags, const struct RemQueryInterface *r)
{
	uint32_t cntr_iids_1;
	uint32_t cntr_ip_1;
	ndr_print_struct(ndr, name, "RemQueryInterface");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemQueryInterface");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "ripid", r->in.ripid);
		ndr->depth++;
		if (r->in.ripid) {
			ndr_print_GUID(ndr, "ripid", r->in.ripid);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cRefs", r->in.cRefs);
		ndr_print_uint16(ndr, "cIids", r->in.cIids);
		ndr_print_ptr(ndr, "iids", r->in.iids);
		ndr->depth++;
		if (r->in.iids) {
			ndr->print(ndr, "%s: ARRAY(%d)", "iids", r->in.cIids);
			ndr->depth++;
			for (cntr_iids_1=0;cntr_iids_1<r->in.cIids;cntr_iids_1++) {
				char *idx_1=NULL;
				asprintf(&idx_1, "[%d]", cntr_iids_1);
				if (idx_1) {
					ndr_print_GUID(ndr, "iids", &r->in.iids[cntr_iids_1]);
					free(idx_1);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemQueryInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ip", r->out.ip);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "ip", r->in.cIids);
		ndr->depth++;
		for (cntr_ip_1=0;cntr_ip_1<r->in.cIids;cntr_ip_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_ip_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "ip", r->out.ip[cntr_ip_1]);
				ndr->depth++;
				ndr_print_MInterfacePointer(ndr, "ip", r->out.ip[cntr_ip_1]);
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_RemAddRef(struct ndr_push *ndr, int flags, const struct RemAddRef *r)
{
	uint32_t cntr_InterfaceRefs_0;
	uint32_t cntr_pResults_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.cInterfaceRefs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cInterfaceRefs));
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_push_REMINTERFACEREF(ndr, NDR_SCALARS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_push_REMINTERFACEREF(ndr, NDR_BUFFERS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.pResults == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cInterfaceRefs));
		for (cntr_pResults_1 = 0; cntr_pResults_1 < r->in.cInterfaceRefs; cntr_pResults_1++) {
			if (r->out.pResults[cntr_pResults_1] == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
			NDR_CHECK(ndr_push_ref_ptr(ndr));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_RemAddRef(struct ndr_pull *ndr, int flags, struct RemAddRef *r)
{
	uint32_t cntr_InterfaceRefs_0;
	uint32_t _ptr_pResults;
	uint32_t cntr_pResults_1;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_InterfaceRefs_0;
	TALLOC_CTX *_mem_save_pResults_1;
	TALLOC_CTX *_mem_save_pResults_2;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.cInterfaceRefs));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.InterfaceRefs));
		NDR_PULL_ALLOC_N(ndr, r->in.InterfaceRefs, ndr_get_array_size(ndr, &r->in.InterfaceRefs));
		_mem_save_InterfaceRefs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.InterfaceRefs, 0);
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_pull_REMINTERFACEREF(ndr, NDR_SCALARS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_pull_REMINTERFACEREF(ndr, NDR_BUFFERS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_InterfaceRefs_0, 0);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC_N(ndr, r->out.pResults, r->in.cInterfaceRefs);
		memset(r->out.pResults, 0, r->in.cInterfaceRefs * sizeof(*r->out.pResults));
		if (r->in.InterfaceRefs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.InterfaceRefs, r->in.cInterfaceRefs));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pResults));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pResults, ndr_get_array_size(ndr, &r->out.pResults));
		}
		_mem_save_pResults_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pResults, 0);
		for (cntr_pResults_1 = 0; cntr_pResults_1 < r->in.cInterfaceRefs; cntr_pResults_1++) {
			NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_pResults));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->out.pResults[cntr_pResults_1]);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResults_1, 0);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pResults) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.pResults, r->in.cInterfaceRefs));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_RemAddRef(struct ndr_print *ndr, const char *name, int flags, const struct RemAddRef *r)
{
	uint32_t cntr_InterfaceRefs_0;
	uint32_t cntr_pResults_1;
	ndr_print_struct(ndr, name, "RemAddRef");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemAddRef");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint16(ndr, "cInterfaceRefs", r->in.cInterfaceRefs);
		ndr->print(ndr, "%s: ARRAY(%d)", "InterfaceRefs", r->in.cInterfaceRefs);
		ndr->depth++;
		for (cntr_InterfaceRefs_0=0;cntr_InterfaceRefs_0<r->in.cInterfaceRefs;cntr_InterfaceRefs_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_InterfaceRefs_0);
			if (idx_0) {
				ndr_print_REMINTERFACEREF(ndr, "InterfaceRefs", &r->in.InterfaceRefs[cntr_InterfaceRefs_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemAddRef");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResults", r->out.pResults);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "pResults", r->in.cInterfaceRefs);
		ndr->depth++;
		for (cntr_pResults_1=0;cntr_pResults_1<r->in.cInterfaceRefs;cntr_pResults_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_pResults_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "pResults", r->out.pResults[cntr_pResults_1]);
				ndr->depth++;
				ndr_print_WERROR(ndr, "pResults", *r->out.pResults[cntr_pResults_1]);
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_RemRelease(struct ndr_push *ndr, int flags, const struct RemRelease *r)
{
	uint32_t cntr_InterfaceRefs_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.cInterfaceRefs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cInterfaceRefs));
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_push_REMINTERFACEREF(ndr, NDR_SCALARS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_push_REMINTERFACEREF(ndr, NDR_BUFFERS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_RemRelease(struct ndr_pull *ndr, int flags, struct RemRelease *r)
{
	uint32_t cntr_InterfaceRefs_0;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_InterfaceRefs_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.cInterfaceRefs));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.InterfaceRefs));
		NDR_PULL_ALLOC_N(ndr, r->in.InterfaceRefs, ndr_get_array_size(ndr, &r->in.InterfaceRefs));
		_mem_save_InterfaceRefs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.InterfaceRefs, 0);
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_pull_REMINTERFACEREF(ndr, NDR_SCALARS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
		for (cntr_InterfaceRefs_0 = 0; cntr_InterfaceRefs_0 < r->in.cInterfaceRefs; cntr_InterfaceRefs_0++) {
			NDR_CHECK(ndr_pull_REMINTERFACEREF(ndr, NDR_BUFFERS, &r->in.InterfaceRefs[cntr_InterfaceRefs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_InterfaceRefs_0, 0);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		if (r->in.InterfaceRefs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.InterfaceRefs, r->in.cInterfaceRefs));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_RemRelease(struct ndr_print *ndr, const char *name, int flags, const struct RemRelease *r)
{
	uint32_t cntr_InterfaceRefs_0;
	ndr_print_struct(ndr, name, "RemRelease");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemRelease");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint16(ndr, "cInterfaceRefs", r->in.cInterfaceRefs);
		ndr->print(ndr, "%s: ARRAY(%d)", "InterfaceRefs", r->in.cInterfaceRefs);
		ndr->depth++;
		for (cntr_InterfaceRefs_0=0;cntr_InterfaceRefs_0<r->in.cInterfaceRefs;cntr_InterfaceRefs_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_InterfaceRefs_0);
			if (idx_0) {
				ndr_print_REMINTERFACEREF(ndr, "InterfaceRefs", &r->in.InterfaceRefs[cntr_InterfaceRefs_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemRelease");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IRemUnknown_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"RemQueryInterface",
		sizeof(struct RemQueryInterface),
		(ndr_push_flags_fn_t) ndr_push_RemQueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_RemQueryInterface,
		(ndr_print_function_t) ndr_print_RemQueryInterface,
		False,
	},
	{
		"RemAddRef",
		sizeof(struct RemAddRef),
		(ndr_push_flags_fn_t) ndr_push_RemAddRef,
		(ndr_pull_flags_fn_t) ndr_pull_RemAddRef,
		(ndr_print_function_t) ndr_print_RemAddRef,
		False,
	},
	{
		"RemRelease",
		sizeof(struct RemRelease),
		(ndr_push_flags_fn_t) ndr_push_RemRelease,
		(ndr_pull_flags_fn_t) ndr_pull_RemRelease,
		(ndr_print_function_t) ndr_print_RemRelease,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IRemUnknown_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IRemUnknown]", 
};

static const struct dcerpc_endpoint_list IRemUnknown_endpoints = {
	.count	= 1,
	.names	= IRemUnknown_endpoint_strings
};

static const char * const IRemUnknown_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IRemUnknown_authservices = {
	.count	= 1,
	.names	= IRemUnknown_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IRemUnknown = {
	.name		= "IRemUnknown",
	.syntax_id	= {
		{0x00000131,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_IREMUNKNOWN_VERSION
	},
	.helpstring	= DCERPC_IREMUNKNOWN_HELPSTRING,
	.num_calls	= 6,
	.calls		= IRemUnknown_calls,
	.endpoints	= &IRemUnknown_endpoints,
	.authservices	= &IRemUnknown_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_GetClassObject(struct ndr_push *ndr, int flags, const struct GetClassObject *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.clsid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.context));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.locale));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.iid));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.data == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.data));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_GetClassObject(struct ndr_pull *ndr, int flags, struct GetClassObject *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_data_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.clsid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.context));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.locale));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.iid));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.data);
		ZERO_STRUCTP(r->out.data);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_GetClassObject(struct ndr_print *ndr, const char *name, int flags, const struct GetClassObject *r)
{
	ndr_print_struct(ndr, name, "GetClassObject");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetClassObject");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_GUID(ndr, "clsid", &r->in.clsid);
		ndr_print_uint32(ndr, "context", r->in.context);
		ndr_print_uint32(ndr, "locale", r->in.locale);
		ndr_print_GUID(ndr, "iid", &r->in.iid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetClassObject");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "data", r->out.data);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IClassActivator_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"GetClassObject",
		sizeof(struct GetClassObject),
		(ndr_push_flags_fn_t) ndr_push_GetClassObject,
		(ndr_pull_flags_fn_t) ndr_pull_GetClassObject,
		(ndr_print_function_t) ndr_print_GetClassObject,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IClassActivator_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IClassActivator]", 
};

static const struct dcerpc_endpoint_list IClassActivator_endpoints = {
	.count	= 1,
	.names	= IClassActivator_endpoint_strings
};

static const char * const IClassActivator_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IClassActivator_authservices = {
	.count	= 1,
	.names	= IClassActivator_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IClassActivator = {
	.name		= "IClassActivator",
	.syntax_id	= {
		{0x00000140,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_ICLASSACTIVATOR_VERSION
	},
	.helpstring	= DCERPC_ICLASSACTIVATOR_HELPSTRING,
	.num_calls	= 4,
	.calls		= IClassActivator_calls,
	.endpoints	= &IClassActivator_endpoints,
	.authservices	= &IClassActivator_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_ISCMLocalActivator_CreateInstance(struct ndr_push *ndr, int flags, const struct ISCMLocalActivator_CreateInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_ISCMLocalActivator_CreateInstance(struct ndr_pull *ndr, int flags, struct ISCMLocalActivator_CreateInstance *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_ISCMLocalActivator_CreateInstance(struct ndr_print *ndr, const char *name, int flags, const struct ISCMLocalActivator_CreateInstance *r)
{
	ndr_print_struct(ndr, name, "ISCMLocalActivator_CreateInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ISCMLocalActivator_CreateInstance");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ISCMLocalActivator_CreateInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call ISCMLocalActivator_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"GetClassObject",
		sizeof(struct GetClassObject),
		(ndr_push_flags_fn_t) ndr_push_GetClassObject,
		(ndr_pull_flags_fn_t) ndr_pull_GetClassObject,
		(ndr_print_function_t) ndr_print_GetClassObject,
		False,
	},
	{
		"ISCMLocalActivator_CreateInstance",
		sizeof(struct ISCMLocalActivator_CreateInstance),
		(ndr_push_flags_fn_t) ndr_push_ISCMLocalActivator_CreateInstance,
		(ndr_pull_flags_fn_t) ndr_pull_ISCMLocalActivator_CreateInstance,
		(ndr_print_function_t) ndr_print_ISCMLocalActivator_CreateInstance,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const ISCMLocalActivator_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ISCMLocalActivator]", 
};

static const struct dcerpc_endpoint_list ISCMLocalActivator_endpoints = {
	.count	= 1,
	.names	= ISCMLocalActivator_endpoint_strings
};

static const char * const ISCMLocalActivator_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list ISCMLocalActivator_authservices = {
	.count	= 1,
	.names	= ISCMLocalActivator_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_ISCMLocalActivator = {
	.name		= "ISCMLocalActivator",
	.syntax_id	= {
		{0x00000136,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_ISCMLOCALACTIVATOR_VERSION
	},
	.helpstring	= DCERPC_ISCMLOCALACTIVATOR_HELPSTRING,
	.num_calls	= 5,
	.calls		= ISCMLocalActivator_calls,
	.endpoints	= &ISCMLocalActivator_endpoints,
	.authservices	= &ISCMLocalActivator_authservices
};

static NTSTATUS ndr_push_IMachineLocalActivator_foo(struct ndr_push *ndr, int flags, const struct IMachineLocalActivator_foo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_IMachineLocalActivator_foo(struct ndr_pull *ndr, int flags, struct IMachineLocalActivator_foo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_IMachineLocalActivator_foo(struct ndr_print *ndr, const char *name, int flags, const struct IMachineLocalActivator_foo *r)
{
	ndr_print_struct(ndr, name, "IMachineLocalActivator_foo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "IMachineLocalActivator_foo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "IMachineLocalActivator_foo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IMachineLocalActivator_calls[] = {
	{
		"IMachineLocalActivator_foo",
		sizeof(struct IMachineLocalActivator_foo),
		(ndr_push_flags_fn_t) ndr_push_IMachineLocalActivator_foo,
		(ndr_pull_flags_fn_t) ndr_pull_IMachineLocalActivator_foo,
		(ndr_print_function_t) ndr_print_IMachineLocalActivator_foo,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IMachineLocalActivator_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IMachineLocalActivator]", 
};

static const struct dcerpc_endpoint_list IMachineLocalActivator_endpoints = {
	.count	= 1,
	.names	= IMachineLocalActivator_endpoint_strings
};

static const char * const IMachineLocalActivator_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IMachineLocalActivator_authservices = {
	.count	= 1,
	.names	= IMachineLocalActivator_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IMachineLocalActivator = {
	.name		= "IMachineLocalActivator",
	.syntax_id	= {
		{0xc6f3ee72,0xce7e,0x11d1,{0xb7,0x1e},{0x00,0xc0,0x4f,0xc3,0x11,0x1a}},
		DCERPC_IMACHINELOCALACTIVATOR_VERSION
	},
	.helpstring	= DCERPC_IMACHINELOCALACTIVATOR_HELPSTRING,
	.num_calls	= 1,
	.calls		= IMachineLocalActivator_calls,
	.endpoints	= &IMachineLocalActivator_endpoints,
	.authservices	= &IMachineLocalActivator_authservices
};

static NTSTATUS ndr_push_ILocalObjectExporter_Foo(struct ndr_push *ndr, int flags, const struct ILocalObjectExporter_Foo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_ILocalObjectExporter_Foo(struct ndr_pull *ndr, int flags, struct ILocalObjectExporter_Foo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_ILocalObjectExporter_Foo(struct ndr_print *ndr, const char *name, int flags, const struct ILocalObjectExporter_Foo *r)
{
	ndr_print_struct(ndr, name, "ILocalObjectExporter_Foo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ILocalObjectExporter_Foo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ILocalObjectExporter_Foo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call ILocalObjectExporter_calls[] = {
	{
		"ILocalObjectExporter_Foo",
		sizeof(struct ILocalObjectExporter_Foo),
		(ndr_push_flags_fn_t) ndr_push_ILocalObjectExporter_Foo,
		(ndr_pull_flags_fn_t) ndr_pull_ILocalObjectExporter_Foo,
		(ndr_print_function_t) ndr_print_ILocalObjectExporter_Foo,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const ILocalObjectExporter_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ILocalObjectExporter]", 
};

static const struct dcerpc_endpoint_list ILocalObjectExporter_endpoints = {
	.count	= 1,
	.names	= ILocalObjectExporter_endpoint_strings
};

static const char * const ILocalObjectExporter_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list ILocalObjectExporter_authservices = {
	.count	= 1,
	.names	= ILocalObjectExporter_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_ILocalObjectExporter = {
	.name		= "ILocalObjectExporter",
	.syntax_id	= {
		{0xe60c73e6,0x88f9,0x11cf,{0x9a,0xf1},{0x00,0x20,0xaf,0x6e,0x72,0xf4}},
		DCERPC_ILOCALOBJECTEXPORTER_VERSION
	},
	.helpstring	= DCERPC_ILOCALOBJECTEXPORTER_HELPSTRING,
	.num_calls	= 1,
	.calls		= ILocalObjectExporter_calls,
	.endpoints	= &ILocalObjectExporter_endpoints,
	.authservices	= &ILocalObjectExporter_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_ISystemActivatorRemoteCreateInstance(struct ndr_push *ndr, int flags, const struct ISystemActivatorRemoteCreateInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.iface1));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.unknown3 == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.unknown3));
		if (r->out.iface2 == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.iface2));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_ISystemActivatorRemoteCreateInstance(struct ndr_pull *ndr, int flags, struct ISystemActivatorRemoteCreateInstance *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_unknown3_0;
	TALLOC_CTX *_mem_save_iface2_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.iface1));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.unknown3);
		ZERO_STRUCTP(r->out.unknown3);
		NDR_PULL_ALLOC(ndr, r->out.iface2);
		ZERO_STRUCTP(r->out.iface2);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.unknown3);
		}
		_mem_save_unknown3_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown3, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.unknown3));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown3_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.iface2);
		}
		_mem_save_iface2_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.iface2, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.iface2));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iface2_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_ISystemActivatorRemoteCreateInstance(struct ndr_print *ndr, const char *name, int flags, const struct ISystemActivatorRemoteCreateInstance *r)
{
	ndr_print_struct(ndr, name, "ISystemActivatorRemoteCreateInstance");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ISystemActivatorRemoteCreateInstance");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_hyper(ndr, "unknown1", r->in.unknown1);
		ndr_print_MInterfacePointer(ndr, "iface1", &r->in.iface1);
		ndr_print_hyper(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ISystemActivatorRemoteCreateInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown3", r->out.unknown3);
		ndr->depth++;
		ndr_print_uint32(ndr, "unknown3", *r->out.unknown3);
		ndr->depth--;
		ndr_print_ptr(ndr, "iface2", r->out.iface2);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "iface2", r->out.iface2);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call ISystemActivator_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"GetClassObject",
		sizeof(struct GetClassObject),
		(ndr_push_flags_fn_t) ndr_push_GetClassObject,
		(ndr_pull_flags_fn_t) ndr_pull_GetClassObject,
		(ndr_print_function_t) ndr_print_GetClassObject,
		False,
	},
	{
		"ISystemActivatorRemoteCreateInstance",
		sizeof(struct ISystemActivatorRemoteCreateInstance),
		(ndr_push_flags_fn_t) ndr_push_ISystemActivatorRemoteCreateInstance,
		(ndr_pull_flags_fn_t) ndr_pull_ISystemActivatorRemoteCreateInstance,
		(ndr_print_function_t) ndr_print_ISystemActivatorRemoteCreateInstance,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const ISystemActivator_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ISystemActivator]", 
};

static const struct dcerpc_endpoint_list ISystemActivator_endpoints = {
	.count	= 1,
	.names	= ISystemActivator_endpoint_strings
};

static const char * const ISystemActivator_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list ISystemActivator_authservices = {
	.count	= 1,
	.names	= ISystemActivator_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_ISystemActivator = {
	.name		= "ISystemActivator",
	.syntax_id	= {
		{0x000001a0,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_ISYSTEMACTIVATOR_VERSION
	},
	.helpstring	= DCERPC_ISYSTEMACTIVATOR_HELPSTRING,
	.num_calls	= 5,
	.calls		= ISystemActivator_calls,
	.endpoints	= &ISystemActivator_endpoints,
	.authservices	= &ISystemActivator_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_RemQueryInterface2(struct ndr_push *ndr, int flags, const struct RemQueryInterface2 *r)
{
	uint32_t cntr_iids_1;
	uint32_t cntr_phr_1;
	uint32_t cntr_ppMIF_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ripid));
		if (r->in.ripid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ripid));
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.cIids));
		if (r->in.iids == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cIids));
		for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
			if (r->in.iids[cntr_iids_1] == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
			NDR_CHECK(ndr_push_ref_ptr(ndr));
		}
		for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.iids[cntr_iids_1]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.phr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cIids));
		for (cntr_phr_1 = 0; cntr_phr_1 < r->in.cIids; cntr_phr_1++) {
			if (r->out.phr[cntr_phr_1] == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
			NDR_CHECK(ndr_push_ref_ptr(ndr));
		}
		if (r->out.ppMIF == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cIids));
		for (cntr_ppMIF_1 = 0; cntr_ppMIF_1 < r->in.cIids; cntr_ppMIF_1++) {
			if (r->out.ppMIF[cntr_ppMIF_1] == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
			NDR_CHECK(ndr_push_ref_ptr(ndr));
		}
		for (cntr_ppMIF_1 = 0; cntr_ppMIF_1 < r->in.cIids; cntr_ppMIF_1++) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppMIF[cntr_ppMIF_1]));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_RemQueryInterface2(struct ndr_pull *ndr, int flags, struct RemQueryInterface2 *r)
{
	uint32_t _ptr_ripid;
	uint32_t _ptr_iids;
	uint32_t cntr_iids_1;
	uint32_t _ptr_phr;
	uint32_t cntr_phr_1;
	uint32_t _ptr_ppMIF;
	uint32_t cntr_ppMIF_1;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ripid_0;
	TALLOC_CTX *_mem_save_iids_1;
	TALLOC_CTX *_mem_save_iids_2;
	TALLOC_CTX *_mem_save_phr_1;
	TALLOC_CTX *_mem_save_phr_2;
	TALLOC_CTX *_mem_save_ppMIF_1;
	TALLOC_CTX *_mem_save_ppMIF_2;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ripid));
		if (_ptr_ripid) {
			NDR_PULL_ALLOC(ndr, r->in.ripid);
		} else {
			r->in.ripid = NULL;
		}
		if (r->in.ripid) {
			_mem_save_ripid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ripid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ripid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ripid_0, 0);
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.cIids));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.iids));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.iids, ndr_get_array_size(ndr, &r->in.iids));
		}
		_mem_save_iids_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.iids, 0);
		for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
			NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_iids));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->in.iids[cntr_iids_1]);
			}
		}
		for (cntr_iids_1 = 0; cntr_iids_1 < r->in.cIids; cntr_iids_1++) {
			_mem_save_iids_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.iids[cntr_iids_1], LIBNDR_FLAG_REF_ALLOC);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.iids[cntr_iids_1]));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iids_2, LIBNDR_FLAG_REF_ALLOC);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_iids_1, 0);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC_N(ndr, r->out.phr, r->in.cIids);
		memset(r->out.phr, 0, r->in.cIids * sizeof(*r->out.phr));
		NDR_PULL_ALLOC_N(ndr, r->out.ppMIF, r->in.cIids);
		memset(r->out.ppMIF, 0, r->in.cIids * sizeof(*r->out.ppMIF));
		if (r->in.iids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.iids, r->in.cIids));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.phr));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.phr, ndr_get_array_size(ndr, &r->out.phr));
		}
		_mem_save_phr_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phr, 0);
		for (cntr_phr_1 = 0; cntr_phr_1 < r->in.cIids; cntr_phr_1++) {
			NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_phr));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->out.phr[cntr_phr_1]);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phr_1, 0);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ppMIF));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.ppMIF, ndr_get_array_size(ndr, &r->out.ppMIF));
		}
		_mem_save_ppMIF_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppMIF, 0);
		for (cntr_ppMIF_1 = 0; cntr_ppMIF_1 < r->in.cIids; cntr_ppMIF_1++) {
			NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_ppMIF));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->out.ppMIF[cntr_ppMIF_1]);
			}
		}
		for (cntr_ppMIF_1 = 0; cntr_ppMIF_1 < r->in.cIids; cntr_ppMIF_1++) {
			_mem_save_ppMIF_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppMIF[cntr_ppMIF_1], LIBNDR_FLAG_REF_ALLOC);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppMIF[cntr_ppMIF_1]));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppMIF_2, LIBNDR_FLAG_REF_ALLOC);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppMIF_1, 0);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.phr) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.phr, r->in.cIids));
		}
		if (r->out.ppMIF) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.ppMIF, r->in.cIids));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_RemQueryInterface2(struct ndr_print *ndr, const char *name, int flags, const struct RemQueryInterface2 *r)
{
	uint32_t cntr_iids_1;
	uint32_t cntr_phr_1;
	uint32_t cntr_ppMIF_1;
	ndr_print_struct(ndr, name, "RemQueryInterface2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemQueryInterface2");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "ripid", r->in.ripid);
		ndr->depth++;
		if (r->in.ripid) {
			ndr_print_GUID(ndr, "ripid", r->in.ripid);
		}
		ndr->depth--;
		ndr_print_uint16(ndr, "cIids", r->in.cIids);
		ndr_print_ptr(ndr, "iids", r->in.iids);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "iids", r->in.cIids);
		ndr->depth++;
		for (cntr_iids_1=0;cntr_iids_1<r->in.cIids;cntr_iids_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_iids_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "iids", r->in.iids[cntr_iids_1]);
				ndr->depth++;
				ndr_print_GUID(ndr, "iids", r->in.iids[cntr_iids_1]);
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemQueryInterface2");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "phr", r->out.phr);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "phr", r->in.cIids);
		ndr->depth++;
		for (cntr_phr_1=0;cntr_phr_1<r->in.cIids;cntr_phr_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_phr_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "phr", r->out.phr[cntr_phr_1]);
				ndr->depth++;
				ndr_print_WERROR(ndr, "phr", *r->out.phr[cntr_phr_1]);
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "ppMIF", r->out.ppMIF);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "ppMIF", r->in.cIids);
		ndr->depth++;
		for (cntr_ppMIF_1=0;cntr_ppMIF_1<r->in.cIids;cntr_ppMIF_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_ppMIF_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "ppMIF", r->out.ppMIF[cntr_ppMIF_1]);
				ndr->depth++;
				ndr_print_MInterfacePointer(ndr, "ppMIF", r->out.ppMIF[cntr_ppMIF_1]);
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IRemUnknown2_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"RemQueryInterface",
		sizeof(struct RemQueryInterface),
		(ndr_push_flags_fn_t) ndr_push_RemQueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_RemQueryInterface,
		(ndr_print_function_t) ndr_print_RemQueryInterface,
		False,
	},
	{
		"RemAddRef",
		sizeof(struct RemAddRef),
		(ndr_push_flags_fn_t) ndr_push_RemAddRef,
		(ndr_pull_flags_fn_t) ndr_pull_RemAddRef,
		(ndr_print_function_t) ndr_print_RemAddRef,
		False,
	},
	{
		"RemRelease",
		sizeof(struct RemRelease),
		(ndr_push_flags_fn_t) ndr_push_RemRelease,
		(ndr_pull_flags_fn_t) ndr_pull_RemRelease,
		(ndr_print_function_t) ndr_print_RemRelease,
		False,
	},
	{
		"RemQueryInterface2",
		sizeof(struct RemQueryInterface2),
		(ndr_push_flags_fn_t) ndr_push_RemQueryInterface2,
		(ndr_pull_flags_fn_t) ndr_pull_RemQueryInterface2,
		(ndr_print_function_t) ndr_print_RemQueryInterface2,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IRemUnknown2_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IRemUnknown2]", 
};

static const struct dcerpc_endpoint_list IRemUnknown2_endpoints = {
	.count	= 1,
	.names	= IRemUnknown2_endpoint_strings
};

static const char * const IRemUnknown2_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IRemUnknown2_authservices = {
	.count	= 1,
	.names	= IRemUnknown2_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IRemUnknown2 = {
	.name		= "IRemUnknown2",
	.syntax_id	= {
		{0x00000143,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_IREMUNKNOWN2_VERSION
	},
	.helpstring	= DCERPC_IREMUNKNOWN2_HELPSTRING,
	.num_calls	= 7,
	.calls		= IRemUnknown2_calls,
	.endpoints	= &IRemUnknown2_endpoints,
	.authservices	= &IRemUnknown2_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_REF_ITypeInfo(struct ndr_push *ndr, int ndr_flags, const struct REF_ITypeInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_REF_ITypeInfo(struct ndr_pull *ndr, int ndr_flags, struct REF_ITypeInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_REF_ITypeInfo(struct ndr_print *ndr, const char *name, const struct REF_ITypeInfo *r)
{
	ndr_print_struct(ndr, name, "REF_ITypeInfo");
	ndr->depth++;
	ndr->depth--;
}

static NTSTATUS ndr_push_VARIANT(struct ndr_push *ndr, int ndr_flags, const struct VARIANT *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->vartype));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_VARIANT(struct ndr_pull *ndr, int ndr_flags, struct VARIANT *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->vartype));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_VARIANT(struct ndr_print *ndr, const char *name, const struct VARIANT *r)
{
	ndr_print_struct(ndr, name, "VARIANT");
	ndr->depth++;
	ndr_print_uint16(ndr, "vartype", r->vartype);
	ndr_print_uint16(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_DISPPARAMS(struct ndr_push *ndr, int ndr_flags, const struct DISPPARAMS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_DISPPARAMS(struct ndr_pull *ndr, int ndr_flags, struct DISPPARAMS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_DISPPARAMS(struct ndr_print *ndr, const char *name, const struct DISPPARAMS *r)
{
	ndr_print_struct(ndr, name, "DISPPARAMS");
	ndr->depth++;
	ndr_print_uint16(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_EXCEPINFO(struct ndr_push *ndr, int ndr_flags, const struct EXCEPINFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EXCEPINFO(struct ndr_pull *ndr, int ndr_flags, struct EXCEPINFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EXCEPINFO(struct ndr_print *ndr, const char *name, const struct EXCEPINFO *r)
{
	ndr_print_struct(ndr, name, "EXCEPINFO");
	ndr->depth++;
	ndr_print_uint16(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static NTSTATUS ndr_push_GetTypeInfoCount(struct ndr_push *ndr, int flags, const struct GetTypeInfoCount *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.pctinfo == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.pctinfo));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_GetTypeInfoCount(struct ndr_pull *ndr, int flags, struct GetTypeInfoCount *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pctinfo_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.pctinfo);
		ZERO_STRUCTP(r->out.pctinfo);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pctinfo);
		}
		_mem_save_pctinfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pctinfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.pctinfo));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pctinfo_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_GetTypeInfoCount(struct ndr_print *ndr, const char *name, int flags, const struct GetTypeInfoCount *r)
{
	ndr_print_struct(ndr, name, "GetTypeInfoCount");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetTypeInfoCount");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetTypeInfoCount");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "pctinfo", r->out.pctinfo);
		ndr->depth++;
		ndr_print_uint16(ndr, "pctinfo", *r->out.pctinfo);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_GetTypeInfo(struct ndr_push *ndr, int flags, const struct GetTypeInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.iTInfo));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.lcid));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppTInfo == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.ppTInfo == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_REF_ITypeInfo(ndr, NDR_SCALARS, *r->out.ppTInfo));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_GetTypeInfo(struct ndr_pull *ndr, int flags, struct GetTypeInfo *r)
{
	uint32_t _ptr_ppTInfo;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppTInfo_0;
	TALLOC_CTX *_mem_save_ppTInfo_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.iTInfo));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.lcid));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppTInfo);
		ZERO_STRUCTP(r->out.ppTInfo);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppTInfo);
		}
		_mem_save_ppTInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppTInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_ppTInfo));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.ppTInfo);
		}
		_mem_save_ppTInfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppTInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_REF_ITypeInfo(ndr, NDR_SCALARS, *r->out.ppTInfo));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppTInfo_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppTInfo_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_GetTypeInfo(struct ndr_print *ndr, const char *name, int flags, const struct GetTypeInfo *r)
{
	ndr_print_struct(ndr, name, "GetTypeInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetTypeInfo");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint16(ndr, "iTInfo", r->in.iTInfo);
		ndr_print_uint32(ndr, "lcid", r->in.lcid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetTypeInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppTInfo", r->out.ppTInfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppTInfo", *r->out.ppTInfo);
		ndr->depth++;
		ndr_print_REF_ITypeInfo(ndr, "ppTInfo", *r->out.ppTInfo);
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_GetIDsOfNames(struct ndr_push *ndr, int flags, const struct GetIDsOfNames *r)
{
	uint32_t cntr_rgDispId_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.riid));
		if (r->in.riid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.riid));
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.cNames));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.lcid));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.rgDispId == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cNames));
		for (cntr_rgDispId_1 = 0; cntr_rgDispId_1 < r->in.cNames; cntr_rgDispId_1++) {
			if (r->out.rgDispId[cntr_rgDispId_1] == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
			NDR_CHECK(ndr_push_ref_ptr(ndr));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_GetIDsOfNames(struct ndr_pull *ndr, int flags, struct GetIDsOfNames *r)
{
	uint32_t _ptr_riid;
	uint32_t _ptr_rgDispId;
	uint32_t cntr_rgDispId_1;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_riid_0;
	TALLOC_CTX *_mem_save_rgDispId_1;
	TALLOC_CTX *_mem_save_rgDispId_2;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_riid));
		if (_ptr_riid) {
			NDR_PULL_ALLOC(ndr, r->in.riid);
		} else {
			r->in.riid = NULL;
		}
		if (r->in.riid) {
			_mem_save_riid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.riid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.riid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_riid_0, 0);
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.cNames));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.lcid));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC_N(ndr, r->out.rgDispId, r->in.cNames);
		memset(r->out.rgDispId, 0, r->in.cNames * sizeof(*r->out.rgDispId));
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.rgDispId));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.rgDispId, ndr_get_array_size(ndr, &r->out.rgDispId));
		}
		_mem_save_rgDispId_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rgDispId, 0);
		for (cntr_rgDispId_1 = 0; cntr_rgDispId_1 < r->in.cNames; cntr_rgDispId_1++) {
			NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_rgDispId));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->out.rgDispId[cntr_rgDispId_1]);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rgDispId_1, 0);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.rgDispId) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.rgDispId, r->in.cNames));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_GetIDsOfNames(struct ndr_print *ndr, const char *name, int flags, const struct GetIDsOfNames *r)
{
	uint32_t cntr_rgDispId_1;
	ndr_print_struct(ndr, name, "GetIDsOfNames");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetIDsOfNames");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "riid", r->in.riid);
		ndr->depth++;
		if (r->in.riid) {
			ndr_print_GUID(ndr, "riid", r->in.riid);
		}
		ndr->depth--;
		ndr_print_uint16(ndr, "cNames", r->in.cNames);
		ndr_print_uint32(ndr, "lcid", r->in.lcid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetIDsOfNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "rgDispId", r->out.rgDispId);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "rgDispId", r->in.cNames);
		ndr->depth++;
		for (cntr_rgDispId_1=0;cntr_rgDispId_1<r->in.cNames;cntr_rgDispId_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_rgDispId_1);
			if (idx_1) {
				ndr_print_ptr(ndr, "rgDispId", r->out.rgDispId[cntr_rgDispId_1]);
				ndr->depth++;
				ndr_print_uint32(ndr, "rgDispId", *r->out.rgDispId[cntr_rgDispId_1]);
				ndr->depth--;
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_Invoke(struct ndr_push *ndr, int flags, const struct Invoke *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dispIdMember));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.riid));
		if (r->in.riid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.riid));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.lcid));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.wFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDispParams));
		if (r->in.pDispParams) {
			NDR_CHECK(ndr_push_DISPPARAMS(ndr, NDR_SCALARS, r->in.pDispParams));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pDispParams));
		if (r->out.pDispParams) {
			NDR_CHECK(ndr_push_DISPPARAMS(ndr, NDR_SCALARS, r->out.pDispParams));
		}
		if (r->out.pVarResult == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.pVarResult == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_VARIANT(ndr, NDR_SCALARS, *r->out.pVarResult));
		if (r->out.pExcepInfo == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.pExcepInfo == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_EXCEPINFO(ndr, NDR_SCALARS, *r->out.pExcepInfo));
		if (r->out.puArgErr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.puArgErr == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, **r->out.puArgErr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_Invoke(struct ndr_pull *ndr, int flags, struct Invoke *r)
{
	uint32_t _ptr_riid;
	uint32_t _ptr_pDispParams;
	uint32_t _ptr_pVarResult;
	uint32_t _ptr_pExcepInfo;
	uint32_t _ptr_puArgErr;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_riid_0;
	TALLOC_CTX *_mem_save_pDispParams_0;
	TALLOC_CTX *_mem_save_pVarResult_0;
	TALLOC_CTX *_mem_save_pVarResult_1;
	TALLOC_CTX *_mem_save_pExcepInfo_0;
	TALLOC_CTX *_mem_save_pExcepInfo_1;
	TALLOC_CTX *_mem_save_puArgErr_0;
	TALLOC_CTX *_mem_save_puArgErr_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dispIdMember));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_riid));
		if (_ptr_riid) {
			NDR_PULL_ALLOC(ndr, r->in.riid);
		} else {
			r->in.riid = NULL;
		}
		if (r->in.riid) {
			_mem_save_riid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.riid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.riid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_riid_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.lcid));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.wFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDispParams));
		if (_ptr_pDispParams) {
			NDR_PULL_ALLOC(ndr, r->in.pDispParams);
		} else {
			r->in.pDispParams = NULL;
		}
		if (r->in.pDispParams) {
			_mem_save_pDispParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDispParams, 0);
			NDR_CHECK(ndr_pull_DISPPARAMS(ndr, NDR_SCALARS, r->in.pDispParams));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDispParams_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.pVarResult);
		ZERO_STRUCTP(r->out.pVarResult);
		NDR_PULL_ALLOC(ndr, r->out.pExcepInfo);
		ZERO_STRUCTP(r->out.pExcepInfo);
		NDR_PULL_ALLOC(ndr, r->out.puArgErr);
		ZERO_STRUCTP(r->out.puArgErr);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDispParams));
		if (_ptr_pDispParams) {
			NDR_PULL_ALLOC(ndr, r->out.pDispParams);
		} else {
			r->out.pDispParams = NULL;
		}
		if (r->out.pDispParams) {
			_mem_save_pDispParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pDispParams, 0);
			NDR_CHECK(ndr_pull_DISPPARAMS(ndr, NDR_SCALARS, r->out.pDispParams));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDispParams_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pVarResult);
		}
		_mem_save_pVarResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pVarResult, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_pVarResult));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.pVarResult);
		}
		_mem_save_pVarResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.pVarResult, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_VARIANT(ndr, NDR_SCALARS, *r->out.pVarResult));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pVarResult_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pVarResult_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pExcepInfo);
		}
		_mem_save_pExcepInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pExcepInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_pExcepInfo));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.pExcepInfo);
		}
		_mem_save_pExcepInfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.pExcepInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_EXCEPINFO(ndr, NDR_SCALARS, *r->out.pExcepInfo));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExcepInfo_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExcepInfo_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.puArgErr);
		}
		_mem_save_puArgErr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.puArgErr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_puArgErr));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.puArgErr);
		}
		_mem_save_puArgErr_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.puArgErr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, *r->out.puArgErr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_puArgErr_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_puArgErr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_Invoke(struct ndr_print *ndr, const char *name, int flags, const struct Invoke *r)
{
	ndr_print_struct(ndr, name, "Invoke");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Invoke");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint32(ndr, "dispIdMember", r->in.dispIdMember);
		ndr_print_ptr(ndr, "riid", r->in.riid);
		ndr->depth++;
		if (r->in.riid) {
			ndr_print_GUID(ndr, "riid", r->in.riid);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "lcid", r->in.lcid);
		ndr_print_uint16(ndr, "wFlags", r->in.wFlags);
		ndr_print_ptr(ndr, "pDispParams", r->in.pDispParams);
		ndr->depth++;
		if (r->in.pDispParams) {
			ndr_print_DISPPARAMS(ndr, "pDispParams", r->in.pDispParams);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Invoke");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "pDispParams", r->out.pDispParams);
		ndr->depth++;
		if (r->out.pDispParams) {
			ndr_print_DISPPARAMS(ndr, "pDispParams", r->out.pDispParams);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pVarResult", r->out.pVarResult);
		ndr->depth++;
		ndr_print_ptr(ndr, "pVarResult", *r->out.pVarResult);
		ndr->depth++;
		ndr_print_VARIANT(ndr, "pVarResult", *r->out.pVarResult);
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "pExcepInfo", r->out.pExcepInfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "pExcepInfo", *r->out.pExcepInfo);
		ndr->depth++;
		ndr_print_EXCEPINFO(ndr, "pExcepInfo", *r->out.pExcepInfo);
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "puArgErr", r->out.puArgErr);
		ndr->depth++;
		ndr_print_ptr(ndr, "puArgErr", *r->out.puArgErr);
		ndr->depth++;
		ndr_print_uint16(ndr, "puArgErr", **r->out.puArgErr);
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IDispatch_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"GetTypeInfoCount",
		sizeof(struct GetTypeInfoCount),
		(ndr_push_flags_fn_t) ndr_push_GetTypeInfoCount,
		(ndr_pull_flags_fn_t) ndr_pull_GetTypeInfoCount,
		(ndr_print_function_t) ndr_print_GetTypeInfoCount,
		False,
	},
	{
		"GetTypeInfo",
		sizeof(struct GetTypeInfo),
		(ndr_push_flags_fn_t) ndr_push_GetTypeInfo,
		(ndr_pull_flags_fn_t) ndr_pull_GetTypeInfo,
		(ndr_print_function_t) ndr_print_GetTypeInfo,
		False,
	},
	{
		"GetIDsOfNames",
		sizeof(struct GetIDsOfNames),
		(ndr_push_flags_fn_t) ndr_push_GetIDsOfNames,
		(ndr_pull_flags_fn_t) ndr_pull_GetIDsOfNames,
		(ndr_print_function_t) ndr_print_GetIDsOfNames,
		False,
	},
	{
		"Invoke",
		sizeof(struct Invoke),
		(ndr_push_flags_fn_t) ndr_push_Invoke,
		(ndr_pull_flags_fn_t) ndr_pull_Invoke,
		(ndr_print_function_t) ndr_print_Invoke,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IDispatch_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IDispatch]", 
};

static const struct dcerpc_endpoint_list IDispatch_endpoints = {
	.count	= 1,
	.names	= IDispatch_endpoint_strings
};

static const char * const IDispatch_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IDispatch_authservices = {
	.count	= 1,
	.names	= IDispatch_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IDispatch = {
	.name		= "IDispatch",
	.syntax_id	= {
		{0x00020400,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_IDISPATCH_VERSION
	},
	.helpstring	= DCERPC_IDISPATCH_HELPSTRING,
	.num_calls	= 7,
	.calls		= IDispatch_calls,
	.endpoints	= &IDispatch_endpoints,
	.authservices	= &IDispatch_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_MarshalInterface(struct ndr_push *ndr, int flags, const struct MarshalInterface *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_MarshalInterface(struct ndr_pull *ndr, int flags, struct MarshalInterface *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_MarshalInterface(struct ndr_print *ndr, const char *name, int flags, const struct MarshalInterface *r)
{
	ndr_print_struct(ndr, name, "MarshalInterface");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "MarshalInterface");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "MarshalInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_UnMarshalInterface(struct ndr_push *ndr, int flags, const struct UnMarshalInterface *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_UnMarshalInterface(struct ndr_pull *ndr, int flags, struct UnMarshalInterface *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_UnMarshalInterface(struct ndr_print *ndr, const char *name, int flags, const struct UnMarshalInterface *r)
{
	ndr_print_struct(ndr, name, "UnMarshalInterface");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "UnMarshalInterface");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "UnMarshalInterface");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IMarshal_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"MarshalInterface",
		sizeof(struct MarshalInterface),
		(ndr_push_flags_fn_t) ndr_push_MarshalInterface,
		(ndr_pull_flags_fn_t) ndr_pull_MarshalInterface,
		(ndr_print_function_t) ndr_print_MarshalInterface,
		False,
	},
	{
		"UnMarshalInterface",
		sizeof(struct UnMarshalInterface),
		(ndr_push_flags_fn_t) ndr_push_UnMarshalInterface,
		(ndr_pull_flags_fn_t) ndr_pull_UnMarshalInterface,
		(ndr_print_function_t) ndr_print_UnMarshalInterface,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IMarshal_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IMarshal]", 
};

static const struct dcerpc_endpoint_list IMarshal_endpoints = {
	.count	= 1,
	.names	= IMarshal_endpoint_strings
};

static const char * const IMarshal_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IMarshal_authservices = {
	.count	= 1,
	.names	= IMarshal_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IMarshal = {
	.name		= "IMarshal",
	.syntax_id	= {
		{0x00000003,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_IMARSHAL_VERSION
	},
	.helpstring	= DCERPC_IMARSHAL_HELPSTRING,
	.num_calls	= 5,
	.calls		= IMarshal_calls,
	.endpoints	= &IMarshal_endpoints,
	.authservices	= &IMarshal_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_MakeCoffee(struct ndr_push *ndr, int flags, const struct MakeCoffee *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.flavor == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.flavor, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.flavor, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.flavor, ndr_charset_length(r->in.flavor, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_MakeCoffee(struct ndr_pull *ndr, int flags, struct MakeCoffee *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.flavor));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.flavor));
		if (ndr_get_array_length(ndr, &r->in.flavor) > ndr_get_array_size(ndr, &r->in.flavor)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.flavor), ndr_get_array_length(ndr, &r->in.flavor));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.flavor), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.flavor, ndr_get_array_length(ndr, &r->in.flavor), sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_MakeCoffee(struct ndr_print *ndr, const char *name, int flags, const struct MakeCoffee *r)
{
	ndr_print_struct(ndr, name, "MakeCoffee");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "MakeCoffee");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "flavor", r->in.flavor);
		ndr->depth++;
		ndr_print_string(ndr, "flavor", r->in.flavor);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "MakeCoffee");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call ICoffeeMachine_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"MakeCoffee",
		sizeof(struct MakeCoffee),
		(ndr_push_flags_fn_t) ndr_push_MakeCoffee,
		(ndr_pull_flags_fn_t) ndr_pull_MakeCoffee,
		(ndr_print_function_t) ndr_print_MakeCoffee,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const ICoffeeMachine_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ICoffeeMachine]", 
};

static const struct dcerpc_endpoint_list ICoffeeMachine_endpoints = {
	.count	= 1,
	.names	= ICoffeeMachine_endpoint_strings
};

static const char * const ICoffeeMachine_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list ICoffeeMachine_authservices = {
	.count	= 1,
	.names	= ICoffeeMachine_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_ICoffeeMachine = {
	.name		= "ICoffeeMachine",
	.syntax_id	= {
		{0xda23f6db,0x6f45,0x466c,{0x9e,0xed},{0x0b,0x65,0x28,0x6f,0x2d,0x78}},
		DCERPC_ICOFFEEMACHINE_VERSION
	},
	.helpstring	= DCERPC_ICOFFEEMACHINE_HELPSTRING,
	.num_calls	= 4,
	.calls		= ICoffeeMachine_calls,
	.endpoints	= &ICoffeeMachine_endpoints,
	.authservices	= &ICoffeeMachine_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static NTSTATUS ndr_push_Read(struct ndr_push *ndr, int flags, const struct Read *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_requested));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.num_readx));
		if (r->in.num_readx) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.num_readx));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_requested));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_read));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pv, *r->out.num_read));
		if (r->out.num_read == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_read));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_Read(struct ndr_pull *ndr, int flags, struct Read *r)
{
	uint32_t _ptr_num_readx;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_num_readx_0;
	TALLOC_CTX *_mem_save_num_read_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_requested));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_num_readx));
		if (_ptr_num_readx) {
			NDR_PULL_ALLOC(ndr, r->in.num_readx);
		} else {
			r->in.num_readx = NULL;
		}
		if (r->in.num_readx) {
			_mem_save_num_readx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.num_readx, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.num_readx));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_readx_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.num_read);
		ZERO_STRUCTP(r->out.num_read);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pv));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.pv));
		if (ndr_get_array_length(ndr, &r->out.pv) > ndr_get_array_size(ndr, &r->out.pv)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.pv), ndr_get_array_length(ndr, &r->out.pv));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.pv, ndr_get_array_size(ndr, &r->out.pv));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pv, ndr_get_array_length(ndr, &r->out.pv)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_read);
		}
		_mem_save_num_read_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_read, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_read));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_read_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pv) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.pv, r->in.num_requested));
		}
		if (r->out.pv) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.pv, *r->out.num_read));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_Read(struct ndr_print *ndr, const char *name, int flags, const struct Read *r)
{
	ndr_print_struct(ndr, name, "Read");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Read");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint32(ndr, "num_requested", r->in.num_requested);
		ndr_print_ptr(ndr, "num_readx", r->in.num_readx);
		ndr->depth++;
		if (r->in.num_readx) {
			ndr_print_uint32(ndr, "num_readx", *r->in.num_readx);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Read");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_array_uint8(ndr, "pv", r->out.pv, *r->out.num_read);
		ndr_print_ptr(ndr, "num_read", r->out.num_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_read", *r->out.num_read);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_Write(struct ndr_push *ndr, int flags, const struct Write *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data));
		if (r->in.data) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_requested));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.data, r->in.num_requested));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_requested));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.num_written == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_written));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_Write(struct ndr_pull *ndr, int flags, struct Write *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_num_written_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		} else {
			r->in.data = NULL;
		}
		if (r->in.data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data));
			NDR_PULL_ALLOC_N(ndr, r->in.data, ndr_get_array_size(ndr, &r->in.data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.data, ndr_get_array_size(ndr, &r->in.data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_requested));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.num_written);
		ZERO_STRUCTP(r->out.num_written);
		if (r->in.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.data, r->in.num_requested));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_written);
		}
		_mem_save_num_written_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_written, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_written));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_written_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_Write(struct ndr_print *ndr, const char *name, int flags, const struct Write *r)
{
	ndr_print_struct(ndr, name, "Write");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Write");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		if (r->in.data) {
			ndr_print_array_uint8(ndr, "data", r->in.data, r->in.num_requested);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "num_requested", r->in.num_requested);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Write");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "num_written", r->out.num_written);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_written", *r->out.num_written);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call IStream_calls[] = {
	{
		"QueryInterface",
		sizeof(struct QueryInterface),
		(ndr_push_flags_fn_t) ndr_push_QueryInterface,
		(ndr_pull_flags_fn_t) ndr_pull_QueryInterface,
		(ndr_print_function_t) ndr_print_QueryInterface,
		False,
	},
	{
		"AddRef",
		sizeof(struct AddRef),
		(ndr_push_flags_fn_t) ndr_push_AddRef,
		(ndr_pull_flags_fn_t) ndr_pull_AddRef,
		(ndr_print_function_t) ndr_print_AddRef,
		False,
	},
	{
		"Release",
		sizeof(struct Release),
		(ndr_push_flags_fn_t) ndr_push_Release,
		(ndr_pull_flags_fn_t) ndr_pull_Release,
		(ndr_print_function_t) ndr_print_Release,
		False,
	},
	{
		"Read",
		sizeof(struct Read),
		(ndr_push_flags_fn_t) ndr_push_Read,
		(ndr_pull_flags_fn_t) ndr_pull_Read,
		(ndr_print_function_t) ndr_print_Read,
		False,
	},
	{
		"Write",
		sizeof(struct Write),
		(ndr_push_flags_fn_t) ndr_push_Write,
		(ndr_pull_flags_fn_t) ndr_pull_Write,
		(ndr_print_function_t) ndr_print_Write,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const IStream_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IStream]", 
};

static const struct dcerpc_endpoint_list IStream_endpoints = {
	.count	= 1,
	.names	= IStream_endpoint_strings
};

static const char * const IStream_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list IStream_authservices = {
	.count	= 1,
	.names	= IStream_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_IStream = {
	.name		= "IStream",
	.syntax_id	= {
		{0x0000000c,0x0000,0x0000,{0xc0,0x00},{0x00,0x00,0x00,0x00,0x00,0x46}},
		DCERPC_ISTREAM_VERSION
	},
	.helpstring	= DCERPC_ISTREAM_HELPSTRING,
	.num_calls	= 5,
	.calls		= IStream_calls,
	.endpoints	= &IStream_endpoints,
	.authservices	= &IStream_authservices
};

