
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/gen_ndr/ndr_dcerpc_ejs.h"


_PUBLIC_ NTSTATUS ejs_push_dcerpc_syntax_id(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_syntax_id *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "uuid", &r->uuid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "if_version", &r->if_version));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_syntax_id(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_syntax_id *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "uuid", &r->uuid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "if_version", &r->if_version));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_ctx_list(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_ctx_list *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_push_uint8(ejs, v, "num_transfer_syntaxes", &r->num_transfer_syntaxes));
	NDR_CHECK(ejs_push_dcerpc_syntax_id(ejs, v, "abstract_syntax", &r->abstract_syntax));
	{
		uint32_t i;
		for (i=0;i<r->num_transfer_syntaxes;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "transfer_syntaxes", i);
			NDR_CHECK(ejs_push_dcerpc_syntax_id(ejs, v, id, &r->transfer_syntaxes[i]));
		}
		ejs_push_uint32(ejs, v, "transfer_syntaxes" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_ctx_list(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_ctx_list *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "num_transfer_syntaxes", &r->num_transfer_syntaxes));
	NDR_CHECK(ejs_pull_dcerpc_syntax_id(ejs, v, "abstract_syntax", &r->abstract_syntax));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->transfer_syntaxes, r->num_transfer_syntaxes);
		for (i=0;i<r->num_transfer_syntaxes;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "transfer_syntaxes", i);
			NDR_CHECK(ejs_pull_dcerpc_syntax_id(ejs, v, id, &r->transfer_syntaxes[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "transfer_syntaxes" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_bind(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_bind *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_xmit_frag", &r->max_xmit_frag));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_recv_frag", &r->max_recv_frag));
	NDR_CHECK(ejs_push_uint32(ejs, v, "assoc_group_id", &r->assoc_group_id));
	NDR_CHECK(ejs_push_uint8(ejs, v, "num_contexts", &r->num_contexts));
	{
		uint32_t i;
		for (i=0;i<r->num_contexts;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "ctx_list", i);
			NDR_CHECK(ejs_push_dcerpc_ctx_list(ejs, v, id, &r->ctx_list[i]));
		}
		ejs_push_uint32(ejs, v, "ctx_list" ".length", &i);
	}
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_bind(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_bind *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_xmit_frag", &r->max_xmit_frag));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_recv_frag", &r->max_recv_frag));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "assoc_group_id", &r->assoc_group_id));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "num_contexts", &r->num_contexts));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->ctx_list, r->num_contexts);
		for (i=0;i<r->num_contexts;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "ctx_list", i);
			NDR_CHECK(ejs_pull_dcerpc_ctx_list(ejs, v, id, &r->ctx_list[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "ctx_list" ".length", &i);
	}
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_empty(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_empty *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_empty(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_empty *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_object(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dcerpc_object *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		default:
			NDR_CHECK(ejs_push_dcerpc_empty(ejs, v, "empty", &r->empty));
			break;
		case LIBNDR_FLAG_OBJECT_PRESENT:
			NDR_CHECK(ejs_push_GUID(ejs, v, "object", &r->object));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dcerpc_object(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dcerpc_object *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		default:
			NDR_CHECK(ejs_pull_dcerpc_empty(ejs, v, "empty", &r->empty));
			break;
		case LIBNDR_FLAG_OBJECT_PRESENT:
			NDR_CHECK(ejs_pull_GUID(ejs, v, "object", &r->object));
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_dcerpc_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_request *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alloc_hint", &r->alloc_hint));
	NDR_CHECK(ejs_push_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_push_uint16(ejs, v, "opnum", &r->opnum));
	ejs_set_switch(ejs, ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT);
	NDR_CHECK(ejs_push_dcerpc_object(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "stub_and_verifier", &r->stub_and_verifier));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_request(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_request *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alloc_hint", &r->alloc_hint));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "opnum", &r->opnum));
	ejs_set_switch(ejs, ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT);
	NDR_CHECK(ejs_pull_dcerpc_object(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "stub_and_verifier", &r->stub_and_verifier));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_ack_ctx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_ack_ctx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "result", &r->result));
	NDR_CHECK(ejs_push_uint16(ejs, v, "reason", &r->reason));
	NDR_CHECK(ejs_push_dcerpc_syntax_id(ejs, v, "syntax", &r->syntax));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_ack_ctx(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_ack_ctx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "result", &r->result));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "reason", &r->reason));
	NDR_CHECK(ejs_pull_dcerpc_syntax_id(ejs, v, "syntax", &r->syntax));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_bind_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_bind_ack *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_xmit_frag", &r->max_xmit_frag));
	NDR_CHECK(ejs_push_uint16(ejs, v, "max_recv_frag", &r->max_recv_frag));
	NDR_CHECK(ejs_push_uint32(ejs, v, "assoc_group_id", &r->assoc_group_id));
	NDR_CHECK(ejs_push_string(ejs, v, "secondary_address", r->secondary_address));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad1", &r->_pad1));
	NDR_CHECK(ejs_push_uint8(ejs, v, "num_results", &r->num_results));
	{
		uint32_t i;
		for (i=0;i<r->num_results;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "ctx_list", i);
			NDR_CHECK(ejs_push_dcerpc_ack_ctx(ejs, v, id, &r->ctx_list[i]));
		}
		ejs_push_uint32(ejs, v, "ctx_list" ".length", &i);
	}
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_bind_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_bind_ack *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_xmit_frag", &r->max_xmit_frag));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "max_recv_frag", &r->max_recv_frag));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "assoc_group_id", &r->assoc_group_id));
	NDR_CHECK(ejs_pull_string(ejs, v, "secondary_address", &r->secondary_address));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad1", &r->_pad1));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "num_results", &r->num_results));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->ctx_list, r->num_results);
		for (i=0;i<r->num_results;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "ctx_list", i);
			NDR_CHECK(ejs_pull_dcerpc_ack_ctx(ejs, v, id, &r->ctx_list[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "ctx_list" ".length", &i);
	}
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_bind_nak_versions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_bind_nak_versions *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_versions", &r->num_versions));
	{
		uint32_t i;
		for (i=0;i<r->num_versions;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "versions", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->versions[i]));
		}
		ejs_push_uint32(ejs, v, "versions" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_bind_nak_versions(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_bind_nak_versions *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_versions", &r->num_versions));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->versions, r->num_versions);
		for (i=0;i<r->num_versions;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "versions", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->versions[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "versions" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_bind_nak_versions_ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dcerpc_bind_nak_versions_ctr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			NDR_CHECK(ejs_push_dcerpc_bind_nak_versions(ejs, v, "v", &r->v));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dcerpc_bind_nak_versions_ctr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dcerpc_bind_nak_versions_ctr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			NDR_CHECK(ejs_pull_dcerpc_bind_nak_versions(ejs, v, "v", &r->v));
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_dcerpc_bind_nak(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_bind_nak *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "reject_reason", &r->reject_reason));
	ejs_set_switch(ejs, r->reject_reason);
	NDR_CHECK(ejs_push_dcerpc_bind_nak_versions_ctr(ejs, v, "versions", &r->versions));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_bind_nak(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_bind_nak *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "reject_reason", &r->reject_reason));
	ejs_set_switch(ejs, r->reject_reason);
	NDR_CHECK(ejs_pull_dcerpc_bind_nak_versions_ctr(ejs, v, "versions", &r->versions));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_response(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_response *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alloc_hint", &r->alloc_hint));
	NDR_CHECK(ejs_push_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_push_uint8(ejs, v, "cancel_count", &r->cancel_count));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "stub_and_verifier", &r->stub_and_verifier));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_response(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_response *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alloc_hint", &r->alloc_hint));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "cancel_count", &r->cancel_count));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "stub_and_verifier", &r->stub_and_verifier));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_fault(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_fault *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alloc_hint", &r->alloc_hint));
	NDR_CHECK(ejs_push_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_push_uint8(ejs, v, "cancel_count", &r->cancel_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_fault(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_fault *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alloc_hint", &r->alloc_hint));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "context_id", &r->context_id));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "cancel_count", &r->cancel_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "status", &r->status));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_auth(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_auth *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "auth_type", &r->auth_type));
	NDR_CHECK(ejs_push_uint8(ejs, v, "auth_level", &r->auth_level));
	NDR_CHECK(ejs_push_uint8(ejs, v, "auth_pad_length", &r->auth_pad_length));
	NDR_CHECK(ejs_push_uint8(ejs, v, "auth_reserved", &r->auth_reserved));
	NDR_CHECK(ejs_push_uint32(ejs, v, "auth_context_id", &r->auth_context_id));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "credentials", &r->credentials));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_auth(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_auth *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "auth_type", &r->auth_type));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "auth_level", &r->auth_level));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "auth_pad_length", &r->auth_pad_length));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "auth_reserved", &r->auth_reserved));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "auth_context_id", &r->auth_context_id));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "credentials", &r->credentials));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_auth3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_auth3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_auth3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_auth3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_orphaned(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_orphaned *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_orphaned(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_orphaned *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_co_cancel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_co_cancel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_co_cancel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_co_cancel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "_pad", &r->_pad));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "auth_info", &r->auth_info));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_cl_cancel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_cl_cancel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "id", &r->id));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_cl_cancel(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_cl_cancel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "id", &r->id));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_cancel_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_cancel_ack *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "id", &r->id));
	NDR_CHECK(ejs_push_uint32(ejs, v, "server_is_accepting", &r->server_is_accepting));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_cancel_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_cancel_ack *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "id", &r->id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "server_is_accepting", &r->server_is_accepting));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_fack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_fack *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint8(ejs, v, "_pad1", &r->_pad1));
	NDR_CHECK(ejs_push_uint16(ejs, v, "window_size", &r->window_size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_tdsu", &r->max_tdsu));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_frag_size", &r->max_frag_size));
	NDR_CHECK(ejs_push_uint16(ejs, v, "serial_no", &r->serial_no));
	NDR_CHECK(ejs_push_uint16(ejs, v, "selack_size", &r->selack_size));
	{
		uint32_t i;
		for (i=0;i<r->selack_size;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "selack", i);
			NDR_CHECK(ejs_push_uint32(ejs, v, id, &r->selack[i]));
		}
		ejs_push_uint32(ejs, v, "selack" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_fack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_fack *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "_pad1", &r->_pad1));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "window_size", &r->window_size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_tdsu", &r->max_tdsu));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_frag_size", &r->max_frag_size));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "serial_no", &r->serial_no));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "selack_size", &r->selack_size));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->selack, r->selack_size);
		for (i=0;i<r->selack_size;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "selack", i);
			NDR_CHECK(ejs_pull_uint32(ejs, v, id, &r->selack[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "selack" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_ack *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_ack *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_ping(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_ping *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_ping(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_ping *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_shutdown(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_shutdown *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_shutdown(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_shutdown *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_dcerpc_working(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct dcerpc_working *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_dcerpc_working(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct dcerpc_working *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_pkt_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum dcerpc_pkt_type *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_dcerpc_pkt_type(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum dcerpc_pkt_type *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_dcerpc_payload(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union dcerpc_payload *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DCERPC_PKT_REQUEST:
			NDR_CHECK(ejs_push_dcerpc_request(ejs, v, "request", &r->request));
			break;
		case DCERPC_PKT_PING:
			NDR_CHECK(ejs_push_dcerpc_ping(ejs, v, "ping", &r->ping));
			break;
		case DCERPC_PKT_RESPONSE:
			NDR_CHECK(ejs_push_dcerpc_response(ejs, v, "response", &r->response));
			break;
		case DCERPC_PKT_FAULT:
			NDR_CHECK(ejs_push_dcerpc_fault(ejs, v, "fault", &r->fault));
			break;
		case DCERPC_PKT_WORKING:
			NDR_CHECK(ejs_push_dcerpc_working(ejs, v, "working", &r->working));
			break;
		case DCERPC_PKT_NOCALL:
			NDR_CHECK(ejs_push_dcerpc_fack(ejs, v, "nocall", &r->nocall));
			break;
		case DCERPC_PKT_REJECT:
			NDR_CHECK(ejs_push_dcerpc_fault(ejs, v, "reject", &r->reject));
			break;
		case DCERPC_PKT_ACK:
			NDR_CHECK(ejs_push_dcerpc_ack(ejs, v, "ack", &r->ack));
			break;
		case DCERPC_PKT_CL_CANCEL:
			NDR_CHECK(ejs_push_dcerpc_cl_cancel(ejs, v, "cl_cancel", &r->cl_cancel));
			break;
		case DCERPC_PKT_FACK:
			NDR_CHECK(ejs_push_dcerpc_fack(ejs, v, "fack", &r->fack));
			break;
		case DCERPC_PKT_CANCEL_ACK:
			NDR_CHECK(ejs_push_dcerpc_cancel_ack(ejs, v, "cancel_ack", &r->cancel_ack));
			break;
		case DCERPC_PKT_BIND:
			NDR_CHECK(ejs_push_dcerpc_bind(ejs, v, "bind", &r->bind));
			break;
		case DCERPC_PKT_BIND_ACK:
			NDR_CHECK(ejs_push_dcerpc_bind_ack(ejs, v, "bind_ack", &r->bind_ack));
			break;
		case DCERPC_PKT_BIND_NAK:
			NDR_CHECK(ejs_push_dcerpc_bind_nak(ejs, v, "bind_nak", &r->bind_nak));
			break;
		case DCERPC_PKT_ALTER:
			NDR_CHECK(ejs_push_dcerpc_bind(ejs, v, "alter", &r->alter));
			break;
		case DCERPC_PKT_ALTER_RESP:
			NDR_CHECK(ejs_push_dcerpc_bind_ack(ejs, v, "alter_resp", &r->alter_resp));
			break;
		case DCERPC_PKT_SHUTDOWN:
			NDR_CHECK(ejs_push_dcerpc_shutdown(ejs, v, "shutdown", &r->shutdown));
			break;
		case DCERPC_PKT_CO_CANCEL:
			NDR_CHECK(ejs_push_dcerpc_co_cancel(ejs, v, "co_cancel", &r->co_cancel));
			break;
		case DCERPC_PKT_ORPHANED:
			NDR_CHECK(ejs_push_dcerpc_orphaned(ejs, v, "orphaned", &r->orphaned));
			break;
		case DCERPC_PKT_AUTH3:
			NDR_CHECK(ejs_push_dcerpc_auth3(ejs, v, "auth3", &r->auth3));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_dcerpc_payload(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union dcerpc_payload *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case DCERPC_PKT_REQUEST:
			NDR_CHECK(ejs_pull_dcerpc_request(ejs, v, "request", &r->request));
			break;
		case DCERPC_PKT_PING:
			NDR_CHECK(ejs_pull_dcerpc_ping(ejs, v, "ping", &r->ping));
			break;
		case DCERPC_PKT_RESPONSE:
			NDR_CHECK(ejs_pull_dcerpc_response(ejs, v, "response", &r->response));
			break;
		case DCERPC_PKT_FAULT:
			NDR_CHECK(ejs_pull_dcerpc_fault(ejs, v, "fault", &r->fault));
			break;
		case DCERPC_PKT_WORKING:
			NDR_CHECK(ejs_pull_dcerpc_working(ejs, v, "working", &r->working));
			break;
		case DCERPC_PKT_NOCALL:
			NDR_CHECK(ejs_pull_dcerpc_fack(ejs, v, "nocall", &r->nocall));
			break;
		case DCERPC_PKT_REJECT:
			NDR_CHECK(ejs_pull_dcerpc_fault(ejs, v, "reject", &r->reject));
			break;
		case DCERPC_PKT_ACK:
			NDR_CHECK(ejs_pull_dcerpc_ack(ejs, v, "ack", &r->ack));
			break;
		case DCERPC_PKT_CL_CANCEL:
			NDR_CHECK(ejs_pull_dcerpc_cl_cancel(ejs, v, "cl_cancel", &r->cl_cancel));
			break;
		case DCERPC_PKT_FACK:
			NDR_CHECK(ejs_pull_dcerpc_fack(ejs, v, "fack", &r->fack));
			break;
		case DCERPC_PKT_CANCEL_ACK:
			NDR_CHECK(ejs_pull_dcerpc_cancel_ack(ejs, v, "cancel_ack", &r->cancel_ack));
			break;
		case DCERPC_PKT_BIND:
			NDR_CHECK(ejs_pull_dcerpc_bind(ejs, v, "bind", &r->bind));
			break;
		case DCERPC_PKT_BIND_ACK:
			NDR_CHECK(ejs_pull_dcerpc_bind_ack(ejs, v, "bind_ack", &r->bind_ack));
			break;
		case DCERPC_PKT_BIND_NAK:
			NDR_CHECK(ejs_pull_dcerpc_bind_nak(ejs, v, "bind_nak", &r->bind_nak));
			break;
		case DCERPC_PKT_ALTER:
			NDR_CHECK(ejs_pull_dcerpc_bind(ejs, v, "alter", &r->alter));
			break;
		case DCERPC_PKT_ALTER_RESP:
			NDR_CHECK(ejs_pull_dcerpc_bind_ack(ejs, v, "alter_resp", &r->alter_resp));
			break;
		case DCERPC_PKT_SHUTDOWN:
			NDR_CHECK(ejs_pull_dcerpc_shutdown(ejs, v, "shutdown", &r->shutdown));
			break;
		case DCERPC_PKT_CO_CANCEL:
			NDR_CHECK(ejs_pull_dcerpc_co_cancel(ejs, v, "co_cancel", &r->co_cancel));
			break;
		case DCERPC_PKT_ORPHANED:
			NDR_CHECK(ejs_pull_dcerpc_orphaned(ejs, v, "orphaned", &r->orphaned));
			break;
		case DCERPC_PKT_AUTH3:
			NDR_CHECK(ejs_pull_dcerpc_auth3(ejs, v, "auth3", &r->auth3));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_ncacn_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ncacn_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "rpc_vers", &r->rpc_vers));
	NDR_CHECK(ejs_push_uint8(ejs, v, "rpc_vers_minor", &r->rpc_vers_minor));
	NDR_CHECK(ejs_push_dcerpc_pkt_type(ejs, v, "ptype", &r->ptype));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pfc_flags", &r->pfc_flags));
	ejs_push_array_uint8(ejs, v, "drep", r->drep, 4);
	NDR_CHECK(ejs_push_uint16(ejs, v, "frag_length", &r->frag_length));
	NDR_CHECK(ejs_push_uint16(ejs, v, "auth_length", &r->auth_length));
	NDR_CHECK(ejs_push_uint32(ejs, v, "call_id", &r->call_id));
	ejs_set_switch(ejs, r->ptype);
	NDR_CHECK(ejs_push_dcerpc_payload(ejs, v, "u", &r->u));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_ncacn_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ncacn_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "rpc_vers", &r->rpc_vers));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "rpc_vers_minor", &r->rpc_vers_minor));
	NDR_CHECK(ejs_pull_dcerpc_pkt_type(ejs, v, "ptype", &r->ptype));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pfc_flags", &r->pfc_flags));
	ejs_pull_array_uint8(ejs, v, "drep", r->drep, 4);
	NDR_CHECK(ejs_pull_uint16(ejs, v, "frag_length", &r->frag_length));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "auth_length", &r->auth_length));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "call_id", &r->call_id));
	ejs_set_switch(ejs, r->ptype);
	NDR_CHECK(ejs_pull_dcerpc_payload(ejs, v, "u", &r->u));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_ncadg_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ncadg_packet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "rpc_vers", &r->rpc_vers));
	NDR_CHECK(ejs_push_uint8(ejs, v, "ptype", &r->ptype));
	NDR_CHECK(ejs_push_uint8(ejs, v, "pfc_flags", &r->pfc_flags));
	NDR_CHECK(ejs_push_uint8(ejs, v, "ncadg_flags", &r->ncadg_flags));
	ejs_push_array_uint8(ejs, v, "drep", r->drep, 3);
	NDR_CHECK(ejs_push_uint8(ejs, v, "serial_high", &r->serial_high));
	NDR_CHECK(ejs_push_GUID(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_push_GUID(ejs, v, "iface", &r->iface));
	NDR_CHECK(ejs_push_GUID(ejs, v, "activity", &r->activity));
	NDR_CHECK(ejs_push_uint32(ejs, v, "server_boot", &r->server_boot));
	NDR_CHECK(ejs_push_uint32(ejs, v, "iface_version", &r->iface_version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "seq_num", &r->seq_num));
	NDR_CHECK(ejs_push_uint16(ejs, v, "opnum", &r->opnum));
	NDR_CHECK(ejs_push_uint16(ejs, v, "ihint", &r->ihint));
	NDR_CHECK(ejs_push_uint16(ejs, v, "ahint", &r->ahint));
	NDR_CHECK(ejs_push_uint16(ejs, v, "len", &r->len));
	NDR_CHECK(ejs_push_uint16(ejs, v, "fragnum", &r->fragnum));
	NDR_CHECK(ejs_push_uint8(ejs, v, "auth_proto", &r->auth_proto));
	NDR_CHECK(ejs_push_uint8(ejs, v, "serial_low", &r->serial_low));
	ejs_set_switch(ejs, r->ptype);
	NDR_CHECK(ejs_push_dcerpc_payload(ejs, v, "u", &r->u));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_ncadg_packet(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ncadg_packet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "rpc_vers", &r->rpc_vers));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "ptype", &r->ptype));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "pfc_flags", &r->pfc_flags));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "ncadg_flags", &r->ncadg_flags));
	ejs_pull_array_uint8(ejs, v, "drep", r->drep, 3);
	NDR_CHECK(ejs_pull_uint8(ejs, v, "serial_high", &r->serial_high));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "object", &r->object));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "iface", &r->iface));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "activity", &r->activity));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "server_boot", &r->server_boot));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "iface_version", &r->iface_version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "seq_num", &r->seq_num));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "opnum", &r->opnum));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "ihint", &r->ihint));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "ahint", &r->ahint));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "len", &r->len));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "fragnum", &r->fragnum));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "auth_proto", &r->auth_proto));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "serial_low", &r->serial_low));
	ejs_set_switch(ejs, r->ptype);
	NDR_CHECK(ejs_pull_dcerpc_payload(ejs, v, "u", &r->u));
	return NT_STATUS_OK;
}

static int ejs_dcerpc_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "dcerpc", argc, argv);
	mprSetVar(obj, "DCERPC_AUTH_TYPE_SCHANNEL", mprCreateNumberVar(68));
	mprSetVar(obj, "DCERPC_FAULT_OP_RNG_ERROR", mprCreateNumberVar(0x1c010002));
	mprSetVar(obj, "DCERPC_BIND_REASON_INVALID_AUTH_TYPE", mprCreateNumberVar(8));
	mprSetVar(obj, "DCERPC_PFC_FLAG_NOCALL", mprCreateNumberVar(0x20));
	mprSetVar(obj, "DCERPC_AUTH_TYPE_MSMQ", mprCreateNumberVar(100));
	mprSetVar(obj, "DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED", mprCreateNumberVar(4));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_CONNECT", mprCreateNumberVar(2));
	mprSetVar(obj, "DCERPC_PKT_ORPHANED", mprCreateNumberVar(19));
	mprSetVar(obj, "DCERPC_BIND_REASON_ASYNTAX", mprCreateNumberVar(1));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_CALL", mprCreateNumberVar(3));
	mprSetVar(obj, "DCERPC_PKT_SHUTDOWN", mprCreateNumberVar(17));
	mprSetVar(obj, "DCERPC_PKT_CO_CANCEL", mprCreateNumberVar(18));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_NONE", mprCreateNumberVar(1));
	mprSetVar(obj, "DCERPC_FAULT_CONTEXT_MISMATCH", mprCreateNumberVar(0x1c00001a));
	mprSetVar(obj, "DCERPC_PKT_BIND_NAK", mprCreateNumberVar(13));
	mprSetVar(obj, "DCERPC_PKT_WORKING", mprCreateNumberVar(4));
	mprSetVar(obj, "DCERPC_PKT_RESPONSE", mprCreateNumberVar(2));
	mprSetVar(obj, "DCERPC_FAULT_TODO", mprCreateNumberVar(0x00000042));
	mprSetVar(obj, "DCERPC_FRAG_LEN_OFFSET", mprCreateNumberVar(8));
	mprSetVar(obj, "DCERPC_DREP_LE", mprCreateNumberVar(0x10));
	mprSetVar(obj, "DCERPC_PFC_FLAG_FIRST", mprCreateNumberVar(0x01));
	mprSetVar(obj, "DCERPC_PKT_CL_CANCEL", mprCreateNumberVar(8));
	mprSetVar(obj, "DCERPC_PKT_CANCEL_ACK", mprCreateNumberVar(10));
	mprSetVar(obj, "DCERPC_PKT_FAULT", mprCreateNumberVar(3));
	mprSetVar(obj, "DCERPC_FAULT_OTHER", mprCreateNumberVar(0x00000001));
	mprSetVar(obj, "DCERPC_FAULT_ACCESS_DENIED", mprCreateNumberVar(0x00000005));
	mprSetVar(obj, "DCERPC_AUTH_TYPE_KRB5", mprCreateNumberVar(16));
	mprSetVar(obj, "DCERPC_PKT_REQUEST", mprCreateNumberVar(0));
	mprSetVar(obj, "DCERPC_PFC_FLAG_ORPC", mprCreateNumberVar(0x80));
	mprSetVar(obj, "DCERPC_PFC_FLAG_LAST", mprCreateNumberVar(0x02));
	mprSetVar(obj, "DCERPC_BIND_PROVIDER_REJECT", mprCreateNumberVar(2));
	mprSetVar(obj, "DCERPC_AUTH_LEN_OFFSET", mprCreateNumberVar(10));
	mprSetVar(obj, "DCERPC_FAULT_UNK_IF", mprCreateNumberVar(0x1c010003));
	mprSetVar(obj, "DCERPC_PKT_ACK", mprCreateNumberVar(7));
	mprSetVar(obj, "DCERPC_MAX_SIGN_SIZE", mprCreateNumberVar(32));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_INTEGRITY", mprCreateNumberVar(5));
	mprSetVar(obj, "DCERPC_FAULT_CANT_PERFORM", mprCreateNumberVar(0x000006d8));
	mprSetVar(obj, "DCERPC_AUTH_TYPE_NONE", mprCreateNumberVar(0));
	mprSetVar(obj, "DCERPC_PKT_BIND", mprCreateNumberVar(11));
	mprSetVar(obj, "DCERPC_PKT_BIND_ACK", mprCreateNumberVar(12));
	mprSetVar(obj, "DCERPC_PKT_FACK", mprCreateNumberVar(9));
	mprSetVar(obj, "DCERPC_DREP_OFFSET", mprCreateNumberVar(4));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_PRIVACY", mprCreateNumberVar(6));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_PACKET", mprCreateNumberVar(4));
	mprSetVar(obj, "DCERPC_FAULT_NDR", mprCreateNumberVar(0x000006f7));
	mprSetVar(obj, "DCERPC_PKT_AUTH3", mprCreateNumberVar(16));
	mprSetVar(obj, "DCERPC_FAULT_INVALID_TAG", mprCreateNumberVar(0x1c000006));
	mprSetVar(obj, "DCERPC_AUTH_TYPE_KRB5_1", mprCreateNumberVar(1));
	mprSetVar(obj, "DCERPC_AUTH_TYPE_SPNEGO", mprCreateNumberVar(9));
	mprSetVar(obj, "DCERPC_PKT_ALTER_RESP", mprCreateNumberVar(15));
	mprSetVar(obj, "DCERPC_PKT_PING", mprCreateNumberVar(1));
	mprSetVar(obj, "DCERPC_RESPONSE_LENGTH", mprCreateNumberVar(24));
	mprSetVar(obj, "DCERPC_PKT_REJECT", mprCreateNumberVar(6));
	mprSetVar(obj, "DCERPC_REQUEST_LENGTH", mprCreateNumberVar(24));
	mprSetVar(obj, "DCERPC_PKT_ALTER", mprCreateNumberVar(14));
	mprSetVar(obj, "DCERPC_AUTH_TYPE_NTLMSSP", mprCreateNumberVar(10));
	mprSetVar(obj, "DCERPC_AUTH_LEVEL_DEFAULT", mprCreateNumberVar(DCERPC_AUTH_LEVEL_CONNECT));
	mprSetVar(obj, "DCERPC_PKT_NOCALL", mprCreateNumberVar(5));
	return ejs_rpc_init(obj, "dcerpc");
}

NTSTATUS ejs_init_dcerpc(void)
{
	ejsDefineCFunction(-1, "dcerpc_init", ejs_dcerpc_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
