/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_browser.h"

/* browser - dcerpc server boilerplate generated by pidl */


static NTSTATUS browser__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_BROWSER_BIND
	return DCESRV_INTERFACE_BROWSER_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void browser__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_BROWSER_UNBIND
	DCESRV_INTERFACE_BROWSER_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS browser__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_browser.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_browser.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_browser.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_browser, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS browser__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct BrowserrServerEnum *r2 = (struct BrowserrServerEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrServerEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrServerEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrServerEnum will reply async\n"));
		}
		break;
	}
	case 1: {
		struct BrowserrDebugCall *r2 = (struct BrowserrDebugCall *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrDebugCall, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrDebugCall(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrDebugCall will reply async\n"));
		}
		break;
	}
	case 2: {
		struct BrowserrQueryOtherDomains *r2 = (struct BrowserrQueryOtherDomains *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrQueryOtherDomains, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrQueryOtherDomains(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrQueryOtherDomains will reply async\n"));
		}
		break;
	}
	case 3: {
		struct BrowserrResetNetlogonState *r2 = (struct BrowserrResetNetlogonState *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrResetNetlogonState, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrResetNetlogonState(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrResetNetlogonState will reply async\n"));
		}
		break;
	}
	case 4: {
		struct BrowserrDebugTrace *r2 = (struct BrowserrDebugTrace *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrDebugTrace, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrDebugTrace(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrDebugTrace will reply async\n"));
		}
		break;
	}
	case 5: {
		struct BrowserrQueryStatistics *r2 = (struct BrowserrQueryStatistics *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrQueryStatistics, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrQueryStatistics(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrQueryStatistics will reply async\n"));
		}
		break;
	}
	case 6: {
		struct BrowserResetStatistics *r2 = (struct BrowserResetStatistics *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserResetStatistics, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserResetStatistics(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserResetStatistics will reply async\n"));
		}
		break;
	}
	case 7: {
		struct NetrBrowserStatisticsClear *r2 = (struct NetrBrowserStatisticsClear *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrBrowserStatisticsClear, NDR_IN, r2);
		}
		r2->out.result = dcesrv_NetrBrowserStatisticsClear(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrBrowserStatisticsClear will reply async\n"));
		}
		break;
	}
	case 8: {
		struct NetrBrowserStatisticsGet *r2 = (struct NetrBrowserStatisticsGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(NetrBrowserStatisticsGet, NDR_IN, r2);
		}
		r2->out.result = dcesrv_NetrBrowserStatisticsGet(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrBrowserStatisticsGet will reply async\n"));
		}
		break;
	}
	case 9: {
		struct BrowserrSetNetlogonState *r2 = (struct BrowserrSetNetlogonState *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrSetNetlogonState, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrSetNetlogonState(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrSetNetlogonState will reply async\n"));
		}
		break;
	}
	case 10: {
		struct BrowserrQueryEmulatedDomains *r2 = (struct BrowserrQueryEmulatedDomains *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrQueryEmulatedDomains, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrQueryEmulatedDomains(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrQueryEmulatedDomains will reply async\n"));
		}
		break;
	}
	case 11: {
		struct BrowserrServerEnumEx *r2 = (struct BrowserrServerEnumEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrServerEnumEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_BrowserrServerEnumEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrServerEnumEx will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_browser, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS browser__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct BrowserrServerEnum *r2 = (struct BrowserrServerEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrServerEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrServerEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrServerEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct BrowserrDebugCall *r2 = (struct BrowserrDebugCall *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrDebugCall replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrDebugCall, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrDebugCall\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct BrowserrQueryOtherDomains *r2 = (struct BrowserrQueryOtherDomains *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrQueryOtherDomains replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrQueryOtherDomains, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrQueryOtherDomains\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct BrowserrResetNetlogonState *r2 = (struct BrowserrResetNetlogonState *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrResetNetlogonState replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrResetNetlogonState, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrResetNetlogonState\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct BrowserrDebugTrace *r2 = (struct BrowserrDebugTrace *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrDebugTrace replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrDebugTrace, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrDebugTrace\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct BrowserrQueryStatistics *r2 = (struct BrowserrQueryStatistics *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrQueryStatistics replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrQueryStatistics, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrQueryStatistics\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct BrowserResetStatistics *r2 = (struct BrowserResetStatistics *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserResetStatistics replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserResetStatistics, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserResetStatistics\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct NetrBrowserStatisticsClear *r2 = (struct NetrBrowserStatisticsClear *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrBrowserStatisticsClear replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrBrowserStatisticsClear, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrBrowserStatisticsClear\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct NetrBrowserStatisticsGet *r2 = (struct NetrBrowserStatisticsGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function NetrBrowserStatisticsGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(NetrBrowserStatisticsGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in NetrBrowserStatisticsGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct BrowserrSetNetlogonState *r2 = (struct BrowserrSetNetlogonState *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrSetNetlogonState replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrSetNetlogonState, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrSetNetlogonState\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct BrowserrQueryEmulatedDomains *r2 = (struct BrowserrQueryEmulatedDomains *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrQueryEmulatedDomains replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrQueryEmulatedDomains, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrQueryEmulatedDomains\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct BrowserrServerEnumEx *r2 = (struct BrowserrServerEnumEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function BrowserrServerEnumEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(BrowserrServerEnumEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in BrowserrServerEnumEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_browser, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS browser__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_browser.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_browser_interface = {
	.name		= "browser",
	.syntax_id  = {{0x6bffd098,0xa112,0x3610,{0x98,0x33},{0x01,0x28,0x92,0x02,0x01,0x62}},0.0},
	.bind		= browser__op_bind,
	.unbind		= browser__op_unbind,
	.ndr_pull	= browser__op_ndr_pull,
	.dispatch	= browser__op_dispatch,
	.reply		= browser__op_reply,
	.ndr_push	= browser__op_ndr_push
};


static NTSTATUS browser__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_browser.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_browser.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_browser_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("browser_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL browser__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_browser_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_browser_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_browser_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL browser__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_browser_interface.name, name)==0) {
		memcpy(iface, &dcesrv_browser_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_browser_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "browser";

	/* fill in all the operations */
	ep_server.init_server = browser__op_init_server;

	ep_server.interface_by_uuid = browser__op_interface_by_uuid;
	ep_server.interface_by_name = browser__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'browser' endpoint server!\n"));
		return ret;
	}

	return ret;
}

