/* This file is autogenerated by pidl. DO NOT EDIT */
%module krb5pac

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_krb5pac_c.h"
#include "librpc/gen_ndr/krb5pac.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(PAC_SIGNATURE_DATA);
%types(PAC_LOGON_INFO_CTR);
%types(PAC_TYPE);
%types(PAC_INFO);
%types(PAC_BUFFER);
%types(PAC_DATA);
%types(PAC_BUFFER_RAW);
%types(PAC_DATA_RAW);


%inline {
struct krb5pac { struct dcerpc_pipe *pipe; };
}

%extend krb5pac {
	krb5pac (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct krb5pac *ret = talloc(mem_ctx, struct krb5pac);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_krb5pac, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~krb5pac() {
		talloc_free(self);
	}
	
	/* decode_pac */
	void decode_pac(struct PAC_DATA pac, TALLOC_CTX *mem_ctx = NULL)
	{
		struct decode_pac r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.pac = pac;
		
		status = dcerpc_decode_pac(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
	}
	
	/* decode_pac_raw */
	void decode_pac_raw(struct PAC_DATA_RAW pac, TALLOC_CTX *mem_ctx = NULL)
	{
		struct decode_pac_raw r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.pac = pac;
		
		status = dcerpc_decode_pac_raw(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
	}
	
	/* decode_login_info */
	void decode_login_info(struct PAC_LOGON_INFO logon_info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct decode_login_info r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_info = logon_info;
		
		status = dcerpc_decode_login_info(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
	}
	
};

/* PAC_LOGON_NAME */
/* PAC_SIGNATURE_DATA */
/* PAC_LOGON_INFO */
/* PAC_LOGON_INFO_CTR */
/* PAC_TYPE */
/* PAC_INFO */
/* PAC_BUFFER */
/* PAC_DATA */
/* DATA_BLOB_REM */
/* PAC_BUFFER_RAW */
/* PAC_DATA_RAW */

