/* header auto-generated by pidl */

#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/nbt.h"
#ifndef _HEADER_irpc
#define _HEADER_irpc

/* bitmap irpc_flags */
#define IRPC_FLAG_REPLY ( 0x0001 )

struct irpc_header {
	struct GUID uuid;
	uint32_t if_version;
	uint32_t callnum;
	uint32_t callid;
	uint32_t flags;
	NTSTATUS status;
}/* [public,noejs] */;

#ifndef USE_UINT_ENUMS
enum nbtd_info_level {
	NBTD_INFO_STATISTICS
};
#else
enum nbtd_info_level { __donnot_use_enum_nbtd_info_level=0x7FFFFFFF};
#define NBTD_INFO_STATISTICS ( 0 )
#endif

struct nbtd_statistics {
	uint64_t total_received;
	uint64_t total_sent;
	uint64_t query_count;
	uint64_t register_count;
	uint64_t release_count;
};

union nbtd_info {
	struct nbtd_statistics *stats;/* [unique,case(NBTD_INFO_STATISTICS)] */
};

struct nbtd_proxy_wins_addr {
	const char * addr;
}/* [noejs] */;

#ifndef USE_UINT_ENUMS
enum smbsrv_info_level {
	SMBSRV_INFO_SESSIONS,
	SMBSRV_INFO_TCONS
};
#else
enum smbsrv_info_level { __donnot_use_enum_smbsrv_info_level=0x7FFFFFFF};
#define SMBSRV_INFO_SESSIONS ( 0 )
#define SMBSRV_INFO_TCONS ( 1 )
#endif

struct smbsrv_session_info {
	uint64_t vuid;
	const char * account_name;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	const char * domain_name;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	const char * client_ip;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	NTTIME connect_time;
	NTTIME auth_time;
	NTTIME last_use_time;
};

struct smbsrv_sessions {
	uint32_t num_sessions;
	struct smbsrv_session_info *sessions;/* [unique,size_is(num_sessions)] */
};

struct smbsrv_tcon_info {
	uint32_t tid;
	const char * share_name;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	const char * client_ip;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	NTTIME connect_time;
	NTTIME last_use_time;
};

struct smbsrv_tcons {
	uint32_t num_tcons;
	struct smbsrv_tcon_info *tcons;/* [unique,size_is(num_tcons)] */
};

union smbsrv_info {
	struct smbsrv_sessions sessions;/* [case(SMBSRV_INFO_SESSIONS)] */
	struct smbsrv_tcons tcons;/* [case(SMBSRV_INFO_TCONS)] */
};


struct irpc_uptime {
	struct {
		NTTIME *start_time;/* [ref] */
	} out;

};


struct nbtd_information {
	struct {
		enum nbtd_info_level level;
	} in;

	struct {
		union nbtd_info info;/* [switch_is(level)] */
	} out;

};


struct nbtd_getdcname {
	struct {
		const char * domainname;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
		const char * ip_address;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
		const char * my_computername;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
		const char * my_accountname;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
		uint32_t account_control;
		struct dom_sid *domain_sid;/* [ref] */
	} in;

	struct {
		const char * dcname;/* [unique,flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	} out;

};


struct nbtd_proxy_wins_challenge {
	struct {
		struct nbt_name name;
		uint32_t num_addrs;
		struct nbtd_proxy_wins_addr *addrs;
	} in;

	struct {
		uint32_t num_addrs;
		struct nbtd_proxy_wins_addr *addrs;
	} out;

};


struct nbtd_proxy_wins_release_demand {
	struct {
		struct nbt_name name;
		uint32_t num_addrs;
		struct nbtd_proxy_wins_addr *addrs;
	} in;

};


struct smbsrv_information {
	struct {
		enum smbsrv_info_level level;
	} in;

	struct {
		union smbsrv_info info;/* [switch_is(level)] */
	} out;

};

#endif /* _HEADER_irpc */
