
#include "includes.h"
#include "librpc/gen_ndr/ndr_dcom.h"
#include "rpc_server/dcerpc_server.h"
#include "rpc_server/common/common.h"

/* dcom interface stub generated by pidl */


static NTSTATUS IUnknown__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IUNKNOWN_BIND
	return DCESRV_INTERFACE_IUNKNOWN_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IUnknown__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IUNKNOWN_UNBIND
	DCESRV_INTERFACE_IUNKNOWN_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IUnknown__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IUnknown.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IUnknown.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IUnknown.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IUnknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IUnknown__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IUnknown_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IUnknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IUnknown__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IUnknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IUnknown__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IUnknown.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IUnknown_interface = {
	.name		= "IUnknown",
	.uuid		= "00000000-0000-0000-C000-000000000046",
	.if_version	= 0.0,
	.bind		= IUnknown__op_bind,
	.unbind		= IUnknown__op_unbind,
	.ndr_pull	= IUnknown__op_ndr_pull,
	.dispatch	= IUnknown__op_dispatch,
	.reply		= IUnknown__op_reply,
	.ndr_push	= IUnknown__op_ndr_push
};


static NTSTATUS IUnknown__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IUnknown.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IUnknown.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IUnknown_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IUnknown_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IUnknown__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IUnknown.if_version == if_version &&
		strcmp(dcerpc_table_IUnknown.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IUnknown, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IUnknown__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IUnknown.name, name)==0) {
		memcpy(iface,&dcerpc_table_IUnknown, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IUnknown_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IUnknown";

	/* fill in all the operations */
	ep_server.init_server = IUnknown__op_init_server;

	ep_server.interface_by_uuid = IUnknown__op_interface_by_uuid;
	ep_server.interface_by_name = IUnknown__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IUnknown' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS IClassFactory__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ICLASSFACTORY_BIND
	return DCESRV_INTERFACE_ICLASSFACTORY_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IClassFactory__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ICLASSFACTORY_UNBIND
	DCESRV_INTERFACE_ICLASSFACTORY_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IClassFactory__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IClassFactory.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IClassFactory.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IClassFactory.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IClassFactory, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IClassFactory__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IClassFactory_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		NTSTATUS result;
		struct CreateInstance *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(CreateInstance, NDR_IN, r2);
		}
		result = vtable->CreateInstance(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function CreateInstance will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct RemoteCreateInstance *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemoteCreateInstance, NDR_IN, r2);
		}
		result = vtable->RemoteCreateInstance(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemoteCreateInstance will reply async\n"));
		}
		break;
	}
	case 5: {
		NTSTATUS result;
		struct LockServer *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(LockServer, NDR_IN, r2);
		}
		result = vtable->LockServer(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function LockServer will reply async\n"));
		}
		break;
	}
	case 6: {
		NTSTATUS result;
		struct RemoteLockServer *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemoteLockServer, NDR_IN, r2);
		}
		result = vtable->RemoteLockServer(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemoteLockServer will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IClassFactory, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IClassFactory__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct CreateInstance *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function CreateInstance replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(CreateInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in CreateInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct RemoteCreateInstance *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemoteCreateInstance replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemoteCreateInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemoteCreateInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct LockServer *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function LockServer replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(LockServer, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in LockServer\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct RemoteLockServer *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemoteLockServer replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemoteLockServer, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemoteLockServer\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IClassFactory, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IClassFactory__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IClassFactory.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IClassFactory_interface = {
	.name		= "IClassFactory",
	.uuid		= "00000001-0000-0000-C000-000000000046",
	.if_version	= 0.0,
	.bind		= IClassFactory__op_bind,
	.unbind		= IClassFactory__op_unbind,
	.ndr_pull	= IClassFactory__op_ndr_pull,
	.dispatch	= IClassFactory__op_dispatch,
	.reply		= IClassFactory__op_reply,
	.ndr_push	= IClassFactory__op_ndr_push
};


static NTSTATUS IClassFactory__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IClassFactory.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IClassFactory.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IClassFactory_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IClassFactory_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IClassFactory__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IClassFactory.if_version == if_version &&
		strcmp(dcerpc_table_IClassFactory.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IClassFactory, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IClassFactory__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IClassFactory.name, name)==0) {
		memcpy(iface,&dcerpc_table_IClassFactory, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IClassFactory_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IClassFactory";

	/* fill in all the operations */
	ep_server.init_server = IClassFactory__op_init_server;

	ep_server.interface_by_uuid = IClassFactory__op_interface_by_uuid;
	ep_server.interface_by_name = IClassFactory__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IClassFactory' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS IRemUnknown__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IREMUNKNOWN_BIND
	return DCESRV_INTERFACE_IREMUNKNOWN_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IRemUnknown__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IREMUNKNOWN_UNBIND
	DCESRV_INTERFACE_IREMUNKNOWN_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IRemUnknown__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IRemUnknown.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IRemUnknown.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IRemUnknown.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IRemUnknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IRemUnknown__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IRemUnknown_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		NTSTATUS result;
		struct RemQueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface, NDR_IN, r2);
		}
		result = vtable->RemQueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemQueryInterface will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct RemAddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemAddRef, NDR_IN, r2);
		}
		result = vtable->RemAddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemAddRef will reply async\n"));
		}
		break;
	}
	case 5: {
		NTSTATUS result;
		struct RemRelease *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemRelease, NDR_IN, r2);
		}
		result = vtable->RemRelease(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemRelease will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IRemUnknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IRemUnknown__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct RemQueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemQueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemQueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct RemAddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemAddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemAddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemAddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct RemRelease *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemRelease replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemRelease, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemRelease\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IRemUnknown, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IRemUnknown__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IRemUnknown.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IRemUnknown_interface = {
	.name		= "IRemUnknown",
	.uuid		= "00000131-0000-0000-C000-000000000046",
	.if_version	= 0.0,
	.bind		= IRemUnknown__op_bind,
	.unbind		= IRemUnknown__op_unbind,
	.ndr_pull	= IRemUnknown__op_ndr_pull,
	.dispatch	= IRemUnknown__op_dispatch,
	.reply		= IRemUnknown__op_reply,
	.ndr_push	= IRemUnknown__op_ndr_push
};


static NTSTATUS IRemUnknown__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IRemUnknown.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IRemUnknown.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IRemUnknown_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IRemUnknown_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IRemUnknown__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IRemUnknown.if_version == if_version &&
		strcmp(dcerpc_table_IRemUnknown.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IRemUnknown, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IRemUnknown__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IRemUnknown.name, name)==0) {
		memcpy(iface,&dcerpc_table_IRemUnknown, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IRemUnknown_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IRemUnknown";

	/* fill in all the operations */
	ep_server.init_server = IRemUnknown__op_init_server;

	ep_server.interface_by_uuid = IRemUnknown__op_interface_by_uuid;
	ep_server.interface_by_name = IRemUnknown__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IRemUnknown' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS IClassActivator__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ICLASSACTIVATOR_BIND
	return DCESRV_INTERFACE_ICLASSACTIVATOR_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IClassActivator__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ICLASSACTIVATOR_UNBIND
	DCESRV_INTERFACE_ICLASSACTIVATOR_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IClassActivator__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IClassActivator.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IClassActivator.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IClassActivator.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IClassActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IClassActivator__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IClassActivator_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		struct GetClassObject *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_IN, r2);
		}
		vtable->GetClassObject(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetClassObject will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IClassActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IClassActivator__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct GetClassObject *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetClassObject replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetClassObject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IClassActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IClassActivator__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IClassActivator.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IClassActivator_interface = {
	.name		= "IClassActivator",
	.uuid		= "00000140-0000-0000-c000-000000000046",
	.if_version	= 0.0,
	.bind		= IClassActivator__op_bind,
	.unbind		= IClassActivator__op_unbind,
	.ndr_pull	= IClassActivator__op_ndr_pull,
	.dispatch	= IClassActivator__op_dispatch,
	.reply		= IClassActivator__op_reply,
	.ndr_push	= IClassActivator__op_ndr_push
};


static NTSTATUS IClassActivator__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IClassActivator.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IClassActivator.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IClassActivator_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IClassActivator_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IClassActivator__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IClassActivator.if_version == if_version &&
		strcmp(dcerpc_table_IClassActivator.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IClassActivator, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IClassActivator__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IClassActivator.name, name)==0) {
		memcpy(iface,&dcerpc_table_IClassActivator, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IClassActivator_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IClassActivator";

	/* fill in all the operations */
	ep_server.init_server = IClassActivator__op_init_server;

	ep_server.interface_by_uuid = IClassActivator__op_interface_by_uuid;
	ep_server.interface_by_name = IClassActivator__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IClassActivator' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS ISCMLocalActivator__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ISCMLOCALACTIVATOR_BIND
	return DCESRV_INTERFACE_ISCMLOCALACTIVATOR_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ISCMLocalActivator__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ISCMLOCALACTIVATOR_UNBIND
	DCESRV_INTERFACE_ISCMLOCALACTIVATOR_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ISCMLocalActivator__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_ISCMLocalActivator.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_ISCMLocalActivator.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_ISCMLocalActivator.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_ISCMLocalActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ISCMLocalActivator__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_ISCMLocalActivator_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		struct GetClassObject *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_IN, r2);
		}
		vtable->GetClassObject(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetClassObject will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct ISCMLocalActivator_CreateInstance *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(ISCMLocalActivator_CreateInstance, NDR_IN, r2);
		}
		result = vtable->ISCMLocalActivator_CreateInstance(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ISCMLocalActivator_CreateInstance will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ISCMLocalActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ISCMLocalActivator__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct GetClassObject *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetClassObject replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetClassObject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct ISCMLocalActivator_CreateInstance *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ISCMLocalActivator_CreateInstance replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ISCMLocalActivator_CreateInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ISCMLocalActivator_CreateInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ISCMLocalActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ISCMLocalActivator__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_ISCMLocalActivator.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface ISCMLocalActivator_interface = {
	.name		= "ISCMLocalActivator",
	.uuid		= "00000136-0000-0000-c000-000000000046",
	.if_version	= 0.0,
	.bind		= ISCMLocalActivator__op_bind,
	.unbind		= ISCMLocalActivator__op_unbind,
	.ndr_pull	= ISCMLocalActivator__op_ndr_pull,
	.dispatch	= ISCMLocalActivator__op_dispatch,
	.reply		= ISCMLocalActivator__op_reply,
	.ndr_push	= ISCMLocalActivator__op_ndr_push
};


static NTSTATUS ISCMLocalActivator__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_ISCMLocalActivator.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_ISCMLocalActivator.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &ISCMLocalActivator_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ISCMLocalActivator_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL ISCMLocalActivator__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_ISCMLocalActivator.if_version == if_version &&
		strcmp(dcerpc_table_ISCMLocalActivator.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_ISCMLocalActivator, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL ISCMLocalActivator__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_ISCMLocalActivator.name, name)==0) {
		memcpy(iface,&dcerpc_table_ISCMLocalActivator, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_ISCMLocalActivator_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ISCMLocalActivator";

	/* fill in all the operations */
	ep_server.init_server = ISCMLocalActivator__op_init_server;

	ep_server.interface_by_uuid = ISCMLocalActivator__op_interface_by_uuid;
	ep_server.interface_by_name = ISCMLocalActivator__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ISCMLocalActivator' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS ISystemActivator__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ISYSTEMACTIVATOR_BIND
	return DCESRV_INTERFACE_ISYSTEMACTIVATOR_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ISystemActivator__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ISYSTEMACTIVATOR_UNBIND
	DCESRV_INTERFACE_ISYSTEMACTIVATOR_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ISystemActivator__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_ISystemActivator.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_ISystemActivator.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_ISystemActivator.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_ISystemActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ISystemActivator__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_ISystemActivator_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		struct GetClassObject *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_IN, r2);
		}
		vtable->GetClassObject(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetClassObject will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct ISystemActivatorRemoteCreateInstance *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(ISystemActivatorRemoteCreateInstance, NDR_IN, r2);
		}
		result = vtable->ISystemActivatorRemoteCreateInstance(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ISystemActivatorRemoteCreateInstance will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ISystemActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ISystemActivator__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct GetClassObject *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetClassObject replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetClassObject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetClassObject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct ISystemActivatorRemoteCreateInstance *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ISystemActivatorRemoteCreateInstance replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ISystemActivatorRemoteCreateInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ISystemActivatorRemoteCreateInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ISystemActivator, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ISystemActivator__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_ISystemActivator.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface ISystemActivator_interface = {
	.name		= "ISystemActivator",
	.uuid		= "000001a0-0000-0000-c000-000000000046",
	.if_version	= 0.0,
	.bind		= ISystemActivator__op_bind,
	.unbind		= ISystemActivator__op_unbind,
	.ndr_pull	= ISystemActivator__op_ndr_pull,
	.dispatch	= ISystemActivator__op_dispatch,
	.reply		= ISystemActivator__op_reply,
	.ndr_push	= ISystemActivator__op_ndr_push
};


static NTSTATUS ISystemActivator__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_ISystemActivator.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_ISystemActivator.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &ISystemActivator_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ISystemActivator_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL ISystemActivator__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_ISystemActivator.if_version == if_version &&
		strcmp(dcerpc_table_ISystemActivator.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_ISystemActivator, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL ISystemActivator__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_ISystemActivator.name, name)==0) {
		memcpy(iface,&dcerpc_table_ISystemActivator, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_ISystemActivator_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ISystemActivator";

	/* fill in all the operations */
	ep_server.init_server = ISystemActivator__op_init_server;

	ep_server.interface_by_uuid = ISystemActivator__op_interface_by_uuid;
	ep_server.interface_by_name = ISystemActivator__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ISystemActivator' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS IRemUnknown2__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IREMUNKNOWN2_BIND
	return DCESRV_INTERFACE_IREMUNKNOWN2_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IRemUnknown2__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IREMUNKNOWN2_UNBIND
	DCESRV_INTERFACE_IREMUNKNOWN2_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IRemUnknown2__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IRemUnknown2.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IRemUnknown2.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IRemUnknown2.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IRemUnknown2, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IRemUnknown2__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IRemUnknown2_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		NTSTATUS result;
		struct RemQueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface, NDR_IN, r2);
		}
		result = vtable->RemQueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemQueryInterface will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct RemAddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemAddRef, NDR_IN, r2);
		}
		result = vtable->RemAddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemAddRef will reply async\n"));
		}
		break;
	}
	case 5: {
		NTSTATUS result;
		struct RemRelease *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemRelease, NDR_IN, r2);
		}
		result = vtable->RemRelease(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemRelease will reply async\n"));
		}
		break;
	}
	case 6: {
		NTSTATUS result;
		struct RemQueryInterface2 *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface2, NDR_IN, r2);
		}
		result = vtable->RemQueryInterface2(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemQueryInterface2 will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IRemUnknown2, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IRemUnknown2__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct RemQueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemQueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemQueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct RemAddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemAddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemAddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemAddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct RemRelease *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemRelease replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemRelease, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemRelease\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct RemQueryInterface2 *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function RemQueryInterface2 replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(RemQueryInterface2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in RemQueryInterface2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IRemUnknown2, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IRemUnknown2__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IRemUnknown2.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IRemUnknown2_interface = {
	.name		= "IRemUnknown2",
	.uuid		= "00000143-0000-0000-C000-000000000046",
	.if_version	= 0.0,
	.bind		= IRemUnknown2__op_bind,
	.unbind		= IRemUnknown2__op_unbind,
	.ndr_pull	= IRemUnknown2__op_ndr_pull,
	.dispatch	= IRemUnknown2__op_dispatch,
	.reply		= IRemUnknown2__op_reply,
	.ndr_push	= IRemUnknown2__op_ndr_push
};


static NTSTATUS IRemUnknown2__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IRemUnknown2.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IRemUnknown2.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IRemUnknown2_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IRemUnknown2_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IRemUnknown2__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IRemUnknown2.if_version == if_version &&
		strcmp(dcerpc_table_IRemUnknown2.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IRemUnknown2, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IRemUnknown2__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IRemUnknown2.name, name)==0) {
		memcpy(iface,&dcerpc_table_IRemUnknown2, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IRemUnknown2_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IRemUnknown2";

	/* fill in all the operations */
	ep_server.init_server = IRemUnknown2__op_init_server;

	ep_server.interface_by_uuid = IRemUnknown2__op_interface_by_uuid;
	ep_server.interface_by_name = IRemUnknown2__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IRemUnknown2' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS IDispatch__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IDISPATCH_BIND
	return DCESRV_INTERFACE_IDISPATCH_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IDispatch__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IDISPATCH_UNBIND
	DCESRV_INTERFACE_IDISPATCH_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IDispatch__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IDispatch.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IDispatch.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IDispatch.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IDispatch, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IDispatch__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IDispatch_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		NTSTATUS result;
		struct GetTypeInfoCount *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetTypeInfoCount, NDR_IN, r2);
		}
		result = vtable->GetTypeInfoCount(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetTypeInfoCount will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct GetTypeInfo *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetTypeInfo, NDR_IN, r2);
		}
		result = vtable->GetTypeInfo(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetTypeInfo will reply async\n"));
		}
		break;
	}
	case 5: {
		NTSTATUS result;
		struct GetIDsOfNames *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(GetIDsOfNames, NDR_IN, r2);
		}
		result = vtable->GetIDsOfNames(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetIDsOfNames will reply async\n"));
		}
		break;
	}
	case 6: {
		NTSTATUS result;
		struct Invoke *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Invoke, NDR_IN, r2);
		}
		result = vtable->Invoke(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Invoke will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IDispatch, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IDispatch__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct GetTypeInfoCount *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetTypeInfoCount replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetTypeInfoCount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetTypeInfoCount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct GetTypeInfo *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetTypeInfo replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetTypeInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetTypeInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct GetIDsOfNames *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function GetIDsOfNames replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(GetIDsOfNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in GetIDsOfNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct Invoke *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Invoke replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Invoke, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Invoke\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IDispatch, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IDispatch__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IDispatch.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IDispatch_interface = {
	.name		= "IDispatch",
	.uuid		= "00020400-0000-0000-C000-000000000046",
	.if_version	= 0.0,
	.bind		= IDispatch__op_bind,
	.unbind		= IDispatch__op_unbind,
	.ndr_pull	= IDispatch__op_ndr_pull,
	.dispatch	= IDispatch__op_dispatch,
	.reply		= IDispatch__op_reply,
	.ndr_push	= IDispatch__op_ndr_push
};


static NTSTATUS IDispatch__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IDispatch.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IDispatch.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IDispatch_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IDispatch_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IDispatch__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IDispatch.if_version == if_version &&
		strcmp(dcerpc_table_IDispatch.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IDispatch, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IDispatch__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IDispatch.name, name)==0) {
		memcpy(iface,&dcerpc_table_IDispatch, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IDispatch_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IDispatch";

	/* fill in all the operations */
	ep_server.init_server = IDispatch__op_init_server;

	ep_server.interface_by_uuid = IDispatch__op_interface_by_uuid;
	ep_server.interface_by_name = IDispatch__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IDispatch' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS ICoffeeMachine__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ICOFFEEMACHINE_BIND
	return DCESRV_INTERFACE_ICOFFEEMACHINE_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ICoffeeMachine__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ICOFFEEMACHINE_UNBIND
	DCESRV_INTERFACE_ICOFFEEMACHINE_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ICoffeeMachine__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_ICoffeeMachine.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_ICoffeeMachine.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_ICoffeeMachine.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_ICoffeeMachine, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ICoffeeMachine__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_ICoffeeMachine_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		NTSTATUS result;
		struct MakeCoffee *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(MakeCoffee, NDR_IN, r2);
		}
		result = vtable->MakeCoffee(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function MakeCoffee will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ICoffeeMachine, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ICoffeeMachine__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct MakeCoffee *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function MakeCoffee replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(MakeCoffee, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in MakeCoffee\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_ICoffeeMachine, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ICoffeeMachine__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_ICoffeeMachine.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface ICoffeeMachine_interface = {
	.name		= "ICoffeeMachine",
	.uuid		= "DA23F6DB-6F45-466C-9EED-0B65286F2D78",
	.if_version	= 0.0,
	.bind		= ICoffeeMachine__op_bind,
	.unbind		= ICoffeeMachine__op_unbind,
	.ndr_pull	= ICoffeeMachine__op_ndr_pull,
	.dispatch	= ICoffeeMachine__op_dispatch,
	.reply		= ICoffeeMachine__op_reply,
	.ndr_push	= ICoffeeMachine__op_ndr_push
};


static NTSTATUS ICoffeeMachine__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_ICoffeeMachine.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_ICoffeeMachine.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &ICoffeeMachine_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ICoffeeMachine_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL ICoffeeMachine__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_ICoffeeMachine.if_version == if_version &&
		strcmp(dcerpc_table_ICoffeeMachine.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_ICoffeeMachine, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL ICoffeeMachine__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_ICoffeeMachine.name, name)==0) {
		memcpy(iface,&dcerpc_table_ICoffeeMachine, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_ICoffeeMachine_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ICoffeeMachine";

	/* fill in all the operations */
	ep_server.init_server = ICoffeeMachine__op_init_server;

	ep_server.interface_by_uuid = ICoffeeMachine__op_interface_by_uuid;
	ep_server.interface_by_name = ICoffeeMachine__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ICoffeeMachine' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* dcom interface stub generated by pidl */


static NTSTATUS IStream__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ISTREAM_BIND
	return DCESRV_INTERFACE_ISTREAM_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IStream__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ISTREAM_UNBIND
	DCESRV_INTERFACE_ISTREAM_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IStream__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IStream.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IStream.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IStream.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IStream, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IStream__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct GUID ipid = dce_call->pkt.u.request.object.object;
	struct dcom_interface_p *iface = dcom_get_local_iface_p(&ipid);
	const struct dcom_IStream_vtable *vtable = iface->vtable;

	switch (opnum) {
	case 0: {
		NTSTATUS result;
		struct QueryInterface *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_IN, r2);
		}
		result = vtable->QueryInterface(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface will reply async\n"));
		}
		break;
	}
	case 1: {
		NTSTATUS result;
		struct AddRef *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_IN, r2);
		}
		result = vtable->AddRef(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef will reply async\n"));
		}
		break;
	}
	case 2: {
		NTSTATUS result;
		struct Release *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_IN, r2);
		}
		result = vtable->Release(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release will reply async\n"));
		}
		break;
	}
	case 3: {
		NTSTATUS result;
		struct Read *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Read, NDR_IN, r2);
		}
		result = vtable->Read(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Read will reply async\n"));
		}
		break;
	}
	case 4: {
		NTSTATUS result;
		struct Write *r2 = r;
		if (DEBUGLEVEL > 10) {
			NDR_PRINT_FUNCTION_DEBUG(Write, NDR_IN, r2);
		}
		result = vtable->Write(iface, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Write will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IStream, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IStream__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct QueryInterface *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function QueryInterface replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(QueryInterface, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in QueryInterface\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct AddRef *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function AddRef replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(AddRef, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in AddRef\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct Release *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Release replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Release, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Release\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct Read *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Read replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Read, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Read\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct Write *r2 = r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function Write replied async\n"));
		}
		if (DEBUGLEVEL > 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(Write, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in Write\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IStream, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IStream__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IStream.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface IStream_interface = {
	.name		= "IStream",
	.uuid		= "0000000C-0000-0000-C000-000000000046",
	.if_version	= 0.0,
	.bind		= IStream__op_bind,
	.unbind		= IStream__op_unbind,
	.ndr_pull	= IStream__op_ndr_pull,
	.dispatch	= IStream__op_dispatch,
	.reply		= IStream__op_reply,
	.ndr_push	= IStream__op_ndr_push
};


static NTSTATUS IStream__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IStream.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IStream.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &IStream_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IStream_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IStream__op_interface_by_uuid(struct dcesrv_interface *iface, const char *uuid, uint32_t if_version)
{
	if (dcerpc_table_IStream.if_version == if_version &&
		strcmp(dcerpc_table_IStream.uuid, uuid)==0) {
		memcpy(iface,&dcerpc_table_IStream, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IStream__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcerpc_table_IStream.name, name)==0) {
		memcpy(iface,&dcerpc_table_IStream, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IStream_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IStream";

	/* fill in all the operations */
	ep_server.init_server = IStream__op_init_server;

	ep_server.interface_by_uuid = IStream__op_interface_by_uuid;
	ep_server.interface_by_name = IStream__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IStream' endpoint server!\n"));
		return ret;
	}

	return ret;
}


