
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_svcctl.h"
#include "../librpc/gen_ndr/ndr_svcctl_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject SERVICE_LOCK_STATUS_Type;
staticforward PyTypeObject SERVICE_STATUS_Type;
staticforward PyTypeObject SERVICE_STATUS_PROCESS_Type;
staticforward PyTypeObject ENUM_SERVICE_STATUSW_Type;
staticforward PyTypeObject ENUM_SERVICE_STATUSA_Type;
staticforward PyTypeObject QUERY_SERVICE_CONFIG_Type;
staticforward PyTypeObject svcctl_ArgumentString_Type;
staticforward PyTypeObject SERVICE_DESCRIPTION_Type;
staticforward PyTypeObject SC_ACTION_Type;
staticforward PyTypeObject SERVICE_FAILURE_ACTIONS_Type;
staticforward PyTypeObject svcctl_InterfaceType;

static PyTypeObject *policy_handle_Type;

static PyObject *py_SERVICE_LOCK_STATUS_get_is_locked(PyObject *obj, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = (struct SERVICE_LOCK_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_is_locked;
	py_is_locked = PyInt_FromLong(object->is_locked);
	return py_is_locked;
}

static int py_SERVICE_LOCK_STATUS_set_is_locked(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = (struct SERVICE_LOCK_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->is_locked = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_LOCK_STATUS_get_lock_owner(PyObject *obj, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = (struct SERVICE_LOCK_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_lock_owner;
	if (object->lock_owner == NULL) {
		py_lock_owner = Py_None;
	} else {
		py_lock_owner = PyUnicode_Decode(object->lock_owner, strlen(object->lock_owner), "utf-8", "ignore");
	}
	return py_lock_owner;
}

static int py_SERVICE_LOCK_STATUS_set_lock_owner(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = (struct SERVICE_LOCK_STATUS *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->lock_owner = NULL;
	} else {
		object->lock_owner = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->lock_owner);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->lock_owner = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_SERVICE_LOCK_STATUS_get_lock_duration(PyObject *obj, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = (struct SERVICE_LOCK_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_lock_duration;
	py_lock_duration = PyInt_FromLong(object->lock_duration);
	return py_lock_duration;
}

static int py_SERVICE_LOCK_STATUS_set_lock_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_LOCK_STATUS *object = (struct SERVICE_LOCK_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lock_duration = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_SERVICE_LOCK_STATUS_getsetters[] = {
	{ discard_const_p(char, "is_locked"), py_SERVICE_LOCK_STATUS_get_is_locked, py_SERVICE_LOCK_STATUS_set_is_locked },
	{ discard_const_p(char, "lock_owner"), py_SERVICE_LOCK_STATUS_get_lock_owner, py_SERVICE_LOCK_STATUS_set_lock_owner },
	{ discard_const_p(char, "lock_duration"), py_SERVICE_LOCK_STATUS_get_lock_duration, py_SERVICE_LOCK_STATUS_set_lock_duration },
	{ NULL }
};

static PyObject *py_SERVICE_LOCK_STATUS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct SERVICE_LOCK_STATUS, type);
}


static PyTypeObject SERVICE_LOCK_STATUS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.SERVICE_LOCK_STATUS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_SERVICE_LOCK_STATUS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_LOCK_STATUS_new,
};


static PyObject *py_SERVICE_STATUS_get_type(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_SERVICE_STATUS_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_state(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_state;
	py_state = PyInt_FromLong(object->state);
	return py_state;
}

static int py_SERVICE_STATUS_set_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->state = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_controls_accepted(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_controls_accepted;
	py_controls_accepted = PyInt_FromLong(object->controls_accepted);
	return py_controls_accepted;
}

static int py_SERVICE_STATUS_set_controls_accepted(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->controls_accepted = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_win32_exit_code(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_win32_exit_code;
	py_win32_exit_code = PyErr_FromWERROR(object->win32_exit_code);
	return py_win32_exit_code;
}

static int py_SERVICE_STATUS_set_win32_exit_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	object->win32_exit_code = W_ERROR(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_service_exit_code(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_service_exit_code;
	py_service_exit_code = PyInt_FromLong(object->service_exit_code);
	return py_service_exit_code;
}

static int py_SERVICE_STATUS_set_service_exit_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->service_exit_code = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_check_point(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_check_point;
	py_check_point = PyInt_FromLong(object->check_point);
	return py_check_point;
}

static int py_SERVICE_STATUS_set_check_point(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->check_point = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_get_wait_hint(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(obj);
	PyObject *py_wait_hint;
	py_wait_hint = PyInt_FromLong(object->wait_hint);
	return py_wait_hint;
}

static int py_SERVICE_STATUS_set_wait_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS *object = (struct SERVICE_STATUS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wait_hint = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_SERVICE_STATUS_getsetters[] = {
	{ discard_const_p(char, "type"), py_SERVICE_STATUS_get_type, py_SERVICE_STATUS_set_type },
	{ discard_const_p(char, "state"), py_SERVICE_STATUS_get_state, py_SERVICE_STATUS_set_state },
	{ discard_const_p(char, "controls_accepted"), py_SERVICE_STATUS_get_controls_accepted, py_SERVICE_STATUS_set_controls_accepted },
	{ discard_const_p(char, "win32_exit_code"), py_SERVICE_STATUS_get_win32_exit_code, py_SERVICE_STATUS_set_win32_exit_code },
	{ discard_const_p(char, "service_exit_code"), py_SERVICE_STATUS_get_service_exit_code, py_SERVICE_STATUS_set_service_exit_code },
	{ discard_const_p(char, "check_point"), py_SERVICE_STATUS_get_check_point, py_SERVICE_STATUS_set_check_point },
	{ discard_const_p(char, "wait_hint"), py_SERVICE_STATUS_get_wait_hint, py_SERVICE_STATUS_set_wait_hint },
	{ NULL }
};

static PyObject *py_SERVICE_STATUS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct SERVICE_STATUS, type);
}


static PyTypeObject SERVICE_STATUS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.SERVICE_STATUS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_SERVICE_STATUS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_STATUS_new,
};


static PyObject *py_SERVICE_STATUS_PROCESS_get_status(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = py_talloc_import_ex(&SERVICE_STATUS_Type, py_talloc_get_mem_ctx(obj), &object->status);
	return py_status;
}

static int py_SERVICE_STATUS_PROCESS_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	memcpy(&object->status, py_talloc_get_ptr(value), sizeof(object->status));
	return 0;
}

static PyObject *py_SERVICE_STATUS_PROCESS_get_process_id(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(obj);
	PyObject *py_process_id;
	py_process_id = PyInt_FromLong(object->process_id);
	return py_process_id;
}

static int py_SERVICE_STATUS_PROCESS_set_process_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->process_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_STATUS_PROCESS_get_service_flags(PyObject *obj, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(obj);
	PyObject *py_service_flags;
	py_service_flags = PyInt_FromLong(object->service_flags);
	return py_service_flags;
}

static int py_SERVICE_STATUS_PROCESS_set_service_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->service_flags = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_SERVICE_STATUS_PROCESS_getsetters[] = {
	{ discard_const_p(char, "status"), py_SERVICE_STATUS_PROCESS_get_status, py_SERVICE_STATUS_PROCESS_set_status },
	{ discard_const_p(char, "process_id"), py_SERVICE_STATUS_PROCESS_get_process_id, py_SERVICE_STATUS_PROCESS_set_process_id },
	{ discard_const_p(char, "service_flags"), py_SERVICE_STATUS_PROCESS_get_service_flags, py_SERVICE_STATUS_PROCESS_set_service_flags },
	{ NULL }
};

static PyObject *py_SERVICE_STATUS_PROCESS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct SERVICE_STATUS_PROCESS, type);
}

static PyObject *py_SERVICE_STATUS_PROCESS_ndr_pack(PyObject *py_obj)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_SERVICE_STATUS_PROCESS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_SERVICE_STATUS_PROCESS_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct SERVICE_STATUS_PROCESS *object = (struct SERVICE_STATUS_PROCESS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_STATUS_PROCESS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_SERVICE_STATUS_PROCESS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SERVICE_STATUS_PROCESS_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_SERVICE_STATUS_PROCESS_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SERVICE_STATUS_PROCESS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.SERVICE_STATUS_PROCESS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_SERVICE_STATUS_PROCESS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_SERVICE_STATUS_PROCESS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_STATUS_PROCESS_new,
};


static PyObject *py_ENUM_SERVICE_STATUSW_get_service_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(obj);
	PyObject *py_service_name;
	py_service_name = PyString_FromString(object->service_name);
	return py_service_name;
}

static int py_ENUM_SERVICE_STATUSW_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(py_obj);
	object->service_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSW_get_display_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(obj);
	PyObject *py_display_name;
	py_display_name = PyString_FromString(object->display_name);
	return py_display_name;
}

static int py_ENUM_SERVICE_STATUSW_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(py_obj);
	object->display_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSW_get_status(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = py_talloc_import_ex(&SERVICE_STATUS_Type, py_talloc_get_mem_ctx(obj), &object->status);
	return py_status;
}

static int py_ENUM_SERVICE_STATUSW_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	memcpy(&object->status, py_talloc_get_ptr(value), sizeof(object->status));
	return 0;
}

static PyGetSetDef py_ENUM_SERVICE_STATUSW_getsetters[] = {
	{ discard_const_p(char, "service_name"), py_ENUM_SERVICE_STATUSW_get_service_name, py_ENUM_SERVICE_STATUSW_set_service_name },
	{ discard_const_p(char, "display_name"), py_ENUM_SERVICE_STATUSW_get_display_name, py_ENUM_SERVICE_STATUSW_set_display_name },
	{ discard_const_p(char, "status"), py_ENUM_SERVICE_STATUSW_get_status, py_ENUM_SERVICE_STATUSW_set_status },
	{ NULL }
};

static PyObject *py_ENUM_SERVICE_STATUSW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct ENUM_SERVICE_STATUSW, type);
}

static PyObject *py_ENUM_SERVICE_STATUSW_ndr_pack(PyObject *py_obj)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_ENUM_SERVICE_STATUSW);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ENUM_SERVICE_STATUSW_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct ENUM_SERVICE_STATUSW *object = (struct ENUM_SERVICE_STATUSW *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_ENUM_SERVICE_STATUSW);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_ENUM_SERVICE_STATUSW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ENUM_SERVICE_STATUSW_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ENUM_SERVICE_STATUSW_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ENUM_SERVICE_STATUSW_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.ENUM_SERVICE_STATUSW",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_ENUM_SERVICE_STATUSW_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_ENUM_SERVICE_STATUSW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ENUM_SERVICE_STATUSW_new,
};


static PyObject *py_ENUM_SERVICE_STATUSA_get_service_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(obj);
	PyObject *py_service_name;
	py_service_name = PyString_FromString(object->service_name);
	return py_service_name;
}

static int py_ENUM_SERVICE_STATUSA_set_service_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(py_obj);
	object->service_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSA_get_display_name(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(obj);
	PyObject *py_display_name;
	py_display_name = PyString_FromString(object->display_name);
	return py_display_name;
}

static int py_ENUM_SERVICE_STATUSA_set_display_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(py_obj);
	object->display_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_ENUM_SERVICE_STATUSA_get_status(PyObject *obj, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = py_talloc_import_ex(&SERVICE_STATUS_Type, py_talloc_get_mem_ctx(obj), &object->status);
	return py_status;
}

static int py_ENUM_SERVICE_STATUSA_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&SERVICE_STATUS_Type, value, return -1;);
	memcpy(&object->status, py_talloc_get_ptr(value), sizeof(object->status));
	return 0;
}

static PyGetSetDef py_ENUM_SERVICE_STATUSA_getsetters[] = {
	{ discard_const_p(char, "service_name"), py_ENUM_SERVICE_STATUSA_get_service_name, py_ENUM_SERVICE_STATUSA_set_service_name },
	{ discard_const_p(char, "display_name"), py_ENUM_SERVICE_STATUSA_get_display_name, py_ENUM_SERVICE_STATUSA_set_display_name },
	{ discard_const_p(char, "status"), py_ENUM_SERVICE_STATUSA_get_status, py_ENUM_SERVICE_STATUSA_set_status },
	{ NULL }
};

static PyObject *py_ENUM_SERVICE_STATUSA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct ENUM_SERVICE_STATUSA, type);
}

static PyObject *py_ENUM_SERVICE_STATUSA_ndr_pack(PyObject *py_obj)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_ENUM_SERVICE_STATUSA);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ENUM_SERVICE_STATUSA_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct ENUM_SERVICE_STATUSA *object = (struct ENUM_SERVICE_STATUSA *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_ENUM_SERVICE_STATUSA);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_ENUM_SERVICE_STATUSA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ENUM_SERVICE_STATUSA_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ENUM_SERVICE_STATUSA_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ENUM_SERVICE_STATUSA_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.ENUM_SERVICE_STATUSA",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_ENUM_SERVICE_STATUSA_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_ENUM_SERVICE_STATUSA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ENUM_SERVICE_STATUSA_new,
};


static PyObject *py_QUERY_SERVICE_CONFIG_get_service_type(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_service_type;
	py_service_type = PyInt_FromLong(object->service_type);
	return py_service_type;
}

static int py_QUERY_SERVICE_CONFIG_set_service_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->service_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_start_type(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_start_type;
	py_start_type = PyInt_FromLong(object->start_type);
	return py_start_type;
}

static int py_QUERY_SERVICE_CONFIG_set_start_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->start_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_error_control(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_error_control;
	py_error_control = PyInt_FromLong(object->error_control);
	return py_error_control;
}

static int py_QUERY_SERVICE_CONFIG_set_error_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->error_control = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_executablepath(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_executablepath;
	if (object->executablepath == NULL) {
		py_executablepath = Py_None;
	} else {
		py_executablepath = PyUnicode_Decode(object->executablepath, strlen(object->executablepath), "utf-8", "ignore");
	}
	return py_executablepath;
}

static int py_QUERY_SERVICE_CONFIG_set_executablepath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->executablepath = NULL;
	} else {
		object->executablepath = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->executablepath);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->executablepath = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_loadordergroup(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_loadordergroup;
	if (object->loadordergroup == NULL) {
		py_loadordergroup = Py_None;
	} else {
		py_loadordergroup = PyUnicode_Decode(object->loadordergroup, strlen(object->loadordergroup), "utf-8", "ignore");
	}
	return py_loadordergroup;
}

static int py_QUERY_SERVICE_CONFIG_set_loadordergroup(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->loadordergroup = NULL;
	} else {
		object->loadordergroup = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->loadordergroup);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->loadordergroup = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_tag_id(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_tag_id;
	py_tag_id = PyInt_FromLong(object->tag_id);
	return py_tag_id;
}

static int py_QUERY_SERVICE_CONFIG_set_tag_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->tag_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_dependencies(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_dependencies;
	if (object->dependencies == NULL) {
		py_dependencies = Py_None;
	} else {
		py_dependencies = PyUnicode_Decode(object->dependencies, strlen(object->dependencies), "utf-8", "ignore");
	}
	return py_dependencies;
}

static int py_QUERY_SERVICE_CONFIG_set_dependencies(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dependencies = NULL;
	} else {
		object->dependencies = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->dependencies);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->dependencies = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_startname(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_startname;
	if (object->startname == NULL) {
		py_startname = Py_None;
	} else {
		py_startname = PyUnicode_Decode(object->startname, strlen(object->startname), "utf-8", "ignore");
	}
	return py_startname;
}

static int py_QUERY_SERVICE_CONFIG_set_startname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->startname = NULL;
	} else {
		object->startname = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->startname);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->startname = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_QUERY_SERVICE_CONFIG_get_displayname(PyObject *obj, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(obj);
	PyObject *py_displayname;
	if (object->displayname == NULL) {
		py_displayname = Py_None;
	} else {
		py_displayname = PyUnicode_Decode(object->displayname, strlen(object->displayname), "utf-8", "ignore");
	}
	return py_displayname;
}

static int py_QUERY_SERVICE_CONFIG_set_displayname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->displayname = NULL;
	} else {
		object->displayname = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->displayname);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->displayname = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_QUERY_SERVICE_CONFIG_getsetters[] = {
	{ discard_const_p(char, "service_type"), py_QUERY_SERVICE_CONFIG_get_service_type, py_QUERY_SERVICE_CONFIG_set_service_type },
	{ discard_const_p(char, "start_type"), py_QUERY_SERVICE_CONFIG_get_start_type, py_QUERY_SERVICE_CONFIG_set_start_type },
	{ discard_const_p(char, "error_control"), py_QUERY_SERVICE_CONFIG_get_error_control, py_QUERY_SERVICE_CONFIG_set_error_control },
	{ discard_const_p(char, "executablepath"), py_QUERY_SERVICE_CONFIG_get_executablepath, py_QUERY_SERVICE_CONFIG_set_executablepath },
	{ discard_const_p(char, "loadordergroup"), py_QUERY_SERVICE_CONFIG_get_loadordergroup, py_QUERY_SERVICE_CONFIG_set_loadordergroup },
	{ discard_const_p(char, "tag_id"), py_QUERY_SERVICE_CONFIG_get_tag_id, py_QUERY_SERVICE_CONFIG_set_tag_id },
	{ discard_const_p(char, "dependencies"), py_QUERY_SERVICE_CONFIG_get_dependencies, py_QUERY_SERVICE_CONFIG_set_dependencies },
	{ discard_const_p(char, "startname"), py_QUERY_SERVICE_CONFIG_get_startname, py_QUERY_SERVICE_CONFIG_set_startname },
	{ discard_const_p(char, "displayname"), py_QUERY_SERVICE_CONFIG_get_displayname, py_QUERY_SERVICE_CONFIG_set_displayname },
	{ NULL }
};

static PyObject *py_QUERY_SERVICE_CONFIG_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct QUERY_SERVICE_CONFIG, type);
}

static PyObject *py_QUERY_SERVICE_CONFIG_ndr_pack(PyObject *py_obj)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_QUERY_SERVICE_CONFIG);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_QUERY_SERVICE_CONFIG_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct QUERY_SERVICE_CONFIG *object = (struct QUERY_SERVICE_CONFIG *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_QUERY_SERVICE_CONFIG);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_QUERY_SERVICE_CONFIG_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_QUERY_SERVICE_CONFIG_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_QUERY_SERVICE_CONFIG_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject QUERY_SERVICE_CONFIG_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.QUERY_SERVICE_CONFIG",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_QUERY_SERVICE_CONFIG_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_QUERY_SERVICE_CONFIG_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_QUERY_SERVICE_CONFIG_new,
};


static PyObject *py_svcctl_ArgumentString_get_string(PyObject *obj, void *closure)
{
	struct svcctl_ArgumentString *object = (struct svcctl_ArgumentString *)py_talloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		py_string = Py_None;
	} else {
		py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
	}
	return py_string;
}

static int py_svcctl_ArgumentString_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct svcctl_ArgumentString *object = (struct svcctl_ArgumentString *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->string);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->string = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_svcctl_ArgumentString_getsetters[] = {
	{ discard_const_p(char, "string"), py_svcctl_ArgumentString_get_string, py_svcctl_ArgumentString_set_string },
	{ NULL }
};

static PyObject *py_svcctl_ArgumentString_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct svcctl_ArgumentString, type);
}


static PyTypeObject svcctl_ArgumentString_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.ArgumentString",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_svcctl_ArgumentString_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_svcctl_ArgumentString_new,
};


static PyObject *py_SERVICE_DESCRIPTION_get_description(PyObject *obj, void *closure)
{
	struct SERVICE_DESCRIPTION *object = (struct SERVICE_DESCRIPTION *)py_talloc_get_ptr(obj);
	PyObject *py_description;
	py_description = PyString_FromString(object->description);
	return py_description;
}

static int py_SERVICE_DESCRIPTION_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_DESCRIPTION *object = (struct SERVICE_DESCRIPTION *)py_talloc_get_ptr(py_obj);
	object->description = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyGetSetDef py_SERVICE_DESCRIPTION_getsetters[] = {
	{ discard_const_p(char, "description"), py_SERVICE_DESCRIPTION_get_description, py_SERVICE_DESCRIPTION_set_description },
	{ NULL }
};

static PyObject *py_SERVICE_DESCRIPTION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct SERVICE_DESCRIPTION, type);
}

static PyObject *py_SERVICE_DESCRIPTION_ndr_pack(PyObject *py_obj)
{
	struct SERVICE_DESCRIPTION *object = (struct SERVICE_DESCRIPTION *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_SERVICE_DESCRIPTION);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_SERVICE_DESCRIPTION_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct SERVICE_DESCRIPTION *object = (struct SERVICE_DESCRIPTION *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_DESCRIPTION);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_SERVICE_DESCRIPTION_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SERVICE_DESCRIPTION_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_SERVICE_DESCRIPTION_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SERVICE_DESCRIPTION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.SERVICE_DESCRIPTION",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_SERVICE_DESCRIPTION_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_SERVICE_DESCRIPTION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_DESCRIPTION_new,
};


static PyObject *py_SC_ACTION_get_type(PyObject *obj, void *closure)
{
	struct SC_ACTION *object = (struct SC_ACTION *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_SC_ACTION_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_ACTION *object = (struct SC_ACTION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SC_ACTION_get_delay(PyObject *obj, void *closure)
{
	struct SC_ACTION *object = (struct SC_ACTION *)py_talloc_get_ptr(obj);
	PyObject *py_delay;
	py_delay = PyInt_FromLong(object->delay);
	return py_delay;
}

static int py_SC_ACTION_set_delay(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SC_ACTION *object = (struct SC_ACTION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->delay = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_SC_ACTION_getsetters[] = {
	{ discard_const_p(char, "type"), py_SC_ACTION_get_type, py_SC_ACTION_set_type },
	{ discard_const_p(char, "delay"), py_SC_ACTION_get_delay, py_SC_ACTION_set_delay },
	{ NULL }
};

static PyObject *py_SC_ACTION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct SC_ACTION, type);
}


static PyTypeObject SC_ACTION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.SC_ACTION",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_SC_ACTION_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SC_ACTION_new,
};


static PyObject *py_SERVICE_FAILURE_ACTIONS_get_reset_period(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(obj);
	PyObject *py_reset_period;
	py_reset_period = PyInt_FromLong(object->reset_period);
	return py_reset_period;
}

static int py_SERVICE_FAILURE_ACTIONS_set_reset_period(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reset_period = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONS_get_rebootmsg(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(obj);
	PyObject *py_rebootmsg;
	py_rebootmsg = PyString_FromString(object->rebootmsg);
	return py_rebootmsg;
}

static int py_SERVICE_FAILURE_ACTIONS_set_rebootmsg(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	object->rebootmsg = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONS_get_command(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyString_FromString(object->command);
	return py_command;
}

static int py_SERVICE_FAILURE_ACTIONS_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	object->command = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONS_get_num_actions(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(obj);
	PyObject *py_num_actions;
	py_num_actions = PyInt_FromLong(object->num_actions);
	return py_num_actions;
}

static int py_SERVICE_FAILURE_ACTIONS_set_num_actions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_actions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_SERVICE_FAILURE_ACTIONS_get_actions(PyObject *obj, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(obj);
	PyObject *py_actions;
	if (object->actions == NULL) {
		py_actions = Py_None;
	} else {
		py_actions = PyList_New(object->num_actions);
		if (py_actions == NULL) {
			return NULL;
		}
		{
			int actions_cntr_1;
			for (actions_cntr_1 = 0; actions_cntr_1 < object->num_actions; actions_cntr_1++) {
				PyObject *py_actions_1;
				py_actions_1 = py_talloc_import_ex(&SC_ACTION_Type, object->actions, &object->actions[actions_cntr_1]);
				PyList_SetItem(py_actions, actions_cntr_1, py_actions_1);
			}
		}
	}
	return py_actions;
}

static int py_SERVICE_FAILURE_ACTIONS_set_actions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	talloc_free(object->actions);
	if (value == Py_None) {
		object->actions = NULL;
	} else {
		object->actions = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->actions);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int actions_cntr_1;
			object->actions = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->actions, PyList_Size(value));
			for (actions_cntr_1 = 0; actions_cntr_1 < PyList_Size(value); actions_cntr_1++) {
				PY_CHECK_TYPE(&SC_ACTION_Type, PyList_GetItem(value, actions_cntr_1), return -1;);
				memcpy(&object->actions[actions_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, actions_cntr_1)), sizeof(object->actions[actions_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_SERVICE_FAILURE_ACTIONS_getsetters[] = {
	{ discard_const_p(char, "reset_period"), py_SERVICE_FAILURE_ACTIONS_get_reset_period, py_SERVICE_FAILURE_ACTIONS_set_reset_period },
	{ discard_const_p(char, "rebootmsg"), py_SERVICE_FAILURE_ACTIONS_get_rebootmsg, py_SERVICE_FAILURE_ACTIONS_set_rebootmsg },
	{ discard_const_p(char, "command"), py_SERVICE_FAILURE_ACTIONS_get_command, py_SERVICE_FAILURE_ACTIONS_set_command },
	{ discard_const_p(char, "num_actions"), py_SERVICE_FAILURE_ACTIONS_get_num_actions, py_SERVICE_FAILURE_ACTIONS_set_num_actions },
	{ discard_const_p(char, "actions"), py_SERVICE_FAILURE_ACTIONS_get_actions, py_SERVICE_FAILURE_ACTIONS_set_actions },
	{ NULL }
};

static PyObject *py_SERVICE_FAILURE_ACTIONS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct SERVICE_FAILURE_ACTIONS, type);
}

static PyObject *py_SERVICE_FAILURE_ACTIONS_ndr_pack(PyObject *py_obj)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_SERVICE_FAILURE_ACTIONS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_SERVICE_FAILURE_ACTIONS_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct SERVICE_FAILURE_ACTIONS *object = (struct SERVICE_FAILURE_ACTIONS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_SERVICE_FAILURE_ACTIONS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_SERVICE_FAILURE_ACTIONS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_SERVICE_FAILURE_ACTIONS_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_SERVICE_FAILURE_ACTIONS_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject SERVICE_FAILURE_ACTIONS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.SERVICE_FAILURE_ACTIONS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_SERVICE_FAILURE_ACTIONS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_SERVICE_FAILURE_ACTIONS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_SERVICE_FAILURE_ACTIONS_new,
};


static bool pack_py_svcctl_CloseServiceHandle_args_in(PyObject *args, PyObject *kwargs, struct svcctl_CloseServiceHandle *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_CloseServiceHandle", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_CloseServiceHandle_args_out(struct svcctl_CloseServiceHandle *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_ControlService_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ControlService *r)
{
	PyObject *py_handle;
	PyObject *py_control;
	const char *kwnames[] = {
		"handle", "control", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_ControlService", discard_const_p(char *, kwnames), &py_handle, &py_control)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_control, return false;);
	r->in.control = PyInt_AsLong(py_control);
	return true;
}

static PyObject *unpack_py_svcctl_ControlService_args_out(struct svcctl_ControlService *r)
{
	PyObject *result = Py_None;
	PyObject *py_service_status;
	py_service_status = py_talloc_import_ex(&SERVICE_STATUS_Type, r->out.service_status, r->out.service_status);
	result = py_service_status;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_DeleteService_args_in(PyObject *args, PyObject *kwargs, struct svcctl_DeleteService *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_DeleteService", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_DeleteService_args_out(struct svcctl_DeleteService *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_LockServiceDatabase_args_in(PyObject *args, PyObject *kwargs, struct svcctl_LockServiceDatabase *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_LockServiceDatabase", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_LockServiceDatabase_args_out(struct svcctl_LockServiceDatabase *r)
{
	PyObject *result = Py_None;
	PyObject *py_lock;
	py_lock = py_talloc_import_ex(policy_handle_Type, r->out.lock, r->out.lock);
	result = py_lock;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceObjectSecurity_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceObjectSecurity *r)
{
	PyObject *py_handle;
	PyObject *py_security_flags;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "security_flags", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_QueryServiceObjectSecurity", discard_const_p(char *, kwnames), &py_handle, &py_security_flags, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_security_flags, return false;);
	r->in.security_flags = PyInt_AsLong(py_security_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceObjectSecurity_args_out(struct svcctl_QueryServiceObjectSecurity *r)
{
	PyObject *result = Py_None;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_buffer = PyList_New(r->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < r->in.offered; buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	PyTuple_SetItem(result, 0, py_buffer);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_SetServiceObjectSecurity_args_in(PyObject *args, PyObject *kwargs, struct svcctl_SetServiceObjectSecurity *r)
{
	PyObject *py_handle;
	PyObject *py_security_flags;
	PyObject *py_buffer;
	const char *kwnames[] = {
		"handle", "security_flags", "buffer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_SetServiceObjectSecurity", discard_const_p(char *, kwnames), &py_handle, &py_security_flags, &py_buffer)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_security_flags, return false;);
	r->in.security_flags = PyInt_AsLong(py_security_flags);
	r->in.buffer = talloc_ptrtype(r, r->in.buffer);
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	{
		int buffer_cntr_1;
		r->in.buffer = talloc_array_ptrtype(r, r->in.buffer, PyList_Size(py_buffer));
		for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_Size(py_buffer); buffer_cntr_1++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_buffer, buffer_cntr_1), return false;);
			r->in.buffer[buffer_cntr_1] = PyInt_AsLong(PyList_GetItem(py_buffer, buffer_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_buffer, return false;);
	r->in.offered = PyList_Size(py_buffer);
	return true;
}

static PyObject *unpack_py_svcctl_SetServiceObjectSecurity_args_out(struct svcctl_SetServiceObjectSecurity *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceStatus_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceStatus *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_QueryServiceStatus", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceStatus_args_out(struct svcctl_QueryServiceStatus *r)
{
	PyObject *result = Py_None;
	PyObject *py_service_status;
	py_service_status = py_talloc_import_ex(&SERVICE_STATUS_Type, r->out.service_status, r->out.service_status);
	result = py_service_status;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_UnlockServiceDatabase_args_in(PyObject *args, PyObject *kwargs, struct svcctl_UnlockServiceDatabase *r)
{
	PyObject *py_lock;
	const char *kwnames[] = {
		"lock", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:svcctl_UnlockServiceDatabase", discard_const_p(char *, kwnames), &py_lock)) {
		return false;
	}

	r->in.lock = talloc_ptrtype(r, r->in.lock);
	PY_CHECK_TYPE(policy_handle_Type, py_lock, return false;);
	r->in.lock = py_talloc_get_ptr(py_lock);
	return true;
}

static PyObject *unpack_py_svcctl_UnlockServiceDatabase_args_out(struct svcctl_UnlockServiceDatabase *r)
{
	PyObject *result = Py_None;
	PyObject *py_lock;
	py_lock = py_talloc_import_ex(policy_handle_Type, r->out.lock, r->out.lock);
	result = py_lock;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_SCSetServiceBitsW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_SCSetServiceBitsW *r)
{
	PyObject *py_handle;
	PyObject *py_bits;
	PyObject *py_bitson;
	PyObject *py_immediate;
	const char *kwnames[] = {
		"handle", "bits", "bitson", "immediate", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:svcctl_SCSetServiceBitsW", discard_const_p(char *, kwnames), &py_handle, &py_bits, &py_bitson, &py_immediate)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_bits, return false;);
	r->in.bits = PyInt_AsLong(py_bits);
	PY_CHECK_TYPE(&PyInt_Type, py_bitson, return false;);
	r->in.bitson = PyInt_AsLong(py_bitson);
	PY_CHECK_TYPE(&PyInt_Type, py_immediate, return false;);
	r->in.immediate = PyInt_AsLong(py_immediate);
	return true;
}

static PyObject *unpack_py_svcctl_SCSetServiceBitsW_args_out(struct svcctl_SCSetServiceBitsW *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_ChangeServiceConfigW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfigW *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_load_order_group;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	PyObject *py_display_name;
	const char *kwnames[] = {
		"handle", "type", "start_type", "error_control", "binary_path", "load_order_group", "dependencies", "service_start_name", "password", "display_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOO:svcctl_ChangeServiceConfigW", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_load_order_group, &py_dependencies, &py_service_start_name, &py_password, &py_display_name)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_start_type, return false;);
	r->in.start_type = PyInt_AsLong(py_start_type);
	PY_CHECK_TYPE(&PyInt_Type, py_error_control, return false;);
	r->in.error_control = PyInt_AsLong(py_error_control);
	if (py_binary_path == Py_None) {
		r->in.binary_path = NULL;
	} else {
		r->in.binary_path = talloc_ptrtype(r, r->in.binary_path);
		PY_CHECK_TYPE(&PyUnicode_Type, py_binary_path, return false;);
		r->in.binary_path = PyString_AsString(PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore"));
	}
	if (py_load_order_group == Py_None) {
		r->in.load_order_group = NULL;
	} else {
		r->in.load_order_group = talloc_ptrtype(r, r->in.load_order_group);
		PY_CHECK_TYPE(&PyUnicode_Type, py_load_order_group, return false;);
		r->in.load_order_group = PyString_AsString(PyUnicode_AsEncodedString(py_load_order_group, "utf-8", "ignore"));
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = talloc_ptrtype(r, r->in.dependencies);
		PY_CHECK_TYPE(&PyUnicode_Type, py_dependencies, return false;);
		r->in.dependencies = PyString_AsString(PyUnicode_AsEncodedString(py_dependencies, "utf-8", "ignore"));
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = talloc_ptrtype(r, r->in.service_start_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_start_name, return false;);
		r->in.service_start_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore"));
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = talloc_ptrtype(r, r->in.password);
		PY_CHECK_TYPE(&PyUnicode_Type, py_password, return false;);
		r->in.password = PyString_AsString(PyUnicode_AsEncodedString(py_password, "utf-8", "ignore"));
	}
	if (py_display_name == Py_None) {
		r->in.display_name = NULL;
	} else {
		r->in.display_name = talloc_ptrtype(r, r->in.display_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_display_name, return false;);
		r->in.display_name = PyString_AsString(PyUnicode_AsEncodedString(py_display_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfigW_args_out(struct svcctl_ChangeServiceConfigW *r)
{
	PyObject *result = Py_None;
	PyObject *py_tag_id;
	py_tag_id = PyInt_FromLong(*r->out.tag_id);
	result = py_tag_id;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_CreateServiceW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_CreateServiceW *r)
{
	PyObject *py_scmanager_handle;
	PyObject *py_ServiceName;
	PyObject *py_DisplayName;
	PyObject *py_desired_access;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_LoadOrderGroupKey;
	PyObject *py_TagId;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	const char *kwnames[] = {
		"scmanager_handle", "ServiceName", "DisplayName", "desired_access", "type", "start_type", "error_control", "binary_path", "LoadOrderGroupKey", "TagId", "dependencies", "service_start_name", "password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOOO:svcctl_CreateServiceW", discard_const_p(char *, kwnames), &py_scmanager_handle, &py_ServiceName, &py_DisplayName, &py_desired_access, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_LoadOrderGroupKey, &py_TagId, &py_dependencies, &py_service_start_name, &py_password)) {
		return false;
	}

	r->in.scmanager_handle = talloc_ptrtype(r, r->in.scmanager_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager_handle, return false;);
	r->in.scmanager_handle = py_talloc_get_ptr(py_scmanager_handle);
	PY_CHECK_TYPE(&PyUnicode_Type, py_ServiceName, return false;);
	r->in.ServiceName = PyString_AsString(PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore"));
	if (py_DisplayName == Py_None) {
		r->in.DisplayName = NULL;
	} else {
		r->in.DisplayName = talloc_ptrtype(r, r->in.DisplayName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_DisplayName, return false;);
		r->in.DisplayName = PyString_AsString(PyUnicode_AsEncodedString(py_DisplayName, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_desired_access, return false;);
	r->in.desired_access = PyInt_AsLong(py_desired_access);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_start_type, return false;);
	r->in.start_type = PyInt_AsLong(py_start_type);
	PY_CHECK_TYPE(&PyInt_Type, py_error_control, return false;);
	r->in.error_control = PyInt_AsLong(py_error_control);
	PY_CHECK_TYPE(&PyUnicode_Type, py_binary_path, return false;);
	r->in.binary_path = PyString_AsString(PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore"));
	if (py_LoadOrderGroupKey == Py_None) {
		r->in.LoadOrderGroupKey = NULL;
	} else {
		r->in.LoadOrderGroupKey = talloc_ptrtype(r, r->in.LoadOrderGroupKey);
		PY_CHECK_TYPE(&PyUnicode_Type, py_LoadOrderGroupKey, return false;);
		r->in.LoadOrderGroupKey = PyString_AsString(PyUnicode_AsEncodedString(py_LoadOrderGroupKey, "utf-8", "ignore"));
	}
	if (py_TagId == Py_None) {
		r->in.TagId = NULL;
	} else {
		r->in.TagId = talloc_ptrtype(r, r->in.TagId);
		PY_CHECK_TYPE(&PyInt_Type, py_TagId, return false;);
		*r->in.TagId = PyInt_AsLong(py_TagId);
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = talloc_ptrtype(r, r->in.dependencies);
		PY_CHECK_TYPE(&PyList_Type, py_dependencies, return false;);
		{
			int dependencies_cntr_1;
			r->in.dependencies = talloc_array_ptrtype(r, r->in.dependencies, PyList_Size(py_dependencies));
			for (dependencies_cntr_1 = 0; dependencies_cntr_1 < PyList_Size(py_dependencies); dependencies_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_dependencies, dependencies_cntr_1), return false;);
				r->in.dependencies[dependencies_cntr_1] = PyInt_AsLong(PyList_GetItem(py_dependencies, dependencies_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_dependencies, return false;);
	r->in.dependencies_size = PyList_Size(py_dependencies);
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = talloc_ptrtype(r, r->in.service_start_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_start_name, return false;);
		r->in.service_start_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore"));
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = talloc_ptrtype(r, r->in.password);
		PY_CHECK_TYPE(&PyList_Type, py_password, return false;);
		{
			int password_cntr_1;
			r->in.password = talloc_array_ptrtype(r, r->in.password, PyList_Size(py_password));
			for (password_cntr_1 = 0; password_cntr_1 < PyList_Size(py_password); password_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(py_password, password_cntr_1), return false;);
				r->in.password[password_cntr_1] = PyInt_AsLong(PyList_GetItem(py_password, password_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_password, return false;);
	r->in.password_size = PyList_Size(py_password);
	return true;
}

static PyObject *unpack_py_svcctl_CreateServiceW_args_out(struct svcctl_CreateServiceW *r)
{
	PyObject *result = Py_None;
	PyObject *py_TagId;
	PyObject *py_handle;
	result = PyTuple_New(2);
	if (r->out.TagId == NULL) {
		py_TagId = Py_None;
	} else {
		py_TagId = PyInt_FromLong(*r->out.TagId);
	}
	PyTuple_SetItem(result, 0, py_TagId);
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	PyTuple_SetItem(result, 1, py_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_EnumDependentServicesW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumDependentServicesW *r)
{
	PyObject *py_service;
	PyObject *py_state;
	PyObject *py_offered;
	const char *kwnames[] = {
		"service", "state", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_EnumDependentServicesW", discard_const_p(char *, kwnames), &py_service, &py_state, &py_offered)) {
		return false;
	}

	r->in.service = talloc_ptrtype(r, r->in.service);
	PY_CHECK_TYPE(policy_handle_Type, py_service, return false;);
	r->in.service = py_talloc_get_ptr(py_service);
	PY_CHECK_TYPE(&PyInt_Type, py_state, return false;);
	r->in.state = PyInt_AsLong(py_state);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_EnumDependentServicesW_args_out(struct svcctl_EnumDependentServicesW *r)
{
	PyObject *result = Py_None;
	PyObject *py_service_status;
	PyObject *py_needed;
	PyObject *py_services_returned;
	result = PyTuple_New(3);
	py_service_status = PyList_New(r->in.offered);
	if (py_service_status == NULL) {
		return NULL;
	}
	{
		int service_status_cntr_1;
		for (service_status_cntr_1 = 0; service_status_cntr_1 < r->in.offered; service_status_cntr_1++) {
			PyObject *py_service_status_1;
			py_service_status_1 = PyInt_FromLong(r->out.service_status[service_status_cntr_1]);
			PyList_SetItem(py_service_status, service_status_cntr_1, py_service_status_1);
		}
	}
	PyTuple_SetItem(result, 0, py_service_status);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyInt_FromLong(*r->out.services_returned);
	PyTuple_SetItem(result, 2, py_services_returned);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_EnumServicesStatusW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumServicesStatusW *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_state;
	PyObject *py_offered;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"handle", "type", "state", "offered", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:svcctl_EnumServicesStatusW", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_state, &py_offered, &py_resume_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_state, return false;);
	r->in.state = PyInt_AsLong(py_state);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
		*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	}
	return true;
}

static PyObject *unpack_py_svcctl_EnumServicesStatusW_args_out(struct svcctl_EnumServicesStatusW *r)
{
	PyObject *result = Py_None;
	PyObject *py_service;
	PyObject *py_needed;
	PyObject *py_services_returned;
	PyObject *py_resume_handle;
	result = PyTuple_New(4);
	py_service = PyList_New(r->in.offered);
	if (py_service == NULL) {
		return NULL;
	}
	{
		int service_cntr_1;
		for (service_cntr_1 = 0; service_cntr_1 < r->in.offered; service_cntr_1++) {
			PyObject *py_service_1;
			py_service_1 = PyInt_FromLong(r->out.service[service_cntr_1]);
			PyList_SetItem(py_service, service_cntr_1, py_service_1);
		}
	}
	PyTuple_SetItem(result, 0, py_service);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyInt_FromLong(*r->out.services_returned);
	PyTuple_SetItem(result, 2, py_services_returned);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
	} else {
		py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	}
	PyTuple_SetItem(result, 3, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_OpenSCManagerW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenSCManagerW *r)
{
	PyObject *py_MachineName;
	PyObject *py_DatabaseName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"MachineName", "DatabaseName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenSCManagerW", discard_const_p(char *, kwnames), &py_MachineName, &py_DatabaseName, &py_access_mask)) {
		return false;
	}

	if (py_MachineName == Py_None) {
		r->in.MachineName = NULL;
	} else {
		r->in.MachineName = talloc_ptrtype(r, r->in.MachineName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_MachineName, return false;);
		r->in.MachineName = PyString_AsString(PyUnicode_AsEncodedString(py_MachineName, "utf-8", "ignore"));
	}
	if (py_DatabaseName == Py_None) {
		r->in.DatabaseName = NULL;
	} else {
		r->in.DatabaseName = talloc_ptrtype(r, r->in.DatabaseName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_DatabaseName, return false;);
		r->in.DatabaseName = PyString_AsString(PyUnicode_AsEncodedString(py_DatabaseName, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_svcctl_OpenSCManagerW_args_out(struct svcctl_OpenSCManagerW *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_OpenServiceW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenServiceW *r)
{
	PyObject *py_scmanager_handle;
	PyObject *py_ServiceName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"scmanager_handle", "ServiceName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenServiceW", discard_const_p(char *, kwnames), &py_scmanager_handle, &py_ServiceName, &py_access_mask)) {
		return false;
	}

	r->in.scmanager_handle = talloc_ptrtype(r, r->in.scmanager_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager_handle, return false;);
	r->in.scmanager_handle = py_talloc_get_ptr(py_scmanager_handle);
	PY_CHECK_TYPE(&PyUnicode_Type, py_ServiceName, return false;);
	r->in.ServiceName = PyString_AsString(PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_svcctl_OpenServiceW_args_out(struct svcctl_OpenServiceW *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceConfigW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceConfigW *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceConfigW", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceConfigW_args_out(struct svcctl_QueryServiceConfigW *r)
{
	PyObject *result = Py_None;
	PyObject *py_query;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_query = py_talloc_import_ex(&QUERY_SERVICE_CONFIG_Type, r->out.query, r->out.query);
	PyTuple_SetItem(result, 0, py_query);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceLockStatusW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceLockStatusW *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceLockStatusW", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceLockStatusW_args_out(struct svcctl_QueryServiceLockStatusW *r)
{
	PyObject *result = Py_None;
	PyObject *py_lock_status;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_lock_status = py_talloc_import_ex(&SERVICE_LOCK_STATUS_Type, r->out.lock_status, r->out.lock_status);
	PyTuple_SetItem(result, 0, py_lock_status);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_StartServiceW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_StartServiceW *r)
{
	PyObject *py_handle;
	PyObject *py_Arguments;
	const char *kwnames[] = {
		"handle", "Arguments", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_StartServiceW", discard_const_p(char *, kwnames), &py_handle, &py_Arguments)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyList_Type, py_Arguments, return false;);
	r->in.NumArgs = PyList_Size(py_Arguments);
	if (py_Arguments == Py_None) {
		r->in.Arguments = NULL;
	} else {
		r->in.Arguments = talloc_ptrtype(r, r->in.Arguments);
		PY_CHECK_TYPE(&PyList_Type, py_Arguments, return false;);
		{
			int Arguments_cntr_1;
			r->in.Arguments = talloc_array_ptrtype(r, r->in.Arguments, PyList_Size(py_Arguments));
			for (Arguments_cntr_1 = 0; Arguments_cntr_1 < PyList_Size(py_Arguments); Arguments_cntr_1++) {
				PY_CHECK_TYPE(&svcctl_ArgumentString_Type, PyList_GetItem(py_Arguments, Arguments_cntr_1), return false;);
				memcpy(&r->in.Arguments[Arguments_cntr_1], py_talloc_get_ptr(PyList_GetItem(py_Arguments, Arguments_cntr_1)), sizeof(r->in.Arguments[Arguments_cntr_1]));
			}
		}
	}
	return true;
}

static PyObject *unpack_py_svcctl_StartServiceW_args_out(struct svcctl_StartServiceW *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_GetServiceDisplayNameW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceDisplayNameW *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceDisplayNameW", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = talloc_ptrtype(r, r->in.service_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_name, return false;);
		r->in.service_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore"));
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		PY_CHECK_TYPE(&PyInt_Type, py_display_name_length, return false;);
		*r->in.display_name_length = PyInt_AsLong(py_display_name_length);
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceDisplayNameW_args_out(struct svcctl_GetServiceDisplayNameW *r)
{
	PyObject *result = Py_None;
	PyObject *py_display_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.display_name == NULL) {
		py_display_name = Py_None;
	} else {
		py_display_name = PyUnicode_Decode(*r->out.display_name, strlen(*r->out.display_name), "utf-8", "ignore");
	}
	PyTuple_SetItem(result, 0, py_display_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
	} else {
		py_display_name_length = PyInt_FromLong(*r->out.display_name_length);
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_GetServiceKeyNameW_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceKeyNameW *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceKeyNameW", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = talloc_ptrtype(r, r->in.service_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_name, return false;);
		r->in.service_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore"));
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		PY_CHECK_TYPE(&PyInt_Type, py_display_name_length, return false;);
		*r->in.display_name_length = PyInt_AsLong(py_display_name_length);
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceKeyNameW_args_out(struct svcctl_GetServiceKeyNameW *r)
{
	PyObject *result = Py_None;
	PyObject *py_key_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.key_name == NULL) {
		py_key_name = Py_None;
	} else {
		py_key_name = PyUnicode_Decode(*r->out.key_name, strlen(*r->out.key_name), "utf-8", "ignore");
	}
	PyTuple_SetItem(result, 0, py_key_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
	} else {
		py_display_name_length = PyInt_FromLong(*r->out.display_name_length);
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_SCSetServiceBitsA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_SCSetServiceBitsA *r)
{
	PyObject *py_handle;
	PyObject *py_bits;
	PyObject *py_bitson;
	PyObject *py_immediate;
	const char *kwnames[] = {
		"handle", "bits", "bitson", "immediate", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:svcctl_SCSetServiceBitsA", discard_const_p(char *, kwnames), &py_handle, &py_bits, &py_bitson, &py_immediate)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_bits, return false;);
	r->in.bits = PyInt_AsLong(py_bits);
	PY_CHECK_TYPE(&PyInt_Type, py_bitson, return false;);
	r->in.bitson = PyInt_AsLong(py_bitson);
	PY_CHECK_TYPE(&PyInt_Type, py_immediate, return false;);
	r->in.immediate = PyInt_AsLong(py_immediate);
	return true;
}

static PyObject *unpack_py_svcctl_SCSetServiceBitsA_args_out(struct svcctl_SCSetServiceBitsA *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_ChangeServiceConfigA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfigA *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_load_order_group;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	PyObject *py_display_name;
	const char *kwnames[] = {
		"handle", "type", "start_type", "error_control", "binary_path", "load_order_group", "dependencies", "service_start_name", "password", "display_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOO:svcctl_ChangeServiceConfigA", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_load_order_group, &py_dependencies, &py_service_start_name, &py_password, &py_display_name)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_start_type, return false;);
	r->in.start_type = PyInt_AsLong(py_start_type);
	PY_CHECK_TYPE(&PyInt_Type, py_error_control, return false;);
	r->in.error_control = PyInt_AsLong(py_error_control);
	if (py_binary_path == Py_None) {
		r->in.binary_path = NULL;
	} else {
		r->in.binary_path = talloc_ptrtype(r, r->in.binary_path);
		PY_CHECK_TYPE(&PyUnicode_Type, py_binary_path, return false;);
		r->in.binary_path = PyString_AsString(PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore"));
	}
	if (py_load_order_group == Py_None) {
		r->in.load_order_group = NULL;
	} else {
		r->in.load_order_group = talloc_ptrtype(r, r->in.load_order_group);
		PY_CHECK_TYPE(&PyUnicode_Type, py_load_order_group, return false;);
		r->in.load_order_group = PyString_AsString(PyUnicode_AsEncodedString(py_load_order_group, "utf-8", "ignore"));
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = talloc_ptrtype(r, r->in.dependencies);
		PY_CHECK_TYPE(&PyUnicode_Type, py_dependencies, return false;);
		r->in.dependencies = PyString_AsString(PyUnicode_AsEncodedString(py_dependencies, "utf-8", "ignore"));
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = talloc_ptrtype(r, r->in.service_start_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_start_name, return false;);
		r->in.service_start_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore"));
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = talloc_ptrtype(r, r->in.password);
		PY_CHECK_TYPE(&PyUnicode_Type, py_password, return false;);
		r->in.password = PyString_AsString(PyUnicode_AsEncodedString(py_password, "utf-8", "ignore"));
	}
	if (py_display_name == Py_None) {
		r->in.display_name = NULL;
	} else {
		r->in.display_name = talloc_ptrtype(r, r->in.display_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_display_name, return false;);
		r->in.display_name = PyString_AsString(PyUnicode_AsEncodedString(py_display_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfigA_args_out(struct svcctl_ChangeServiceConfigA *r)
{
	PyObject *result = Py_None;
	PyObject *py_tag_id;
	py_tag_id = PyInt_FromLong(*r->out.tag_id);
	result = py_tag_id;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_CreateServiceA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_CreateServiceA *r)
{
	PyObject *py_handle;
	PyObject *py_ServiceName;
	PyObject *py_DisplayName;
	PyObject *py_desired_access;
	PyObject *py_type;
	PyObject *py_start_type;
	PyObject *py_error_control;
	PyObject *py_binary_path;
	PyObject *py_LoadOrderGroupKey;
	PyObject *py_dependencies;
	PyObject *py_service_start_name;
	PyObject *py_password;
	const char *kwnames[] = {
		"handle", "ServiceName", "DisplayName", "desired_access", "type", "start_type", "error_control", "binary_path", "LoadOrderGroupKey", "dependencies", "service_start_name", "password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOO:svcctl_CreateServiceA", discard_const_p(char *, kwnames), &py_handle, &py_ServiceName, &py_DisplayName, &py_desired_access, &py_type, &py_start_type, &py_error_control, &py_binary_path, &py_LoadOrderGroupKey, &py_dependencies, &py_service_start_name, &py_password)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	if (py_ServiceName == Py_None) {
		r->in.ServiceName = NULL;
	} else {
		r->in.ServiceName = talloc_ptrtype(r, r->in.ServiceName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_ServiceName, return false;);
		r->in.ServiceName = PyString_AsString(PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore"));
	}
	if (py_DisplayName == Py_None) {
		r->in.DisplayName = NULL;
	} else {
		r->in.DisplayName = talloc_ptrtype(r, r->in.DisplayName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_DisplayName, return false;);
		r->in.DisplayName = PyString_AsString(PyUnicode_AsEncodedString(py_DisplayName, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_desired_access, return false;);
	r->in.desired_access = PyInt_AsLong(py_desired_access);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_start_type, return false;);
	r->in.start_type = PyInt_AsLong(py_start_type);
	PY_CHECK_TYPE(&PyInt_Type, py_error_control, return false;);
	r->in.error_control = PyInt_AsLong(py_error_control);
	if (py_binary_path == Py_None) {
		r->in.binary_path = NULL;
	} else {
		r->in.binary_path = talloc_ptrtype(r, r->in.binary_path);
		PY_CHECK_TYPE(&PyUnicode_Type, py_binary_path, return false;);
		r->in.binary_path = PyString_AsString(PyUnicode_AsEncodedString(py_binary_path, "utf-8", "ignore"));
	}
	if (py_LoadOrderGroupKey == Py_None) {
		r->in.LoadOrderGroupKey = NULL;
	} else {
		r->in.LoadOrderGroupKey = talloc_ptrtype(r, r->in.LoadOrderGroupKey);
		PY_CHECK_TYPE(&PyUnicode_Type, py_LoadOrderGroupKey, return false;);
		r->in.LoadOrderGroupKey = PyString_AsString(PyUnicode_AsEncodedString(py_LoadOrderGroupKey, "utf-8", "ignore"));
	}
	if (py_dependencies == Py_None) {
		r->in.dependencies = NULL;
	} else {
		r->in.dependencies = talloc_ptrtype(r, r->in.dependencies);
		PY_CHECK_TYPE(&PyUnicode_Type, py_dependencies, return false;);
		r->in.dependencies = PyString_AsString(PyUnicode_AsEncodedString(py_dependencies, "utf-8", "ignore"));
	}
	if (py_service_start_name == Py_None) {
		r->in.service_start_name = NULL;
	} else {
		r->in.service_start_name = talloc_ptrtype(r, r->in.service_start_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_start_name, return false;);
		r->in.service_start_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_start_name, "utf-8", "ignore"));
	}
	if (py_password == Py_None) {
		r->in.password = NULL;
	} else {
		r->in.password = talloc_ptrtype(r, r->in.password);
		PY_CHECK_TYPE(&PyUnicode_Type, py_password, return false;);
		r->in.password = PyString_AsString(PyUnicode_AsEncodedString(py_password, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_svcctl_CreateServiceA_args_out(struct svcctl_CreateServiceA *r)
{
	PyObject *result = Py_None;
	PyObject *py_TagId;
	if (r->out.TagId == NULL) {
		py_TagId = Py_None;
	} else {
		py_TagId = PyInt_FromLong(*r->out.TagId);
	}
	result = py_TagId;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_EnumDependentServicesA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumDependentServicesA *r)
{
	PyObject *py_service;
	PyObject *py_state;
	PyObject *py_offered;
	const char *kwnames[] = {
		"service", "state", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_EnumDependentServicesA", discard_const_p(char *, kwnames), &py_service, &py_state, &py_offered)) {
		return false;
	}

	r->in.service = talloc_ptrtype(r, r->in.service);
	PY_CHECK_TYPE(policy_handle_Type, py_service, return false;);
	r->in.service = py_talloc_get_ptr(py_service);
	PY_CHECK_TYPE(&PyInt_Type, py_state, return false;);
	r->in.state = PyInt_AsLong(py_state);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_EnumDependentServicesA_args_out(struct svcctl_EnumDependentServicesA *r)
{
	PyObject *result = Py_None;
	PyObject *py_service_status;
	PyObject *py_needed;
	PyObject *py_services_returned;
	result = PyTuple_New(3);
	if (r->out.service_status == NULL) {
		py_service_status = Py_None;
	} else {
		py_service_status = py_talloc_import_ex(&ENUM_SERVICE_STATUSA_Type, r->out.service_status, r->out.service_status);
	}
	PyTuple_SetItem(result, 0, py_service_status);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyInt_FromLong(*r->out.services_returned);
	PyTuple_SetItem(result, 2, py_services_returned);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_EnumServicesStatusA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_EnumServicesStatusA *r)
{
	PyObject *py_handle;
	PyObject *py_type;
	PyObject *py_state;
	PyObject *py_offered;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"handle", "type", "state", "offered", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:svcctl_EnumServicesStatusA", discard_const_p(char *, kwnames), &py_handle, &py_type, &py_state, &py_offered, &py_resume_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_state, return false;);
	r->in.state = PyInt_AsLong(py_state);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
		*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	}
	return true;
}

static PyObject *unpack_py_svcctl_EnumServicesStatusA_args_out(struct svcctl_EnumServicesStatusA *r)
{
	PyObject *result = Py_None;
	PyObject *py_service;
	PyObject *py_needed;
	PyObject *py_services_returned;
	PyObject *py_resume_handle;
	result = PyTuple_New(4);
	py_service = PyList_New(r->in.offered);
	if (py_service == NULL) {
		return NULL;
	}
	{
		int service_cntr_0;
		for (service_cntr_0 = 0; service_cntr_0 < r->in.offered; service_cntr_0++) {
			PyObject *py_service_0;
			py_service_0 = PyInt_FromLong(r->out.service[service_cntr_0]);
			PyList_SetItem(py_service, service_cntr_0, py_service_0);
		}
	}
	PyTuple_SetItem(result, 0, py_service);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	py_services_returned = PyInt_FromLong(*r->out.services_returned);
	PyTuple_SetItem(result, 2, py_services_returned);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
	} else {
		py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	}
	PyTuple_SetItem(result, 3, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_OpenSCManagerA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenSCManagerA *r)
{
	PyObject *py_MachineName;
	PyObject *py_DatabaseName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"MachineName", "DatabaseName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenSCManagerA", discard_const_p(char *, kwnames), &py_MachineName, &py_DatabaseName, &py_access_mask)) {
		return false;
	}

	if (py_MachineName == Py_None) {
		r->in.MachineName = NULL;
	} else {
		r->in.MachineName = talloc_ptrtype(r, r->in.MachineName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_MachineName, return false;);
		r->in.MachineName = PyString_AsString(PyUnicode_AsEncodedString(py_MachineName, "utf-8", "ignore"));
	}
	if (py_DatabaseName == Py_None) {
		r->in.DatabaseName = NULL;
	} else {
		r->in.DatabaseName = talloc_ptrtype(r, r->in.DatabaseName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_DatabaseName, return false;);
		r->in.DatabaseName = PyString_AsString(PyUnicode_AsEncodedString(py_DatabaseName, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_svcctl_OpenSCManagerA_args_out(struct svcctl_OpenSCManagerA *r)
{
	PyObject *result = Py_None;
	PyObject *py_handle;
	py_handle = py_talloc_import_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_OpenServiceA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_OpenServiceA *r)
{
	PyObject *py_scmanager_handle;
	PyObject *py_ServiceName;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"scmanager_handle", "ServiceName", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_OpenServiceA", discard_const_p(char *, kwnames), &py_scmanager_handle, &py_ServiceName, &py_access_mask)) {
		return false;
	}

	r->in.scmanager_handle = talloc_ptrtype(r, r->in.scmanager_handle);
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager_handle, return false;);
	r->in.scmanager_handle = py_talloc_get_ptr(py_scmanager_handle);
	if (py_ServiceName == Py_None) {
		r->in.ServiceName = NULL;
	} else {
		r->in.ServiceName = talloc_ptrtype(r, r->in.ServiceName);
		PY_CHECK_TYPE(&PyUnicode_Type, py_ServiceName, return false;);
		r->in.ServiceName = PyString_AsString(PyUnicode_AsEncodedString(py_ServiceName, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_access_mask, return false;);
	r->in.access_mask = PyInt_AsLong(py_access_mask);
	return true;
}

static PyObject *unpack_py_svcctl_OpenServiceA_args_out(struct svcctl_OpenServiceA *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceConfigA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceConfigA *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceConfigA", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceConfigA_args_out(struct svcctl_QueryServiceConfigA *r)
{
	PyObject *result = Py_None;
	PyObject *py_query;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_query = PyList_New(r->in.offered);
	if (py_query == NULL) {
		return NULL;
	}
	{
		int query_cntr_0;
		for (query_cntr_0 = 0; query_cntr_0 < r->in.offered; query_cntr_0++) {
			PyObject *py_query_0;
			py_query_0 = PyInt_FromLong(r->out.query[query_cntr_0]);
			PyList_SetItem(py_query, query_cntr_0, py_query_0);
		}
	}
	PyTuple_SetItem(result, 0, py_query);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceLockStatusA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceLockStatusA *r)
{
	PyObject *py_handle;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:svcctl_QueryServiceLockStatusA", discard_const_p(char *, kwnames), &py_handle, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceLockStatusA_args_out(struct svcctl_QueryServiceLockStatusA *r)
{
	PyObject *result = Py_None;
	PyObject *py_lock_status;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_lock_status = py_talloc_import_ex(&SERVICE_LOCK_STATUS_Type, r->out.lock_status, r->out.lock_status);
	PyTuple_SetItem(result, 0, py_lock_status);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_StartServiceA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_StartServiceA *r)
{
	PyObject *py_handle;
	PyObject *py_NumArgs;
	PyObject *py_Arguments;
	const char *kwnames[] = {
		"handle", "NumArgs", "Arguments", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_StartServiceA", discard_const_p(char *, kwnames), &py_handle, &py_NumArgs, &py_Arguments)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_NumArgs, return false;);
	r->in.NumArgs = PyInt_AsLong(py_NumArgs);
	if (py_Arguments == Py_None) {
		r->in.Arguments = NULL;
	} else {
		r->in.Arguments = talloc_ptrtype(r, r->in.Arguments);
		PY_CHECK_TYPE(&PyUnicode_Type, py_Arguments, return false;);
		r->in.Arguments = PyString_AsString(PyUnicode_AsEncodedString(py_Arguments, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_svcctl_StartServiceA_args_out(struct svcctl_StartServiceA *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_GetServiceDisplayNameA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceDisplayNameA *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceDisplayNameA", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = talloc_ptrtype(r, r->in.service_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_name, return false;);
		r->in.service_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore"));
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		PY_CHECK_TYPE(&PyInt_Type, py_display_name_length, return false;);
		*r->in.display_name_length = PyInt_AsLong(py_display_name_length);
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceDisplayNameA_args_out(struct svcctl_GetServiceDisplayNameA *r)
{
	PyObject *result = Py_None;
	PyObject *py_display_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.display_name == NULL) {
		py_display_name = Py_None;
	} else {
		py_display_name = PyUnicode_Decode(*r->out.display_name, strlen(*r->out.display_name), "utf-8", "ignore");
	}
	PyTuple_SetItem(result, 0, py_display_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
	} else {
		py_display_name_length = PyInt_FromLong(*r->out.display_name_length);
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_GetServiceKeyNameA_args_in(PyObject *args, PyObject *kwargs, struct svcctl_GetServiceKeyNameA *r)
{
	PyObject *py_handle;
	PyObject *py_service_name;
	PyObject *py_display_name_length;
	const char *kwnames[] = {
		"handle", "service_name", "display_name_length", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_GetServiceKeyNameA", discard_const_p(char *, kwnames), &py_handle, &py_service_name, &py_display_name_length)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	if (py_service_name == Py_None) {
		r->in.service_name = NULL;
	} else {
		r->in.service_name = talloc_ptrtype(r, r->in.service_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_service_name, return false;);
		r->in.service_name = PyString_AsString(PyUnicode_AsEncodedString(py_service_name, "utf-8", "ignore"));
	}
	if (py_display_name_length == Py_None) {
		r->in.display_name_length = NULL;
	} else {
		r->in.display_name_length = talloc_ptrtype(r, r->in.display_name_length);
		PY_CHECK_TYPE(&PyInt_Type, py_display_name_length, return false;);
		*r->in.display_name_length = PyInt_AsLong(py_display_name_length);
	}
	return true;
}

static PyObject *unpack_py_svcctl_GetServiceKeyNameA_args_out(struct svcctl_GetServiceKeyNameA *r)
{
	PyObject *result = Py_None;
	PyObject *py_key_name;
	PyObject *py_display_name_length;
	result = PyTuple_New(2);
	if (*r->out.key_name == NULL) {
		py_key_name = Py_None;
	} else {
		py_key_name = PyUnicode_Decode(*r->out.key_name, strlen(*r->out.key_name), "utf-8", "ignore");
	}
	PyTuple_SetItem(result, 0, py_key_name);
	if (r->out.display_name_length == NULL) {
		py_display_name_length = Py_None;
	} else {
		py_display_name_length = PyInt_FromLong(*r->out.display_name_length);
	}
	PyTuple_SetItem(result, 1, py_display_name_length);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_ChangeServiceConfig2A_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfig2A *r)
{
	PyObject *py_handle;
	PyObject *py_info_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "info_level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_ChangeServiceConfig2A", discard_const_p(char *, kwnames), &py_handle, &py_info_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	if (py_info == Py_None) {
		r->in.info = NULL;
	} else {
		r->in.info = talloc_ptrtype(r, r->in.info);
		PY_CHECK_TYPE(&PyInt_Type, py_info, return false;);
		*r->in.info = PyInt_AsLong(py_info);
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfig2A_args_out(struct svcctl_ChangeServiceConfig2A *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_ChangeServiceConfig2W_args_in(PyObject *args, PyObject *kwargs, struct svcctl_ChangeServiceConfig2W *r)
{
	PyObject *py_handle;
	PyObject *py_info_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"handle", "info_level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_ChangeServiceConfig2W", discard_const_p(char *, kwnames), &py_handle, &py_info_level, &py_info)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	if (py_info == Py_None) {
		r->in.info = NULL;
	} else {
		r->in.info = talloc_ptrtype(r, r->in.info);
		PY_CHECK_TYPE(&PyInt_Type, py_info, return false;);
		*r->in.info = PyInt_AsLong(py_info);
	}
	return true;
}

static PyObject *unpack_py_svcctl_ChangeServiceConfig2W_args_out(struct svcctl_ChangeServiceConfig2W *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceConfig2A_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceConfig2A *r)
{
	PyObject *py_handle;
	PyObject *py_info_level;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "info_level", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_QueryServiceConfig2A", discard_const_p(char *, kwnames), &py_handle, &py_info_level, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceConfig2A_args_out(struct svcctl_QueryServiceConfig2A *r)
{
	PyObject *result = Py_None;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_buffer = PyList_New(r->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_0;
		for (buffer_cntr_0 = 0; buffer_cntr_0 < r->in.offered; buffer_cntr_0++) {
			PyObject *py_buffer_0;
			py_buffer_0 = PyInt_FromLong(r->out.buffer[buffer_cntr_0]);
			PyList_SetItem(py_buffer, buffer_cntr_0, py_buffer_0);
		}
	}
	PyTuple_SetItem(result, 0, py_buffer);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceConfig2W_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceConfig2W *r)
{
	PyObject *py_handle;
	PyObject *py_info_level;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "info_level", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_QueryServiceConfig2W", discard_const_p(char *, kwnames), &py_handle, &py_info_level, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceConfig2W_args_out(struct svcctl_QueryServiceConfig2W *r)
{
	PyObject *result = Py_None;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_buffer = PyList_New(r->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < r->in.offered; buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	PyTuple_SetItem(result, 0, py_buffer);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_svcctl_QueryServiceStatusEx_args_in(PyObject *args, PyObject *kwargs, struct svcctl_QueryServiceStatusEx *r)
{
	PyObject *py_handle;
	PyObject *py_info_level;
	PyObject *py_offered;
	const char *kwnames[] = {
		"handle", "info_level", "offered", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:svcctl_QueryServiceStatusEx", discard_const_p(char *, kwnames), &py_handle, &py_info_level, &py_offered)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	r->in.handle = py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	return true;
}

static PyObject *unpack_py_svcctl_QueryServiceStatusEx_args_out(struct svcctl_QueryServiceStatusEx *r)
{
	PyObject *result = Py_None;
	PyObject *py_buffer;
	PyObject *py_needed;
	result = PyTuple_New(2);
	py_buffer = PyList_New(r->in.offered);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_1;
		for (buffer_cntr_1 = 0; buffer_cntr_1 < r->in.offered; buffer_cntr_1++) {
			PyObject *py_buffer_1;
			py_buffer_1 = PyInt_FromLong(r->out.buffer[buffer_cntr_1]);
			PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
		}
	}
	PyTuple_SetItem(result, 0, py_buffer);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_EnumServicesStatusExA_args_in(PyObject *args, PyObject *kwargs, struct EnumServicesStatusExA *r)
{
	PyObject *py_scmanager;
	PyObject *py_info_level;
	PyObject *py_type;
	PyObject *py_state;
	PyObject *py_offered;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"scmanager", "info_level", "type", "state", "offered", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:EnumServicesStatusExA", discard_const_p(char *, kwnames), &py_scmanager, &py_info_level, &py_type, &py_state, &py_offered, &py_resume_handle)) {
		return false;
	}

	r->in.scmanager = talloc_ptrtype(r, r->in.scmanager);
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager, return false;);
	r->in.scmanager = py_talloc_get_ptr(py_scmanager);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_state, return false;);
	r->in.state = PyInt_AsLong(py_state);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
		*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	}
	return true;
}

static PyObject *unpack_py_EnumServicesStatusExA_args_out(struct EnumServicesStatusExA *r)
{
	PyObject *result = Py_None;
	PyObject *py_services;
	PyObject *py_needed;
	PyObject *py_service_returned;
	PyObject *py_resume_handle;
	PyObject *py_group_name;
	result = PyTuple_New(5);
	py_services = PyList_New(r->in.offered);
	if (py_services == NULL) {
		return NULL;
	}
	{
		int services_cntr_0;
		for (services_cntr_0 = 0; services_cntr_0 < r->in.offered; services_cntr_0++) {
			PyObject *py_services_0;
			py_services_0 = PyInt_FromLong(r->out.services[services_cntr_0]);
			PyList_SetItem(py_services, services_cntr_0, py_services_0);
		}
	}
	PyTuple_SetItem(result, 0, py_services);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	py_service_returned = PyInt_FromLong(*r->out.service_returned);
	PyTuple_SetItem(result, 2, py_service_returned);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
	} else {
		py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	}
	PyTuple_SetItem(result, 3, py_resume_handle);
	if (*r->out.group_name == NULL) {
		py_group_name = Py_None;
	} else {
		py_group_name = PyUnicode_Decode(*r->out.group_name, strlen(*r->out.group_name), "utf-8", "ignore");
	}
	PyTuple_SetItem(result, 4, py_group_name);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_EnumServicesStatusExW_args_in(PyObject *args, PyObject *kwargs, struct EnumServicesStatusExW *r)
{
	PyObject *py_scmanager;
	PyObject *py_info_level;
	PyObject *py_type;
	PyObject *py_state;
	PyObject *py_offered;
	PyObject *py_resume_handle;
	PyObject *py_group_name;
	const char *kwnames[] = {
		"scmanager", "info_level", "type", "state", "offered", "resume_handle", "group_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:EnumServicesStatusExW", discard_const_p(char *, kwnames), &py_scmanager, &py_info_level, &py_type, &py_state, &py_offered, &py_resume_handle, &py_group_name)) {
		return false;
	}

	r->in.scmanager = talloc_ptrtype(r, r->in.scmanager);
	PY_CHECK_TYPE(policy_handle_Type, py_scmanager, return false;);
	r->in.scmanager = py_talloc_get_ptr(py_scmanager);
	PY_CHECK_TYPE(&PyInt_Type, py_info_level, return false;);
	r->in.info_level = PyInt_AsLong(py_info_level);
	PY_CHECK_TYPE(&PyInt_Type, py_type, return false;);
	r->in.type = PyInt_AsLong(py_type);
	PY_CHECK_TYPE(&PyInt_Type, py_state, return false;);
	r->in.state = PyInt_AsLong(py_state);
	PY_CHECK_TYPE(&PyInt_Type, py_offered, return false;);
	r->in.offered = PyInt_AsLong(py_offered);
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
		*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	}
	if (py_group_name == Py_None) {
		r->in.group_name = NULL;
	} else {
		r->in.group_name = talloc_ptrtype(r, r->in.group_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_group_name, return false;);
		r->in.group_name = PyString_AsString(PyUnicode_AsEncodedString(py_group_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_EnumServicesStatusExW_args_out(struct EnumServicesStatusExW *r)
{
	PyObject *result = Py_None;
	PyObject *py_services;
	PyObject *py_needed;
	PyObject *py_service_returned;
	PyObject *py_resume_handle;
	result = PyTuple_New(4);
	py_services = PyList_New(r->in.offered);
	if (py_services == NULL) {
		return NULL;
	}
	{
		int services_cntr_1;
		for (services_cntr_1 = 0; services_cntr_1 < r->in.offered; services_cntr_1++) {
			PyObject *py_services_1;
			py_services_1 = PyInt_FromLong(r->out.services[services_cntr_1]);
			PyList_SetItem(py_services, services_cntr_1, py_services_1);
		}
	}
	PyTuple_SetItem(result, 0, py_services);
	py_needed = PyInt_FromLong(*r->out.needed);
	PyTuple_SetItem(result, 1, py_needed);
	py_service_returned = PyInt_FromLong(*r->out.service_returned);
	PyTuple_SetItem(result, 2, py_service_returned);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
	} else {
		py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	}
	PyTuple_SetItem(result, 3, py_resume_handle);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_svcctl_methods[] = {
	{ "CloseServiceHandle", "S.CloseServiceHandle(handle) -> handle", (dcerpc_call_fn)dcerpc_svcctl_CloseServiceHandle, (py_data_pack_fn)pack_py_svcctl_CloseServiceHandle_args_in, (py_data_unpack_fn)unpack_py_svcctl_CloseServiceHandle_args_out, 0, &ndr_table_svcctl },
	{ "ControlService", "S.ControlService(handle, control) -> service_status", (dcerpc_call_fn)dcerpc_svcctl_ControlService, (py_data_pack_fn)pack_py_svcctl_ControlService_args_in, (py_data_unpack_fn)unpack_py_svcctl_ControlService_args_out, 1, &ndr_table_svcctl },
	{ "DeleteService", "S.DeleteService(handle) -> None", (dcerpc_call_fn)dcerpc_svcctl_DeleteService, (py_data_pack_fn)pack_py_svcctl_DeleteService_args_in, (py_data_unpack_fn)unpack_py_svcctl_DeleteService_args_out, 2, &ndr_table_svcctl },
	{ "LockServiceDatabase", "S.LockServiceDatabase(handle) -> lock", (dcerpc_call_fn)dcerpc_svcctl_LockServiceDatabase, (py_data_pack_fn)pack_py_svcctl_LockServiceDatabase_args_in, (py_data_unpack_fn)unpack_py_svcctl_LockServiceDatabase_args_out, 3, &ndr_table_svcctl },
	{ "QueryServiceObjectSecurity", "S.QueryServiceObjectSecurity(handle, security_flags, offered) -> (buffer, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceObjectSecurity, (py_data_pack_fn)pack_py_svcctl_QueryServiceObjectSecurity_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceObjectSecurity_args_out, 4, &ndr_table_svcctl },
	{ "SetServiceObjectSecurity", "S.SetServiceObjectSecurity(handle, security_flags, buffer) -> None", (dcerpc_call_fn)dcerpc_svcctl_SetServiceObjectSecurity, (py_data_pack_fn)pack_py_svcctl_SetServiceObjectSecurity_args_in, (py_data_unpack_fn)unpack_py_svcctl_SetServiceObjectSecurity_args_out, 5, &ndr_table_svcctl },
	{ "QueryServiceStatus", "S.QueryServiceStatus(handle) -> service_status", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceStatus, (py_data_pack_fn)pack_py_svcctl_QueryServiceStatus_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceStatus_args_out, 6, &ndr_table_svcctl },
	{ "SetServiceStatus", NULL, (dcerpc_call_fn)dcerpc_svcctl_SetServiceStatus, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 7, &ndr_table_svcctl },
	{ "UnlockServiceDatabase", "S.UnlockServiceDatabase(lock) -> lock", (dcerpc_call_fn)dcerpc_svcctl_UnlockServiceDatabase, (py_data_pack_fn)pack_py_svcctl_UnlockServiceDatabase_args_in, (py_data_unpack_fn)unpack_py_svcctl_UnlockServiceDatabase_args_out, 8, &ndr_table_svcctl },
	{ "NotifyBootConfigStatus", NULL, (dcerpc_call_fn)dcerpc_svcctl_NotifyBootConfigStatus, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 9, &ndr_table_svcctl },
	{ "SCSetServiceBitsW", "S.SCSetServiceBitsW(handle, bits, bitson, immediate) -> None", (dcerpc_call_fn)dcerpc_svcctl_SCSetServiceBitsW, (py_data_pack_fn)pack_py_svcctl_SCSetServiceBitsW_args_in, (py_data_unpack_fn)unpack_py_svcctl_SCSetServiceBitsW_args_out, 10, &ndr_table_svcctl },
	{ "ChangeServiceConfigW", "S.ChangeServiceConfigW(handle, type, start_type, error_control, binary_path, load_order_group, dependencies, service_start_name, password, display_name) -> tag_id", (dcerpc_call_fn)dcerpc_svcctl_ChangeServiceConfigW, (py_data_pack_fn)pack_py_svcctl_ChangeServiceConfigW_args_in, (py_data_unpack_fn)unpack_py_svcctl_ChangeServiceConfigW_args_out, 11, &ndr_table_svcctl },
	{ "CreateServiceW", "S.CreateServiceW(scmanager_handle, ServiceName, DisplayName, desired_access, type, start_type, error_control, binary_path, LoadOrderGroupKey, TagId, dependencies, service_start_name, password) -> (TagId, handle)", (dcerpc_call_fn)dcerpc_svcctl_CreateServiceW, (py_data_pack_fn)pack_py_svcctl_CreateServiceW_args_in, (py_data_unpack_fn)unpack_py_svcctl_CreateServiceW_args_out, 12, &ndr_table_svcctl },
	{ "EnumDependentServicesW", "S.EnumDependentServicesW(service, state, offered) -> (service_status, needed, services_returned)", (dcerpc_call_fn)dcerpc_svcctl_EnumDependentServicesW, (py_data_pack_fn)pack_py_svcctl_EnumDependentServicesW_args_in, (py_data_unpack_fn)unpack_py_svcctl_EnumDependentServicesW_args_out, 13, &ndr_table_svcctl },
	{ "EnumServicesStatusW", "S.EnumServicesStatusW(handle, type, state, offered, resume_handle) -> (service, needed, services_returned, resume_handle)", (dcerpc_call_fn)dcerpc_svcctl_EnumServicesStatusW, (py_data_pack_fn)pack_py_svcctl_EnumServicesStatusW_args_in, (py_data_unpack_fn)unpack_py_svcctl_EnumServicesStatusW_args_out, 14, &ndr_table_svcctl },
	{ "OpenSCManagerW", "S.OpenSCManagerW(MachineName, DatabaseName, access_mask) -> handle", (dcerpc_call_fn)dcerpc_svcctl_OpenSCManagerW, (py_data_pack_fn)pack_py_svcctl_OpenSCManagerW_args_in, (py_data_unpack_fn)unpack_py_svcctl_OpenSCManagerW_args_out, 15, &ndr_table_svcctl },
	{ "OpenServiceW", "S.OpenServiceW(scmanager_handle, ServiceName, access_mask) -> handle", (dcerpc_call_fn)dcerpc_svcctl_OpenServiceW, (py_data_pack_fn)pack_py_svcctl_OpenServiceW_args_in, (py_data_unpack_fn)unpack_py_svcctl_OpenServiceW_args_out, 16, &ndr_table_svcctl },
	{ "QueryServiceConfigW", "S.QueryServiceConfigW(handle, offered) -> (query, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceConfigW, (py_data_pack_fn)pack_py_svcctl_QueryServiceConfigW_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceConfigW_args_out, 17, &ndr_table_svcctl },
	{ "QueryServiceLockStatusW", "S.QueryServiceLockStatusW(handle, offered) -> (lock_status, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceLockStatusW, (py_data_pack_fn)pack_py_svcctl_QueryServiceLockStatusW_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceLockStatusW_args_out, 18, &ndr_table_svcctl },
	{ "StartServiceW", "S.StartServiceW(handle, Arguments) -> None", (dcerpc_call_fn)dcerpc_svcctl_StartServiceW, (py_data_pack_fn)pack_py_svcctl_StartServiceW_args_in, (py_data_unpack_fn)unpack_py_svcctl_StartServiceW_args_out, 19, &ndr_table_svcctl },
	{ "GetServiceDisplayNameW", "S.GetServiceDisplayNameW(handle, service_name, display_name_length) -> (display_name, display_name_length)", (dcerpc_call_fn)dcerpc_svcctl_GetServiceDisplayNameW, (py_data_pack_fn)pack_py_svcctl_GetServiceDisplayNameW_args_in, (py_data_unpack_fn)unpack_py_svcctl_GetServiceDisplayNameW_args_out, 20, &ndr_table_svcctl },
	{ "GetServiceKeyNameW", "S.GetServiceKeyNameW(handle, service_name, display_name_length) -> (key_name, display_name_length)", (dcerpc_call_fn)dcerpc_svcctl_GetServiceKeyNameW, (py_data_pack_fn)pack_py_svcctl_GetServiceKeyNameW_args_in, (py_data_unpack_fn)unpack_py_svcctl_GetServiceKeyNameW_args_out, 21, &ndr_table_svcctl },
	{ "SCSetServiceBitsA", "S.SCSetServiceBitsA(handle, bits, bitson, immediate) -> None", (dcerpc_call_fn)dcerpc_svcctl_SCSetServiceBitsA, (py_data_pack_fn)pack_py_svcctl_SCSetServiceBitsA_args_in, (py_data_unpack_fn)unpack_py_svcctl_SCSetServiceBitsA_args_out, 22, &ndr_table_svcctl },
	{ "ChangeServiceConfigA", "S.ChangeServiceConfigA(handle, type, start_type, error_control, binary_path, load_order_group, dependencies, service_start_name, password, display_name) -> tag_id", (dcerpc_call_fn)dcerpc_svcctl_ChangeServiceConfigA, (py_data_pack_fn)pack_py_svcctl_ChangeServiceConfigA_args_in, (py_data_unpack_fn)unpack_py_svcctl_ChangeServiceConfigA_args_out, 23, &ndr_table_svcctl },
	{ "CreateServiceA", "S.CreateServiceA(handle, ServiceName, DisplayName, desired_access, type, start_type, error_control, binary_path, LoadOrderGroupKey, dependencies, service_start_name, password) -> TagId", (dcerpc_call_fn)dcerpc_svcctl_CreateServiceA, (py_data_pack_fn)pack_py_svcctl_CreateServiceA_args_in, (py_data_unpack_fn)unpack_py_svcctl_CreateServiceA_args_out, 24, &ndr_table_svcctl },
	{ "EnumDependentServicesA", "S.EnumDependentServicesA(service, state, offered) -> (service_status, needed, services_returned)", (dcerpc_call_fn)dcerpc_svcctl_EnumDependentServicesA, (py_data_pack_fn)pack_py_svcctl_EnumDependentServicesA_args_in, (py_data_unpack_fn)unpack_py_svcctl_EnumDependentServicesA_args_out, 25, &ndr_table_svcctl },
	{ "EnumServicesStatusA", "S.EnumServicesStatusA(handle, type, state, offered, resume_handle) -> (service, needed, services_returned, resume_handle)", (dcerpc_call_fn)dcerpc_svcctl_EnumServicesStatusA, (py_data_pack_fn)pack_py_svcctl_EnumServicesStatusA_args_in, (py_data_unpack_fn)unpack_py_svcctl_EnumServicesStatusA_args_out, 26, &ndr_table_svcctl },
	{ "OpenSCManagerA", "S.OpenSCManagerA(MachineName, DatabaseName, access_mask) -> handle", (dcerpc_call_fn)dcerpc_svcctl_OpenSCManagerA, (py_data_pack_fn)pack_py_svcctl_OpenSCManagerA_args_in, (py_data_unpack_fn)unpack_py_svcctl_OpenSCManagerA_args_out, 27, &ndr_table_svcctl },
	{ "OpenServiceA", "S.OpenServiceA(scmanager_handle, ServiceName, access_mask) -> None", (dcerpc_call_fn)dcerpc_svcctl_OpenServiceA, (py_data_pack_fn)pack_py_svcctl_OpenServiceA_args_in, (py_data_unpack_fn)unpack_py_svcctl_OpenServiceA_args_out, 28, &ndr_table_svcctl },
	{ "QueryServiceConfigA", "S.QueryServiceConfigA(handle, offered) -> (query, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceConfigA, (py_data_pack_fn)pack_py_svcctl_QueryServiceConfigA_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceConfigA_args_out, 29, &ndr_table_svcctl },
	{ "QueryServiceLockStatusA", "S.QueryServiceLockStatusA(handle, offered) -> (lock_status, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceLockStatusA, (py_data_pack_fn)pack_py_svcctl_QueryServiceLockStatusA_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceLockStatusA_args_out, 30, &ndr_table_svcctl },
	{ "StartServiceA", "S.StartServiceA(handle, NumArgs, Arguments) -> None", (dcerpc_call_fn)dcerpc_svcctl_StartServiceA, (py_data_pack_fn)pack_py_svcctl_StartServiceA_args_in, (py_data_unpack_fn)unpack_py_svcctl_StartServiceA_args_out, 31, &ndr_table_svcctl },
	{ "GetServiceDisplayNameA", "S.GetServiceDisplayNameA(handle, service_name, display_name_length) -> (display_name, display_name_length)", (dcerpc_call_fn)dcerpc_svcctl_GetServiceDisplayNameA, (py_data_pack_fn)pack_py_svcctl_GetServiceDisplayNameA_args_in, (py_data_unpack_fn)unpack_py_svcctl_GetServiceDisplayNameA_args_out, 32, &ndr_table_svcctl },
	{ "GetServiceKeyNameA", "S.GetServiceKeyNameA(handle, service_name, display_name_length) -> (key_name, display_name_length)", (dcerpc_call_fn)dcerpc_svcctl_GetServiceKeyNameA, (py_data_pack_fn)pack_py_svcctl_GetServiceKeyNameA_args_in, (py_data_unpack_fn)unpack_py_svcctl_GetServiceKeyNameA_args_out, 33, &ndr_table_svcctl },
	{ "GetCurrentGroupeStateW", NULL, (dcerpc_call_fn)dcerpc_svcctl_GetCurrentGroupeStateW, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 34, &ndr_table_svcctl },
	{ "EnumServiceGroupW", NULL, (dcerpc_call_fn)dcerpc_svcctl_EnumServiceGroupW, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 35, &ndr_table_svcctl },
	{ "ChangeServiceConfig2A", "S.ChangeServiceConfig2A(handle, info_level, info) -> None", (dcerpc_call_fn)dcerpc_svcctl_ChangeServiceConfig2A, (py_data_pack_fn)pack_py_svcctl_ChangeServiceConfig2A_args_in, (py_data_unpack_fn)unpack_py_svcctl_ChangeServiceConfig2A_args_out, 36, &ndr_table_svcctl },
	{ "ChangeServiceConfig2W", "S.ChangeServiceConfig2W(handle, info_level, info) -> None", (dcerpc_call_fn)dcerpc_svcctl_ChangeServiceConfig2W, (py_data_pack_fn)pack_py_svcctl_ChangeServiceConfig2W_args_in, (py_data_unpack_fn)unpack_py_svcctl_ChangeServiceConfig2W_args_out, 37, &ndr_table_svcctl },
	{ "QueryServiceConfig2A", "S.QueryServiceConfig2A(handle, info_level, offered) -> (buffer, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceConfig2A, (py_data_pack_fn)pack_py_svcctl_QueryServiceConfig2A_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceConfig2A_args_out, 38, &ndr_table_svcctl },
	{ "QueryServiceConfig2W", "S.QueryServiceConfig2W(handle, info_level, offered) -> (buffer, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceConfig2W, (py_data_pack_fn)pack_py_svcctl_QueryServiceConfig2W_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceConfig2W_args_out, 39, &ndr_table_svcctl },
	{ "QueryServiceStatusEx", "S.QueryServiceStatusEx(handle, info_level, offered) -> (buffer, needed)", (dcerpc_call_fn)dcerpc_svcctl_QueryServiceStatusEx, (py_data_pack_fn)pack_py_svcctl_QueryServiceStatusEx_args_in, (py_data_unpack_fn)unpack_py_svcctl_QueryServiceStatusEx_args_out, 40, &ndr_table_svcctl },
	{ "EnumServicesStatusExA", "S.EnumServicesStatusExA(scmanager, info_level, type, state, offered, resume_handle) -> (services, needed, service_returned, resume_handle, group_name)", (dcerpc_call_fn)dcerpc_EnumServicesStatusExA, (py_data_pack_fn)pack_py_EnumServicesStatusExA_args_in, (py_data_unpack_fn)unpack_py_EnumServicesStatusExA_args_out, 41, &ndr_table_svcctl },
	{ "EnumServicesStatusExW", "S.EnumServicesStatusExW(scmanager, info_level, type, state, offered, resume_handle, group_name) -> (services, needed, service_returned, resume_handle)", (dcerpc_call_fn)dcerpc_EnumServicesStatusExW, (py_data_pack_fn)pack_py_EnumServicesStatusExW_args_in, (py_data_unpack_fn)unpack_py_EnumServicesStatusExW_args_out, 42, &ndr_table_svcctl },
	{ "SCSendTSMessage", NULL, (dcerpc_call_fn)dcerpc_svcctl_SCSendTSMessage, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 43, &ndr_table_svcctl },
	{ NULL }
};

static PyObject *interface_svcctl_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_svcctl);
}

#define PY_DOC_SVCCTL "Service Control"
static PyTypeObject svcctl_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "svcctl.svcctl",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "svcctl(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_SVCCTL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_svcctl_new,
};

static PyMethodDef svcctl_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initsvcctl(void)
{
	PyObject *m;
	PyObject *dep_misc;
	PyObject *dep_security;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	dep_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_security == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	if (PyType_Ready(&SERVICE_LOCK_STATUS_Type) < 0)
		return;
	if (PyType_Ready(&SERVICE_STATUS_Type) < 0)
		return;
	if (PyType_Ready(&SERVICE_STATUS_PROCESS_Type) < 0)
		return;
	if (PyType_Ready(&ENUM_SERVICE_STATUSW_Type) < 0)
		return;
	if (PyType_Ready(&ENUM_SERVICE_STATUSA_Type) < 0)
		return;
	if (PyType_Ready(&QUERY_SERVICE_CONFIG_Type) < 0)
		return;
	if (PyType_Ready(&svcctl_ArgumentString_Type) < 0)
		return;
	if (PyType_Ready(&SERVICE_DESCRIPTION_Type) < 0)
		return;
	if (PyType_Ready(&SC_ACTION_Type) < 0)
		return;
	if (PyType_Ready(&SERVICE_FAILURE_ACTIONS_Type) < 0)
		return;
	if (PyType_Ready(&svcctl_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&svcctl_InterfaceType, py_ndr_svcctl_methods))
		return;

#ifdef PY_SERVICE_LOCK_STATUS_PATCH
	PY_SERVICE_LOCK_STATUS_PATCH(&SERVICE_LOCK_STATUS_Type);
#endif
#ifdef PY_SERVICE_STATUS_PATCH
	PY_SERVICE_STATUS_PATCH(&SERVICE_STATUS_Type);
#endif
#ifdef PY_SERVICE_STATUS_PROCESS_PATCH
	PY_SERVICE_STATUS_PROCESS_PATCH(&SERVICE_STATUS_PROCESS_Type);
#endif
#ifdef PY_ENUM_SERVICE_STATUSW_PATCH
	PY_ENUM_SERVICE_STATUSW_PATCH(&ENUM_SERVICE_STATUSW_Type);
#endif
#ifdef PY_ENUM_SERVICE_STATUSA_PATCH
	PY_ENUM_SERVICE_STATUSA_PATCH(&ENUM_SERVICE_STATUSA_Type);
#endif
#ifdef PY_QUERY_SERVICE_CONFIG_PATCH
	PY_QUERY_SERVICE_CONFIG_PATCH(&QUERY_SERVICE_CONFIG_Type);
#endif
#ifdef PY_ARGUMENTSTRING_PATCH
	PY_ARGUMENTSTRING_PATCH(&svcctl_ArgumentString_Type);
#endif
#ifdef PY_SERVICE_DESCRIPTION_PATCH
	PY_SERVICE_DESCRIPTION_PATCH(&SERVICE_DESCRIPTION_Type);
#endif
#ifdef PY_SC_ACTION_PATCH
	PY_SC_ACTION_PATCH(&SC_ACTION_Type);
#endif
#ifdef PY_SERVICE_FAILURE_ACTIONS_PATCH
	PY_SERVICE_FAILURE_ACTIONS_PATCH(&SERVICE_FAILURE_ACTIONS_Type);
#endif
#ifdef PY_SVCCTL_PATCH
	PY_SVCCTL_PATCH(&svcctl_InterfaceType);
#endif

	m = Py_InitModule3("svcctl", svcctl_methods, "svcctl DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "SC_RIGHT_SVC_QUERY_CONFIG", PyInt_FromLong(SC_RIGHT_SVC_QUERY_CONFIG));
	PyModule_AddObject(m, "SERVICE_WRITE_ACCESS", PyInt_FromLong((SEC_STD_REQUIRED|SERVICE_READ_ACCESS|SERVICE_EXECUTE_ACCESS|SC_RIGHT_SVC_CHANGE_CONFIG)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_CTRL", PyInt_FromLong(SV_TYPE_DOMAIN_CTRL));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_SHUTDOWN", PyInt_FromLong(SVCCTL_ACCEPT_SHUTDOWN));
	PyModule_AddObject(m, "SVCCTL_DISABLED", PyInt_FromLong(SVCCTL_DISABLED));
	PyModule_AddObject(m, "SV_TYPE_SERVER_NT", PyInt_FromLong(SV_TYPE_SERVER_NT));
	PyModule_AddObject(m, "SV_TYPE_AFP", PyInt_FromLong(SV_TYPE_AFP));
	PyModule_AddObject(m, "SV_TYPE_SERVER_UNIX", PyInt_FromLong(SV_TYPE_SERVER_UNIX));
	PyModule_AddObject(m, "SERVICE_READ_ACCESS", PyInt_FromLong((SEC_STD_READ_CONTROL|SC_RIGHT_SVC_ENUMERATE_DEPENDENTS|SC_RIGHT_SVC_INTERROGATE|SC_RIGHT_SVC_QUERY_CONFIG|SC_RIGHT_SVC_QUERY_STATUS|SC_RIGHT_SVC_USER_DEFINED_CONTROL)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_MASTER", PyInt_FromLong(SV_TYPE_DOMAIN_MASTER));
	PyModule_AddObject(m, "SERVICE_STATE_ACTIVE", PyInt_FromLong(SERVICE_STATE_ACTIVE));
	PyModule_AddObject(m, "SVCCTL_CONTINUE_PENDING", PyInt_FromLong(SVCCTL_CONTINUE_PENDING));
	PyModule_AddObject(m, "SVCCTL_STOPPED", PyInt_FromLong(SVCCTL_STOPPED));
	PyModule_AddObject(m, "SERVICE_TYPE_FS_DRIVER", PyInt_FromLong(0x02));
	PyModule_AddObject(m, "SC_ACTION_RUN_COMMAND", PyInt_FromLong(SC_ACTION_RUN_COMMAND));
	PyModule_AddObject(m, "SVCCTL_SYSTEM_START", PyInt_FromLong(SVCCTL_SYSTEM_START));
	PyModule_AddObject(m, "SV_TYPE_BACKUP_BROWSER", PyInt_FromLong(SV_TYPE_BACKUP_BROWSER));
	PyModule_AddObject(m, "SV_TYPE_DIALIN_SERVER", PyInt_FromLong(SV_TYPE_DIALIN_SERVER));
	PyModule_AddObject(m, "SC_RIGHT_SVC_CHANGE_CONFIG", PyInt_FromLong(SC_RIGHT_SVC_CHANGE_CONFIG));
	PyModule_AddObject(m, "SV_TYPE_WFW", PyInt_FromLong(SV_TYPE_WFW));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_NETBINDCHANGE", PyInt_FromLong(SVCCTL_ACCEPT_NETBINDCHANGE));
	PyModule_AddObject(m, "SERVICE_TYPE_INTERACTIVE_PROCESS", PyInt_FromLong(0x100));
	PyModule_AddObject(m, "SC_ACTION_NONE", PyInt_FromLong(SC_ACTION_NONE));
	PyModule_AddObject(m, "SERVICE_ALL_ACCESS", PyInt_FromLong(SERVICE_WRITE_ACCESS));
	PyModule_AddObject(m, "SC_RIGHT_SVC_QUERY_STATUS", PyInt_FromLong(SC_RIGHT_SVC_QUERY_STATUS));
	PyModule_AddObject(m, "SERVICE_TYPE_WIN32_OWN_PROCESS", PyInt_FromLong(0x10));
	PyModule_AddObject(m, "SC_RIGHT_MGR_CONNECT", PyInt_FromLong(SC_RIGHT_MGR_CONNECT));
	PyModule_AddObject(m, "SVCCTL_CONTROL_PAUSE", PyInt_FromLong(SVCCTL_CONTROL_PAUSE));
	PyModule_AddObject(m, "SV_TYPE_POTENTIAL_BROWSER", PyInt_FromLong(SV_TYPE_POTENTIAL_BROWSER));
	PyModule_AddObject(m, "SVCCTL_SVC_ERROR_IGNORE", PyInt_FromLong(SVCCTL_SVC_ERROR_IGNORE));
	PyModule_AddObject(m, "SC_ACTION_REBOOT", PyInt_FromLong(SC_ACTION_REBOOT));
	PyModule_AddObject(m, "SV_TYPE_SERVER", PyInt_FromLong(SV_TYPE_SERVER));
	PyModule_AddObject(m, "SERVICE_TYPE_DRIVER", PyInt_FromLong(SERVICE_TYPE_KERNEL_DRIVER|SERVICE_TYPE_FS_DRIVER|SERVICE_TYPE_RECOGNIZER_DRIVER));
	PyModule_AddObject(m, "SV_TYPE_SQLSERVER", PyInt_FromLong(SV_TYPE_SQLSERVER));
	PyModule_AddObject(m, "SC_RIGHT_MGR_MODIFY_BOOT_CONFIG", PyInt_FromLong(SC_RIGHT_MGR_MODIFY_BOOT_CONFIG));
	PyModule_AddObject(m, "SVCCTL_SVC_ERROR_NORMAL", PyInt_FromLong(SVCCTL_SVC_ERROR_NORMAL));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_PAUSE_CONTINUE", PyInt_FromLong(SVCCTL_ACCEPT_PAUSE_CONTINUE));
	PyModule_AddObject(m, "SERVICE_TYPE_ADAPTER", PyInt_FromLong(0x04));
	PyModule_AddObject(m, "SVCCTL_CONTROL_CONTINUE", PyInt_FromLong(SVCCTL_CONTROL_CONTINUE));
	PyModule_AddObject(m, "SV_TYPE_ALL", PyInt_FromLong(0xFFFFFFFF));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_BAKCTRL", PyInt_FromLong(SV_TYPE_DOMAIN_BAKCTRL));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_ENUM", PyInt_FromLong(SV_TYPE_DOMAIN_ENUM));
	PyModule_AddObject(m, "SERVICE_TYPE_RECOGNIZER_DRIVER", PyInt_FromLong(0x08));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_MEMBER", PyInt_FromLong(SV_TYPE_DOMAIN_MEMBER));
	PyModule_AddObject(m, "SVCCTL_PAUSED", PyInt_FromLong(SVCCTL_PAUSED));
	PyModule_AddObject(m, "SERVICE_EXECUTE_ACCESS", PyInt_FromLong((SERVICE_READ_ACCESS|SC_RIGHT_SVC_START|SC_RIGHT_SVC_STOP|SC_RIGHT_SVC_PAUSE_CONTINUE)));
	PyModule_AddObject(m, "SVCCTL_CONTROL_SHUTDOWN", PyInt_FromLong(SVCCTL_CONTROL_SHUTDOWN));
	PyModule_AddObject(m, "SV_TYPE_PRINTQ_SERVER", PyInt_FromLong(SV_TYPE_PRINTQ_SERVER));
	PyModule_AddObject(m, "SERVICE_TYPE_WIN32", PyInt_FromLong(SERVICE_TYPE_WIN32_OWN_PROCESS|SERVICE_TYPE_WIN32_SHARE_PROCESS));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_HARDWAREPROFILECHANGE", PyInt_FromLong(SVCCTL_ACCEPT_HARDWAREPROFILECHANGE));
	PyModule_AddObject(m, "SV_TYPE_WORKSTATION", PyInt_FromLong(SV_TYPE_WORKSTATION));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_PARAMCHANGE", PyInt_FromLong(SVCCTL_ACCEPT_PARAMCHANGE));
	PyModule_AddObject(m, "SVCCTL_SVC_ERROR_SEVERE", PyInt_FromLong(SVCCTL_SVC_ERROR_SEVERE));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_NONE", PyInt_FromLong(0x00000000));
	PyModule_AddObject(m, "SV_TYPE_SERVER_VMS", PyInt_FromLong(SV_TYPE_SERVER_VMS));
	PyModule_AddObject(m, "SV_TYPE_SERVER_MFPN", PyInt_FromLong(SV_TYPE_SERVER_MFPN));
	PyModule_AddObject(m, "SERVICE_CONFIG_DESCRIPTION", PyInt_FromLong(SERVICE_CONFIG_DESCRIPTION));
	PyModule_AddObject(m, "SVCCTL_START_PENDING", PyInt_FromLong(SVCCTL_START_PENDING));
	PyModule_AddObject(m, "SC_RIGHT_SVC_USER_DEFINED_CONTROL", PyInt_FromLong(SC_RIGHT_SVC_USER_DEFINED_CONTROL));
	PyModule_AddObject(m, "SV_TYPE_ALTERNATE_XPORT", PyInt_FromLong(SV_TYPE_ALTERNATE_XPORT));
	PyModule_AddObject(m, "SV_TYPE_DFS_SERVER", PyInt_FromLong(SV_TYPE_DFS_SERVER));
	PyModule_AddObject(m, "SC_ACTION_RESTART", PyInt_FromLong(SC_ACTION_RESTART));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_STOP", PyInt_FromLong(SVCCTL_ACCEPT_STOP));
	PyModule_AddObject(m, "SC_RIGHT_SVC_ENUMERATE_DEPENDENTS", PyInt_FromLong(SC_RIGHT_SVC_ENUMERATE_DEPENDENTS));
	PyModule_AddObject(m, "SC_RIGHT_MGR_CREATE_SERVICE", PyInt_FromLong(SC_RIGHT_MGR_CREATE_SERVICE));
	PyModule_AddObject(m, "SC_MAX_ARGUMENTS", PyInt_FromLong(1024));
	PyModule_AddObject(m, "SVCCTL_ACCEPT_POWEREVENT", PyInt_FromLong(SVCCTL_ACCEPT_POWEREVENT));
	PyModule_AddObject(m, "SVCCTL_CONTROL_INTERROGATE", PyInt_FromLong(SVCCTL_CONTROL_INTERROGATE));
	PyModule_AddObject(m, "SVCCTL_STATE_UNKNOWN", PyInt_FromLong(SVCCTL_STATE_UNKNOWN));
	PyModule_AddObject(m, "SV_TYPE_MASTER_BROWSER", PyInt_FromLong(SV_TYPE_MASTER_BROWSER));
	PyModule_AddObject(m, "SV_TYPE_SERVER_OSF", PyInt_FromLong(SV_TYPE_SERVER_OSF));
	PyModule_AddObject(m, "SV_TYPE_LOCAL_LIST_ONLY", PyInt_FromLong(SV_TYPE_LOCAL_LIST_ONLY));
	PyModule_AddObject(m, "SC_RIGHT_MGR_LOCK", PyInt_FromLong(SC_RIGHT_MGR_LOCK));
	PyModule_AddObject(m, "SVCCTL_SVC_ERROR_CRITICAL", PyInt_FromLong(SVCCTL_SVC_ERROR_CRITICAL));
	PyModule_AddObject(m, "SC_RIGHT_MGR_ENUMERATE_SERVICE", PyInt_FromLong(SC_RIGHT_MGR_ENUMERATE_SERVICE));
	PyModule_AddObject(m, "SVCCTL_PAUSE_PENDING", PyInt_FromLong(SVCCTL_PAUSE_PENDING));
	PyModule_AddObject(m, "SVCCTL_RUNNING", PyInt_FromLong(SVCCTL_RUNNING));
	PyModule_AddObject(m, "SVCCTL_CONTROL_STOP", PyInt_FromLong(SVCCTL_CONTROL_STOP));
	PyModule_AddObject(m, "SC_MANAGER_EXECUTE_ACCESS", PyInt_FromLong(SC_MANAGER_READ_ACCESS));
	PyModule_AddObject(m, "SERVICE_TYPE_WIN32_SHARE_PROCESS", PyInt_FromLong(0x20));
	PyModule_AddObject(m, "SVCCTL_AUTO_START", PyInt_FromLong(SVCCTL_AUTO_START));
	PyModule_AddObject(m, "SV_TYPE_NOVELL", PyInt_FromLong(SV_TYPE_NOVELL));
	PyModule_AddObject(m, "SVC_STATUS_PROCESS_INFO", PyInt_FromLong(SVC_STATUS_PROCESS_INFO));
	PyModule_AddObject(m, "SV_TYPE_WIN95_PLUS", PyInt_FromLong(SV_TYPE_WIN95_PLUS));
	PyModule_AddObject(m, "SC_MANAGER_WRITE_ACCESS", PyInt_FromLong((SEC_STD_REQUIRED|SC_MANAGER_READ_ACCESS|SC_RIGHT_MGR_CREATE_SERVICE|SC_RIGHT_MGR_LOCK|SC_RIGHT_MGR_MODIFY_BOOT_CONFIG)));
	PyModule_AddObject(m, "SC_RIGHT_SVC_START", PyInt_FromLong(SC_RIGHT_SVC_START));
	PyModule_AddObject(m, "SC_RIGHT_MGR_QUERY_LOCK_STATUS", PyInt_FromLong(SC_RIGHT_MGR_QUERY_LOCK_STATUS));
	PyModule_AddObject(m, "SERVICE_STATE_ALL", PyInt_FromLong(SERVICE_STATE_ALL));
	PyModule_AddObject(m, "SC_MANAGER_READ_ACCESS", PyInt_FromLong((SEC_STD_READ_CONTROL|SC_RIGHT_MGR_CONNECT|SC_RIGHT_MGR_ENUMERATE_SERVICE|SC_RIGHT_MGR_QUERY_LOCK_STATUS)));
	PyModule_AddObject(m, "SC_RIGHT_SVC_INTERROGATE", PyInt_FromLong(SC_RIGHT_SVC_INTERROGATE));
	PyModule_AddObject(m, "SC_RIGHT_SVC_PAUSE_CONTINUE", PyInt_FromLong(SC_RIGHT_SVC_PAUSE_CONTINUE));
	PyModule_AddObject(m, "SVCCTL_BOOT_START", PyInt_FromLong(SVCCTL_BOOT_START));
	PyModule_AddObject(m, "SV_TYPE_NT", PyInt_FromLong(SV_TYPE_NT));
	PyModule_AddObject(m, "SC_MAX_ARGUMENT_LENGTH", PyInt_FromLong(1024));
	PyModule_AddObject(m, "SC_MANAGER_ALL_ACCESS", PyInt_FromLong(SC_MANAGER_WRITE_ACCESS));
	PyModule_AddObject(m, "SERVICE_STATE_INACTIVE", PyInt_FromLong(SERVICE_STATE_INACTIVE));
	PyModule_AddObject(m, "SV_TYPE_TIME_SOURCE", PyInt_FromLong(SV_TYPE_TIME_SOURCE));
	PyModule_AddObject(m, "SVCCTL_DEMAND_START", PyInt_FromLong(SVCCTL_DEMAND_START));
	PyModule_AddObject(m, "SERVICE_CONFIG_FAILURE_ACTIONS", PyInt_FromLong(SERVICE_CONFIG_FAILURE_ACTIONS));
	PyModule_AddObject(m, "SC_RIGHT_SVC_STOP", PyInt_FromLong(SC_RIGHT_SVC_STOP));
	PyModule_AddObject(m, "SERVICE_TYPE_KERNEL_DRIVER", PyInt_FromLong(0x01));
	PyModule_AddObject(m, "SVCCTL_STOP_PENDING", PyInt_FromLong(SVCCTL_STOP_PENDING));
	Py_INCREF((PyObject *)&SERVICE_LOCK_STATUS_Type);
	PyModule_AddObject(m, "SERVICE_LOCK_STATUS", (PyObject *)&SERVICE_LOCK_STATUS_Type);
	Py_INCREF((PyObject *)&SERVICE_STATUS_Type);
	PyModule_AddObject(m, "SERVICE_STATUS", (PyObject *)&SERVICE_STATUS_Type);
	Py_INCREF((PyObject *)&SERVICE_STATUS_PROCESS_Type);
	PyModule_AddObject(m, "SERVICE_STATUS_PROCESS", (PyObject *)&SERVICE_STATUS_PROCESS_Type);
	Py_INCREF((PyObject *)&ENUM_SERVICE_STATUSW_Type);
	PyModule_AddObject(m, "ENUM_SERVICE_STATUSW", (PyObject *)&ENUM_SERVICE_STATUSW_Type);
	Py_INCREF((PyObject *)&ENUM_SERVICE_STATUSA_Type);
	PyModule_AddObject(m, "ENUM_SERVICE_STATUSA", (PyObject *)&ENUM_SERVICE_STATUSA_Type);
	Py_INCREF((PyObject *)&QUERY_SERVICE_CONFIG_Type);
	PyModule_AddObject(m, "QUERY_SERVICE_CONFIG", (PyObject *)&QUERY_SERVICE_CONFIG_Type);
	Py_INCREF((PyObject *)&svcctl_ArgumentString_Type);
	PyModule_AddObject(m, "ArgumentString", (PyObject *)&svcctl_ArgumentString_Type);
	Py_INCREF((PyObject *)&SERVICE_DESCRIPTION_Type);
	PyModule_AddObject(m, "SERVICE_DESCRIPTION", (PyObject *)&SERVICE_DESCRIPTION_Type);
	Py_INCREF((PyObject *)&SC_ACTION_Type);
	PyModule_AddObject(m, "SC_ACTION", (PyObject *)&SC_ACTION_Type);
	Py_INCREF((PyObject *)&SERVICE_FAILURE_ACTIONS_Type);
	PyModule_AddObject(m, "SERVICE_FAILURE_ACTIONS", (PyObject *)&SERVICE_FAILURE_ACTIONS_Type);
	Py_INCREF((PyObject *)&svcctl_InterfaceType);
	PyModule_AddObject(m, "svcctl", (PyObject *)&svcctl_InterfaceType);
#ifdef PY_MOD_SVCCTL_PATCH
	PY_MOD_SVCCTL_PATCH(m);
#endif

}
