
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_security.h"
#include "../librpc/gen_ndr/ndr_security_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dom_sid_Type;
staticforward PyTypeObject security_ace_object_Type;
staticforward PyTypeObject security_ace_Type;
staticforward PyTypeObject security_acl_Type;
staticforward PyTypeObject security_descriptor_Type;
staticforward PyTypeObject sec_desc_buf_Type;
staticforward PyTypeObject security_token_Type;

static PyTypeObject *GUID_Type;
#include "librpc/ndr/py_security.c"


static PyObject *py_dom_sid_get_sid_rev_num(PyObject *obj, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(obj);
	PyObject *py_sid_rev_num;
	py_sid_rev_num = PyInt_FromLong(object->sid_rev_num);
	return py_sid_rev_num;
}

static int py_dom_sid_set_sid_rev_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_rev_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dom_sid_get_num_auths(PyObject *obj, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(obj);
	PyObject *py_num_auths;
	py_num_auths = PyInt_FromLong(object->num_auths);
	return py_num_auths;
}

static int py_dom_sid_set_num_auths(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_auths = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dom_sid_get_id_auth(PyObject *obj, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(obj);
	PyObject *py_id_auth;
	py_id_auth = PyList_New(6);
	if (py_id_auth == NULL) {
		return NULL;
	}
	{
		int id_auth_cntr_0;
		for (id_auth_cntr_0 = 0; id_auth_cntr_0 < 6; id_auth_cntr_0++) {
			PyObject *py_id_auth_0;
			py_id_auth_0 = PyInt_FromLong(object->id_auth[id_auth_cntr_0]);
			PyList_SetItem(py_id_auth, id_auth_cntr_0, py_id_auth_0);
		}
	}
	return py_id_auth;
}

static int py_dom_sid_set_id_auth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int id_auth_cntr_0;
		for (id_auth_cntr_0 = 0; id_auth_cntr_0 < PyList_Size(value); id_auth_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, id_auth_cntr_0), return -1;);
			object->id_auth[id_auth_cntr_0] = PyInt_AsLong(PyList_GetItem(value, id_auth_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dom_sid_get_sub_auths(PyObject *obj, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(obj);
	PyObject *py_sub_auths;
	py_sub_auths = PyList_New(15);
	if (py_sub_auths == NULL) {
		return NULL;
	}
	{
		int sub_auths_cntr_0;
		for (sub_auths_cntr_0 = 0; sub_auths_cntr_0 < 15; sub_auths_cntr_0++) {
			PyObject *py_sub_auths_0;
			py_sub_auths_0 = PyInt_FromLong(object->sub_auths[sub_auths_cntr_0]);
			PyList_SetItem(py_sub_auths, sub_auths_cntr_0, py_sub_auths_0);
		}
	}
	return py_sub_auths;
}

static int py_dom_sid_set_sub_auths(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sub_auths_cntr_0;
		for (sub_auths_cntr_0 = 0; sub_auths_cntr_0 < PyList_Size(value); sub_auths_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, sub_auths_cntr_0), return -1;);
			object->sub_auths[sub_auths_cntr_0] = PyInt_AsLong(PyList_GetItem(value, sub_auths_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dom_sid_getsetters[] = {
	{ discard_const_p(char, "sid_rev_num"), py_dom_sid_get_sid_rev_num, py_dom_sid_set_sid_rev_num },
	{ discard_const_p(char, "num_auths"), py_dom_sid_get_num_auths, py_dom_sid_set_num_auths },
	{ discard_const_p(char, "id_auth"), py_dom_sid_get_id_auth, py_dom_sid_set_id_auth },
	{ discard_const_p(char, "sub_auths"), py_dom_sid_get_sub_auths, py_dom_sid_set_sub_auths },
	{ NULL }
};

static PyObject *py_dom_sid_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dom_sid, type);
}

static PyObject *py_dom_sid_ndr_pack(PyObject *py_obj)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dom_sid);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dom_sid_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dom_sid *object = (struct dom_sid *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dom_sid);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dom_sid_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dom_sid_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dom_sid_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dom_sid_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.dom_sid",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dom_sid_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dom_sid_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dom_sid_new,
};

PyObject *py_import_security_ace_object_type(TALLOC_CTX *mem_ctx, int level, union security_ace_object_type *in)
{
	PyObject *ret;

	switch (level) {
		case SEC_ACE_OBJECT_TYPE_PRESENT:
			ret = py_talloc_import_ex(GUID_Type, mem_ctx, &in->type);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union security_ace_object_type *py_export_security_ace_object_type(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_object_type *ret = talloc_zero(mem_ctx, union security_ace_object_type);
	switch (level) {
		case SEC_ACE_OBJECT_TYPE_PRESENT:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->type, py_talloc_get_ptr(in), sizeof(ret->type));
			break;

		default:
			break;

	}

	return ret;
}

PyObject *py_import_security_ace_object_inherited_type(TALLOC_CTX *mem_ctx, int level, union security_ace_object_inherited_type *in)
{
	PyObject *ret;

	switch (level) {
		case SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT:
			ret = py_talloc_import_ex(GUID_Type, mem_ctx, &in->inherited_type);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union security_ace_object_inherited_type *py_export_security_ace_object_inherited_type(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_object_inherited_type *ret = talloc_zero(mem_ctx, union security_ace_object_inherited_type);
	switch (level) {
		case SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->inherited_type, py_talloc_get_ptr(in), sizeof(ret->inherited_type));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_security_ace_object_get_flags(PyObject *obj, void *closure)
{
	struct security_ace_object *object = (struct security_ace_object *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_security_ace_object_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace_object *object = (struct security_ace_object *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_ace_object_get_type(PyObject *obj, void *closure)
{
	struct security_ace_object *object = (struct security_ace_object *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = py_import_security_ace_object_type(py_talloc_get_mem_ctx(obj), object->flags & SEC_ACE_OBJECT_TYPE_PRESENT, &object->type);
	if (py_type == NULL) {
		return NULL;
	}
	return py_type;
}

static int py_security_ace_object_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace_object *object = (struct security_ace_object *)py_talloc_get_ptr(py_obj);
	memcpy(&object->type, py_export_security_ace_object_type(py_talloc_get_mem_ctx(py_obj), object->flags & SEC_ACE_OBJECT_TYPE_PRESENT, value), sizeof(object->type));
	return 0;
}

static PyObject *py_security_ace_object_get_inherited_type(PyObject *obj, void *closure)
{
	struct security_ace_object *object = (struct security_ace_object *)py_talloc_get_ptr(obj);
	PyObject *py_inherited_type;
	py_inherited_type = py_import_security_ace_object_inherited_type(py_talloc_get_mem_ctx(obj), object->flags & SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT, &object->inherited_type);
	if (py_inherited_type == NULL) {
		return NULL;
	}
	return py_inherited_type;
}

static int py_security_ace_object_set_inherited_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace_object *object = (struct security_ace_object *)py_talloc_get_ptr(py_obj);
	memcpy(&object->inherited_type, py_export_security_ace_object_inherited_type(py_talloc_get_mem_ctx(py_obj), object->flags & SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT, value), sizeof(object->inherited_type));
	return 0;
}

static PyGetSetDef py_security_ace_object_getsetters[] = {
	{ discard_const_p(char, "flags"), py_security_ace_object_get_flags, py_security_ace_object_set_flags },
	{ discard_const_p(char, "type"), py_security_ace_object_get_type, py_security_ace_object_set_type },
	{ discard_const_p(char, "inherited_type"), py_security_ace_object_get_inherited_type, py_security_ace_object_set_inherited_type },
	{ NULL }
};

static PyObject *py_security_ace_object_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct security_ace_object, type);
}


static PyTypeObject security_ace_object_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.ace_object",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_security_ace_object_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_object_new,
};

PyObject *py_import_security_ace_object_ctr(TALLOC_CTX *mem_ctx, int level, union security_ace_object_ctr *in)
{
	PyObject *ret;

	switch (level) {
		case SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT:
			ret = py_talloc_import_ex(&security_ace_object_Type, mem_ctx, &in->object);
			return ret;

		case SEC_ACE_TYPE_ACCESS_DENIED_OBJECT:
			ret = py_talloc_import_ex(&security_ace_object_Type, mem_ctx, &in->object);
			return ret;

		case SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT:
			ret = py_talloc_import_ex(&security_ace_object_Type, mem_ctx, &in->object);
			return ret;

		case SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT:
			ret = py_talloc_import_ex(&security_ace_object_Type, mem_ctx, &in->object);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union security_ace_object_ctr *py_export_security_ace_object_ctr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union security_ace_object_ctr *ret = talloc_zero(mem_ctx, union security_ace_object_ctr);
	switch (level) {
		case SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT:
			PY_CHECK_TYPE(&security_ace_object_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->object, py_talloc_get_ptr(in), sizeof(ret->object));
			break;

		case SEC_ACE_TYPE_ACCESS_DENIED_OBJECT:
			PY_CHECK_TYPE(&security_ace_object_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->object, py_talloc_get_ptr(in), sizeof(ret->object));
			break;

		case SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT:
			PY_CHECK_TYPE(&security_ace_object_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->object, py_talloc_get_ptr(in), sizeof(ret->object));
			break;

		case SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT:
			PY_CHECK_TYPE(&security_ace_object_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->object, py_talloc_get_ptr(in), sizeof(ret->object));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_security_ace_get_type(PyObject *obj, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_security_ace_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_ace_get_flags(PyObject *obj, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_security_ace_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_ace_get_size(PyObject *obj, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_security_ace_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_ace_get_access_mask(PyObject *obj, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyInt_FromLong(object->access_mask);
	return py_access_mask;
}

static int py_security_ace_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->access_mask = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_ace_get_object(PyObject *obj, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(obj);
	PyObject *py_object;
	py_object = py_import_security_ace_object_ctr(py_talloc_get_mem_ctx(obj), object->type, &object->object);
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_security_ace_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	memcpy(&object->object, py_export_security_ace_object_ctr(py_talloc_get_mem_ctx(py_obj), object->type, value), sizeof(object->object));
	return 0;
}

static PyObject *py_security_ace_get_trustee(PyObject *obj, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(obj);
	PyObject *py_trustee;
	py_trustee = py_talloc_import_ex(&dom_sid_Type, py_talloc_get_mem_ctx(obj), &object->trustee);
	return py_trustee;
}

static int py_security_ace_set_trustee(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
	memcpy(&object->trustee, py_talloc_get_ptr(value), sizeof(object->trustee));
	return 0;
}

static PyGetSetDef py_security_ace_getsetters[] = {
	{ discard_const_p(char, "type"), py_security_ace_get_type, py_security_ace_set_type },
	{ discard_const_p(char, "flags"), py_security_ace_get_flags, py_security_ace_set_flags },
	{ discard_const_p(char, "size"), py_security_ace_get_size, py_security_ace_set_size },
	{ discard_const_p(char, "access_mask"), py_security_ace_get_access_mask, py_security_ace_set_access_mask },
	{ discard_const_p(char, "object"), py_security_ace_get_object, py_security_ace_set_object },
	{ discard_const_p(char, "trustee"), py_security_ace_get_trustee, py_security_ace_set_trustee },
	{ NULL }
};

static PyObject *py_security_ace_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct security_ace, type);
}

static PyObject *py_security_ace_ndr_pack(PyObject *py_obj)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_security_ace);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_security_ace_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct security_ace *object = (struct security_ace *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_security_ace);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_security_ace_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_ace_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_security_ace_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_ace_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.ace",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_security_ace_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_security_ace_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_ace_new,
};


static PyObject *py_security_acl_get_revision(PyObject *obj, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(obj);
	PyObject *py_revision;
	py_revision = PyInt_FromLong(object->revision);
	return py_revision;
}

static int py_security_acl_set_revision(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->revision = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_acl_get_size(PyObject *obj, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_security_acl_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_acl_get_num_aces(PyObject *obj, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(obj);
	PyObject *py_num_aces;
	py_num_aces = PyInt_FromLong(object->num_aces);
	return py_num_aces;
}

static int py_security_acl_set_num_aces(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_aces = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_acl_get_aces(PyObject *obj, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(obj);
	PyObject *py_aces;
	py_aces = PyList_New(object->num_aces);
	if (py_aces == NULL) {
		return NULL;
	}
	{
		int aces_cntr_0;
		for (aces_cntr_0 = 0; aces_cntr_0 < object->num_aces; aces_cntr_0++) {
			PyObject *py_aces_0;
			py_aces_0 = py_talloc_import_ex(&security_ace_Type, object->aces, &object->aces[aces_cntr_0]);
			PyList_SetItem(py_aces, aces_cntr_0, py_aces_0);
		}
	}
	return py_aces;
}

static int py_security_acl_set_aces(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int aces_cntr_0;
		object->aces = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->aces, PyList_Size(value));
		for (aces_cntr_0 = 0; aces_cntr_0 < PyList_Size(value); aces_cntr_0++) {
			PY_CHECK_TYPE(&security_ace_Type, PyList_GetItem(value, aces_cntr_0), return -1;);
			memcpy(&object->aces[aces_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, aces_cntr_0)), sizeof(object->aces[aces_cntr_0]));
		}
	}
	return 0;
}

static PyGetSetDef py_security_acl_getsetters[] = {
	{ discard_const_p(char, "revision"), py_security_acl_get_revision, py_security_acl_set_revision },
	{ discard_const_p(char, "size"), py_security_acl_get_size, py_security_acl_set_size },
	{ discard_const_p(char, "num_aces"), py_security_acl_get_num_aces, py_security_acl_set_num_aces },
	{ discard_const_p(char, "aces"), py_security_acl_get_aces, py_security_acl_set_aces },
	{ NULL }
};

static PyObject *py_security_acl_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct security_acl, type);
}

static PyObject *py_security_acl_ndr_pack(PyObject *py_obj)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_security_acl);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_security_acl_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct security_acl *object = (struct security_acl *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_security_acl);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_security_acl_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_acl_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_security_acl_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_acl_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.acl",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_security_acl_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_security_acl_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_acl_new,
};


static PyObject *py_security_descriptor_get_revision(PyObject *obj, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(obj);
	PyObject *py_revision;
	py_revision = PyInt_FromLong(object->revision);
	return py_revision;
}

static int py_security_descriptor_set_revision(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->revision = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_descriptor_get_type(PyObject *obj, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_security_descriptor_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_descriptor_get_owner_sid(PyObject *obj, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(obj);
	PyObject *py_owner_sid;
	if (object->owner_sid == NULL) {
		py_owner_sid = Py_None;
	} else {
		py_owner_sid = py_talloc_import_ex(&dom_sid_Type, object->owner_sid, object->owner_sid);
	}
	return py_owner_sid;
}

static int py_security_descriptor_set_owner_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	talloc_free(object->owner_sid);
	if (value == Py_None) {
		object->owner_sid = NULL;
	} else {
		object->owner_sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->owner_sid);
		PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
		object->owner_sid = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_descriptor_get_group_sid(PyObject *obj, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(obj);
	PyObject *py_group_sid;
	if (object->group_sid == NULL) {
		py_group_sid = Py_None;
	} else {
		py_group_sid = py_talloc_import_ex(&dom_sid_Type, object->group_sid, object->group_sid);
	}
	return py_group_sid;
}

static int py_security_descriptor_set_group_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	talloc_free(object->group_sid);
	if (value == Py_None) {
		object->group_sid = NULL;
	} else {
		object->group_sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->group_sid);
		PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
		object->group_sid = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_descriptor_get_sacl(PyObject *obj, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(obj);
	PyObject *py_sacl;
	if (object->sacl == NULL) {
		py_sacl = Py_None;
	} else {
		py_sacl = py_talloc_import_ex(&security_acl_Type, object->sacl, object->sacl);
	}
	return py_sacl;
}

static int py_security_descriptor_set_sacl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sacl);
	if (value == Py_None) {
		object->sacl = NULL;
	} else {
		object->sacl = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sacl);
		PY_CHECK_TYPE(&security_acl_Type, value, return -1;);
		object->sacl = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_descriptor_get_dacl(PyObject *obj, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(obj);
	PyObject *py_dacl;
	if (object->dacl == NULL) {
		py_dacl = Py_None;
	} else {
		py_dacl = py_talloc_import_ex(&security_acl_Type, object->dacl, object->dacl);
	}
	return py_dacl;
}

static int py_security_descriptor_set_dacl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	talloc_free(object->dacl);
	if (value == Py_None) {
		object->dacl = NULL;
	} else {
		object->dacl = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->dacl);
		PY_CHECK_TYPE(&security_acl_Type, value, return -1;);
		object->dacl = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_security_descriptor_getsetters[] = {
	{ discard_const_p(char, "revision"), py_security_descriptor_get_revision, py_security_descriptor_set_revision },
	{ discard_const_p(char, "type"), py_security_descriptor_get_type, py_security_descriptor_set_type },
	{ discard_const_p(char, "owner_sid"), py_security_descriptor_get_owner_sid, py_security_descriptor_set_owner_sid },
	{ discard_const_p(char, "group_sid"), py_security_descriptor_get_group_sid, py_security_descriptor_set_group_sid },
	{ discard_const_p(char, "sacl"), py_security_descriptor_get_sacl, py_security_descriptor_set_sacl },
	{ discard_const_p(char, "dacl"), py_security_descriptor_get_dacl, py_security_descriptor_set_dacl },
	{ NULL }
};

static PyObject *py_security_descriptor_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct security_descriptor, type);
}

static PyObject *py_security_descriptor_ndr_pack(PyObject *py_obj)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_security_descriptor);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_security_descriptor_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct security_descriptor *object = (struct security_descriptor *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_security_descriptor);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_security_descriptor_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_descriptor_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_security_descriptor_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_descriptor_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.descriptor",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_security_descriptor_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_security_descriptor_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_descriptor_new,
};


static PyObject *py_sec_desc_buf_get_sd_size(PyObject *obj, void *closure)
{
	struct sec_desc_buf *object = (struct sec_desc_buf *)py_talloc_get_ptr(obj);
	PyObject *py_sd_size;
	py_sd_size = PyInt_FromLong(object->sd_size);
	return py_sd_size;
}

static int py_sec_desc_buf_set_sd_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct sec_desc_buf *object = (struct sec_desc_buf *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sd_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_sec_desc_buf_get_sd(PyObject *obj, void *closure)
{
	struct sec_desc_buf *object = (struct sec_desc_buf *)py_talloc_get_ptr(obj);
	PyObject *py_sd;
	if (object->sd == NULL) {
		py_sd = Py_None;
	} else {
		py_sd = py_talloc_import_ex(&security_descriptor_Type, object->sd, object->sd);
	}
	return py_sd;
}

static int py_sec_desc_buf_set_sd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct sec_desc_buf *object = (struct sec_desc_buf *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sd);
	if (value == Py_None) {
		object->sd = NULL;
	} else {
		object->sd = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sd);
		PY_CHECK_TYPE(&security_descriptor_Type, value, return -1;);
		object->sd = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_sec_desc_buf_getsetters[] = {
	{ discard_const_p(char, "sd_size"), py_sec_desc_buf_get_sd_size, py_sec_desc_buf_set_sd_size },
	{ discard_const_p(char, "sd"), py_sec_desc_buf_get_sd, py_sec_desc_buf_set_sd },
	{ NULL }
};

static PyObject *py_sec_desc_buf_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct sec_desc_buf, type);
}

static PyObject *py_sec_desc_buf_ndr_pack(PyObject *py_obj)
{
	struct sec_desc_buf *object = (struct sec_desc_buf *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_sec_desc_buf);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_sec_desc_buf_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct sec_desc_buf *object = (struct sec_desc_buf *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_sec_desc_buf);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_sec_desc_buf_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_sec_desc_buf_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_sec_desc_buf_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject sec_desc_buf_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.sec_desc_buf",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_sec_desc_buf_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_sec_desc_buf_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_sec_desc_buf_new,
};


static PyObject *py_security_token_get_user_sid(PyObject *obj, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(obj);
	PyObject *py_user_sid;
	if (object->user_sid == NULL) {
		py_user_sid = Py_None;
	} else {
		py_user_sid = py_talloc_import_ex(&dom_sid_Type, object->user_sid, object->user_sid);
	}
	return py_user_sid;
}

static int py_security_token_set_user_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	talloc_free(object->user_sid);
	if (value == Py_None) {
		object->user_sid = NULL;
	} else {
		object->user_sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->user_sid);
		PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
		object->user_sid = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_token_get_group_sid(PyObject *obj, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(obj);
	PyObject *py_group_sid;
	if (object->group_sid == NULL) {
		py_group_sid = Py_None;
	} else {
		py_group_sid = py_talloc_import_ex(&dom_sid_Type, object->group_sid, object->group_sid);
	}
	return py_group_sid;
}

static int py_security_token_set_group_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	talloc_free(object->group_sid);
	if (value == Py_None) {
		object->group_sid = NULL;
	} else {
		object->group_sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->group_sid);
		PY_CHECK_TYPE(&dom_sid_Type, value, return -1;);
		object->group_sid = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_security_token_get_num_sids(PyObject *obj, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyInt_FromLong(object->num_sids);
	return py_num_sids;
}

static int py_security_token_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_sids = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_security_token_get_sids(PyObject *obj, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = PyList_New(object->num_sids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < object->num_sids; sids_cntr_0++) {
			PyObject *py_sids_0;
			if (object->sids[sids_cntr_0] == NULL) {
				py_sids_0 = Py_None;
			} else {
				py_sids_0 = py_talloc_import_ex(&dom_sid_Type, object->sids[sids_cntr_0], object->sids[sids_cntr_0]);
			}
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	return py_sids;
}

static int py_security_token_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sids_cntr_0;
		object->sids = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sids, PyList_Size(value));
		for (sids_cntr_0 = 0; sids_cntr_0 < PyList_Size(value); sids_cntr_0++) {
			if (PyList_GetItem(value, sids_cntr_0) == Py_None) {
				object->sids[sids_cntr_0] = NULL;
			} else {
				object->sids[sids_cntr_0] = talloc_ptrtype(object->sids, object->sids[sids_cntr_0]);
				PY_CHECK_TYPE(&dom_sid_Type, PyList_GetItem(value, sids_cntr_0), return -1;);
				object->sids[sids_cntr_0] = py_talloc_get_ptr(PyList_GetItem(value, sids_cntr_0));
			}
		}
	}
	return 0;
}

static PyObject *py_security_token_get_privilege_mask(PyObject *obj, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(obj);
	PyObject *py_privilege_mask;
	py_privilege_mask = PyInt_FromLong(object->privilege_mask);
	return py_privilege_mask;
}

static int py_security_token_set_privilege_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->privilege_mask = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_security_token_getsetters[] = {
	{ discard_const_p(char, "user_sid"), py_security_token_get_user_sid, py_security_token_set_user_sid },
	{ discard_const_p(char, "group_sid"), py_security_token_get_group_sid, py_security_token_set_group_sid },
	{ discard_const_p(char, "num_sids"), py_security_token_get_num_sids, py_security_token_set_num_sids },
	{ discard_const_p(char, "sids"), py_security_token_get_sids, py_security_token_set_sids },
	{ discard_const_p(char, "privilege_mask"), py_security_token_get_privilege_mask, py_security_token_set_privilege_mask },
	{ NULL }
};

static PyObject *py_security_token_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct security_token, type);
}

static PyObject *py_security_token_ndr_pack(PyObject *py_obj)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_security_token);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_security_token_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct security_token *object = (struct security_token *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_security_token);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_security_token_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_security_token_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_security_token_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject security_token_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "security.token",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_security_token_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_security_token_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_security_token_new,
};

static PyMethodDef security_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initsecurity(void)
{
	PyObject *m;
	PyObject *dep_misc;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	if (PyType_Ready(&dom_sid_Type) < 0)
		return;
	if (PyType_Ready(&security_ace_object_Type) < 0)
		return;
	if (PyType_Ready(&security_ace_Type) < 0)
		return;
	if (PyType_Ready(&security_acl_Type) < 0)
		return;
	if (PyType_Ready(&security_descriptor_Type) < 0)
		return;
	if (PyType_Ready(&sec_desc_buf_Type) < 0)
		return;
	if (PyType_Ready(&security_token_Type) < 0)
		return;
#ifdef PY_DOM_SID_PATCH
	PY_DOM_SID_PATCH(&dom_sid_Type);
#endif
#ifdef PY_ACE_OBJECT_PATCH
	PY_ACE_OBJECT_PATCH(&security_ace_object_Type);
#endif
#ifdef PY_ACE_PATCH
	PY_ACE_PATCH(&security_ace_Type);
#endif
#ifdef PY_ACL_PATCH
	PY_ACL_PATCH(&security_acl_Type);
#endif
#ifdef PY_DESCRIPTOR_PATCH
	PY_DESCRIPTOR_PATCH(&security_descriptor_Type);
#endif
#ifdef PY_SEC_DESC_BUF_PATCH
	PY_SEC_DESC_BUF_PATCH(&sec_desc_buf_Type);
#endif
#ifdef PY_TOKEN_PATCH
	PY_TOKEN_PATCH(&security_token_Type);
#endif

	m = Py_InitModule3("security", security_methods, "security DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "KERB_ENCTYPE_AES128_CTS_HMAC_SHA1_96", PyInt_FromLong(KERB_ENCTYPE_AES128_CTS_HMAC_SHA1_96));
	PyModule_AddObject(m, "NAME_NT_AUTHORITY", PyString_FromString("NT AUTHORITY"));
	PyModule_AddObject(m, "SID_BUILTIN_NETWORK_CONF_OPERATORS", PyString_FromString("S-1-5-32-556"));
	PyModule_AddObject(m, "SEC_FLAG_MAXIMUM_ALLOWED", PyInt_FromLong(0x02000000));
	PyModule_AddObject(m, "SID_BUILTIN_GUESTS", PyString_FromString("S-1-5-32-546"));
	PyModule_AddObject(m, "DOMAIN_RID_USERS", PyInt_FromLong(513));
	PyModule_AddObject(m, "SEC_ADS_READ_PROP", PyInt_FromLong(0x00000010));
	PyModule_AddObject(m, "SEC_STD_SYNCHRONIZE", PyInt_FromLong(0x00100000));
	PyModule_AddObject(m, "SID_BUILTIN_PREW2K", PyString_FromString("S-1-5-32-554"));
	PyModule_AddObject(m, "STANDARD_RIGHTS_ALL_ACCESS", PyInt_FromLong(SEC_STD_ALL));
	PyModule_AddObject(m, "SEC_FILE_WRITE_DATA", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "SEC_STD_ALL", PyInt_FromLong(0x001F0000));
	PyModule_AddObject(m, "DOMAIN_RID_ADMINISTRATOR", PyInt_FromLong(500));
	PyModule_AddObject(m, "SEC_ACE_FLAG_INHERIT_ONLY", PyInt_FromLong(SEC_ACE_FLAG_INHERIT_ONLY));
	PyModule_AddObject(m, "SID_OWNER_RIGHTS", PyString_FromString("S-1-3-4"));
	PyModule_AddObject(m, "SEC_FILE_APPEND_DATA", PyInt_FromLong(0x00000004));
	PyModule_AddObject(m, "SEC_DESC_DACL_DEFAULTED", PyInt_FromLong(SEC_DESC_DACL_DEFAULTED));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_ALL", PyInt_FromLong(SEC_STD_ALL|SEC_FILE_ALL));
	PyModule_AddObject(m, "SID_NT_LOCAL_SERVICE", PyString_FromString("S-1-5-19"));
	PyModule_AddObject(m, "SEC_ACE_FLAG_OBJECT_INHERIT", PyInt_FromLong(SEC_ACE_FLAG_OBJECT_INHERIT));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEM_ENVIRONMENT", PyInt_FromLong(SEC_PRIV_SYSTEM_ENVIRONMENT));
	PyModule_AddObject(m, "SID_NT_ANONYMOUS", PyString_FromString("S-1-5-7"));
	PyModule_AddObject(m, "SEC_PRIV_RESTORE", PyInt_FromLong(SEC_PRIV_RESTORE));
	PyModule_AddObject(m, "SID_BUILTIN_REPLICATOR", PyString_FromString("S-1-5-32-552"));
	PyModule_AddObject(m, "DOMAIN_RID_KRBTGT", PyInt_FromLong(502));
	PyModule_AddObject(m, "SID_NT_REMOTE_INTERACTIVE", PyString_FromString("S-1-5-14"));
	PyModule_AddObject(m, "SEC_PRIV_DEBUG", PyInt_FromLong(SEC_PRIV_DEBUG));
	PyModule_AddObject(m, "SID_BUILTIN_RAS_SERVERS", PyString_FromString("S-1-5-32-553"));
	PyModule_AddObject(m, "SID_NT_SERVICE", PyString_FromString("S-1-5-6"));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_WRITE", PyInt_FromLong(SEC_STD_READ_CONTROL|SEC_STD_SYNCHRONIZE|SEC_FILE_WRITE_DATA|SEC_FILE_WRITE_ATTRIBUTE|SEC_FILE_WRITE_EA|SEC_FILE_APPEND_DATA));
	PyModule_AddObject(m, "SID_BUILTIN_ADMINISTRATORS", PyString_FromString("S-1-5-32-544"));
	PyModule_AddObject(m, "SID_NT_DIALUP", PyString_FromString("S-1-5-1"));
	PyModule_AddObject(m, "SEC_FLAG_SYSTEM_SECURITY", PyInt_FromLong(0x01000000));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_READ", PyInt_FromLong(SEC_STD_READ_CONTROL|SEC_STD_SYNCHRONIZE|SEC_FILE_READ_DATA|SEC_FILE_READ_ATTRIBUTE|SEC_FILE_READ_EA));
	PyModule_AddObject(m, "SEC_STD_WRITE_DAC", PyInt_FromLong(0x00040000));
	PyModule_AddObject(m, "SEC_PRIV_REMOTE_SHUTDOWN", PyInt_FromLong(SEC_PRIV_REMOTE_SHUTDOWN));
	PyModule_AddObject(m, "STANDARD_RIGHTS_EXECUTE_ACCESS", PyInt_FromLong(SEC_STD_READ_CONTROL));
	PyModule_AddObject(m, "SID_NT_OTHER_ORGANISATION", PyString_FromString("S-1-5-1000"));
	PyModule_AddObject(m, "SEC_PRIV_CREATE_GLOBAL", PyInt_FromLong(SEC_PRIV_CREATE_GLOBAL));
	PyModule_AddObject(m, "KERB_ENCTYPE_DES_CBC_MD5", PyInt_FromLong(KERB_ENCTYPE_DES_CBC_MD5));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT", PyInt_FromLong(SEC_ACE_TYPE_SYSTEM_AUDIT_OBJECT));
	PyModule_AddObject(m, "SEC_ADS_DELETE_CHILD", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_WRITE", PyInt_FromLong(SEC_RIGHTS_FILE_WRITE));
	PyModule_AddObject(m, "SEC_DIR_ADD_FILE", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "SEC_GENERIC_ALL", PyInt_FromLong(0x10000000));
	PyModule_AddObject(m, "SEC_GENERIC_WRITE", PyInt_FromLong(0x40000000));
	PyModule_AddObject(m, "DOMAIN_RID_DOMAIN_MEMBERS", PyInt_FromLong(515));
	PyModule_AddObject(m, "SID_NT_SELF", PyString_FromString("S-1-5-10"));
	PyModule_AddObject(m, "SEC_STD_REQUIRED", PyInt_FromLong(0x000F0000));
	PyModule_AddObject(m, "SEC_ACE_FLAG_CONTAINER_INHERIT", PyInt_FromLong(SEC_ACE_FLAG_CONTAINER_INHERIT));
	PyModule_AddObject(m, "SEC_ADS_CREATE_CHILD", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_EXECUTE", PyInt_FromLong(SEC_RIGHTS_FILE_EXECUTE));
	PyModule_AddObject(m, "SEC_ADS_WRITE_PROP", PyInt_FromLong(0x00000020));
	PyModule_AddObject(m, "SID_NT_DIGEST_AUTHENTICATION", PyString_FromString("S-1-5-64-21"));
	PyModule_AddObject(m, "SEC_DIR_READ_ATTRIBUTE", PyInt_FromLong(0x00000080));
	PyModule_AddObject(m, "SID_CREATOR_OWNER", PyString_FromString("S-1-3-0"));
	PyModule_AddObject(m, "SEC_DIR_READ_EA", PyInt_FromLong(0x00000008));
	PyModule_AddObject(m, "SID_NT_SYSTEM", PyString_FromString("S-1-5-18"));
	PyModule_AddObject(m, "SEC_DESC_SACL_PRESENT", PyInt_FromLong(SEC_DESC_SACL_PRESENT));
	PyModule_AddObject(m, "SECURITY_ACL_REVISION_ADS", PyInt_FromLong(SECURITY_ACL_REVISION_ADS));
	PyModule_AddObject(m, "NAME_BUILTIN", PyString_FromString("BUILTIN"));
	PyModule_AddObject(m, "SECINFO_UNPROTECTED_SACL", PyInt_FromLong(SECINFO_UNPROTECTED_SACL));
	PyModule_AddObject(m, "SEC_DESC_SACL_AUTO_INHERIT_REQ", PyInt_FromLong(SEC_DESC_SACL_AUTO_INHERIT_REQ));
	PyModule_AddObject(m, "SEC_MASK_INVALID", PyInt_FromLong(0x0ce0fe00));
	PyModule_AddObject(m, "SECINFO_DACL", PyInt_FromLong(SECINFO_DACL));
	PyModule_AddObject(m, "SECINFO_GROUP", PyInt_FromLong(SECINFO_GROUP));
	PyModule_AddObject(m, "SID_BUILTIN_SERVER_OPERATORS", PyString_FromString("S-1-5-32-549"));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEMTIME", PyInt_FromLong(SEC_PRIV_SYSTEMTIME));
	PyModule_AddObject(m, "SID_NT_NTLM_AUTHENTICATION", PyString_FromString("S-1-5-64-10"));
	PyModule_AddObject(m, "NT4_ACL_REVISION", PyInt_FromLong(SECURITY_ACL_REVISION_NT4));
	PyModule_AddObject(m, "SID_CREATOR_OWNER_DOMAIN", PyString_FromString("S-1-3"));
	PyModule_AddObject(m, "SECURITY_DESCRIPTOR_REVISION_1", PyInt_FromLong(SECURITY_DESCRIPTOR_REVISION_1));
	PyModule_AddObject(m, "SEC_REG_CREATE_LINK", PyInt_FromLong(0x00000020));
	PyModule_AddObject(m, "SEC_REG_NOTIFY", PyInt_FromLong(0x00000010));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT", PyInt_FromLong(SEC_ACE_TYPE_ACCESS_ALLOWED_OBJECT));
	PyModule_AddObject(m, "SEC_REG_CREATE_SUBKEY", PyInt_FromLong(0x00000004));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_ALLOWED", PyInt_FromLong(SEC_ACE_TYPE_ACCESS_ALLOWED));
	PyModule_AddObject(m, "SEC_DIR_TRAVERSE", PyInt_FromLong(0x00000020));
	PyModule_AddObject(m, "SEC_DESC_RM_CONTROL_VALID", PyInt_FromLong(SEC_DESC_RM_CONTROL_VALID));
	PyModule_AddObject(m, "SEC_DESC_DACL_AUTO_INHERIT_REQ", PyInt_FromLong(SEC_DESC_DACL_AUTO_INHERIT_REQ));
	PyModule_AddObject(m, "SEC_PRIV_BACKUP", PyInt_FromLong(SEC_PRIV_BACKUP));
	PyModule_AddObject(m, "SEC_FILE_READ_DATA", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "SID_NT_TERMINAL_SERVER_USERS", PyString_FromString("S-1-5-13"));
	PyModule_AddObject(m, "SID_NT_ENTERPRISE_DCS", PyString_FromString("S-1-5-9"));
	PyModule_AddObject(m, "SECINFO_PROTECTED_SACL", PyInt_FromLong(SECINFO_PROTECTED_SACL));
	PyModule_AddObject(m, "SEC_DESC_SACL_DEFAULTED", PyInt_FromLong(SEC_DESC_SACL_DEFAULTED));
	PyModule_AddObject(m, "SEC_DESC_DACL_TRUSTED", PyInt_FromLong(SEC_DESC_DACL_TRUSTED));
	PyModule_AddObject(m, "SECINFO_PROTECTED_DACL", PyInt_FromLong(SECINFO_PROTECTED_DACL));
	PyModule_AddObject(m, "SEC_DESC_SELF_RELATIVE", PyInt_FromLong(SEC_DESC_SELF_RELATIVE));
	PyModule_AddObject(m, "SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT", PyInt_FromLong(SEC_ACE_INHERITED_OBJECT_TYPE_PRESENT));
	PyModule_AddObject(m, "SEC_ACE_FLAG_VALID_INHERIT", PyInt_FromLong(SEC_ACE_FLAG_VALID_INHERIT));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_ALL", PyInt_FromLong(SEC_RIGHTS_FILE_ALL));
	PyModule_AddObject(m, "SEC_PRIV_MACHINE_ACCOUNT", PyInt_FromLong(SEC_PRIV_MACHINE_ACCOUNT));
	PyModule_AddObject(m, "SID_BUILTIN_REMOTE_DESKTOP_USERS", PyString_FromString("S-1-5-32-555"));
	PyModule_AddObject(m, "KERB_ENCTYPE_RC4_HMAC_MD5", PyInt_FromLong(KERB_ENCTYPE_RC4_HMAC_MD5));
	PyModule_AddObject(m, "SID_NT_RESTRICTED", PyString_FromString("S-1-5-12"));
	PyModule_AddObject(m, "KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96", PyInt_FromLong(KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96));
	PyModule_AddObject(m, "SEC_DESC_GROUP_DEFAULTED", PyInt_FromLong(SEC_DESC_GROUP_DEFAULTED));
	PyModule_AddObject(m, "SEC_PRIV_CHANGE_NOTIFY", PyInt_FromLong(SEC_PRIV_CHANGE_NOTIFY));
	PyModule_AddObject(m, "SEC_ADS_LIST_OBJECT", PyInt_FromLong(0x00000080));
	PyModule_AddObject(m, "SEC_PRIV_PROFILE_SINGLE_PROCESS", PyInt_FromLong(SEC_PRIV_PROFILE_SINGLE_PROCESS));
	PyModule_AddObject(m, "SEC_DESC_DACL_PRESENT", PyInt_FromLong(SEC_DESC_DACL_PRESENT));
	PyModule_AddObject(m, "SEC_DIR_DELETE_CHILD", PyInt_FromLong(0x00000040));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_AUDIT", PyInt_FromLong(SEC_ACE_TYPE_SYSTEM_AUDIT));
	PyModule_AddObject(m, "SEC_FILE_READ_ATTRIBUTE", PyInt_FromLong(0x00000080));
	PyModule_AddObject(m, "SEC_ACE_FLAG_NO_PROPAGATE_INHERIT", PyInt_FromLong(SEC_ACE_FLAG_NO_PROPAGATE_INHERIT));
	PyModule_AddObject(m, "SEC_RIGHTS_FILE_EXECUTE", PyInt_FromLong(SEC_STD_SYNCHRONIZE|SEC_STD_READ_CONTROL|SEC_FILE_READ_ATTRIBUTE|SEC_FILE_EXECUTE));
	PyModule_AddObject(m, "SECURITY_ACL_REVISION_NT4", PyInt_FromLong(SECURITY_ACL_REVISION_NT4));
	PyModule_AddObject(m, "SID_NT_INTERACTIVE", PyString_FromString("S-1-5-4"));
	PyModule_AddObject(m, "SEC_MASK_STANDARD", PyInt_FromLong(0x00FF0000));
	PyModule_AddObject(m, "SID_BUILTIN_POWER_USERS", PyString_FromString("S-1-5-32-547"));
	PyModule_AddObject(m, "SEC_ACE_FLAG_SUCCESSFUL_ACCESS", PyInt_FromLong(SEC_ACE_FLAG_SUCCESSFUL_ACCESS));
	PyModule_AddObject(m, "DOMAIN_RID_ADMINS", PyInt_FromLong(512));
	PyModule_AddObject(m, "SEC_ACE_FLAG_FAILED_ACCESS", PyInt_FromLong(SEC_ACE_FLAG_FAILED_ACCESS));
	PyModule_AddObject(m, "SEC_ADS_LIST", PyInt_FromLong(0x00000004));
	PyModule_AddObject(m, "DOMAIN_RID_GUESTS", PyInt_FromLong(514));
	PyModule_AddObject(m, "SEC_PRIV_INCREASE_BASE_PRIORITY", PyInt_FromLong(SEC_PRIV_INCREASE_BASE_PRIORITY));
	PyModule_AddObject(m, "KERB_ENCTYPE_DES_CBC_CRC", PyInt_FromLong(KERB_ENCTYPE_DES_CBC_CRC));
	PyModule_AddObject(m, "SEC_FILE_READ_EA", PyInt_FromLong(0x00000008));
	PyModule_AddObject(m, "STANDARD_RIGHTS_REQUIRED_ACCESS", PyInt_FromLong((SEC_STD_DELETE|SEC_STD_READ_CONTROL|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER)));
	PyModule_AddObject(m, "SID_WORLD_DOMAIN", PyString_FromString("S-1-1"));
	PyModule_AddObject(m, "SEC_ADS_SELF_WRITE", PyInt_FromLong(0x00000008));
	PyModule_AddObject(m, "SEC_PRIV_LOAD_DRIVER", PyInt_FromLong(SEC_PRIV_LOAD_DRIVER));
	PyModule_AddObject(m, "SEC_FILE_WRITE_ATTRIBUTE", PyInt_FromLong(0x00000100));
	PyModule_AddObject(m, "DOMAIN_RID_GUEST", PyInt_FromLong(501));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT", PyInt_FromLong(SEC_ACE_TYPE_SYSTEM_ALARM_OBJECT));
	PyModule_AddObject(m, "SEC_PRIV_ENABLE_DELEGATION", PyInt_FromLong(SEC_PRIV_ENABLE_DELEGATION));
	PyModule_AddObject(m, "SEC_PRIV_MANAGE_VOLUME", PyInt_FromLong(SEC_PRIV_MANAGE_VOLUME));
	PyModule_AddObject(m, "SECINFO_UNPROTECTED_DACL", PyInt_FromLong(SECINFO_UNPROTECTED_DACL));
	PyModule_AddObject(m, "SEC_REG_QUERY_VALUE", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "SID_CREATOR_GROUP", PyString_FromString("S-1-3-1"));
	PyModule_AddObject(m, "SID_NT_PROXY", PyString_FromString("S-1-5-8"));
	PyModule_AddObject(m, "DOMAIN_RID_DCS", PyInt_FromLong(516));
	PyModule_AddObject(m, "SID_NT_AUTHENTICATED_USERS", PyString_FromString("S-1-5-11"));
	PyModule_AddObject(m, "SEC_PRIV_UNDOCK", PyInt_FromLong(SEC_PRIV_UNDOCK));
	PyModule_AddObject(m, "SEC_PRIV_TAKE_OWNERSHIP", PyInt_FromLong(SEC_PRIV_TAKE_OWNERSHIP));
	PyModule_AddObject(m, "SEC_REG_SET_VALUE", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "SECINFO_OWNER", PyInt_FromLong(SECINFO_OWNER));
	PyModule_AddObject(m, "SEC_PRIV_NETWORK_LOGON", PyInt_FromLong(SEC_PRIV_NETWORK_LOGON));
	PyModule_AddObject(m, "NAME_WORLD", PyString_FromString("WORLD"));
	PyModule_AddObject(m, "SID_BUILTIN_ACCOUNT_OPERATORS", PyString_FromString("S-1-5-32-548"));
	PyModule_AddObject(m, "SEC_GENERIC_EXECUTE", PyInt_FromLong(0x20000000));
	PyModule_AddObject(m, "SEC_PRIV_REMOTE_INTERACTIVE_LOGON", PyInt_FromLong(SEC_PRIV_REMOTE_INTERACTIVE_LOGON));
	PyModule_AddObject(m, "SEC_ACE_FLAG_INHERITED_ACE", PyInt_FromLong(SEC_ACE_FLAG_INHERITED_ACE));
	PyModule_AddObject(m, "SEC_PRIV_SYSTEM_PROFILE", PyInt_FromLong(SEC_PRIV_SYSTEM_PROFILE));
	PyModule_AddObject(m, "SEC_ADS_CONTROL_ACCESS", PyInt_FromLong(0x00000100));
	PyModule_AddObject(m, "SEC_FILE_EXECUTE", PyInt_FromLong(0x00000020));
	PyModule_AddObject(m, "STANDARD_RIGHTS_WRITE_ACCESS", PyInt_FromLong((SEC_STD_WRITE_OWNER|SEC_STD_WRITE_DAC|SEC_STD_DELETE)));
	PyModule_AddObject(m, "STANDARD_RIGHTS_READ_ACCESS", PyInt_FromLong(SEC_STD_READ_CONTROL));
	PyModule_AddObject(m, "SID_NT_AUTHORITY", PyString_FromString("S-1-5"));
	PyModule_AddObject(m, "SEC_PRIV_INTERACTIVE_LOGON", PyInt_FromLong(SEC_PRIV_INTERACTIVE_LOGON));
	PyModule_AddObject(m, "SEC_DIR_ADD_SUBDIR", PyInt_FromLong(0x00000004));
	PyModule_AddObject(m, "SEC_PRIV_INCREASE_QUOTA", PyInt_FromLong(SEC_PRIV_INCREASE_QUOTA));
	PyModule_AddObject(m, "DOMAIN_RID_POLICY_ADMINS", PyInt_FromLong(520));
	PyModule_AddObject(m, "SEC_ACE_TYPE_SYSTEM_ALARM", PyInt_FromLong(SEC_ACE_TYPE_SYSTEM_ALARM));
	PyModule_AddObject(m, "SID_NULL", PyString_FromString("S-1-0-0"));
	PyModule_AddObject(m, "SID_NT_SCHANNEL_AUTHENTICATION", PyString_FromString("S-1-5-64-14"));
	PyModule_AddObject(m, "SEC_FILE_WRITE_EA", PyInt_FromLong(0x00000010));
	PyModule_AddObject(m, "SEC_DIR_LIST", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "SID_WORLD", PyString_FromString("S-1-1-0"));
	PyModule_AddObject(m, "DOMAIN_RID_LOGON", PyInt_FromLong(9));
	PyModule_AddObject(m, "SEC_STD_READ_CONTROL", PyInt_FromLong(0x00020000));
	PyModule_AddObject(m, "SD_REVISION", PyInt_FromLong(SECURITY_DESCRIPTOR_REVISION_1));
	PyModule_AddObject(m, "SEC_MASK_GENERIC", PyInt_FromLong(0xF0000000));
	PyModule_AddObject(m, "SEC_FILE_ALL", PyInt_FromLong(0x000001ff));
	PyModule_AddObject(m, "SEC_GENERIC_READ", PyInt_FromLong(0x80000000));
	PyModule_AddObject(m, "SEC_DIR_WRITE_EA", PyInt_FromLong(0x00000010));
	PyModule_AddObject(m, "DOMAIN_RID_SCHEMA_ADMINS", PyInt_FromLong(518));
	PyModule_AddObject(m, "DOMAIN_RID_ENTERPRISE_ADMINS", PyInt_FromLong(519));
	PyModule_AddObject(m, "SEC_MASK_SPECIFIC", PyInt_FromLong(0x0000FFFF));
	PyModule_AddObject(m, "SID_BUILTIN_USERS", PyString_FromString("S-1-5-32-545"));
	PyModule_AddObject(m, "SEC_REG_ENUM_SUBKEYS", PyInt_FromLong(0x00000008));
	PyModule_AddObject(m, "DOMAIN_RID_CERT_ADMINS", PyInt_FromLong(517));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_DENIED_OBJECT", PyInt_FromLong(SEC_ACE_TYPE_ACCESS_DENIED_OBJECT));
	PyModule_AddObject(m, "SEC_PRIV_CREATE_PAGEFILE", PyInt_FromLong(SEC_PRIV_CREATE_PAGEFILE));
	PyModule_AddObject(m, "SEC_RIGHTS_DIR_READ", PyInt_FromLong(SEC_RIGHTS_FILE_READ));
	PyModule_AddObject(m, "SEC_DESC_DACL_PROTECTED", PyInt_FromLong(SEC_DESC_DACL_PROTECTED));
	PyModule_AddObject(m, "SEC_PRIV_IMPERSONATE", PyInt_FromLong(SEC_PRIV_IMPERSONATE));
	PyModule_AddObject(m, "SID_BUILTIN", PyString_FromString("S-1-5-32"));
	PyModule_AddObject(m, "SEC_PRIV_SECURITY", PyInt_FromLong(SEC_PRIV_SECURITY));
	PyModule_AddObject(m, "SEC_DESC_SACL_AUTO_INHERITED", PyInt_FromLong(SEC_DESC_SACL_AUTO_INHERITED));
	PyModule_AddObject(m, "SEC_DESC_DACL_AUTO_INHERITED", PyInt_FromLong(SEC_DESC_DACL_AUTO_INHERITED));
	PyModule_AddObject(m, "SID_NT_IUSR", PyString_FromString("S-1-5-17"));
	PyModule_AddObject(m, "SID_BUILTIN_BACKUP_OPERATORS", PyString_FromString("S-1-5-32-551"));
	PyModule_AddObject(m, "STANDARD_RIGHTS_MODIFY_ACCESS", PyInt_FromLong(SEC_STD_READ_CONTROL));
	PyModule_AddObject(m, "SID_NT_BATCH", PyString_FromString("S-1-5-3"));
	PyModule_AddObject(m, "SID_BUILTIN_PRINT_OPERATORS", PyString_FromString("S-1-5-32-550"));
	PyModule_AddObject(m, "SEC_MASK_FLAGS", PyInt_FromLong(0x0F000000));
	PyModule_AddObject(m, "SEC_DESC_OWNER_DEFAULTED", PyInt_FromLong(SEC_DESC_OWNER_DEFAULTED));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ACCESS_DENIED", PyInt_FromLong(SEC_ACE_TYPE_ACCESS_DENIED));
	PyModule_AddObject(m, "SEC_ACE_TYPE_ALLOWED_COMPOUND", PyInt_FromLong(SEC_ACE_TYPE_ALLOWED_COMPOUND));
	PyModule_AddObject(m, "SEC_STD_WRITE_OWNER", PyInt_FromLong(0x00080000));
	PyModule_AddObject(m, "SECINFO_SACL", PyInt_FromLong(SECINFO_SACL));
	PyModule_AddObject(m, "SEC_STD_DELETE", PyInt_FromLong(0x00010000));
	PyModule_AddObject(m, "SEC_DESC_SACL_PROTECTED", PyInt_FromLong(SEC_DESC_SACL_PROTECTED));
	PyModule_AddObject(m, "SEC_PRIV_SHUTDOWN", PyInt_FromLong(SEC_PRIV_SHUTDOWN));
	PyModule_AddObject(m, "SEC_DIR_WRITE_ATTRIBUTE", PyInt_FromLong(0x00000100));
	PyModule_AddObject(m, "SID_NT_NETWORK", PyString_FromString("S-1-5-2"));
	PyModule_AddObject(m, "SEC_DESC_SERVER_SECURITY", PyInt_FromLong(SEC_DESC_SERVER_SECURITY));
	PyModule_AddObject(m, "SID_NT_NETWORK_SERVICE", PyString_FromString("S-1-5-20"));
	PyModule_AddObject(m, "SEC_ACE_OBJECT_TYPE_PRESENT", PyInt_FromLong(SEC_ACE_OBJECT_TYPE_PRESENT));
	PyModule_AddObject(m, "SID_NT_THIS_ORGANISATION", PyString_FromString("S-1-5-15"));
	PyModule_AddObject(m, "SEC_ADS_DELETE_TREE", PyInt_FromLong(0x00000040));
	Py_INCREF((PyObject *)&dom_sid_Type);
	PyModule_AddObject(m, "dom_sid", (PyObject *)&dom_sid_Type);
	Py_INCREF((PyObject *)&security_ace_object_Type);
	PyModule_AddObject(m, "ace_object", (PyObject *)&security_ace_object_Type);
	Py_INCREF((PyObject *)&security_ace_Type);
	PyModule_AddObject(m, "ace", (PyObject *)&security_ace_Type);
	Py_INCREF((PyObject *)&security_acl_Type);
	PyModule_AddObject(m, "acl", (PyObject *)&security_acl_Type);
	Py_INCREF((PyObject *)&security_descriptor_Type);
	PyModule_AddObject(m, "descriptor", (PyObject *)&security_descriptor_Type);
	Py_INCREF((PyObject *)&sec_desc_buf_Type);
	PyModule_AddObject(m, "sec_desc_buf", (PyObject *)&sec_desc_buf_Type);
	Py_INCREF((PyObject *)&security_token_Type);
	PyModule_AddObject(m, "token", (PyObject *)&security_token_Type);
#ifdef PY_MOD_SECURITY_PATCH
	PY_MOD_SECURITY_PATCH(m);
#endif

}
