
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_netlogon.h"
#include "../librpc/gen_ndr/ndr_netlogon_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/nbt.h"
staticforward PyTypeObject netr_UasInfo_Type;
staticforward PyTypeObject netr_UasLogoffInfo_Type;
staticforward PyTypeObject netr_AcctLockStr_Type;
staticforward PyTypeObject netr_IdentityInfo_Type;
staticforward PyTypeObject netr_PasswordInfo_Type;
staticforward PyTypeObject netr_ChallengeResponse_Type;
staticforward PyTypeObject netr_NetworkInfo_Type;
staticforward PyTypeObject netr_GenericInfo_Type;
staticforward PyTypeObject netr_UserSessionKey_Type;
staticforward PyTypeObject netr_LMSessionKey_Type;
staticforward PyTypeObject netr_SamBaseInfo_Type;
staticforward PyTypeObject netr_SamInfo2_Type;
staticforward PyTypeObject netr_SidAttr_Type;
staticforward PyTypeObject netr_SamInfo3_Type;
staticforward PyTypeObject netr_SamInfo6_Type;
staticforward PyTypeObject netr_PacInfo_Type;
staticforward PyTypeObject netr_GenericInfo2_Type;
staticforward PyTypeObject netr_Credential_Type;
staticforward PyTypeObject netr_Authenticator_Type;
staticforward PyTypeObject netr_DELTA_DELETE_USER_Type;
staticforward PyTypeObject netr_USER_KEY16_Type;
staticforward PyTypeObject netr_PasswordHistory_Type;
staticforward PyTypeObject netr_USER_KEYS2_Type;
staticforward PyTypeObject netr_USER_KEY_UNION_Type;
staticforward PyTypeObject netr_USER_KEYS_Type;
staticforward PyTypeObject netr_USER_PRIVATE_INFO_Type;
staticforward PyTypeObject netr_DELTA_USER_Type;
staticforward PyTypeObject netr_DELTA_DOMAIN_Type;
staticforward PyTypeObject netr_DELTA_GROUP_Type;
staticforward PyTypeObject netr_DELTA_RENAME_Type;
staticforward PyTypeObject netr_DELTA_GROUP_MEMBER_Type;
staticforward PyTypeObject netr_DELTA_ALIAS_Type;
staticforward PyTypeObject netr_DELTA_ALIAS_MEMBER_Type;
staticforward PyTypeObject netr_QUOTA_LIMITS_Type;
staticforward PyTypeObject netr_DELTA_POLICY_Type;
staticforward PyTypeObject netr_DELTA_TRUSTED_DOMAIN_Type;
staticforward PyTypeObject netr_DELTA_DELETE_TRUST_Type;
staticforward PyTypeObject netr_DELTA_ACCOUNT_Type;
staticforward PyTypeObject netr_DELTA_DELETE_ACCOUNT_Type;
staticforward PyTypeObject netr_DELTA_DELETE_SECRET_Type;
staticforward PyTypeObject netr_CIPHER_VALUE_Type;
staticforward PyTypeObject netr_DELTA_SECRET_Type;
staticforward PyTypeObject netr_DELTA_ENUM_Type;
staticforward PyTypeObject netr_DELTA_ENUM_ARRAY_Type;
staticforward PyTypeObject netr_UAS_INFO_0_Type;
staticforward PyTypeObject netr_AccountBuffer_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_1_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_2_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_3_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_4_Type;
staticforward PyTypeObject netr_ChangeLogEntry_Type;
staticforward PyTypeObject netr_Blob_Type;
staticforward PyTypeObject netr_DsRGetDCNameInfo_Type;
staticforward PyTypeObject netr_DomainQuery1_Type;
staticforward PyTypeObject netr_trust_extension_Type;
staticforward PyTypeObject netr_trust_extension_container_Type;
staticforward PyTypeObject netr_DomainTrustInfo_Type;
staticforward PyTypeObject netr_LsaPolicyInfo_Type;
staticforward PyTypeObject netr_DomainInfo1_Type;
staticforward PyTypeObject netr_CryptPassword_Type;
staticforward PyTypeObject netr_DsRAddressToSitenamesWCtr_Type;
staticforward PyTypeObject netr_DsRAddress_Type;
staticforward PyTypeObject netr_DomainTrust_Type;
staticforward PyTypeObject netr_DomainTrustList_Type;
staticforward PyTypeObject netr_DsRAddressToSitenamesExWCtr_Type;
staticforward PyTypeObject DcSitesCtr_Type;
staticforward PyTypeObject netr_TrustInfo_Type;
staticforward PyTypeObject netlogon_InterfaceType;

static PyTypeObject *dom_sid_Type;
static PyTypeObject *lsa_BinaryString_Type;
static PyTypeObject *samr_Password_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *samr_LogonHours_Type;
static PyTypeObject *samr_RidWithAttributeArray_Type;
static PyTypeObject *lsa_String_Type;
static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *lsa_SidArray_Type;
static PyTypeObject *lsa_ForestTrustInformation_Type;

static PyObject *py_netr_UasInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
	} else {
		py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_netr_UasInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->account_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->account_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_priv(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_priv;
	py_priv = PyInt_FromLong(object->priv);
	return py_priv;
}

static int py_netr_UasInfo_set_priv(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->priv = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_auth_flags(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_auth_flags;
	py_auth_flags = PyInt_FromLong(object->auth_flags);
	return py_auth_flags;
}

static int py_netr_UasInfo_set_auth_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_UasInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_bad_pw_count(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_bad_pw_count;
	py_bad_pw_count = PyInt_FromLong(object->bad_pw_count);
	return py_bad_pw_count;
}

static int py_netr_UasInfo_set_bad_pw_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_pw_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyInt_FromLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_UasInfo_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logon = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyInt_FromLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_UasInfo_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logoff = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_logoff_time(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logoff_time;
	py_logoff_time = PyInt_FromLong(object->logoff_time);
	return py_logoff_time;
}

static int py_netr_UasInfo_set_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logoff_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_kickoff_time(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_kickoff_time;
	py_kickoff_time = PyInt_FromLong(object->kickoff_time);
	return py_kickoff_time;
}

static int py_netr_UasInfo_set_kickoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->kickoff_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_password_age(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_password_age;
	py_password_age = PyInt_FromLong(object->password_age);
	return py_password_age;
}

static int py_netr_UasInfo_set_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->password_age = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_pw_can_change(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_pw_can_change;
	py_pw_can_change = PyInt_FromLong(object->pw_can_change);
	return py_pw_can_change;
}

static int py_netr_UasInfo_set_pw_can_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pw_can_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_pw_must_change(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_pw_must_change;
	py_pw_must_change = PyInt_FromLong(object->pw_must_change);
	return py_pw_must_change;
}

static int py_netr_UasInfo_set_pw_must_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pw_must_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_computer(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_computer;
	if (object->computer == NULL) {
		py_computer = Py_None;
	} else {
		py_computer = PyUnicode_Decode(object->computer, strlen(object->computer), "utf-8", "ignore");
	}
	return py_computer;
}

static int py_netr_UasInfo_set_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->computer = NULL;
	} else {
		object->computer = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->computer);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->computer = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_domain(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		py_domain = Py_None;
	} else {
		py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
	}
	return py_domain;
}

static int py_netr_UasInfo_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->domain);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->domain = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_script_path(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_script_path;
	if (object->script_path == NULL) {
		py_script_path = Py_None;
	} else {
		py_script_path = PyUnicode_Decode(object->script_path, strlen(object->script_path), "utf-8", "ignore");
	}
	return py_script_path;
}

static int py_netr_UasInfo_set_script_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->script_path = NULL;
	} else {
		object->script_path = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->script_path);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->script_path = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_unknown(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_netr_UasInfo_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_UasInfo_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_netr_UasInfo_get_account_name, py_netr_UasInfo_set_account_name },
	{ discard_const_p(char, "priv"), py_netr_UasInfo_get_priv, py_netr_UasInfo_set_priv },
	{ discard_const_p(char, "auth_flags"), py_netr_UasInfo_get_auth_flags, py_netr_UasInfo_set_auth_flags },
	{ discard_const_p(char, "logon_count"), py_netr_UasInfo_get_logon_count, py_netr_UasInfo_set_logon_count },
	{ discard_const_p(char, "bad_pw_count"), py_netr_UasInfo_get_bad_pw_count, py_netr_UasInfo_set_bad_pw_count },
	{ discard_const_p(char, "last_logon"), py_netr_UasInfo_get_last_logon, py_netr_UasInfo_set_last_logon },
	{ discard_const_p(char, "last_logoff"), py_netr_UasInfo_get_last_logoff, py_netr_UasInfo_set_last_logoff },
	{ discard_const_p(char, "logoff_time"), py_netr_UasInfo_get_logoff_time, py_netr_UasInfo_set_logoff_time },
	{ discard_const_p(char, "kickoff_time"), py_netr_UasInfo_get_kickoff_time, py_netr_UasInfo_set_kickoff_time },
	{ discard_const_p(char, "password_age"), py_netr_UasInfo_get_password_age, py_netr_UasInfo_set_password_age },
	{ discard_const_p(char, "pw_can_change"), py_netr_UasInfo_get_pw_can_change, py_netr_UasInfo_set_pw_can_change },
	{ discard_const_p(char, "pw_must_change"), py_netr_UasInfo_get_pw_must_change, py_netr_UasInfo_set_pw_must_change },
	{ discard_const_p(char, "computer"), py_netr_UasInfo_get_computer, py_netr_UasInfo_set_computer },
	{ discard_const_p(char, "domain"), py_netr_UasInfo_get_domain, py_netr_UasInfo_set_domain },
	{ discard_const_p(char, "script_path"), py_netr_UasInfo_get_script_path, py_netr_UasInfo_set_script_path },
	{ discard_const_p(char, "unknown"), py_netr_UasInfo_get_unknown, py_netr_UasInfo_set_unknown },
	{ NULL }
};

static PyObject *py_netr_UasInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_UasInfo, type);
}


static PyTypeObject netr_UasInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UasInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_UasInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UasInfo_new,
};


static PyObject *py_netr_UasLogoffInfo_get_duration(PyObject *obj, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)py_talloc_get_ptr(obj);
	PyObject *py_duration;
	py_duration = PyInt_FromLong(object->duration);
	return py_duration;
}

static int py_netr_UasLogoffInfo_set_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->duration = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasLogoffInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_UasLogoffInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_UasLogoffInfo_getsetters[] = {
	{ discard_const_p(char, "duration"), py_netr_UasLogoffInfo_get_duration, py_netr_UasLogoffInfo_set_duration },
	{ discard_const_p(char, "logon_count"), py_netr_UasLogoffInfo_get_logon_count, py_netr_UasLogoffInfo_set_logon_count },
	{ NULL }
};

static PyObject *py_netr_UasLogoffInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_UasLogoffInfo, type);
}


static PyTypeObject netr_UasLogoffInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UasLogoffInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_UasLogoffInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UasLogoffInfo_new,
};


static PyObject *py_netr_AcctLockStr_get_lockout_duration(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(obj);
	PyObject *py_lockout_duration;
	py_lockout_duration = PyInt_FromLong(object->lockout_duration);
	return py_lockout_duration;
}

static int py_netr_AcctLockStr_set_lockout_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lockout_duration = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_reset_count(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(obj);
	PyObject *py_reset_count;
	py_reset_count = PyInt_FromLong(object->reset_count);
	return py_reset_count;
}

static int py_netr_AcctLockStr_set_reset_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reset_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_bad_attempt_lockout(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(obj);
	PyObject *py_bad_attempt_lockout;
	py_bad_attempt_lockout = PyInt_FromLong(object->bad_attempt_lockout);
	return py_bad_attempt_lockout;
}

static int py_netr_AcctLockStr_set_bad_attempt_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_attempt_lockout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_dummy(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyInt_FromLong(object->dummy);
	return py_dummy;
}

static int py_netr_AcctLockStr_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_AcctLockStr_getsetters[] = {
	{ discard_const_p(char, "lockout_duration"), py_netr_AcctLockStr_get_lockout_duration, py_netr_AcctLockStr_set_lockout_duration },
	{ discard_const_p(char, "reset_count"), py_netr_AcctLockStr_get_reset_count, py_netr_AcctLockStr_set_reset_count },
	{ discard_const_p(char, "bad_attempt_lockout"), py_netr_AcctLockStr_get_bad_attempt_lockout, py_netr_AcctLockStr_set_bad_attempt_lockout },
	{ discard_const_p(char, "dummy"), py_netr_AcctLockStr_get_dummy, py_netr_AcctLockStr_set_dummy },
	{ NULL }
};

static PyObject *py_netr_AcctLockStr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_AcctLockStr, type);
}

static PyObject *py_netr_AcctLockStr_ndr_pack(PyObject *py_obj)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_AcctLockStr);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_AcctLockStr_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_AcctLockStr);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_AcctLockStr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_AcctLockStr_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_AcctLockStr_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_AcctLockStr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_AcctLockStr",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_AcctLockStr_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_AcctLockStr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_AcctLockStr_new,
};


static PyObject *py_netr_IdentityInfo_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_IdentityInfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->domain_name, py_talloc_get_ptr(value), sizeof(object->domain_name));
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_parameter_control(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(obj);
	PyObject *py_parameter_control;
	py_parameter_control = PyInt_FromLong(object->parameter_control);
	return py_parameter_control;
}

static int py_netr_IdentityInfo_set_parameter_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->parameter_control = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_logon_id_low(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_id_low;
	py_logon_id_low = PyInt_FromLong(object->logon_id_low);
	return py_logon_id_low;
}

static int py_netr_IdentityInfo_set_logon_id_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_id_low = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_logon_id_high(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_id_high;
	py_logon_id_high = PyInt_FromLong(object->logon_id_high);
	return py_logon_id_high;
}

static int py_netr_IdentityInfo_set_logon_id_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_id_high = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_IdentityInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->account_name, py_talloc_get_ptr(value), sizeof(object->account_name));
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_workstation(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(obj);
	PyObject *py_workstation;
	py_workstation = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->workstation);
	return py_workstation;
}

static int py_netr_IdentityInfo_set_workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->workstation, py_talloc_get_ptr(value), sizeof(object->workstation));
	return 0;
}

static PyGetSetDef py_netr_IdentityInfo_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_netr_IdentityInfo_get_domain_name, py_netr_IdentityInfo_set_domain_name },
	{ discard_const_p(char, "parameter_control"), py_netr_IdentityInfo_get_parameter_control, py_netr_IdentityInfo_set_parameter_control },
	{ discard_const_p(char, "logon_id_low"), py_netr_IdentityInfo_get_logon_id_low, py_netr_IdentityInfo_set_logon_id_low },
	{ discard_const_p(char, "logon_id_high"), py_netr_IdentityInfo_get_logon_id_high, py_netr_IdentityInfo_set_logon_id_high },
	{ discard_const_p(char, "account_name"), py_netr_IdentityInfo_get_account_name, py_netr_IdentityInfo_set_account_name },
	{ discard_const_p(char, "workstation"), py_netr_IdentityInfo_get_workstation, py_netr_IdentityInfo_set_workstation },
	{ NULL }
};

static PyObject *py_netr_IdentityInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_IdentityInfo, type);
}


static PyTypeObject netr_IdentityInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_IdentityInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_IdentityInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_IdentityInfo_new,
};


static PyObject *py_netr_PasswordInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)py_talloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = py_talloc_import_ex(&netr_IdentityInfo_Type, py_talloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_PasswordInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	memcpy(&object->identity_info, py_talloc_get_ptr(value), sizeof(object->identity_info));
	return 0;
}

static PyObject *py_netr_PasswordInfo_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)py_talloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = py_talloc_import_ex(samr_Password_Type, py_talloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_PasswordInfo_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	memcpy(&object->lmpassword, py_talloc_get_ptr(value), sizeof(object->lmpassword));
	return 0;
}

static PyObject *py_netr_PasswordInfo_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)py_talloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = py_talloc_import_ex(samr_Password_Type, py_talloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_PasswordInfo_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	memcpy(&object->ntpassword, py_talloc_get_ptr(value), sizeof(object->ntpassword));
	return 0;
}

static PyGetSetDef py_netr_PasswordInfo_getsetters[] = {
	{ discard_const_p(char, "identity_info"), py_netr_PasswordInfo_get_identity_info, py_netr_PasswordInfo_set_identity_info },
	{ discard_const_p(char, "lmpassword"), py_netr_PasswordInfo_get_lmpassword, py_netr_PasswordInfo_set_lmpassword },
	{ discard_const_p(char, "ntpassword"), py_netr_PasswordInfo_get_ntpassword, py_netr_PasswordInfo_set_ntpassword },
	{ NULL }
};

static PyObject *py_netr_PasswordInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_PasswordInfo, type);
}


static PyTypeObject netr_PasswordInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_PasswordInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_PasswordInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_PasswordInfo_new,
};


static PyObject *py_netr_ChallengeResponse_get_length(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_ChallengeResponse_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChallengeResponse_get_size(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_ChallengeResponse_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChallengeResponse_get_data(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_ChallengeResponse_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)py_talloc_get_ptr(py_obj);
	talloc_free(object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_Size(value));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_ChallengeResponse_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_ChallengeResponse_get_length, py_netr_ChallengeResponse_set_length },
	{ discard_const_p(char, "size"), py_netr_ChallengeResponse_get_size, py_netr_ChallengeResponse_set_size },
	{ discard_const_p(char, "data"), py_netr_ChallengeResponse_get_data, py_netr_ChallengeResponse_set_data },
	{ NULL }
};

static PyObject *py_netr_ChallengeResponse_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_ChallengeResponse, type);
}


static PyTypeObject netr_ChallengeResponse_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_ChallengeResponse",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_ChallengeResponse_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_ChallengeResponse_new,
};


static PyObject *py_netr_NetworkInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = py_talloc_import_ex(&netr_IdentityInfo_Type, py_talloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_NetworkInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	memcpy(&object->identity_info, py_talloc_get_ptr(value), sizeof(object->identity_info));
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_challenge(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(obj);
	PyObject *py_challenge;
	py_challenge = PyList_New(8);
	if (py_challenge == NULL) {
		return NULL;
	}
	{
		int challenge_cntr_0;
		for (challenge_cntr_0 = 0; challenge_cntr_0 < 8; challenge_cntr_0++) {
			PyObject *py_challenge_0;
			py_challenge_0 = PyInt_FromLong(object->challenge[challenge_cntr_0]);
			PyList_SetItem(py_challenge, challenge_cntr_0, py_challenge_0);
		}
	}
	return py_challenge;
}

static int py_netr_NetworkInfo_set_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int challenge_cntr_0;
		for (challenge_cntr_0 = 0; challenge_cntr_0 < PyList_Size(value); challenge_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, challenge_cntr_0), return -1;);
			object->challenge[challenge_cntr_0] = PyInt_AsLong(PyList_GetItem(value, challenge_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_nt(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(obj);
	PyObject *py_nt;
	py_nt = py_talloc_import_ex(&netr_ChallengeResponse_Type, py_talloc_get_mem_ctx(obj), &object->nt);
	return py_nt;
}

static int py_netr_NetworkInfo_set_nt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_ChallengeResponse_Type, value, return -1;);
	memcpy(&object->nt, py_talloc_get_ptr(value), sizeof(object->nt));
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_lm(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(obj);
	PyObject *py_lm;
	py_lm = py_talloc_import_ex(&netr_ChallengeResponse_Type, py_talloc_get_mem_ctx(obj), &object->lm);
	return py_lm;
}

static int py_netr_NetworkInfo_set_lm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_ChallengeResponse_Type, value, return -1;);
	memcpy(&object->lm, py_talloc_get_ptr(value), sizeof(object->lm));
	return 0;
}

static PyGetSetDef py_netr_NetworkInfo_getsetters[] = {
	{ discard_const_p(char, "identity_info"), py_netr_NetworkInfo_get_identity_info, py_netr_NetworkInfo_set_identity_info },
	{ discard_const_p(char, "challenge"), py_netr_NetworkInfo_get_challenge, py_netr_NetworkInfo_set_challenge },
	{ discard_const_p(char, "nt"), py_netr_NetworkInfo_get_nt, py_netr_NetworkInfo_set_nt },
	{ discard_const_p(char, "lm"), py_netr_NetworkInfo_get_lm, py_netr_NetworkInfo_set_lm },
	{ NULL }
};

static PyObject *py_netr_NetworkInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_NetworkInfo, type);
}


static PyTypeObject netr_NetworkInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NetworkInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_NetworkInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NetworkInfo_new,
};


static PyObject *py_netr_GenericInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = py_talloc_import_ex(&netr_IdentityInfo_Type, py_talloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_GenericInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	memcpy(&object->identity_info, py_talloc_get_ptr(value), sizeof(object->identity_info));
	return 0;
}

static PyObject *py_netr_GenericInfo_get_package_name(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(obj);
	PyObject *py_package_name;
	py_package_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->package_name);
	return py_package_name;
}

static int py_netr_GenericInfo_set_package_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->package_name, py_talloc_get_ptr(value), sizeof(object->package_name));
	return 0;
}

static PyObject *py_netr_GenericInfo_get_length(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_GenericInfo_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_GenericInfo_get_data(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_GenericInfo_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_Size(value));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_GenericInfo_getsetters[] = {
	{ discard_const_p(char, "identity_info"), py_netr_GenericInfo_get_identity_info, py_netr_GenericInfo_set_identity_info },
	{ discard_const_p(char, "package_name"), py_netr_GenericInfo_get_package_name, py_netr_GenericInfo_set_package_name },
	{ discard_const_p(char, "length"), py_netr_GenericInfo_get_length, py_netr_GenericInfo_set_length },
	{ discard_const_p(char, "data"), py_netr_GenericInfo_get_data, py_netr_GenericInfo_set_data },
	{ NULL }
};

static PyObject *py_netr_GenericInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_GenericInfo, type);
}


static PyTypeObject netr_GenericInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_GenericInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_GenericInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_GenericInfo_new,
};

PyObject *py_import_netr_LogonLevel(TALLOC_CTX *mem_ctx, int level, union netr_LogonLevel *in)
{
	PyObject *ret;

	switch (level) {
		case NetlogonInteractiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonNetworkInformation:
			if (in->network == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_NetworkInfo_Type, in->network, in->network);
			}
			return ret;

		case NetlogonServiceInformation:
			if (in->password == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonGenericInformation:
			if (in->generic == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_GenericInfo_Type, in->generic, in->generic);
			}
			return ret;

		case NetlogonInteractiveTransitiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonNetworkTransitiveInformation:
			if (in->network == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_NetworkInfo_Type, in->network, in->network);
			}
			return ret;

		case NetlogonServiceTransitiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_LogonLevel *py_export_netr_LogonLevel(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_LogonLevel *ret = talloc_zero(mem_ctx, union netr_LogonLevel);
	switch (level) {
		case NetlogonInteractiveInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = talloc_ptrtype(mem_ctx, ret->password);
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				ret->password = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonNetworkInformation:
			if (in == Py_None) {
				ret->network = NULL;
			} else {
				ret->network = talloc_ptrtype(mem_ctx, ret->network);
				PY_CHECK_TYPE(&netr_NetworkInfo_Type, in, talloc_free(ret); return NULL;);
				ret->network = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonServiceInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = talloc_ptrtype(mem_ctx, ret->password);
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				ret->password = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonGenericInformation:
			if (in == Py_None) {
				ret->generic = NULL;
			} else {
				ret->generic = talloc_ptrtype(mem_ctx, ret->generic);
				PY_CHECK_TYPE(&netr_GenericInfo_Type, in, talloc_free(ret); return NULL;);
				ret->generic = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonInteractiveTransitiveInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = talloc_ptrtype(mem_ctx, ret->password);
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				ret->password = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonNetworkTransitiveInformation:
			if (in == Py_None) {
				ret->network = NULL;
			} else {
				ret->network = talloc_ptrtype(mem_ctx, ret->network);
				PY_CHECK_TYPE(&netr_NetworkInfo_Type, in, talloc_free(ret); return NULL;);
				ret->network = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonServiceTransitiveInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = talloc_ptrtype(mem_ctx, ret->password);
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				ret->password = py_talloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_UserSessionKey_get_key(PyObject *obj, void *closure)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)py_talloc_get_ptr(obj);
	PyObject *py_key;
	py_key = PyList_New(16);
	if (py_key == NULL) {
		return NULL;
	}
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < 16; key_cntr_0++) {
			PyObject *py_key_0;
			py_key_0 = PyInt_FromLong(object->key[key_cntr_0]);
			PyList_SetItem(py_key, key_cntr_0, py_key_0);
		}
	}
	return py_key;
}

static int py_netr_UserSessionKey_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < PyList_Size(value); key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, key_cntr_0), return -1;);
			object->key[key_cntr_0] = PyInt_AsLong(PyList_GetItem(value, key_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_UserSessionKey_getsetters[] = {
	{ discard_const_p(char, "key"), py_netr_UserSessionKey_get_key, py_netr_UserSessionKey_set_key },
	{ NULL }
};

static PyObject *py_netr_UserSessionKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_UserSessionKey, type);
}

static PyObject *py_netr_UserSessionKey_ndr_pack(PyObject *py_obj)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_UserSessionKey);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_UserSessionKey_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_UserSessionKey);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_UserSessionKey_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_UserSessionKey_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_UserSessionKey_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_UserSessionKey_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UserSessionKey",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_UserSessionKey_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_UserSessionKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UserSessionKey_new,
};


static PyObject *py_netr_LMSessionKey_get_key(PyObject *obj, void *closure)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)py_talloc_get_ptr(obj);
	PyObject *py_key;
	py_key = PyList_New(8);
	if (py_key == NULL) {
		return NULL;
	}
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < 8; key_cntr_0++) {
			PyObject *py_key_0;
			py_key_0 = PyInt_FromLong(object->key[key_cntr_0]);
			PyList_SetItem(py_key, key_cntr_0, py_key_0);
		}
	}
	return py_key;
}

static int py_netr_LMSessionKey_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < PyList_Size(value); key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, key_cntr_0), return -1;);
			object->key[key_cntr_0] = PyInt_AsLong(PyList_GetItem(value, key_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_LMSessionKey_getsetters[] = {
	{ discard_const_p(char, "key"), py_netr_LMSessionKey_get_key, py_netr_LMSessionKey_set_key },
	{ NULL }
};

static PyObject *py_netr_LMSessionKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_LMSessionKey, type);
}

static PyObject *py_netr_LMSessionKey_ndr_pack(PyObject *py_obj)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_LMSessionKey);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_LMSessionKey_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_LMSessionKey);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_LMSessionKey_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_LMSessionKey_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_LMSessionKey_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_LMSessionKey_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_LMSessionKey",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_LMSessionKey_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_LMSessionKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LMSessionKey_new,
};


static PyObject *py_netr_SamBaseInfo_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyInt_FromLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_SamBaseInfo_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logon = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyInt_FromLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_SamBaseInfo_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logoff = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_acct_expiry(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyInt_FromLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_netr_SamBaseInfo_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->acct_expiry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyInt_FromLong(object->last_password_change);
	return py_last_password_change;
}

static int py_netr_SamBaseInfo_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_password_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_allow_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyInt_FromLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_netr_SamBaseInfo_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->allow_password_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_force_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyInt_FromLong(object->force_password_change);
	return py_force_password_change;
}

static int py_netr_SamBaseInfo_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->force_password_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_SamBaseInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->account_name, py_talloc_get_ptr(value), sizeof(object->account_name));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_full_name(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_netr_SamBaseInfo_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->full_name, py_talloc_get_ptr(value), sizeof(object->full_name));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_script(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_netr_SamBaseInfo_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->logon_script, py_talloc_get_ptr(value), sizeof(object->logon_script));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_profile_path(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_netr_SamBaseInfo_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->profile_path, py_talloc_get_ptr(value), sizeof(object->profile_path));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_home_directory(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_netr_SamBaseInfo_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->home_directory, py_talloc_get_ptr(value), sizeof(object->home_directory));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_home_drive(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_netr_SamBaseInfo_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->home_drive, py_talloc_get_ptr(value), sizeof(object->home_drive));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_SamBaseInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_bad_password_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyInt_FromLong(object->bad_password_count);
	return py_bad_password_count;
}

static int py_netr_SamBaseInfo_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_password_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_rid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_SamBaseInfo_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_primary_gid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyInt_FromLong(object->primary_gid);
	return py_primary_gid;
}

static int py_netr_SamBaseInfo_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->primary_gid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_groups(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_groups;
	py_groups = py_talloc_import_ex(samr_RidWithAttributeArray_Type, py_talloc_get_mem_ctx(obj), &object->groups);
	return py_groups;
}

static int py_netr_SamBaseInfo_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_RidWithAttributeArray_Type, value, return -1;);
	memcpy(&object->groups, py_talloc_get_ptr(value), sizeof(object->groups));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_user_flags(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyInt_FromLong(object->user_flags);
	return py_user_flags;
}

static int py_netr_SamBaseInfo_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->user_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_key(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_key;
	py_key = py_talloc_import_ex(&netr_UserSessionKey_Type, py_talloc_get_mem_ctx(obj), &object->key);
	return py_key;
}

static int py_netr_SamBaseInfo_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_UserSessionKey_Type, value, return -1;);
	memcpy(&object->key, py_talloc_get_ptr(value), sizeof(object->key));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_server(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_server;
	py_logon_server = py_talloc_import_ex(lsa_StringLarge_Type, py_talloc_get_mem_ctx(obj), &object->logon_server);
	return py_logon_server;
}

static int py_netr_SamBaseInfo_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	memcpy(&object->logon_server, py_talloc_get_ptr(value), sizeof(object->logon_server));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_domain(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domain;
	py_domain = py_talloc_import_ex(lsa_StringLarge_Type, py_talloc_get_mem_ctx(obj), &object->domain);
	return py_domain;
}

static int py_netr_SamBaseInfo_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	memcpy(&object->domain, py_talloc_get_ptr(value), sizeof(object->domain));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
	} else {
		py_domain_sid = NULL;
	}
	return py_domain_sid;
}

static int py_netr_SamBaseInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->domain_sid);
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->domain_sid);
		object->domain_sid = NULL;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_LMSessKey(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_LMSessKey;
	py_LMSessKey = py_talloc_import_ex(&netr_LMSessionKey_Type, py_talloc_get_mem_ctx(obj), &object->LMSessKey);
	return py_LMSessKey;
}

static int py_netr_SamBaseInfo_set_LMSessKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_LMSessionKey_Type, value, return -1;);
	memcpy(&object->LMSessKey, py_talloc_get_ptr(value), sizeof(object->LMSessKey));
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_acct_flags(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyInt_FromLong(object->acct_flags);
	return py_acct_flags;
}

static int py_netr_SamBaseInfo_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->acct_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_unknown(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyList_New(7);
	if (py_unknown == NULL) {
		return NULL;
	}
	{
		int unknown_cntr_0;
		for (unknown_cntr_0 = 0; unknown_cntr_0 < 7; unknown_cntr_0++) {
			PyObject *py_unknown_0;
			py_unknown_0 = PyInt_FromLong(object->unknown[unknown_cntr_0]);
			PyList_SetItem(py_unknown, unknown_cntr_0, py_unknown_0);
		}
	}
	return py_unknown;
}

static int py_netr_SamBaseInfo_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unknown_cntr_0;
		for (unknown_cntr_0 = 0; unknown_cntr_0 < PyList_Size(value); unknown_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, unknown_cntr_0), return -1;);
			object->unknown[unknown_cntr_0] = PyInt_AsLong(PyList_GetItem(value, unknown_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamBaseInfo_getsetters[] = {
	{ discard_const_p(char, "last_logon"), py_netr_SamBaseInfo_get_last_logon, py_netr_SamBaseInfo_set_last_logon },
	{ discard_const_p(char, "last_logoff"), py_netr_SamBaseInfo_get_last_logoff, py_netr_SamBaseInfo_set_last_logoff },
	{ discard_const_p(char, "acct_expiry"), py_netr_SamBaseInfo_get_acct_expiry, py_netr_SamBaseInfo_set_acct_expiry },
	{ discard_const_p(char, "last_password_change"), py_netr_SamBaseInfo_get_last_password_change, py_netr_SamBaseInfo_set_last_password_change },
	{ discard_const_p(char, "allow_password_change"), py_netr_SamBaseInfo_get_allow_password_change, py_netr_SamBaseInfo_set_allow_password_change },
	{ discard_const_p(char, "force_password_change"), py_netr_SamBaseInfo_get_force_password_change, py_netr_SamBaseInfo_set_force_password_change },
	{ discard_const_p(char, "account_name"), py_netr_SamBaseInfo_get_account_name, py_netr_SamBaseInfo_set_account_name },
	{ discard_const_p(char, "full_name"), py_netr_SamBaseInfo_get_full_name, py_netr_SamBaseInfo_set_full_name },
	{ discard_const_p(char, "logon_script"), py_netr_SamBaseInfo_get_logon_script, py_netr_SamBaseInfo_set_logon_script },
	{ discard_const_p(char, "profile_path"), py_netr_SamBaseInfo_get_profile_path, py_netr_SamBaseInfo_set_profile_path },
	{ discard_const_p(char, "home_directory"), py_netr_SamBaseInfo_get_home_directory, py_netr_SamBaseInfo_set_home_directory },
	{ discard_const_p(char, "home_drive"), py_netr_SamBaseInfo_get_home_drive, py_netr_SamBaseInfo_set_home_drive },
	{ discard_const_p(char, "logon_count"), py_netr_SamBaseInfo_get_logon_count, py_netr_SamBaseInfo_set_logon_count },
	{ discard_const_p(char, "bad_password_count"), py_netr_SamBaseInfo_get_bad_password_count, py_netr_SamBaseInfo_set_bad_password_count },
	{ discard_const_p(char, "rid"), py_netr_SamBaseInfo_get_rid, py_netr_SamBaseInfo_set_rid },
	{ discard_const_p(char, "primary_gid"), py_netr_SamBaseInfo_get_primary_gid, py_netr_SamBaseInfo_set_primary_gid },
	{ discard_const_p(char, "groups"), py_netr_SamBaseInfo_get_groups, py_netr_SamBaseInfo_set_groups },
	{ discard_const_p(char, "user_flags"), py_netr_SamBaseInfo_get_user_flags, py_netr_SamBaseInfo_set_user_flags },
	{ discard_const_p(char, "key"), py_netr_SamBaseInfo_get_key, py_netr_SamBaseInfo_set_key },
	{ discard_const_p(char, "logon_server"), py_netr_SamBaseInfo_get_logon_server, py_netr_SamBaseInfo_set_logon_server },
	{ discard_const_p(char, "domain"), py_netr_SamBaseInfo_get_domain, py_netr_SamBaseInfo_set_domain },
	{ discard_const_p(char, "domain_sid"), py_netr_SamBaseInfo_get_domain_sid, py_netr_SamBaseInfo_set_domain_sid },
	{ discard_const_p(char, "LMSessKey"), py_netr_SamBaseInfo_get_LMSessKey, py_netr_SamBaseInfo_set_LMSessKey },
	{ discard_const_p(char, "acct_flags"), py_netr_SamBaseInfo_get_acct_flags, py_netr_SamBaseInfo_set_acct_flags },
	{ discard_const_p(char, "unknown"), py_netr_SamBaseInfo_get_unknown, py_netr_SamBaseInfo_set_unknown },
	{ NULL }
};

static PyObject *py_netr_SamBaseInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_SamBaseInfo, type);
}


static PyTypeObject netr_SamBaseInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamBaseInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_SamBaseInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamBaseInfo_new,
};


static PyObject *py_netr_SamInfo2_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo2 *object = (struct netr_SamInfo2 *)py_talloc_get_ptr(obj);
	PyObject *py_base;
	py_base = py_talloc_import_ex(&netr_SamBaseInfo_Type, py_talloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo2_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo2 *object = (struct netr_SamInfo2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	memcpy(&object->base, py_talloc_get_ptr(value), sizeof(object->base));
	return 0;
}

static PyGetSetDef py_netr_SamInfo2_getsetters[] = {
	{ discard_const_p(char, "base"), py_netr_SamInfo2_get_base, py_netr_SamInfo2_set_base },
	{ NULL }
};

static PyObject *py_netr_SamInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_SamInfo2, type);
}


static PyTypeObject netr_SamInfo2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamInfo2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_SamInfo2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamInfo2_new,
};


static PyObject *py_netr_SidAttr_get_sid(PyObject *obj, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)py_talloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
	} else {
		py_sid = NULL;
	}
	return py_sid;
}

static int py_netr_SidAttr_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sid);
		object->sid = NULL;
	}
	return 0;
}

static PyObject *py_netr_SidAttr_get_attributes(PyObject *obj, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)py_talloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyInt_FromLong(object->attributes);
	return py_attributes;
}

static int py_netr_SidAttr_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->attributes = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_SidAttr_getsetters[] = {
	{ discard_const_p(char, "sid"), py_netr_SidAttr_get_sid, py_netr_SidAttr_set_sid },
	{ discard_const_p(char, "attributes"), py_netr_SidAttr_get_attributes, py_netr_SidAttr_set_attributes },
	{ NULL }
};

static PyObject *py_netr_SidAttr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_SidAttr, type);
}


static PyTypeObject netr_SidAttr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SidAttr",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_SidAttr_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SidAttr_new,
};


static PyObject *py_netr_SamInfo3_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(obj);
	PyObject *py_base;
	py_base = py_talloc_import_ex(&netr_SamBaseInfo_Type, py_talloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo3_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	memcpy(&object->base, py_talloc_get_ptr(value), sizeof(object->base));
	return 0;
}

static PyObject *py_netr_SamInfo3_get_sidcount(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(obj);
	PyObject *py_sidcount;
	py_sidcount = PyInt_FromLong(object->sidcount);
	return py_sidcount;
}

static int py_netr_SamInfo3_set_sidcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sidcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamInfo3_get_sids(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
	} else {
		py_sids = PyList_New(object->sidcount);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->sidcount; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = py_talloc_import_ex(&netr_SidAttr_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_netr_SamInfo3_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sids);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sids, PyList_Size(value));
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_Size(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&netr_SidAttr_Type, PyList_GetItem(value, sids_cntr_1), return -1;);
				memcpy(&object->sids[sids_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, sids_cntr_1)), sizeof(object->sids[sids_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamInfo3_getsetters[] = {
	{ discard_const_p(char, "base"), py_netr_SamInfo3_get_base, py_netr_SamInfo3_set_base },
	{ discard_const_p(char, "sidcount"), py_netr_SamInfo3_get_sidcount, py_netr_SamInfo3_set_sidcount },
	{ discard_const_p(char, "sids"), py_netr_SamInfo3_get_sids, py_netr_SamInfo3_set_sids },
	{ NULL }
};

static PyObject *py_netr_SamInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_SamInfo3, type);
}

static PyObject *py_netr_SamInfo3_ndr_pack(PyObject *py_obj)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_SamInfo3);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_SamInfo3_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo3);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_SamInfo3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SamInfo3_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_SamInfo3_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SamInfo3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamInfo3",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_SamInfo3_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_SamInfo3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamInfo3_new,
};


static PyObject *py_netr_SamInfo6_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(obj);
	PyObject *py_base;
	py_base = py_talloc_import_ex(&netr_SamBaseInfo_Type, py_talloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo6_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	memcpy(&object->base, py_talloc_get_ptr(value), sizeof(object->base));
	return 0;
}

static PyObject *py_netr_SamInfo6_get_sidcount(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(obj);
	PyObject *py_sidcount;
	py_sidcount = PyInt_FromLong(object->sidcount);
	return py_sidcount;
}

static int py_netr_SamInfo6_set_sidcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sidcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_sids(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
	} else {
		py_sids = PyList_New(object->sidcount);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->sidcount; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = py_talloc_import_ex(&netr_SidAttr_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_netr_SamInfo6_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sids);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sids, PyList_Size(value));
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_Size(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&netr_SidAttr_Type, PyList_GetItem(value, sids_cntr_1), return -1;);
				memcpy(&object->sids[sids_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, sids_cntr_1)), sizeof(object->sids[sids_cntr_1]));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_SamInfo6_get_forest(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(obj);
	PyObject *py_forest;
	py_forest = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->forest);
	return py_forest;
}

static int py_netr_SamInfo6_set_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->forest, py_talloc_get_ptr(value), sizeof(object->forest));
	return 0;
}

static PyObject *py_netr_SamInfo6_get_principle(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(obj);
	PyObject *py_principle;
	py_principle = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->principle);
	return py_principle;
}

static int py_netr_SamInfo6_set_principle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->principle, py_talloc_get_ptr(value), sizeof(object->principle));
	return 0;
}

static PyObject *py_netr_SamInfo6_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyList_New(20);
	if (py_unknown4 == NULL) {
		return NULL;
	}
	{
		int unknown4_cntr_0;
		for (unknown4_cntr_0 = 0; unknown4_cntr_0 < 20; unknown4_cntr_0++) {
			PyObject *py_unknown4_0;
			py_unknown4_0 = PyInt_FromLong(object->unknown4[unknown4_cntr_0]);
			PyList_SetItem(py_unknown4, unknown4_cntr_0, py_unknown4_0);
		}
	}
	return py_unknown4;
}

static int py_netr_SamInfo6_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unknown4_cntr_0;
		for (unknown4_cntr_0 = 0; unknown4_cntr_0 < PyList_Size(value); unknown4_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, unknown4_cntr_0), return -1;);
			object->unknown4[unknown4_cntr_0] = PyInt_AsLong(PyList_GetItem(value, unknown4_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamInfo6_getsetters[] = {
	{ discard_const_p(char, "base"), py_netr_SamInfo6_get_base, py_netr_SamInfo6_set_base },
	{ discard_const_p(char, "sidcount"), py_netr_SamInfo6_get_sidcount, py_netr_SamInfo6_set_sidcount },
	{ discard_const_p(char, "sids"), py_netr_SamInfo6_get_sids, py_netr_SamInfo6_set_sids },
	{ discard_const_p(char, "forest"), py_netr_SamInfo6_get_forest, py_netr_SamInfo6_set_forest },
	{ discard_const_p(char, "principle"), py_netr_SamInfo6_get_principle, py_netr_SamInfo6_set_principle },
	{ discard_const_p(char, "unknown4"), py_netr_SamInfo6_get_unknown4, py_netr_SamInfo6_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_SamInfo6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_SamInfo6, type);
}


static PyTypeObject netr_SamInfo6_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamInfo6",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_SamInfo6_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_SamInfo6_new,
};


static PyObject *py_netr_PacInfo_get_pac_size(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_pac_size;
	py_pac_size = PyInt_FromLong(object->pac_size);
	return py_pac_size;
}

static int py_netr_PacInfo_set_pac_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pac_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_pac(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_pac;
	if (object->pac == NULL) {
		py_pac = Py_None;
	} else {
		py_pac = PyList_New(object->pac_size);
		if (py_pac == NULL) {
			return NULL;
		}
		{
			int pac_cntr_1;
			for (pac_cntr_1 = 0; pac_cntr_1 < object->pac_size; pac_cntr_1++) {
				PyObject *py_pac_1;
				py_pac_1 = PyInt_FromLong(object->pac[pac_cntr_1]);
				PyList_SetItem(py_pac, pac_cntr_1, py_pac_1);
			}
		}
	}
	return py_pac;
}

static int py_netr_PacInfo_set_pac(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->pac);
	if (value == Py_None) {
		object->pac = NULL;
	} else {
		object->pac = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->pac);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pac_cntr_1;
			object->pac = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->pac, PyList_Size(value));
			for (pac_cntr_1 = 0; pac_cntr_1 < PyList_Size(value); pac_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, pac_cntr_1), return -1;);
				object->pac[pac_cntr_1] = PyInt_AsLong(PyList_GetItem(value, pac_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_logon_domain(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_domain;
	py_logon_domain = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->logon_domain);
	return py_logon_domain;
}

static int py_netr_PacInfo_set_logon_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->logon_domain, py_talloc_get_ptr(value), sizeof(object->logon_domain));
	return 0;
}

static PyObject *py_netr_PacInfo_get_logon_server(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_logon_server;
	py_logon_server = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->logon_server);
	return py_logon_server;
}

static int py_netr_PacInfo_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->logon_server, py_talloc_get_ptr(value), sizeof(object->logon_server));
	return 0;
}

static PyObject *py_netr_PacInfo_get_principal_name(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_principal_name;
	py_principal_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->principal_name);
	return py_principal_name;
}

static int py_netr_PacInfo_set_principal_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->principal_name, py_talloc_get_ptr(value), sizeof(object->principal_name));
	return 0;
}

static PyObject *py_netr_PacInfo_get_auth_size(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_auth_size;
	py_auth_size = PyInt_FromLong(object->auth_size);
	return py_auth_size;
}

static int py_netr_PacInfo_set_auth_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_auth(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_auth;
	if (object->auth == NULL) {
		py_auth = Py_None;
	} else {
		py_auth = PyList_New(object->auth_size);
		if (py_auth == NULL) {
			return NULL;
		}
		{
			int auth_cntr_1;
			for (auth_cntr_1 = 0; auth_cntr_1 < object->auth_size; auth_cntr_1++) {
				PyObject *py_auth_1;
				py_auth_1 = PyInt_FromLong(object->auth[auth_cntr_1]);
				PyList_SetItem(py_auth, auth_cntr_1, py_auth_1);
			}
		}
	}
	return py_auth;
}

static int py_netr_PacInfo_set_auth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->auth);
	if (value == Py_None) {
		object->auth = NULL;
	} else {
		object->auth = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->auth);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int auth_cntr_1;
			object->auth = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->auth, PyList_Size(value));
			for (auth_cntr_1 = 0; auth_cntr_1 < PyList_Size(value); auth_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, auth_cntr_1), return -1;);
				object->auth[auth_cntr_1] = PyInt_AsLong(PyList_GetItem(value, auth_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_user_session_key(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_user_session_key;
	py_user_session_key = py_talloc_import_ex(&netr_UserSessionKey_Type, py_talloc_get_mem_ctx(obj), &object->user_session_key);
	return py_user_session_key;
}

static int py_netr_PacInfo_set_user_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_UserSessionKey_Type, value, return -1;);
	memcpy(&object->user_session_key, py_talloc_get_ptr(value), sizeof(object->user_session_key));
	return 0;
}

static PyObject *py_netr_PacInfo_get_expansionroom(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_expansionroom;
	py_expansionroom = PyList_New(10);
	if (py_expansionroom == NULL) {
		return NULL;
	}
	{
		int expansionroom_cntr_0;
		for (expansionroom_cntr_0 = 0; expansionroom_cntr_0 < 10; expansionroom_cntr_0++) {
			PyObject *py_expansionroom_0;
			py_expansionroom_0 = PyInt_FromLong(object->expansionroom[expansionroom_cntr_0]);
			PyList_SetItem(py_expansionroom, expansionroom_cntr_0, py_expansionroom_0);
		}
	}
	return py_expansionroom;
}

static int py_netr_PacInfo_set_expansionroom(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int expansionroom_cntr_0;
		for (expansionroom_cntr_0 = 0; expansionroom_cntr_0 < PyList_Size(value); expansionroom_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, expansionroom_cntr_0), return -1;);
			object->expansionroom[expansionroom_cntr_0] = PyInt_AsLong(PyList_GetItem(value, expansionroom_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_PacInfo_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_PacInfo_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_PacInfo_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_PacInfo_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyGetSetDef py_netr_PacInfo_getsetters[] = {
	{ discard_const_p(char, "pac_size"), py_netr_PacInfo_get_pac_size, py_netr_PacInfo_set_pac_size },
	{ discard_const_p(char, "pac"), py_netr_PacInfo_get_pac, py_netr_PacInfo_set_pac },
	{ discard_const_p(char, "logon_domain"), py_netr_PacInfo_get_logon_domain, py_netr_PacInfo_set_logon_domain },
	{ discard_const_p(char, "logon_server"), py_netr_PacInfo_get_logon_server, py_netr_PacInfo_set_logon_server },
	{ discard_const_p(char, "principal_name"), py_netr_PacInfo_get_principal_name, py_netr_PacInfo_set_principal_name },
	{ discard_const_p(char, "auth_size"), py_netr_PacInfo_get_auth_size, py_netr_PacInfo_set_auth_size },
	{ discard_const_p(char, "auth"), py_netr_PacInfo_get_auth, py_netr_PacInfo_set_auth },
	{ discard_const_p(char, "user_session_key"), py_netr_PacInfo_get_user_session_key, py_netr_PacInfo_set_user_session_key },
	{ discard_const_p(char, "expansionroom"), py_netr_PacInfo_get_expansionroom, py_netr_PacInfo_set_expansionroom },
	{ discard_const_p(char, "unknown1"), py_netr_PacInfo_get_unknown1, py_netr_PacInfo_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_PacInfo_get_unknown2, py_netr_PacInfo_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_PacInfo_get_unknown3, py_netr_PacInfo_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_PacInfo_get_unknown4, py_netr_PacInfo_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_PacInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_PacInfo, type);
}


static PyTypeObject netr_PacInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_PacInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_PacInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_PacInfo_new,
};


static PyObject *py_netr_GenericInfo2_get_length(PyObject *obj, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_GenericInfo2_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_GenericInfo2_get_data(PyObject *obj, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_GenericInfo2_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_Size(value));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_GenericInfo2_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_GenericInfo2_get_length, py_netr_GenericInfo2_set_length },
	{ discard_const_p(char, "data"), py_netr_GenericInfo2_get_data, py_netr_GenericInfo2_set_data },
	{ NULL }
};

static PyObject *py_netr_GenericInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_GenericInfo2, type);
}


static PyTypeObject netr_GenericInfo2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_GenericInfo2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_GenericInfo2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_GenericInfo2_new,
};

PyObject *py_import_netr_Validation(TALLOC_CTX *mem_ctx, int level, union netr_Validation *in)
{
	PyObject *ret;

	switch (level) {
		case NetlogonValidationSamInfo:
			if (in->sam2 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_SamInfo2_Type, in->sam2, in->sam2);
			}
			return ret;

		case NetlogonValidationSamInfo2:
			if (in->sam3 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_SamInfo3_Type, in->sam3, in->sam3);
			}
			return ret;

		case 4:
			if (in->pac == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_PacInfo_Type, in->pac, in->pac);
			}
			return ret;

		case NetlogonValidationGenericInfo2:
			if (in->generic == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_GenericInfo2_Type, in->generic, in->generic);
			}
			return ret;

		case NetlogonValidationSamInfo4:
			if (in->sam6 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_SamInfo6_Type, in->sam6, in->sam6);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_Validation *py_export_netr_Validation(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_Validation *ret = talloc_zero(mem_ctx, union netr_Validation);
	switch (level) {
		case NetlogonValidationSamInfo:
			if (in == Py_None) {
				ret->sam2 = NULL;
			} else {
				ret->sam2 = talloc_ptrtype(mem_ctx, ret->sam2);
				PY_CHECK_TYPE(&netr_SamInfo2_Type, in, talloc_free(ret); return NULL;);
				ret->sam2 = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonValidationSamInfo2:
			if (in == Py_None) {
				ret->sam3 = NULL;
			} else {
				ret->sam3 = talloc_ptrtype(mem_ctx, ret->sam3);
				PY_CHECK_TYPE(&netr_SamInfo3_Type, in, talloc_free(ret); return NULL;);
				ret->sam3 = py_talloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == Py_None) {
				ret->pac = NULL;
			} else {
				ret->pac = talloc_ptrtype(mem_ctx, ret->pac);
				PY_CHECK_TYPE(&netr_PacInfo_Type, in, talloc_free(ret); return NULL;);
				ret->pac = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonValidationGenericInfo2:
			if (in == Py_None) {
				ret->generic = NULL;
			} else {
				ret->generic = talloc_ptrtype(mem_ctx, ret->generic);
				PY_CHECK_TYPE(&netr_GenericInfo2_Type, in, talloc_free(ret); return NULL;);
				ret->generic = py_talloc_get_ptr(in);
			}
			break;

		case NetlogonValidationSamInfo4:
			if (in == Py_None) {
				ret->sam6 = NULL;
			} else {
				ret->sam6 = talloc_ptrtype(mem_ctx, ret->sam6);
				PY_CHECK_TYPE(&netr_SamInfo6_Type, in, talloc_free(ret); return NULL;);
				ret->sam6 = py_talloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_Credential_get_data(PyObject *obj, void *closure)
{
	struct netr_Credential *object = (struct netr_Credential *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(8);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < 8; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_netr_Credential_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Credential *object = (struct netr_Credential *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < PyList_Size(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GetItem(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Credential_getsetters[] = {
	{ discard_const_p(char, "data"), py_netr_Credential_get_data, py_netr_Credential_set_data },
	{ NULL }
};

static PyObject *py_netr_Credential_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_Credential, type);
}

static PyObject *py_netr_Credential_ndr_pack(PyObject *py_obj)
{
	struct netr_Credential *object = (struct netr_Credential *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_Credential);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_Credential_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_Credential *object = (struct netr_Credential *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_Credential);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_Credential_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_Credential_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_Credential_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_Credential_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_Credential",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_Credential_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_Credential_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Credential_new,
};


static PyObject *py_netr_Authenticator_get_cred(PyObject *obj, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)py_talloc_get_ptr(obj);
	PyObject *py_cred;
	py_cred = py_talloc_import_ex(&netr_Credential_Type, py_talloc_get_mem_ctx(obj), &object->cred);
	return py_cred;
}

static int py_netr_Authenticator_set_cred(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_Credential_Type, value, return -1;);
	memcpy(&object->cred, py_talloc_get_ptr(value), sizeof(object->cred));
	return 0;
}

static PyObject *py_netr_Authenticator_get_timestamp(PyObject *obj, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)py_talloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyInt_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_netr_Authenticator_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timestamp = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_Authenticator_getsetters[] = {
	{ discard_const_p(char, "cred"), py_netr_Authenticator_get_cred, py_netr_Authenticator_set_cred },
	{ discard_const_p(char, "timestamp"), py_netr_Authenticator_get_timestamp, py_netr_Authenticator_set_timestamp },
	{ NULL }
};

static PyObject *py_netr_Authenticator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_Authenticator, type);
}

static PyObject *py_netr_Authenticator_ndr_pack(PyObject *py_obj)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_Authenticator);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_Authenticator_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_Authenticator);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_Authenticator_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_Authenticator_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_Authenticator_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_Authenticator_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_Authenticator",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_Authenticator_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_Authenticator_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Authenticator_new,
};


static PyObject *py_netr_DELTA_DELETE_USER_get_account_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
	} else {
		py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_netr_DELTA_DELETE_USER_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->account_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->account_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_DELETE_USER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_DELETE_USER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_DELETE_USER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_DELETE_USER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_DELETE_USER_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_DELETE_USER_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_DELETE_USER_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_DELETE_USER_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DELETE_USER_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_netr_DELTA_DELETE_USER_get_account_name, py_netr_DELTA_DELETE_USER_set_account_name },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_DELETE_USER_get_unknown1, py_netr_DELTA_DELETE_USER_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_DELETE_USER_get_unknown2, py_netr_DELTA_DELETE_USER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_DELETE_USER_get_unknown3, py_netr_DELTA_DELETE_USER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_DELETE_USER_get_unknown4, py_netr_DELTA_DELETE_USER_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_DELETE_USER_get_unknown5, py_netr_DELTA_DELETE_USER_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_DELETE_USER_get_unknown6, py_netr_DELTA_DELETE_USER_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_DELETE_USER_get_unknown7, py_netr_DELTA_DELETE_USER_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_DELETE_USER_get_unknown8, py_netr_DELTA_DELETE_USER_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_DELETE_USER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_DELETE_USER, type);
}


static PyTypeObject netr_DELTA_DELETE_USER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DELETE_USER",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_DELETE_USER_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DELETE_USER_new,
};


static PyObject *py_netr_USER_KEY16_get_length(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_USER_KEY16_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_size(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_USER_KEY16_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_flags(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_USER_KEY16_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_pwd(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(obj);
	PyObject *py_pwd;
	py_pwd = py_talloc_import_ex(samr_Password_Type, py_talloc_get_mem_ctx(obj), &object->pwd);
	return py_pwd;
}

static int py_netr_USER_KEY16_set_pwd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	memcpy(&object->pwd, py_talloc_get_ptr(value), sizeof(object->pwd));
	return 0;
}

static PyGetSetDef py_netr_USER_KEY16_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_USER_KEY16_get_length, py_netr_USER_KEY16_set_length },
	{ discard_const_p(char, "size"), py_netr_USER_KEY16_get_size, py_netr_USER_KEY16_set_size },
	{ discard_const_p(char, "flags"), py_netr_USER_KEY16_get_flags, py_netr_USER_KEY16_set_flags },
	{ discard_const_p(char, "pwd"), py_netr_USER_KEY16_get_pwd, py_netr_USER_KEY16_set_pwd },
	{ NULL }
};

static PyObject *py_netr_USER_KEY16_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_USER_KEY16, type);
}


static PyTypeObject netr_USER_KEY16_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEY16",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_USER_KEY16_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEY16_new,
};


static PyObject *py_netr_PasswordHistory_get_nt_length(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_nt_length;
	py_nt_length = PyInt_FromLong(object->nt_length);
	return py_nt_length;
}

static int py_netr_PasswordHistory_set_nt_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_size(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_nt_size;
	py_nt_size = PyInt_FromLong(object->nt_size);
	return py_nt_size;
}

static int py_netr_PasswordHistory_set_nt_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_flags(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_nt_flags;
	py_nt_flags = PyInt_FromLong(object->nt_flags);
	return py_nt_flags;
}

static int py_netr_PasswordHistory_set_nt_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_length(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_lm_length;
	py_lm_length = PyInt_FromLong(object->lm_length);
	return py_lm_length;
}

static int py_netr_PasswordHistory_set_lm_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_size(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_lm_size;
	py_lm_size = PyInt_FromLong(object->lm_size);
	return py_lm_size;
}

static int py_netr_PasswordHistory_set_lm_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_flags(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_lm_flags;
	py_lm_flags = PyInt_FromLong(object->lm_flags);
	return py_lm_flags;
}

static int py_netr_PasswordHistory_set_lm_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_history(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_nt_history;
	py_nt_history = PyList_New(object->nt_length);
	if (py_nt_history == NULL) {
		return NULL;
	}
	{
		int nt_history_cntr_0;
		for (nt_history_cntr_0 = 0; nt_history_cntr_0 < object->nt_length; nt_history_cntr_0++) {
			PyObject *py_nt_history_0;
			py_nt_history_0 = PyInt_FromLong(object->nt_history[nt_history_cntr_0]);
			PyList_SetItem(py_nt_history, nt_history_cntr_0, py_nt_history_0);
		}
	}
	return py_nt_history;
}

static int py_netr_PasswordHistory_set_nt_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nt_history_cntr_0;
		object->nt_history = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->nt_history, PyList_Size(value));
		for (nt_history_cntr_0 = 0; nt_history_cntr_0 < PyList_Size(value); nt_history_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, nt_history_cntr_0), return -1;);
			object->nt_history[nt_history_cntr_0] = PyInt_AsLong(PyList_GetItem(value, nt_history_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_history(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(obj);
	PyObject *py_lm_history;
	py_lm_history = PyList_New(object->lm_length);
	if (py_lm_history == NULL) {
		return NULL;
	}
	{
		int lm_history_cntr_0;
		for (lm_history_cntr_0 = 0; lm_history_cntr_0 < object->lm_length; lm_history_cntr_0++) {
			PyObject *py_lm_history_0;
			py_lm_history_0 = PyInt_FromLong(object->lm_history[lm_history_cntr_0]);
			PyList_SetItem(py_lm_history, lm_history_cntr_0, py_lm_history_0);
		}
	}
	return py_lm_history;
}

static int py_netr_PasswordHistory_set_lm_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int lm_history_cntr_0;
		object->lm_history = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->lm_history, PyList_Size(value));
		for (lm_history_cntr_0 = 0; lm_history_cntr_0 < PyList_Size(value); lm_history_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, lm_history_cntr_0), return -1;);
			object->lm_history[lm_history_cntr_0] = PyInt_AsLong(PyList_GetItem(value, lm_history_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_PasswordHistory_getsetters[] = {
	{ discard_const_p(char, "nt_length"), py_netr_PasswordHistory_get_nt_length, py_netr_PasswordHistory_set_nt_length },
	{ discard_const_p(char, "nt_size"), py_netr_PasswordHistory_get_nt_size, py_netr_PasswordHistory_set_nt_size },
	{ discard_const_p(char, "nt_flags"), py_netr_PasswordHistory_get_nt_flags, py_netr_PasswordHistory_set_nt_flags },
	{ discard_const_p(char, "lm_length"), py_netr_PasswordHistory_get_lm_length, py_netr_PasswordHistory_set_lm_length },
	{ discard_const_p(char, "lm_size"), py_netr_PasswordHistory_get_lm_size, py_netr_PasswordHistory_set_lm_size },
	{ discard_const_p(char, "lm_flags"), py_netr_PasswordHistory_get_lm_flags, py_netr_PasswordHistory_set_lm_flags },
	{ discard_const_p(char, "nt_history"), py_netr_PasswordHistory_get_nt_history, py_netr_PasswordHistory_set_nt_history },
	{ discard_const_p(char, "lm_history"), py_netr_PasswordHistory_get_lm_history, py_netr_PasswordHistory_set_lm_history },
	{ NULL }
};

static PyObject *py_netr_PasswordHistory_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_PasswordHistory, type);
}


static PyTypeObject netr_PasswordHistory_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_PasswordHistory",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_PasswordHistory_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_PasswordHistory_new,
};


static PyObject *py_netr_USER_KEYS2_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)py_talloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = py_talloc_import_ex(&netr_USER_KEY16_Type, py_talloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_USER_KEYS2_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEY16_Type, value, return -1;);
	memcpy(&object->lmpassword, py_talloc_get_ptr(value), sizeof(object->lmpassword));
	return 0;
}

static PyObject *py_netr_USER_KEYS2_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)py_talloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = py_talloc_import_ex(&netr_USER_KEY16_Type, py_talloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_USER_KEYS2_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEY16_Type, value, return -1;);
	memcpy(&object->ntpassword, py_talloc_get_ptr(value), sizeof(object->ntpassword));
	return 0;
}

static PyObject *py_netr_USER_KEYS2_get_history(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)py_talloc_get_ptr(obj);
	PyObject *py_history;
	py_history = py_talloc_import_ex(&netr_PasswordHistory_Type, py_talloc_get_mem_ctx(obj), &object->history);
	return py_history;
}

static int py_netr_USER_KEYS2_set_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_PasswordHistory_Type, value, return -1;);
	memcpy(&object->history, py_talloc_get_ptr(value), sizeof(object->history));
	return 0;
}

static PyGetSetDef py_netr_USER_KEYS2_getsetters[] = {
	{ discard_const_p(char, "lmpassword"), py_netr_USER_KEYS2_get_lmpassword, py_netr_USER_KEYS2_set_lmpassword },
	{ discard_const_p(char, "ntpassword"), py_netr_USER_KEYS2_get_ntpassword, py_netr_USER_KEYS2_set_ntpassword },
	{ discard_const_p(char, "history"), py_netr_USER_KEYS2_get_history, py_netr_USER_KEYS2_set_history },
	{ NULL }
};

static PyObject *py_netr_USER_KEYS2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_USER_KEYS2, type);
}


static PyTypeObject netr_USER_KEYS2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEYS2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_USER_KEYS2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEYS2_new,
};


static PyObject *py_netr_USER_KEY_UNION_get_keys2(PyObject *obj, void *closure)
{
	struct netr_USER_KEY_UNION *object = (struct netr_USER_KEY_UNION *)py_talloc_get_ptr(obj);
	PyObject *py_keys2;
	py_keys2 = py_talloc_import_ex(&netr_USER_KEYS2_Type, py_talloc_get_mem_ctx(obj), &object->keys2);
	return py_keys2;
}

static int py_netr_USER_KEY_UNION_set_keys2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY_UNION *object = (struct netr_USER_KEY_UNION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEYS2_Type, value, return -1;);
	memcpy(&object->keys2, py_talloc_get_ptr(value), sizeof(object->keys2));
	return 0;
}

static PyGetSetDef py_netr_USER_KEY_UNION_getsetters[] = {
	{ discard_const_p(char, "keys2"), py_netr_USER_KEY_UNION_get_keys2, py_netr_USER_KEY_UNION_set_keys2 },
	{ NULL }
};

static PyObject *py_netr_USER_KEY_UNION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_USER_KEY_UNION, type);
}


static PyTypeObject netr_USER_KEY_UNION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEY_UNION",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_USER_KEY_UNION_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEY_UNION_new,
};


static PyObject *py_netr_USER_KEYS_get_version(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_netr_USER_KEYS_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEYS_get_keys(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)py_talloc_get_ptr(obj);
	PyObject *py_keys;
	py_keys = py_talloc_import_ex(&netr_USER_KEY_UNION_Type, py_talloc_get_mem_ctx(obj), &object->keys);
	return py_keys;
}

static int py_netr_USER_KEYS_set_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEY_UNION_Type, value, return -1;);
	memcpy(&object->keys, py_talloc_get_ptr(value), sizeof(object->keys));
	return 0;
}

static PyGetSetDef py_netr_USER_KEYS_getsetters[] = {
	{ discard_const_p(char, "version"), py_netr_USER_KEYS_get_version, py_netr_USER_KEYS_set_version },
	{ discard_const_p(char, "keys"), py_netr_USER_KEYS_get_keys, py_netr_USER_KEYS_set_keys },
	{ NULL }
};

static PyObject *py_netr_USER_KEYS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_USER_KEYS, type);
}

static PyObject *py_netr_USER_KEYS_ndr_pack(PyObject *py_obj)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_USER_KEYS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_USER_KEYS_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_USER_KEYS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_USER_KEYS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_USER_KEYS_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_USER_KEYS_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_USER_KEYS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEYS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_USER_KEYS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_USER_KEYS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_KEYS_new,
};


static PyObject *py_netr_USER_PRIVATE_INFO_get_SensitiveDataFlag(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)py_talloc_get_ptr(obj);
	PyObject *py_SensitiveDataFlag;
	py_SensitiveDataFlag = PyInt_FromLong(object->SensitiveDataFlag);
	return py_SensitiveDataFlag;
}

static int py_netr_USER_PRIVATE_INFO_set_SensitiveDataFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SensitiveDataFlag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_PRIVATE_INFO_get_DataLength(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)py_talloc_get_ptr(obj);
	PyObject *py_DataLength;
	py_DataLength = PyInt_FromLong(object->DataLength);
	return py_DataLength;
}

static int py_netr_USER_PRIVATE_INFO_set_DataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DataLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_PRIVATE_INFO_get_SensitiveData(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)py_talloc_get_ptr(obj);
	PyObject *py_SensitiveData;
	if (object->SensitiveData == NULL) {
		py_SensitiveData = Py_None;
	} else {
		py_SensitiveData = PyList_New(object->DataLength);
		if (py_SensitiveData == NULL) {
			return NULL;
		}
		{
			int SensitiveData_cntr_1;
			for (SensitiveData_cntr_1 = 0; SensitiveData_cntr_1 < object->DataLength; SensitiveData_cntr_1++) {
				PyObject *py_SensitiveData_1;
				py_SensitiveData_1 = PyInt_FromLong(object->SensitiveData[SensitiveData_cntr_1]);
				PyList_SetItem(py_SensitiveData, SensitiveData_cntr_1, py_SensitiveData_1);
			}
		}
	}
	return py_SensitiveData;
}

static int py_netr_USER_PRIVATE_INFO_set_SensitiveData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)py_talloc_get_ptr(py_obj);
	talloc_free(object->SensitiveData);
	if (value == Py_None) {
		object->SensitiveData = NULL;
	} else {
		object->SensitiveData = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->SensitiveData);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int SensitiveData_cntr_1;
			object->SensitiveData = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->SensitiveData, PyList_Size(value));
			for (SensitiveData_cntr_1 = 0; SensitiveData_cntr_1 < PyList_Size(value); SensitiveData_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, SensitiveData_cntr_1), return -1;);
				object->SensitiveData[SensitiveData_cntr_1] = PyInt_AsLong(PyList_GetItem(value, SensitiveData_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_USER_PRIVATE_INFO_getsetters[] = {
	{ discard_const_p(char, "SensitiveDataFlag"), py_netr_USER_PRIVATE_INFO_get_SensitiveDataFlag, py_netr_USER_PRIVATE_INFO_set_SensitiveDataFlag },
	{ discard_const_p(char, "DataLength"), py_netr_USER_PRIVATE_INFO_get_DataLength, py_netr_USER_PRIVATE_INFO_set_DataLength },
	{ discard_const_p(char, "SensitiveData"), py_netr_USER_PRIVATE_INFO_get_SensitiveData, py_netr_USER_PRIVATE_INFO_set_SensitiveData },
	{ NULL }
};

static PyObject *py_netr_USER_PRIVATE_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_USER_PRIVATE_INFO, type);
}


static PyTypeObject netr_USER_PRIVATE_INFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_PRIVATE_INFO",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_USER_PRIVATE_INFO_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_USER_PRIVATE_INFO_new,
};


static PyObject *py_netr_DELTA_USER_get_account_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_DELTA_USER_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->account_name, py_talloc_get_ptr(value), sizeof(object->account_name));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_full_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_netr_DELTA_USER_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->full_name, py_talloc_get_ptr(value), sizeof(object->full_name));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_DELTA_USER_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_primary_gid(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyInt_FromLong(object->primary_gid);
	return py_primary_gid;
}

static int py_netr_DELTA_USER_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->primary_gid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_home_directory(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_netr_DELTA_USER_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->home_directory, py_talloc_get_ptr(value), sizeof(object->home_directory));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_home_drive(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_netr_DELTA_USER_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->home_drive, py_talloc_get_ptr(value), sizeof(object->home_drive));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_script(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_netr_DELTA_USER_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->logon_script, py_talloc_get_ptr(value), sizeof(object->logon_script));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_description;
	py_description = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_USER_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->description, py_talloc_get_ptr(value), sizeof(object->description));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_workstations(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_netr_DELTA_USER_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->workstations, py_talloc_get_ptr(value), sizeof(object->workstations));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyInt_FromLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_DELTA_USER_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logon = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyInt_FromLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_DELTA_USER_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logoff = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_hours(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = py_talloc_import_ex(samr_LogonHours_Type, py_talloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_netr_DELTA_USER_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_LogonHours_Type, value, return -1;);
	memcpy(&object->logon_hours, py_talloc_get_ptr(value), sizeof(object->logon_hours));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_bad_password_count(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyInt_FromLong(object->bad_password_count);
	return py_bad_password_count;
}

static int py_netr_DELTA_USER_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_password_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_DELTA_USER_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_password_change(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyInt_FromLong(object->last_password_change);
	return py_last_password_change;
}

static int py_netr_DELTA_USER_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_password_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_acct_expiry(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyInt_FromLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_netr_DELTA_USER_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->acct_expiry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_acct_flags(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyInt_FromLong(object->acct_flags);
	return py_acct_flags;
}

static int py_netr_DELTA_USER_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->acct_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = py_talloc_import_ex(samr_Password_Type, py_talloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_DELTA_USER_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	memcpy(&object->lmpassword, py_talloc_get_ptr(value), sizeof(object->lmpassword));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = py_talloc_import_ex(samr_Password_Type, py_talloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_DELTA_USER_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	memcpy(&object->ntpassword, py_talloc_get_ptr(value), sizeof(object->ntpassword));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_nt_password_present(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_nt_password_present;
	py_nt_password_present = PyInt_FromLong(object->nt_password_present);
	return py_nt_password_present;
}

static int py_netr_DELTA_USER_set_nt_password_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_password_present = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_lm_password_present(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_lm_password_present;
	py_lm_password_present = PyInt_FromLong(object->lm_password_present);
	return py_lm_password_present;
}

static int py_netr_DELTA_USER_set_lm_password_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_password_present = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_password_expired(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyInt_FromLong(object->password_expired);
	return py_password_expired;
}

static int py_netr_DELTA_USER_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->password_expired = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_comment(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_comment;
	py_comment = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->comment);
	return py_comment;
}

static int py_netr_DELTA_USER_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->comment, py_talloc_get_ptr(value), sizeof(object->comment));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_parameters(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_parameters;
	py_parameters = py_talloc_import_ex(lsa_BinaryString_Type, py_talloc_get_mem_ctx(obj), &object->parameters);
	return py_parameters;
}

static int py_netr_DELTA_USER_set_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	memcpy(&object->parameters, py_talloc_get_ptr(value), sizeof(object->parameters));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_country_code(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_country_code;
	py_country_code = PyInt_FromLong(object->country_code);
	return py_country_code;
}

static int py_netr_DELTA_USER_set_country_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->country_code = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_code_page(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_code_page;
	py_code_page = PyInt_FromLong(object->code_page);
	return py_code_page;
}

static int py_netr_DELTA_USER_set_code_page(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->code_page = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_user_private_info(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_user_private_info;
	py_user_private_info = py_talloc_import_ex(&netr_USER_PRIVATE_INFO_Type, py_talloc_get_mem_ctx(obj), &object->user_private_info);
	return py_user_private_info;
}

static int py_netr_DELTA_USER_set_user_private_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_PRIVATE_INFO_Type, value, return -1;);
	memcpy(&object->user_private_info, py_talloc_get_ptr(value), sizeof(object->user_private_info));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_USER_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_USER_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_profile_path(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_netr_DELTA_USER_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->profile_path, py_talloc_get_ptr(value), sizeof(object->profile_path));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_USER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_USER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_USER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_USER_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_USER_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_USER_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_USER_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_USER_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_netr_DELTA_USER_get_account_name, py_netr_DELTA_USER_set_account_name },
	{ discard_const_p(char, "full_name"), py_netr_DELTA_USER_get_full_name, py_netr_DELTA_USER_set_full_name },
	{ discard_const_p(char, "rid"), py_netr_DELTA_USER_get_rid, py_netr_DELTA_USER_set_rid },
	{ discard_const_p(char, "primary_gid"), py_netr_DELTA_USER_get_primary_gid, py_netr_DELTA_USER_set_primary_gid },
	{ discard_const_p(char, "home_directory"), py_netr_DELTA_USER_get_home_directory, py_netr_DELTA_USER_set_home_directory },
	{ discard_const_p(char, "home_drive"), py_netr_DELTA_USER_get_home_drive, py_netr_DELTA_USER_set_home_drive },
	{ discard_const_p(char, "logon_script"), py_netr_DELTA_USER_get_logon_script, py_netr_DELTA_USER_set_logon_script },
	{ discard_const_p(char, "description"), py_netr_DELTA_USER_get_description, py_netr_DELTA_USER_set_description },
	{ discard_const_p(char, "workstations"), py_netr_DELTA_USER_get_workstations, py_netr_DELTA_USER_set_workstations },
	{ discard_const_p(char, "last_logon"), py_netr_DELTA_USER_get_last_logon, py_netr_DELTA_USER_set_last_logon },
	{ discard_const_p(char, "last_logoff"), py_netr_DELTA_USER_get_last_logoff, py_netr_DELTA_USER_set_last_logoff },
	{ discard_const_p(char, "logon_hours"), py_netr_DELTA_USER_get_logon_hours, py_netr_DELTA_USER_set_logon_hours },
	{ discard_const_p(char, "bad_password_count"), py_netr_DELTA_USER_get_bad_password_count, py_netr_DELTA_USER_set_bad_password_count },
	{ discard_const_p(char, "logon_count"), py_netr_DELTA_USER_get_logon_count, py_netr_DELTA_USER_set_logon_count },
	{ discard_const_p(char, "last_password_change"), py_netr_DELTA_USER_get_last_password_change, py_netr_DELTA_USER_set_last_password_change },
	{ discard_const_p(char, "acct_expiry"), py_netr_DELTA_USER_get_acct_expiry, py_netr_DELTA_USER_set_acct_expiry },
	{ discard_const_p(char, "acct_flags"), py_netr_DELTA_USER_get_acct_flags, py_netr_DELTA_USER_set_acct_flags },
	{ discard_const_p(char, "lmpassword"), py_netr_DELTA_USER_get_lmpassword, py_netr_DELTA_USER_set_lmpassword },
	{ discard_const_p(char, "ntpassword"), py_netr_DELTA_USER_get_ntpassword, py_netr_DELTA_USER_set_ntpassword },
	{ discard_const_p(char, "nt_password_present"), py_netr_DELTA_USER_get_nt_password_present, py_netr_DELTA_USER_set_nt_password_present },
	{ discard_const_p(char, "lm_password_present"), py_netr_DELTA_USER_get_lm_password_present, py_netr_DELTA_USER_set_lm_password_present },
	{ discard_const_p(char, "password_expired"), py_netr_DELTA_USER_get_password_expired, py_netr_DELTA_USER_set_password_expired },
	{ discard_const_p(char, "comment"), py_netr_DELTA_USER_get_comment, py_netr_DELTA_USER_set_comment },
	{ discard_const_p(char, "parameters"), py_netr_DELTA_USER_get_parameters, py_netr_DELTA_USER_set_parameters },
	{ discard_const_p(char, "country_code"), py_netr_DELTA_USER_get_country_code, py_netr_DELTA_USER_set_country_code },
	{ discard_const_p(char, "code_page"), py_netr_DELTA_USER_get_code_page, py_netr_DELTA_USER_set_code_page },
	{ discard_const_p(char, "user_private_info"), py_netr_DELTA_USER_get_user_private_info, py_netr_DELTA_USER_set_user_private_info },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_USER_get_SecurityInformation, py_netr_DELTA_USER_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_USER_get_sdbuf, py_netr_DELTA_USER_set_sdbuf },
	{ discard_const_p(char, "profile_path"), py_netr_DELTA_USER_get_profile_path, py_netr_DELTA_USER_set_profile_path },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_USER_get_unknown2, py_netr_DELTA_USER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_USER_get_unknown3, py_netr_DELTA_USER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_USER_get_unknown4, py_netr_DELTA_USER_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_USER_get_unknown5, py_netr_DELTA_USER_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_USER_get_unknown6, py_netr_DELTA_USER_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_USER_get_unknown7, py_netr_DELTA_USER_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_USER_get_unknown8, py_netr_DELTA_USER_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_USER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_USER, type);
}


static PyTypeObject netr_DELTA_USER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_USER",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_USER_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_USER_new,
};


static PyObject *py_netr_DELTA_DOMAIN_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_DELTA_DOMAIN_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->domain_name, py_talloc_get_ptr(value), sizeof(object->domain_name));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_oem_information(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_oem_information;
	py_oem_information = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->oem_information);
	return py_oem_information;
}

static int py_netr_DELTA_DOMAIN_set_oem_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->oem_information, py_talloc_get_ptr(value), sizeof(object->oem_information));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_force_logoff_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_force_logoff_time;
	py_force_logoff_time = PyInt_FromLong(object->force_logoff_time);
	return py_force_logoff_time;
}

static int py_netr_DELTA_DOMAIN_set_force_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->force_logoff_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_min_password_length(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_min_password_length;
	py_min_password_length = PyInt_FromLong(object->min_password_length);
	return py_min_password_length;
}

static int py_netr_DELTA_DOMAIN_set_min_password_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->min_password_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_password_history_length(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_password_history_length;
	py_password_history_length = PyInt_FromLong(object->password_history_length);
	return py_password_history_length;
}

static int py_netr_DELTA_DOMAIN_set_password_history_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->password_history_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_max_password_age(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_max_password_age;
	py_max_password_age = PyInt_FromLong(object->max_password_age);
	return py_max_password_age;
}

static int py_netr_DELTA_DOMAIN_set_max_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_password_age = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_min_password_age(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_min_password_age;
	py_min_password_age = PyInt_FromLong(object->min_password_age);
	return py_min_password_age;
}

static int py_netr_DELTA_DOMAIN_set_min_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->min_password_age = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_sequence_num(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyInt_FromLong(object->sequence_num);
	return py_sequence_num;
}

static int py_netr_DELTA_DOMAIN_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sequence_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_domain_create_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_domain_create_time;
	py_domain_create_time = PyInt_FromLong(object->domain_create_time);
	return py_domain_create_time;
}

static int py_netr_DELTA_DOMAIN_set_domain_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->domain_create_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_DOMAIN_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_DOMAIN_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_account_lockout(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_account_lockout;
	py_account_lockout = py_talloc_import_ex(lsa_BinaryString_Type, py_talloc_get_mem_ctx(obj), &object->account_lockout);
	return py_account_lockout;
}

static int py_netr_DELTA_DOMAIN_set_account_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	memcpy(&object->account_lockout, py_talloc_get_ptr(value), sizeof(object->account_lockout));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_DOMAIN_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_DOMAIN_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_DOMAIN_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_logon_to_chgpass(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_logon_to_chgpass;
	py_logon_to_chgpass = PyInt_FromLong(object->logon_to_chgpass);
	return py_logon_to_chgpass;
}

static int py_netr_DELTA_DOMAIN_set_logon_to_chgpass(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_to_chgpass = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_DOMAIN_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_DOMAIN_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_DOMAIN_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DOMAIN_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_netr_DELTA_DOMAIN_get_domain_name, py_netr_DELTA_DOMAIN_set_domain_name },
	{ discard_const_p(char, "oem_information"), py_netr_DELTA_DOMAIN_get_oem_information, py_netr_DELTA_DOMAIN_set_oem_information },
	{ discard_const_p(char, "force_logoff_time"), py_netr_DELTA_DOMAIN_get_force_logoff_time, py_netr_DELTA_DOMAIN_set_force_logoff_time },
	{ discard_const_p(char, "min_password_length"), py_netr_DELTA_DOMAIN_get_min_password_length, py_netr_DELTA_DOMAIN_set_min_password_length },
	{ discard_const_p(char, "password_history_length"), py_netr_DELTA_DOMAIN_get_password_history_length, py_netr_DELTA_DOMAIN_set_password_history_length },
	{ discard_const_p(char, "max_password_age"), py_netr_DELTA_DOMAIN_get_max_password_age, py_netr_DELTA_DOMAIN_set_max_password_age },
	{ discard_const_p(char, "min_password_age"), py_netr_DELTA_DOMAIN_get_min_password_age, py_netr_DELTA_DOMAIN_set_min_password_age },
	{ discard_const_p(char, "sequence_num"), py_netr_DELTA_DOMAIN_get_sequence_num, py_netr_DELTA_DOMAIN_set_sequence_num },
	{ discard_const_p(char, "domain_create_time"), py_netr_DELTA_DOMAIN_get_domain_create_time, py_netr_DELTA_DOMAIN_set_domain_create_time },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_DOMAIN_get_SecurityInformation, py_netr_DELTA_DOMAIN_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_DOMAIN_get_sdbuf, py_netr_DELTA_DOMAIN_set_sdbuf },
	{ discard_const_p(char, "account_lockout"), py_netr_DELTA_DOMAIN_get_account_lockout, py_netr_DELTA_DOMAIN_set_account_lockout },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_DOMAIN_get_unknown2, py_netr_DELTA_DOMAIN_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_DOMAIN_get_unknown3, py_netr_DELTA_DOMAIN_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_DOMAIN_get_unknown4, py_netr_DELTA_DOMAIN_set_unknown4 },
	{ discard_const_p(char, "logon_to_chgpass"), py_netr_DELTA_DOMAIN_get_logon_to_chgpass, py_netr_DELTA_DOMAIN_set_logon_to_chgpass },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_DOMAIN_get_unknown6, py_netr_DELTA_DOMAIN_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_DOMAIN_get_unknown7, py_netr_DELTA_DOMAIN_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_DOMAIN_get_unknown8, py_netr_DELTA_DOMAIN_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_DOMAIN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_DOMAIN, type);
}


static PyTypeObject netr_DELTA_DOMAIN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DOMAIN",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_DOMAIN_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DOMAIN_new,
};


static PyObject *py_netr_DELTA_GROUP_get_group_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_group_name;
	py_group_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->group_name);
	return py_group_name;
}

static int py_netr_DELTA_GROUP_set_group_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->group_name, py_talloc_get_ptr(value), sizeof(object->group_name));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_DELTA_GROUP_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_attributes(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyInt_FromLong(object->attributes);
	return py_attributes;
}

static int py_netr_DELTA_GROUP_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->attributes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_description;
	py_description = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_GROUP_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->description, py_talloc_get_ptr(value), sizeof(object->description));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_GROUP_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_GROUP_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_GROUP_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_GROUP_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_GROUP_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_GROUP_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_GROUP_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_GROUP_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_GROUP_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_GROUP_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_GROUP_getsetters[] = {
	{ discard_const_p(char, "group_name"), py_netr_DELTA_GROUP_get_group_name, py_netr_DELTA_GROUP_set_group_name },
	{ discard_const_p(char, "rid"), py_netr_DELTA_GROUP_get_rid, py_netr_DELTA_GROUP_set_rid },
	{ discard_const_p(char, "attributes"), py_netr_DELTA_GROUP_get_attributes, py_netr_DELTA_GROUP_set_attributes },
	{ discard_const_p(char, "description"), py_netr_DELTA_GROUP_get_description, py_netr_DELTA_GROUP_set_description },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_GROUP_get_SecurityInformation, py_netr_DELTA_GROUP_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_GROUP_get_sdbuf, py_netr_DELTA_GROUP_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_GROUP_get_unknown1, py_netr_DELTA_GROUP_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_GROUP_get_unknown2, py_netr_DELTA_GROUP_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_GROUP_get_unknown3, py_netr_DELTA_GROUP_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_GROUP_get_unknown4, py_netr_DELTA_GROUP_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_GROUP_get_unknown5, py_netr_DELTA_GROUP_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_GROUP_get_unknown6, py_netr_DELTA_GROUP_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_GROUP_get_unknown7, py_netr_DELTA_GROUP_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_GROUP_get_unknown8, py_netr_DELTA_GROUP_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_GROUP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_GROUP, type);
}


static PyTypeObject netr_DELTA_GROUP_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_GROUP",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_GROUP_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_GROUP_new,
};


static PyObject *py_netr_DELTA_RENAME_get_OldName(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_OldName;
	py_OldName = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->OldName);
	return py_OldName;
}

static int py_netr_DELTA_RENAME_set_OldName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->OldName, py_talloc_get_ptr(value), sizeof(object->OldName));
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_NewName(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_NewName;
	py_NewName = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->NewName);
	return py_NewName;
}

static int py_netr_DELTA_RENAME_set_NewName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->NewName, py_talloc_get_ptr(value), sizeof(object->NewName));
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_RENAME_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_RENAME_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_RENAME_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_RENAME_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_RENAME_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_RENAME_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_RENAME_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_RENAME_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_RENAME_getsetters[] = {
	{ discard_const_p(char, "OldName"), py_netr_DELTA_RENAME_get_OldName, py_netr_DELTA_RENAME_set_OldName },
	{ discard_const_p(char, "NewName"), py_netr_DELTA_RENAME_get_NewName, py_netr_DELTA_RENAME_set_NewName },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_RENAME_get_unknown1, py_netr_DELTA_RENAME_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_RENAME_get_unknown2, py_netr_DELTA_RENAME_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_RENAME_get_unknown3, py_netr_DELTA_RENAME_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_RENAME_get_unknown4, py_netr_DELTA_RENAME_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_RENAME_get_unknown5, py_netr_DELTA_RENAME_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_RENAME_get_unknown6, py_netr_DELTA_RENAME_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_RENAME_get_unknown7, py_netr_DELTA_RENAME_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_RENAME_get_unknown8, py_netr_DELTA_RENAME_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_RENAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_RENAME, type);
}


static PyTypeObject netr_DELTA_RENAME_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_RENAME",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_RENAME_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_RENAME_new,
};


static PyObject *py_netr_DELTA_GROUP_MEMBER_get_rids(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->rids == NULL) {
		py_rids = Py_None;
	} else {
		py_rids = PyList_New(object->num_rids);
		if (py_rids == NULL) {
			return NULL;
		}
		{
			int rids_cntr_1;
			for (rids_cntr_1 = 0; rids_cntr_1 < object->num_rids; rids_cntr_1++) {
				PyObject *py_rids_1;
				py_rids_1 = PyInt_FromLong(object->rids[rids_cntr_1]);
				PyList_SetItem(py_rids, rids_cntr_1, py_rids_1);
			}
		}
	}
	return py_rids;
}

static int py_netr_DELTA_GROUP_MEMBER_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	talloc_free(object->rids);
	if (value == Py_None) {
		object->rids = NULL;
	} else {
		object->rids = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->rids);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int rids_cntr_1;
			object->rids = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->rids, PyList_Size(value));
			for (rids_cntr_1 = 0; rids_cntr_1 < PyList_Size(value); rids_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, rids_cntr_1), return -1;);
				object->rids[rids_cntr_1] = PyInt_AsLong(PyList_GetItem(value, rids_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_attribs(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_attribs;
	if (object->attribs == NULL) {
		py_attribs = Py_None;
	} else {
		py_attribs = PyList_New(object->num_rids);
		if (py_attribs == NULL) {
			return NULL;
		}
		{
			int attribs_cntr_1;
			for (attribs_cntr_1 = 0; attribs_cntr_1 < object->num_rids; attribs_cntr_1++) {
				PyObject *py_attribs_1;
				py_attribs_1 = PyInt_FromLong(object->attribs[attribs_cntr_1]);
				PyList_SetItem(py_attribs, attribs_cntr_1, py_attribs_1);
			}
		}
	}
	return py_attribs;
}

static int py_netr_DELTA_GROUP_MEMBER_set_attribs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	talloc_free(object->attribs);
	if (value == Py_None) {
		object->attribs = NULL;
	} else {
		object->attribs = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->attribs);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int attribs_cntr_1;
			object->attribs = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->attribs, PyList_Size(value));
			for (attribs_cntr_1 = 0; attribs_cntr_1 < PyList_Size(value); attribs_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, attribs_cntr_1), return -1;);
				object->attribs[attribs_cntr_1] = PyInt_AsLong(PyList_GetItem(value, attribs_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_num_rids(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_num_rids;
	py_num_rids = PyInt_FromLong(object->num_rids);
	return py_num_rids;
}

static int py_netr_DELTA_GROUP_MEMBER_set_num_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_rids = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_GROUP_MEMBER_getsetters[] = {
	{ discard_const_p(char, "rids"), py_netr_DELTA_GROUP_MEMBER_get_rids, py_netr_DELTA_GROUP_MEMBER_set_rids },
	{ discard_const_p(char, "attribs"), py_netr_DELTA_GROUP_MEMBER_get_attribs, py_netr_DELTA_GROUP_MEMBER_set_attribs },
	{ discard_const_p(char, "num_rids"), py_netr_DELTA_GROUP_MEMBER_get_num_rids, py_netr_DELTA_GROUP_MEMBER_set_num_rids },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_GROUP_MEMBER_get_unknown1, py_netr_DELTA_GROUP_MEMBER_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_GROUP_MEMBER_get_unknown2, py_netr_DELTA_GROUP_MEMBER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_GROUP_MEMBER_get_unknown3, py_netr_DELTA_GROUP_MEMBER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_GROUP_MEMBER_get_unknown4, py_netr_DELTA_GROUP_MEMBER_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_DELTA_GROUP_MEMBER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_GROUP_MEMBER, type);
}


static PyTypeObject netr_DELTA_GROUP_MEMBER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_GROUP_MEMBER",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_GROUP_MEMBER_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_GROUP_MEMBER_new,
};


static PyObject *py_netr_DELTA_ALIAS_get_alias_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_alias_name;
	py_alias_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->alias_name);
	return py_alias_name;
}

static int py_netr_DELTA_ALIAS_set_alias_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->alias_name, py_talloc_get_ptr(value), sizeof(object->alias_name));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_DELTA_ALIAS_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_ALIAS_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_ALIAS_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_description;
	py_description = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_ALIAS_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->description, py_talloc_get_ptr(value), sizeof(object->description));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ALIAS_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ALIAS_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ALIAS_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_ALIAS_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_ALIAS_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_ALIAS_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_ALIAS_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_ALIAS_getsetters[] = {
	{ discard_const_p(char, "alias_name"), py_netr_DELTA_ALIAS_get_alias_name, py_netr_DELTA_ALIAS_set_alias_name },
	{ discard_const_p(char, "rid"), py_netr_DELTA_ALIAS_get_rid, py_netr_DELTA_ALIAS_set_rid },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_ALIAS_get_SecurityInformation, py_netr_DELTA_ALIAS_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_ALIAS_get_sdbuf, py_netr_DELTA_ALIAS_set_sdbuf },
	{ discard_const_p(char, "description"), py_netr_DELTA_ALIAS_get_description, py_netr_DELTA_ALIAS_set_description },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_ALIAS_get_unknown2, py_netr_DELTA_ALIAS_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_ALIAS_get_unknown3, py_netr_DELTA_ALIAS_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_ALIAS_get_unknown4, py_netr_DELTA_ALIAS_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_ALIAS_get_unknown5, py_netr_DELTA_ALIAS_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_ALIAS_get_unknown6, py_netr_DELTA_ALIAS_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_ALIAS_get_unknown7, py_netr_DELTA_ALIAS_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_ALIAS_get_unknown8, py_netr_DELTA_ALIAS_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_ALIAS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_ALIAS, type);
}


static PyTypeObject netr_DELTA_ALIAS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ALIAS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_ALIAS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ALIAS_new,
};


static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_sids(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = py_talloc_import_ex(lsa_SidArray_Type, py_talloc_get_mem_ctx(obj), &object->sids);
	return py_sids;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_SidArray_Type, value, return -1;);
	memcpy(&object->sids, py_talloc_get_ptr(value), sizeof(object->sids));
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_ALIAS_MEMBER_getsetters[] = {
	{ discard_const_p(char, "sids"), py_netr_DELTA_ALIAS_MEMBER_get_sids, py_netr_DELTA_ALIAS_MEMBER_set_sids },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_ALIAS_MEMBER_get_unknown1, py_netr_DELTA_ALIAS_MEMBER_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_ALIAS_MEMBER_get_unknown2, py_netr_DELTA_ALIAS_MEMBER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_ALIAS_MEMBER_get_unknown3, py_netr_DELTA_ALIAS_MEMBER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_ALIAS_MEMBER_get_unknown4, py_netr_DELTA_ALIAS_MEMBER_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_DELTA_ALIAS_MEMBER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_ALIAS_MEMBER, type);
}


static PyTypeObject netr_DELTA_ALIAS_MEMBER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ALIAS_MEMBER",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_ALIAS_MEMBER_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ALIAS_MEMBER_new,
};


static PyObject *py_netr_QUOTA_LIMITS_get_pagedpoollimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(obj);
	PyObject *py_pagedpoollimit;
	py_pagedpoollimit = PyInt_FromLong(object->pagedpoollimit);
	return py_pagedpoollimit;
}

static int py_netr_QUOTA_LIMITS_set_pagedpoollimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pagedpoollimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_nonpagedpoollimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(obj);
	PyObject *py_nonpagedpoollimit;
	py_nonpagedpoollimit = PyInt_FromLong(object->nonpagedpoollimit);
	return py_nonpagedpoollimit;
}

static int py_netr_QUOTA_LIMITS_set_nonpagedpoollimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nonpagedpoollimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_minimumworkingsetsize(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(obj);
	PyObject *py_minimumworkingsetsize;
	py_minimumworkingsetsize = PyInt_FromLong(object->minimumworkingsetsize);
	return py_minimumworkingsetsize;
}

static int py_netr_QUOTA_LIMITS_set_minimumworkingsetsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->minimumworkingsetsize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_maximumworkingsetsize(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(obj);
	PyObject *py_maximumworkingsetsize;
	py_maximumworkingsetsize = PyInt_FromLong(object->maximumworkingsetsize);
	return py_maximumworkingsetsize;
}

static int py_netr_QUOTA_LIMITS_set_maximumworkingsetsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maximumworkingsetsize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_pagefilelimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(obj);
	PyObject *py_pagefilelimit;
	py_pagefilelimit = PyInt_FromLong(object->pagefilelimit);
	return py_pagefilelimit;
}

static int py_netr_QUOTA_LIMITS_set_pagefilelimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pagefilelimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_timelimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(obj);
	PyObject *py_timelimit;
	py_timelimit = PyInt_FromLong(object->timelimit);
	return py_timelimit;
}

static int py_netr_QUOTA_LIMITS_set_timelimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timelimit = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_QUOTA_LIMITS_getsetters[] = {
	{ discard_const_p(char, "pagedpoollimit"), py_netr_QUOTA_LIMITS_get_pagedpoollimit, py_netr_QUOTA_LIMITS_set_pagedpoollimit },
	{ discard_const_p(char, "nonpagedpoollimit"), py_netr_QUOTA_LIMITS_get_nonpagedpoollimit, py_netr_QUOTA_LIMITS_set_nonpagedpoollimit },
	{ discard_const_p(char, "minimumworkingsetsize"), py_netr_QUOTA_LIMITS_get_minimumworkingsetsize, py_netr_QUOTA_LIMITS_set_minimumworkingsetsize },
	{ discard_const_p(char, "maximumworkingsetsize"), py_netr_QUOTA_LIMITS_get_maximumworkingsetsize, py_netr_QUOTA_LIMITS_set_maximumworkingsetsize },
	{ discard_const_p(char, "pagefilelimit"), py_netr_QUOTA_LIMITS_get_pagefilelimit, py_netr_QUOTA_LIMITS_set_pagefilelimit },
	{ discard_const_p(char, "timelimit"), py_netr_QUOTA_LIMITS_get_timelimit, py_netr_QUOTA_LIMITS_set_timelimit },
	{ NULL }
};

static PyObject *py_netr_QUOTA_LIMITS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_QUOTA_LIMITS, type);
}


static PyTypeObject netr_QUOTA_LIMITS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_QUOTA_LIMITS",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_QUOTA_LIMITS_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_QUOTA_LIMITS_new,
};


static PyObject *py_netr_DELTA_POLICY_get_maxlogsize(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_maxlogsize;
	py_maxlogsize = PyInt_FromLong(object->maxlogsize);
	return py_maxlogsize;
}

static int py_netr_DELTA_POLICY_set_maxlogsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maxlogsize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_auditretentionperiod(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_auditretentionperiod;
	py_auditretentionperiod = PyInt_FromLong(object->auditretentionperiod);
	return py_auditretentionperiod;
}

static int py_netr_DELTA_POLICY_set_auditretentionperiod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auditretentionperiod = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_auditingmode(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_auditingmode;
	py_auditingmode = PyInt_FromLong(object->auditingmode);
	return py_auditingmode;
}

static int py_netr_DELTA_POLICY_set_auditingmode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auditingmode = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_maxauditeventcount(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_maxauditeventcount;
	py_maxauditeventcount = PyInt_FromLong(object->maxauditeventcount);
	return py_maxauditeventcount;
}

static int py_netr_DELTA_POLICY_set_maxauditeventcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maxauditeventcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_eventauditoptions(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_eventauditoptions;
	if (object->eventauditoptions == NULL) {
		py_eventauditoptions = Py_None;
	} else {
		py_eventauditoptions = PyList_New(object->maxauditeventcount + 1);
		if (py_eventauditoptions == NULL) {
			return NULL;
		}
		{
			int eventauditoptions_cntr_1;
			for (eventauditoptions_cntr_1 = 0; eventauditoptions_cntr_1 < object->maxauditeventcount + 1; eventauditoptions_cntr_1++) {
				PyObject *py_eventauditoptions_1;
				py_eventauditoptions_1 = PyInt_FromLong(object->eventauditoptions[eventauditoptions_cntr_1]);
				PyList_SetItem(py_eventauditoptions, eventauditoptions_cntr_1, py_eventauditoptions_1);
			}
		}
	}
	return py_eventauditoptions;
}

static int py_netr_DELTA_POLICY_set_eventauditoptions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	talloc_free(object->eventauditoptions);
	if (value == Py_None) {
		object->eventauditoptions = NULL;
	} else {
		object->eventauditoptions = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->eventauditoptions);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int eventauditoptions_cntr_1;
			object->eventauditoptions = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->eventauditoptions, PyList_Size(value));
			for (eventauditoptions_cntr_1 = 0; eventauditoptions_cntr_1 < PyList_Size(value); eventauditoptions_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, eventauditoptions_cntr_1), return -1;);
				object->eventauditoptions[eventauditoptions_cntr_1] = PyInt_AsLong(PyList_GetItem(value, eventauditoptions_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_primary_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_primary_domain_name;
	py_primary_domain_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->primary_domain_name);
	return py_primary_domain_name;
}

static int py_netr_DELTA_POLICY_set_primary_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->primary_domain_name, py_talloc_get_ptr(value), sizeof(object->primary_domain_name));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sid(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
	} else {
		py_sid = NULL;
	}
	return py_sid;
}

static int py_netr_DELTA_POLICY_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sid);
		object->sid = NULL;
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_quota_limits(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_quota_limits;
	py_quota_limits = py_talloc_import_ex(&netr_QUOTA_LIMITS_Type, py_talloc_get_mem_ctx(obj), &object->quota_limits);
	return py_quota_limits;
}

static int py_netr_DELTA_POLICY_set_quota_limits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_QUOTA_LIMITS_Type, value, return -1;);
	memcpy(&object->quota_limits, py_talloc_get_ptr(value), sizeof(object->quota_limits));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sequence_num(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyInt_FromLong(object->sequence_num);
	return py_sequence_num;
}

static int py_netr_DELTA_POLICY_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sequence_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_db_create_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_db_create_time;
	py_db_create_time = PyInt_FromLong(object->db_create_time);
	return py_db_create_time;
}

static int py_netr_DELTA_POLICY_set_db_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->db_create_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_POLICY_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_POLICY_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_POLICY_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_POLICY_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_POLICY_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_POLICY_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_POLICY_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_POLICY_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_POLICY_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_POLICY_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_POLICY_getsetters[] = {
	{ discard_const_p(char, "maxlogsize"), py_netr_DELTA_POLICY_get_maxlogsize, py_netr_DELTA_POLICY_set_maxlogsize },
	{ discard_const_p(char, "auditretentionperiod"), py_netr_DELTA_POLICY_get_auditretentionperiod, py_netr_DELTA_POLICY_set_auditretentionperiod },
	{ discard_const_p(char, "auditingmode"), py_netr_DELTA_POLICY_get_auditingmode, py_netr_DELTA_POLICY_set_auditingmode },
	{ discard_const_p(char, "maxauditeventcount"), py_netr_DELTA_POLICY_get_maxauditeventcount, py_netr_DELTA_POLICY_set_maxauditeventcount },
	{ discard_const_p(char, "eventauditoptions"), py_netr_DELTA_POLICY_get_eventauditoptions, py_netr_DELTA_POLICY_set_eventauditoptions },
	{ discard_const_p(char, "primary_domain_name"), py_netr_DELTA_POLICY_get_primary_domain_name, py_netr_DELTA_POLICY_set_primary_domain_name },
	{ discard_const_p(char, "sid"), py_netr_DELTA_POLICY_get_sid, py_netr_DELTA_POLICY_set_sid },
	{ discard_const_p(char, "quota_limits"), py_netr_DELTA_POLICY_get_quota_limits, py_netr_DELTA_POLICY_set_quota_limits },
	{ discard_const_p(char, "sequence_num"), py_netr_DELTA_POLICY_get_sequence_num, py_netr_DELTA_POLICY_set_sequence_num },
	{ discard_const_p(char, "db_create_time"), py_netr_DELTA_POLICY_get_db_create_time, py_netr_DELTA_POLICY_set_db_create_time },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_POLICY_get_SecurityInformation, py_netr_DELTA_POLICY_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_POLICY_get_sdbuf, py_netr_DELTA_POLICY_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_POLICY_get_unknown1, py_netr_DELTA_POLICY_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_POLICY_get_unknown2, py_netr_DELTA_POLICY_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_POLICY_get_unknown3, py_netr_DELTA_POLICY_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_POLICY_get_unknown4, py_netr_DELTA_POLICY_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_POLICY_get_unknown5, py_netr_DELTA_POLICY_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_POLICY_get_unknown6, py_netr_DELTA_POLICY_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_POLICY_get_unknown7, py_netr_DELTA_POLICY_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_POLICY_get_unknown8, py_netr_DELTA_POLICY_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_POLICY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_POLICY, type);
}


static PyTypeObject netr_DELTA_POLICY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_POLICY",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_POLICY_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_POLICY_new,
};


static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->domain_name, py_talloc_get_ptr(value), sizeof(object->domain_name));
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_num_controllers(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_num_controllers;
	py_num_controllers = PyInt_FromLong(object->num_controllers);
	return py_num_controllers;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_num_controllers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_controllers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_controller_names(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_controller_names;
	if (object->controller_names == NULL) {
		py_controller_names = Py_None;
	} else {
		py_controller_names = PyList_New(object->num_controllers);
		if (py_controller_names == NULL) {
			return NULL;
		}
		{
			int controller_names_cntr_1;
			for (controller_names_cntr_1 = 0; controller_names_cntr_1 < object->num_controllers; controller_names_cntr_1++) {
				PyObject *py_controller_names_1;
				py_controller_names_1 = py_talloc_import_ex(lsa_String_Type, object->controller_names, &object->controller_names[controller_names_cntr_1]);
				PyList_SetItem(py_controller_names, controller_names_cntr_1, py_controller_names_1);
			}
		}
	}
	return py_controller_names;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_controller_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	talloc_free(object->controller_names);
	if (value == Py_None) {
		object->controller_names = NULL;
	} else {
		object->controller_names = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->controller_names);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int controller_names_cntr_1;
			object->controller_names = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->controller_names, PyList_Size(value));
			for (controller_names_cntr_1 = 0; controller_names_cntr_1 < PyList_Size(value); controller_names_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, controller_names_cntr_1), return -1;);
				memcpy(&object->controller_names[controller_names_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, controller_names_cntr_1)), sizeof(object->controller_names[controller_names_cntr_1]));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_posix_offset(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = PyInt_FromLong(object->posix_offset);
	return py_posix_offset;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->posix_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_TRUSTED_DOMAIN_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_netr_DELTA_TRUSTED_DOMAIN_get_domain_name, py_netr_DELTA_TRUSTED_DOMAIN_set_domain_name },
	{ discard_const_p(char, "num_controllers"), py_netr_DELTA_TRUSTED_DOMAIN_get_num_controllers, py_netr_DELTA_TRUSTED_DOMAIN_set_num_controllers },
	{ discard_const_p(char, "controller_names"), py_netr_DELTA_TRUSTED_DOMAIN_get_controller_names, py_netr_DELTA_TRUSTED_DOMAIN_set_controller_names },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_TRUSTED_DOMAIN_get_SecurityInformation, py_netr_DELTA_TRUSTED_DOMAIN_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_TRUSTED_DOMAIN_get_sdbuf, py_netr_DELTA_TRUSTED_DOMAIN_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown1, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown2, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown3, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown4, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown4 },
	{ discard_const_p(char, "posix_offset"), py_netr_DELTA_TRUSTED_DOMAIN_get_posix_offset, py_netr_DELTA_TRUSTED_DOMAIN_set_posix_offset },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown6, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown7, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown8, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_TRUSTED_DOMAIN, type);
}


static PyTypeObject netr_DELTA_TRUSTED_DOMAIN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_TRUSTED_DOMAIN",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_TRUSTED_DOMAIN_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_TRUSTED_DOMAIN_new,
};


static PyObject *py_netr_DELTA_DELETE_TRUST_get_unknown(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_TRUST *object = (struct netr_DELTA_DELETE_TRUST *)py_talloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_netr_DELTA_DELETE_TRUST_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_TRUST *object = (struct netr_DELTA_DELETE_TRUST *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DELETE_TRUST_getsetters[] = {
	{ discard_const_p(char, "unknown"), py_netr_DELTA_DELETE_TRUST_get_unknown, py_netr_DELTA_DELETE_TRUST_set_unknown },
	{ NULL }
};

static PyObject *py_netr_DELTA_DELETE_TRUST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_DELETE_TRUST, type);
}


static PyTypeObject netr_DELTA_DELETE_TRUST_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DELETE_TRUST",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_DELETE_TRUST_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DELETE_TRUST_new,
};


static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_entries(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_privilege_entries;
	py_privilege_entries = PyInt_FromLong(object->privilege_entries);
	return py_privilege_entries;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->privilege_entries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_control(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_privilege_control;
	py_privilege_control = PyInt_FromLong(object->privilege_control);
	return py_privilege_control;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->privilege_control = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_attrib(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_privilege_attrib;
	if (object->privilege_attrib == NULL) {
		py_privilege_attrib = Py_None;
	} else {
		py_privilege_attrib = PyList_New(object->privilege_entries);
		if (py_privilege_attrib == NULL) {
			return NULL;
		}
		{
			int privilege_attrib_cntr_1;
			for (privilege_attrib_cntr_1 = 0; privilege_attrib_cntr_1 < object->privilege_entries; privilege_attrib_cntr_1++) {
				PyObject *py_privilege_attrib_1;
				py_privilege_attrib_1 = PyInt_FromLong(object->privilege_attrib[privilege_attrib_cntr_1]);
				PyList_SetItem(py_privilege_attrib, privilege_attrib_cntr_1, py_privilege_attrib_1);
			}
		}
	}
	return py_privilege_attrib;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_attrib(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	talloc_free(object->privilege_attrib);
	if (value == Py_None) {
		object->privilege_attrib = NULL;
	} else {
		object->privilege_attrib = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->privilege_attrib);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privilege_attrib_cntr_1;
			object->privilege_attrib = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->privilege_attrib, PyList_Size(value));
			for (privilege_attrib_cntr_1 = 0; privilege_attrib_cntr_1 < PyList_Size(value); privilege_attrib_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, privilege_attrib_cntr_1), return -1;);
				object->privilege_attrib[privilege_attrib_cntr_1] = PyInt_AsLong(PyList_GetItem(value, privilege_attrib_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_privilege_name;
	if (object->privilege_name == NULL) {
		py_privilege_name = Py_None;
	} else {
		py_privilege_name = PyList_New(object->privilege_entries);
		if (py_privilege_name == NULL) {
			return NULL;
		}
		{
			int privilege_name_cntr_1;
			for (privilege_name_cntr_1 = 0; privilege_name_cntr_1 < object->privilege_entries; privilege_name_cntr_1++) {
				PyObject *py_privilege_name_1;
				py_privilege_name_1 = py_talloc_import_ex(lsa_String_Type, object->privilege_name, &object->privilege_name[privilege_name_cntr_1]);
				PyList_SetItem(py_privilege_name, privilege_name_cntr_1, py_privilege_name_1);
			}
		}
	}
	return py_privilege_name;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	talloc_free(object->privilege_name);
	if (value == Py_None) {
		object->privilege_name = NULL;
	} else {
		object->privilege_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->privilege_name);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privilege_name_cntr_1;
			object->privilege_name = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->privilege_name, PyList_Size(value));
			for (privilege_name_cntr_1 = 0; privilege_name_cntr_1 < PyList_Size(value); privilege_name_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, privilege_name_cntr_1), return -1;);
				memcpy(&object->privilege_name[privilege_name_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, privilege_name_cntr_1)), sizeof(object->privilege_name[privilege_name_cntr_1]));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_quotalimits(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_quotalimits;
	py_quotalimits = py_talloc_import_ex(&netr_QUOTA_LIMITS_Type, py_talloc_get_mem_ctx(obj), &object->quotalimits);
	return py_quotalimits;
}

static int py_netr_DELTA_ACCOUNT_set_quotalimits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_QUOTA_LIMITS_Type, value, return -1;);
	memcpy(&object->quotalimits, py_talloc_get_ptr(value), sizeof(object->quotalimits));
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_system_flags(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_system_flags;
	py_system_flags = PyInt_FromLong(object->system_flags);
	return py_system_flags;
}

static int py_netr_DELTA_ACCOUNT_set_system_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->system_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_ACCOUNT_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_ACCOUNT_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_ACCOUNT_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ACCOUNT_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ACCOUNT_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ACCOUNT_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_ACCOUNT_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_ACCOUNT_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_ACCOUNT_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_ACCOUNT_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_ACCOUNT_getsetters[] = {
	{ discard_const_p(char, "privilege_entries"), py_netr_DELTA_ACCOUNT_get_privilege_entries, py_netr_DELTA_ACCOUNT_set_privilege_entries },
	{ discard_const_p(char, "privilege_control"), py_netr_DELTA_ACCOUNT_get_privilege_control, py_netr_DELTA_ACCOUNT_set_privilege_control },
	{ discard_const_p(char, "privilege_attrib"), py_netr_DELTA_ACCOUNT_get_privilege_attrib, py_netr_DELTA_ACCOUNT_set_privilege_attrib },
	{ discard_const_p(char, "privilege_name"), py_netr_DELTA_ACCOUNT_get_privilege_name, py_netr_DELTA_ACCOUNT_set_privilege_name },
	{ discard_const_p(char, "quotalimits"), py_netr_DELTA_ACCOUNT_get_quotalimits, py_netr_DELTA_ACCOUNT_set_quotalimits },
	{ discard_const_p(char, "system_flags"), py_netr_DELTA_ACCOUNT_get_system_flags, py_netr_DELTA_ACCOUNT_set_system_flags },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_ACCOUNT_get_SecurityInformation, py_netr_DELTA_ACCOUNT_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_ACCOUNT_get_sdbuf, py_netr_DELTA_ACCOUNT_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_ACCOUNT_get_unknown1, py_netr_DELTA_ACCOUNT_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_ACCOUNT_get_unknown2, py_netr_DELTA_ACCOUNT_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_ACCOUNT_get_unknown3, py_netr_DELTA_ACCOUNT_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_ACCOUNT_get_unknown4, py_netr_DELTA_ACCOUNT_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_ACCOUNT_get_unknown5, py_netr_DELTA_ACCOUNT_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_ACCOUNT_get_unknown6, py_netr_DELTA_ACCOUNT_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_ACCOUNT_get_unknown7, py_netr_DELTA_ACCOUNT_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_ACCOUNT_get_unknown8, py_netr_DELTA_ACCOUNT_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_ACCOUNT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_ACCOUNT, type);
}


static PyTypeObject netr_DELTA_ACCOUNT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ACCOUNT",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_ACCOUNT_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ACCOUNT_new,
};


static PyObject *py_netr_DELTA_DELETE_ACCOUNT_get_unknown(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_ACCOUNT *object = (struct netr_DELTA_DELETE_ACCOUNT *)py_talloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_netr_DELTA_DELETE_ACCOUNT_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_ACCOUNT *object = (struct netr_DELTA_DELETE_ACCOUNT *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DELETE_ACCOUNT_getsetters[] = {
	{ discard_const_p(char, "unknown"), py_netr_DELTA_DELETE_ACCOUNT_get_unknown, py_netr_DELTA_DELETE_ACCOUNT_set_unknown },
	{ NULL }
};

static PyObject *py_netr_DELTA_DELETE_ACCOUNT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_DELETE_ACCOUNT, type);
}


static PyTypeObject netr_DELTA_DELETE_ACCOUNT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DELETE_ACCOUNT",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_DELETE_ACCOUNT_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DELETE_ACCOUNT_new,
};


static PyObject *py_netr_DELTA_DELETE_SECRET_get_unknown(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_SECRET *object = (struct netr_DELTA_DELETE_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_netr_DELTA_DELETE_SECRET_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_SECRET *object = (struct netr_DELTA_DELETE_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DELETE_SECRET_getsetters[] = {
	{ discard_const_p(char, "unknown"), py_netr_DELTA_DELETE_SECRET_get_unknown, py_netr_DELTA_DELETE_SECRET_set_unknown },
	{ NULL }
};

static PyObject *py_netr_DELTA_DELETE_SECRET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_DELETE_SECRET, type);
}


static PyTypeObject netr_DELTA_DELETE_SECRET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DELETE_SECRET",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_DELETE_SECRET_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_DELETE_SECRET_new,
};


static PyObject *py_netr_CIPHER_VALUE_get_len(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)py_talloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_netr_CIPHER_VALUE_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_CIPHER_VALUE_get_maxlen(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)py_talloc_get_ptr(obj);
	PyObject *py_maxlen;
	py_maxlen = PyInt_FromLong(object->maxlen);
	return py_maxlen;
}

static int py_netr_CIPHER_VALUE_set_maxlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maxlen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_CIPHER_VALUE_get_cipher_data(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)py_talloc_get_ptr(obj);
	PyObject *py_cipher_data;
	if (object->cipher_data == NULL) {
		py_cipher_data = Py_None;
	} else {
		py_cipher_data = PyList_New(object->len);
		if (py_cipher_data == NULL) {
			return NULL;
		}
		{
			int cipher_data_cntr_1;
			for (cipher_data_cntr_1 = 0; cipher_data_cntr_1 < object->len; cipher_data_cntr_1++) {
				PyObject *py_cipher_data_1;
				py_cipher_data_1 = PyInt_FromLong(object->cipher_data[cipher_data_cntr_1]);
				PyList_SetItem(py_cipher_data, cipher_data_cntr_1, py_cipher_data_1);
			}
		}
	}
	return py_cipher_data;
}

static int py_netr_CIPHER_VALUE_set_cipher_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->cipher_data);
	if (value == Py_None) {
		object->cipher_data = NULL;
	} else {
		object->cipher_data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->cipher_data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int cipher_data_cntr_1;
			object->cipher_data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->cipher_data, PyList_Size(value));
			for (cipher_data_cntr_1 = 0; cipher_data_cntr_1 < PyList_Size(value); cipher_data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, cipher_data_cntr_1), return -1;);
				object->cipher_data[cipher_data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, cipher_data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_CIPHER_VALUE_getsetters[] = {
	{ discard_const_p(char, "len"), py_netr_CIPHER_VALUE_get_len, py_netr_CIPHER_VALUE_set_len },
	{ discard_const_p(char, "maxlen"), py_netr_CIPHER_VALUE_get_maxlen, py_netr_CIPHER_VALUE_set_maxlen },
	{ discard_const_p(char, "cipher_data"), py_netr_CIPHER_VALUE_get_cipher_data, py_netr_CIPHER_VALUE_set_cipher_data },
	{ NULL }
};

static PyObject *py_netr_CIPHER_VALUE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_CIPHER_VALUE, type);
}


static PyTypeObject netr_CIPHER_VALUE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_CIPHER_VALUE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_CIPHER_VALUE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_CIPHER_VALUE_new,
};


static PyObject *py_netr_DELTA_SECRET_get_current_cipher(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_current_cipher;
	py_current_cipher = py_talloc_import_ex(&netr_CIPHER_VALUE_Type, py_talloc_get_mem_ctx(obj), &object->current_cipher);
	return py_current_cipher;
}

static int py_netr_DELTA_SECRET_set_current_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_CIPHER_VALUE_Type, value, return -1;);
	memcpy(&object->current_cipher, py_talloc_get_ptr(value), sizeof(object->current_cipher));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_current_cipher_set_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_current_cipher_set_time;
	py_current_cipher_set_time = PyInt_FromLong(object->current_cipher_set_time);
	return py_current_cipher_set_time;
}

static int py_netr_DELTA_SECRET_set_current_cipher_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->current_cipher_set_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_old_cipher(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_old_cipher;
	py_old_cipher = py_talloc_import_ex(&netr_CIPHER_VALUE_Type, py_talloc_get_mem_ctx(obj), &object->old_cipher);
	return py_old_cipher;
}

static int py_netr_DELTA_SECRET_set_old_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_CIPHER_VALUE_Type, value, return -1;);
	memcpy(&object->old_cipher, py_talloc_get_ptr(value), sizeof(object->old_cipher));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_old_cipher_set_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_old_cipher_set_time;
	py_old_cipher_set_time = PyInt_FromLong(object->old_cipher_set_time);
	return py_old_cipher_set_time;
}

static int py_netr_DELTA_SECRET_set_old_cipher_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->old_cipher_set_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_SECRET_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = py_talloc_import_ex(sec_desc_buf_Type, py_talloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_SECRET_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	memcpy(&object->sdbuf, py_talloc_get_ptr(value), sizeof(object->sdbuf));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_SECRET_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown1, py_talloc_get_ptr(value), sizeof(object->unknown1));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_SECRET_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown2, py_talloc_get_ptr(value), sizeof(object->unknown2));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_SECRET_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown3, py_talloc_get_ptr(value), sizeof(object->unknown3));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_SECRET_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown4, py_talloc_get_ptr(value), sizeof(object->unknown4));
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_SECRET_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_SECRET_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_SECRET_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_SECRET_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_SECRET_getsetters[] = {
	{ discard_const_p(char, "current_cipher"), py_netr_DELTA_SECRET_get_current_cipher, py_netr_DELTA_SECRET_set_current_cipher },
	{ discard_const_p(char, "current_cipher_set_time"), py_netr_DELTA_SECRET_get_current_cipher_set_time, py_netr_DELTA_SECRET_set_current_cipher_set_time },
	{ discard_const_p(char, "old_cipher"), py_netr_DELTA_SECRET_get_old_cipher, py_netr_DELTA_SECRET_set_old_cipher },
	{ discard_const_p(char, "old_cipher_set_time"), py_netr_DELTA_SECRET_get_old_cipher_set_time, py_netr_DELTA_SECRET_set_old_cipher_set_time },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_SECRET_get_SecurityInformation, py_netr_DELTA_SECRET_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_SECRET_get_sdbuf, py_netr_DELTA_SECRET_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_SECRET_get_unknown1, py_netr_DELTA_SECRET_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_SECRET_get_unknown2, py_netr_DELTA_SECRET_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_SECRET_get_unknown3, py_netr_DELTA_SECRET_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_SECRET_get_unknown4, py_netr_DELTA_SECRET_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_SECRET_get_unknown5, py_netr_DELTA_SECRET_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_SECRET_get_unknown6, py_netr_DELTA_SECRET_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_SECRET_get_unknown7, py_netr_DELTA_SECRET_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_SECRET_get_unknown8, py_netr_DELTA_SECRET_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_SECRET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_SECRET, type);
}


static PyTypeObject netr_DELTA_SECRET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_SECRET",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_SECRET_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_SECRET_new,
};

PyObject *py_import_netr_DELTA_UNION(TALLOC_CTX *mem_ctx, int level, union netr_DELTA_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in->domain == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_DOMAIN_Type, in->domain, in->domain);
			}
			return ret;

		case NETR_DELTA_GROUP:
			if (in->group == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_GROUP_Type, in->group, in->group);
			}
			return ret;

		case NETR_DELTA_DELETE_GROUP:
			ret = Py_None;
			return ret;

		case NETR_DELTA_RENAME_GROUP:
			if (in->rename_group == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_RENAME_Type, in->rename_group, in->rename_group);
			}
			return ret;

		case NETR_DELTA_USER:
			if (in->user == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_USER_Type, in->user, in->user);
			}
			return ret;

		case NETR_DELTA_DELETE_USER:
			ret = Py_None;
			return ret;

		case NETR_DELTA_RENAME_USER:
			if (in->rename_user == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_RENAME_Type, in->rename_user, in->rename_user);
			}
			return ret;

		case NETR_DELTA_GROUP_MEMBER:
			if (in->group_member == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_GROUP_MEMBER_Type, in->group_member, in->group_member);
			}
			return ret;

		case NETR_DELTA_ALIAS:
			if (in->alias == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_ALIAS_Type, in->alias, in->alias);
			}
			return ret;

		case NETR_DELTA_DELETE_ALIAS:
			ret = Py_None;
			return ret;

		case NETR_DELTA_RENAME_ALIAS:
			if (in->rename_alias == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_RENAME_Type, in->rename_alias, in->rename_alias);
			}
			return ret;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in->alias_member == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_ALIAS_MEMBER_Type, in->alias_member, in->alias_member);
			}
			return ret;

		case NETR_DELTA_POLICY:
			if (in->policy == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_POLICY_Type, in->policy, in->policy);
			}
			return ret;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in->trusted_domain == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_TRUSTED_DOMAIN_Type, in->trusted_domain, in->trusted_domain);
			}
			return ret;

		case NETR_DELTA_DELETE_TRUST:
			ret = py_talloc_import_ex(&netr_DELTA_DELETE_TRUST_Type, mem_ctx, &in->delete_trust);
			return ret;

		case NETR_DELTA_ACCOUNT:
			if (in->account == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_ACCOUNT_Type, in->account, in->account);
			}
			return ret;

		case NETR_DELTA_DELETE_ACCOUNT:
			ret = py_talloc_import_ex(&netr_DELTA_DELETE_ACCOUNT_Type, mem_ctx, &in->delete_account);
			return ret;

		case NETR_DELTA_SECRET:
			if (in->secret == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_SECRET_Type, in->secret, in->secret);
			}
			return ret;

		case NETR_DELTA_DELETE_SECRET:
			ret = py_talloc_import_ex(&netr_DELTA_DELETE_SECRET_Type, mem_ctx, &in->delete_secret);
			return ret;

		case NETR_DELTA_DELETE_GROUP2:
			if (in->delete_group == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_DELETE_USER_Type, in->delete_group, in->delete_group);
			}
			return ret;

		case NETR_DELTA_DELETE_USER2:
			if (in->delete_user == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DELTA_DELETE_USER_Type, in->delete_user, in->delete_user);
			}
			return ret;

		case NETR_DELTA_MODIFY_COUNT:
			if (in->modified_count == NULL) {
				ret = Py_None;
			} else {
				ret = PyInt_FromLong(*in->modified_count);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DELTA_UNION *py_export_netr_DELTA_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DELTA_UNION *ret = talloc_zero(mem_ctx, union netr_DELTA_UNION);
	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = talloc_ptrtype(mem_ctx, ret->domain);
				PY_CHECK_TYPE(&netr_DELTA_DOMAIN_Type, in, talloc_free(ret); return NULL;);
				ret->domain = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_GROUP:
			if (in == Py_None) {
				ret->group = NULL;
			} else {
				ret->group = talloc_ptrtype(mem_ctx, ret->group);
				PY_CHECK_TYPE(&netr_DELTA_GROUP_Type, in, talloc_free(ret); return NULL;);
				ret->group = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_GROUP:
			break;

		case NETR_DELTA_RENAME_GROUP:
			if (in == Py_None) {
				ret->rename_group = NULL;
			} else {
				ret->rename_group = talloc_ptrtype(mem_ctx, ret->rename_group);
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				ret->rename_group = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_USER:
			if (in == Py_None) {
				ret->user = NULL;
			} else {
				ret->user = talloc_ptrtype(mem_ctx, ret->user);
				PY_CHECK_TYPE(&netr_DELTA_USER_Type, in, talloc_free(ret); return NULL;);
				ret->user = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_USER:
			break;

		case NETR_DELTA_RENAME_USER:
			if (in == Py_None) {
				ret->rename_user = NULL;
			} else {
				ret->rename_user = talloc_ptrtype(mem_ctx, ret->rename_user);
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				ret->rename_user = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_GROUP_MEMBER:
			if (in == Py_None) {
				ret->group_member = NULL;
			} else {
				ret->group_member = talloc_ptrtype(mem_ctx, ret->group_member);
				PY_CHECK_TYPE(&netr_DELTA_GROUP_MEMBER_Type, in, talloc_free(ret); return NULL;);
				ret->group_member = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ALIAS:
			if (in == Py_None) {
				ret->alias = NULL;
			} else {
				ret->alias = talloc_ptrtype(mem_ctx, ret->alias);
				PY_CHECK_TYPE(&netr_DELTA_ALIAS_Type, in, talloc_free(ret); return NULL;);
				ret->alias = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ALIAS:
			break;

		case NETR_DELTA_RENAME_ALIAS:
			if (in == Py_None) {
				ret->rename_alias = NULL;
			} else {
				ret->rename_alias = talloc_ptrtype(mem_ctx, ret->rename_alias);
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				ret->rename_alias = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in == Py_None) {
				ret->alias_member = NULL;
			} else {
				ret->alias_member = talloc_ptrtype(mem_ctx, ret->alias_member);
				PY_CHECK_TYPE(&netr_DELTA_ALIAS_MEMBER_Type, in, talloc_free(ret); return NULL;);
				ret->alias_member = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_POLICY:
			if (in == Py_None) {
				ret->policy = NULL;
			} else {
				ret->policy = talloc_ptrtype(mem_ctx, ret->policy);
				PY_CHECK_TYPE(&netr_DELTA_POLICY_Type, in, talloc_free(ret); return NULL;);
				ret->policy = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in == Py_None) {
				ret->trusted_domain = NULL;
			} else {
				ret->trusted_domain = talloc_ptrtype(mem_ctx, ret->trusted_domain);
				PY_CHECK_TYPE(&netr_DELTA_TRUSTED_DOMAIN_Type, in, talloc_free(ret); return NULL;);
				ret->trusted_domain = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_TRUST:
			PY_CHECK_TYPE(&netr_DELTA_DELETE_TRUST_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->delete_trust, py_talloc_get_ptr(in), sizeof(ret->delete_trust));
			break;

		case NETR_DELTA_ACCOUNT:
			if (in == Py_None) {
				ret->account = NULL;
			} else {
				ret->account = talloc_ptrtype(mem_ctx, ret->account);
				PY_CHECK_TYPE(&netr_DELTA_ACCOUNT_Type, in, talloc_free(ret); return NULL;);
				ret->account = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ACCOUNT:
			PY_CHECK_TYPE(&netr_DELTA_DELETE_ACCOUNT_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->delete_account, py_talloc_get_ptr(in), sizeof(ret->delete_account));
			break;

		case NETR_DELTA_SECRET:
			if (in == Py_None) {
				ret->secret = NULL;
			} else {
				ret->secret = talloc_ptrtype(mem_ctx, ret->secret);
				PY_CHECK_TYPE(&netr_DELTA_SECRET_Type, in, talloc_free(ret); return NULL;);
				ret->secret = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_SECRET:
			PY_CHECK_TYPE(&netr_DELTA_DELETE_SECRET_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->delete_secret, py_talloc_get_ptr(in), sizeof(ret->delete_secret));
			break;

		case NETR_DELTA_DELETE_GROUP2:
			if (in == Py_None) {
				ret->delete_group = NULL;
			} else {
				ret->delete_group = talloc_ptrtype(mem_ctx, ret->delete_group);
				PY_CHECK_TYPE(&netr_DELTA_DELETE_USER_Type, in, talloc_free(ret); return NULL;);
				ret->delete_group = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_USER2:
			if (in == Py_None) {
				ret->delete_user = NULL;
			} else {
				ret->delete_user = talloc_ptrtype(mem_ctx, ret->delete_user);
				PY_CHECK_TYPE(&netr_DELTA_DELETE_USER_Type, in, talloc_free(ret); return NULL;);
				ret->delete_user = py_talloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_MODIFY_COUNT:
			if (in == Py_None) {
				ret->modified_count = NULL;
			} else {
				ret->modified_count = talloc_ptrtype(mem_ctx, ret->modified_count);
				PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
				*ret->modified_count = PyInt_AsLong(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

PyObject *py_import_netr_DELTA_ID_UNION(TALLOC_CTX *mem_ctx, int level, union netr_DELTA_ID_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_DELTA_DOMAIN:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_GROUP:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_GROUP:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_RENAME_GROUP:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_USER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_USER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_RENAME_USER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_GROUP_MEMBER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_ALIAS:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_ALIAS:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_RENAME_ALIAS:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_ALIAS_MEMBER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_POLICY:
			if (in->sid == NULL) {
				ret = Py_None;
			} else {
				ret = NULL;
			}
			return ret;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in->sid == NULL) {
				ret = Py_None;
			} else {
				ret = NULL;
			}
			return ret;

		case NETR_DELTA_DELETE_TRUST:
			if (in->sid == NULL) {
				ret = Py_None;
			} else {
				ret = NULL;
			}
			return ret;

		case NETR_DELTA_ACCOUNT:
			if (in->sid == NULL) {
				ret = Py_None;
			} else {
				ret = NULL;
			}
			return ret;

		case NETR_DELTA_DELETE_ACCOUNT:
			if (in->sid == NULL) {
				ret = Py_None;
			} else {
				ret = NULL;
			}
			return ret;

		case NETR_DELTA_SECRET:
			if (in->name == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->name, strlen(in->name), "utf-8", "ignore");
			}
			return ret;

		case NETR_DELTA_DELETE_SECRET:
			if (in->name == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->name, strlen(in->name), "utf-8", "ignore");
			}
			return ret;

		case NETR_DELTA_DELETE_GROUP2:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_USER2:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_MODIFY_COUNT:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DELTA_ID_UNION *py_export_netr_DELTA_ID_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DELTA_ID_UNION *ret = talloc_zero(mem_ctx, union netr_DELTA_ID_UNION);
	switch (level) {
		case NETR_DELTA_DOMAIN:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_GROUP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_GROUP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_RENAME_GROUP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_USER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_USER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_RENAME_USER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_GROUP_MEMBER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_ALIAS:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_ALIAS:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_RENAME_ALIAS:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_ALIAS_MEMBER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_POLICY:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = talloc_ptrtype(mem_ctx, ret->sid);
				ret->sid = NULL;
			}
			break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = talloc_ptrtype(mem_ctx, ret->sid);
				ret->sid = NULL;
			}
			break;

		case NETR_DELTA_DELETE_TRUST:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = talloc_ptrtype(mem_ctx, ret->sid);
				ret->sid = NULL;
			}
			break;

		case NETR_DELTA_ACCOUNT:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = talloc_ptrtype(mem_ctx, ret->sid);
				ret->sid = NULL;
			}
			break;

		case NETR_DELTA_DELETE_ACCOUNT:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = talloc_ptrtype(mem_ctx, ret->sid);
				ret->sid = NULL;
			}
			break;

		case NETR_DELTA_SECRET:
			if (in == Py_None) {
				ret->name = NULL;
			} else {
				ret->name = talloc_ptrtype(mem_ctx, ret->name);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->name = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETR_DELTA_DELETE_SECRET:
			if (in == Py_None) {
				ret->name = NULL;
			} else {
				ret->name = talloc_ptrtype(mem_ctx, ret->name);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->name = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETR_DELTA_DELETE_GROUP2:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_USER2:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_MODIFY_COUNT:
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_DELTA_ENUM_get_delta_type(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)py_talloc_get_ptr(obj);
	PyObject *py_delta_type;
	py_delta_type = PyInt_FromLong(object->delta_type);
	return py_delta_type;
}

static int py_netr_DELTA_ENUM_set_delta_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->delta_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_get_delta_id_union(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)py_talloc_get_ptr(obj);
	PyObject *py_delta_id_union;
	py_delta_id_union = py_import_netr_DELTA_ID_UNION(py_talloc_get_mem_ctx(obj), object->delta_type, &object->delta_id_union);
	if (py_delta_id_union == NULL) {
		return NULL;
	}
	return py_delta_id_union;
}

static int py_netr_DELTA_ENUM_set_delta_id_union(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)py_talloc_get_ptr(py_obj);
	memcpy(&object->delta_id_union, py_export_netr_DELTA_ID_UNION(py_talloc_get_mem_ctx(py_obj), object->delta_type, value), sizeof(object->delta_id_union));
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_get_delta_union(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)py_talloc_get_ptr(obj);
	PyObject *py_delta_union;
	py_delta_union = py_import_netr_DELTA_UNION(py_talloc_get_mem_ctx(obj), object->delta_type, &object->delta_union);
	if (py_delta_union == NULL) {
		return NULL;
	}
	return py_delta_union;
}

static int py_netr_DELTA_ENUM_set_delta_union(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)py_talloc_get_ptr(py_obj);
	memcpy(&object->delta_union, py_export_netr_DELTA_UNION(py_talloc_get_mem_ctx(py_obj), object->delta_type, value), sizeof(object->delta_union));
	return 0;
}

static PyGetSetDef py_netr_DELTA_ENUM_getsetters[] = {
	{ discard_const_p(char, "delta_type"), py_netr_DELTA_ENUM_get_delta_type, py_netr_DELTA_ENUM_set_delta_type },
	{ discard_const_p(char, "delta_id_union"), py_netr_DELTA_ENUM_get_delta_id_union, py_netr_DELTA_ENUM_set_delta_id_union },
	{ discard_const_p(char, "delta_union"), py_netr_DELTA_ENUM_get_delta_union, py_netr_DELTA_ENUM_set_delta_union },
	{ NULL }
};

static PyObject *py_netr_DELTA_ENUM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_ENUM, type);
}


static PyTypeObject netr_DELTA_ENUM_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ENUM",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_ENUM_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ENUM_new,
};


static PyObject *py_netr_DELTA_ENUM_ARRAY_get_num_deltas(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)py_talloc_get_ptr(obj);
	PyObject *py_num_deltas;
	py_num_deltas = PyInt_FromLong(object->num_deltas);
	return py_num_deltas;
}

static int py_netr_DELTA_ENUM_ARRAY_set_num_deltas(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_deltas = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_ARRAY_get_delta_enum(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)py_talloc_get_ptr(obj);
	PyObject *py_delta_enum;
	if (object->delta_enum == NULL) {
		py_delta_enum = Py_None;
	} else {
		py_delta_enum = PyList_New(object->num_deltas);
		if (py_delta_enum == NULL) {
			return NULL;
		}
		{
			int delta_enum_cntr_1;
			for (delta_enum_cntr_1 = 0; delta_enum_cntr_1 < object->num_deltas; delta_enum_cntr_1++) {
				PyObject *py_delta_enum_1;
				py_delta_enum_1 = py_talloc_import_ex(&netr_DELTA_ENUM_Type, object->delta_enum, &object->delta_enum[delta_enum_cntr_1]);
				PyList_SetItem(py_delta_enum, delta_enum_cntr_1, py_delta_enum_1);
			}
		}
	}
	return py_delta_enum;
}

static int py_netr_DELTA_ENUM_ARRAY_set_delta_enum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)py_talloc_get_ptr(py_obj);
	talloc_free(object->delta_enum);
	if (value == Py_None) {
		object->delta_enum = NULL;
	} else {
		object->delta_enum = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->delta_enum);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int delta_enum_cntr_1;
			object->delta_enum = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->delta_enum, PyList_Size(value));
			for (delta_enum_cntr_1 = 0; delta_enum_cntr_1 < PyList_Size(value); delta_enum_cntr_1++) {
				PY_CHECK_TYPE(&netr_DELTA_ENUM_Type, PyList_GetItem(value, delta_enum_cntr_1), return -1;);
				memcpy(&object->delta_enum[delta_enum_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, delta_enum_cntr_1)), sizeof(object->delta_enum[delta_enum_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ENUM_ARRAY_getsetters[] = {
	{ discard_const_p(char, "num_deltas"), py_netr_DELTA_ENUM_ARRAY_get_num_deltas, py_netr_DELTA_ENUM_ARRAY_set_num_deltas },
	{ discard_const_p(char, "delta_enum"), py_netr_DELTA_ENUM_ARRAY_get_delta_enum, py_netr_DELTA_ENUM_ARRAY_set_delta_enum },
	{ NULL }
};

static PyObject *py_netr_DELTA_ENUM_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DELTA_ENUM_ARRAY, type);
}


static PyTypeObject netr_DELTA_ENUM_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ENUM_ARRAY",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DELTA_ENUM_ARRAY_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DELTA_ENUM_ARRAY_new,
};


static PyObject *py_netr_UAS_INFO_0_get_computer_name(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)py_talloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyList_New(16);
	if (py_computer_name == NULL) {
		return NULL;
	}
	{
		int computer_name_cntr_0;
		for (computer_name_cntr_0 = 0; computer_name_cntr_0 < 16; computer_name_cntr_0++) {
			PyObject *py_computer_name_0;
			py_computer_name_0 = PyInt_FromLong(object->computer_name[computer_name_cntr_0]);
			PyList_SetItem(py_computer_name, computer_name_cntr_0, py_computer_name_0);
		}
	}
	return py_computer_name;
}

static int py_netr_UAS_INFO_0_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int computer_name_cntr_0;
		for (computer_name_cntr_0 = 0; computer_name_cntr_0 < PyList_Size(value); computer_name_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, computer_name_cntr_0), return -1;);
			object->computer_name[computer_name_cntr_0] = PyInt_AsLong(PyList_GetItem(value, computer_name_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_UAS_INFO_0_get_timecreated(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)py_talloc_get_ptr(obj);
	PyObject *py_timecreated;
	py_timecreated = PyInt_FromLong(object->timecreated);
	return py_timecreated;
}

static int py_netr_UAS_INFO_0_set_timecreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timecreated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UAS_INFO_0_get_serial_number(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)py_talloc_get_ptr(obj);
	PyObject *py_serial_number;
	py_serial_number = PyInt_FromLong(object->serial_number);
	return py_serial_number;
}

static int py_netr_UAS_INFO_0_set_serial_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_number = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_UAS_INFO_0_getsetters[] = {
	{ discard_const_p(char, "computer_name"), py_netr_UAS_INFO_0_get_computer_name, py_netr_UAS_INFO_0_set_computer_name },
	{ discard_const_p(char, "timecreated"), py_netr_UAS_INFO_0_get_timecreated, py_netr_UAS_INFO_0_set_timecreated },
	{ discard_const_p(char, "serial_number"), py_netr_UAS_INFO_0_get_serial_number, py_netr_UAS_INFO_0_set_serial_number },
	{ NULL }
};

static PyObject *py_netr_UAS_INFO_0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_UAS_INFO_0, type);
}


static PyTypeObject netr_UAS_INFO_0_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UAS_INFO_0",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_UAS_INFO_0_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_UAS_INFO_0_new,
};


static PyObject *py_netr_AccountBuffer_get_blob(PyObject *obj, void *closure)
{
	struct netr_AccountBuffer *object = (struct netr_AccountBuffer *)py_talloc_get_ptr(obj);
	PyObject *py_blob;
	py_blob = PyString_FromStringAndSize((char *)(object->blob).data, (object->blob).length);
	return py_blob;
}

static int py_netr_AccountBuffer_set_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AccountBuffer *object = (struct netr_AccountBuffer *)py_talloc_get_ptr(py_obj);
	object->blob = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_netr_AccountBuffer_getsetters[] = {
	{ discard_const_p(char, "blob"), py_netr_AccountBuffer_get_blob, py_netr_AccountBuffer_set_blob },
	{ NULL }
};

static PyObject *py_netr_AccountBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_AccountBuffer, type);
}


static PyTypeObject netr_AccountBuffer_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_AccountBuffer",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_AccountBuffer_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_AccountBuffer_new,
};


static PyObject *py_netr_NETLOGON_INFO_1_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_NETLOGON_INFO_1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_1_get_pdc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)py_talloc_get_ptr(obj);
	PyObject *py_pdc_connection_status;
	py_pdc_connection_status = PyInt_FromLong(object->pdc_connection_status);
	return py_pdc_connection_status;
}

static int py_netr_NETLOGON_INFO_1_set_pdc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pdc_connection_status = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_1_getsetters[] = {
	{ discard_const_p(char, "flags"), py_netr_NETLOGON_INFO_1_get_flags, py_netr_NETLOGON_INFO_1_set_flags },
	{ discard_const_p(char, "pdc_connection_status"), py_netr_NETLOGON_INFO_1_get_pdc_connection_status, py_netr_NETLOGON_INFO_1_set_pdc_connection_status },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_NETLOGON_INFO_1, type);
}


static PyTypeObject netr_NETLOGON_INFO_1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_1",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_NETLOGON_INFO_1_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_1_new,
};


static PyObject *py_netr_NETLOGON_INFO_2_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_NETLOGON_INFO_2_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_pdc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(obj);
	PyObject *py_pdc_connection_status;
	py_pdc_connection_status = PyInt_FromLong(object->pdc_connection_status);
	return py_pdc_connection_status;
}

static int py_netr_NETLOGON_INFO_2_set_pdc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pdc_connection_status = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_trusted_dc_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(obj);
	PyObject *py_trusted_dc_name;
	if (object->trusted_dc_name == NULL) {
		py_trusted_dc_name = Py_None;
	} else {
		py_trusted_dc_name = PyUnicode_Decode(object->trusted_dc_name, strlen(object->trusted_dc_name), "utf-8", "ignore");
	}
	return py_trusted_dc_name;
}

static int py_netr_NETLOGON_INFO_2_set_trusted_dc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->trusted_dc_name = NULL;
	} else {
		object->trusted_dc_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->trusted_dc_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->trusted_dc_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_tc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(obj);
	PyObject *py_tc_connection_status;
	py_tc_connection_status = PyInt_FromLong(object->tc_connection_status);
	return py_tc_connection_status;
}

static int py_netr_NETLOGON_INFO_2_set_tc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->tc_connection_status = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_2_getsetters[] = {
	{ discard_const_p(char, "flags"), py_netr_NETLOGON_INFO_2_get_flags, py_netr_NETLOGON_INFO_2_set_flags },
	{ discard_const_p(char, "pdc_connection_status"), py_netr_NETLOGON_INFO_2_get_pdc_connection_status, py_netr_NETLOGON_INFO_2_set_pdc_connection_status },
	{ discard_const_p(char, "trusted_dc_name"), py_netr_NETLOGON_INFO_2_get_trusted_dc_name, py_netr_NETLOGON_INFO_2_set_trusted_dc_name },
	{ discard_const_p(char, "tc_connection_status"), py_netr_NETLOGON_INFO_2_get_tc_connection_status, py_netr_NETLOGON_INFO_2_set_tc_connection_status },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_NETLOGON_INFO_2, type);
}


static PyTypeObject netr_NETLOGON_INFO_2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_NETLOGON_INFO_2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_2_new,
};


static PyObject *py_netr_NETLOGON_INFO_3_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_NETLOGON_INFO_3_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_logon_attempts(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_logon_attempts;
	py_logon_attempts = PyInt_FromLong(object->logon_attempts);
	return py_logon_attempts;
}

static int py_netr_NETLOGON_INFO_3_set_logon_attempts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_attempts = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_netr_NETLOGON_INFO_3_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_netr_NETLOGON_INFO_3_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_netr_NETLOGON_INFO_3_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_netr_NETLOGON_INFO_3_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_NETLOGON_INFO_3_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_3_getsetters[] = {
	{ discard_const_p(char, "flags"), py_netr_NETLOGON_INFO_3_get_flags, py_netr_NETLOGON_INFO_3_set_flags },
	{ discard_const_p(char, "logon_attempts"), py_netr_NETLOGON_INFO_3_get_logon_attempts, py_netr_NETLOGON_INFO_3_set_logon_attempts },
	{ discard_const_p(char, "unknown1"), py_netr_NETLOGON_INFO_3_get_unknown1, py_netr_NETLOGON_INFO_3_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_NETLOGON_INFO_3_get_unknown2, py_netr_NETLOGON_INFO_3_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_NETLOGON_INFO_3_get_unknown3, py_netr_NETLOGON_INFO_3_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_NETLOGON_INFO_3_get_unknown4, py_netr_NETLOGON_INFO_3_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_NETLOGON_INFO_3_get_unknown5, py_netr_NETLOGON_INFO_3_set_unknown5 },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_NETLOGON_INFO_3, type);
}


static PyTypeObject netr_NETLOGON_INFO_3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_3",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_NETLOGON_INFO_3_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_3_new,
};


static PyObject *py_netr_NETLOGON_INFO_4_get_trusted_dc_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)py_talloc_get_ptr(obj);
	PyObject *py_trusted_dc_name;
	if (object->trusted_dc_name == NULL) {
		py_trusted_dc_name = Py_None;
	} else {
		py_trusted_dc_name = PyUnicode_Decode(object->trusted_dc_name, strlen(object->trusted_dc_name), "utf-8", "ignore");
	}
	return py_trusted_dc_name;
}

static int py_netr_NETLOGON_INFO_4_set_trusted_dc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->trusted_dc_name = NULL;
	} else {
		object->trusted_dc_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->trusted_dc_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->trusted_dc_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_4_get_trusted_domain_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)py_talloc_get_ptr(obj);
	PyObject *py_trusted_domain_name;
	if (object->trusted_domain_name == NULL) {
		py_trusted_domain_name = Py_None;
	} else {
		py_trusted_domain_name = PyUnicode_Decode(object->trusted_domain_name, strlen(object->trusted_domain_name), "utf-8", "ignore");
	}
	return py_trusted_domain_name;
}

static int py_netr_NETLOGON_INFO_4_set_trusted_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->trusted_domain_name = NULL;
	} else {
		object->trusted_domain_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->trusted_domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->trusted_domain_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_4_getsetters[] = {
	{ discard_const_p(char, "trusted_dc_name"), py_netr_NETLOGON_INFO_4_get_trusted_dc_name, py_netr_NETLOGON_INFO_4_set_trusted_dc_name },
	{ discard_const_p(char, "trusted_domain_name"), py_netr_NETLOGON_INFO_4_get_trusted_domain_name, py_netr_NETLOGON_INFO_4_set_trusted_domain_name },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_NETLOGON_INFO_4, type);
}


static PyTypeObject netr_NETLOGON_INFO_4_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_4",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_NETLOGON_INFO_4_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_NETLOGON_INFO_4_new,
};

PyObject *py_import_netr_CONTROL_QUERY_INFORMATION(TALLOC_CTX *mem_ctx, int level, union netr_CONTROL_QUERY_INFORMATION *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_NETLOGON_INFO_1_Type, in->info1, in->info1);
			}
			return ret;

		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_NETLOGON_INFO_2_Type, in->info2, in->info2);
			}
			return ret;

		case 3:
			if (in->info3 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_NETLOGON_INFO_3_Type, in->info3, in->info3);
			}
			return ret;

		case 4:
			if (in->info4 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_NETLOGON_INFO_4_Type, in->info4, in->info4);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_CONTROL_QUERY_INFORMATION *py_export_netr_CONTROL_QUERY_INFORMATION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_CONTROL_QUERY_INFORMATION *ret = talloc_zero(mem_ctx, union netr_CONTROL_QUERY_INFORMATION);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = talloc_ptrtype(mem_ctx, ret->info1);
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_1_Type, in, talloc_free(ret); return NULL;);
				ret->info1 = py_talloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = talloc_ptrtype(mem_ctx, ret->info2);
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_2_Type, in, talloc_free(ret); return NULL;);
				ret->info2 = py_talloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == Py_None) {
				ret->info3 = NULL;
			} else {
				ret->info3 = talloc_ptrtype(mem_ctx, ret->info3);
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_3_Type, in, talloc_free(ret); return NULL;);
				ret->info3 = py_talloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == Py_None) {
				ret->info4 = NULL;
			} else {
				ret->info4 = talloc_ptrtype(mem_ctx, ret->info4);
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_4_Type, in, talloc_free(ret); return NULL;);
				ret->info4 = py_talloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

PyObject *py_import_netr_CONTROL_DATA_INFORMATION(TALLOC_CTX *mem_ctx, int level, union netr_CONTROL_DATA_INFORMATION *in)
{
	PyObject *ret;

	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (in->domain == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
			}
			return ret;

		case NETLOGON_CONTROL_TC_QUERY:
			if (in->domain == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
			}
			return ret;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (in->domain == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
			}
			return ret;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			if (in->domain == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
			}
			return ret;

		case NETLOGON_CONTROL_TC_VERIFY:
			if (in->domain == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
			}
			return ret;

		case NETLOGON_CONTROL_FIND_USER:
			if (in->user == NULL) {
				ret = Py_None;
			} else {
				ret = PyUnicode_Decode(in->user, strlen(in->user), "utf-8", "ignore");
			}
			return ret;

		case NETLOGON_CONTROL_SET_DBFLAG:
			ret = PyInt_FromLong(in->debug_level);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_CONTROL_DATA_INFORMATION *py_export_netr_CONTROL_DATA_INFORMATION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_CONTROL_DATA_INFORMATION *ret = talloc_zero(mem_ctx, union netr_CONTROL_DATA_INFORMATION);
	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = talloc_ptrtype(mem_ctx, ret->domain);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->domain = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETLOGON_CONTROL_TC_QUERY:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = talloc_ptrtype(mem_ctx, ret->domain);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->domain = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = talloc_ptrtype(mem_ctx, ret->domain);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->domain = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = talloc_ptrtype(mem_ctx, ret->domain);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->domain = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETLOGON_CONTROL_TC_VERIFY:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = talloc_ptrtype(mem_ctx, ret->domain);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->domain = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETLOGON_CONTROL_FIND_USER:
			if (in == Py_None) {
				ret->user = NULL;
			} else {
				ret->user = talloc_ptrtype(mem_ctx, ret->user);
				PY_CHECK_TYPE(&PyUnicode_Type, in, talloc_free(ret); return NULL;);
				ret->user = PyString_AsString(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
			}
			break;

		case NETLOGON_CONTROL_SET_DBFLAG:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->debug_level = PyInt_AsLong(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

PyObject *py_import_netr_ChangeLogObject(TALLOC_CTX *mem_ctx, int level, union netr_ChangeLogObject *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			ret = py_talloc_import_ex(dom_sid_Type, mem_ctx, &in->object_sid);
			return ret;

		case NETR_CHANGELOG_NAME_INCLUDED:
			ret = PyString_FromString(in->object_name);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_ChangeLogObject *py_export_netr_ChangeLogObject(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_ChangeLogObject *ret = talloc_zero(mem_ctx, union netr_ChangeLogObject);
	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->object_sid, py_talloc_get_ptr(in), sizeof(ret->object_sid));
			break;

		case NETR_CHANGELOG_NAME_INCLUDED:
			ret->object_name = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_netr_ChangeLogEntry_get_serial_number1(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_serial_number1;
	py_serial_number1 = PyInt_FromLong(object->serial_number1);
	return py_serial_number1;
}

static int py_netr_ChangeLogEntry_set_serial_number1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_number1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_serial_number2(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_serial_number2;
	py_serial_number2 = PyInt_FromLong(object->serial_number2);
	return py_serial_number2;
}

static int py_netr_ChangeLogEntry_set_serial_number2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_number2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_object_rid(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_object_rid;
	py_object_rid = PyInt_FromLong(object->object_rid);
	return py_object_rid;
}

static int py_netr_ChangeLogEntry_set_object_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->object_rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_flags(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_ChangeLogEntry_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_db_index(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_db_index;
	py_db_index = PyInt_FromLong(object->db_index);
	return py_db_index;
}

static int py_netr_ChangeLogEntry_set_db_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->db_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_delta_type(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_delta_type;
	py_delta_type = PyInt_FromLong(object->delta_type);
	return py_delta_type;
}

static int py_netr_ChangeLogEntry_set_delta_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->delta_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_object(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(obj);
	PyObject *py_object;
	py_object = py_import_netr_ChangeLogObject(py_talloc_get_mem_ctx(obj), object->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED), &object->object);
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_netr_ChangeLogEntry_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	memcpy(&object->object, py_export_netr_ChangeLogObject(py_talloc_get_mem_ctx(py_obj), object->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED), value), sizeof(object->object));
	return 0;
}

static PyGetSetDef py_netr_ChangeLogEntry_getsetters[] = {
	{ discard_const_p(char, "serial_number1"), py_netr_ChangeLogEntry_get_serial_number1, py_netr_ChangeLogEntry_set_serial_number1 },
	{ discard_const_p(char, "serial_number2"), py_netr_ChangeLogEntry_get_serial_number2, py_netr_ChangeLogEntry_set_serial_number2 },
	{ discard_const_p(char, "object_rid"), py_netr_ChangeLogEntry_get_object_rid, py_netr_ChangeLogEntry_set_object_rid },
	{ discard_const_p(char, "flags"), py_netr_ChangeLogEntry_get_flags, py_netr_ChangeLogEntry_set_flags },
	{ discard_const_p(char, "db_index"), py_netr_ChangeLogEntry_get_db_index, py_netr_ChangeLogEntry_set_db_index },
	{ discard_const_p(char, "delta_type"), py_netr_ChangeLogEntry_get_delta_type, py_netr_ChangeLogEntry_set_delta_type },
	{ discard_const_p(char, "object"), py_netr_ChangeLogEntry_get_object, py_netr_ChangeLogEntry_set_object },
	{ NULL }
};

static PyObject *py_netr_ChangeLogEntry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_ChangeLogEntry, type);
}

static PyObject *py_netr_ChangeLogEntry_ndr_pack(PyObject *py_obj)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_ChangeLogEntry);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_ChangeLogEntry_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_ChangeLogEntry);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_ChangeLogEntry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_ChangeLogEntry_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_ChangeLogEntry_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_ChangeLogEntry_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_ChangeLogEntry",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_ChangeLogEntry_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_ChangeLogEntry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_ChangeLogEntry_new,
};


static PyObject *py_netr_Blob_get_length(PyObject *obj, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_Blob_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_Blob_get_data(PyObject *obj, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_Blob_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)py_talloc_get_ptr(py_obj);
	talloc_free(object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_Size(value));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Blob_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_Blob_get_length, py_netr_Blob_set_length },
	{ discard_const_p(char, "data"), py_netr_Blob_get_data, py_netr_Blob_set_data },
	{ NULL }
};

static PyObject *py_netr_Blob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_Blob, type);
}


static PyTypeObject netr_Blob_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_Blob",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_Blob_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_Blob_new,
};


static PyObject *py_netr_DsRGetDCNameInfo_get_dc_unc(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dc_unc;
	if (object->dc_unc == NULL) {
		py_dc_unc = Py_None;
	} else {
		py_dc_unc = PyUnicode_Decode(object->dc_unc, strlen(object->dc_unc), "utf-8", "ignore");
	}
	return py_dc_unc;
}

static int py_netr_DsRGetDCNameInfo_set_dc_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dc_unc = NULL;
	} else {
		object->dc_unc = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->dc_unc);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->dc_unc = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_address(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dc_address;
	if (object->dc_address == NULL) {
		py_dc_address = Py_None;
	} else {
		py_dc_address = PyUnicode_Decode(object->dc_address, strlen(object->dc_address), "utf-8", "ignore");
	}
	return py_dc_address;
}

static int py_netr_DsRGetDCNameInfo_set_dc_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dc_address = NULL;
	} else {
		object->dc_address = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->dc_address);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->dc_address = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_address_type(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dc_address_type;
	py_dc_address_type = PyInt_FromLong(object->dc_address_type);
	return py_dc_address_type;
}

static int py_netr_DsRGetDCNameInfo_set_dc_address_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dc_address_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = py_talloc_import_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_netr_DsRGetDCNameInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	memcpy(&object->domain_guid, py_talloc_get_ptr(value), sizeof(object->domain_guid));
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
	} else {
		py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_netr_DsRGetDCNameInfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->domain_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_forest_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_forest_name;
	if (object->forest_name == NULL) {
		py_forest_name = Py_None;
	} else {
		py_forest_name = PyUnicode_Decode(object->forest_name, strlen(object->forest_name), "utf-8", "ignore");
	}
	return py_forest_name;
}

static int py_netr_DsRGetDCNameInfo_set_forest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->forest_name = NULL;
	} else {
		object->forest_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->forest_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->forest_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_flags(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dc_flags;
	py_dc_flags = PyInt_FromLong(object->dc_flags);
	return py_dc_flags;
}

static int py_netr_DsRGetDCNameInfo_set_dc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dc_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_site_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dc_site_name;
	if (object->dc_site_name == NULL) {
		py_dc_site_name = Py_None;
	} else {
		py_dc_site_name = PyUnicode_Decode(object->dc_site_name, strlen(object->dc_site_name), "utf-8", "ignore");
	}
	return py_dc_site_name;
}

static int py_netr_DsRGetDCNameInfo_set_dc_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dc_site_name = NULL;
	} else {
		object->dc_site_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->dc_site_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->dc_site_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_client_site_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(obj);
	PyObject *py_client_site_name;
	if (object->client_site_name == NULL) {
		py_client_site_name = Py_None;
	} else {
		py_client_site_name = PyUnicode_Decode(object->client_site_name, strlen(object->client_site_name), "utf-8", "ignore");
	}
	return py_client_site_name;
}

static int py_netr_DsRGetDCNameInfo_set_client_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->client_site_name = NULL;
	} else {
		object->client_site_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->client_site_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->client_site_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyGetSetDef py_netr_DsRGetDCNameInfo_getsetters[] = {
	{ discard_const_p(char, "dc_unc"), py_netr_DsRGetDCNameInfo_get_dc_unc, py_netr_DsRGetDCNameInfo_set_dc_unc },
	{ discard_const_p(char, "dc_address"), py_netr_DsRGetDCNameInfo_get_dc_address, py_netr_DsRGetDCNameInfo_set_dc_address },
	{ discard_const_p(char, "dc_address_type"), py_netr_DsRGetDCNameInfo_get_dc_address_type, py_netr_DsRGetDCNameInfo_set_dc_address_type },
	{ discard_const_p(char, "domain_guid"), py_netr_DsRGetDCNameInfo_get_domain_guid, py_netr_DsRGetDCNameInfo_set_domain_guid },
	{ discard_const_p(char, "domain_name"), py_netr_DsRGetDCNameInfo_get_domain_name, py_netr_DsRGetDCNameInfo_set_domain_name },
	{ discard_const_p(char, "forest_name"), py_netr_DsRGetDCNameInfo_get_forest_name, py_netr_DsRGetDCNameInfo_set_forest_name },
	{ discard_const_p(char, "dc_flags"), py_netr_DsRGetDCNameInfo_get_dc_flags, py_netr_DsRGetDCNameInfo_set_dc_flags },
	{ discard_const_p(char, "dc_site_name"), py_netr_DsRGetDCNameInfo_get_dc_site_name, py_netr_DsRGetDCNameInfo_set_dc_site_name },
	{ discard_const_p(char, "client_site_name"), py_netr_DsRGetDCNameInfo_get_client_site_name, py_netr_DsRGetDCNameInfo_set_client_site_name },
	{ NULL }
};

static PyObject *py_netr_DsRGetDCNameInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DsRGetDCNameInfo, type);
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_pack(PyObject *py_obj)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_netr_DsRGetDCNameInfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_netr_DsRGetDCNameInfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_netr_DsRGetDCNameInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_DsRGetDCNameInfo_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_DsRGetDCNameInfo_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_DsRGetDCNameInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRGetDCNameInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DsRGetDCNameInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_netr_DsRGetDCNameInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRGetDCNameInfo_new,
};

PyObject *py_import_netr_Capabilities(TALLOC_CTX *mem_ctx, int level, union netr_Capabilities *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = PyInt_FromLong(in->server_capabilities);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_Capabilities *py_export_netr_Capabilities(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_Capabilities *ret = talloc_zero(mem_ctx, union netr_Capabilities);
	switch (level) {
		case 1:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->server_capabilities = PyInt_AsLong(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_DomainQuery1_get_blob(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_blob;
	py_blob = py_talloc_import_ex(&netr_Blob_Type, py_talloc_get_mem_ctx(obj), &object->blob);
	return py_blob;
}

static int py_netr_DomainQuery1_set_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_Blob_Type, value, return -1;);
	memcpy(&object->blob, py_talloc_get_ptr(value), sizeof(object->blob));
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_workstation_domain(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_workstation_domain;
	if (object->workstation_domain == NULL) {
		py_workstation_domain = Py_None;
	} else {
		py_workstation_domain = PyUnicode_Decode(object->workstation_domain, strlen(object->workstation_domain), "utf-8", "ignore");
	}
	return py_workstation_domain;
}

static int py_netr_DomainQuery1_set_workstation_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->workstation_domain = NULL;
	} else {
		object->workstation_domain = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->workstation_domain);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->workstation_domain = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_workstation_site(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_workstation_site;
	if (object->workstation_site == NULL) {
		py_workstation_site = Py_None;
	} else {
		py_workstation_site = PyUnicode_Decode(object->workstation_site, strlen(object->workstation_site), "utf-8", "ignore");
	}
	return py_workstation_site;
}

static int py_netr_DomainQuery1_set_workstation_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->workstation_site = NULL;
	} else {
		object->workstation_site = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->workstation_site);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->workstation_site = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown1;
	if (object->unknown1 == NULL) {
		py_unknown1 = Py_None;
	} else {
		py_unknown1 = PyUnicode_Decode(object->unknown1, strlen(object->unknown1), "utf-8", "ignore");
	}
	return py_unknown1;
}

static int py_netr_DomainQuery1_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->unknown1 = NULL;
	} else {
		object->unknown1 = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->unknown1);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->unknown1 = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown2;
	if (object->unknown2 == NULL) {
		py_unknown2 = Py_None;
	} else {
		py_unknown2 = PyUnicode_Decode(object->unknown2, strlen(object->unknown2), "utf-8", "ignore");
	}
	return py_unknown2;
}

static int py_netr_DomainQuery1_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->unknown2 = NULL;
	} else {
		object->unknown2 = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->unknown2);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->unknown2 = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown3;
	if (object->unknown3 == NULL) {
		py_unknown3 = Py_None;
	} else {
		py_unknown3 = PyUnicode_Decode(object->unknown3, strlen(object->unknown3), "utf-8", "ignore");
	}
	return py_unknown3;
}

static int py_netr_DomainQuery1_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->unknown3 = NULL;
	} else {
		object->unknown3 = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->unknown3);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->unknown3 = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown4;
	if (object->unknown4 == NULL) {
		py_unknown4 = Py_None;
	} else {
		py_unknown4 = PyUnicode_Decode(object->unknown4, strlen(object->unknown4), "utf-8", "ignore");
	}
	return py_unknown4;
}

static int py_netr_DomainQuery1_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->unknown4 = NULL;
	} else {
		object->unknown4 = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->unknown4);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->unknown4 = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_blob2(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_blob2;
	py_blob2 = py_talloc_import_ex(lsa_BinaryString_Type, py_talloc_get_mem_ctx(obj), &object->blob2);
	return py_blob2;
}

static int py_netr_DomainQuery1_set_blob2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	memcpy(&object->blob2, py_talloc_get_ptr(value), sizeof(object->blob2));
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_product(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_product;
	py_product = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->product);
	return py_product;
}

static int py_netr_DomainQuery1_set_product(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->product, py_talloc_get_ptr(value), sizeof(object->product));
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown5);
	return py_unknown5;
}

static int py_netr_DomainQuery1_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown5, py_talloc_get_ptr(value), sizeof(object->unknown5));
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->unknown6);
	return py_unknown6;
}

static int py_netr_DomainQuery1_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->unknown6, py_talloc_get_ptr(value), sizeof(object->unknown6));
	return 0;
}

static PyObject *py_netr_DomainQuery1_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyList_New(4);
	if (py_unknown7 == NULL) {
		return NULL;
	}
	{
		int unknown7_cntr_0;
		for (unknown7_cntr_0 = 0; unknown7_cntr_0 < 4; unknown7_cntr_0++) {
			PyObject *py_unknown7_0;
			py_unknown7_0 = PyInt_FromLong(object->unknown7[unknown7_cntr_0]);
			PyList_SetItem(py_unknown7, unknown7_cntr_0, py_unknown7_0);
		}
	}
	return py_unknown7;
}

static int py_netr_DomainQuery1_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainQuery1 *object = (struct netr_DomainQuery1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unknown7_cntr_0;
		for (unknown7_cntr_0 = 0; unknown7_cntr_0 < PyList_Size(value); unknown7_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, unknown7_cntr_0), return -1;);
			object->unknown7[unknown7_cntr_0] = PyInt_AsLong(PyList_GetItem(value, unknown7_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainQuery1_getsetters[] = {
	{ discard_const_p(char, "blob"), py_netr_DomainQuery1_get_blob, py_netr_DomainQuery1_set_blob },
	{ discard_const_p(char, "workstation_domain"), py_netr_DomainQuery1_get_workstation_domain, py_netr_DomainQuery1_set_workstation_domain },
	{ discard_const_p(char, "workstation_site"), py_netr_DomainQuery1_get_workstation_site, py_netr_DomainQuery1_set_workstation_site },
	{ discard_const_p(char, "unknown1"), py_netr_DomainQuery1_get_unknown1, py_netr_DomainQuery1_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DomainQuery1_get_unknown2, py_netr_DomainQuery1_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DomainQuery1_get_unknown3, py_netr_DomainQuery1_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DomainQuery1_get_unknown4, py_netr_DomainQuery1_set_unknown4 },
	{ discard_const_p(char, "blob2"), py_netr_DomainQuery1_get_blob2, py_netr_DomainQuery1_set_blob2 },
	{ discard_const_p(char, "product"), py_netr_DomainQuery1_get_product, py_netr_DomainQuery1_set_product },
	{ discard_const_p(char, "unknown5"), py_netr_DomainQuery1_get_unknown5, py_netr_DomainQuery1_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DomainQuery1_get_unknown6, py_netr_DomainQuery1_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DomainQuery1_get_unknown7, py_netr_DomainQuery1_set_unknown7 },
	{ NULL }
};

static PyObject *py_netr_DomainQuery1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DomainQuery1, type);
}


static PyTypeObject netr_DomainQuery1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainQuery1",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DomainQuery1_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainQuery1_new,
};

PyObject *py_import_netr_DomainQuery(TALLOC_CTX *mem_ctx, int level, union netr_DomainQuery *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->query1 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DomainQuery1_Type, in->query1, in->query1);
			}
			return ret;

		case 2:
			if (in->query1 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DomainQuery1_Type, in->query1, in->query1);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DomainQuery *py_export_netr_DomainQuery(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DomainQuery *ret = talloc_zero(mem_ctx, union netr_DomainQuery);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->query1 = NULL;
			} else {
				ret->query1 = talloc_ptrtype(mem_ctx, ret->query1);
				PY_CHECK_TYPE(&netr_DomainQuery1_Type, in, talloc_free(ret); return NULL;);
				ret->query1 = py_talloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == Py_None) {
				ret->query1 = NULL;
			} else {
				ret->query1 = talloc_ptrtype(mem_ctx, ret->query1);
				PY_CHECK_TYPE(&netr_DomainQuery1_Type, in, talloc_free(ret); return NULL;);
				ret->query1 = py_talloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_trust_extension_get_length(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_trust_extension_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_dummy(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyInt_FromLong(object->dummy);
	return py_dummy;
}

static int py_netr_trust_extension_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_size(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_trust_extension_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_flags(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_trust_extension_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_parent_index(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_parent_index;
	py_parent_index = PyInt_FromLong(object->parent_index);
	return py_parent_index;
}

static int py_netr_trust_extension_set_parent_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->parent_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_trust_type(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyInt_FromLong(object->trust_type);
	return py_trust_type;
}

static int py_netr_trust_extension_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_trust_attributes(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyInt_FromLong(object->trust_attributes);
	return py_trust_attributes;
}

static int py_netr_trust_extension_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_attributes = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_trust_extension_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_trust_extension_get_length, py_netr_trust_extension_set_length },
	{ discard_const_p(char, "dummy"), py_netr_trust_extension_get_dummy, py_netr_trust_extension_set_dummy },
	{ discard_const_p(char, "size"), py_netr_trust_extension_get_size, py_netr_trust_extension_set_size },
	{ discard_const_p(char, "flags"), py_netr_trust_extension_get_flags, py_netr_trust_extension_set_flags },
	{ discard_const_p(char, "parent_index"), py_netr_trust_extension_get_parent_index, py_netr_trust_extension_set_parent_index },
	{ discard_const_p(char, "trust_type"), py_netr_trust_extension_get_trust_type, py_netr_trust_extension_set_trust_type },
	{ discard_const_p(char, "trust_attributes"), py_netr_trust_extension_get_trust_attributes, py_netr_trust_extension_set_trust_attributes },
	{ NULL }
};

static PyObject *py_netr_trust_extension_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_trust_extension, type);
}


static PyTypeObject netr_trust_extension_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_trust_extension",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_trust_extension_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_trust_extension_new,
};


static PyObject *py_netr_trust_extension_container_get_length(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_trust_extension_container_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_container_get_size(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_trust_extension_container_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_container_get_info(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)py_talloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
	} else {
		py_info = py_talloc_import_ex(&netr_trust_extension_Type, object->info, object->info);
	}
	return py_info;
}

static int py_netr_trust_extension_container_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)py_talloc_get_ptr(py_obj);
	talloc_free(object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->info);
		PY_CHECK_TYPE(&netr_trust_extension_Type, value, return -1;);
		object->info = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netr_trust_extension_container_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_trust_extension_container_get_length, py_netr_trust_extension_container_set_length },
	{ discard_const_p(char, "size"), py_netr_trust_extension_container_get_size, py_netr_trust_extension_container_set_size },
	{ discard_const_p(char, "info"), py_netr_trust_extension_container_get_info, py_netr_trust_extension_container_set_info },
	{ NULL }
};

static PyObject *py_netr_trust_extension_container_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_trust_extension_container, type);
}


static PyTypeObject netr_trust_extension_container_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_trust_extension_container",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_trust_extension_container_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_trust_extension_container_new,
};


static PyObject *py_netr_DomainTrustInfo_get_domainname(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_domainname;
	py_domainname = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->domainname);
	return py_domainname;
}

static int py_netr_DomainTrustInfo_set_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->domainname, py_talloc_get_ptr(value), sizeof(object->domainname));
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_fulldomainname(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_fulldomainname;
	py_fulldomainname = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->fulldomainname);
	return py_fulldomainname;
}

static int py_netr_DomainTrustInfo_set_fulldomainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->fulldomainname, py_talloc_get_ptr(value), sizeof(object->fulldomainname));
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_forest(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_forest;
	py_forest = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->forest);
	return py_forest;
}

static int py_netr_DomainTrustInfo_set_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->forest, py_talloc_get_ptr(value), sizeof(object->forest));
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_guid(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = py_talloc_import_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_netr_DomainTrustInfo_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	memcpy(&object->guid, py_talloc_get_ptr(value), sizeof(object->guid));
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_sid(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
	} else {
		py_sid = NULL;
	}
	return py_sid;
}

static int py_netr_DomainTrustInfo_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sid);
		object->sid = NULL;
	}
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_trust_extension(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_trust_extension;
	py_trust_extension = py_talloc_import_ex(&netr_trust_extension_container_Type, py_talloc_get_mem_ctx(obj), &object->trust_extension);
	return py_trust_extension;
}

static int py_netr_DomainTrustInfo_set_trust_extension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_trust_extension_container_Type, value, return -1;);
	memcpy(&object->trust_extension, py_talloc_get_ptr(value), sizeof(object->trust_extension));
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_dummystring(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dummystring;
	py_dummystring = PyList_New(3);
	if (py_dummystring == NULL) {
		return NULL;
	}
	{
		int dummystring_cntr_0;
		for (dummystring_cntr_0 = 0; dummystring_cntr_0 < 3; dummystring_cntr_0++) {
			PyObject *py_dummystring_0;
			py_dummystring_0 = py_talloc_import_ex(lsa_String_Type, object->dummystring, &object->dummystring[dummystring_cntr_0]);
			PyList_SetItem(py_dummystring, dummystring_cntr_0, py_dummystring_0);
		}
	}
	return py_dummystring;
}

static int py_netr_DomainTrustInfo_set_dummystring(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dummystring_cntr_0;
		for (dummystring_cntr_0 = 0; dummystring_cntr_0 < PyList_Size(value); dummystring_cntr_0++) {
			PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, dummystring_cntr_0), return -1;);
			memcpy(&object->dummystring[dummystring_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, dummystring_cntr_0)), sizeof(object->dummystring[dummystring_cntr_0]));
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrustInfo_get_dummy(PyObject *obj, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyList_New(4);
	if (py_dummy == NULL) {
		return NULL;
	}
	{
		int dummy_cntr_0;
		for (dummy_cntr_0 = 0; dummy_cntr_0 < 4; dummy_cntr_0++) {
			PyObject *py_dummy_0;
			py_dummy_0 = PyInt_FromLong(object->dummy[dummy_cntr_0]);
			PyList_SetItem(py_dummy, dummy_cntr_0, py_dummy_0);
		}
	}
	return py_dummy;
}

static int py_netr_DomainTrustInfo_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustInfo *object = (struct netr_DomainTrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dummy_cntr_0;
		for (dummy_cntr_0 = 0; dummy_cntr_0 < PyList_Size(value); dummy_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, dummy_cntr_0), return -1;);
			object->dummy[dummy_cntr_0] = PyInt_AsLong(PyList_GetItem(value, dummy_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainTrustInfo_getsetters[] = {
	{ discard_const_p(char, "domainname"), py_netr_DomainTrustInfo_get_domainname, py_netr_DomainTrustInfo_set_domainname },
	{ discard_const_p(char, "fulldomainname"), py_netr_DomainTrustInfo_get_fulldomainname, py_netr_DomainTrustInfo_set_fulldomainname },
	{ discard_const_p(char, "forest"), py_netr_DomainTrustInfo_get_forest, py_netr_DomainTrustInfo_set_forest },
	{ discard_const_p(char, "guid"), py_netr_DomainTrustInfo_get_guid, py_netr_DomainTrustInfo_set_guid },
	{ discard_const_p(char, "sid"), py_netr_DomainTrustInfo_get_sid, py_netr_DomainTrustInfo_set_sid },
	{ discard_const_p(char, "trust_extension"), py_netr_DomainTrustInfo_get_trust_extension, py_netr_DomainTrustInfo_set_trust_extension },
	{ discard_const_p(char, "dummystring"), py_netr_DomainTrustInfo_get_dummystring, py_netr_DomainTrustInfo_set_dummystring },
	{ discard_const_p(char, "dummy"), py_netr_DomainTrustInfo_get_dummy, py_netr_DomainTrustInfo_set_dummy },
	{ NULL }
};

static PyObject *py_netr_DomainTrustInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DomainTrustInfo, type);
}


static PyTypeObject netr_DomainTrustInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainTrustInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DomainTrustInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainTrustInfo_new,
};


static PyObject *py_netr_LsaPolicyInfo_get_policy_size(PyObject *obj, void *closure)
{
	struct netr_LsaPolicyInfo *object = (struct netr_LsaPolicyInfo *)py_talloc_get_ptr(obj);
	PyObject *py_policy_size;
	py_policy_size = PyInt_FromLong(object->policy_size);
	return py_policy_size;
}

static int py_netr_LsaPolicyInfo_set_policy_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LsaPolicyInfo *object = (struct netr_LsaPolicyInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->policy_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_LsaPolicyInfo_get_policy(PyObject *obj, void *closure)
{
	struct netr_LsaPolicyInfo *object = (struct netr_LsaPolicyInfo *)py_talloc_get_ptr(obj);
	PyObject *py_policy;
	if (object->policy == NULL) {
		py_policy = Py_None;
	} else {
		py_policy = PyList_New(object->policy_size);
		if (py_policy == NULL) {
			return NULL;
		}
		{
			int policy_cntr_1;
			for (policy_cntr_1 = 0; policy_cntr_1 < object->policy_size; policy_cntr_1++) {
				PyObject *py_policy_1;
				py_policy_1 = PyInt_FromLong(object->policy[policy_cntr_1]);
				PyList_SetItem(py_policy, policy_cntr_1, py_policy_1);
			}
		}
	}
	return py_policy;
}

static int py_netr_LsaPolicyInfo_set_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LsaPolicyInfo *object = (struct netr_LsaPolicyInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->policy);
	if (value == Py_None) {
		object->policy = NULL;
	} else {
		object->policy = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->policy);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int policy_cntr_1;
			object->policy = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->policy, PyList_Size(value));
			for (policy_cntr_1 = 0; policy_cntr_1 < PyList_Size(value); policy_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, policy_cntr_1), return -1;);
				object->policy[policy_cntr_1] = PyInt_AsLong(PyList_GetItem(value, policy_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_LsaPolicyInfo_getsetters[] = {
	{ discard_const_p(char, "policy_size"), py_netr_LsaPolicyInfo_get_policy_size, py_netr_LsaPolicyInfo_set_policy_size },
	{ discard_const_p(char, "policy"), py_netr_LsaPolicyInfo_get_policy, py_netr_LsaPolicyInfo_set_policy },
	{ NULL }
};

static PyObject *py_netr_LsaPolicyInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_LsaPolicyInfo, type);
}


static PyTypeObject netr_LsaPolicyInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_LsaPolicyInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_LsaPolicyInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_LsaPolicyInfo_new,
};


static PyObject *py_netr_DomainInfo1_get_domaininfo(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_domaininfo;
	py_domaininfo = py_talloc_import_ex(&netr_DomainTrustInfo_Type, py_talloc_get_mem_ctx(obj), &object->domaininfo);
	return py_domaininfo;
}

static int py_netr_DomainInfo1_set_domaininfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_DomainTrustInfo_Type, value, return -1;);
	memcpy(&object->domaininfo, py_talloc_get_ptr(value), sizeof(object->domaininfo));
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_num_trusts(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_num_trusts;
	py_num_trusts = PyInt_FromLong(object->num_trusts);
	return py_num_trusts;
}

static int py_netr_DomainInfo1_set_num_trusts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_trusts = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_trusts(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_trusts;
	if (object->trusts == NULL) {
		py_trusts = Py_None;
	} else {
		py_trusts = PyList_New(object->num_trusts);
		if (py_trusts == NULL) {
			return NULL;
		}
		{
			int trusts_cntr_1;
			for (trusts_cntr_1 = 0; trusts_cntr_1 < object->num_trusts; trusts_cntr_1++) {
				PyObject *py_trusts_1;
				py_trusts_1 = py_talloc_import_ex(&netr_DomainTrustInfo_Type, object->trusts, &object->trusts[trusts_cntr_1]);
				PyList_SetItem(py_trusts, trusts_cntr_1, py_trusts_1);
			}
		}
	}
	return py_trusts;
}

static int py_netr_DomainInfo1_set_trusts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->trusts);
	if (value == Py_None) {
		object->trusts = NULL;
	} else {
		object->trusts = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->trusts);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int trusts_cntr_1;
			object->trusts = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->trusts, PyList_Size(value));
			for (trusts_cntr_1 = 0; trusts_cntr_1 < PyList_Size(value); trusts_cntr_1++) {
				PY_CHECK_TYPE(&netr_DomainTrustInfo_Type, PyList_GetItem(value, trusts_cntr_1), return -1;);
				memcpy(&object->trusts[trusts_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, trusts_cntr_1)), sizeof(object->trusts[trusts_cntr_1]));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_lsa_policy(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_lsa_policy;
	py_lsa_policy = py_talloc_import_ex(&netr_LsaPolicyInfo_Type, py_talloc_get_mem_ctx(obj), &object->lsa_policy);
	return py_lsa_policy;
}

static int py_netr_DomainInfo1_set_lsa_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_LsaPolicyInfo_Type, value, return -1;);
	memcpy(&object->lsa_policy, py_talloc_get_ptr(value), sizeof(object->lsa_policy));
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_dns_hostname(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_dns_hostname;
	py_dns_hostname = py_talloc_import_ex(lsa_String_Type, py_talloc_get_mem_ctx(obj), &object->dns_hostname);
	return py_dns_hostname;
}

static int py_netr_DomainInfo1_set_dns_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	memcpy(&object->dns_hostname, py_talloc_get_ptr(value), sizeof(object->dns_hostname));
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_dummystring(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_dummystring;
	py_dummystring = PyList_New(3);
	if (py_dummystring == NULL) {
		return NULL;
	}
	{
		int dummystring_cntr_0;
		for (dummystring_cntr_0 = 0; dummystring_cntr_0 < 3; dummystring_cntr_0++) {
			PyObject *py_dummystring_0;
			py_dummystring_0 = py_talloc_import_ex(lsa_String_Type, object->dummystring, &object->dummystring[dummystring_cntr_0]);
			PyList_SetItem(py_dummystring, dummystring_cntr_0, py_dummystring_0);
		}
	}
	return py_dummystring;
}

static int py_netr_DomainInfo1_set_dummystring(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dummystring_cntr_0;
		for (dummystring_cntr_0 = 0; dummystring_cntr_0 < PyList_Size(value); dummystring_cntr_0++) {
			PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, dummystring_cntr_0), return -1;);
			memcpy(&object->dummystring[dummystring_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, dummystring_cntr_0)), sizeof(object->dummystring[dummystring_cntr_0]));
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_workstation_flags(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_workstation_flags;
	py_workstation_flags = PyInt_FromLong(object->workstation_flags);
	return py_workstation_flags;
}

static int py_netr_DomainInfo1_set_workstation_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->workstation_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_supported_enc_types(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_supported_enc_types;
	py_supported_enc_types = PyInt_FromLong(object->supported_enc_types);
	return py_supported_enc_types;
}

static int py_netr_DomainInfo1_set_supported_enc_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->supported_enc_types = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainInfo1_get_dummy(PyObject *obj, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyList_New(2);
	if (py_dummy == NULL) {
		return NULL;
	}
	{
		int dummy_cntr_0;
		for (dummy_cntr_0 = 0; dummy_cntr_0 < 2; dummy_cntr_0++) {
			PyObject *py_dummy_0;
			py_dummy_0 = PyInt_FromLong(object->dummy[dummy_cntr_0]);
			PyList_SetItem(py_dummy, dummy_cntr_0, py_dummy_0);
		}
	}
	return py_dummy;
}

static int py_netr_DomainInfo1_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInfo1 *object = (struct netr_DomainInfo1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dummy_cntr_0;
		for (dummy_cntr_0 = 0; dummy_cntr_0 < PyList_Size(value); dummy_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, dummy_cntr_0), return -1;);
			object->dummy[dummy_cntr_0] = PyInt_AsLong(PyList_GetItem(value, dummy_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainInfo1_getsetters[] = {
	{ discard_const_p(char, "domaininfo"), py_netr_DomainInfo1_get_domaininfo, py_netr_DomainInfo1_set_domaininfo },
	{ discard_const_p(char, "num_trusts"), py_netr_DomainInfo1_get_num_trusts, py_netr_DomainInfo1_set_num_trusts },
	{ discard_const_p(char, "trusts"), py_netr_DomainInfo1_get_trusts, py_netr_DomainInfo1_set_trusts },
	{ discard_const_p(char, "lsa_policy"), py_netr_DomainInfo1_get_lsa_policy, py_netr_DomainInfo1_set_lsa_policy },
	{ discard_const_p(char, "dns_hostname"), py_netr_DomainInfo1_get_dns_hostname, py_netr_DomainInfo1_set_dns_hostname },
	{ discard_const_p(char, "dummystring"), py_netr_DomainInfo1_get_dummystring, py_netr_DomainInfo1_set_dummystring },
	{ discard_const_p(char, "workstation_flags"), py_netr_DomainInfo1_get_workstation_flags, py_netr_DomainInfo1_set_workstation_flags },
	{ discard_const_p(char, "supported_enc_types"), py_netr_DomainInfo1_get_supported_enc_types, py_netr_DomainInfo1_set_supported_enc_types },
	{ discard_const_p(char, "dummy"), py_netr_DomainInfo1_get_dummy, py_netr_DomainInfo1_set_dummy },
	{ NULL }
};

static PyObject *py_netr_DomainInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DomainInfo1, type);
}


static PyTypeObject netr_DomainInfo1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainInfo1",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DomainInfo1_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainInfo1_new,
};

PyObject *py_import_netr_DomainInfo(TALLOC_CTX *mem_ctx, int level, union netr_DomainInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DomainInfo1_Type, in->info1, in->info1);
			}
			return ret;

		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
			} else {
				ret = py_talloc_import_ex(&netr_DomainInfo1_Type, in->info2, in->info2);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DomainInfo *py_export_netr_DomainInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DomainInfo *ret = talloc_zero(mem_ctx, union netr_DomainInfo);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = talloc_ptrtype(mem_ctx, ret->info1);
				PY_CHECK_TYPE(&netr_DomainInfo1_Type, in, talloc_free(ret); return NULL;);
				ret->info1 = py_talloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = talloc_ptrtype(mem_ctx, ret->info2);
				PY_CHECK_TYPE(&netr_DomainInfo1_Type, in, talloc_free(ret); return NULL;);
				ret->info2 = py_talloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_CryptPassword_get_data(PyObject *obj, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(512);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < 512; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_netr_CryptPassword_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < PyList_Size(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GetItem(value, data_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_CryptPassword_get_length(PyObject *obj, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_CryptPassword_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_CryptPassword_getsetters[] = {
	{ discard_const_p(char, "data"), py_netr_CryptPassword_get_data, py_netr_CryptPassword_set_data },
	{ discard_const_p(char, "length"), py_netr_CryptPassword_get_length, py_netr_CryptPassword_set_length },
	{ NULL }
};

static PyObject *py_netr_CryptPassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_CryptPassword, type);
}


static PyTypeObject netr_CryptPassword_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_CryptPassword",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_CryptPassword_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_CryptPassword_new,
};


static PyObject *py_netr_DsRAddressToSitenamesWCtr_get_count(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_DsRAddressToSitenamesWCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesWCtr_get_sitename(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)py_talloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		py_sitename = Py_None;
	} else {
		py_sitename = PyList_New(object->count);
		if (py_sitename == NULL) {
			return NULL;
		}
		{
			int sitename_cntr_1;
			for (sitename_cntr_1 = 0; sitename_cntr_1 < object->count; sitename_cntr_1++) {
				PyObject *py_sitename_1;
				py_sitename_1 = py_talloc_import_ex(lsa_String_Type, object->sitename, &object->sitename[sitename_cntr_1]);
				PyList_SetItem(py_sitename, sitename_cntr_1, py_sitename_1);
			}
		}
	}
	return py_sitename;
}

static int py_netr_DsRAddressToSitenamesWCtr_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sitename);
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sitename);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sitename_cntr_1;
			object->sitename = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sitename, PyList_Size(value));
			for (sitename_cntr_1 = 0; sitename_cntr_1 < PyList_Size(value); sitename_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, sitename_cntr_1), return -1;);
				memcpy(&object->sitename[sitename_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, sitename_cntr_1)), sizeof(object->sitename[sitename_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddressToSitenamesWCtr_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_DsRAddressToSitenamesWCtr_get_count, py_netr_DsRAddressToSitenamesWCtr_set_count },
	{ discard_const_p(char, "sitename"), py_netr_DsRAddressToSitenamesWCtr_get_sitename, py_netr_DsRAddressToSitenamesWCtr_set_sitename },
	{ NULL }
};

static PyObject *py_netr_DsRAddressToSitenamesWCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DsRAddressToSitenamesWCtr, type);
}


static PyTypeObject netr_DsRAddressToSitenamesWCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRAddressToSitenamesWCtr",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DsRAddressToSitenamesWCtr_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRAddressToSitenamesWCtr_new,
};


static PyObject *py_netr_DsRAddress_get_buffer(PyObject *obj, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)py_talloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->buffer == NULL) {
		py_buffer = Py_None;
	} else {
		py_buffer = PyList_New(object->size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < object->size; buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyInt_FromLong(object->buffer[buffer_cntr_1]);
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_netr_DsRAddress_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)py_talloc_get_ptr(py_obj);
	talloc_free(object->buffer);
	if (value == Py_None) {
		object->buffer = NULL;
	} else {
		object->buffer = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->buffer);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->buffer = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->buffer, PyList_Size(value));
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_Size(value); buffer_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, buffer_cntr_1), return -1;);
				object->buffer[buffer_cntr_1] = PyInt_AsLong(PyList_GetItem(value, buffer_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddress_get_size(PyObject *obj, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_DsRAddress_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DsRAddress_getsetters[] = {
	{ discard_const_p(char, "buffer"), py_netr_DsRAddress_get_buffer, py_netr_DsRAddress_set_buffer },
	{ discard_const_p(char, "size"), py_netr_DsRAddress_get_size, py_netr_DsRAddress_set_size },
	{ NULL }
};

static PyObject *py_netr_DsRAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DsRAddress, type);
}


static PyTypeObject netr_DsRAddress_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRAddress",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DsRAddress_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRAddress_new,
};


static PyObject *py_netr_DomainTrust_get_netbios_name(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_netbios_name;
	if (object->netbios_name == NULL) {
		py_netbios_name = Py_None;
	} else {
		py_netbios_name = PyUnicode_Decode(object->netbios_name, strlen(object->netbios_name), "utf-8", "ignore");
	}
	return py_netbios_name;
}

static int py_netr_DomainTrust_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->netbios_name = NULL;
	} else {
		object->netbios_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->netbios_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->netbios_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_dns_name(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
	} else {
		py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
	}
	return py_dns_name;
}

static int py_netr_DomainTrust_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dns_name = NULL;
	} else {
		object->dns_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->dns_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->dns_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_flags(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_trust_flags;
	py_trust_flags = PyInt_FromLong(object->trust_flags);
	return py_trust_flags;
}

static int py_netr_DomainTrust_set_trust_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrust_get_parent_index(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_parent_index;
	py_parent_index = PyInt_FromLong(object->parent_index);
	return py_parent_index;
}

static int py_netr_DomainTrust_set_parent_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->parent_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_type(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyInt_FromLong(object->trust_type);
	return py_trust_type;
}

static int py_netr_DomainTrust_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_attributes(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyInt_FromLong(object->trust_attributes);
	return py_trust_attributes;
}

static int py_netr_DomainTrust_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_attributes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrust_get_sid(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
	} else {
		py_sid = NULL;
	}
	return py_sid;
}

static int py_netr_DomainTrust_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sid);
		object->sid = NULL;
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_guid(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = py_talloc_import_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_netr_DomainTrust_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	memcpy(&object->guid, py_talloc_get_ptr(value), sizeof(object->guid));
	return 0;
}

static PyGetSetDef py_netr_DomainTrust_getsetters[] = {
	{ discard_const_p(char, "netbios_name"), py_netr_DomainTrust_get_netbios_name, py_netr_DomainTrust_set_netbios_name },
	{ discard_const_p(char, "dns_name"), py_netr_DomainTrust_get_dns_name, py_netr_DomainTrust_set_dns_name },
	{ discard_const_p(char, "trust_flags"), py_netr_DomainTrust_get_trust_flags, py_netr_DomainTrust_set_trust_flags },
	{ discard_const_p(char, "parent_index"), py_netr_DomainTrust_get_parent_index, py_netr_DomainTrust_set_parent_index },
	{ discard_const_p(char, "trust_type"), py_netr_DomainTrust_get_trust_type, py_netr_DomainTrust_set_trust_type },
	{ discard_const_p(char, "trust_attributes"), py_netr_DomainTrust_get_trust_attributes, py_netr_DomainTrust_set_trust_attributes },
	{ discard_const_p(char, "sid"), py_netr_DomainTrust_get_sid, py_netr_DomainTrust_set_sid },
	{ discard_const_p(char, "guid"), py_netr_DomainTrust_get_guid, py_netr_DomainTrust_set_guid },
	{ NULL }
};

static PyObject *py_netr_DomainTrust_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DomainTrust, type);
}


static PyTypeObject netr_DomainTrust_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainTrust",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DomainTrust_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainTrust_new,
};


static PyObject *py_netr_DomainTrustList_get_count(PyObject *obj, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_DomainTrustList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrustList_get_array(PyObject *obj, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)py_talloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		py_array = Py_None;
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < object->count; array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = py_talloc_import_ex(&netr_DomainTrust_Type, object->array, &object->array[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_netr_DomainTrustList_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)py_talloc_get_ptr(py_obj);
	talloc_free(object->array);
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->array);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->array, PyList_Size(value));
			for (array_cntr_1 = 0; array_cntr_1 < PyList_Size(value); array_cntr_1++) {
				PY_CHECK_TYPE(&netr_DomainTrust_Type, PyList_GetItem(value, array_cntr_1), return -1;);
				memcpy(&object->array[array_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, array_cntr_1)), sizeof(object->array[array_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainTrustList_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_DomainTrustList_get_count, py_netr_DomainTrustList_set_count },
	{ discard_const_p(char, "array"), py_netr_DomainTrustList_get_array, py_netr_DomainTrustList_set_array },
	{ NULL }
};

static PyObject *py_netr_DomainTrustList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DomainTrustList, type);
}


static PyTypeObject netr_DomainTrustList_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainTrustList",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DomainTrustList_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DomainTrustList_new,
};


static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_count(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_sitename(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)py_talloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		py_sitename = Py_None;
	} else {
		py_sitename = PyList_New(object->count);
		if (py_sitename == NULL) {
			return NULL;
		}
		{
			int sitename_cntr_1;
			for (sitename_cntr_1 = 0; sitename_cntr_1 < object->count; sitename_cntr_1++) {
				PyObject *py_sitename_1;
				py_sitename_1 = py_talloc_import_ex(lsa_String_Type, object->sitename, &object->sitename[sitename_cntr_1]);
				PyList_SetItem(py_sitename, sitename_cntr_1, py_sitename_1);
			}
		}
	}
	return py_sitename;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sitename);
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sitename);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sitename_cntr_1;
			object->sitename = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sitename, PyList_Size(value));
			for (sitename_cntr_1 = 0; sitename_cntr_1 < PyList_Size(value); sitename_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, sitename_cntr_1), return -1;);
				memcpy(&object->sitename[sitename_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, sitename_cntr_1)), sizeof(object->sitename[sitename_cntr_1]));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_subnetname(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)py_talloc_get_ptr(obj);
	PyObject *py_subnetname;
	if (object->subnetname == NULL) {
		py_subnetname = Py_None;
	} else {
		py_subnetname = PyList_New(object->count);
		if (py_subnetname == NULL) {
			return NULL;
		}
		{
			int subnetname_cntr_1;
			for (subnetname_cntr_1 = 0; subnetname_cntr_1 < object->count; subnetname_cntr_1++) {
				PyObject *py_subnetname_1;
				py_subnetname_1 = py_talloc_import_ex(lsa_String_Type, object->subnetname, &object->subnetname[subnetname_cntr_1]);
				PyList_SetItem(py_subnetname, subnetname_cntr_1, py_subnetname_1);
			}
		}
	}
	return py_subnetname;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_subnetname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)py_talloc_get_ptr(py_obj);
	talloc_free(object->subnetname);
	if (value == Py_None) {
		object->subnetname = NULL;
	} else {
		object->subnetname = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->subnetname);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int subnetname_cntr_1;
			object->subnetname = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->subnetname, PyList_Size(value));
			for (subnetname_cntr_1 = 0; subnetname_cntr_1 < PyList_Size(value); subnetname_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, subnetname_cntr_1), return -1;);
				memcpy(&object->subnetname[subnetname_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, subnetname_cntr_1)), sizeof(object->subnetname[subnetname_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddressToSitenamesExWCtr_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_DsRAddressToSitenamesExWCtr_get_count, py_netr_DsRAddressToSitenamesExWCtr_set_count },
	{ discard_const_p(char, "sitename"), py_netr_DsRAddressToSitenamesExWCtr_get_sitename, py_netr_DsRAddressToSitenamesExWCtr_set_sitename },
	{ discard_const_p(char, "subnetname"), py_netr_DsRAddressToSitenamesExWCtr_get_subnetname, py_netr_DsRAddressToSitenamesExWCtr_set_subnetname },
	{ NULL }
};

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_DsRAddressToSitenamesExWCtr, type);
}


static PyTypeObject netr_DsRAddressToSitenamesExWCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRAddressToSitenamesExWCtr",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_DsRAddressToSitenamesExWCtr_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_DsRAddressToSitenamesExWCtr_new,
};


static PyObject *py_DcSitesCtr_get_num_sites(PyObject *obj, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)py_talloc_get_ptr(obj);
	PyObject *py_num_sites;
	py_num_sites = PyInt_FromLong(object->num_sites);
	return py_num_sites;
}

static int py_DcSitesCtr_set_num_sites(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_sites = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DcSitesCtr_get_sites(PyObject *obj, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)py_talloc_get_ptr(obj);
	PyObject *py_sites;
	if (object->sites == NULL) {
		py_sites = Py_None;
	} else {
		py_sites = PyList_New(object->num_sites);
		if (py_sites == NULL) {
			return NULL;
		}
		{
			int sites_cntr_1;
			for (sites_cntr_1 = 0; sites_cntr_1 < object->num_sites; sites_cntr_1++) {
				PyObject *py_sites_1;
				py_sites_1 = py_talloc_import_ex(lsa_String_Type, object->sites, &object->sites[sites_cntr_1]);
				PyList_SetItem(py_sites, sites_cntr_1, py_sites_1);
			}
		}
	}
	return py_sites;
}

static int py_DcSitesCtr_set_sites(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sites);
	if (value == Py_None) {
		object->sites = NULL;
	} else {
		object->sites = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sites);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sites_cntr_1;
			object->sites = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sites, PyList_Size(value));
			for (sites_cntr_1 = 0; sites_cntr_1 < PyList_Size(value); sites_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, sites_cntr_1), return -1;);
				memcpy(&object->sites[sites_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, sites_cntr_1)), sizeof(object->sites[sites_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DcSitesCtr_getsetters[] = {
	{ discard_const_p(char, "num_sites"), py_DcSitesCtr_get_num_sites, py_DcSitesCtr_set_num_sites },
	{ discard_const_p(char, "sites"), py_DcSitesCtr_get_sites, py_DcSitesCtr_set_sites },
	{ NULL }
};

static PyObject *py_DcSitesCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct DcSitesCtr, type);
}


static PyTypeObject DcSitesCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.DcSitesCtr",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_DcSitesCtr_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DcSitesCtr_new,
};


static PyObject *py_netr_TrustInfo_get_count(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_TrustInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_TrustInfo_get_data(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
	} else {
		py_data = PyList_New(object->count);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->count; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_TrustInfo_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->data, PyList_Size(value));
			for (data_cntr_1 = 0; data_cntr_1 < PyList_Size(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GetItem(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_TrustInfo_get_entry_count(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_entry_count;
	py_entry_count = PyInt_FromLong(object->entry_count);
	return py_entry_count;
}

static int py_netr_TrustInfo_set_entry_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entry_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_TrustInfo_get_entries(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		py_entries = Py_None;
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < object->count; entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = py_talloc_import_ex(lsa_String_Type, object->entries, &object->entries[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_netr_TrustInfo_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)py_talloc_get_ptr(py_obj);
	talloc_free(object->entries);
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->entries);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->entries, PyList_Size(value));
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_Size(value); entries_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GetItem(value, entries_cntr_1), return -1;);
				memcpy(&object->entries[entries_cntr_1], py_talloc_get_ptr(PyList_GetItem(value, entries_cntr_1)), sizeof(object->entries[entries_cntr_1]));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_TrustInfo_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_TrustInfo_get_count, py_netr_TrustInfo_set_count },
	{ discard_const_p(char, "data"), py_netr_TrustInfo_get_data, py_netr_TrustInfo_set_data },
	{ discard_const_p(char, "entry_count"), py_netr_TrustInfo_get_entry_count, py_netr_TrustInfo_set_entry_count },
	{ discard_const_p(char, "entries"), py_netr_TrustInfo_get_entries, py_netr_TrustInfo_set_entries },
	{ NULL }
};

static PyObject *py_netr_TrustInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct netr_TrustInfo, type);
}


static PyTypeObject netr_TrustInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_TrustInfo",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_netr_TrustInfo_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netr_TrustInfo_new,
};


static bool pack_py_netr_LogonUasLogon_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonUasLogon *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_workstation;
	const char *kwnames[] = {
		"server_name", "account_name", "workstation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonUasLogon", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_workstation)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyUnicode_Type, py_workstation, return false;);
	r->in.workstation = PyString_AsString(PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore"));
	return true;
}

static PyObject *unpack_py_netr_LogonUasLogon_args_out(struct netr_LogonUasLogon *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
	} else {
		py_info = py_talloc_import_ex(&netr_UasInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonUasLogoff_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonUasLogoff *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_workstation;
	const char *kwnames[] = {
		"server_name", "account_name", "workstation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonUasLogoff", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_workstation)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyUnicode_Type, py_workstation, return false;);
	r->in.workstation = PyString_AsString(PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore"));
	return true;
}

static PyObject *unpack_py_netr_LogonUasLogoff_args_out(struct netr_LogonUasLogoff *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	py_info = py_talloc_import_ex(&netr_UasLogoffInfo_Type, r->out.info, r->out.info);
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogon_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogon *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", "validation_level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_LogonSamLogon", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon, &py_validation_level)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = talloc_ptrtype(r, r->in.credential);
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		r->in.credential = py_talloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_logon_level, return false;);
	r->in.logon_level = PyInt_AsLong(py_logon_level);
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	r->in.logon = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
	PY_CHECK_TYPE(&PyInt_Type, py_validation_level, return false;);
	r->in.validation_level = PyInt_AsLong(py_validation_level);
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogon_args_out(struct netr_LogonSamLogon *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_validation;
	PyObject *py_authoritative;
	result = PyTuple_New(3);
	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
	} else {
		py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_validation = py_import_netr_Validation(r->out.validation, r->in.validation_level, r->out.validation);
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_validation);
	py_authoritative = PyInt_FromLong(*r->out.authoritative);
	PyTuple_SetItem(result, 2, py_authoritative);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogoff_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogoff *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_LogonSamLogoff", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = talloc_ptrtype(r, r->in.credential);
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		r->in.credential = py_talloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_logon_level, return false;);
	r->in.logon_level = PyInt_AsLong(py_logon_level);
	memcpy(&r->in.logon, py_export_netr_LogonLevel(r, r->in.logon_level, py_logon), sizeof(r->in.logon));
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogoff_args_out(struct netr_LogonSamLogoff *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
	} else {
		py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	result = py_return_authenticator;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerReqChallenge_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerReqChallenge *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	const char *kwnames[] = {
		"server_name", "computer_name", "credentials", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_ServerReqChallenge", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credentials)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	r->in.credentials = py_talloc_get_ptr(py_credentials);
	return true;
}

static PyObject *unpack_py_netr_ServerReqChallenge_args_out(struct netr_ServerReqChallenge *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_credentials;
	py_return_credentials = py_talloc_import_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	result = py_return_credentials;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerAuthenticate_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerAuthenticate *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credentials", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerAuthenticate", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credentials)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	r->in.credentials = py_talloc_get_ptr(py_credentials);
	return true;
}

static PyObject *unpack_py_netr_ServerAuthenticate_args_out(struct netr_ServerAuthenticate *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_credentials;
	py_return_credentials = py_talloc_import_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	result = py_return_credentials;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerPasswordSet_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerPasswordSet *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_new_password;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", "new_password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerPasswordSet", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential, &py_new_password)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.new_password = talloc_ptrtype(r, r->in.new_password);
	PY_CHECK_TYPE(samr_Password_Type, py_new_password, return false;);
	r->in.new_password = py_talloc_get_ptr(py_new_password);
	return true;
}

static PyObject *unpack_py_netr_ServerPasswordSet_args_out(struct netr_ServerPasswordSet *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	result = py_return_authenticator;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseDeltas_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseDeltas *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_database_id;
	PyObject *py_sequence_num;
	PyObject *py_preferredmaximumlength;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "database_id", "sequence_num", "preferredmaximumlength", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_DatabaseDeltas", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_database_id, &py_sequence_num, &py_preferredmaximumlength)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
	r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyUnicode_Type, py_computername, return false;);
	r->in.computername = PyString_AsString(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_database_id, return false;);
	r->in.database_id = PyInt_AsLong(py_database_id);
	r->in.sequence_num = talloc_ptrtype(r, r->in.sequence_num);
	PY_CHECK_TYPE(&PyInt_Type, py_sequence_num, return false;);
	*r->in.sequence_num = PyInt_AsLong(py_sequence_num);
	PY_CHECK_TYPE(&PyInt_Type, py_preferredmaximumlength, return false;);
	r->in.preferredmaximumlength = PyInt_AsLong(py_preferredmaximumlength);
	return true;
}

static PyObject *unpack_py_netr_DatabaseDeltas_args_out(struct netr_DatabaseDeltas *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_sequence_num;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(3);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_sequence_num = PyInt_FromLong(*r->out.sequence_num);
	PyTuple_SetItem(result, 1, py_sequence_num);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
	} else {
		py_delta_enum_array = py_talloc_import_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 2, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseSync_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseSync *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_database_id;
	PyObject *py_sync_context;
	PyObject *py_preferredmaximumlength;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "database_id", "sync_context", "preferredmaximumlength", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_DatabaseSync", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_database_id, &py_sync_context, &py_preferredmaximumlength)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
	r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyUnicode_Type, py_computername, return false;);
	r->in.computername = PyString_AsString(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_database_id, return false;);
	r->in.database_id = PyInt_AsLong(py_database_id);
	r->in.sync_context = talloc_ptrtype(r, r->in.sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_sync_context, return false;);
	*r->in.sync_context = PyInt_AsLong(py_sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_preferredmaximumlength, return false;);
	r->in.preferredmaximumlength = PyInt_AsLong(py_preferredmaximumlength);
	return true;
}

static PyObject *unpack_py_netr_DatabaseSync_args_out(struct netr_DatabaseSync *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_sync_context;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(3);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_sync_context = PyInt_FromLong(*r->out.sync_context);
	PyTuple_SetItem(result, 1, py_sync_context);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
	} else {
		py_delta_enum_array = py_talloc_import_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 2, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_AccountDeltas_args_in(PyObject *args, PyObject *kwargs, struct netr_AccountDeltas *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_uas;
	PyObject *py_count;
	PyObject *py_level;
	PyObject *py_buffersize;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "uas", "count", "level", "buffersize", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_AccountDeltas", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_uas, &py_count, &py_level, &py_buffersize)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
		PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
		r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_computername, return false;);
	r->in.computername = PyString_AsString(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	memcpy(&r->in.credential, py_talloc_get_ptr(py_credential), sizeof(r->in.credential));
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&netr_UAS_INFO_0_Type, py_uas, return false;);
	memcpy(&r->in.uas, py_talloc_get_ptr(py_uas), sizeof(r->in.uas));
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	r->in.count = PyInt_AsLong(py_count);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	PY_CHECK_TYPE(&PyInt_Type, py_buffersize, return false;);
	r->in.buffersize = PyInt_AsLong(py_buffersize);
	return true;
}

static PyObject *unpack_py_netr_AccountDeltas_args_out(struct netr_AccountDeltas *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_buffer;
	PyObject *py_count_returned;
	PyObject *py_total_entries;
	PyObject *py_recordid;
	result = PyTuple_New(5);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_buffer = py_talloc_import_ex(&netr_AccountBuffer_Type, r->out.buffer, r->out.buffer);
	PyTuple_SetItem(result, 1, py_buffer);
	py_count_returned = PyInt_FromLong(*r->out.count_returned);
	PyTuple_SetItem(result, 2, py_count_returned);
	py_total_entries = PyInt_FromLong(*r->out.total_entries);
	PyTuple_SetItem(result, 3, py_total_entries);
	py_recordid = py_talloc_import_ex(&netr_UAS_INFO_0_Type, r->out.recordid, r->out.recordid);
	PyTuple_SetItem(result, 4, py_recordid);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_AccountSync_args_in(PyObject *args, PyObject *kwargs, struct netr_AccountSync *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_reference;
	PyObject *py_level;
	PyObject *py_buffersize;
	PyObject *py_recordid;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "reference", "level", "buffersize", "recordid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_AccountSync", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_reference, &py_level, &py_buffersize, &py_recordid)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
		PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
		r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_computername, return false;);
	r->in.computername = PyString_AsString(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	memcpy(&r->in.credential, py_talloc_get_ptr(py_credential), sizeof(r->in.credential));
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_reference, return false;);
	r->in.reference = PyInt_AsLong(py_reference);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	PY_CHECK_TYPE(&PyInt_Type, py_buffersize, return false;);
	r->in.buffersize = PyInt_AsLong(py_buffersize);
	r->in.recordid = talloc_ptrtype(r, r->in.recordid);
	PY_CHECK_TYPE(&netr_UAS_INFO_0_Type, py_recordid, return false;);
	r->in.recordid = py_talloc_get_ptr(py_recordid);
	return true;
}

static PyObject *unpack_py_netr_AccountSync_args_out(struct netr_AccountSync *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_buffer;
	PyObject *py_count_returned;
	PyObject *py_total_entries;
	PyObject *py_next_reference;
	PyObject *py_recordid;
	result = PyTuple_New(6);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_buffer = py_talloc_import_ex(&netr_AccountBuffer_Type, r->out.buffer, r->out.buffer);
	PyTuple_SetItem(result, 1, py_buffer);
	py_count_returned = PyInt_FromLong(*r->out.count_returned);
	PyTuple_SetItem(result, 2, py_count_returned);
	py_total_entries = PyInt_FromLong(*r->out.total_entries);
	PyTuple_SetItem(result, 3, py_total_entries);
	py_next_reference = PyInt_FromLong(*r->out.next_reference);
	PyTuple_SetItem(result, 4, py_next_reference);
	py_recordid = py_talloc_import_ex(&netr_UAS_INFO_0_Type, r->out.recordid, r->out.recordid);
	PyTuple_SetItem(result, 5, py_recordid);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_GetDcName_args_in(PyObject *args, PyObject *kwargs, struct netr_GetDcName *r)
{
	PyObject *py_logon_server;
	PyObject *py_domainname;
	const char *kwnames[] = {
		"logon_server", "domainname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_GetDcName", discard_const_p(char *, kwnames), &py_logon_server, &py_domainname)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
	r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	if (py_domainname == Py_None) {
		r->in.domainname = NULL;
	} else {
		r->in.domainname = talloc_ptrtype(r, r->in.domainname);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domainname, return false;);
		r->in.domainname = PyString_AsString(PyUnicode_AsEncodedString(py_domainname, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_GetDcName_args_out(struct netr_GetDcName *r)
{
	PyObject *result = Py_None;
	PyObject *py_dcname;
	if (*r->out.dcname == NULL) {
		py_dcname = Py_None;
	} else {
		py_dcname = PyUnicode_Decode(*r->out.dcname, strlen(*r->out.dcname), "utf-8", "ignore");
	}
	result = py_dcname;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonControl_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonControl *r)
{
	PyObject *py_logon_server;
	PyObject *py_function_code;
	PyObject *py_level;
	const char *kwnames[] = {
		"logon_server", "function_code", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonControl", discard_const_p(char *, kwnames), &py_logon_server, &py_function_code, &py_level)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
		PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
		r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_function_code, return false;);
	r->in.function_code = PyInt_AsLong(py_function_code);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	return true;
}

static PyObject *unpack_py_netr_LogonControl_args_out(struct netr_LogonControl *r)
{
	PyObject *result = Py_None;
	PyObject *py_query;
	py_query = py_import_netr_CONTROL_QUERY_INFORMATION(r->out.query, r->in.level, r->out.query);
	if (py_query == NULL) {
		return NULL;
	}
	result = py_query;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_GetAnyDCName_args_in(PyObject *args, PyObject *kwargs, struct netr_GetAnyDCName *r)
{
	PyObject *py_logon_server;
	PyObject *py_domainname;
	const char *kwnames[] = {
		"logon_server", "domainname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_GetAnyDCName", discard_const_p(char *, kwnames), &py_logon_server, &py_domainname)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
		PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
		r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	}
	if (py_domainname == Py_None) {
		r->in.domainname = NULL;
	} else {
		r->in.domainname = talloc_ptrtype(r, r->in.domainname);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domainname, return false;);
		r->in.domainname = PyString_AsString(PyUnicode_AsEncodedString(py_domainname, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_GetAnyDCName_args_out(struct netr_GetAnyDCName *r)
{
	PyObject *result = Py_None;
	PyObject *py_dcname;
	if (*r->out.dcname == NULL) {
		py_dcname = Py_None;
	} else {
		py_dcname = PyUnicode_Decode(*r->out.dcname, strlen(*r->out.dcname), "utf-8", "ignore");
	}
	result = py_dcname;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonControl2_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonControl2 *r)
{
	PyObject *py_logon_server;
	PyObject *py_function_code;
	PyObject *py_level;
	PyObject *py_data;
	const char *kwnames[] = {
		"logon_server", "function_code", "level", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:netr_LogonControl2", discard_const_p(char *, kwnames), &py_logon_server, &py_function_code, &py_level, &py_data)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
		PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
		r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_function_code, return false;);
	r->in.function_code = PyInt_AsLong(py_function_code);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	r->in.data = talloc_ptrtype(r, r->in.data);
	r->in.data = py_export_netr_CONTROL_DATA_INFORMATION(r, r->in.function_code, py_data);
	return true;
}

static PyObject *unpack_py_netr_LogonControl2_args_out(struct netr_LogonControl2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_query;
	py_query = py_import_netr_CONTROL_QUERY_INFORMATION(r->out.query, r->in.level, r->out.query);
	if (py_query == NULL) {
		return NULL;
	}
	result = py_query;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerAuthenticate2_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerAuthenticate2 *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	PyObject *py_negotiate_flags;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credentials", "negotiate_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerAuthenticate2", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credentials, &py_negotiate_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	r->in.credentials = py_talloc_get_ptr(py_credentials);
	r->in.negotiate_flags = talloc_ptrtype(r, r->in.negotiate_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_negotiate_flags, return false;);
	*r->in.negotiate_flags = PyInt_AsLong(py_negotiate_flags);
	return true;
}

static PyObject *unpack_py_netr_ServerAuthenticate2_args_out(struct netr_ServerAuthenticate2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_credentials;
	PyObject *py_negotiate_flags;
	result = PyTuple_New(2);
	py_return_credentials = py_talloc_import_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	PyTuple_SetItem(result, 0, py_return_credentials);
	py_negotiate_flags = PyInt_FromLong(*r->out.negotiate_flags);
	PyTuple_SetItem(result, 1, py_negotiate_flags);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseSync2_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseSync2 *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_database_id;
	PyObject *py_restart_state;
	PyObject *py_sync_context;
	PyObject *py_preferredmaximumlength;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "database_id", "restart_state", "sync_context", "preferredmaximumlength", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_DatabaseSync2", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_database_id, &py_restart_state, &py_sync_context, &py_preferredmaximumlength)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
	r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyUnicode_Type, py_computername, return false;);
	r->in.computername = PyString_AsString(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_database_id, return false;);
	r->in.database_id = PyInt_AsLong(py_database_id);
	PY_CHECK_TYPE(&PyInt_Type, py_restart_state, return false;);
	r->in.restart_state = PyInt_AsLong(py_restart_state);
	r->in.sync_context = talloc_ptrtype(r, r->in.sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_sync_context, return false;);
	*r->in.sync_context = PyInt_AsLong(py_sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_preferredmaximumlength, return false;);
	r->in.preferredmaximumlength = PyInt_AsLong(py_preferredmaximumlength);
	return true;
}

static PyObject *unpack_py_netr_DatabaseSync2_args_out(struct netr_DatabaseSync2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_sync_context;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(3);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_sync_context = PyInt_FromLong(*r->out.sync_context);
	PyTuple_SetItem(result, 1, py_sync_context);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
	} else {
		py_delta_enum_array = py_talloc_import_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 2, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseRedo_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseRedo *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_change_log_entry;
	PyObject *py_change_log_entry_size;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "change_log_entry", "change_log_entry_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_DatabaseRedo", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_change_log_entry, &py_change_log_entry_size)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
	r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyUnicode_Type, py_computername, return false;);
	r->in.computername = PyString_AsString(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&netr_ChangeLogEntry_Type, py_change_log_entry, return false;);
	memcpy(&r->in.change_log_entry, py_talloc_get_ptr(py_change_log_entry), sizeof(r->in.change_log_entry));
	PY_CHECK_TYPE(&PyInt_Type, py_change_log_entry_size, return false;);
	r->in.change_log_entry_size = PyInt_AsLong(py_change_log_entry_size);
	return true;
}

static PyObject *unpack_py_netr_DatabaseRedo_args_out(struct netr_DatabaseRedo *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(2);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
	} else {
		py_delta_enum_array = py_talloc_import_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 1, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonControl2Ex_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonControl2Ex *r)
{
	PyObject *py_logon_server;
	PyObject *py_function_code;
	PyObject *py_level;
	PyObject *py_data;
	const char *kwnames[] = {
		"logon_server", "function_code", "level", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:netr_LogonControl2Ex", discard_const_p(char *, kwnames), &py_logon_server, &py_function_code, &py_level, &py_data)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
		PY_CHECK_TYPE(&PyUnicode_Type, py_logon_server, return false;);
		r->in.logon_server = PyString_AsString(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_function_code, return false;);
	r->in.function_code = PyInt_AsLong(py_function_code);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	r->in.data = talloc_ptrtype(r, r->in.data);
	r->in.data = py_export_netr_CONTROL_DATA_INFORMATION(r, r->in.function_code, py_data);
	return true;
}

static PyObject *unpack_py_netr_LogonControl2Ex_args_out(struct netr_LogonControl2Ex *r)
{
	PyObject *result = Py_None;
	PyObject *py_query;
	py_query = py_import_netr_CONTROL_QUERY_INFORMATION(r->out.query, r->in.level, r->out.query);
	if (py_query == NULL) {
		return NULL;
	}
	result = py_query;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_NetrEnumerateTrustedDomains_args_in(PyObject *args, PyObject *kwargs, struct netr_NetrEnumerateTrustedDomains *r)
{
	PyObject *py_server_name;
	const char *kwnames[] = {
		"server_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_NetrEnumerateTrustedDomains", discard_const_p(char *, kwnames), &py_server_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_NetrEnumerateTrustedDomains_args_out(struct netr_NetrEnumerateTrustedDomains *r)
{
	PyObject *result = Py_None;
	PyObject *py_trusted_domains_blob;
	py_trusted_domains_blob = py_talloc_import_ex(&netr_Blob_Type, r->out.trusted_domains_blob, r->out.trusted_domains_blob);
	result = py_trusted_domains_blob;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetDCName_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetDCName *r)
{
	PyObject *py_server_unc;
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_guid;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_unc", "domain_name", "domain_guid", "site_guid", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_DsRGetDCName", discard_const_p(char *, kwnames), &py_server_unc, &py_domain_name, &py_domain_guid, &py_site_guid, &py_flags)) {
		return false;
	}

	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = talloc_ptrtype(r, r->in.server_unc);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_unc, return false;);
		r->in.server_unc = PyString_AsString(PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore"));
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domain_name, return false;);
		r->in.domain_name = PyString_AsString(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = talloc_ptrtype(r, r->in.domain_guid);
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		r->in.domain_guid = py_talloc_get_ptr(py_domain_guid);
	}
	if (py_site_guid == Py_None) {
		r->in.site_guid = NULL;
	} else {
		r->in.site_guid = talloc_ptrtype(r, r->in.site_guid);
		PY_CHECK_TYPE(GUID_Type, py_site_guid, return false;);
		r->in.site_guid = py_talloc_get_ptr(py_site_guid);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_DsRGetDCName_args_out(struct netr_DsRGetDCName *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
	} else {
		py_info = py_talloc_import_ex(&netr_DsRGetDCNameInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonGetCapabilities_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonGetCapabilities *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_query_level;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "query_level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_LogonGetCapabilities", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_query_level)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
	r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_query_level, return false;);
	r->in.query_level = PyInt_AsLong(py_query_level);
	return true;
}

static PyObject *unpack_py_netr_LogonGetCapabilities_args_out(struct netr_LogonGetCapabilities *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_capabilities;
	result = PyTuple_New(2);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_capabilities = py_import_netr_Capabilities(r->out.capabilities, r->in.query_level, r->out.capabilities);
	if (py_capabilities == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_capabilities);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonGetTrustRid_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonGetTrustRid *r)
{
	PyObject *py_server_name;
	PyObject *py_domain_name;
	const char *kwnames[] = {
		"server_name", "domain_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_LogonGetTrustRid", discard_const_p(char *, kwnames), &py_server_name, &py_domain_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domain_name, return false;);
		r->in.domain_name = PyString_AsString(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_LogonGetTrustRid_args_out(struct netr_LogonGetTrustRid *r)
{
	PyObject *result = Py_None;
	PyObject *py_rid;
	py_rid = PyInt_FromLong(*r->out.rid);
	result = py_rid;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerAuthenticate3_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerAuthenticate3 *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	PyObject *py_negotiate_flags;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credentials", "negotiate_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerAuthenticate3", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credentials, &py_negotiate_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	r->in.credentials = py_talloc_get_ptr(py_credentials);
	r->in.negotiate_flags = talloc_ptrtype(r, r->in.negotiate_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_negotiate_flags, return false;);
	*r->in.negotiate_flags = PyInt_AsLong(py_negotiate_flags);
	return true;
}

static PyObject *unpack_py_netr_ServerAuthenticate3_args_out(struct netr_ServerAuthenticate3 *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_credentials;
	PyObject *py_negotiate_flags;
	PyObject *py_rid;
	result = PyTuple_New(3);
	py_return_credentials = py_talloc_import_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	PyTuple_SetItem(result, 0, py_return_credentials);
	py_negotiate_flags = PyInt_FromLong(*r->out.negotiate_flags);
	PyTuple_SetItem(result, 1, py_negotiate_flags);
	py_rid = PyInt_FromLong(*r->out.rid);
	PyTuple_SetItem(result, 2, py_rid);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetDCNameEx_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetDCNameEx *r)
{
	PyObject *py_server_unc;
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_unc", "domain_name", "domain_guid", "site_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_DsRGetDCNameEx", discard_const_p(char *, kwnames), &py_server_unc, &py_domain_name, &py_domain_guid, &py_site_name, &py_flags)) {
		return false;
	}

	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = talloc_ptrtype(r, r->in.server_unc);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_unc, return false;);
		r->in.server_unc = PyString_AsString(PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore"));
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domain_name, return false;);
		r->in.domain_name = PyString_AsString(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = talloc_ptrtype(r, r->in.domain_guid);
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		r->in.domain_guid = py_talloc_get_ptr(py_domain_guid);
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = talloc_ptrtype(r, r->in.site_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_site_name, return false;);
		r->in.site_name = PyString_AsString(PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_DsRGetDCNameEx_args_out(struct netr_DsRGetDCNameEx *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
	} else {
		py_info = py_talloc_import_ex(&netr_DsRGetDCNameInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetSiteName_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetSiteName *r)
{
	PyObject *py_computer_name;
	const char *kwnames[] = {
		"computer_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_DsRGetSiteName", discard_const_p(char *, kwnames), &py_computer_name)) {
		return false;
	}

	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_DsRGetSiteName_args_out(struct netr_DsRGetSiteName *r)
{
	PyObject *result = Py_None;
	PyObject *py_site;
	if (*r->out.site == NULL) {
		py_site = Py_None;
	} else {
		py_site = PyUnicode_Decode(*r->out.site, strlen(*r->out.site), "utf-8", "ignore");
	}
	result = py_site;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonGetDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonGetDomainInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_level;
	PyObject *py_query;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "level", "query", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_LogonGetDomainInfo", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_level, &py_query)) {
		return false;
	}

	PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
	r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	memcpy(&r->in.query, py_export_netr_DomainQuery(r, r->in.level, py_query), sizeof(r->in.query));
	return true;
}

static PyObject *unpack_py_netr_LogonGetDomainInfo_args_out(struct netr_LogonGetDomainInfo *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_info;
	result = PyTuple_New(2);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_info = py_import_netr_DomainInfo(r->out.info, r->in.level, r->out.info);
	if (py_info == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_info);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerPasswordSet2_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerPasswordSet2 *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_new_password;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", "new_password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerPasswordSet2", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential, &py_new_password)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	r->in.new_password = talloc_ptrtype(r, r->in.new_password);
	PY_CHECK_TYPE(&netr_CryptPassword_Type, py_new_password, return false;);
	r->in.new_password = py_talloc_get_ptr(py_new_password);
	return true;
}

static PyObject *unpack_py_netr_ServerPasswordSet2_args_out(struct netr_ServerPasswordSet2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	result = py_return_authenticator;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerPasswordGet_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerPasswordGet *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerPasswordGet", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	return true;
}

static PyObject *unpack_py_netr_ServerPasswordGet_args_out(struct netr_ServerPasswordGet *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_password;
	result = PyTuple_New(2);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_password = py_talloc_import_ex(samr_Password_Type, r->out.password, r->out.password);
	PyTuple_SetItem(result, 1, py_password);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRAddressToSitenamesW_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRAddressToSitenamesW *r)
{
	PyObject *py_server_name;
	PyObject *py_addresses;
	const char *kwnames[] = {
		"server_name", "addresses", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_DsRAddressToSitenamesW", discard_const_p(char *, kwnames), &py_server_name, &py_addresses)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	r->in.count = PyList_Size(py_addresses);
	r->in.addresses = talloc_ptrtype(r, r->in.addresses);
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	{
		int addresses_cntr_1;
		r->in.addresses = talloc_array_ptrtype(r, r->in.addresses, PyList_Size(py_addresses));
		for (addresses_cntr_1 = 0; addresses_cntr_1 < PyList_Size(py_addresses); addresses_cntr_1++) {
			PY_CHECK_TYPE(&netr_DsRAddress_Type, PyList_GetItem(py_addresses, addresses_cntr_1), return false;);
			memcpy(&r->in.addresses[addresses_cntr_1], py_talloc_get_ptr(PyList_GetItem(py_addresses, addresses_cntr_1)), sizeof(r->in.addresses[addresses_cntr_1]));
		}
	}
	return true;
}

static PyObject *unpack_py_netr_DsRAddressToSitenamesW_args_out(struct netr_DsRAddressToSitenamesW *r)
{
	PyObject *result = Py_None;
	PyObject *py_ctr;
	if (*r->out.ctr == NULL) {
		py_ctr = Py_None;
	} else {
		py_ctr = py_talloc_import_ex(&netr_DsRAddressToSitenamesWCtr_Type, *r->out.ctr, *r->out.ctr);
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetDCNameEx2_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetDCNameEx2 *r)
{
	PyObject *py_server_unc;
	PyObject *py_client_account;
	PyObject *py_mask;
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_unc", "client_account", "mask", "domain_name", "domain_guid", "site_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_DsRGetDCNameEx2", discard_const_p(char *, kwnames), &py_server_unc, &py_client_account, &py_mask, &py_domain_name, &py_domain_guid, &py_site_name, &py_flags)) {
		return false;
	}

	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = talloc_ptrtype(r, r->in.server_unc);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_unc, return false;);
		r->in.server_unc = PyString_AsString(PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore"));
	}
	if (py_client_account == Py_None) {
		r->in.client_account = NULL;
	} else {
		r->in.client_account = talloc_ptrtype(r, r->in.client_account);
		PY_CHECK_TYPE(&PyUnicode_Type, py_client_account, return false;);
		r->in.client_account = PyString_AsString(PyUnicode_AsEncodedString(py_client_account, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_mask, return false;);
	r->in.mask = PyInt_AsLong(py_mask);
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domain_name, return false;);
		r->in.domain_name = PyString_AsString(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = talloc_ptrtype(r, r->in.domain_guid);
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		r->in.domain_guid = py_talloc_get_ptr(py_domain_guid);
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = talloc_ptrtype(r, r->in.site_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_site_name, return false;);
		r->in.site_name = PyString_AsString(PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_DsRGetDCNameEx2_args_out(struct netr_DsRGetDCNameEx2 *r)
{
	PyObject *result = Py_None;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
	} else {
		py_info = py_talloc_import_ex(&netr_DsRGetDCNameInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_NetrEnumerateTrustedDomainsEx_args_in(PyObject *args, PyObject *kwargs, struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	PyObject *py_server_name;
	const char *kwnames[] = {
		"server_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_NetrEnumerateTrustedDomainsEx", discard_const_p(char *, kwnames), &py_server_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_NetrEnumerateTrustedDomainsEx_args_out(struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	PyObject *result = Py_None;
	PyObject *py_dom_trust_list;
	py_dom_trust_list = py_talloc_import_ex(&netr_DomainTrustList_Type, r->out.dom_trust_list, r->out.dom_trust_list);
	result = py_dom_trust_list;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRAddressToSitenamesExW_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRAddressToSitenamesExW *r)
{
	PyObject *py_server_name;
	PyObject *py_addresses;
	const char *kwnames[] = {
		"server_name", "addresses", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_DsRAddressToSitenamesExW", discard_const_p(char *, kwnames), &py_server_name, &py_addresses)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	r->in.count = PyList_Size(py_addresses);
	r->in.addresses = talloc_ptrtype(r, r->in.addresses);
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	{
		int addresses_cntr_1;
		r->in.addresses = talloc_array_ptrtype(r, r->in.addresses, PyList_Size(py_addresses));
		for (addresses_cntr_1 = 0; addresses_cntr_1 < PyList_Size(py_addresses); addresses_cntr_1++) {
			PY_CHECK_TYPE(&netr_DsRAddress_Type, PyList_GetItem(py_addresses, addresses_cntr_1), return false;);
			memcpy(&r->in.addresses[addresses_cntr_1], py_talloc_get_ptr(PyList_GetItem(py_addresses, addresses_cntr_1)), sizeof(r->in.addresses[addresses_cntr_1]));
		}
	}
	return true;
}

static PyObject *unpack_py_netr_DsRAddressToSitenamesExW_args_out(struct netr_DsRAddressToSitenamesExW *r)
{
	PyObject *result = Py_None;
	PyObject *py_ctr;
	if (*r->out.ctr == NULL) {
		py_ctr = Py_None;
	} else {
		py_ctr = py_talloc_import_ex(&netr_DsRAddressToSitenamesExWCtr_Type, *r->out.ctr, *r->out.ctr);
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrGetDcSiteCoverageW_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrGetDcSiteCoverageW *r)
{
	PyObject *py_server_name;
	const char *kwnames[] = {
		"server_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_DsrGetDcSiteCoverageW", discard_const_p(char *, kwnames), &py_server_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	return true;
}

static PyObject *unpack_py_netr_DsrGetDcSiteCoverageW_args_out(struct netr_DsrGetDcSiteCoverageW *r)
{
	PyObject *result = Py_None;
	PyObject *py_ctr;
	if (*r->out.ctr == NULL) {
		py_ctr = Py_None;
	} else {
		py_ctr = py_talloc_import_ex(&DcSitesCtr_Type, *r->out.ctr, *r->out.ctr);
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogonEx_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogonEx *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "computer_name", "logon_level", "logon", "validation_level", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_LogonSamLogonEx", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_logon_level, &py_logon, &py_validation_level, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_logon_level, return false;);
	r->in.logon_level = PyInt_AsLong(py_logon_level);
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	r->in.logon = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
	PY_CHECK_TYPE(&PyInt_Type, py_validation_level, return false;);
	r->in.validation_level = PyInt_AsLong(py_validation_level);
	r->in.flags = talloc_ptrtype(r, r->in.flags);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	*r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogonEx_args_out(struct netr_LogonSamLogonEx *r)
{
	PyObject *result = Py_None;
	PyObject *py_validation;
	PyObject *py_authoritative;
	PyObject *py_flags;
	result = PyTuple_New(3);
	py_validation = py_import_netr_Validation(r->out.validation, r->in.validation_level, r->out.validation);
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 0, py_validation);
	py_authoritative = PyInt_FromLong(*r->out.authoritative);
	PyTuple_SetItem(result, 1, py_authoritative);
	py_flags = PyInt_FromLong(*r->out.flags);
	PyTuple_SetItem(result, 2, py_flags);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrEnumerateDomainTrusts_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrEnumerateDomainTrusts *r)
{
	PyObject *py_server_name;
	PyObject *py_trust_flags;
	const char *kwnames[] = {
		"server_name", "trust_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_DsrEnumerateDomainTrusts", discard_const_p(char *, kwnames), &py_server_name, &py_trust_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_trust_flags, return false;);
	r->in.trust_flags = PyInt_AsLong(py_trust_flags);
	return true;
}

static PyObject *unpack_py_netr_DsrEnumerateDomainTrusts_args_out(struct netr_DsrEnumerateDomainTrusts *r)
{
	PyObject *result = Py_None;
	PyObject *py_trusts;
	py_trusts = py_talloc_import_ex(&netr_DomainTrustList_Type, r->out.trusts, r->out.trusts);
	result = py_trusts;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrDeregisterDNSHostRecords_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrDeregisterDNSHostRecords *r)
{
	PyObject *py_server_name;
	PyObject *py_domain;
	PyObject *py_domain_guid;
	PyObject *py_dsa_guid;
	PyObject *py_dns_host;
	const char *kwnames[] = {
		"server_name", "domain", "domain_guid", "dsa_guid", "dns_host", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_DsrDeregisterDNSHostRecords", discard_const_p(char *, kwnames), &py_server_name, &py_domain, &py_domain_guid, &py_dsa_guid, &py_dns_host)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_domain == Py_None) {
		r->in.domain = NULL;
	} else {
		r->in.domain = talloc_ptrtype(r, r->in.domain);
		PY_CHECK_TYPE(&PyUnicode_Type, py_domain, return false;);
		r->in.domain = PyString_AsString(PyUnicode_AsEncodedString(py_domain, "utf-8", "ignore"));
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = talloc_ptrtype(r, r->in.domain_guid);
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		r->in.domain_guid = py_talloc_get_ptr(py_domain_guid);
	}
	if (py_dsa_guid == Py_None) {
		r->in.dsa_guid = NULL;
	} else {
		r->in.dsa_guid = talloc_ptrtype(r, r->in.dsa_guid);
		PY_CHECK_TYPE(GUID_Type, py_dsa_guid, return false;);
		r->in.dsa_guid = py_talloc_get_ptr(py_dsa_guid);
	}
	r->in.dns_host = talloc_ptrtype(r, r->in.dns_host);
	PY_CHECK_TYPE(&PyUnicode_Type, py_dns_host, return false;);
	r->in.dns_host = PyString_AsString(PyUnicode_AsEncodedString(py_dns_host, "utf-8", "ignore"));
	return true;
}

static PyObject *unpack_py_netr_DsrDeregisterDNSHostRecords_args_out(struct netr_DsrDeregisterDNSHostRecords *r)
{
	PyObject *result = Py_None;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerTrustPasswordsGet_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerTrustPasswordsGet *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerTrustPasswordsGet", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	return true;
}

static PyObject *unpack_py_netr_ServerTrustPasswordsGet_args_out(struct netr_ServerTrustPasswordsGet *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_password;
	PyObject *py_password2;
	result = PyTuple_New(3);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_password = py_talloc_import_ex(samr_Password_Type, r->out.password, r->out.password);
	PyTuple_SetItem(result, 1, py_password);
	py_password2 = py_talloc_import_ex(samr_Password_Type, r->out.password2, r->out.password2);
	PyTuple_SetItem(result, 2, py_password2);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetForestTrustInformation *r)
{
	PyObject *py_server_name;
	PyObject *py_trusted_domain_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "trusted_domain_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_DsRGetForestTrustInformation", discard_const_p(char *, kwnames), &py_server_name, &py_trusted_domain_name, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_trusted_domain_name == Py_None) {
		r->in.trusted_domain_name = NULL;
	} else {
		r->in.trusted_domain_name = talloc_ptrtype(r, r->in.trusted_domain_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_trusted_domain_name, return false;);
		r->in.trusted_domain_name = PyString_AsString(PyUnicode_AsEncodedString(py_trusted_domain_name, "utf-8", "ignore"));
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_DsRGetForestTrustInformation_args_out(struct netr_DsRGetForestTrustInformation *r)
{
	PyObject *result = Py_None;
	PyObject *py_forest_trust_info;
	if (*r->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
	} else {
		py_forest_trust_info = py_talloc_import_ex(lsa_ForestTrustInformation_Type, *r->out.forest_trust_info, *r->out.forest_trust_info);
	}
	result = py_forest_trust_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_GetForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct netr_GetForestTrustInformation *r)
{
	PyObject *py_server_name;
	PyObject *py_trusted_domain_name;
	PyObject *py_credential;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "trusted_domain_name", "credential", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:netr_GetForestTrustInformation", discard_const_p(char *, kwnames), &py_server_name, &py_trusted_domain_name, &py_credential, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	r->in.trusted_domain_name = talloc_ptrtype(r, r->in.trusted_domain_name);
	PY_CHECK_TYPE(&PyUnicode_Type, py_trusted_domain_name, return false;);
	r->in.trusted_domain_name = PyString_AsString(PyUnicode_AsEncodedString(py_trusted_domain_name, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_GetForestTrustInformation_args_out(struct netr_GetForestTrustInformation *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_forest_trust_info;
	result = PyTuple_New(2);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	if (*r->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
	} else {
		py_forest_trust_info = py_talloc_import_ex(lsa_ForestTrustInformation_Type, *r->out.forest_trust_info, *r->out.forest_trust_info);
	}
	PyTuple_SetItem(result, 1, py_forest_trust_info);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogonWithFlags_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogonWithFlags *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", "validation_level", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_LogonSamLogonWithFlags", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon, &py_validation_level, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
		r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = talloc_ptrtype(r, r->in.credential);
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		r->in.credential = py_talloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		r->in.return_authenticator = py_talloc_get_ptr(py_return_authenticator);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_logon_level, return false;);
	r->in.logon_level = PyInt_AsLong(py_logon_level);
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	r->in.logon = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
	PY_CHECK_TYPE(&PyInt_Type, py_validation_level, return false;);
	r->in.validation_level = PyInt_AsLong(py_validation_level);
	r->in.flags = talloc_ptrtype(r, r->in.flags);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	*r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogonWithFlags_args_out(struct netr_LogonSamLogonWithFlags *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_validation;
	PyObject *py_authoritative;
	PyObject *py_flags;
	result = PyTuple_New(4);
	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
	} else {
		py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_validation = py_import_netr_Validation(r->out.validation, r->in.validation_level, r->out.validation);
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_validation);
	py_authoritative = PyInt_FromLong(*r->out.authoritative);
	PyTuple_SetItem(result, 2, py_authoritative);
	py_flags = PyInt_FromLong(*r->out.flags);
	PyTuple_SetItem(result, 3, py_flags);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerGetTrustInfo_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerGetTrustInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerGetTrustInfo", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = talloc_ptrtype(r, r->in.server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, py_server_name, return false;);
		r->in.server_name = PyString_AsString(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	PY_CHECK_TYPE(&PyUnicode_Type, py_account_name, return false;);
	r->in.account_name = PyString_AsString(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	PY_CHECK_TYPE(&PyInt_Type, py_secure_channel_type, return false;);
	r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	PY_CHECK_TYPE(&PyUnicode_Type, py_computer_name, return false;);
	r->in.computer_name = PyString_AsString(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	r->in.credential = py_talloc_get_ptr(py_credential);
	return true;
}

static PyObject *unpack_py_netr_ServerGetTrustInfo_args_out(struct netr_ServerGetTrustInfo *r)
{
	PyObject *result = Py_None;
	PyObject *py_return_authenticator;
	PyObject *py_new_owf_password;
	PyObject *py_old_owf_password;
	PyObject *py_trust_info;
	result = PyTuple_New(4);
	py_return_authenticator = py_talloc_import_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_new_owf_password = py_talloc_import_ex(samr_Password_Type, r->out.new_owf_password, r->out.new_owf_password);
	PyTuple_SetItem(result, 1, py_new_owf_password);
	py_old_owf_password = py_talloc_import_ex(samr_Password_Type, r->out.old_owf_password, r->out.old_owf_password);
	PyTuple_SetItem(result, 2, py_old_owf_password);
	if (*r->out.trust_info == NULL) {
		py_trust_info = Py_None;
	} else {
		py_trust_info = py_talloc_import_ex(&netr_TrustInfo_Type, *r->out.trust_info, *r->out.trust_info);
	}
	PyTuple_SetItem(result, 3, py_trust_info);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_netlogon_methods[] = {
	{ "netr_LogonUasLogon", "S.netr_LogonUasLogon(server_name, account_name, workstation) -> info", (dcerpc_call_fn)dcerpc_netr_LogonUasLogon, (py_data_pack_fn)pack_py_netr_LogonUasLogon_args_in, (py_data_unpack_fn)unpack_py_netr_LogonUasLogon_args_out, 0, &ndr_table_netlogon },
	{ "netr_LogonUasLogoff", "S.netr_LogonUasLogoff(server_name, account_name, workstation) -> info", (dcerpc_call_fn)dcerpc_netr_LogonUasLogoff, (py_data_pack_fn)pack_py_netr_LogonUasLogoff_args_in, (py_data_unpack_fn)unpack_py_netr_LogonUasLogoff_args_out, 1, &ndr_table_netlogon },
	{ "netr_LogonSamLogon", "S.netr_LogonSamLogon(server_name, computer_name, credential, return_authenticator, logon_level, logon, validation_level) -> (return_authenticator, validation, authoritative)", (dcerpc_call_fn)dcerpc_netr_LogonSamLogon, (py_data_pack_fn)pack_py_netr_LogonSamLogon_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogon_args_out, 2, &ndr_table_netlogon },
	{ "netr_LogonSamLogoff", "S.netr_LogonSamLogoff(server_name, computer_name, credential, return_authenticator, logon_level, logon) -> return_authenticator", (dcerpc_call_fn)dcerpc_netr_LogonSamLogoff, (py_data_pack_fn)pack_py_netr_LogonSamLogoff_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogoff_args_out, 3, &ndr_table_netlogon },
	{ "netr_ServerReqChallenge", "S.netr_ServerReqChallenge(server_name, computer_name, credentials) -> return_credentials", (dcerpc_call_fn)dcerpc_netr_ServerReqChallenge, (py_data_pack_fn)pack_py_netr_ServerReqChallenge_args_in, (py_data_unpack_fn)unpack_py_netr_ServerReqChallenge_args_out, 4, &ndr_table_netlogon },
	{ "netr_ServerAuthenticate", "S.netr_ServerAuthenticate(server_name, account_name, secure_channel_type, computer_name, credentials) -> return_credentials", (dcerpc_call_fn)dcerpc_netr_ServerAuthenticate, (py_data_pack_fn)pack_py_netr_ServerAuthenticate_args_in, (py_data_unpack_fn)unpack_py_netr_ServerAuthenticate_args_out, 5, &ndr_table_netlogon },
	{ "netr_ServerPasswordSet", "S.netr_ServerPasswordSet(server_name, account_name, secure_channel_type, computer_name, credential, new_password) -> return_authenticator", (dcerpc_call_fn)dcerpc_netr_ServerPasswordSet, (py_data_pack_fn)pack_py_netr_ServerPasswordSet_args_in, (py_data_unpack_fn)unpack_py_netr_ServerPasswordSet_args_out, 6, &ndr_table_netlogon },
	{ "netr_DatabaseDeltas", "S.netr_DatabaseDeltas(logon_server, computername, credential, return_authenticator, database_id, sequence_num, preferredmaximumlength) -> (return_authenticator, sequence_num, delta_enum_array)", (dcerpc_call_fn)dcerpc_netr_DatabaseDeltas, (py_data_pack_fn)pack_py_netr_DatabaseDeltas_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseDeltas_args_out, 7, &ndr_table_netlogon },
	{ "netr_DatabaseSync", "S.netr_DatabaseSync(logon_server, computername, credential, return_authenticator, database_id, sync_context, preferredmaximumlength) -> (return_authenticator, sync_context, delta_enum_array)", (dcerpc_call_fn)dcerpc_netr_DatabaseSync, (py_data_pack_fn)pack_py_netr_DatabaseSync_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseSync_args_out, 8, &ndr_table_netlogon },
	{ "netr_AccountDeltas", "S.netr_AccountDeltas(logon_server, computername, credential, return_authenticator, uas, count, level, buffersize) -> (return_authenticator, buffer, count_returned, total_entries, recordid)", (dcerpc_call_fn)dcerpc_netr_AccountDeltas, (py_data_pack_fn)pack_py_netr_AccountDeltas_args_in, (py_data_unpack_fn)unpack_py_netr_AccountDeltas_args_out, 9, &ndr_table_netlogon },
	{ "netr_AccountSync", "S.netr_AccountSync(logon_server, computername, credential, return_authenticator, reference, level, buffersize, recordid) -> (return_authenticator, buffer, count_returned, total_entries, next_reference, recordid)", (dcerpc_call_fn)dcerpc_netr_AccountSync, (py_data_pack_fn)pack_py_netr_AccountSync_args_in, (py_data_unpack_fn)unpack_py_netr_AccountSync_args_out, 10, &ndr_table_netlogon },
	{ "netr_GetDcName", "S.netr_GetDcName(logon_server, domainname) -> dcname", (dcerpc_call_fn)dcerpc_netr_GetDcName, (py_data_pack_fn)pack_py_netr_GetDcName_args_in, (py_data_unpack_fn)unpack_py_netr_GetDcName_args_out, 11, &ndr_table_netlogon },
	{ "netr_LogonControl", "S.netr_LogonControl(logon_server, function_code, level) -> query", (dcerpc_call_fn)dcerpc_netr_LogonControl, (py_data_pack_fn)pack_py_netr_LogonControl_args_in, (py_data_unpack_fn)unpack_py_netr_LogonControl_args_out, 12, &ndr_table_netlogon },
	{ "netr_GetAnyDCName", "S.netr_GetAnyDCName(logon_server, domainname) -> dcname", (dcerpc_call_fn)dcerpc_netr_GetAnyDCName, (py_data_pack_fn)pack_py_netr_GetAnyDCName_args_in, (py_data_unpack_fn)unpack_py_netr_GetAnyDCName_args_out, 13, &ndr_table_netlogon },
	{ "netr_LogonControl2", "S.netr_LogonControl2(logon_server, function_code, level, data) -> query", (dcerpc_call_fn)dcerpc_netr_LogonControl2, (py_data_pack_fn)pack_py_netr_LogonControl2_args_in, (py_data_unpack_fn)unpack_py_netr_LogonControl2_args_out, 14, &ndr_table_netlogon },
	{ "netr_ServerAuthenticate2", "S.netr_ServerAuthenticate2(server_name, account_name, secure_channel_type, computer_name, credentials, negotiate_flags) -> (return_credentials, negotiate_flags)", (dcerpc_call_fn)dcerpc_netr_ServerAuthenticate2, (py_data_pack_fn)pack_py_netr_ServerAuthenticate2_args_in, (py_data_unpack_fn)unpack_py_netr_ServerAuthenticate2_args_out, 15, &ndr_table_netlogon },
	{ "netr_DatabaseSync2", "S.netr_DatabaseSync2(logon_server, computername, credential, return_authenticator, database_id, restart_state, sync_context, preferredmaximumlength) -> (return_authenticator, sync_context, delta_enum_array)", (dcerpc_call_fn)dcerpc_netr_DatabaseSync2, (py_data_pack_fn)pack_py_netr_DatabaseSync2_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseSync2_args_out, 16, &ndr_table_netlogon },
	{ "netr_DatabaseRedo", "S.netr_DatabaseRedo(logon_server, computername, credential, return_authenticator, change_log_entry, change_log_entry_size) -> (return_authenticator, delta_enum_array)", (dcerpc_call_fn)dcerpc_netr_DatabaseRedo, (py_data_pack_fn)pack_py_netr_DatabaseRedo_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseRedo_args_out, 17, &ndr_table_netlogon },
	{ "netr_LogonControl2Ex", "S.netr_LogonControl2Ex(logon_server, function_code, level, data) -> query", (dcerpc_call_fn)dcerpc_netr_LogonControl2Ex, (py_data_pack_fn)pack_py_netr_LogonControl2Ex_args_in, (py_data_unpack_fn)unpack_py_netr_LogonControl2Ex_args_out, 18, &ndr_table_netlogon },
	{ "netr_NetrEnumerateTrustedDomains", "S.netr_NetrEnumerateTrustedDomains(server_name) -> trusted_domains_blob", (dcerpc_call_fn)dcerpc_netr_NetrEnumerateTrustedDomains, (py_data_pack_fn)pack_py_netr_NetrEnumerateTrustedDomains_args_in, (py_data_unpack_fn)unpack_py_netr_NetrEnumerateTrustedDomains_args_out, 19, &ndr_table_netlogon },
	{ "netr_DsRGetDCName", "S.netr_DsRGetDCName(server_unc, domain_name, domain_guid, site_guid, flags) -> info", (dcerpc_call_fn)dcerpc_netr_DsRGetDCName, (py_data_pack_fn)pack_py_netr_DsRGetDCName_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetDCName_args_out, 20, &ndr_table_netlogon },
	{ "netr_LogonGetCapabilities", "S.netr_LogonGetCapabilities(server_name, computer_name, credential, return_authenticator, query_level) -> (return_authenticator, capabilities)", (dcerpc_call_fn)dcerpc_netr_LogonGetCapabilities, (py_data_pack_fn)pack_py_netr_LogonGetCapabilities_args_in, (py_data_unpack_fn)unpack_py_netr_LogonGetCapabilities_args_out, 21, &ndr_table_netlogon },
	{ "netr_NETRLOGONSETSERVICEBITS", NULL, (dcerpc_call_fn)dcerpc_netr_NETRLOGONSETSERVICEBITS, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 22, &ndr_table_netlogon },
	{ "netr_LogonGetTrustRid", "S.netr_LogonGetTrustRid(server_name, domain_name) -> rid", (dcerpc_call_fn)dcerpc_netr_LogonGetTrustRid, (py_data_pack_fn)pack_py_netr_LogonGetTrustRid_args_in, (py_data_unpack_fn)unpack_py_netr_LogonGetTrustRid_args_out, 23, &ndr_table_netlogon },
	{ "netr_NETRLOGONCOMPUTESERVERDIGEST", NULL, (dcerpc_call_fn)dcerpc_netr_NETRLOGONCOMPUTESERVERDIGEST, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 24, &ndr_table_netlogon },
	{ "netr_NETRLOGONCOMPUTECLIENTDIGEST", NULL, (dcerpc_call_fn)dcerpc_netr_NETRLOGONCOMPUTECLIENTDIGEST, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 25, &ndr_table_netlogon },
	{ "netr_ServerAuthenticate3", "S.netr_ServerAuthenticate3(server_name, account_name, secure_channel_type, computer_name, credentials, negotiate_flags) -> (return_credentials, negotiate_flags, rid)", (dcerpc_call_fn)dcerpc_netr_ServerAuthenticate3, (py_data_pack_fn)pack_py_netr_ServerAuthenticate3_args_in, (py_data_unpack_fn)unpack_py_netr_ServerAuthenticate3_args_out, 26, &ndr_table_netlogon },
	{ "netr_DsRGetDCNameEx", "S.netr_DsRGetDCNameEx(server_unc, domain_name, domain_guid, site_name, flags) -> info", (dcerpc_call_fn)dcerpc_netr_DsRGetDCNameEx, (py_data_pack_fn)pack_py_netr_DsRGetDCNameEx_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetDCNameEx_args_out, 27, &ndr_table_netlogon },
	{ "netr_DsRGetSiteName", "S.netr_DsRGetSiteName(computer_name) -> site", (dcerpc_call_fn)dcerpc_netr_DsRGetSiteName, (py_data_pack_fn)pack_py_netr_DsRGetSiteName_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetSiteName_args_out, 28, &ndr_table_netlogon },
	{ "netr_LogonGetDomainInfo", "S.netr_LogonGetDomainInfo(server_name, computer_name, credential, return_authenticator, level, query) -> (return_authenticator, info)", (dcerpc_call_fn)dcerpc_netr_LogonGetDomainInfo, (py_data_pack_fn)pack_py_netr_LogonGetDomainInfo_args_in, (py_data_unpack_fn)unpack_py_netr_LogonGetDomainInfo_args_out, 29, &ndr_table_netlogon },
	{ "netr_ServerPasswordSet2", "S.netr_ServerPasswordSet2(server_name, account_name, secure_channel_type, computer_name, credential, new_password) -> return_authenticator", (dcerpc_call_fn)dcerpc_netr_ServerPasswordSet2, (py_data_pack_fn)pack_py_netr_ServerPasswordSet2_args_in, (py_data_unpack_fn)unpack_py_netr_ServerPasswordSet2_args_out, 30, &ndr_table_netlogon },
	{ "netr_ServerPasswordGet", "S.netr_ServerPasswordGet(server_name, account_name, secure_channel_type, computer_name, credential) -> (return_authenticator, password)", (dcerpc_call_fn)dcerpc_netr_ServerPasswordGet, (py_data_pack_fn)pack_py_netr_ServerPasswordGet_args_in, (py_data_unpack_fn)unpack_py_netr_ServerPasswordGet_args_out, 31, &ndr_table_netlogon },
	{ "netr_NETRLOGONSENDTOSAM", NULL, (dcerpc_call_fn)dcerpc_netr_NETRLOGONSENDTOSAM, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 32, &ndr_table_netlogon },
	{ "netr_DsRAddressToSitenamesW", "S.netr_DsRAddressToSitenamesW(server_name, addresses) -> ctr", (dcerpc_call_fn)dcerpc_netr_DsRAddressToSitenamesW, (py_data_pack_fn)pack_py_netr_DsRAddressToSitenamesW_args_in, (py_data_unpack_fn)unpack_py_netr_DsRAddressToSitenamesW_args_out, 33, &ndr_table_netlogon },
	{ "netr_DsRGetDCNameEx2", "S.netr_DsRGetDCNameEx2(server_unc, client_account, mask, domain_name, domain_guid, site_name, flags) -> info", (dcerpc_call_fn)dcerpc_netr_DsRGetDCNameEx2, (py_data_pack_fn)pack_py_netr_DsRGetDCNameEx2_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetDCNameEx2_args_out, 34, &ndr_table_netlogon },
	{ "netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN", NULL, (dcerpc_call_fn)dcerpc_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, (py_data_pack_fn)NULL, (py_data_unpack_fn)NULL, 35, &ndr_table_netlogon },
	{ "netr_NetrEnumerateTrustedDomainsEx", "S.netr_NetrEnumerateTrustedDomainsEx(server_name) -> dom_trust_list", (dcerpc_call_fn)dcerpc_netr_NetrEnumerateTrustedDomainsEx, (py_data_pack_fn)pack_py_netr_NetrEnumerateTrustedDomainsEx_args_in, (py_data_unpack_fn)unpack_py_netr_NetrEnumerateTrustedDomainsEx_args_out, 36, &ndr_table_netlogon },
	{ "netr_DsRAddressToSitenamesExW", "S.netr_DsRAddressToSitenamesExW(server_name, addresses) -> ctr", (dcerpc_call_fn)dcerpc_netr_DsRAddressToSitenamesExW, (py_data_pack_fn)pack_py_netr_DsRAddressToSitenamesExW_args_in, (py_data_unpack_fn)unpack_py_netr_DsRAddressToSitenamesExW_args_out, 37, &ndr_table_netlogon },
	{ "netr_DsrGetDcSiteCoverageW", "S.netr_DsrGetDcSiteCoverageW(server_name) -> ctr", (dcerpc_call_fn)dcerpc_netr_DsrGetDcSiteCoverageW, (py_data_pack_fn)pack_py_netr_DsrGetDcSiteCoverageW_args_in, (py_data_unpack_fn)unpack_py_netr_DsrGetDcSiteCoverageW_args_out, 38, &ndr_table_netlogon },
	{ "netr_LogonSamLogonEx", "S.netr_LogonSamLogonEx(server_name, computer_name, logon_level, logon, validation_level, flags) -> (validation, authoritative, flags)", (dcerpc_call_fn)dcerpc_netr_LogonSamLogonEx, (py_data_pack_fn)pack_py_netr_LogonSamLogonEx_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogonEx_args_out, 39, &ndr_table_netlogon },
	{ "netr_DsrEnumerateDomainTrusts", "S.netr_DsrEnumerateDomainTrusts(server_name, trust_flags) -> trusts", (dcerpc_call_fn)dcerpc_netr_DsrEnumerateDomainTrusts, (py_data_pack_fn)pack_py_netr_DsrEnumerateDomainTrusts_args_in, (py_data_unpack_fn)unpack_py_netr_DsrEnumerateDomainTrusts_args_out, 40, &ndr_table_netlogon },
	{ "netr_DsrDeregisterDNSHostRecords", "S.netr_DsrDeregisterDNSHostRecords(server_name, domain, domain_guid, dsa_guid, dns_host) -> None", (dcerpc_call_fn)dcerpc_netr_DsrDeregisterDNSHostRecords, (py_data_pack_fn)pack_py_netr_DsrDeregisterDNSHostRecords_args_in, (py_data_unpack_fn)unpack_py_netr_DsrDeregisterDNSHostRecords_args_out, 41, &ndr_table_netlogon },
	{ "netr_ServerTrustPasswordsGet", "S.netr_ServerTrustPasswordsGet(server_name, account_name, secure_channel_type, computer_name, credential) -> (return_authenticator, password, password2)", (dcerpc_call_fn)dcerpc_netr_ServerTrustPasswordsGet, (py_data_pack_fn)pack_py_netr_ServerTrustPasswordsGet_args_in, (py_data_unpack_fn)unpack_py_netr_ServerTrustPasswordsGet_args_out, 42, &ndr_table_netlogon },
	{ "netr_DsRGetForestTrustInformation", "S.netr_DsRGetForestTrustInformation(server_name, trusted_domain_name, flags) -> forest_trust_info", (dcerpc_call_fn)dcerpc_netr_DsRGetForestTrustInformation, (py_data_pack_fn)pack_py_netr_DsRGetForestTrustInformation_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetForestTrustInformation_args_out, 43, &ndr_table_netlogon },
	{ "netr_GetForestTrustInformation", "S.netr_GetForestTrustInformation(server_name, trusted_domain_name, credential, flags) -> (return_authenticator, forest_trust_info)", (dcerpc_call_fn)dcerpc_netr_GetForestTrustInformation, (py_data_pack_fn)pack_py_netr_GetForestTrustInformation_args_in, (py_data_unpack_fn)unpack_py_netr_GetForestTrustInformation_args_out, 44, &ndr_table_netlogon },
	{ "netr_LogonSamLogonWithFlags", "S.netr_LogonSamLogonWithFlags(server_name, computer_name, credential, return_authenticator, logon_level, logon, validation_level, flags) -> (return_authenticator, validation, authoritative, flags)", (dcerpc_call_fn)dcerpc_netr_LogonSamLogonWithFlags, (py_data_pack_fn)pack_py_netr_LogonSamLogonWithFlags_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogonWithFlags_args_out, 45, &ndr_table_netlogon },
	{ "netr_ServerGetTrustInfo", "S.netr_ServerGetTrustInfo(server_name, account_name, secure_channel_type, computer_name, credential) -> (return_authenticator, new_owf_password, old_owf_password, trust_info)", (dcerpc_call_fn)dcerpc_netr_ServerGetTrustInfo, (py_data_pack_fn)pack_py_netr_ServerGetTrustInfo_args_in, (py_data_unpack_fn)unpack_py_netr_ServerGetTrustInfo_args_out, 46, &ndr_table_netlogon },
	{ NULL }
};

static PyObject *interface_netlogon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_netlogon);
}

static PyTypeObject netlogon_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netlogon",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "netlogon(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_netlogon_new,
};

static PyMethodDef netlogon_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initnetlogon(void)
{
	PyObject *m;
	PyObject *dep_misc;
	PyObject *dep_lsa;
	PyObject *dep_samr;
	PyObject *dep_security;
	PyObject *dep_nbt;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	dep_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_lsa == NULL)
		return;

	dep_samr = PyImport_ImportModule("samba.dcerpc.samr");
	if (dep_samr == NULL)
		return;

	dep_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_security == NULL)
		return;

	dep_nbt = PyImport_ImportModule("samba.dcerpc.nbt");
	if (dep_nbt == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	lsa_BinaryString_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "BinaryString");
	if (lsa_BinaryString_Type == NULL)
		return;

	samr_Password_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samr, "Password");
	if (samr_Password_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	samr_LogonHours_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samr, "LogonHours");
	if (samr_LogonHours_Type == NULL)
		return;

	samr_RidWithAttributeArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samr, "RidWithAttributeArray");
	if (samr_RidWithAttributeArray_Type == NULL)
		return;

	lsa_String_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "String");
	if (lsa_String_Type == NULL)
		return;

	lsa_StringLarge_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "StringLarge");
	if (lsa_StringLarge_Type == NULL)
		return;

	sec_desc_buf_Type = (PyTypeObject *)PyObject_GetAttrString(dep_security, "sec_desc_buf");
	if (sec_desc_buf_Type == NULL)
		return;

	lsa_SidArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "SidArray");
	if (lsa_SidArray_Type == NULL)
		return;

	lsa_ForestTrustInformation_Type = (PyTypeObject *)PyObject_GetAttrString(dep_lsa, "ForestTrustInformation");
	if (lsa_ForestTrustInformation_Type == NULL)
		return;

	if (PyType_Ready(&netr_UasInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_UasLogoffInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_AcctLockStr_Type) < 0)
		return;
	if (PyType_Ready(&netr_IdentityInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_PasswordInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_ChallengeResponse_Type) < 0)
		return;
	if (PyType_Ready(&netr_NetworkInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_GenericInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_UserSessionKey_Type) < 0)
		return;
	if (PyType_Ready(&netr_LMSessionKey_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamBaseInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamInfo2_Type) < 0)
		return;
	if (PyType_Ready(&netr_SidAttr_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamInfo3_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamInfo6_Type) < 0)
		return;
	if (PyType_Ready(&netr_PacInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_GenericInfo2_Type) < 0)
		return;
	if (PyType_Ready(&netr_Credential_Type) < 0)
		return;
	if (PyType_Ready(&netr_Authenticator_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DELETE_USER_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEY16_Type) < 0)
		return;
	if (PyType_Ready(&netr_PasswordHistory_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEYS2_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEY_UNION_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEYS_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_PRIVATE_INFO_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_USER_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DOMAIN_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_GROUP_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_RENAME_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_GROUP_MEMBER_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ALIAS_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ALIAS_MEMBER_Type) < 0)
		return;
	if (PyType_Ready(&netr_QUOTA_LIMITS_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_POLICY_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_TRUSTED_DOMAIN_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DELETE_TRUST_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ACCOUNT_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DELETE_ACCOUNT_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DELETE_SECRET_Type) < 0)
		return;
	if (PyType_Ready(&netr_CIPHER_VALUE_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_SECRET_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ENUM_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ENUM_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&netr_UAS_INFO_0_Type) < 0)
		return;
	if (PyType_Ready(&netr_AccountBuffer_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_1_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_2_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_3_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_4_Type) < 0)
		return;
	if (PyType_Ready(&netr_ChangeLogEntry_Type) < 0)
		return;
	if (PyType_Ready(&netr_Blob_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRGetDCNameInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainQuery1_Type) < 0)
		return;
	if (PyType_Ready(&netr_trust_extension_Type) < 0)
		return;
	if (PyType_Ready(&netr_trust_extension_container_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainTrustInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_LsaPolicyInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainInfo1_Type) < 0)
		return;
	if (PyType_Ready(&netr_CryptPassword_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRAddressToSitenamesWCtr_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRAddress_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainTrust_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainTrustList_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRAddressToSitenamesExWCtr_Type) < 0)
		return;
	if (PyType_Ready(&DcSitesCtr_Type) < 0)
		return;
	if (PyType_Ready(&netr_TrustInfo_Type) < 0)
		return;
	if (PyType_Ready(&netlogon_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&netlogon_InterfaceType, py_ndr_netlogon_methods))
		return;

#ifdef PY_NETR_UASINFO_PATCH
	PY_NETR_UASINFO_PATCH(&netr_UasInfo_Type);
#endif
#ifdef PY_NETR_UASLOGOFFINFO_PATCH
	PY_NETR_UASLOGOFFINFO_PATCH(&netr_UasLogoffInfo_Type);
#endif
#ifdef PY_NETR_ACCTLOCKSTR_PATCH
	PY_NETR_ACCTLOCKSTR_PATCH(&netr_AcctLockStr_Type);
#endif
#ifdef PY_NETR_IDENTITYINFO_PATCH
	PY_NETR_IDENTITYINFO_PATCH(&netr_IdentityInfo_Type);
#endif
#ifdef PY_NETR_PASSWORDINFO_PATCH
	PY_NETR_PASSWORDINFO_PATCH(&netr_PasswordInfo_Type);
#endif
#ifdef PY_NETR_CHALLENGERESPONSE_PATCH
	PY_NETR_CHALLENGERESPONSE_PATCH(&netr_ChallengeResponse_Type);
#endif
#ifdef PY_NETR_NETWORKINFO_PATCH
	PY_NETR_NETWORKINFO_PATCH(&netr_NetworkInfo_Type);
#endif
#ifdef PY_NETR_GENERICINFO_PATCH
	PY_NETR_GENERICINFO_PATCH(&netr_GenericInfo_Type);
#endif
#ifdef PY_NETR_USERSESSIONKEY_PATCH
	PY_NETR_USERSESSIONKEY_PATCH(&netr_UserSessionKey_Type);
#endif
#ifdef PY_NETR_LMSESSIONKEY_PATCH
	PY_NETR_LMSESSIONKEY_PATCH(&netr_LMSessionKey_Type);
#endif
#ifdef PY_NETR_SAMBASEINFO_PATCH
	PY_NETR_SAMBASEINFO_PATCH(&netr_SamBaseInfo_Type);
#endif
#ifdef PY_NETR_SAMINFO2_PATCH
	PY_NETR_SAMINFO2_PATCH(&netr_SamInfo2_Type);
#endif
#ifdef PY_NETR_SIDATTR_PATCH
	PY_NETR_SIDATTR_PATCH(&netr_SidAttr_Type);
#endif
#ifdef PY_NETR_SAMINFO3_PATCH
	PY_NETR_SAMINFO3_PATCH(&netr_SamInfo3_Type);
#endif
#ifdef PY_NETR_SAMINFO6_PATCH
	PY_NETR_SAMINFO6_PATCH(&netr_SamInfo6_Type);
#endif
#ifdef PY_NETR_PACINFO_PATCH
	PY_NETR_PACINFO_PATCH(&netr_PacInfo_Type);
#endif
#ifdef PY_NETR_GENERICINFO2_PATCH
	PY_NETR_GENERICINFO2_PATCH(&netr_GenericInfo2_Type);
#endif
#ifdef PY_NETR_CREDENTIAL_PATCH
	PY_NETR_CREDENTIAL_PATCH(&netr_Credential_Type);
#endif
#ifdef PY_NETR_AUTHENTICATOR_PATCH
	PY_NETR_AUTHENTICATOR_PATCH(&netr_Authenticator_Type);
#endif
#ifdef PY_NETR_DELTA_DELETE_USER_PATCH
	PY_NETR_DELTA_DELETE_USER_PATCH(&netr_DELTA_DELETE_USER_Type);
#endif
#ifdef PY_NETR_USER_KEY16_PATCH
	PY_NETR_USER_KEY16_PATCH(&netr_USER_KEY16_Type);
#endif
#ifdef PY_NETR_PASSWORDHISTORY_PATCH
	PY_NETR_PASSWORDHISTORY_PATCH(&netr_PasswordHistory_Type);
#endif
#ifdef PY_NETR_USER_KEYS2_PATCH
	PY_NETR_USER_KEYS2_PATCH(&netr_USER_KEYS2_Type);
#endif
#ifdef PY_NETR_USER_KEY_UNION_PATCH
	PY_NETR_USER_KEY_UNION_PATCH(&netr_USER_KEY_UNION_Type);
#endif
#ifdef PY_NETR_USER_KEYS_PATCH
	PY_NETR_USER_KEYS_PATCH(&netr_USER_KEYS_Type);
#endif
#ifdef PY_NETR_USER_PRIVATE_INFO_PATCH
	PY_NETR_USER_PRIVATE_INFO_PATCH(&netr_USER_PRIVATE_INFO_Type);
#endif
#ifdef PY_NETR_DELTA_USER_PATCH
	PY_NETR_DELTA_USER_PATCH(&netr_DELTA_USER_Type);
#endif
#ifdef PY_NETR_DELTA_DOMAIN_PATCH
	PY_NETR_DELTA_DOMAIN_PATCH(&netr_DELTA_DOMAIN_Type);
#endif
#ifdef PY_NETR_DELTA_GROUP_PATCH
	PY_NETR_DELTA_GROUP_PATCH(&netr_DELTA_GROUP_Type);
#endif
#ifdef PY_NETR_DELTA_RENAME_PATCH
	PY_NETR_DELTA_RENAME_PATCH(&netr_DELTA_RENAME_Type);
#endif
#ifdef PY_NETR_DELTA_GROUP_MEMBER_PATCH
	PY_NETR_DELTA_GROUP_MEMBER_PATCH(&netr_DELTA_GROUP_MEMBER_Type);
#endif
#ifdef PY_NETR_DELTA_ALIAS_PATCH
	PY_NETR_DELTA_ALIAS_PATCH(&netr_DELTA_ALIAS_Type);
#endif
#ifdef PY_NETR_DELTA_ALIAS_MEMBER_PATCH
	PY_NETR_DELTA_ALIAS_MEMBER_PATCH(&netr_DELTA_ALIAS_MEMBER_Type);
#endif
#ifdef PY_NETR_QUOTA_LIMITS_PATCH
	PY_NETR_QUOTA_LIMITS_PATCH(&netr_QUOTA_LIMITS_Type);
#endif
#ifdef PY_NETR_DELTA_POLICY_PATCH
	PY_NETR_DELTA_POLICY_PATCH(&netr_DELTA_POLICY_Type);
#endif
#ifdef PY_NETR_DELTA_TRUSTED_DOMAIN_PATCH
	PY_NETR_DELTA_TRUSTED_DOMAIN_PATCH(&netr_DELTA_TRUSTED_DOMAIN_Type);
#endif
#ifdef PY_NETR_DELTA_DELETE_TRUST_PATCH
	PY_NETR_DELTA_DELETE_TRUST_PATCH(&netr_DELTA_DELETE_TRUST_Type);
#endif
#ifdef PY_NETR_DELTA_ACCOUNT_PATCH
	PY_NETR_DELTA_ACCOUNT_PATCH(&netr_DELTA_ACCOUNT_Type);
#endif
#ifdef PY_NETR_DELTA_DELETE_ACCOUNT_PATCH
	PY_NETR_DELTA_DELETE_ACCOUNT_PATCH(&netr_DELTA_DELETE_ACCOUNT_Type);
#endif
#ifdef PY_NETR_DELTA_DELETE_SECRET_PATCH
	PY_NETR_DELTA_DELETE_SECRET_PATCH(&netr_DELTA_DELETE_SECRET_Type);
#endif
#ifdef PY_NETR_CIPHER_VALUE_PATCH
	PY_NETR_CIPHER_VALUE_PATCH(&netr_CIPHER_VALUE_Type);
#endif
#ifdef PY_NETR_DELTA_SECRET_PATCH
	PY_NETR_DELTA_SECRET_PATCH(&netr_DELTA_SECRET_Type);
#endif
#ifdef PY_NETR_DELTA_ENUM_PATCH
	PY_NETR_DELTA_ENUM_PATCH(&netr_DELTA_ENUM_Type);
#endif
#ifdef PY_NETR_DELTA_ENUM_ARRAY_PATCH
	PY_NETR_DELTA_ENUM_ARRAY_PATCH(&netr_DELTA_ENUM_ARRAY_Type);
#endif
#ifdef PY_NETR_UAS_INFO_0_PATCH
	PY_NETR_UAS_INFO_0_PATCH(&netr_UAS_INFO_0_Type);
#endif
#ifdef PY_NETR_ACCOUNTBUFFER_PATCH
	PY_NETR_ACCOUNTBUFFER_PATCH(&netr_AccountBuffer_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_1_PATCH
	PY_NETR_NETLOGON_INFO_1_PATCH(&netr_NETLOGON_INFO_1_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_2_PATCH
	PY_NETR_NETLOGON_INFO_2_PATCH(&netr_NETLOGON_INFO_2_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_3_PATCH
	PY_NETR_NETLOGON_INFO_3_PATCH(&netr_NETLOGON_INFO_3_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_4_PATCH
	PY_NETR_NETLOGON_INFO_4_PATCH(&netr_NETLOGON_INFO_4_Type);
#endif
#ifdef PY_NETR_CHANGELOGENTRY_PATCH
	PY_NETR_CHANGELOGENTRY_PATCH(&netr_ChangeLogEntry_Type);
#endif
#ifdef PY_NETR_BLOB_PATCH
	PY_NETR_BLOB_PATCH(&netr_Blob_Type);
#endif
#ifdef PY_NETR_DSRGETDCNAMEINFO_PATCH
	PY_NETR_DSRGETDCNAMEINFO_PATCH(&netr_DsRGetDCNameInfo_Type);
#endif
#ifdef PY_NETR_DOMAINQUERY1_PATCH
	PY_NETR_DOMAINQUERY1_PATCH(&netr_DomainQuery1_Type);
#endif
#ifdef PY_NETR_TRUST_EXTENSION_PATCH
	PY_NETR_TRUST_EXTENSION_PATCH(&netr_trust_extension_Type);
#endif
#ifdef PY_NETR_TRUST_EXTENSION_CONTAINER_PATCH
	PY_NETR_TRUST_EXTENSION_CONTAINER_PATCH(&netr_trust_extension_container_Type);
#endif
#ifdef PY_NETR_DOMAINTRUSTINFO_PATCH
	PY_NETR_DOMAINTRUSTINFO_PATCH(&netr_DomainTrustInfo_Type);
#endif
#ifdef PY_NETR_LSAPOLICYINFO_PATCH
	PY_NETR_LSAPOLICYINFO_PATCH(&netr_LsaPolicyInfo_Type);
#endif
#ifdef PY_NETR_DOMAININFO1_PATCH
	PY_NETR_DOMAININFO1_PATCH(&netr_DomainInfo1_Type);
#endif
#ifdef PY_NETR_CRYPTPASSWORD_PATCH
	PY_NETR_CRYPTPASSWORD_PATCH(&netr_CryptPassword_Type);
#endif
#ifdef PY_NETR_DSRADDRESSTOSITENAMESWCTR_PATCH
	PY_NETR_DSRADDRESSTOSITENAMESWCTR_PATCH(&netr_DsRAddressToSitenamesWCtr_Type);
#endif
#ifdef PY_NETR_DSRADDRESS_PATCH
	PY_NETR_DSRADDRESS_PATCH(&netr_DsRAddress_Type);
#endif
#ifdef PY_NETR_DOMAINTRUST_PATCH
	PY_NETR_DOMAINTRUST_PATCH(&netr_DomainTrust_Type);
#endif
#ifdef PY_NETR_DOMAINTRUSTLIST_PATCH
	PY_NETR_DOMAINTRUSTLIST_PATCH(&netr_DomainTrustList_Type);
#endif
#ifdef PY_NETR_DSRADDRESSTOSITENAMESEXWCTR_PATCH
	PY_NETR_DSRADDRESSTOSITENAMESEXWCTR_PATCH(&netr_DsRAddressToSitenamesExWCtr_Type);
#endif
#ifdef PY_DCSITESCTR_PATCH
	PY_DCSITESCTR_PATCH(&DcSitesCtr_Type);
#endif
#ifdef PY_NETR_TRUSTINFO_PATCH
	PY_NETR_TRUSTINFO_PATCH(&netr_TrustInfo_Type);
#endif
#ifdef PY_NETLOGON_PATCH
	PY_NETLOGON_PATCH(&netlogon_InterfaceType);
#endif

	m = Py_InitModule3("netlogon", netlogon_methods, "netlogon DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "NetlogonValidationSamInfo2", PyInt_FromLong(NetlogonValidationSamInfo2));
	PyModule_AddObject(m, "NETLOGON_NTLMV2_ENABLED", PyInt_FromLong(NETLOGON_NTLMV2_ENABLED));
	PyModule_AddObject(m, "NETLOGON_CTRL_REPL_FULL_SYNC", PyInt_FromLong(NETLOGON_CTRL_REPL_FULL_SYNC));
	PyModule_AddObject(m, "SYNCSTATE_DOMAIN_STATE", PyInt_FromLong(SYNCSTATE_DOMAIN_STATE));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_DOWNLEVEL", PyInt_FromLong(NETR_TRUST_TYPE_DOWNLEVEL));
	PyModule_AddObject(m, "NETLOGON_NEG_PASSWORD_SET2", PyInt_FromLong(NETLOGON_NEG_PASSWORD_SET2));
	PyModule_AddObject(m, "NETR_DELTA_RENAME_ALIAS", PyInt_FromLong(NETR_DELTA_RENAME_ALIAS));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_MIT_KRB5", PyInt_FromLong(NETR_TRUST_FLAG_MIT_KRB5));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_AES", PyInt_FromLong(NETR_TRUST_FLAG_AES));
	PyModule_AddObject(m, "DS_SERVER_DS", PyInt_FromLong(DS_SERVER_DS));
	PyModule_AddObject(m, "NETR_DELTA_USER", PyInt_FromLong(NETR_DELTA_USER));
	PyModule_AddObject(m, "DS_DIRECTORY_SERVICE_REQUIRED", PyInt_FromLong(DS_DIRECTORY_SERVICE_REQUIRED));
	PyModule_AddObject(m, "SYNCSTATE_SAM_DONE_STATE", PyInt_FromLong(SYNCSTATE_SAM_DONE_STATE));
	PyModule_AddObject(m, "DS_SERVER_NDNC", PyInt_FromLong(DS_SERVER_NDNC));
	PyModule_AddObject(m, "NETLOGON_NEG_PROMOTION_COUNT", PyInt_FromLong(NETLOGON_NEG_PROMOTION_COUNT));
	PyModule_AddObject(m, "NETLOGON_NEG_AUTHENTICATED_RPC_LSASS", PyInt_FromLong(NETLOGON_NEG_AUTHENTICATED_RPC_LSASS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_SYNCHRONIZE", PyInt_FromLong(NETLOGON_CONTROL_SYNCHRONIZE));
	PyModule_AddObject(m, "NETLOGON_NEG_MULTIPLE_SIDS", PyInt_FromLong(NETLOGON_NEG_MULTIPLE_SIDS));
	PyModule_AddObject(m, "NETLOGON_GUEST", PyInt_FromLong(NETLOGON_GUEST));
	PyModule_AddObject(m, "NetlogonGenericInformation", PyInt_FromLong(NetlogonGenericInformation));
	PyModule_AddObject(m, "SYNCSTATE_USER_STATE", PyInt_FromLong(SYNCSTATE_USER_STATE));
	PyModule_AddObject(m, "NETLOGON_NEG_CROSS_FOREST_TRUSTS", PyInt_FromLong(NETLOGON_NEG_CROSS_FOREST_TRUSTS));
	PyModule_AddObject(m, "NETLOGON_RESOURCE_GROUPS", PyInt_FromLong(NETLOGON_RESOURCE_GROUPS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TRUNCATE_LOG", PyInt_FromLong(NETLOGON_CONTROL_TRUNCATE_LOG));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY));
	PyModule_AddObject(m, "DS_RETURN_DNS_NAME", PyInt_FromLong(DS_RETURN_DNS_NAME));
	PyModule_AddObject(m, "DS_SERVER_TIMESERV", PyInt_FromLong(DS_SERVER_TIMESERV));
	PyModule_AddObject(m, "NETLOGON_CONTROL_QUERY_DNS_REG", PyInt_FromLong(NETLOGON_CONTROL_QUERY_DNS_REG));
	PyModule_AddObject(m, "NETLOGON_NEG_128BIT", PyInt_FromLong(NETLOGON_NEG_STRONG_KEYS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_SET_DBFLAG", PyInt_FromLong(NETLOGON_CONTROL_SET_DBFLAG));
	PyModule_AddObject(m, "NETLOGON_CTRL_REPL_NEEDED", PyInt_FromLong(NETLOGON_CTRL_REPL_NEEDED));
	PyModule_AddObject(m, "NETLOGON_SUBAUTH_SESSION_KEY", PyInt_FromLong(NETLOGON_SUBAUTH_SESSION_KEY));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TC_VERIFY", PyInt_FromLong(NETLOGON_CONTROL_TC_VERIFY));
	PyModule_AddObject(m, "NETLOGON_USED_LM_PASSWORD", PyInt_FromLong(NETLOGON_USED_LM_PASSWORD));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN));
	PyModule_AddObject(m, "DS_IP_REQUIRED", PyInt_FromLong(DS_IP_REQUIRED));
	PyModule_AddObject(m, "NETR_CHANGELOG_SID_INCLUDED", PyInt_FromLong(NETR_CHANGELOG_SID_INCLUDED));
	PyModule_AddObject(m, "SYNCSTATE_ALIAS_STATE", PyInt_FromLong(SYNCSTATE_ALIAS_STATE));
	PyModule_AddObject(m, "NETR_DELTA_ACCOUNT", PyInt_FromLong(NETR_DELTA_ACCOUNT));
	PyModule_AddObject(m, "NetlogonNetworkTransitiveInformation", PyInt_FromLong(NetlogonNetworkTransitiveInformation));
	PyModule_AddObject(m, "NETLOGON_NEG_GENERIC_PASSTHROUGH", PyInt_FromLong(NETLOGON_NEG_GENERIC_PASSTHROUGH));
	PyModule_AddObject(m, "NETLOGON_NEG_SCHANNEL", PyInt_FromLong(NETLOGON_NEG_AUTHENTICATED_RPC));
	PyModule_AddObject(m, "SYNCSTATE_UAS_BUILT_IN_GROUP_STATE", PyInt_FromLong(SYNCSTATE_UAS_BUILT_IN_GROUP_STATE));
	PyModule_AddObject(m, "NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL", PyInt_FromLong(NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_ALIAS", PyInt_FromLong(NETR_DELTA_DELETE_ALIAS));
	PyModule_AddObject(m, "DS_DIRECTORY_SERVICE_6_REQUIRED", PyInt_FromLong(DS_DIRECTORY_SERVICE_6_REQUIRED));
	PyModule_AddObject(m, "DS_SERVER_WRITABLE", PyInt_FromLong(DS_SERVER_WRITABLE));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL));
	PyModule_AddObject(m, "NETLOGON_NEG_STRONG_KEYS", PyInt_FromLong(NETLOGON_NEG_STRONG_KEYS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TRANSPORT_NOTIFY", PyInt_FromLong(NETLOGON_CONTROL_TRANSPORT_NOTIFY));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_SECRET", PyInt_FromLong(NETR_DELTA_DELETE_SECRET));
	PyModule_AddObject(m, "DS_DIRECTORY_SERVICE_PREFERRED", PyInt_FromLong(DS_DIRECTORY_SERVICE_PREFERRED));
	PyModule_AddObject(m, "DS_SERVER_CLOSEST", PyInt_FromLong(DS_SERVER_CLOSEST));
	PyModule_AddObject(m, "NETLOGON_CONTROL_QUERY", PyInt_FromLong(NETLOGON_CONTROL_QUERY));
	PyModule_AddObject(m, "DS_SERVER_GOOD_TIMESERV", PyInt_FromLong(DS_SERVER_GOOD_TIMESERV));
	PyModule_AddObject(m, "NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED", PyInt_FromLong(NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED));
	PyModule_AddObject(m, "NETLOGON_NEG_REDO", PyInt_FromLong(NETLOGON_NEG_REDO));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_PRIMARY", PyInt_FromLong(NETR_TRUST_FLAG_PRIMARY));
	PyModule_AddObject(m, "NETLOGON_CONTROL_PDC_REPLICATE", PyInt_FromLong(NETLOGON_CONTROL_PDC_REPLICATE));
	PyModule_AddObject(m, "DS_DNS_CONTROLLER", PyInt_FromLong(DS_DNS_CONTROLLER));
	PyModule_AddObject(m, "NETLOGON_NEG_DNS_DOMAIN_TRUSTS", PyInt_FromLong(NETLOGON_NEG_DNS_DOMAIN_TRUSTS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_CHANGE_PASSWORD", PyInt_FromLong(NETLOGON_CONTROL_CHANGE_PASSWORD));
	PyModule_AddObject(m, "NETLOGON_NEG_SUPPORTS_AES_SHA2", PyInt_FromLong(NETLOGON_NEG_SUPPORTS_AES_SHA2));
	PyModule_AddObject(m, "NETLOGON_CONTROL_REPLICATE", PyInt_FromLong(NETLOGON_CONTROL_REPLICATE));
	PyModule_AddObject(m, "NETLOGON_CACHED_ACCOUNT", PyInt_FromLong(NETLOGON_CACHED_ACCOUNT));
	PyModule_AddObject(m, "NETR_DELTA_ALIAS_MEMBER", PyInt_FromLong(NETR_DELTA_ALIAS_MEMBER));
	PyModule_AddObject(m, "DS_GOOD_TIMESERV_PREFERRED", PyInt_FromLong(DS_GOOD_TIMESERV_PREFERRED));
	PyModule_AddObject(m, "NETLOGON_NEG_CHANGELOG_BDC", PyInt_FromLong(NETLOGON_NEG_CHANGELOG_BDC));
	PyModule_AddObject(m, "NETR_DELTA_GROUP_MEMBER", PyInt_FromLong(NETR_DELTA_GROUP_MEMBER));
	PyModule_AddObject(m, "DS_SERVER_PDC", PyInt_FromLong(DS_SERVER_PDC));
	PyModule_AddObject(m, "DS_ONLY_LDAP_NEEDED", PyInt_FromLong(DS_ONLY_LDAP_NEEDED));
	PyModule_AddObject(m, "NETLOGON_NEG_GETDOMAININFO", PyInt_FromLong(NETLOGON_NEG_GETDOMAININFO));
	PyModule_AddObject(m, "NETLOGON_CTRL_REPL_IN_PROGRESS", PyInt_FromLong(NETLOGON_CTRL_REPL_IN_PROGRESS));
	PyModule_AddObject(m, "NETLOGON_NEG_RODC_PASSTHROUGH", PyInt_FromLong(NETLOGON_NEG_RODC_PASSTHROUGH));
	PyModule_AddObject(m, "NETLOGON_NEG_PERSISTENT_SAMREPL", PyInt_FromLong(NETLOGON_NEG_PERSISTENT_SAMREPL));
	PyModule_AddObject(m, "DS_DNS_DOMAIN", PyInt_FromLong(DS_DNS_DOMAIN));
	PyModule_AddObject(m, "DS_IS_FLAT_NAME", PyInt_FromLong(DS_IS_FLAT_NAME));
	PyModule_AddObject(m, "NETLOGON_NOENCRYPTION", PyInt_FromLong(NETLOGON_NOENCRYPTION));
	PyModule_AddObject(m, "NetlogonValidationGenericInfo2", PyInt_FromLong(NetlogonValidationGenericInfo2));
	PyModule_AddObject(m, "DS_SERVER_FULL_SECRET_DOMAIN_6", PyInt_FromLong(DS_SERVER_FULL_SECRET_DOMAIN_6));
	PyModule_AddObject(m, "NETR_DELTA_GROUP", PyInt_FromLong(NETR_DELTA_GROUP));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_MIT", PyInt_FromLong(NETR_TRUST_TYPE_MIT));
	PyModule_AddObject(m, "NetlogonServiceInformation", PyInt_FromLong(NetlogonServiceInformation));
	PyModule_AddObject(m, "DS_KDC_REQUIRED", PyInt_FromLong(DS_KDC_REQUIRED));
	PyModule_AddObject(m, "DS_GC_SERVER_REQUIRED", PyInt_FromLong(DS_GC_SERVER_REQUIRED));
	PyModule_AddObject(m, "NETLOGON_NEG_ACCOUNT_LOCKOUT", PyInt_FromLong(NETLOGON_NEG_ACCOUNT_LOCKOUT));
	PyModule_AddObject(m, "MSV1_0_UPDATE_LOGON_STATISTICS", PyInt_FromLong(MSV1_0_UPDATE_LOGON_STATISTICS));
	PyModule_AddObject(m, "MSV1_0_CLEARTEXT_PASSWORD_ALLOWED", PyInt_FromLong(MSV1_0_CLEARTEXT_PASSWORD_ALLOWED));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_ACCOUNT", PyInt_FromLong(NETR_DELTA_DELETE_ACCOUNT));
	PyModule_AddObject(m, "NetlogonServiceTransitiveInformation", PyInt_FromLong(NetlogonServiceTransitiveInformation));
	PyModule_AddObject(m, "MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT", PyInt_FromLong(MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT));
	PyModule_AddObject(m, "NETLOGON_CONTROL_FIND_USER", PyInt_FromLong(NETLOGON_CONTROL_FIND_USER));
	PyModule_AddObject(m, "NETR_WS_FLAG_HANDLES_SPN_UPDATE", PyInt_FromLong(NETR_WS_FLAG_HANDLES_SPN_UPDATE));
	PyModule_AddObject(m, "NETLOGON_SERVER_TRUST_ACCOUNT", PyInt_FromLong(NETLOGON_SERVER_TRUST_ACCOUNT));
	PyModule_AddObject(m, "NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL", PyInt_FromLong(NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL));
	PyModule_AddObject(m, "NETLOGON_NEG_CONCURRENT_RPC", PyInt_FromLong(NETLOGON_NEG_CONCURRENT_RPC));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_NATIVE", PyInt_FromLong(NETR_TRUST_FLAG_NATIVE));
	PyModule_AddObject(m, "DS_FORCE_REDISCOVERY", PyInt_FromLong(DS_FORCE_REDISCOVERY));
	PyModule_AddObject(m, "NetlogonValidationSamInfo", PyInt_FromLong(NetlogonValidationSamInfo));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_DCE", PyInt_FromLong(NETR_TRUST_TYPE_DCE));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TC_QUERY", PyInt_FromLong(NETLOGON_CONTROL_TC_QUERY));
	PyModule_AddObject(m, "NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS", PyInt_FromLong(NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS));
	PyModule_AddObject(m, "NETR_DELTA_DOMAIN", PyInt_FromLong(NETR_DELTA_DOMAIN));
	PyModule_AddObject(m, "NETR_CHANGELOG_CHANGED_PASSWORD", PyInt_FromLong(NETR_CHANGELOG_CHANGED_PASSWORD));
	PyModule_AddObject(m, "NetlogonInteractiveInformation", PyInt_FromLong(NetlogonInteractiveInformation));
	PyModule_AddObject(m, "NETLOGON_CONTROL_BACKUP_CHANGE_LOG", PyInt_FromLong(NETLOGON_CONTROL_BACKUP_CHANGE_LOG));
	PyModule_AddObject(m, "NETR_DELTA_TRUSTED_DOMAIN", PyInt_FromLong(NETR_DELTA_TRUSTED_DOMAIN));
	PyModule_AddObject(m, "NETR_CHANGELOG_NAME_INCLUDED", PyInt_FromLong(NETR_CHANGELOG_NAME_INCLUDED));
	PyModule_AddObject(m, "DS_ADDRESS_TYPE_INET", PyInt_FromLong(DS_ADDRESS_TYPE_INET));
	PyModule_AddObject(m, "NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION", PyInt_FromLong(NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION));
	PyModule_AddObject(m, "DS_RETURN_FLAT_NAME", PyInt_FromLong(DS_RETURN_FLAT_NAME));
	PyModule_AddObject(m, "NetlogonValidationSamInfo4", PyInt_FromLong(NetlogonValidationSamInfo4));
	PyModule_AddObject(m, "NetlogonNetworkInformation", PyInt_FromLong(NetlogonNetworkInformation));
	PyModule_AddObject(m, "NETLOGON_GRACE_LOGON", PyInt_FromLong(NETLOGON_GRACE_LOGON));
	PyModule_AddObject(m, "MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT", PyInt_FromLong(MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT));
	PyModule_AddObject(m, "NETLOGON_CONTROL_REDISCOVER", PyInt_FromLong(NETLOGON_CONTROL_REDISCOVER));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION));
	PyModule_AddObject(m, "NETLOGON_NEG_FULL_SYNC_REPL", PyInt_FromLong(NETLOGON_NEG_FULL_SYNC_REPL));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_USER2", PyInt_FromLong(NETR_DELTA_DELETE_USER2));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_GROUP2", PyInt_FromLong(NETR_DELTA_DELETE_GROUP2));
	PyModule_AddObject(m, "NETR_DELTA_SECRET", PyInt_FromLong(NETR_DELTA_SECRET));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_TRUST", PyInt_FromLong(NETR_DELTA_DELETE_TRUST));
	PyModule_AddObject(m, "MSV1_0_RETURN_USER_PARAMETERS", PyInt_FromLong(MSV1_0_RETURN_USER_PARAMETERS));
	PyModule_AddObject(m, "NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL", PyInt_FromLong(NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL));
	PyModule_AddObject(m, "DS_IS_DNS_NAME", PyInt_FromLong(DS_IS_DNS_NAME));
	PyModule_AddObject(m, "NETLOGON_NEG_ARCFOUR", PyInt_FromLong(NETLOGON_NEG_ARCFOUR));
	PyModule_AddObject(m, "SYNCSTATE_ALIAS_MEMBER_STATE", PyInt_FromLong(SYNCSTATE_ALIAS_MEMBER_STATE));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE));
	PyModule_AddObject(m, "DSGETDC_VALID_FLAGS", PyInt_FromLong((DS_FORCE_REDISCOVERY|DS_DIRECTORY_SERVICE_REQUIRED|DS_DIRECTORY_SERVICE_PREFERRED|DS_GC_SERVER_REQUIRED|DS_PDC_REQUIRED|DS_BACKGROUND_ONLY|DS_IP_REQUIRED|DS_KDC_REQUIRED|DS_TIMESERV_REQUIRED|DS_WRITABLE_REQUIRED|DS_GOOD_TIMESERV_PREFERRED|DS_AVOID_SELF|DS_ONLY_LDAP_NEEDED|DS_IS_FLAT_NAME|DS_IS_DNS_NAME|DS_RETURN_FLAT_NAME|DS_RETURN_DNS_NAME)));
	PyModule_AddObject(m, "DS_SERVER_SELECT_SECRET_DOMAIN_6", PyInt_FromLong(DS_SERVER_SELECT_SECRET_DOMAIN_6));
	PyModule_AddObject(m, "MSV1_0_RETURN_PROFILE_PATH", PyInt_FromLong(MSV1_0_RETURN_PROFILE_PATH));
	PyModule_AddObject(m, "SYNCSTATE_GROUP_STATE", PyInt_FromLong(SYNCSTATE_GROUP_STATE));
	PyModule_AddObject(m, "DS_WRITABLE_REQUIRED", PyInt_FromLong(DS_WRITABLE_REQUIRED));
	PyModule_AddObject(m, "DS_SERVER_GC", PyInt_FromLong(DS_SERVER_GC));
	PyModule_AddObject(m, "DS_GFTI_UPDATE_TDO", PyInt_FromLong(0x1));
	PyModule_AddObject(m, "NetlogonInteractiveTransitiveInformation", PyInt_FromLong(NetlogonInteractiveTransitiveInformation));
	PyModule_AddObject(m, "NETR_DELTA_POLICY", PyInt_FromLong(NETR_DELTA_POLICY));
	PyModule_AddObject(m, "NETLOGON_NEG_SEND_PASSWORD_INFO_PDC", PyInt_FromLong(NETLOGON_NEG_SEND_PASSWORD_INFO_PDC));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_USER", PyInt_FromLong(NETR_DELTA_DELETE_USER));
	PyModule_AddObject(m, "DS_ADDRESS_TYPE_NETBIOS", PyInt_FromLong(DS_ADDRESS_TYPE_NETBIOS));
	PyModule_AddObject(m, "NETLOGON_NEG_TRANSITIVE_TRUSTS", PyInt_FromLong(NETLOGON_NEG_TRANSITIVE_TRUSTS));
	PyModule_AddObject(m, "DS_DNS_FOREST", PyInt_FromLong(DS_DNS_FOREST));
	PyModule_AddObject(m, "DS_SERVER_LDAP", PyInt_FromLong(DS_SERVER_LDAP));
	PyModule_AddObject(m, "DS_SERVER_KDC", PyInt_FromLong(DS_SERVER_KDC));
	PyModule_AddObject(m, "NETR_CHANGELOG_FIRST_PROMOTION_OBJ", PyInt_FromLong(NETR_CHANGELOG_FIRST_PROMOTION_OBJ));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_OUTBOUND", PyInt_FromLong(NETR_TRUST_FLAG_OUTBOUND));
	PyModule_AddObject(m, "DS_TRY_NEXTCLOSEST_SITE", PyInt_FromLong(DS_TRY_NEXTCLOSEST_SITE));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_TREEROOT", PyInt_FromLong(NETR_TRUST_FLAG_TREEROOT));
	PyModule_AddObject(m, "NETR_DELTA_RENAME_GROUP", PyInt_FromLong(NETR_DELTA_RENAME_GROUP));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_INBOUND", PyInt_FromLong(NETR_TRUST_FLAG_INBOUND));
	PyModule_AddObject(m, "SYNCSTATE_GROUP_MEMBER_STATE", PyInt_FromLong(SYNCSTATE_GROUP_MEMBER_STATE));
	PyModule_AddObject(m, "DS_BACKGROUND_ONLY", PyInt_FromLong(DS_BACKGROUND_ONLY));
	PyModule_AddObject(m, "NETLOGON_CONTROL_FORCE_DNS_REG", PyInt_FromLong(NETLOGON_CONTROL_FORCE_DNS_REG));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_UPLEVEL", PyInt_FromLong(NETR_TRUST_TYPE_UPLEVEL));
	PyModule_AddObject(m, "NETLOGON_PROFILE_PATH_RETURNED", PyInt_FromLong(NETLOGON_PROFILE_PATH_RETURNED));
	PyModule_AddObject(m, "DS_PDC_REQUIRED", PyInt_FromLong(DS_PDC_REQUIRED));
	PyModule_AddObject(m, "SYNCSTATE_NORMAL_STATE", PyInt_FromLong(SYNCSTATE_NORMAL_STATE));
	PyModule_AddObject(m, "NETLOGON_CONTROL_BREAKPOINT", PyInt_FromLong(NETLOGON_CONTROL_BREAKPOINT));
	PyModule_AddObject(m, "DS_TIMESERV_REQUIRED", PyInt_FromLong(DS_TIMESERV_REQUIRED));
	PyModule_AddObject(m, "NETR_DELTA_RENAME_USER", PyInt_FromLong(NETR_DELTA_RENAME_USER));
	PyModule_AddObject(m, "DS_AVOID_SELF", PyInt_FromLong(DS_AVOID_SELF));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_GROUP", PyInt_FromLong(NETR_DELTA_DELETE_GROUP));
	PyModule_AddObject(m, "NetlogonValidationUasInfo", PyInt_FromLong(NetlogonValidationUasInfo));
	PyModule_AddObject(m, "NETLOGON_EXTRA_SIDS", PyInt_FromLong(NETLOGON_EXTRA_SIDS));
	PyModule_AddObject(m, "NETR_DELTA_ALIAS", PyInt_FromLong(NETR_DELTA_ALIAS));
	PyModule_AddObject(m, "NETR_DELTA_MODIFY_COUNT", PyInt_FromLong(NETR_DELTA_MODIFY_COUNT));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_WITHIN_FOREST", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_WITHIN_FOREST));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_IN_FOREST", PyInt_FromLong(NETR_TRUST_FLAG_IN_FOREST));
	PyModule_AddObject(m, "NETLOGON_NEG_AUTHENTICATED_RPC", PyInt_FromLong(NETLOGON_NEG_AUTHENTICATED_RPC));
	Py_INCREF((PyObject *)&netr_UasInfo_Type);
	PyModule_AddObject(m, "netr_UasInfo", (PyObject *)&netr_UasInfo_Type);
	Py_INCREF((PyObject *)&netr_UasLogoffInfo_Type);
	PyModule_AddObject(m, "netr_UasLogoffInfo", (PyObject *)&netr_UasLogoffInfo_Type);
	Py_INCREF((PyObject *)&netr_AcctLockStr_Type);
	PyModule_AddObject(m, "netr_AcctLockStr", (PyObject *)&netr_AcctLockStr_Type);
	Py_INCREF((PyObject *)&netr_IdentityInfo_Type);
	PyModule_AddObject(m, "netr_IdentityInfo", (PyObject *)&netr_IdentityInfo_Type);
	Py_INCREF((PyObject *)&netr_PasswordInfo_Type);
	PyModule_AddObject(m, "netr_PasswordInfo", (PyObject *)&netr_PasswordInfo_Type);
	Py_INCREF((PyObject *)&netr_ChallengeResponse_Type);
	PyModule_AddObject(m, "netr_ChallengeResponse", (PyObject *)&netr_ChallengeResponse_Type);
	Py_INCREF((PyObject *)&netr_NetworkInfo_Type);
	PyModule_AddObject(m, "netr_NetworkInfo", (PyObject *)&netr_NetworkInfo_Type);
	Py_INCREF((PyObject *)&netr_GenericInfo_Type);
	PyModule_AddObject(m, "netr_GenericInfo", (PyObject *)&netr_GenericInfo_Type);
	Py_INCREF((PyObject *)&netr_UserSessionKey_Type);
	PyModule_AddObject(m, "netr_UserSessionKey", (PyObject *)&netr_UserSessionKey_Type);
	Py_INCREF((PyObject *)&netr_LMSessionKey_Type);
	PyModule_AddObject(m, "netr_LMSessionKey", (PyObject *)&netr_LMSessionKey_Type);
	Py_INCREF((PyObject *)&netr_SamBaseInfo_Type);
	PyModule_AddObject(m, "netr_SamBaseInfo", (PyObject *)&netr_SamBaseInfo_Type);
	Py_INCREF((PyObject *)&netr_SamInfo2_Type);
	PyModule_AddObject(m, "netr_SamInfo2", (PyObject *)&netr_SamInfo2_Type);
	Py_INCREF((PyObject *)&netr_SidAttr_Type);
	PyModule_AddObject(m, "netr_SidAttr", (PyObject *)&netr_SidAttr_Type);
	Py_INCREF((PyObject *)&netr_SamInfo3_Type);
	PyModule_AddObject(m, "netr_SamInfo3", (PyObject *)&netr_SamInfo3_Type);
	Py_INCREF((PyObject *)&netr_SamInfo6_Type);
	PyModule_AddObject(m, "netr_SamInfo6", (PyObject *)&netr_SamInfo6_Type);
	Py_INCREF((PyObject *)&netr_PacInfo_Type);
	PyModule_AddObject(m, "netr_PacInfo", (PyObject *)&netr_PacInfo_Type);
	Py_INCREF((PyObject *)&netr_GenericInfo2_Type);
	PyModule_AddObject(m, "netr_GenericInfo2", (PyObject *)&netr_GenericInfo2_Type);
	Py_INCREF((PyObject *)&netr_Credential_Type);
	PyModule_AddObject(m, "netr_Credential", (PyObject *)&netr_Credential_Type);
	Py_INCREF((PyObject *)&netr_Authenticator_Type);
	PyModule_AddObject(m, "netr_Authenticator", (PyObject *)&netr_Authenticator_Type);
	Py_INCREF((PyObject *)&netr_DELTA_DELETE_USER_Type);
	PyModule_AddObject(m, "netr_DELTA_DELETE_USER", (PyObject *)&netr_DELTA_DELETE_USER_Type);
	Py_INCREF((PyObject *)&netr_USER_KEY16_Type);
	PyModule_AddObject(m, "netr_USER_KEY16", (PyObject *)&netr_USER_KEY16_Type);
	Py_INCREF((PyObject *)&netr_PasswordHistory_Type);
	PyModule_AddObject(m, "netr_PasswordHistory", (PyObject *)&netr_PasswordHistory_Type);
	Py_INCREF((PyObject *)&netr_USER_KEYS2_Type);
	PyModule_AddObject(m, "netr_USER_KEYS2", (PyObject *)&netr_USER_KEYS2_Type);
	Py_INCREF((PyObject *)&netr_USER_KEY_UNION_Type);
	PyModule_AddObject(m, "netr_USER_KEY_UNION", (PyObject *)&netr_USER_KEY_UNION_Type);
	Py_INCREF((PyObject *)&netr_USER_KEYS_Type);
	PyModule_AddObject(m, "netr_USER_KEYS", (PyObject *)&netr_USER_KEYS_Type);
	Py_INCREF((PyObject *)&netr_USER_PRIVATE_INFO_Type);
	PyModule_AddObject(m, "netr_USER_PRIVATE_INFO", (PyObject *)&netr_USER_PRIVATE_INFO_Type);
	Py_INCREF((PyObject *)&netr_DELTA_USER_Type);
	PyModule_AddObject(m, "netr_DELTA_USER", (PyObject *)&netr_DELTA_USER_Type);
	Py_INCREF((PyObject *)&netr_DELTA_DOMAIN_Type);
	PyModule_AddObject(m, "netr_DELTA_DOMAIN", (PyObject *)&netr_DELTA_DOMAIN_Type);
	Py_INCREF((PyObject *)&netr_DELTA_GROUP_Type);
	PyModule_AddObject(m, "netr_DELTA_GROUP", (PyObject *)&netr_DELTA_GROUP_Type);
	Py_INCREF((PyObject *)&netr_DELTA_RENAME_Type);
	PyModule_AddObject(m, "netr_DELTA_RENAME", (PyObject *)&netr_DELTA_RENAME_Type);
	Py_INCREF((PyObject *)&netr_DELTA_GROUP_MEMBER_Type);
	PyModule_AddObject(m, "netr_DELTA_GROUP_MEMBER", (PyObject *)&netr_DELTA_GROUP_MEMBER_Type);
	Py_INCREF((PyObject *)&netr_DELTA_ALIAS_Type);
	PyModule_AddObject(m, "netr_DELTA_ALIAS", (PyObject *)&netr_DELTA_ALIAS_Type);
	Py_INCREF((PyObject *)&netr_DELTA_ALIAS_MEMBER_Type);
	PyModule_AddObject(m, "netr_DELTA_ALIAS_MEMBER", (PyObject *)&netr_DELTA_ALIAS_MEMBER_Type);
	Py_INCREF((PyObject *)&netr_QUOTA_LIMITS_Type);
	PyModule_AddObject(m, "netr_QUOTA_LIMITS", (PyObject *)&netr_QUOTA_LIMITS_Type);
	Py_INCREF((PyObject *)&netr_DELTA_POLICY_Type);
	PyModule_AddObject(m, "netr_DELTA_POLICY", (PyObject *)&netr_DELTA_POLICY_Type);
	Py_INCREF((PyObject *)&netr_DELTA_TRUSTED_DOMAIN_Type);
	PyModule_AddObject(m, "netr_DELTA_TRUSTED_DOMAIN", (PyObject *)&netr_DELTA_TRUSTED_DOMAIN_Type);
	Py_INCREF((PyObject *)&netr_DELTA_DELETE_TRUST_Type);
	PyModule_AddObject(m, "netr_DELTA_DELETE_TRUST", (PyObject *)&netr_DELTA_DELETE_TRUST_Type);
	Py_INCREF((PyObject *)&netr_DELTA_ACCOUNT_Type);
	PyModule_AddObject(m, "netr_DELTA_ACCOUNT", (PyObject *)&netr_DELTA_ACCOUNT_Type);
	Py_INCREF((PyObject *)&netr_DELTA_DELETE_ACCOUNT_Type);
	PyModule_AddObject(m, "netr_DELTA_DELETE_ACCOUNT", (PyObject *)&netr_DELTA_DELETE_ACCOUNT_Type);
	Py_INCREF((PyObject *)&netr_DELTA_DELETE_SECRET_Type);
	PyModule_AddObject(m, "netr_DELTA_DELETE_SECRET", (PyObject *)&netr_DELTA_DELETE_SECRET_Type);
	Py_INCREF((PyObject *)&netr_CIPHER_VALUE_Type);
	PyModule_AddObject(m, "netr_CIPHER_VALUE", (PyObject *)&netr_CIPHER_VALUE_Type);
	Py_INCREF((PyObject *)&netr_DELTA_SECRET_Type);
	PyModule_AddObject(m, "netr_DELTA_SECRET", (PyObject *)&netr_DELTA_SECRET_Type);
	Py_INCREF((PyObject *)&netr_DELTA_ENUM_Type);
	PyModule_AddObject(m, "netr_DELTA_ENUM", (PyObject *)&netr_DELTA_ENUM_Type);
	Py_INCREF((PyObject *)&netr_DELTA_ENUM_ARRAY_Type);
	PyModule_AddObject(m, "netr_DELTA_ENUM_ARRAY", (PyObject *)&netr_DELTA_ENUM_ARRAY_Type);
	Py_INCREF((PyObject *)&netr_UAS_INFO_0_Type);
	PyModule_AddObject(m, "netr_UAS_INFO_0", (PyObject *)&netr_UAS_INFO_0_Type);
	Py_INCREF((PyObject *)&netr_AccountBuffer_Type);
	PyModule_AddObject(m, "netr_AccountBuffer", (PyObject *)&netr_AccountBuffer_Type);
	Py_INCREF((PyObject *)&netr_NETLOGON_INFO_1_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_1", (PyObject *)&netr_NETLOGON_INFO_1_Type);
	Py_INCREF((PyObject *)&netr_NETLOGON_INFO_2_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_2", (PyObject *)&netr_NETLOGON_INFO_2_Type);
	Py_INCREF((PyObject *)&netr_NETLOGON_INFO_3_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_3", (PyObject *)&netr_NETLOGON_INFO_3_Type);
	Py_INCREF((PyObject *)&netr_NETLOGON_INFO_4_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_4", (PyObject *)&netr_NETLOGON_INFO_4_Type);
	Py_INCREF((PyObject *)&netr_ChangeLogEntry_Type);
	PyModule_AddObject(m, "netr_ChangeLogEntry", (PyObject *)&netr_ChangeLogEntry_Type);
	Py_INCREF((PyObject *)&netr_Blob_Type);
	PyModule_AddObject(m, "netr_Blob", (PyObject *)&netr_Blob_Type);
	Py_INCREF((PyObject *)&netr_DsRGetDCNameInfo_Type);
	PyModule_AddObject(m, "netr_DsRGetDCNameInfo", (PyObject *)&netr_DsRGetDCNameInfo_Type);
	Py_INCREF((PyObject *)&netr_DomainQuery1_Type);
	PyModule_AddObject(m, "netr_DomainQuery1", (PyObject *)&netr_DomainQuery1_Type);
	Py_INCREF((PyObject *)&netr_trust_extension_Type);
	PyModule_AddObject(m, "netr_trust_extension", (PyObject *)&netr_trust_extension_Type);
	Py_INCREF((PyObject *)&netr_trust_extension_container_Type);
	PyModule_AddObject(m, "netr_trust_extension_container", (PyObject *)&netr_trust_extension_container_Type);
	Py_INCREF((PyObject *)&netr_DomainTrustInfo_Type);
	PyModule_AddObject(m, "netr_DomainTrustInfo", (PyObject *)&netr_DomainTrustInfo_Type);
	Py_INCREF((PyObject *)&netr_LsaPolicyInfo_Type);
	PyModule_AddObject(m, "netr_LsaPolicyInfo", (PyObject *)&netr_LsaPolicyInfo_Type);
	Py_INCREF((PyObject *)&netr_DomainInfo1_Type);
	PyModule_AddObject(m, "netr_DomainInfo1", (PyObject *)&netr_DomainInfo1_Type);
	Py_INCREF((PyObject *)&netr_CryptPassword_Type);
	PyModule_AddObject(m, "netr_CryptPassword", (PyObject *)&netr_CryptPassword_Type);
	Py_INCREF((PyObject *)&netr_DsRAddressToSitenamesWCtr_Type);
	PyModule_AddObject(m, "netr_DsRAddressToSitenamesWCtr", (PyObject *)&netr_DsRAddressToSitenamesWCtr_Type);
	Py_INCREF((PyObject *)&netr_DsRAddress_Type);
	PyModule_AddObject(m, "netr_DsRAddress", (PyObject *)&netr_DsRAddress_Type);
	Py_INCREF((PyObject *)&netr_DomainTrust_Type);
	PyModule_AddObject(m, "netr_DomainTrust", (PyObject *)&netr_DomainTrust_Type);
	Py_INCREF((PyObject *)&netr_DomainTrustList_Type);
	PyModule_AddObject(m, "netr_DomainTrustList", (PyObject *)&netr_DomainTrustList_Type);
	Py_INCREF((PyObject *)&netr_DsRAddressToSitenamesExWCtr_Type);
	PyModule_AddObject(m, "netr_DsRAddressToSitenamesExWCtr", (PyObject *)&netr_DsRAddressToSitenamesExWCtr_Type);
	Py_INCREF((PyObject *)&DcSitesCtr_Type);
	PyModule_AddObject(m, "DcSitesCtr", (PyObject *)&DcSitesCtr_Type);
	Py_INCREF((PyObject *)&netr_TrustInfo_Type);
	PyModule_AddObject(m, "netr_TrustInfo", (PyObject *)&netr_TrustInfo_Type);
	Py_INCREF((PyObject *)&netlogon_InterfaceType);
	PyModule_AddObject(m, "netlogon", (PyObject *)&netlogon_InterfaceType);
#ifdef PY_MOD_NETLOGON_PATCH
	PY_MOD_NETLOGON_PATCH(m);
#endif

}
