
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_dcerpc.h"
#include "../librpc/gen_ndr/ndr_dcerpc_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dcerpc_ctx_list_Type;
staticforward PyTypeObject dcerpc_bind_Type;
staticforward PyTypeObject dcerpc_empty_Type;
staticforward PyTypeObject dcerpc_request_Type;
staticforward PyTypeObject dcerpc_ack_ctx_Type;
staticforward PyTypeObject dcerpc_bind_ack_Type;
staticforward PyTypeObject dcerpc_bind_nak_versions_Type;
staticforward PyTypeObject dcerpc_bind_nak_Type;
staticforward PyTypeObject dcerpc_response_Type;
staticforward PyTypeObject dcerpc_fault_Type;
staticforward PyTypeObject dcerpc_auth_Type;
staticforward PyTypeObject dcerpc_auth3_Type;
staticforward PyTypeObject dcerpc_orphaned_Type;
staticforward PyTypeObject dcerpc_co_cancel_Type;
staticforward PyTypeObject dcerpc_cl_cancel_Type;
staticforward PyTypeObject dcerpc_cancel_ack_Type;
staticforward PyTypeObject dcerpc_fack_Type;
staticforward PyTypeObject dcerpc_ack_Type;
staticforward PyTypeObject dcerpc_ping_Type;
staticforward PyTypeObject dcerpc_shutdown_Type;
staticforward PyTypeObject dcerpc_working_Type;
staticforward PyTypeObject ncacn_packet_Type;
staticforward PyTypeObject ncadg_packet_Type;

static PyTypeObject *ndr_syntax_id_Type;
static PyTypeObject *GUID_Type;

static PyObject *py_dcerpc_ctx_list_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_ctx_list_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_num_transfer_syntaxes(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(obj);
	PyObject *py_num_transfer_syntaxes;
	py_num_transfer_syntaxes = PyInt_FromLong(object->num_transfer_syntaxes);
	return py_num_transfer_syntaxes;
}

static int py_dcerpc_ctx_list_set_num_transfer_syntaxes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_transfer_syntaxes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_abstract_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(obj);
	PyObject *py_abstract_syntax;
	py_abstract_syntax = py_talloc_import_ex(ndr_syntax_id_Type, py_talloc_get_mem_ctx(obj), &object->abstract_syntax);
	return py_abstract_syntax;
}

static int py_dcerpc_ctx_list_set_abstract_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	memcpy(&object->abstract_syntax, py_talloc_get_ptr(value), sizeof(object->abstract_syntax));
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_transfer_syntaxes(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(obj);
	PyObject *py_transfer_syntaxes;
	py_transfer_syntaxes = PyList_New(object->num_transfer_syntaxes);
	if (py_transfer_syntaxes == NULL) {
		return NULL;
	}
	{
		int transfer_syntaxes_cntr_0;
		for (transfer_syntaxes_cntr_0 = 0; transfer_syntaxes_cntr_0 < object->num_transfer_syntaxes; transfer_syntaxes_cntr_0++) {
			PyObject *py_transfer_syntaxes_0;
			py_transfer_syntaxes_0 = py_talloc_import_ex(ndr_syntax_id_Type, object->transfer_syntaxes, &object->transfer_syntaxes[transfer_syntaxes_cntr_0]);
			PyList_SetItem(py_transfer_syntaxes, transfer_syntaxes_cntr_0, py_transfer_syntaxes_0);
		}
	}
	return py_transfer_syntaxes;
}

static int py_dcerpc_ctx_list_set_transfer_syntaxes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int transfer_syntaxes_cntr_0;
		object->transfer_syntaxes = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->transfer_syntaxes, PyList_Size(value));
		for (transfer_syntaxes_cntr_0 = 0; transfer_syntaxes_cntr_0 < PyList_Size(value); transfer_syntaxes_cntr_0++) {
			PY_CHECK_TYPE(ndr_syntax_id_Type, PyList_GetItem(value, transfer_syntaxes_cntr_0), return -1;);
			memcpy(&object->transfer_syntaxes[transfer_syntaxes_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, transfer_syntaxes_cntr_0)), sizeof(object->transfer_syntaxes[transfer_syntaxes_cntr_0]));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_ctx_list_getsetters[] = {
	{ discard_const_p(char, "context_id"), py_dcerpc_ctx_list_get_context_id, py_dcerpc_ctx_list_set_context_id },
	{ discard_const_p(char, "num_transfer_syntaxes"), py_dcerpc_ctx_list_get_num_transfer_syntaxes, py_dcerpc_ctx_list_set_num_transfer_syntaxes },
	{ discard_const_p(char, "abstract_syntax"), py_dcerpc_ctx_list_get_abstract_syntax, py_dcerpc_ctx_list_set_abstract_syntax },
	{ discard_const_p(char, "transfer_syntaxes"), py_dcerpc_ctx_list_get_transfer_syntaxes, py_dcerpc_ctx_list_set_transfer_syntaxes },
	{ NULL }
};

static PyObject *py_dcerpc_ctx_list_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_ctx_list, type);
}


static PyTypeObject dcerpc_ctx_list_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ctx_list",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_ctx_list_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ctx_list_new,
};


static PyObject *py_dcerpc_bind_get_max_xmit_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py_max_xmit_frag;
	py_max_xmit_frag = PyInt_FromLong(object->max_xmit_frag);
	return py_max_xmit_frag;
}

static int py_dcerpc_bind_set_max_xmit_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_xmit_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_max_recv_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py_max_recv_frag;
	py_max_recv_frag = PyInt_FromLong(object->max_recv_frag);
	return py_max_recv_frag;
}

static int py_dcerpc_bind_set_max_recv_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_recv_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_assoc_group_id(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py_assoc_group_id;
	py_assoc_group_id = PyInt_FromLong(object->assoc_group_id);
	return py_assoc_group_id;
}

static int py_dcerpc_bind_set_assoc_group_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->assoc_group_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_num_contexts(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py_num_contexts;
	py_num_contexts = PyInt_FromLong(object->num_contexts);
	return py_num_contexts;
}

static int py_dcerpc_bind_set_num_contexts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_contexts = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_ctx_list(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py_ctx_list;
	py_ctx_list = PyList_New(object->num_contexts);
	if (py_ctx_list == NULL) {
		return NULL;
	}
	{
		int ctx_list_cntr_0;
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < object->num_contexts; ctx_list_cntr_0++) {
			PyObject *py_ctx_list_0;
			py_ctx_list_0 = py_talloc_import_ex(&dcerpc_ctx_list_Type, object->ctx_list, &object->ctx_list[ctx_list_cntr_0]);
			PyList_SetItem(py_ctx_list, ctx_list_cntr_0, py_ctx_list_0);
		}
	}
	return py_ctx_list;
}

static int py_dcerpc_bind_set_ctx_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ctx_list_cntr_0;
		object->ctx_list = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->ctx_list, PyList_Size(value));
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < PyList_Size(value); ctx_list_cntr_0++) {
			PY_CHECK_TYPE(&dcerpc_ctx_list_Type, PyList_GetItem(value, ctx_list_cntr_0), return -1;);
			memcpy(&object->ctx_list[ctx_list_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, ctx_list_cntr_0)), sizeof(object->ctx_list[ctx_list_cntr_0]));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_bind_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyObject *py_dcerpc_bind_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_bind_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)py_talloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_getsetters[] = {
	{ discard_const_p(char, "max_xmit_frag"), py_dcerpc_bind_get_max_xmit_frag, py_dcerpc_bind_set_max_xmit_frag },
	{ discard_const_p(char, "max_recv_frag"), py_dcerpc_bind_get_max_recv_frag, py_dcerpc_bind_set_max_recv_frag },
	{ discard_const_p(char, "assoc_group_id"), py_dcerpc_bind_get_assoc_group_id, py_dcerpc_bind_set_assoc_group_id },
	{ discard_const_p(char, "num_contexts"), py_dcerpc_bind_get_num_contexts, py_dcerpc_bind_set_num_contexts },
	{ discard_const_p(char, "ctx_list"), py_dcerpc_bind_get_ctx_list, py_dcerpc_bind_set_ctx_list },
	{ discard_const_p(char, "_pad"), py_dcerpc_bind_get__pad, py_dcerpc_bind_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_bind_get_auth_info, py_dcerpc_bind_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_bind_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_bind, type);
}


static PyTypeObject dcerpc_bind_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_bind_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_new,
};


static PyObject *py_dcerpc_empty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_empty, type);
}


static PyTypeObject dcerpc_empty_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.empty",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = NULL,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_empty_new,
};

PyObject *py_import_dcerpc_object(TALLOC_CTX *mem_ctx, int level, union dcerpc_object *in)
{
	PyObject *ret;

	switch (level) {
		default:
			ret = py_talloc_import_ex(&dcerpc_empty_Type, mem_ctx, &in->empty);
			return ret;

		case LIBNDR_FLAG_OBJECT_PRESENT:
			ret = py_talloc_import_ex(GUID_Type, mem_ctx, &in->object);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_object *py_export_dcerpc_object(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_object *ret = talloc_zero(mem_ctx, union dcerpc_object);
	switch (level) {
		default:
			PY_CHECK_TYPE(&dcerpc_empty_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->empty, py_talloc_get_ptr(in), sizeof(ret->empty));
			break;

		case LIBNDR_FLAG_OBJECT_PRESENT:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->object, py_talloc_get_ptr(in), sizeof(ret->object));
			break;

	}

	return ret;
}


static PyObject *py_dcerpc_request_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyInt_FromLong(object->alloc_hint);
	return py_alloc_hint;
}

static int py_dcerpc_request_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->alloc_hint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_request_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_request_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_request_get_opnum(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyInt_FromLong(object->opnum);
	return py_opnum;
}

static int py_dcerpc_request_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->opnum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_request_get_object(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(obj);
	PyObject *py_object;
	py_object = py_import_dcerpc_object(py_talloc_get_mem_ctx(obj), ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT, &object->object);
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_dcerpc_request_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(py_obj);
	memcpy(&object->object, py_export_dcerpc_object(py_talloc_get_mem_ctx(py_obj), ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT, value), sizeof(object->object));
	return 0;
}

static PyObject *py_dcerpc_request_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_request_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyObject *py_dcerpc_request_get_stub_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(obj);
	PyObject *py_stub_and_verifier;
	py_stub_and_verifier = PyString_FromStringAndSize((char *)(object->stub_and_verifier).data, (object->stub_and_verifier).length);
	return py_stub_and_verifier;
}

static int py_dcerpc_request_set_stub_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)py_talloc_get_ptr(py_obj);
	object->stub_and_verifier = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_request_getsetters[] = {
	{ discard_const_p(char, "alloc_hint"), py_dcerpc_request_get_alloc_hint, py_dcerpc_request_set_alloc_hint },
	{ discard_const_p(char, "context_id"), py_dcerpc_request_get_context_id, py_dcerpc_request_set_context_id },
	{ discard_const_p(char, "opnum"), py_dcerpc_request_get_opnum, py_dcerpc_request_set_opnum },
	{ discard_const_p(char, "object"), py_dcerpc_request_get_object, py_dcerpc_request_set_object },
	{ discard_const_p(char, "_pad"), py_dcerpc_request_get__pad, py_dcerpc_request_set__pad },
	{ discard_const_p(char, "stub_and_verifier"), py_dcerpc_request_get_stub_and_verifier, py_dcerpc_request_set_stub_and_verifier },
	{ NULL }
};

static PyObject *py_dcerpc_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_request, type);
}


static PyTypeObject dcerpc_request_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.request",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_request_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_request_new,
};


static PyObject *py_dcerpc_ack_ctx_get_result(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)py_talloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyInt_FromLong(object->result);
	return py_result;
}

static int py_dcerpc_ack_ctx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->result = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ack_ctx_get_reason(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)py_talloc_get_ptr(obj);
	PyObject *py_reason;
	py_reason = PyInt_FromLong(object->reason);
	return py_reason;
}

static int py_dcerpc_ack_ctx_set_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reason = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ack_ctx_get_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)py_talloc_get_ptr(obj);
	PyObject *py_syntax;
	py_syntax = py_talloc_import_ex(ndr_syntax_id_Type, py_talloc_get_mem_ctx(obj), &object->syntax);
	return py_syntax;
}

static int py_dcerpc_ack_ctx_set_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	memcpy(&object->syntax, py_talloc_get_ptr(value), sizeof(object->syntax));
	return 0;
}

static PyGetSetDef py_dcerpc_ack_ctx_getsetters[] = {
	{ discard_const_p(char, "result"), py_dcerpc_ack_ctx_get_result, py_dcerpc_ack_ctx_set_result },
	{ discard_const_p(char, "reason"), py_dcerpc_ack_ctx_get_reason, py_dcerpc_ack_ctx_set_reason },
	{ discard_const_p(char, "syntax"), py_dcerpc_ack_ctx_get_syntax, py_dcerpc_ack_ctx_set_syntax },
	{ NULL }
};

static PyObject *py_dcerpc_ack_ctx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_ack_ctx, type);
}


static PyTypeObject dcerpc_ack_ctx_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ack_ctx",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_ack_ctx_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ack_ctx_new,
};


static PyObject *py_dcerpc_bind_ack_get_max_xmit_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_max_xmit_frag;
	py_max_xmit_frag = PyInt_FromLong(object->max_xmit_frag);
	return py_max_xmit_frag;
}

static int py_dcerpc_bind_ack_set_max_xmit_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_xmit_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_max_recv_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_max_recv_frag;
	py_max_recv_frag = PyInt_FromLong(object->max_recv_frag);
	return py_max_recv_frag;
}

static int py_dcerpc_bind_ack_set_max_recv_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_recv_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_assoc_group_id(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_assoc_group_id;
	py_assoc_group_id = PyInt_FromLong(object->assoc_group_id);
	return py_assoc_group_id;
}

static int py_dcerpc_bind_ack_set_assoc_group_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->assoc_group_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_secondary_address_size(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_secondary_address_size;
	py_secondary_address_size = PyInt_FromLong(object->secondary_address_size);
	return py_secondary_address_size;
}

static int py_dcerpc_bind_ack_set_secondary_address_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->secondary_address_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_secondary_address(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_secondary_address;
	py_secondary_address = PyUnicode_Decode(object->secondary_address, strlen(object->secondary_address), "utf-8", "ignore");
	return py_secondary_address;
}

static int py_dcerpc_bind_ack_set_secondary_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->secondary_address = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get__pad1(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py__pad1;
	py__pad1 = PyString_FromStringAndSize((char *)(object->_pad1).data, (object->_pad1).length);
	return py__pad1;
}

static int py_dcerpc_bind_ack_set__pad1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	object->_pad1 = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_num_results(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_num_results;
	py_num_results = PyInt_FromLong(object->num_results);
	return py_num_results;
}

static int py_dcerpc_bind_ack_set_num_results(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_results = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_ctx_list(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_ctx_list;
	py_ctx_list = PyList_New(object->num_results);
	if (py_ctx_list == NULL) {
		return NULL;
	}
	{
		int ctx_list_cntr_0;
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < object->num_results; ctx_list_cntr_0++) {
			PyObject *py_ctx_list_0;
			py_ctx_list_0 = py_talloc_import_ex(&dcerpc_ack_ctx_Type, object->ctx_list, &object->ctx_list[ctx_list_cntr_0]);
			PyList_SetItem(py_ctx_list, ctx_list_cntr_0, py_ctx_list_0);
		}
	}
	return py_ctx_list;
}

static int py_dcerpc_bind_ack_set_ctx_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ctx_list_cntr_0;
		object->ctx_list = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->ctx_list, PyList_Size(value));
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < PyList_Size(value); ctx_list_cntr_0++) {
			PY_CHECK_TYPE(&dcerpc_ack_ctx_Type, PyList_GetItem(value, ctx_list_cntr_0), return -1;);
			memcpy(&object->ctx_list[ctx_list_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, ctx_list_cntr_0)), sizeof(object->ctx_list[ctx_list_cntr_0]));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_bind_ack_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)py_talloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_ack_getsetters[] = {
	{ discard_const_p(char, "max_xmit_frag"), py_dcerpc_bind_ack_get_max_xmit_frag, py_dcerpc_bind_ack_set_max_xmit_frag },
	{ discard_const_p(char, "max_recv_frag"), py_dcerpc_bind_ack_get_max_recv_frag, py_dcerpc_bind_ack_set_max_recv_frag },
	{ discard_const_p(char, "assoc_group_id"), py_dcerpc_bind_ack_get_assoc_group_id, py_dcerpc_bind_ack_set_assoc_group_id },
	{ discard_const_p(char, "secondary_address_size"), py_dcerpc_bind_ack_get_secondary_address_size, py_dcerpc_bind_ack_set_secondary_address_size },
	{ discard_const_p(char, "secondary_address"), py_dcerpc_bind_ack_get_secondary_address, py_dcerpc_bind_ack_set_secondary_address },
	{ discard_const_p(char, "_pad1"), py_dcerpc_bind_ack_get__pad1, py_dcerpc_bind_ack_set__pad1 },
	{ discard_const_p(char, "num_results"), py_dcerpc_bind_ack_get_num_results, py_dcerpc_bind_ack_set_num_results },
	{ discard_const_p(char, "ctx_list"), py_dcerpc_bind_ack_get_ctx_list, py_dcerpc_bind_ack_set_ctx_list },
	{ discard_const_p(char, "auth_info"), py_dcerpc_bind_ack_get_auth_info, py_dcerpc_bind_ack_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_bind_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_bind_ack, type);
}


static PyTypeObject dcerpc_bind_ack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind_ack",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_bind_ack_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_ack_new,
};


static PyObject *py_dcerpc_bind_nak_versions_get_num_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)py_talloc_get_ptr(obj);
	PyObject *py_num_versions;
	py_num_versions = PyInt_FromLong(object->num_versions);
	return py_num_versions;
}

static int py_dcerpc_bind_nak_versions_set_num_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_versions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_nak_versions_get_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)py_talloc_get_ptr(obj);
	PyObject *py_versions;
	py_versions = PyList_New(object->num_versions);
	if (py_versions == NULL) {
		return NULL;
	}
	{
		int versions_cntr_0;
		for (versions_cntr_0 = 0; versions_cntr_0 < object->num_versions; versions_cntr_0++) {
			PyObject *py_versions_0;
			py_versions_0 = PyInt_FromLong(object->versions[versions_cntr_0]);
			PyList_SetItem(py_versions, versions_cntr_0, py_versions_0);
		}
	}
	return py_versions;
}

static int py_dcerpc_bind_nak_versions_set_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int versions_cntr_0;
		object->versions = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->versions, PyList_Size(value));
		for (versions_cntr_0 = 0; versions_cntr_0 < PyList_Size(value); versions_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, versions_cntr_0), return -1;);
			object->versions[versions_cntr_0] = PyInt_AsLong(PyList_GetItem(value, versions_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_bind_nak_versions_getsetters[] = {
	{ discard_const_p(char, "num_versions"), py_dcerpc_bind_nak_versions_get_num_versions, py_dcerpc_bind_nak_versions_set_num_versions },
	{ discard_const_p(char, "versions"), py_dcerpc_bind_nak_versions_get_versions, py_dcerpc_bind_nak_versions_set_versions },
	{ NULL }
};

static PyObject *py_dcerpc_bind_nak_versions_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_bind_nak_versions, type);
}


static PyTypeObject dcerpc_bind_nak_versions_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind_nak_versions",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_bind_nak_versions_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_nak_versions_new,
};

PyObject *py_import_dcerpc_bind_nak_versions_ctr(TALLOC_CTX *mem_ctx, int level, union dcerpc_bind_nak_versions_ctr *in)
{
	PyObject *ret;

	switch (level) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			ret = py_talloc_import_ex(&dcerpc_bind_nak_versions_Type, mem_ctx, &in->v);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_bind_nak_versions_ctr *py_export_dcerpc_bind_nak_versions_ctr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_bind_nak_versions_ctr *ret = talloc_zero(mem_ctx, union dcerpc_bind_nak_versions_ctr);
	switch (level) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			PY_CHECK_TYPE(&dcerpc_bind_nak_versions_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v, py_talloc_get_ptr(in), sizeof(ret->v));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_dcerpc_bind_nak_get_reject_reason(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)py_talloc_get_ptr(obj);
	PyObject *py_reject_reason;
	py_reject_reason = PyInt_FromLong(object->reject_reason);
	return py_reject_reason;
}

static int py_dcerpc_bind_nak_set_reject_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reject_reason = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_nak_get_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)py_talloc_get_ptr(obj);
	PyObject *py_versions;
	py_versions = py_import_dcerpc_bind_nak_versions_ctr(py_talloc_get_mem_ctx(obj), object->reject_reason, &object->versions);
	if (py_versions == NULL) {
		return NULL;
	}
	return py_versions;
}

static int py_dcerpc_bind_nak_set_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)py_talloc_get_ptr(py_obj);
	memcpy(&object->versions, py_export_dcerpc_bind_nak_versions_ctr(py_talloc_get_mem_ctx(py_obj), object->reject_reason, value), sizeof(object->versions));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_nak_getsetters[] = {
	{ discard_const_p(char, "reject_reason"), py_dcerpc_bind_nak_get_reject_reason, py_dcerpc_bind_nak_set_reject_reason },
	{ discard_const_p(char, "versions"), py_dcerpc_bind_nak_get_versions, py_dcerpc_bind_nak_set_versions },
	{ NULL }
};

static PyObject *py_dcerpc_bind_nak_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_bind_nak, type);
}


static PyTypeObject dcerpc_bind_nak_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind_nak",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_bind_nak_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_nak_new,
};


static PyObject *py_dcerpc_response_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyInt_FromLong(object->alloc_hint);
	return py_alloc_hint;
}

static int py_dcerpc_response_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->alloc_hint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_response_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_response_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_response_get_cancel_count(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(obj);
	PyObject *py_cancel_count;
	py_cancel_count = PyInt_FromLong(object->cancel_count);
	return py_cancel_count;
}

static int py_dcerpc_response_set_cancel_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cancel_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_response_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_response_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyObject *py_dcerpc_response_get_stub_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(obj);
	PyObject *py_stub_and_verifier;
	py_stub_and_verifier = PyString_FromStringAndSize((char *)(object->stub_and_verifier).data, (object->stub_and_verifier).length);
	return py_stub_and_verifier;
}

static int py_dcerpc_response_set_stub_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)py_talloc_get_ptr(py_obj);
	object->stub_and_verifier = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_response_getsetters[] = {
	{ discard_const_p(char, "alloc_hint"), py_dcerpc_response_get_alloc_hint, py_dcerpc_response_set_alloc_hint },
	{ discard_const_p(char, "context_id"), py_dcerpc_response_get_context_id, py_dcerpc_response_set_context_id },
	{ discard_const_p(char, "cancel_count"), py_dcerpc_response_get_cancel_count, py_dcerpc_response_set_cancel_count },
	{ discard_const_p(char, "_pad"), py_dcerpc_response_get__pad, py_dcerpc_response_set__pad },
	{ discard_const_p(char, "stub_and_verifier"), py_dcerpc_response_get_stub_and_verifier, py_dcerpc_response_set_stub_and_verifier },
	{ NULL }
};

static PyObject *py_dcerpc_response_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_response, type);
}


static PyTypeObject dcerpc_response_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.response",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_response_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_response_new,
};


static PyObject *py_dcerpc_fault_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyInt_FromLong(object->alloc_hint);
	return py_alloc_hint;
}

static int py_dcerpc_fault_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->alloc_hint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_fault_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get_cancel_count(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(obj);
	PyObject *py_cancel_count;
	py_cancel_count = PyInt_FromLong(object->cancel_count);
	return py_cancel_count;
}

static int py_dcerpc_fault_set_cancel_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cancel_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get_status(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyInt_FromLong(object->status);
	return py_status;
}

static int py_dcerpc_fault_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->status = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_fault_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)py_talloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_fault_getsetters[] = {
	{ discard_const_p(char, "alloc_hint"), py_dcerpc_fault_get_alloc_hint, py_dcerpc_fault_set_alloc_hint },
	{ discard_const_p(char, "context_id"), py_dcerpc_fault_get_context_id, py_dcerpc_fault_set_context_id },
	{ discard_const_p(char, "cancel_count"), py_dcerpc_fault_get_cancel_count, py_dcerpc_fault_set_cancel_count },
	{ discard_const_p(char, "status"), py_dcerpc_fault_get_status, py_dcerpc_fault_set_status },
	{ discard_const_p(char, "_pad"), py_dcerpc_fault_get__pad, py_dcerpc_fault_set__pad },
	{ NULL }
};

static PyObject *py_dcerpc_fault_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_fault, type);
}


static PyTypeObject dcerpc_fault_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.fault",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_fault_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_fault_new,
};


static PyObject *py_dcerpc_auth_get_auth_type(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(obj);
	PyObject *py_auth_type;
	py_auth_type = PyInt_FromLong(object->auth_type);
	return py_auth_type;
}

static int py_dcerpc_auth_set_auth_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_level(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(obj);
	PyObject *py_auth_level;
	py_auth_level = PyInt_FromLong(object->auth_level);
	return py_auth_level;
}

static int py_dcerpc_auth_set_auth_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_level = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_pad_length(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(obj);
	PyObject *py_auth_pad_length;
	py_auth_pad_length = PyInt_FromLong(object->auth_pad_length);
	return py_auth_pad_length;
}

static int py_dcerpc_auth_set_auth_pad_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_pad_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_reserved(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(obj);
	PyObject *py_auth_reserved;
	py_auth_reserved = PyInt_FromLong(object->auth_reserved);
	return py_auth_reserved;
}

static int py_dcerpc_auth_set_auth_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(obj);
	PyObject *py_auth_context_id;
	py_auth_context_id = PyInt_FromLong(object->auth_context_id);
	return py_auth_context_id;
}

static int py_dcerpc_auth_set_auth_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_credentials(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(obj);
	PyObject *py_credentials;
	py_credentials = PyString_FromStringAndSize((char *)(object->credentials).data, (object->credentials).length);
	return py_credentials;
}

static int py_dcerpc_auth_set_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	object->credentials = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_auth_getsetters[] = {
	{ discard_const_p(char, "auth_type"), py_dcerpc_auth_get_auth_type, py_dcerpc_auth_set_auth_type },
	{ discard_const_p(char, "auth_level"), py_dcerpc_auth_get_auth_level, py_dcerpc_auth_set_auth_level },
	{ discard_const_p(char, "auth_pad_length"), py_dcerpc_auth_get_auth_pad_length, py_dcerpc_auth_set_auth_pad_length },
	{ discard_const_p(char, "auth_reserved"), py_dcerpc_auth_get_auth_reserved, py_dcerpc_auth_set_auth_reserved },
	{ discard_const_p(char, "auth_context_id"), py_dcerpc_auth_get_auth_context_id, py_dcerpc_auth_set_auth_context_id },
	{ discard_const_p(char, "credentials"), py_dcerpc_auth_get_credentials, py_dcerpc_auth_set_credentials },
	{ NULL }
};

static PyObject *py_dcerpc_auth_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_auth, type);
}

static PyObject *py_dcerpc_auth_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_auth);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_auth_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_auth_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_auth_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_auth_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_auth_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.auth",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_auth_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_auth_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_auth_new,
};


static PyObject *py_dcerpc_auth3_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_dcerpc_auth3_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth3_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)py_talloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_auth3_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)py_talloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_auth3_getsetters[] = {
	{ discard_const_p(char, "_pad"), py_dcerpc_auth3_get__pad, py_dcerpc_auth3_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_auth3_get_auth_info, py_dcerpc_auth3_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_auth3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_auth3, type);
}

static PyObject *py_dcerpc_auth3_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_auth3);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_auth3_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth3);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_auth3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_auth3_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_auth3_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_auth3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.auth3",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_auth3_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_auth3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_auth3_new,
};


static PyObject *py_dcerpc_orphaned_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_dcerpc_orphaned_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_orphaned_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)py_talloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_orphaned_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)py_talloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_orphaned_getsetters[] = {
	{ discard_const_p(char, "_pad"), py_dcerpc_orphaned_get__pad, py_dcerpc_orphaned_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_orphaned_get_auth_info, py_dcerpc_orphaned_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_orphaned_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_orphaned, type);
}

static PyObject *py_dcerpc_orphaned_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_orphaned);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_orphaned_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_orphaned);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_orphaned_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_orphaned_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_orphaned_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_orphaned_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.orphaned",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_orphaned_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_orphaned_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_orphaned_new,
};


static PyObject *py_dcerpc_co_cancel_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)py_talloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_dcerpc_co_cancel_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_co_cancel_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)py_talloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_co_cancel_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)py_talloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	return 0;
}

static PyGetSetDef py_dcerpc_co_cancel_getsetters[] = {
	{ discard_const_p(char, "_pad"), py_dcerpc_co_cancel_get__pad, py_dcerpc_co_cancel_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_co_cancel_get_auth_info, py_dcerpc_co_cancel_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_co_cancel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_co_cancel, type);
}

static PyObject *py_dcerpc_co_cancel_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_co_cancel);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_co_cancel_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_co_cancel);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_co_cancel_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_co_cancel_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_co_cancel_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_co_cancel_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.co_cancel",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_co_cancel_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_co_cancel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_co_cancel_new,
};


static PyObject *py_dcerpc_cl_cancel_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dcerpc_cl_cancel_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_cl_cancel_get_id(PyObject *obj, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)py_talloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyInt_FromLong(object->id);
	return py_id;
}

static int py_dcerpc_cl_cancel_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->id = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_cl_cancel_getsetters[] = {
	{ discard_const_p(char, "version"), py_dcerpc_cl_cancel_get_version, py_dcerpc_cl_cancel_set_version },
	{ discard_const_p(char, "id"), py_dcerpc_cl_cancel_get_id, py_dcerpc_cl_cancel_set_id },
	{ NULL }
};

static PyObject *py_dcerpc_cl_cancel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_cl_cancel, type);
}

static PyObject *py_dcerpc_cl_cancel_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_cl_cancel);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_cl_cancel_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cl_cancel);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_cl_cancel_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_cl_cancel_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_cl_cancel_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_cl_cancel_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.cl_cancel",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_cl_cancel_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_cl_cancel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_cl_cancel_new,
};


static PyObject *py_dcerpc_cancel_ack_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dcerpc_cancel_ack_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_cancel_ack_get_id(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyInt_FromLong(object->id);
	return py_id;
}

static int py_dcerpc_cancel_ack_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_cancel_ack_get_server_is_accepting(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(obj);
	PyObject *py_server_is_accepting;
	py_server_is_accepting = PyInt_FromLong(object->server_is_accepting);
	return py_server_is_accepting;
}

static int py_dcerpc_cancel_ack_set_server_is_accepting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_is_accepting = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_cancel_ack_getsetters[] = {
	{ discard_const_p(char, "version"), py_dcerpc_cancel_ack_get_version, py_dcerpc_cancel_ack_set_version },
	{ discard_const_p(char, "id"), py_dcerpc_cancel_ack_get_id, py_dcerpc_cancel_ack_set_id },
	{ discard_const_p(char, "server_is_accepting"), py_dcerpc_cancel_ack_get_server_is_accepting, py_dcerpc_cancel_ack_set_server_is_accepting },
	{ NULL }
};

static PyObject *py_dcerpc_cancel_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_cancel_ack, type);
}

static PyObject *py_dcerpc_cancel_ack_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_cancel_ack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_cancel_ack_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cancel_ack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_cancel_ack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_cancel_ack_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_cancel_ack_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_cancel_ack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.cancel_ack",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_cancel_ack_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_cancel_ack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_cancel_ack_new,
};


static PyObject *py_dcerpc_fack_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dcerpc_fack_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get__pad1(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py__pad1;
	py__pad1 = PyInt_FromLong(object->_pad1);
	return py__pad1;
}

static int py_dcerpc_fack_set__pad1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_window_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_window_size;
	py_window_size = PyInt_FromLong(object->window_size);
	return py_window_size;
}

static int py_dcerpc_fack_set_window_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->window_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_max_tdsu(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_max_tdsu;
	py_max_tdsu = PyInt_FromLong(object->max_tdsu);
	return py_max_tdsu;
}

static int py_dcerpc_fack_set_max_tdsu(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_tdsu = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_max_frag_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_max_frag_size;
	py_max_frag_size = PyInt_FromLong(object->max_frag_size);
	return py_max_frag_size;
}

static int py_dcerpc_fack_set_max_frag_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_frag_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_serial_no(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_serial_no;
	py_serial_no = PyInt_FromLong(object->serial_no);
	return py_serial_no;
}

static int py_dcerpc_fack_set_serial_no(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_no = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_selack_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_selack_size;
	py_selack_size = PyInt_FromLong(object->selack_size);
	return py_selack_size;
}

static int py_dcerpc_fack_set_selack_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->selack_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_selack(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(obj);
	PyObject *py_selack;
	py_selack = PyList_New(object->selack_size);
	if (py_selack == NULL) {
		return NULL;
	}
	{
		int selack_cntr_0;
		for (selack_cntr_0 = 0; selack_cntr_0 < object->selack_size; selack_cntr_0++) {
			PyObject *py_selack_0;
			py_selack_0 = PyInt_FromLong(object->selack[selack_cntr_0]);
			PyList_SetItem(py_selack, selack_cntr_0, py_selack_0);
		}
	}
	return py_selack;
}

static int py_dcerpc_fack_set_selack(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int selack_cntr_0;
		object->selack = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->selack, PyList_Size(value));
		for (selack_cntr_0 = 0; selack_cntr_0 < PyList_Size(value); selack_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, selack_cntr_0), return -1;);
			object->selack[selack_cntr_0] = PyInt_AsLong(PyList_GetItem(value, selack_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_fack_getsetters[] = {
	{ discard_const_p(char, "version"), py_dcerpc_fack_get_version, py_dcerpc_fack_set_version },
	{ discard_const_p(char, "_pad1"), py_dcerpc_fack_get__pad1, py_dcerpc_fack_set__pad1 },
	{ discard_const_p(char, "window_size"), py_dcerpc_fack_get_window_size, py_dcerpc_fack_set_window_size },
	{ discard_const_p(char, "max_tdsu"), py_dcerpc_fack_get_max_tdsu, py_dcerpc_fack_set_max_tdsu },
	{ discard_const_p(char, "max_frag_size"), py_dcerpc_fack_get_max_frag_size, py_dcerpc_fack_set_max_frag_size },
	{ discard_const_p(char, "serial_no"), py_dcerpc_fack_get_serial_no, py_dcerpc_fack_set_serial_no },
	{ discard_const_p(char, "selack_size"), py_dcerpc_fack_get_selack_size, py_dcerpc_fack_set_selack_size },
	{ discard_const_p(char, "selack"), py_dcerpc_fack_get_selack, py_dcerpc_fack_set_selack },
	{ NULL }
};

static PyObject *py_dcerpc_fack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_fack, type);
}

static PyObject *py_dcerpc_fack_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_fack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_fack_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_fack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_fack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_fack_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_fack_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_fack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.fack",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dcerpc_fack_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_fack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_fack_new,
};


static PyObject *py_dcerpc_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_ack, type);
}

static PyObject *py_dcerpc_ack_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_ack *object = (struct dcerpc_ack *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_ack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_ack_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_ack *object = (struct dcerpc_ack *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_ack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_ack_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_ack_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_ack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ack",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = NULL,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_ack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ack_new,
};


static PyObject *py_dcerpc_ping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_ping, type);
}

static PyObject *py_dcerpc_ping_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_ping *object = (struct dcerpc_ping *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_ping);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_ping_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_ping *object = (struct dcerpc_ping *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ping);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_ping_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_ping_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_ping_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_ping_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ping",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = NULL,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_ping_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ping_new,
};


static PyObject *py_dcerpc_shutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_shutdown, type);
}

static PyObject *py_dcerpc_shutdown_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_shutdown *object = (struct dcerpc_shutdown *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_shutdown);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_shutdown_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_shutdown *object = (struct dcerpc_shutdown *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_shutdown);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_shutdown_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_shutdown_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_shutdown_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_shutdown_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.shutdown",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = NULL,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_shutdown_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_shutdown_new,
};


static PyObject *py_dcerpc_working_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dcerpc_working, type);
}

static PyObject *py_dcerpc_working_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_working *object = (struct dcerpc_working *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_working);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_working_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dcerpc_working *object = (struct dcerpc_working *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_working);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dcerpc_working_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_working_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_working_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_working_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.working",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = NULL,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dcerpc_working_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_working_new,
};

PyObject *py_import_dcerpc_payload(TALLOC_CTX *mem_ctx, int level, union dcerpc_payload *in)
{
	PyObject *ret;

	switch (level) {
		case DCERPC_PKT_REQUEST:
			ret = py_talloc_import_ex(&dcerpc_request_Type, mem_ctx, &in->request);
			return ret;

		case DCERPC_PKT_PING:
			ret = py_talloc_import_ex(&dcerpc_ping_Type, mem_ctx, &in->ping);
			return ret;

		case DCERPC_PKT_RESPONSE:
			ret = py_talloc_import_ex(&dcerpc_response_Type, mem_ctx, &in->response);
			return ret;

		case DCERPC_PKT_FAULT:
			ret = py_talloc_import_ex(&dcerpc_fault_Type, mem_ctx, &in->fault);
			return ret;

		case DCERPC_PKT_WORKING:
			ret = py_talloc_import_ex(&dcerpc_working_Type, mem_ctx, &in->working);
			return ret;

		case DCERPC_PKT_NOCALL:
			ret = py_talloc_import_ex(&dcerpc_fack_Type, mem_ctx, &in->nocall);
			return ret;

		case DCERPC_PKT_REJECT:
			ret = py_talloc_import_ex(&dcerpc_fault_Type, mem_ctx, &in->reject);
			return ret;

		case DCERPC_PKT_ACK:
			ret = py_talloc_import_ex(&dcerpc_ack_Type, mem_ctx, &in->ack);
			return ret;

		case DCERPC_PKT_CL_CANCEL:
			ret = py_talloc_import_ex(&dcerpc_cl_cancel_Type, mem_ctx, &in->cl_cancel);
			return ret;

		case DCERPC_PKT_FACK:
			ret = py_talloc_import_ex(&dcerpc_fack_Type, mem_ctx, &in->fack);
			return ret;

		case DCERPC_PKT_CANCEL_ACK:
			ret = py_talloc_import_ex(&dcerpc_cancel_ack_Type, mem_ctx, &in->cancel_ack);
			return ret;

		case DCERPC_PKT_BIND:
			ret = py_talloc_import_ex(&dcerpc_bind_Type, mem_ctx, &in->bind);
			return ret;

		case DCERPC_PKT_BIND_ACK:
			ret = py_talloc_import_ex(&dcerpc_bind_ack_Type, mem_ctx, &in->bind_ack);
			return ret;

		case DCERPC_PKT_BIND_NAK:
			ret = py_talloc_import_ex(&dcerpc_bind_nak_Type, mem_ctx, &in->bind_nak);
			return ret;

		case DCERPC_PKT_ALTER:
			ret = py_talloc_import_ex(&dcerpc_bind_Type, mem_ctx, &in->alter);
			return ret;

		case DCERPC_PKT_ALTER_RESP:
			ret = py_talloc_import_ex(&dcerpc_bind_ack_Type, mem_ctx, &in->alter_resp);
			return ret;

		case DCERPC_PKT_SHUTDOWN:
			ret = py_talloc_import_ex(&dcerpc_shutdown_Type, mem_ctx, &in->shutdown);
			return ret;

		case DCERPC_PKT_CO_CANCEL:
			ret = py_talloc_import_ex(&dcerpc_co_cancel_Type, mem_ctx, &in->co_cancel);
			return ret;

		case DCERPC_PKT_ORPHANED:
			ret = py_talloc_import_ex(&dcerpc_orphaned_Type, mem_ctx, &in->orphaned);
			return ret;

		case DCERPC_PKT_AUTH3:
			ret = py_talloc_import_ex(&dcerpc_auth3_Type, mem_ctx, &in->auth3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_payload *py_export_dcerpc_payload(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_payload *ret = talloc_zero(mem_ctx, union dcerpc_payload);
	switch (level) {
		case DCERPC_PKT_REQUEST:
			PY_CHECK_TYPE(&dcerpc_request_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->request, py_talloc_get_ptr(in), sizeof(ret->request));
			break;

		case DCERPC_PKT_PING:
			PY_CHECK_TYPE(&dcerpc_ping_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->ping, py_talloc_get_ptr(in), sizeof(ret->ping));
			break;

		case DCERPC_PKT_RESPONSE:
			PY_CHECK_TYPE(&dcerpc_response_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->response, py_talloc_get_ptr(in), sizeof(ret->response));
			break;

		case DCERPC_PKT_FAULT:
			PY_CHECK_TYPE(&dcerpc_fault_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->fault, py_talloc_get_ptr(in), sizeof(ret->fault));
			break;

		case DCERPC_PKT_WORKING:
			PY_CHECK_TYPE(&dcerpc_working_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->working, py_talloc_get_ptr(in), sizeof(ret->working));
			break;

		case DCERPC_PKT_NOCALL:
			PY_CHECK_TYPE(&dcerpc_fack_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->nocall, py_talloc_get_ptr(in), sizeof(ret->nocall));
			break;

		case DCERPC_PKT_REJECT:
			PY_CHECK_TYPE(&dcerpc_fault_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->reject, py_talloc_get_ptr(in), sizeof(ret->reject));
			break;

		case DCERPC_PKT_ACK:
			PY_CHECK_TYPE(&dcerpc_ack_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->ack, py_talloc_get_ptr(in), sizeof(ret->ack));
			break;

		case DCERPC_PKT_CL_CANCEL:
			PY_CHECK_TYPE(&dcerpc_cl_cancel_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->cl_cancel, py_talloc_get_ptr(in), sizeof(ret->cl_cancel));
			break;

		case DCERPC_PKT_FACK:
			PY_CHECK_TYPE(&dcerpc_fack_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->fack, py_talloc_get_ptr(in), sizeof(ret->fack));
			break;

		case DCERPC_PKT_CANCEL_ACK:
			PY_CHECK_TYPE(&dcerpc_cancel_ack_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->cancel_ack, py_talloc_get_ptr(in), sizeof(ret->cancel_ack));
			break;

		case DCERPC_PKT_BIND:
			PY_CHECK_TYPE(&dcerpc_bind_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->bind, py_talloc_get_ptr(in), sizeof(ret->bind));
			break;

		case DCERPC_PKT_BIND_ACK:
			PY_CHECK_TYPE(&dcerpc_bind_ack_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->bind_ack, py_talloc_get_ptr(in), sizeof(ret->bind_ack));
			break;

		case DCERPC_PKT_BIND_NAK:
			PY_CHECK_TYPE(&dcerpc_bind_nak_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->bind_nak, py_talloc_get_ptr(in), sizeof(ret->bind_nak));
			break;

		case DCERPC_PKT_ALTER:
			PY_CHECK_TYPE(&dcerpc_bind_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->alter, py_talloc_get_ptr(in), sizeof(ret->alter));
			break;

		case DCERPC_PKT_ALTER_RESP:
			PY_CHECK_TYPE(&dcerpc_bind_ack_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->alter_resp, py_talloc_get_ptr(in), sizeof(ret->alter_resp));
			break;

		case DCERPC_PKT_SHUTDOWN:
			PY_CHECK_TYPE(&dcerpc_shutdown_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->shutdown, py_talloc_get_ptr(in), sizeof(ret->shutdown));
			break;

		case DCERPC_PKT_CO_CANCEL:
			PY_CHECK_TYPE(&dcerpc_co_cancel_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->co_cancel, py_talloc_get_ptr(in), sizeof(ret->co_cancel));
			break;

		case DCERPC_PKT_ORPHANED:
			PY_CHECK_TYPE(&dcerpc_orphaned_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->orphaned, py_talloc_get_ptr(in), sizeof(ret->orphaned));
			break;

		case DCERPC_PKT_AUTH3:
			PY_CHECK_TYPE(&dcerpc_auth3_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->auth3, py_talloc_get_ptr(in), sizeof(ret->auth3));
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_ncacn_packet_get_rpc_vers(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyInt_FromLong(object->rpc_vers);
	return py_rpc_vers;
}

static int py_ncacn_packet_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rpc_vers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_rpc_vers_minor(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_rpc_vers_minor;
	py_rpc_vers_minor = PyInt_FromLong(object->rpc_vers_minor);
	return py_rpc_vers_minor;
}

static int py_ncacn_packet_set_rpc_vers_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rpc_vers_minor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_ptype(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyInt_FromLong(object->ptype);
	return py_ptype;
}

static int py_ncacn_packet_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ptype = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_pfc_flags(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_pfc_flags;
	py_pfc_flags = PyInt_FromLong(object->pfc_flags);
	return py_pfc_flags;
}

static int py_ncacn_packet_set_pfc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pfc_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_drep(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(4);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < 4; drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyInt_FromLong(object->drep[drep_cntr_0]);
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_ncacn_packet_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_Size(value); drep_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, drep_cntr_0), return -1;);
			object->drep[drep_cntr_0] = PyInt_AsLong(PyList_GetItem(value, drep_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_frag_length(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_frag_length;
	py_frag_length = PyInt_FromLong(object->frag_length);
	return py_frag_length;
}

static int py_ncacn_packet_set_frag_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->frag_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_auth_length(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_auth_length;
	py_auth_length = PyInt_FromLong(object->auth_length);
	return py_auth_length;
}

static int py_ncacn_packet_set_auth_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_call_id(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_call_id;
	py_call_id = PyInt_FromLong(object->call_id);
	return py_call_id;
}

static int py_ncacn_packet_set_call_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->call_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_u(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(obj);
	PyObject *py_u;
	py_u = py_import_dcerpc_payload(py_talloc_get_mem_ctx(obj), object->ptype, &object->u);
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_ncacn_packet_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	memcpy(&object->u, py_export_dcerpc_payload(py_talloc_get_mem_ctx(py_obj), object->ptype, value), sizeof(object->u));
	return 0;
}

static PyGetSetDef py_ncacn_packet_getsetters[] = {
	{ discard_const_p(char, "rpc_vers"), py_ncacn_packet_get_rpc_vers, py_ncacn_packet_set_rpc_vers },
	{ discard_const_p(char, "rpc_vers_minor"), py_ncacn_packet_get_rpc_vers_minor, py_ncacn_packet_set_rpc_vers_minor },
	{ discard_const_p(char, "ptype"), py_ncacn_packet_get_ptype, py_ncacn_packet_set_ptype },
	{ discard_const_p(char, "pfc_flags"), py_ncacn_packet_get_pfc_flags, py_ncacn_packet_set_pfc_flags },
	{ discard_const_p(char, "drep"), py_ncacn_packet_get_drep, py_ncacn_packet_set_drep },
	{ discard_const_p(char, "frag_length"), py_ncacn_packet_get_frag_length, py_ncacn_packet_set_frag_length },
	{ discard_const_p(char, "auth_length"), py_ncacn_packet_get_auth_length, py_ncacn_packet_set_auth_length },
	{ discard_const_p(char, "call_id"), py_ncacn_packet_get_call_id, py_ncacn_packet_set_call_id },
	{ discard_const_p(char, "u"), py_ncacn_packet_get_u, py_ncacn_packet_set_u },
	{ NULL }
};

static PyObject *py_ncacn_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct ncacn_packet, type);
}

static PyObject *py_ncacn_packet_ndr_pack(PyObject *py_obj)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_ncacn_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ncacn_packet_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct ncacn_packet *object = (struct ncacn_packet *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_ncacn_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_ncacn_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ncacn_packet_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ncacn_packet_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ncacn_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ncacn_packet",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_ncacn_packet_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_ncacn_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ncacn_packet_new,
};


static PyObject *py_ncadg_packet_get_rpc_vers(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyInt_FromLong(object->rpc_vers);
	return py_rpc_vers;
}

static int py_ncadg_packet_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rpc_vers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ptype(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyInt_FromLong(object->ptype);
	return py_ptype;
}

static int py_ncadg_packet_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ptype = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_pfc_flags(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_pfc_flags;
	py_pfc_flags = PyInt_FromLong(object->pfc_flags);
	return py_pfc_flags;
}

static int py_ncadg_packet_set_pfc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pfc_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ncadg_flags(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_ncadg_flags;
	py_ncadg_flags = PyInt_FromLong(object->ncadg_flags);
	return py_ncadg_flags;
}

static int py_ncadg_packet_set_ncadg_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ncadg_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_drep(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(3);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < 3; drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyInt_FromLong(object->drep[drep_cntr_0]);
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_ncadg_packet_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_Size(value); drep_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, drep_cntr_0), return -1;);
			object->drep[drep_cntr_0] = PyInt_AsLong(PyList_GetItem(value, drep_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_serial_high(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_serial_high;
	py_serial_high = PyInt_FromLong(object->serial_high);
	return py_serial_high;
}

static int py_ncadg_packet_set_serial_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_high = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_object(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_object;
	py_object = py_talloc_import_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->object);
	return py_object;
}

static int py_ncadg_packet_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	memcpy(&object->object, py_talloc_get_ptr(value), sizeof(object->object));
	return 0;
}

static PyObject *py_ncadg_packet_get_iface(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_iface;
	py_iface = py_talloc_import_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->iface);
	return py_iface;
}

static int py_ncadg_packet_set_iface(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	memcpy(&object->iface, py_talloc_get_ptr(value), sizeof(object->iface));
	return 0;
}

static PyObject *py_ncadg_packet_get_activity(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_activity;
	py_activity = py_talloc_import_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->activity);
	return py_activity;
}

static int py_ncadg_packet_set_activity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	memcpy(&object->activity, py_talloc_get_ptr(value), sizeof(object->activity));
	return 0;
}

static PyObject *py_ncadg_packet_get_server_boot(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_server_boot;
	py_server_boot = PyInt_FromLong(object->server_boot);
	return py_server_boot;
}

static int py_ncadg_packet_set_server_boot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_boot = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_iface_version(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_iface_version;
	py_iface_version = PyInt_FromLong(object->iface_version);
	return py_iface_version;
}

static int py_ncadg_packet_set_iface_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->iface_version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_seq_num(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_seq_num;
	py_seq_num = PyInt_FromLong(object->seq_num);
	return py_seq_num;
}

static int py_ncadg_packet_set_seq_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->seq_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_opnum(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyInt_FromLong(object->opnum);
	return py_opnum;
}

static int py_ncadg_packet_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->opnum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ihint(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_ihint;
	py_ihint = PyInt_FromLong(object->ihint);
	return py_ihint;
}

static int py_ncadg_packet_set_ihint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ihint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ahint(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_ahint;
	py_ahint = PyInt_FromLong(object->ahint);
	return py_ahint;
}

static int py_ncadg_packet_set_ahint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ahint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_len(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_ncadg_packet_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_fragnum(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_fragnum;
	py_fragnum = PyInt_FromLong(object->fragnum);
	return py_fragnum;
}

static int py_ncadg_packet_set_fragnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fragnum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_auth_proto(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_auth_proto;
	py_auth_proto = PyInt_FromLong(object->auth_proto);
	return py_auth_proto;
}

static int py_ncadg_packet_set_auth_proto(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_proto = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_serial_low(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_serial_low;
	py_serial_low = PyInt_FromLong(object->serial_low);
	return py_serial_low;
}

static int py_ncadg_packet_set_serial_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_low = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_u(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(obj);
	PyObject *py_u;
	py_u = py_import_dcerpc_payload(py_talloc_get_mem_ctx(obj), object->ptype, &object->u);
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_ncadg_packet_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	memcpy(&object->u, py_export_dcerpc_payload(py_talloc_get_mem_ctx(py_obj), object->ptype, value), sizeof(object->u));
	return 0;
}

static PyGetSetDef py_ncadg_packet_getsetters[] = {
	{ discard_const_p(char, "rpc_vers"), py_ncadg_packet_get_rpc_vers, py_ncadg_packet_set_rpc_vers },
	{ discard_const_p(char, "ptype"), py_ncadg_packet_get_ptype, py_ncadg_packet_set_ptype },
	{ discard_const_p(char, "pfc_flags"), py_ncadg_packet_get_pfc_flags, py_ncadg_packet_set_pfc_flags },
	{ discard_const_p(char, "ncadg_flags"), py_ncadg_packet_get_ncadg_flags, py_ncadg_packet_set_ncadg_flags },
	{ discard_const_p(char, "drep"), py_ncadg_packet_get_drep, py_ncadg_packet_set_drep },
	{ discard_const_p(char, "serial_high"), py_ncadg_packet_get_serial_high, py_ncadg_packet_set_serial_high },
	{ discard_const_p(char, "object"), py_ncadg_packet_get_object, py_ncadg_packet_set_object },
	{ discard_const_p(char, "iface"), py_ncadg_packet_get_iface, py_ncadg_packet_set_iface },
	{ discard_const_p(char, "activity"), py_ncadg_packet_get_activity, py_ncadg_packet_set_activity },
	{ discard_const_p(char, "server_boot"), py_ncadg_packet_get_server_boot, py_ncadg_packet_set_server_boot },
	{ discard_const_p(char, "iface_version"), py_ncadg_packet_get_iface_version, py_ncadg_packet_set_iface_version },
	{ discard_const_p(char, "seq_num"), py_ncadg_packet_get_seq_num, py_ncadg_packet_set_seq_num },
	{ discard_const_p(char, "opnum"), py_ncadg_packet_get_opnum, py_ncadg_packet_set_opnum },
	{ discard_const_p(char, "ihint"), py_ncadg_packet_get_ihint, py_ncadg_packet_set_ihint },
	{ discard_const_p(char, "ahint"), py_ncadg_packet_get_ahint, py_ncadg_packet_set_ahint },
	{ discard_const_p(char, "len"), py_ncadg_packet_get_len, py_ncadg_packet_set_len },
	{ discard_const_p(char, "fragnum"), py_ncadg_packet_get_fragnum, py_ncadg_packet_set_fragnum },
	{ discard_const_p(char, "auth_proto"), py_ncadg_packet_get_auth_proto, py_ncadg_packet_set_auth_proto },
	{ discard_const_p(char, "serial_low"), py_ncadg_packet_get_serial_low, py_ncadg_packet_set_serial_low },
	{ discard_const_p(char, "u"), py_ncadg_packet_get_u, py_ncadg_packet_set_u },
	{ NULL }
};

static PyObject *py_ncadg_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct ncadg_packet, type);
}

static PyObject *py_ncadg_packet_ndr_pack(PyObject *py_obj)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_ncadg_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ncadg_packet_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct ncadg_packet *object = (struct ncadg_packet *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_ncadg_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_ncadg_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ncadg_packet_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ncadg_packet_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ncadg_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ncadg_packet",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_ncadg_packet_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_ncadg_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ncadg_packet_new,
};

static PyMethodDef dcerpc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdcerpc(void)
{
	PyObject *m;
	PyObject *dep_misc;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	if (PyType_Ready(&dcerpc_ctx_list_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_empty_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_request_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_ack_ctx_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_ack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_nak_versions_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_nak_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_response_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_fault_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_auth_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_auth3_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_orphaned_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_co_cancel_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_cl_cancel_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_cancel_ack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_fack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_ack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_ping_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_shutdown_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_working_Type) < 0)
		return;
	if (PyType_Ready(&ncacn_packet_Type) < 0)
		return;
	if (PyType_Ready(&ncadg_packet_Type) < 0)
		return;
#ifdef PY_CTX_LIST_PATCH
	PY_CTX_LIST_PATCH(&dcerpc_ctx_list_Type);
#endif
#ifdef PY_BIND_PATCH
	PY_BIND_PATCH(&dcerpc_bind_Type);
#endif
#ifdef PY_EMPTY_PATCH
	PY_EMPTY_PATCH(&dcerpc_empty_Type);
#endif
#ifdef PY_REQUEST_PATCH
	PY_REQUEST_PATCH(&dcerpc_request_Type);
#endif
#ifdef PY_ACK_CTX_PATCH
	PY_ACK_CTX_PATCH(&dcerpc_ack_ctx_Type);
#endif
#ifdef PY_BIND_ACK_PATCH
	PY_BIND_ACK_PATCH(&dcerpc_bind_ack_Type);
#endif
#ifdef PY_BIND_NAK_VERSIONS_PATCH
	PY_BIND_NAK_VERSIONS_PATCH(&dcerpc_bind_nak_versions_Type);
#endif
#ifdef PY_BIND_NAK_PATCH
	PY_BIND_NAK_PATCH(&dcerpc_bind_nak_Type);
#endif
#ifdef PY_RESPONSE_PATCH
	PY_RESPONSE_PATCH(&dcerpc_response_Type);
#endif
#ifdef PY_FAULT_PATCH
	PY_FAULT_PATCH(&dcerpc_fault_Type);
#endif
#ifdef PY_AUTH_PATCH
	PY_AUTH_PATCH(&dcerpc_auth_Type);
#endif
#ifdef PY_AUTH3_PATCH
	PY_AUTH3_PATCH(&dcerpc_auth3_Type);
#endif
#ifdef PY_ORPHANED_PATCH
	PY_ORPHANED_PATCH(&dcerpc_orphaned_Type);
#endif
#ifdef PY_CO_CANCEL_PATCH
	PY_CO_CANCEL_PATCH(&dcerpc_co_cancel_Type);
#endif
#ifdef PY_CL_CANCEL_PATCH
	PY_CL_CANCEL_PATCH(&dcerpc_cl_cancel_Type);
#endif
#ifdef PY_CANCEL_ACK_PATCH
	PY_CANCEL_ACK_PATCH(&dcerpc_cancel_ack_Type);
#endif
#ifdef PY_FACK_PATCH
	PY_FACK_PATCH(&dcerpc_fack_Type);
#endif
#ifdef PY_ACK_PATCH
	PY_ACK_PATCH(&dcerpc_ack_Type);
#endif
#ifdef PY_PING_PATCH
	PY_PING_PATCH(&dcerpc_ping_Type);
#endif
#ifdef PY_SHUTDOWN_PATCH
	PY_SHUTDOWN_PATCH(&dcerpc_shutdown_Type);
#endif
#ifdef PY_WORKING_PATCH
	PY_WORKING_PATCH(&dcerpc_working_Type);
#endif
#ifdef PY_NCACN_PACKET_PATCH
	PY_NCACN_PACKET_PATCH(&ncacn_packet_Type);
#endif
#ifdef PY_NCADG_PACKET_PATCH
	PY_NCADG_PACKET_PATCH(&ncadg_packet_Type);
#endif

	m = Py_InitModule3("dcerpc", dcerpc_methods, "dcerpc DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_SCHANNEL", PyInt_FromLong(DCERPC_AUTH_TYPE_SCHANNEL));
	PyModule_AddObject(m, "DCERPC_FAULT_OP_RNG_ERROR", PyInt_FromLong(0x1c010002));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_OBJECT_UUID", PyInt_FromLong(0x80));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_MSMQ", PyInt_FromLong(DCERPC_AUTH_TYPE_MSMQ));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_CONNECT", PyInt_FromLong(DCERPC_AUTH_LEVEL_CONNECT));
	PyModule_AddObject(m, "DCERPC_PKT_ORPHANED", PyInt_FromLong(DCERPC_PKT_ORPHANED));
	PyModule_AddObject(m, "DCERPC_PKT_CO_CANCEL", PyInt_FromLong(DCERPC_PKT_CO_CANCEL));
	PyModule_AddObject(m, "DCERPC_PKT_BIND_NAK", PyInt_FromLong(DCERPC_PKT_BIND_NAK));
	PyModule_AddObject(m, "DCERPC_PKT_WORKING", PyInt_FromLong(DCERPC_PKT_WORKING));
	PyModule_AddObject(m, "DCERPC_FAULT_CONTEXT_MISMATCH", PyInt_FromLong(0x1c00001a));
	PyModule_AddObject(m, "DCERPC_FAULT_TODO", PyInt_FromLong(0x00000042));
	PyModule_AddObject(m, "DCERPC_PKT_CL_CANCEL", PyInt_FromLong(DCERPC_PKT_CL_CANCEL));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_FIRST", PyInt_FromLong(0x01));
	PyModule_AddObject(m, "DCERPC_PKT_FAULT", PyInt_FromLong(DCERPC_PKT_FAULT));
	PyModule_AddObject(m, "DCERPC_FAULT_ACCESS_DENIED", PyInt_FromLong(0x00000005));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_KRB5", PyInt_FromLong(DCERPC_AUTH_TYPE_KRB5));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_MSN", PyInt_FromLong(DCERPC_AUTH_TYPE_MSN));
	PyModule_AddObject(m, "DCERPC_BIND_PROVIDER_REJECT", PyInt_FromLong(2));
	PyModule_AddObject(m, "DCERPC_PKT_ACK", PyInt_FromLong(DCERPC_PKT_ACK));
	PyModule_AddObject(m, "DCERPC_AUTH_LEN_OFFSET", PyInt_FromLong(10));
	PyModule_AddObject(m, "DCERPC_FAULT_CANT_PERFORM", PyInt_FromLong(0x000006d8));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_DIGEST", PyInt_FromLong(DCERPC_AUTH_TYPE_DIGEST));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_SUPPORT_HEADER_SIGN", PyInt_FromLong(DCERPC_PFC_FLAG_PENDING_CANCEL));
	PyModule_AddObject(m, "DCERPC_AUTH_TRAILER_LENGTH", PyInt_FromLong(8));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NONE", PyInt_FromLong(DCERPC_AUTH_TYPE_NONE));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_DPA", PyInt_FromLong(DCERPC_AUTH_TYPE_DPA));
	PyModule_AddObject(m, "DCERPC_DREP_OFFSET", PyInt_FromLong(4));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_PACKET", PyInt_FromLong(DCERPC_AUTH_LEVEL_PACKET));
	PyModule_AddObject(m, "DCERPC_FAULT_INVALID_TAG", PyInt_FromLong(0x1c000006));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_DID_NOT_EXECUTE", PyInt_FromLong(0x20));
	PyModule_AddObject(m, "DCERPC_RESPONSE_LENGTH", PyInt_FromLong(24));
	PyModule_AddObject(m, "DCERPC_PKT_ALTER", PyInt_FromLong(DCERPC_PKT_ALTER));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NTLMSSP", PyInt_FromLong(DCERPC_AUTH_TYPE_NTLMSSP));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_DEFAULT", PyInt_FromLong(DCERPC_AUTH_LEVEL_CONNECT));
	PyModule_AddObject(m, "DCERPC_BIND_REASON_INVALID_AUTH_TYPE", PyInt_FromLong(8));
	PyModule_AddObject(m, "DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED", PyInt_FromLong(4));
	PyModule_AddObject(m, "DCERPC_BIND_REASON_ASYNTAX", PyInt_FromLong(1));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_CALL", PyInt_FromLong(DCERPC_AUTH_LEVEL_CALL));
	PyModule_AddObject(m, "DCERPC_PKT_SHUTDOWN", PyInt_FromLong(DCERPC_PKT_SHUTDOWN));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_NONE", PyInt_FromLong(DCERPC_AUTH_LEVEL_NONE));
	PyModule_AddObject(m, "DCERPC_PKT_RESPONSE", PyInt_FromLong(DCERPC_PKT_RESPONSE));
	PyModule_AddObject(m, "DCERPC_FRAG_LEN_OFFSET", PyInt_FromLong(8));
	PyModule_AddObject(m, "DCERPC_DREP_LE", PyInt_FromLong(0x10));
	PyModule_AddObject(m, "DCERPC_PKT_CANCEL_ACK", PyInt_FromLong(DCERPC_PKT_CANCEL_ACK));
	PyModule_AddObject(m, "DCERPC_FAULT_OTHER", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "DCERPC_PKT_REQUEST", PyInt_FromLong(DCERPC_PKT_REQUEST));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_CONC_MPX", PyInt_FromLong(0x10));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_LAST", PyInt_FromLong(0x02));
	PyModule_AddObject(m, "DCERPC_FAULT_UNK_IF", PyInt_FromLong(0x1c010003));
	PyModule_AddObject(m, "DCERPC_PFC_OFFSET", PyInt_FromLong(3));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_INTEGRITY", PyInt_FromLong(DCERPC_AUTH_LEVEL_INTEGRITY));
	PyModule_AddObject(m, "DCERPC_PKT_BIND", PyInt_FromLong(DCERPC_PKT_BIND));
	PyModule_AddObject(m, "DCERPC_PKT_FACK", PyInt_FromLong(DCERPC_PKT_FACK));
	PyModule_AddObject(m, "DCERPC_PKT_BIND_ACK", PyInt_FromLong(DCERPC_PKT_BIND_ACK));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_PRIVACY", PyInt_FromLong(DCERPC_AUTH_LEVEL_PRIVACY));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_MAYBE", PyInt_FromLong(0x40));
	PyModule_AddObject(m, "DCERPC_FAULT_NDR", PyInt_FromLong(0x000006f7));
	PyModule_AddObject(m, "DCERPC_PKT_AUTH3", PyInt_FromLong(DCERPC_PKT_AUTH3));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_KRB5_1", PyInt_FromLong(DCERPC_AUTH_TYPE_KRB5_1));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_PENDING_CANCEL", PyInt_FromLong(0x04));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_SPNEGO", PyInt_FromLong(DCERPC_AUTH_TYPE_SPNEGO));
	PyModule_AddObject(m, "DCERPC_PKT_PING", PyInt_FromLong(DCERPC_PKT_PING));
	PyModule_AddObject(m, "DCERPC_PKT_ALTER_RESP", PyInt_FromLong(DCERPC_PKT_ALTER_RESP));
	PyModule_AddObject(m, "DCERPC_PKT_REJECT", PyInt_FromLong(DCERPC_PKT_REJECT));
	PyModule_AddObject(m, "DCERPC_REQUEST_LENGTH", PyInt_FromLong(24));
	PyModule_AddObject(m, "DCERPC_PKT_NOCALL", PyInt_FromLong(DCERPC_PKT_NOCALL));
	Py_INCREF((PyObject *)&dcerpc_ctx_list_Type);
	PyModule_AddObject(m, "ctx_list", (PyObject *)&dcerpc_ctx_list_Type);
	Py_INCREF((PyObject *)&dcerpc_bind_Type);
	PyModule_AddObject(m, "bind", (PyObject *)&dcerpc_bind_Type);
	Py_INCREF((PyObject *)&dcerpc_empty_Type);
	PyModule_AddObject(m, "empty", (PyObject *)&dcerpc_empty_Type);
	Py_INCREF((PyObject *)&dcerpc_request_Type);
	PyModule_AddObject(m, "request", (PyObject *)&dcerpc_request_Type);
	Py_INCREF((PyObject *)&dcerpc_ack_ctx_Type);
	PyModule_AddObject(m, "ack_ctx", (PyObject *)&dcerpc_ack_ctx_Type);
	Py_INCREF((PyObject *)&dcerpc_bind_ack_Type);
	PyModule_AddObject(m, "bind_ack", (PyObject *)&dcerpc_bind_ack_Type);
	Py_INCREF((PyObject *)&dcerpc_bind_nak_versions_Type);
	PyModule_AddObject(m, "bind_nak_versions", (PyObject *)&dcerpc_bind_nak_versions_Type);
	Py_INCREF((PyObject *)&dcerpc_bind_nak_Type);
	PyModule_AddObject(m, "bind_nak", (PyObject *)&dcerpc_bind_nak_Type);
	Py_INCREF((PyObject *)&dcerpc_response_Type);
	PyModule_AddObject(m, "response", (PyObject *)&dcerpc_response_Type);
	Py_INCREF((PyObject *)&dcerpc_fault_Type);
	PyModule_AddObject(m, "fault", (PyObject *)&dcerpc_fault_Type);
	Py_INCREF((PyObject *)&dcerpc_auth_Type);
	PyModule_AddObject(m, "auth", (PyObject *)&dcerpc_auth_Type);
	Py_INCREF((PyObject *)&dcerpc_auth3_Type);
	PyModule_AddObject(m, "auth3", (PyObject *)&dcerpc_auth3_Type);
	Py_INCREF((PyObject *)&dcerpc_orphaned_Type);
	PyModule_AddObject(m, "orphaned", (PyObject *)&dcerpc_orphaned_Type);
	Py_INCREF((PyObject *)&dcerpc_co_cancel_Type);
	PyModule_AddObject(m, "co_cancel", (PyObject *)&dcerpc_co_cancel_Type);
	Py_INCREF((PyObject *)&dcerpc_cl_cancel_Type);
	PyModule_AddObject(m, "cl_cancel", (PyObject *)&dcerpc_cl_cancel_Type);
	Py_INCREF((PyObject *)&dcerpc_cancel_ack_Type);
	PyModule_AddObject(m, "cancel_ack", (PyObject *)&dcerpc_cancel_ack_Type);
	Py_INCREF((PyObject *)&dcerpc_fack_Type);
	PyModule_AddObject(m, "fack", (PyObject *)&dcerpc_fack_Type);
	Py_INCREF((PyObject *)&dcerpc_ack_Type);
	PyModule_AddObject(m, "ack", (PyObject *)&dcerpc_ack_Type);
	Py_INCREF((PyObject *)&dcerpc_ping_Type);
	PyModule_AddObject(m, "ping", (PyObject *)&dcerpc_ping_Type);
	Py_INCREF((PyObject *)&dcerpc_shutdown_Type);
	PyModule_AddObject(m, "shutdown", (PyObject *)&dcerpc_shutdown_Type);
	Py_INCREF((PyObject *)&dcerpc_working_Type);
	PyModule_AddObject(m, "working", (PyObject *)&dcerpc_working_Type);
	Py_INCREF((PyObject *)&ncacn_packet_Type);
	PyModule_AddObject(m, "ncacn_packet", (PyObject *)&ncacn_packet_Type);
	Py_INCREF((PyObject *)&ncadg_packet_Type);
	PyModule_AddObject(m, "ncadg_packet", (PyObject *)&ncadg_packet_Type);
#ifdef PY_MOD_DCERPC_PATCH
	PY_MOD_DCERPC_PATCH(m);
#endif

}
