/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_atsvc.h"

NTSTATUS rpccli_atsvc_JobAdd(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     struct atsvc_JobInfo *job_info /* [in] [ref] */,
			     uint32_t *job_id /* [out] [ref] */)
{
	struct atsvc_JobAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.job_info = job_info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobAdd, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobAdd, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*job_id = *r.out.job_id;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_atsvc_JobDel(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     uint32_t min_job_id /* [in]  */,
			     uint32_t max_job_id /* [in]  */)
{
	struct atsvc_JobDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.min_job_id = min_job_id;
	r.in.max_job_id = max_job_id;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobDel, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBDEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobDel, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_atsvc_JobEnum(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *servername /* [in] [unique,charset(UTF16)] */,
			      struct atsvc_enum_ctr *ctr /* [in,out] [ref] */,
			      uint32_t preferred_max_len /* [in]  */,
			      uint32_t *total_entries /* [out] [ref] */,
			      uint32_t *resume_handle /* [in,out] [unique] */)
{
	struct atsvc_JobEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.ctr = ctr;
	r.in.preferred_max_len = preferred_max_len;
	r.in.resume_handle = resume_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobEnum, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobEnum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;
	*total_entries = *r.out.total_entries;
	if (resume_handle && r.out.resume_handle) {
		*resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_atsvc_JobGetInfo(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [unique,charset(UTF16)] */,
				 uint32_t job_id /* [in]  */,
				 struct atsvc_JobInfo **job_info /* [out] [ref] */)
{
	struct atsvc_JobGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.job_id = job_id;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobGetInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_atsvc,
				NDR_ATSVC_JOBGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*job_info = *r.out.job_info;

	/* Return result */
	return r.out.result;
}

