/* server functions auto-generated by pidl */
#include "../librpc/gen_ndr/ndr_frsapi.h"

/* frsapi - dcerpc server boilerplate generated by pidl */


static NTSTATUS frsapi__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_FRSAPI_BIND
	return DCESRV_INTERFACE_FRSAPI_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void frsapi__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_FRSAPI_UNBIND
	DCESRV_INTERFACE_FRSAPI_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS frsapi__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_frsapi.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_frsapi.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_frsapi.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_frsapi.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_frsapi, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS frsapi__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct FRSAPI_VERIFY_PROMOTION *r2 = (struct FRSAPI_VERIFY_PROMOTION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_VERIFY_PROMOTION, NDR_IN, r2);
		}
		dcesrv_FRSAPI_VERIFY_PROMOTION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_VERIFY_PROMOTION will reply async\n"));
		}
		break;
	}
	case 1: {
		struct FRSAPI_PROMOTION_STATUS *r2 = (struct FRSAPI_PROMOTION_STATUS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_PROMOTION_STATUS, NDR_IN, r2);
		}
		dcesrv_FRSAPI_PROMOTION_STATUS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_PROMOTION_STATUS will reply async\n"));
		}
		break;
	}
	case 2: {
		struct FRSAPI_START_DEMOTION *r2 = (struct FRSAPI_START_DEMOTION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_START_DEMOTION, NDR_IN, r2);
		}
		dcesrv_FRSAPI_START_DEMOTION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_START_DEMOTION will reply async\n"));
		}
		break;
	}
	case 3: {
		struct FRSAPI_COMMIT_DEMOTION *r2 = (struct FRSAPI_COMMIT_DEMOTION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_COMMIT_DEMOTION, NDR_IN, r2);
		}
		dcesrv_FRSAPI_COMMIT_DEMOTION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_COMMIT_DEMOTION will reply async\n"));
		}
		break;
	}
	case 4: {
		struct frsapi_SetDsPollingIntervalW *r2 = (struct frsapi_SetDsPollingIntervalW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_SetDsPollingIntervalW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_frsapi_SetDsPollingIntervalW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_SetDsPollingIntervalW will reply async\n"));
		}
		break;
	}
	case 5: {
		struct frsapi_GetDsPollingIntervalW *r2 = (struct frsapi_GetDsPollingIntervalW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_GetDsPollingIntervalW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_frsapi_GetDsPollingIntervalW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_GetDsPollingIntervalW will reply async\n"));
		}
		break;
	}
	case 6: {
		struct FRSAPI_VERIFY_PROMOTION_W *r2 = (struct FRSAPI_VERIFY_PROMOTION_W *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_VERIFY_PROMOTION_W, NDR_IN, r2);
		}
		dcesrv_FRSAPI_VERIFY_PROMOTION_W(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_VERIFY_PROMOTION_W will reply async\n"));
		}
		break;
	}
	case 7: {
		struct frsapi_InfoW *r2 = (struct frsapi_InfoW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_InfoW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_frsapi_InfoW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_InfoW will reply async\n"));
		}
		break;
	}
	case 8: {
		struct frsapi_IsPathReplicated *r2 = (struct frsapi_IsPathReplicated *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_IsPathReplicated, NDR_IN, r2);
		}
		r2->out.result = dcesrv_frsapi_IsPathReplicated(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_IsPathReplicated will reply async\n"));
		}
		break;
	}
	case 9: {
		struct FRSAPI_WRITER_COMMAND *r2 = (struct FRSAPI_WRITER_COMMAND *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_WRITER_COMMAND, NDR_IN, r2);
		}
		dcesrv_FRSAPI_WRITER_COMMAND(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_WRITER_COMMAND will reply async\n"));
		}
		break;
	}
	case 10: {
		struct frsapi_ForceReplication *r2 = (struct frsapi_ForceReplication *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_ForceReplication, NDR_IN, r2);
		}
		r2->out.result = dcesrv_frsapi_ForceReplication(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_ForceReplication will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_frsapi, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS frsapi__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct FRSAPI_VERIFY_PROMOTION *r2 = (struct FRSAPI_VERIFY_PROMOTION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_VERIFY_PROMOTION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_VERIFY_PROMOTION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSAPI_VERIFY_PROMOTION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct FRSAPI_PROMOTION_STATUS *r2 = (struct FRSAPI_PROMOTION_STATUS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_PROMOTION_STATUS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_PROMOTION_STATUS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSAPI_PROMOTION_STATUS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct FRSAPI_START_DEMOTION *r2 = (struct FRSAPI_START_DEMOTION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_START_DEMOTION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_START_DEMOTION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSAPI_START_DEMOTION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct FRSAPI_COMMIT_DEMOTION *r2 = (struct FRSAPI_COMMIT_DEMOTION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_COMMIT_DEMOTION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_COMMIT_DEMOTION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSAPI_COMMIT_DEMOTION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct frsapi_SetDsPollingIntervalW *r2 = (struct frsapi_SetDsPollingIntervalW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_SetDsPollingIntervalW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_SetDsPollingIntervalW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in frsapi_SetDsPollingIntervalW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct frsapi_GetDsPollingIntervalW *r2 = (struct frsapi_GetDsPollingIntervalW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_GetDsPollingIntervalW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_GetDsPollingIntervalW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in frsapi_GetDsPollingIntervalW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct FRSAPI_VERIFY_PROMOTION_W *r2 = (struct FRSAPI_VERIFY_PROMOTION_W *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_VERIFY_PROMOTION_W replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_VERIFY_PROMOTION_W, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSAPI_VERIFY_PROMOTION_W\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct frsapi_InfoW *r2 = (struct frsapi_InfoW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_InfoW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_InfoW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in frsapi_InfoW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct frsapi_IsPathReplicated *r2 = (struct frsapi_IsPathReplicated *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_IsPathReplicated replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_IsPathReplicated, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in frsapi_IsPathReplicated\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct FRSAPI_WRITER_COMMAND *r2 = (struct FRSAPI_WRITER_COMMAND *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSAPI_WRITER_COMMAND replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSAPI_WRITER_COMMAND, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSAPI_WRITER_COMMAND\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct frsapi_ForceReplication *r2 = (struct frsapi_ForceReplication *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsapi_ForceReplication replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(frsapi_ForceReplication, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in frsapi_ForceReplication\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_frsapi, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS frsapi__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_frsapi.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_frsapi_interface = {
	.name		= "frsapi",
	.syntax_id  = {{0xd049b186,0x814f,0x11d1,{0x9a,0x3c},{0x00,0xc0,0x4f,0xc9,0xb2,0x32}},1.1},
	.bind		= frsapi__op_bind,
	.unbind		= frsapi__op_unbind,
	.ndr_pull	= frsapi__op_ndr_pull,
	.dispatch	= frsapi__op_dispatch,
	.reply		= frsapi__op_reply,
	.ndr_push	= frsapi__op_ndr_push
};


static NTSTATUS frsapi__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_frsapi.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_frsapi.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_frsapi_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("frsapi_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool frsapi__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_frsapi_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_frsapi_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_frsapi_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool frsapi__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_frsapi_interface.name, name)==0) {
		memcpy(iface, &dcesrv_frsapi_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_frsapi_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "frsapi";

	/* fill in all the operations */
	ep_server.init_server = frsapi__op_init_server;

	ep_server.interface_by_uuid = frsapi__op_interface_by_uuid;
	ep_server.interface_by_name = frsapi__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'frsapi' endpoint server!\n"));
		return ret;
	}

	return ret;
}

