# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.35
#
# Don't modify this file, modify the SWIG interface instead.

"""
TDB is a simple key-value database similar to GDBM that supports multiple writers.
"""

import _tdb
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


REPLACE = _tdb.REPLACE
INSERT = _tdb.INSERT
MODIFY = _tdb.MODIFY
DEFAULT = _tdb.DEFAULT
CLEAR_IF_FIRST = _tdb.CLEAR_IF_FIRST
INTERNAL = _tdb.INTERNAL
NOLOCK = _tdb.NOLOCK
NOMMAP = _tdb.NOMMAP
CONVERT = _tdb.CONVERT
BIGENDIAN = _tdb.BIGENDIAN
TDB_SUCCESS = _tdb.TDB_SUCCESS
TDB_ERR_CORRUPT = _tdb.TDB_ERR_CORRUPT
TDB_ERR_IO = _tdb.TDB_ERR_IO
TDB_ERR_LOCK = _tdb.TDB_ERR_LOCK
TDB_ERR_OOM = _tdb.TDB_ERR_OOM
TDB_ERR_EXISTS = _tdb.TDB_ERR_EXISTS
TDB_ERR_NOLOCK = _tdb.TDB_ERR_NOLOCK
TDB_ERR_LOCK_TIMEOUT = _tdb.TDB_ERR_LOCK_TIMEOUT
TDB_ERR_NOEXIST = _tdb.TDB_ERR_NOEXIST
TDB_ERR_EINVAL = _tdb.TDB_ERR_EINVAL
TDB_ERR_RDONLY = _tdb.TDB_ERR_RDONLY
class Tdb(object):
    """A TDB file."""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args, **kwargs): 
        """
        S.__init__(name,hash_size=0,tdb_flags=TDB_DEFAULT,flags=O_RDWR,mode=0600)
        Open a TDB file.
        """
        _tdb.Tdb_swiginit(self,_tdb.new_Tdb(*args, **kwargs))
    __swig_destroy__ = _tdb.delete_Tdb
    def close(*args, **kwargs):
        """
        S.close() -> None
        Close the TDB file.
        """
        return _tdb.Tdb_close(*args, **kwargs)

    def errorstr(*args, **kwargs):
        """
        S.errorstr() -> errorstring
        Obtain last error message.
        """
        return _tdb.Tdb_errorstr(*args, **kwargs)

    def get(*args, **kwargs):
        """
        S.fetch(key) -> value
        Fetch a value.
        """
        return _tdb.Tdb_get(*args, **kwargs)

    def delete(*args, **kwargs):
        """
        S.delete(key) -> None
        Delete an entry.
        """
        return _tdb.Tdb_delete(*args, **kwargs)

    def store(*args, **kwargs):
        """
        S.store(key, value, flag=TDB_REPLACE) -> None
        Store an entry.
        """
        return _tdb.Tdb_store(*args, **kwargs)

    def firstkey(*args, **kwargs):
        """
        S.firstkey() -> data
        Return the first key in this database.
        """
        return _tdb.Tdb_firstkey(*args, **kwargs)

    def nextkey(*args, **kwargs):
        """
        S.nextkey(prev) -> data
        Return the next key in this database.
        """
        return _tdb.Tdb_nextkey(*args, **kwargs)

    def lock_all(*args, **kwargs):
        """S.lockall() -> bool"""
        return _tdb.Tdb_lock_all(*args, **kwargs)

    def unlock_all(*args, **kwargs):
        """S.unlockall() -> bool"""
        return _tdb.Tdb_unlock_all(*args, **kwargs)

    def reopen(*args, **kwargs):
        """
        S.reopen() -> bool
        Reopen this file.
        """
        return _tdb.Tdb_reopen(*args, **kwargs)

    def transaction_start(*args, **kwargs):
        """
        S.transaction_start() -> None
        Start a new transaction.
        """
        return _tdb.Tdb_transaction_start(*args, **kwargs)

    def transaction_commit(*args, **kwargs):
        """
        S.transaction_commit() -> None
        Commit the currently active transaction.
        """
        return _tdb.Tdb_transaction_commit(*args, **kwargs)

    def transaction_cancel(*args, **kwargs):
        """
        S.transaction_cancel() -> None
        Cancel the currently active transaction.
        """
        return _tdb.Tdb_transaction_cancel(*args, **kwargs)

    def hash_size(*args, **kwargs):
        """S.hash_size() -> int"""
        return _tdb.Tdb_hash_size(*args, **kwargs)

    def map_size(*args, **kwargs):
        """S.map_size() -> int"""
        return _tdb.Tdb_map_size(*args, **kwargs)

    def get_flags(*args, **kwargs):
        """S.get_flags() -> int"""
        return _tdb.Tdb_get_flags(*args, **kwargs)

    def set_max_dead(*args, **kwargs):
        """S.set_max_dead(int) -> None"""
        return _tdb.Tdb_set_max_dead(*args, **kwargs)

    def name(*args, **kwargs):
        """
        S.name() -> path
        Return filename of this TDB file.
        """
        return _tdb.Tdb_name(*args, **kwargs)

    def __repr__(self):
        return "Tdb('%s')" % self.name()


    def __getitem__(self, key):
        result = self.get(key)
        if result is None:
            raise KeyError, '%s: %s' % (key, self.errorstr())
        return result

    def __setitem__(self, key, item):
        if self.store(key, item) == -1:
            raise IOError, self.errorstr()

    def __delitem__(self, key):
        if not self.exists(key):
            raise KeyError, '%s: %s' % (key, self.errorstr())
        self.delete(key)

    def __contains__(self, key):
        return self.exists(key) != 0

    def has_key(self, key):
        return self.exists(key) != 0

    def fetch_uint32(self, key):
        data = self.get(key)
        if data is None:
            return None
        import struct
        return struct.unpack("<L", data)[0]

    def fetch_int32(self, key):
        data = self.get(key)
        if data is None:
            return None
        import struct
        return struct.unpack("<l", data)[0]


    class TdbIterator:
        def __init__(self, tdb):
            self.tdb = tdb
            self.key = None

        def __iter__(self):
            return self
            
        def next(self):
            if self.key is None:
                self.key = self.tdb.firstkey()
                if self.key is None:
                    raise StopIteration
                return self.key
            else:
                self.key = self.tdb.nextkey(self.key)
                if self.key is None:
                    raise StopIteration
                return self.key

    def __iter__(self):
        return self.TdbIterator(self)



    def keys(self):
        return [k for k in iter(self)]

    def values(self):
        return [self[k] for k in iter(self)]

    def items(self):
        return [(k, self[k]) for k in iter(self)]

    def __len__(self):
        return len(self.keys())

    def clear(self):
        for k in iter(self):
            del(self[k])

    def iterkeys(self):
        for k in iter(self):
            yield k
       
    def itervalues(self):
        for k in iter(self):
            yield self[k]

    def iteritems(self):
        for k in iter(self):
            yield (k, self[k])



Tdb.error = new_instancemethod(_tdb.Tdb_error,None,Tdb)
Tdb.close = new_instancemethod(_tdb.Tdb_close,None,Tdb)
Tdb.append = new_instancemethod(_tdb.Tdb_append,None,Tdb)
Tdb.errorstr = new_instancemethod(_tdb.Tdb_errorstr,None,Tdb)
Tdb.get = new_instancemethod(_tdb.Tdb_get,None,Tdb)
Tdb.delete = new_instancemethod(_tdb.Tdb_delete,None,Tdb)
Tdb.store = new_instancemethod(_tdb.Tdb_store,None,Tdb)
Tdb.exists = new_instancemethod(_tdb.Tdb_exists,None,Tdb)
Tdb.firstkey = new_instancemethod(_tdb.Tdb_firstkey,None,Tdb)
Tdb.nextkey = new_instancemethod(_tdb.Tdb_nextkey,None,Tdb)
Tdb.lock_all = new_instancemethod(_tdb.Tdb_lock_all,None,Tdb)
Tdb.unlock_all = new_instancemethod(_tdb.Tdb_unlock_all,None,Tdb)
Tdb.read_lock_all = new_instancemethod(_tdb.Tdb_read_lock_all,None,Tdb)
Tdb.read_unlock_all = new_instancemethod(_tdb.Tdb_read_unlock_all,None,Tdb)
Tdb.reopen = new_instancemethod(_tdb.Tdb_reopen,None,Tdb)
Tdb.transaction_start = new_instancemethod(_tdb.Tdb_transaction_start,None,Tdb)
Tdb.transaction_commit = new_instancemethod(_tdb.Tdb_transaction_commit,None,Tdb)
Tdb.transaction_cancel = new_instancemethod(_tdb.Tdb_transaction_cancel,None,Tdb)
Tdb.transaction_recover = new_instancemethod(_tdb.Tdb_transaction_recover,None,Tdb)
Tdb.hash_size = new_instancemethod(_tdb.Tdb_hash_size,None,Tdb)
Tdb.map_size = new_instancemethod(_tdb.Tdb_map_size,None,Tdb)
Tdb.get_flags = new_instancemethod(_tdb.Tdb_get_flags,None,Tdb)
Tdb.set_max_dead = new_instancemethod(_tdb.Tdb_set_max_dead,None,Tdb)
Tdb.name = new_instancemethod(_tdb.Tdb_name,None,Tdb)
Tdb_swigregister = _tdb.Tdb_swigregister
Tdb_swigregister(Tdb)



