/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_frsrpc.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_frsrpc_CommPktChunkGuidName(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktChunkGuidName *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_guid;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_guid, 4, -1));
			NDR_CHECK(ndr_push_GUID(_ndr_guid, NDR_SCALARS, &r->guid));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_guid, 4, -1));
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			{
				struct ndr_push *_ndr_name;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_name, 4, -1));
				NDR_CHECK(ndr_push_string(_ndr_name, NDR_SCALARS, r->name));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_name, 4, -1));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktChunkGuidName(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktChunkGuidName *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_guid;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_guid, 4, -1));
			NDR_CHECK(ndr_pull_GUID(_ndr_guid, NDR_SCALARS, &r->guid));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_guid, 4, -1));
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			{
				struct ndr_pull *_ndr_name;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_name, 4, -1));
				NDR_CHECK(ndr_pull_string(_ndr_name, NDR_SCALARS, &r->name));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_name, 4, -1));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChunkGuidName(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktChunkGuidName *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktChunkGuidName");
	ndr->depth++;
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_string(ndr, "name", r->name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_CommPktGSVN(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktGSVN *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->vsn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktGSVN(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktGSVN *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->vsn));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktGSVN(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktGSVN *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktGSVN");
	ndr->depth++;
	ndr_print_hyper(ndr, "vsn", r->vsn);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoCmdFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoCmdFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoCmdFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr_print_uint32(ndr, name, r);
		ndr->depth++;
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_ABORT_CO", FRSRPC_CO_FLAG_ABORT_CO, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_VV_ACTIVATED", FRSRPC_CO_FLAG_VV_ACTIVATED, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_CONTENT_CMD", FRSRPC_CO_FLAG_CONTENT_CMD, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_LOCATION_CMD", FRSRPC_CO_FLAG_LOCATION_CMD, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_ONLIST", FRSRPC_CO_FLAG_ONLIST, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_LOCALCO", FRSRPC_CO_FLAG_LOCALCO, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_RETRY", FRSRPC_CO_FLAG_RETRY, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_OUT_OF_ORDER", FRSRPC_CO_FLAG_OUT_OF_ORDER, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_NEW_FILE", FRSRPC_CO_FLAG_NEW_FILE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_CONTROL", FRSRPC_CO_FLAG_CONTROL, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_DIRECTED_CO", FRSRPC_CO_FLAG_DIRECTED_CO, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_VVJOIN_TO_ORIG", FRSRPC_CO_FLAG_VVJOIN_TO_ORIG, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_SKIP_ORIG_REC_C", FRSRPC_CO_FLAG_SKIP_ORIG_REC_C, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_MOVEIN_GEN", FRSRPC_CO_FLAG_MOVEIN_GEN, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_MORPH_GEN_HEAD", FRSRPC_CO_FLAG_MORPH_GEN_HEAD, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_JUST_OID_RESET", FRSRPC_CO_FLAG_JUST_OID_RESET, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_COMPRESSED_STAGE", FRSRPC_CO_FLAG_COMPRESSED_STAGE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_COMPRESSED_STAGE", FRSRPC_CO_FLAG_COMPRESSED_STAGE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_FLAG_SKIP_VV_UPDATE", FRSRPC_CO_FLAG_SKIP_VV_UPDATE, r);
		ndr->depth--;
		ndr->flags = _flags_save_BITMAP;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoCmdIFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoCmdIFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoCmdIFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr_print_uint32(ndr, name, r);
		ndr->depth++;
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_IFLAG_VVRETIRE_EXEC", FRSRPC_CO_IFLAG_VVRETIRE_EXEC, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_IFLAG_CO_ABORT", FRSRPC_CO_IFLAG_CO_ABORT, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CO_IFLAG_DIR_ENUM_PENDING", FRSRPC_CO_IFLAG_DIR_ENUM_PENDING, r);
		ndr->depth--;
		ndr->flags = _flags_save_BITMAP;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoCmdStatus(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktCoCmdStatus r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoCmdStatus(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktCoCmdStatus *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoCmdStatus(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktCoCmdStatus r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_CO_STATUS_CO_ENTERED_LOG: val = "FRSRPC_CO_STATUS_CO_ENTERED_LOG"; break;
			case FRSRPC_CO_STATUS_ALLOC_STAGING_LOCAL_CO: val = "FRSRPC_CO_STATUS_ALLOC_STAGING_LOCAL_CO"; break;
			case FRSRPC_CO_STATUS_LOCAL_CO_STAGING_STARTED: val = "FRSRPC_CO_STATUS_LOCAL_CO_STAGING_STARTED"; break;
			case FRSRPC_CO_STATUS_LOCAL_CO_STAGING_COMPLETED: val = "FRSRPC_CO_STATUS_LOCAL_CO_STAGING_COMPLETED"; break;
			case FRSRPC_CO_STATUS_WAIT_RETRY_LOCAL_CO_STAGING: val = "FRSRPC_CO_STATUS_WAIT_RETRY_LOCAL_CO_STAGING"; break;
			case FRSRPC_CO_STATUS_ALLOC_STAGING_REMOTE_CO: val = "FRSRPC_CO_STATUS_ALLOC_STAGING_REMOTE_CO"; break;
			case FRSRPC_CO_STATUS_REMOTE_CO_STAGING_STARTED: val = "FRSRPC_CO_STATUS_REMOTE_CO_STAGING_STARTED"; break;
			case FRSRPC_CO_STATUS_REMOTE_CO_STAGING_COMPLETED: val = "FRSRPC_CO_STATUS_REMOTE_CO_STAGING_COMPLETED"; break;
			case FRSRPC_CO_STATUS_WAIT_RETRY_REMOTE_CO_STAGING: val = "FRSRPC_CO_STATUS_WAIT_RETRY_REMOTE_CO_STAGING"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_REQUESTED: val = "FRSRPC_CO_STATUS_FILE_INSTALL_REQUESTED"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_STARTED: val = "FRSRPC_CO_STATUS_FILE_INSTALL_STARTED"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_COMPLETED: val = "FRSRPC_CO_STATUS_FILE_INSTALL_COMPLETED"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_WAIT_RETRY: val = "FRSRPC_CO_STATUS_FILE_INSTALL_WAIT_RETRY"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_RETRYING: val = "FRSRPC_CO_STATUS_FILE_INSTALL_RETRYING"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_RENAME_RETRYING: val = "FRSRPC_CO_STATUS_FILE_INSTALL_RENAME_RETRYING"; break;
			case FRSRPC_CO_STATUS_FILE_INSTALL_DELETE_RETRYING: val = "FRSRPC_CO_STATUS_FILE_INSTALL_DELETE_RETRYING"; break;
			case FRSRPC_CO_STATUS_CO_RECYCLED_FOR_ENUM: val = "FRSRPC_CO_STATUS_CO_RECYCLED_FOR_ENUM"; break;
			case FRSRPC_CO_STATUS_REQUEST_OUTBOUND_PROPAGATION: val = "FRSRPC_CO_STATUS_REQUEST_OUTBOUND_PROPAGATION"; break;
			case FRSRPC_CO_STATUS_REQUEST_ACCEPTED_OUTBOUND_LOG: val = "FRSRPC_CO_STATUS_REQUEST_ACCEPTED_OUTBOUND_LOG"; break;
			case FRSRPC_CO_STATUS_DB_STATE_UPDATE_STARTED: val = "FRSRPC_CO_STATUS_DB_STATE_UPDATE_STARTED"; break;
			case FRSRPC_CO_STATUS_DB_STATE_UPDATE_COMPLETED: val = "FRSRPC_CO_STATUS_DB_STATE_UPDATE_COMPLETED"; break;
			case FRSRPC_CO_STATUS_CO_ABORTED: val = "FRSRPC_CO_STATUS_CO_ABORTED"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoCmdContentCmd(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoCmdContentCmd(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_BITMAP;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoCmdContentCmd(struct ndr_print *ndr, const char *name, uint32_t r)
{
	{
		uint32_t _flags_save_BITMAP = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr_print_uint32(ndr, name, r);
		ndr->depth++;
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_DATA_OVERWRITE", FRSRPC_CONTENT_REASON_DATA_OVERWRITE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_DATA_EXTEND", FRSRPC_CONTENT_REASON_DATA_EXTEND, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_DATA_TRUNCATION", FRSRPC_CONTENT_REASON_DATA_TRUNCATION, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_NAMED_DATA_OVERWRITE", FRSRPC_CONTENT_REASON_NAMED_DATA_OVERWRITE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_NAMED_DATA_EXTEND", FRSRPC_CONTENT_REASON_NAMED_DATA_EXTEND, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_NAMED_DATA_TRUNCATION", FRSRPC_CONTENT_REASON_NAMED_DATA_TRUNCATION, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_FILE_CREATE", FRSRPC_CONTENT_REASON_FILE_CREATE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_FILE_DELETE", FRSRPC_CONTENT_REASON_FILE_DELETE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_EA_CHANGE", FRSRPC_CONTENT_REASON_EA_CHANGE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_SECURITY_CHANGE", FRSRPC_CONTENT_REASON_SECURITY_CHANGE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_OLD_NAME", FRSRPC_CONTENT_REASON_OLD_NAME, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_NEW_NAME", FRSRPC_CONTENT_REASON_NEW_NAME, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_BASIC_INFO_CHANGE", FRSRPC_CONTENT_REASON_BASIC_INFO_CHANGE, r);
		ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSRPC_CONTENT_REASON_COMPRESSION_CHANGE", FRSRPC_CONTENT_REASON_COMPRESSION_CHANGE, r);
		ndr->depth--;
		ndr->flags = _flags_save_BITMAP;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoCmdLocationCmd(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktCoCmdLocationCmd r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoCmdLocationCmd(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktCoCmdLocationCmd *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoCmdLocationCmd(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktCoCmdLocationCmd r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_CO_LOCATION_FILE_CREATE: val = "FRSRPC_CO_LOCATION_FILE_CREATE"; break;
			case FRSRPC_CO_LOCATION_DIR_CREATE: val = "FRSRPC_CO_LOCATION_DIR_CREATE"; break;
			case FRSRPC_CO_LOCATION_FILE_DELETE: val = "FRSRPC_CO_LOCATION_FILE_DELETE"; break;
			case FRSRPC_CO_LOCATION_DIR_DELETE: val = "FRSRPC_CO_LOCATION_DIR_DELETE"; break;
			case FRSRPC_CO_LOCATION_FILE_MOVEIN: val = "FRSRPC_CO_LOCATION_FILE_MOVEIN"; break;
			case FRSRPC_CO_LOCATION_DIR_MOVEIN: val = "FRSRPC_CO_LOCATION_DIR_MOVEIN"; break;
			case FRSRPC_CO_LOCATION_FILE_MOVEIN2: val = "FRSRPC_CO_LOCATION_FILE_MOVEIN2"; break;
			case FRSRPC_CO_LOCATION_DIR_MOVEIN2: val = "FRSRPC_CO_LOCATION_DIR_MOVEIN2"; break;
			case FRSRPC_CO_LOCATION_FILE_MOVEOUT: val = "FRSRPC_CO_LOCATION_FILE_MOVEOUT"; break;
			case FRSRPC_CO_LOCATION_DIR_MOVEOUT: val = "FRSRPC_CO_LOCATION_DIR_MOVEOUT"; break;
			case FRSRPC_CO_LOCATION_FILE_MOVERS: val = "FRSRPC_CO_LOCATION_FILE_MOVERS"; break;
			case FRSRPC_CO_LOCATION_DIR_MOVERS: val = "FRSRPC_CO_LOCATION_DIR_MOVERS"; break;
			case FRSRPC_CO_LOCATION_FILE_MOVEDIR: val = "FRSRPC_CO_LOCATION_FILE_MOVEDIR"; break;
			case FRSRPC_CO_LOCATION_DIR_MOVEDIR: val = "FRSRPC_CO_LOCATION_DIR_MOVEDIR"; break;
			case FRSRPC_CO_LOCATION_FILE_NO_CMD: val = "FRSRPC_CO_LOCATION_FILE_NO_CMD"; break;
			case FRSRPC_CO_LOCATION_DIR_NO_CMD: val = "FRSRPC_CO_LOCATION_DIR_NO_CMD"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktChangeOrderCommand(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktChangeOrderCommand *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sequence_number));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoCmdFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoCmdIFlags(ndr, NDR_SCALARS, r->iflags));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoCmdStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoCmdContentCmd(ndr, NDR_SCALARS, r->content_cmd));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoCmdLocationCmd(ndr, NDR_SCALARS, r->location_cmd));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->file_attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->file_version_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->partern_ack_sequence_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_size));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_offset));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->frs_vsn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->jrnl_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->jrnl_first_usn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->original_replica_num));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->new_replica_num));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->change_order_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originator_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->file_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->old_parent_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->new_parent_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->connection_guid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->ack_version));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->event_time));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->file_name)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->file_name, 260 + 1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktChangeOrderCommand(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktChangeOrderCommand *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sequence_number));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoCmdFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoCmdIFlags(ndr, NDR_SCALARS, &r->iflags));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoCmdStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoCmdContentCmd(ndr, NDR_SCALARS, &r->content_cmd));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoCmdLocationCmd(ndr, NDR_SCALARS, &r->location_cmd));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->file_attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->file_version_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->partern_ack_sequence_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->not_used));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_size));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_offset));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->frs_vsn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->jrnl_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->jrnl_first_usn));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->original_replica_num));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->new_replica_num));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->change_order_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originator_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->file_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->old_parent_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->new_parent_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->connection_guid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->ack_version));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->spare2ul1));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->spare1guid_p1));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->spare1guid_p2));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->spare2guid_p1));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->spare3guid_p2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->spare1wcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->spare2wcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->extension));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->spare2bin));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->event_time));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->file_name_length));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->file_name, 260 + 1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->padding1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->padding2));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->padding3));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->padding4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChangeOrderCommand(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktChangeOrderCommand *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktChangeOrderCommand");
	ndr->depth++;
	ndr_print_uint32(ndr, "sequence_number", r->sequence_number);
	ndr_print_frsrpc_CommPktCoCmdFlags(ndr, "flags", r->flags);
	ndr_print_frsrpc_CommPktCoCmdIFlags(ndr, "iflags", r->iflags);
	ndr_print_frsrpc_CommPktCoCmdStatus(ndr, "status", r->status);
	ndr_print_frsrpc_CommPktCoCmdContentCmd(ndr, "content_cmd", r->content_cmd);
	ndr_print_frsrpc_CommPktCoCmdLocationCmd(ndr, "location_cmd", r->location_cmd);
	ndr_print_uint32(ndr, "file_attributes", r->file_attributes);
	ndr_print_uint32(ndr, "file_version_number", r->file_version_number);
	ndr_print_uint32(ndr, "partern_ack_sequence_number", r->partern_ack_sequence_number);
	ndr_print_uint32(ndr, "not_used", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->not_used);
	ndr_print_hyper(ndr, "file_size", r->file_size);
	ndr_print_hyper(ndr, "file_offset", r->file_offset);
	ndr_print_hyper(ndr, "frs_vsn", r->frs_vsn);
	ndr_print_hyper(ndr, "file_usn", r->file_usn);
	ndr_print_hyper(ndr, "jrnl_usn", r->jrnl_usn);
	ndr_print_hyper(ndr, "jrnl_first_usn", r->jrnl_first_usn);
	ndr_print_uint32(ndr, "original_replica_num", r->original_replica_num);
	ndr_print_uint32(ndr, "new_replica_num", r->new_replica_num);
	ndr_print_GUID(ndr, "change_order_guid", &r->change_order_guid);
	ndr_print_GUID(ndr, "originator_guid", &r->originator_guid);
	ndr_print_GUID(ndr, "file_guid", &r->file_guid);
	ndr_print_GUID(ndr, "old_parent_guid", &r->old_parent_guid);
	ndr_print_GUID(ndr, "new_parent_guid", &r->new_parent_guid);
	ndr_print_GUID(ndr, "connection_guid", &r->connection_guid);
	ndr_print_hyper(ndr, "ack_version", r->ack_version);
	ndr_print_hyper(ndr, "spare2ul1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare2ul1);
	ndr_print_hyper(ndr, "spare1guid_p1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare1guid_p1);
	ndr_print_hyper(ndr, "spare1guid_p2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare1guid_p2);
	ndr_print_hyper(ndr, "spare2guid_p1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare2guid_p1);
	ndr_print_hyper(ndr, "spare3guid_p2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare3guid_p2);
	ndr_print_uint32(ndr, "spare1wcs", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare1wcs);
	ndr_print_uint32(ndr, "spare2wcs", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare2wcs);
	ndr_print_uint32(ndr, "extension", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->extension);
	ndr_print_uint32(ndr, "spare2bin", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->spare2bin);
	ndr_print_NTTIME(ndr, "event_time", r->event_time);
	ndr_print_uint16(ndr, "file_name_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->file_name):r->file_name_length);
	ndr_print_string(ndr, "file_name", r->file_name);
	ndr_print_uint8(ndr, "padding1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->padding1);
	ndr_print_uint8(ndr, "padding2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->padding2);
	ndr_print_uint8(ndr, "padding3", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->padding3);
	ndr_print_uint8(ndr, "padding4", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->padding4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_CommPktDataExtensionType(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktDataExtensionType r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktDataExtensionType(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktDataExtensionType *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktDataExtensionType(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktDataExtensionType r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_DATA_EXTENSION_TERMINATOR: val = "FRSRPC_DATA_EXTENSION_TERMINATOR"; break;
			case FRSRPC_DATA_EXTENSION_MD5_CHECKSUM: val = "FRSRPC_DATA_EXTENSION_MD5_CHECKSUM"; break;
			case FRSRPC_DATA_EXTENSION_RETRY_TIMEOUT: val = "FRSRPC_DATA_EXTENSION_RETRY_TIMEOUT"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktDataExtensionChecksum(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktDataExtensionChecksum *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000018));
			NDR_CHECK(ndr_push_frsrpc_CommPktDataExtensionType(ndr, NDR_SCALARS, FRSRPC_DATA_EXTENSION_MD5_CHECKSUM));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, 16));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktDataExtensionChecksum(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktDataExtensionChecksum *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->prefix_size));
			NDR_CHECK(ndr_pull_frsrpc_CommPktDataExtensionType(ndr, NDR_SCALARS, &r->prefix_type));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, 16));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktDataExtensionChecksum(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktDataExtensionChecksum *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktDataExtensionChecksum");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "prefix_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000018:r->prefix_size);
		ndr_print_frsrpc_CommPktDataExtensionType(ndr, "prefix_type", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?FRSRPC_DATA_EXTENSION_MD5_CHECKSUM:r->prefix_type);
		ndr_print_array_uint8(ndr, "data", r->data, 16);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktDataExtensionRetryTimeout(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktDataExtensionRetryTimeout *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000018));
		NDR_CHECK(ndr_push_frsrpc_CommPktDataExtensionType(ndr, NDR_SCALARS, FRSRPC_DATA_EXTENSION_RETRY_TIMEOUT));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->first_try_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktDataExtensionRetryTimeout(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktDataExtensionRetryTimeout *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->prefix_size));
		NDR_CHECK(ndr_pull_frsrpc_CommPktDataExtensionType(ndr, NDR_SCALARS, &r->prefix_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->not_used));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->first_try_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktDataExtensionRetryTimeout(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktDataExtensionRetryTimeout *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktDataExtensionRetryTimeout");
	ndr->depth++;
	ndr_print_uint32(ndr, "prefix_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000018:r->prefix_size);
	ndr_print_frsrpc_CommPktDataExtensionType(ndr, "prefix_type", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?FRSRPC_DATA_EXTENSION_RETRY_TIMEOUT:r->prefix_type);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "not_used", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->not_used);
	ndr_print_NTTIME(ndr, "first_try_time", r->first_try_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoRecordExtensionMajor(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktCoRecordExtensionMajor r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoRecordExtensionMajor(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktCoRecordExtensionMajor *r)
{
	uint16_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoRecordExtensionMajor(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktCoRecordExtensionMajor r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_CO_RECORD_EXTENSION_VERSION_WIN2K: val = "FRSRPC_CO_RECORD_EXTENSION_VERSION_WIN2K"; break;
			case FRSRPC_CO_RECORD_EXTENSION_VERSION_1: val = "FRSRPC_CO_RECORD_EXTENSION_VERSION_1"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCoRecordExtensionWin2k(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktCoRecordExtensionWin2k *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000028));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoRecordExtensionMajor(ndr, NDR_SCALARS, FRSRPC_CO_RECORD_EXTENSION_VERSION_WIN2K));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x0001));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000010));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_frsrpc_CommPktDataExtensionChecksum(ndr, NDR_SCALARS, &r->data_checksum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCoRecordExtensionWin2k(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktCoRecordExtensionWin2k *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->field_size));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoRecordExtensionMajor(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->offset_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->offset_last));
		NDR_CHECK(ndr_pull_frsrpc_CommPktDataExtensionChecksum(ndr, NDR_SCALARS, &r->data_checksum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCoRecordExtensionWin2k(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktCoRecordExtensionWin2k *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktCoRecordExtensionWin2k");
	ndr->depth++;
	ndr_print_uint32(ndr, "field_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000028:r->field_size);
	ndr_print_frsrpc_CommPktCoRecordExtensionMajor(ndr, "major", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?FRSRPC_CO_RECORD_EXTENSION_VERSION_WIN2K:r->major);
	ndr_print_uint16(ndr, "offset_count", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0001:r->offset_count);
	ndr_print_uint32(ndr, "offset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000010:r->offset);
	ndr_print_uint32(ndr, "offset_last", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->offset_last);
	ndr_print_frsrpc_CommPktDataExtensionChecksum(ndr, "data_checksum", &r->data_checksum);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_CommPktChangeOrderRecordExtension(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktChangeOrderRecordExtension *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000048));
		NDR_CHECK(ndr_push_frsrpc_CommPktCoRecordExtensionMajor(ndr, NDR_SCALARS, r->major));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x0002));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000018));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000030));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_frsrpc_CommPktDataExtensionChecksum(ndr, NDR_SCALARS, &r->data_checksum));
		NDR_CHECK(ndr_push_frsrpc_CommPktDataExtensionRetryTimeout(ndr, NDR_SCALARS, &r->data_retry_timeout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktChangeOrderRecordExtension(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktChangeOrderRecordExtension *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->field_size));
		NDR_CHECK(ndr_pull_frsrpc_CommPktCoRecordExtensionMajor(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->offset_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->offset0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->offset1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->offset_last));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->not_used));
		NDR_CHECK(ndr_pull_frsrpc_CommPktDataExtensionChecksum(ndr, NDR_SCALARS, &r->data_checksum));
		NDR_CHECK(ndr_pull_frsrpc_CommPktDataExtensionRetryTimeout(ndr, NDR_SCALARS, &r->data_retry_timeout));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChangeOrderRecordExtension(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktChangeOrderRecordExtension *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktChangeOrderRecordExtension");
	ndr->depth++;
	ndr_print_uint32(ndr, "field_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000048:r->field_size);
	ndr_print_frsrpc_CommPktCoRecordExtensionMajor(ndr, "major", r->major);
	ndr_print_uint16(ndr, "offset_count", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0002:r->offset_count);
	ndr_print_uint32(ndr, "offset0", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000018:r->offset0);
	ndr_print_uint32(ndr, "offset1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000030:r->offset1);
	ndr_print_uint32(ndr, "offset_last", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->offset_last);
	ndr_print_uint32(ndr, "not_used", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->not_used);
	ndr_print_frsrpc_CommPktDataExtensionChecksum(ndr, "data_checksum", &r->data_checksum);
	ndr_print_frsrpc_CommPktDataExtensionRetryTimeout(ndr, "data_retry_timeout", &r->data_retry_timeout);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_CommPktCommand(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktCommand r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktCommand(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktCommand *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktCommand(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktCommand r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_COMMAND_REMOTE_CO: val = "FRSRPC_COMMAND_REMOTE_CO"; break;
			case FRSRPC_COMMAND_RECEIVING_STATE: val = "FRSRPC_COMMAND_RECEIVING_STATE"; break;
			case FRSRPC_COMMAND_REMOTE_CO_DONE: val = "FRSRPC_COMMAND_REMOTE_CO_DONE"; break;
			case FRSRPC_COMMAND_ABORT_FETCH: val = "FRSRPC_COMMAND_ABORT_FETCH"; break;
			case FRSRPC_COMMAND_RETRY_FETCH: val = "FRSRPC_COMMAND_RETRY_FETCH"; break;
			case FRSRPC_COMMAND_NEED_JOIN: val = "FRSRPC_COMMAND_NEED_JOIN"; break;
			case FRSRPC_COMMAND_START_JOIN: val = "FRSRPC_COMMAND_START_JOIN"; break;
			case FRSRPC_COMMAND_JOINING: val = "FRSRPC_COMMAND_JOINING"; break;
			case FRSRPC_COMMAND_JOINED: val = "FRSRPC_COMMAND_JOINED"; break;
			case FRSRPC_COMMAND_UNJOIN_REMOTE: val = "FRSRPC_COMMAND_UNJOIN_REMOTE"; break;
			case FRSRPC_COMMAND_WJOIN_DONE: val = "FRSRPC_COMMAND_WJOIN_DONE"; break;
			case FRSRPC_COMMAND_SEND_STAGE: val = "FRSRPC_COMMAND_SEND_STAGE"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktChunkType(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktChunkType r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktChunkType(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktChunkType *r)
{
	uint16_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChunkType(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktChunkType r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_COMM_PKT_CHUNK_BOP: val = "FRSRPC_COMM_PKT_CHUNK_BOP"; break;
			case FRSRPC_COMM_PKT_CHUNK_COMMAND: val = "FRSRPC_COMM_PKT_CHUNK_COMMAND"; break;
			case FRSRPC_COMM_PKT_CHUNK_TO: val = "FRSRPC_COMM_PKT_CHUNK_TO"; break;
			case FRSRPC_COMM_PKT_CHUNK_FROM: val = "FRSRPC_COMM_PKT_CHUNK_FROM"; break;
			case FRSRPC_COMM_PKT_CHUNK_REPLICA: val = "FRSRPC_COMM_PKT_CHUNK_REPLICA"; break;
			case FRSRPC_COMM_PKT_CHUNK_CONNECTION: val = "FRSRPC_COMM_PKT_CHUNK_CONNECTION"; break;
			case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID: val = "FRSRPC_COMM_PKT_CHUNK_JOIN_GUID"; break;
			case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME: val = "FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME"; break;
			case FRSRPC_COMM_PKT_CHUNK_VVECTOR: val = "FRSRPC_COMM_PKT_CHUNK_VVECTOR"; break;
			case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME: val = "FRSRPC_COMM_PKT_CHUNK_JOIN_TIME"; break;
			case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID: val = "FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID"; break;
			case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID: val = "FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID"; break;
			case FRSRPC_COMM_PKT_CHUNK_BLOCK: val = "FRSRPC_COMM_PKT_CHUNK_BLOCK"; break;
			case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE: val = "FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE"; break;
			case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE: val = "FRSRPC_COMM_PKT_CHUNK_FILE_SIZE"; break;
			case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET: val = "FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET"; break;
			case FRSRPC_COMM_PKT_CHUNK_GVSN: val = "FRSRPC_COMM_PKT_CHUNK_GVSN"; break;
			case FRSRPC_COMM_PKT_CHUNK_CO_GUID: val = "FRSRPC_COMM_PKT_CHUNK_CO_GUID"; break;
			case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER: val = "FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER"; break;
			case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO: val = "FRSRPC_COMM_PKT_CHUNK_REMOTE_CO"; break;
			case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K: val = "FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K"; break;
			case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2: val = "FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2"; break;
			case FRSRPC_COMM_PKT_CHUNK_EOP: val = "FRSRPC_COMM_PKT_CHUNK_EOP"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktChunkData(struct ndr_push *ndr, int ndr_flags, const union frsrpc_CommPktChunkData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			default: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->blob));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_BOP: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_COMMAND: {
				NDR_CHECK(ndr_push_frsrpc_CommPktCommand(ndr, NDR_SCALARS, r->command));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_TO: {
				NDR_CHECK(ndr_push_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->to));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_FROM: {
				NDR_CHECK(ndr_push_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->from));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_REPLICA: {
				NDR_CHECK(ndr_push_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->replica));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CONNECTION: {
				NDR_CHECK(ndr_push_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->connection));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID: {
				{
					struct ndr_push *_ndr_join_guid;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_join_guid, 4, -1));
					NDR_CHECK(ndr_push_GUID(_ndr_join_guid, NDR_SCALARS, &r->join_guid));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_join_guid, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME: {
				NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_join_time));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_VVECTOR: {
				{
					struct ndr_push *_ndr_vvector;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_vvector, 4, -1));
					NDR_CHECK(ndr_push_frsrpc_CommPktGSVN(_ndr_vvector, NDR_SCALARS, &r->vvector));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_vvector, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME: {
				{
					struct ndr_push *_ndr_join_time;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_join_time, 4, -1));
					NDR_CHECK(ndr_push_NTTIME(_ndr_join_time, NDR_SCALARS, r->join_time));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_join_time, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID: {
				{
					struct ndr_push *_ndr_replica_version_guid;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_replica_version_guid, 4, -1));
					NDR_CHECK(ndr_push_GUID(_ndr_replica_version_guid, NDR_SCALARS, &r->replica_version_guid));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_replica_version_guid, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID: {
				NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->compression_guid));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_BLOCK: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->block));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE: {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->block_size));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE: {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_size));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET: {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_offset));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_GVSN: {
				{
					struct ndr_push *_ndr_gvsn;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_gvsn, 4, -1));
					NDR_CHECK(ndr_push_frsrpc_CommPktGSVN(_ndr_gvsn, NDR_SCALARS, &r->gvsn));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_gvsn, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_GUID: {
				{
					struct ndr_push *_ndr_co_guid;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_co_guid, 4, -1));
					NDR_CHECK(ndr_push_GUID(_ndr_co_guid, NDR_SCALARS, &r->co_guid));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_co_guid, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->co_sequnence_number));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO: {
				{
					struct ndr_push *_ndr_remote_co;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_remote_co, 4, -1));
					NDR_CHECK(ndr_push_frsrpc_CommPktChangeOrderCommand(_ndr_remote_co, NDR_SCALARS, &r->remote_co));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_remote_co, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K: {
				{
					struct ndr_push *_ndr_co_ext_win2k;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_co_ext_win2k, 4, -1));
					NDR_CHECK(ndr_push_frsrpc_CommPktCoRecordExtensionWin2k(_ndr_co_ext_win2k, NDR_SCALARS, &r->co_ext_win2k));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_co_ext_win2k, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2: {
				{
					struct ndr_push *_ndr_co_extension2;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_co_extension2, 4, -1));
					NDR_CHECK(ndr_push_frsrpc_CommPktChangeOrderRecordExtension(_ndr_co_extension2, NDR_SCALARS, &r->co_extension2));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_co_extension2, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_EOP: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0xFFFFFFFF));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			default:
			break;

			case FRSRPC_COMM_PKT_CHUNK_BOP:
			break;

			case FRSRPC_COMM_PKT_CHUNK_COMMAND:
			break;

			case FRSRPC_COMM_PKT_CHUNK_TO:
			break;

			case FRSRPC_COMM_PKT_CHUNK_FROM:
			break;

			case FRSRPC_COMM_PKT_CHUNK_REPLICA:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CONNECTION:
			break;

			case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME:
			break;

			case FRSRPC_COMM_PKT_CHUNK_VVECTOR:
			break;

			case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME:
			break;

			case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_BLOCK:
			break;

			case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE:
			break;

			case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE:
			break;

			case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET:
			break;

			case FRSRPC_COMM_PKT_CHUNK_GVSN:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER:
			break;

			case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2:
			break;

			case FRSRPC_COMM_PKT_CHUNK_EOP:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktChunkData(struct ndr_pull *ndr, int ndr_flags, union frsrpc_CommPktChunkData *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			default: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->blob));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_BOP: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bop));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_COMMAND: {
				NDR_CHECK(ndr_pull_frsrpc_CommPktCommand(ndr, NDR_SCALARS, &r->command));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_TO: {
				NDR_CHECK(ndr_pull_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->to));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_FROM: {
				NDR_CHECK(ndr_pull_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->from));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_REPLICA: {
				NDR_CHECK(ndr_pull_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->replica));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CONNECTION: {
				NDR_CHECK(ndr_pull_frsrpc_CommPktChunkGuidName(ndr, NDR_SCALARS, &r->connection));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID: {
				{
					struct ndr_pull *_ndr_join_guid;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_join_guid, 4, -1));
					NDR_CHECK(ndr_pull_GUID(_ndr_join_guid, NDR_SCALARS, &r->join_guid));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_join_guid, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME: {
				NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_join_time));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_VVECTOR: {
				{
					struct ndr_pull *_ndr_vvector;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_vvector, 4, -1));
					NDR_CHECK(ndr_pull_frsrpc_CommPktGSVN(_ndr_vvector, NDR_SCALARS, &r->vvector));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_vvector, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME: {
				{
					struct ndr_pull *_ndr_join_time;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_join_time, 4, -1));
					NDR_CHECK(ndr_pull_NTTIME(_ndr_join_time, NDR_SCALARS, &r->join_time));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_join_time, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID: {
				{
					struct ndr_pull *_ndr_replica_version_guid;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_replica_version_guid, 4, -1));
					NDR_CHECK(ndr_pull_GUID(_ndr_replica_version_guid, NDR_SCALARS, &r->replica_version_guid));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_replica_version_guid, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID: {
				NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->compression_guid));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_BLOCK: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->block));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE: {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->block_size));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE: {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_size));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET: {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_offset));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_GVSN: {
				{
					struct ndr_pull *_ndr_gvsn;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_gvsn, 4, -1));
					NDR_CHECK(ndr_pull_frsrpc_CommPktGSVN(_ndr_gvsn, NDR_SCALARS, &r->gvsn));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_gvsn, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_GUID: {
				{
					struct ndr_pull *_ndr_co_guid;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_co_guid, 4, -1));
					NDR_CHECK(ndr_pull_GUID(_ndr_co_guid, NDR_SCALARS, &r->co_guid));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_co_guid, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->co_sequnence_number));
			break; }

			case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO: {
				{
					struct ndr_pull *_ndr_remote_co;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_remote_co, 4, -1));
					NDR_CHECK(ndr_pull_frsrpc_CommPktChangeOrderCommand(_ndr_remote_co, NDR_SCALARS, &r->remote_co));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_remote_co, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K: {
				{
					struct ndr_pull *_ndr_co_ext_win2k;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_co_ext_win2k, 4, -1));
					NDR_CHECK(ndr_pull_frsrpc_CommPktCoRecordExtensionWin2k(_ndr_co_ext_win2k, NDR_SCALARS, &r->co_ext_win2k));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_co_ext_win2k, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2: {
				{
					struct ndr_pull *_ndr_co_extension2;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_co_extension2, 4, -1));
					NDR_CHECK(ndr_pull_frsrpc_CommPktChangeOrderRecordExtension(_ndr_co_extension2, NDR_SCALARS, &r->co_extension2));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_co_extension2, 4, -1));
				}
			break; }

			case FRSRPC_COMM_PKT_CHUNK_EOP: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bop));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			default:
			break;

			case FRSRPC_COMM_PKT_CHUNK_BOP:
			break;

			case FRSRPC_COMM_PKT_CHUNK_COMMAND:
			break;

			case FRSRPC_COMM_PKT_CHUNK_TO:
			break;

			case FRSRPC_COMM_PKT_CHUNK_FROM:
			break;

			case FRSRPC_COMM_PKT_CHUNK_REPLICA:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CONNECTION:
			break;

			case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME:
			break;

			case FRSRPC_COMM_PKT_CHUNK_VVECTOR:
			break;

			case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME:
			break;

			case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_BLOCK:
			break;

			case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE:
			break;

			case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE:
			break;

			case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET:
			break;

			case FRSRPC_COMM_PKT_CHUNK_GVSN:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_GUID:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER:
			break;

			case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K:
			break;

			case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2:
			break;

			case FRSRPC_COMM_PKT_CHUNK_EOP:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChunkData(struct ndr_print *ndr, const char *name, const union frsrpc_CommPktChunkData *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "frsrpc_CommPktChunkData");
	switch (level) {
		default:
			ndr_print_DATA_BLOB(ndr, "blob", r->blob);
		break;

		case FRSRPC_COMM_PKT_CHUNK_BOP:
			ndr_print_uint32(ndr, "bop", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->bop);
		break;

		case FRSRPC_COMM_PKT_CHUNK_COMMAND:
			ndr_print_frsrpc_CommPktCommand(ndr, "command", r->command);
		break;

		case FRSRPC_COMM_PKT_CHUNK_TO:
			ndr_print_frsrpc_CommPktChunkGuidName(ndr, "to", &r->to);
		break;

		case FRSRPC_COMM_PKT_CHUNK_FROM:
			ndr_print_frsrpc_CommPktChunkGuidName(ndr, "from", &r->from);
		break;

		case FRSRPC_COMM_PKT_CHUNK_REPLICA:
			ndr_print_frsrpc_CommPktChunkGuidName(ndr, "replica", &r->replica);
		break;

		case FRSRPC_COMM_PKT_CHUNK_CONNECTION:
			ndr_print_frsrpc_CommPktChunkGuidName(ndr, "connection", &r->connection);
		break;

		case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID:
			ndr_print_GUID(ndr, "join_guid", &r->join_guid);
		break;

		case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME:
			ndr_print_NTTIME(ndr, "last_join_time", r->last_join_time);
		break;

		case FRSRPC_COMM_PKT_CHUNK_VVECTOR:
			ndr_print_frsrpc_CommPktGSVN(ndr, "vvector", &r->vvector);
		break;

		case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME:
			ndr_print_NTTIME(ndr, "join_time", r->join_time);
		break;

		case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID:
			ndr_print_GUID(ndr, "replica_version_guid", &r->replica_version_guid);
		break;

		case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID:
			ndr_print_GUID(ndr, "compression_guid", &r->compression_guid);
		break;

		case FRSRPC_COMM_PKT_CHUNK_BLOCK:
			ndr_print_DATA_BLOB(ndr, "block", r->block);
		break;

		case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE:
			ndr_print_hyper(ndr, "block_size", r->block_size);
		break;

		case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE:
			ndr_print_hyper(ndr, "file_size", r->file_size);
		break;

		case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET:
			ndr_print_hyper(ndr, "file_offset", r->file_offset);
		break;

		case FRSRPC_COMM_PKT_CHUNK_GVSN:
			ndr_print_frsrpc_CommPktGSVN(ndr, "gvsn", &r->gvsn);
		break;

		case FRSRPC_COMM_PKT_CHUNK_CO_GUID:
			ndr_print_GUID(ndr, "co_guid", &r->co_guid);
		break;

		case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER:
			ndr_print_uint32(ndr, "co_sequnence_number", r->co_sequnence_number);
		break;

		case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO:
			ndr_print_frsrpc_CommPktChangeOrderCommand(ndr, "remote_co", &r->remote_co);
		break;

		case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K:
			ndr_print_frsrpc_CommPktCoRecordExtensionWin2k(ndr, "co_ext_win2k", &r->co_ext_win2k);
		break;

		case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2:
			ndr_print_frsrpc_CommPktChangeOrderRecordExtension(ndr, "co_extension2", &r->co_extension2);
		break;

		case FRSRPC_COMM_PKT_CHUNK_EOP:
			ndr_print_uint32(ndr, "bop", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0xFFFFFFFF:r->bop);
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_frsrpc_CommPktChunk(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_CommPktChunk *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 3));
			NDR_CHECK(ndr_push_frsrpc_CommPktChunkType(ndr, NDR_SCALARS, r->type));
			{
				struct ndr_push *_ndr_data;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_data, 4, -1));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_data, &r->data, r->type));
				NDR_CHECK(ndr_push_frsrpc_CommPktChunkData(_ndr_data, NDR_SCALARS, &r->data));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_data, 4, -1));
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 3));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_frsrpc_CommPktChunk(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_CommPktChunk *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 3));
			NDR_CHECK(ndr_pull_frsrpc_CommPktChunkType(ndr, NDR_SCALARS, &r->type));
			{
				struct ndr_pull *_ndr_data;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_data, 4, -1));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_data, &r->data, r->type));
				NDR_CHECK(ndr_pull_frsrpc_CommPktChunkData(_ndr_data, NDR_SCALARS, &r->data));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_data, 4, -1));
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 3));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChunk(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktChunk *r)
{
	ndr_print_struct(ndr, name, "frsrpc_CommPktChunk");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_frsrpc_CommPktChunkType(ndr, "type", r->type);
		ndr_print_set_switch_value(ndr, &r->data, r->type);
		ndr_print_frsrpc_CommPktChunkData(ndr, "data", &r->data);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ void ndr_print_frsrpc_CommPktChunkCtr(struct ndr_print *ndr, const char *name, const struct frsrpc_CommPktChunkCtr *r)
{
	uint32_t cntr_chunks_0;
	ndr_print_struct(ndr, name, "frsrpc_CommPktChunkCtr");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_chunks", r->num_chunks);
		ndr->print(ndr, "%s: ARRAY(%d)", "chunks", (int)r->num_chunks);
		ndr->depth++;
		for (cntr_chunks_0=0;cntr_chunks_0<r->num_chunks;cntr_chunks_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_chunks_0) != -1) {
				ndr_print_frsrpc_CommPktChunk(ndr, "chunks", &r->chunks[cntr_chunks_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_frsrpc_CommPktMajor(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktMajor r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktMajor(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktMajor *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktMajor(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktMajor r)
{
	const char *val = NULL;

	switch (r) {
		case FRSRPC_COMM_PKT_MAJOR_0: val = "FRSRPC_COMM_PKT_MAJOR_0"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frsrpc_CommPktMinor(struct ndr_push *ndr, int ndr_flags, enum frsrpc_CommPktMinor r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_CommPktMinor(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_CommPktMinor *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_CommPktMinor(struct ndr_print *ndr, const char *name, enum frsrpc_CommPktMinor r)
{
	const char *val = NULL;

	switch (r) {
		case FRSRPC_COMM_PKT_MINOR_0: val = "FRSRPC_COMM_PKT_MINOR_0"; break;
		case FRSRPC_COMM_PKT_MINOR_1: val = "FRSRPC_COMM_PKT_MINOR_1"; break;
		case FRSRPC_COMM_PKT_MINOR_2: val = "FRSRPC_COMM_PKT_MINOR_2"; break;
		case FRSRPC_COMM_PKT_MINOR_3: val = "FRSRPC_COMM_PKT_MINOR_3"; break;
		case FRSRPC_COMM_PKT_MINOR_4: val = "FRSRPC_COMM_PKT_MINOR_4"; break;
		case FRSRPC_COMM_PKT_MINOR_5: val = "FRSRPC_COMM_PKT_MINOR_5"; break;
		case FRSRPC_COMM_PKT_MINOR_6: val = "FRSRPC_COMM_PKT_MINOR_6"; break;
		case FRSRPC_COMM_PKT_MINOR_7: val = "FRSRPC_COMM_PKT_MINOR_7"; break;
		case FRSRPC_COMM_PKT_MINOR_8: val = "FRSRPC_COMM_PKT_MINOR_8"; break;
		case FRSRPC_COMM_PKT_MINOR_9: val = "FRSRPC_COMM_PKT_MINOR_9"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frsrpc_FrsSendCommPktReq(struct ndr_push *ndr, int ndr_flags, const struct frsrpc_FrsSendCommPktReq *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_frsrpc_CommPktMajor(ndr, NDR_SCALARS, r->major));
		NDR_CHECK(ndr_push_frsrpc_CommPktMinor(ndr, NDR_SCALARS, r->minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_frsrpc_CommPktChunkCtr(r->ctr, ndr->iconv_convenience, ndr->flags) + 12));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_frsrpc_CommPktChunkCtr(r->ctr, ndr->iconv_convenience, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ctr) {
			{
				struct ndr_push *_ndr_ctr;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_ctr, 4, ndr_size_frsrpc_CommPktChunkCtr(r->ctr, ndr->iconv_convenience, ndr->flags)));
				NDR_CHECK(ndr_push_frsrpc_CommPktChunkCtr(_ndr_ctr, NDR_SCALARS, r->ctr));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_ctr, 4, ndr_size_frsrpc_CommPktChunkCtr(r->ctr, ndr->iconv_convenience, ndr->flags)));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_FrsSendCommPktReq(struct ndr_pull *ndr, int ndr_flags, struct frsrpc_FrsSendCommPktReq *r)
{
	uint32_t _ptr_ctr;
	TALLOC_CTX *_mem_save_ctr_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_frsrpc_CommPktMajor(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_frsrpc_CommPktMinor(ndr, NDR_SCALARS, &r->minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cs_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->memory_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pkt_len));
		if (r->pkt_len > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->upk_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr));
		if (_ptr_ctr) {
			NDR_PULL_ALLOC(ndr, r->ctr);
		} else {
			r->ctr = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_handle));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ctr) {
			_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ctr, 0);
			{
				struct ndr_pull *_ndr_ctr;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ctr, 4, r->pkt_len));
				NDR_CHECK(ndr_pull_frsrpc_CommPktChunkCtr(_ndr_ctr, NDR_SCALARS, r->ctr));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ctr, 4, r->pkt_len));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_FrsSendCommPktReq(struct ndr_print *ndr, const char *name, const struct frsrpc_FrsSendCommPktReq *r)
{
	ndr_print_struct(ndr, name, "frsrpc_FrsSendCommPktReq");
	ndr->depth++;
	ndr_print_frsrpc_CommPktMajor(ndr, "major", r->major);
	ndr_print_frsrpc_CommPktMinor(ndr, "minor", r->minor);
	ndr_print_uint32(ndr, "cs_id", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->cs_id);
	ndr_print_uint32(ndr, "memory_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->pkt_len + 12:r->memory_len);
	ndr_print_uint32(ndr, "pkt_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_frsrpc_CommPktChunkCtr(r->ctr, ndr->iconv_convenience, ndr->flags):r->pkt_len);
	ndr_print_uint32(ndr, "upk_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->upk_len);
	ndr_print_ptr(ndr, "ctr", r->ctr);
	ndr->depth++;
	if (r->ctr) {
		ndr_print_frsrpc_CommPktChunkCtr(ndr, "ctr", r->ctr);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "data_name", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->data_name);
	ndr_print_uint32(ndr, "data_handle", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->data_handle);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_PartnerAuthLevel(struct ndr_push *ndr, int ndr_flags, enum frsrpc_PartnerAuthLevel r)
{
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_PartnerAuthLevel(struct ndr_pull *ndr, int ndr_flags, enum frsrpc_PartnerAuthLevel *r)
{
	uint32_t v;
	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_PartnerAuthLevel(struct ndr_print *ndr, const char *name, enum frsrpc_PartnerAuthLevel r)
{
	const char *val = NULL;

	{
		uint32_t _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSRPC_PARENT_AUTH_LEVEL_ENCRYPTED_KERBEROS: val = "FRSRPC_PARENT_AUTH_LEVEL_ENCRYPTED_KERBEROS"; break;
			case FRSRPC_PARENT_AUTH_LEVEL_NO_AUTHENTICATION: val = "FRSRPC_PARENT_AUTH_LEVEL_NO_AUTHENTICATION"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frsrpc_FrsSendCommPkt(struct ndr_push *ndr, int flags, const struct frsrpc_FrsSendCommPkt *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_frsrpc_FrsSendCommPktReq(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_FrsSendCommPkt(struct ndr_pull *ndr, int flags, struct frsrpc_FrsSendCommPkt *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_frsrpc_FrsSendCommPktReq(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_FrsSendCommPkt(struct ndr_print *ndr, const char *name, int flags, const struct frsrpc_FrsSendCommPkt *r)
{
	ndr_print_struct(ndr, name, "frsrpc_FrsSendCommPkt");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frsrpc_FrsSendCommPkt");
		ndr->depth++;
		ndr_print_frsrpc_FrsSendCommPktReq(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frsrpc_FrsSendCommPkt");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_FrsVerifyPromotionParent(struct ndr_push *ndr, int flags, const struct frsrpc_FrsVerifyPromotionParent *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parent_account));
		if (r->in.parent_account) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.parent_account, ndr_charset_length(r->in.parent_account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parent_password));
		if (r->in.parent_password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.parent_password, ndr_charset_length(r->in.parent_password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.replica_set_name));
		if (r->in.replica_set_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.replica_set_name, ndr_charset_length(r->in.replica_set_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.replica_set_type));
		if (r->in.replica_set_type) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.replica_set_type, ndr_charset_length(r->in.replica_set_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_frsrpc_PartnerAuthLevel(ndr, NDR_SCALARS, r->in.partner_auth_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.__ndr_guid_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_FrsVerifyPromotionParent(struct ndr_pull *ndr, int flags, struct frsrpc_FrsVerifyPromotionParent *r)
{
	uint32_t _ptr_parent_account;
	uint32_t _ptr_parent_password;
	uint32_t _ptr_replica_set_name;
	uint32_t _ptr_replica_set_type;
	TALLOC_CTX *_mem_save_parent_account_0;
	TALLOC_CTX *_mem_save_parent_password_0;
	TALLOC_CTX *_mem_save_replica_set_name_0;
	TALLOC_CTX *_mem_save_replica_set_type_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_account));
		if (_ptr_parent_account) {
			NDR_PULL_ALLOC(ndr, r->in.parent_account);
		} else {
			r->in.parent_account = NULL;
		}
		if (r->in.parent_account) {
			_mem_save_parent_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parent_account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.parent_account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.parent_account));
			if (ndr_get_array_length(ndr, &r->in.parent_account) > ndr_get_array_size(ndr, &r->in.parent_account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.parent_account), ndr_get_array_length(ndr, &r->in.parent_account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.parent_account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.parent_account, ndr_get_array_length(ndr, &r->in.parent_account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_password));
		if (_ptr_parent_password) {
			NDR_PULL_ALLOC(ndr, r->in.parent_password);
		} else {
			r->in.parent_password = NULL;
		}
		if (r->in.parent_password) {
			_mem_save_parent_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parent_password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.parent_password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.parent_password));
			if (ndr_get_array_length(ndr, &r->in.parent_password) > ndr_get_array_size(ndr, &r->in.parent_password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.parent_password), ndr_get_array_length(ndr, &r->in.parent_password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.parent_password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.parent_password, ndr_get_array_length(ndr, &r->in.parent_password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_replica_set_name));
		if (_ptr_replica_set_name) {
			NDR_PULL_ALLOC(ndr, r->in.replica_set_name);
		} else {
			r->in.replica_set_name = NULL;
		}
		if (r->in.replica_set_name) {
			_mem_save_replica_set_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.replica_set_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.replica_set_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.replica_set_name));
			if (ndr_get_array_length(ndr, &r->in.replica_set_name) > ndr_get_array_size(ndr, &r->in.replica_set_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.replica_set_name), ndr_get_array_length(ndr, &r->in.replica_set_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.replica_set_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.replica_set_name, ndr_get_array_length(ndr, &r->in.replica_set_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_replica_set_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_replica_set_type));
		if (_ptr_replica_set_type) {
			NDR_PULL_ALLOC(ndr, r->in.replica_set_type);
		} else {
			r->in.replica_set_type = NULL;
		}
		if (r->in.replica_set_type) {
			_mem_save_replica_set_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.replica_set_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.replica_set_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.replica_set_type));
			if (ndr_get_array_length(ndr, &r->in.replica_set_type) > ndr_get_array_size(ndr, &r->in.replica_set_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.replica_set_type), ndr_get_array_length(ndr, &r->in.replica_set_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.replica_set_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.replica_set_type, ndr_get_array_length(ndr, &r->in.replica_set_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_replica_set_type_0, 0);
		}
		NDR_CHECK(ndr_pull_frsrpc_PartnerAuthLevel(ndr, NDR_SCALARS, &r->in.partner_auth_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.__ndr_guid_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_FrsVerifyPromotionParent(struct ndr_print *ndr, const char *name, int flags, const struct frsrpc_FrsVerifyPromotionParent *r)
{
	ndr_print_struct(ndr, name, "frsrpc_FrsVerifyPromotionParent");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frsrpc_FrsVerifyPromotionParent");
		ndr->depth++;
		ndr_print_ptr(ndr, "parent_account", r->in.parent_account);
		ndr->depth++;
		if (r->in.parent_account) {
			ndr_print_string(ndr, "parent_account", r->in.parent_account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "parent_password", r->in.parent_password);
		ndr->depth++;
		if (r->in.parent_password) {
			ndr_print_string(ndr, "parent_password", r->in.parent_password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "replica_set_name", r->in.replica_set_name);
		ndr->depth++;
		if (r->in.replica_set_name) {
			ndr_print_string(ndr, "replica_set_name", r->in.replica_set_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "replica_set_type", r->in.replica_set_type);
		ndr->depth++;
		if (r->in.replica_set_type) {
			ndr_print_string(ndr, "replica_set_type", r->in.replica_set_type);
		}
		ndr->depth--;
		ndr_print_frsrpc_PartnerAuthLevel(ndr, "partner_auth_level", r->in.partner_auth_level);
		ndr_print_uint32(ndr, "__ndr_guid_size", r->in.__ndr_guid_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frsrpc_FrsVerifyPromotionParent");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_FrsStartPromotionParent(struct ndr_push *ndr, int flags, const struct frsrpc_FrsStartPromotionParent *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parent_account));
		if (r->in.parent_account) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.parent_account, ndr_charset_length(r->in.parent_account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parent_password));
		if (r->in.parent_password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.parent_password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.parent_password, ndr_charset_length(r->in.parent_password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.replica_set_name));
		if (r->in.replica_set_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.replica_set_name, ndr_charset_length(r->in.replica_set_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.replica_set_type));
		if (r->in.replica_set_type) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.replica_set_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.replica_set_type, ndr_charset_length(r->in.replica_set_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.connection_name));
		if (r->in.connection_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.connection_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.connection_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.connection_name, ndr_charset_length(r->in.connection_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.partner_name));
		if (r->in.partner_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.partner_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.partner_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.partner_name, ndr_charset_length(r->in.partner_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.partner_princ_name));
		if (r->in.partner_princ_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.partner_princ_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.partner_princ_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.partner_princ_name, ndr_charset_length(r->in.partner_princ_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_frsrpc_PartnerAuthLevel(ndr, NDR_SCALARS, r->in.partner_auth_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.connection_guid));
		if (r->in.connection_guid) {
			{
				struct ndr_push *_ndr_connection_guid;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_connection_guid, 4, 16));
				NDR_CHECK(ndr_push_GUID(_ndr_connection_guid, NDR_SCALARS, r->in.connection_guid));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_connection_guid, 4, 16));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.partner_guid));
		if (r->in.partner_guid) {
			{
				struct ndr_push *_ndr_partner_guid;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_partner_guid, 4, 16));
				NDR_CHECK(ndr_push_GUID(_ndr_partner_guid, NDR_SCALARS, r->in.partner_guid));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_partner_guid, 4, 16));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.parent_guid));
		if (r->in.parent_guid) {
			{
				struct ndr_push *_ndr_parent_guid;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_parent_guid, 4, 16));
				NDR_CHECK(ndr_push_GUID(_ndr_parent_guid, NDR_SCALARS, r->in.parent_guid));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_parent_guid, 4, 16));
			}
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.parent_guid));
		if (r->out.parent_guid) {
			{
				struct ndr_push *_ndr_parent_guid;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_parent_guid, 4, 16));
				NDR_CHECK(ndr_push_GUID(_ndr_parent_guid, NDR_SCALARS, r->out.parent_guid));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_parent_guid, 4, 16));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_FrsStartPromotionParent(struct ndr_pull *ndr, int flags, struct frsrpc_FrsStartPromotionParent *r)
{
	uint32_t _ptr_parent_account;
	uint32_t _ptr_parent_password;
	uint32_t _ptr_replica_set_name;
	uint32_t _ptr_replica_set_type;
	uint32_t _ptr_connection_name;
	uint32_t _ptr_partner_name;
	uint32_t _ptr_partner_princ_name;
	uint32_t _ptr_connection_guid;
	uint32_t _ptr_partner_guid;
	uint32_t _ptr_parent_guid;
	TALLOC_CTX *_mem_save_parent_account_0;
	TALLOC_CTX *_mem_save_parent_password_0;
	TALLOC_CTX *_mem_save_replica_set_name_0;
	TALLOC_CTX *_mem_save_replica_set_type_0;
	TALLOC_CTX *_mem_save_connection_name_0;
	TALLOC_CTX *_mem_save_partner_name_0;
	TALLOC_CTX *_mem_save_partner_princ_name_0;
	TALLOC_CTX *_mem_save_connection_guid_0;
	TALLOC_CTX *_mem_save_partner_guid_0;
	TALLOC_CTX *_mem_save_parent_guid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_account));
		if (_ptr_parent_account) {
			NDR_PULL_ALLOC(ndr, r->in.parent_account);
		} else {
			r->in.parent_account = NULL;
		}
		if (r->in.parent_account) {
			_mem_save_parent_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parent_account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.parent_account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.parent_account));
			if (ndr_get_array_length(ndr, &r->in.parent_account) > ndr_get_array_size(ndr, &r->in.parent_account)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.parent_account), ndr_get_array_length(ndr, &r->in.parent_account));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.parent_account), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.parent_account, ndr_get_array_length(ndr, &r->in.parent_account), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_account_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_password));
		if (_ptr_parent_password) {
			NDR_PULL_ALLOC(ndr, r->in.parent_password);
		} else {
			r->in.parent_password = NULL;
		}
		if (r->in.parent_password) {
			_mem_save_parent_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parent_password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.parent_password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.parent_password));
			if (ndr_get_array_length(ndr, &r->in.parent_password) > ndr_get_array_size(ndr, &r->in.parent_password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.parent_password), ndr_get_array_length(ndr, &r->in.parent_password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.parent_password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.parent_password, ndr_get_array_length(ndr, &r->in.parent_password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_replica_set_name));
		if (_ptr_replica_set_name) {
			NDR_PULL_ALLOC(ndr, r->in.replica_set_name);
		} else {
			r->in.replica_set_name = NULL;
		}
		if (r->in.replica_set_name) {
			_mem_save_replica_set_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.replica_set_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.replica_set_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.replica_set_name));
			if (ndr_get_array_length(ndr, &r->in.replica_set_name) > ndr_get_array_size(ndr, &r->in.replica_set_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.replica_set_name), ndr_get_array_length(ndr, &r->in.replica_set_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.replica_set_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.replica_set_name, ndr_get_array_length(ndr, &r->in.replica_set_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_replica_set_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_replica_set_type));
		if (_ptr_replica_set_type) {
			NDR_PULL_ALLOC(ndr, r->in.replica_set_type);
		} else {
			r->in.replica_set_type = NULL;
		}
		if (r->in.replica_set_type) {
			_mem_save_replica_set_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.replica_set_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.replica_set_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.replica_set_type));
			if (ndr_get_array_length(ndr, &r->in.replica_set_type) > ndr_get_array_size(ndr, &r->in.replica_set_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.replica_set_type), ndr_get_array_length(ndr, &r->in.replica_set_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.replica_set_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.replica_set_type, ndr_get_array_length(ndr, &r->in.replica_set_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_replica_set_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_connection_name));
		if (_ptr_connection_name) {
			NDR_PULL_ALLOC(ndr, r->in.connection_name);
		} else {
			r->in.connection_name = NULL;
		}
		if (r->in.connection_name) {
			_mem_save_connection_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.connection_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.connection_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.connection_name));
			if (ndr_get_array_length(ndr, &r->in.connection_name) > ndr_get_array_size(ndr, &r->in.connection_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.connection_name), ndr_get_array_length(ndr, &r->in.connection_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.connection_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.connection_name, ndr_get_array_length(ndr, &r->in.connection_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connection_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partner_name));
		if (_ptr_partner_name) {
			NDR_PULL_ALLOC(ndr, r->in.partner_name);
		} else {
			r->in.partner_name = NULL;
		}
		if (r->in.partner_name) {
			_mem_save_partner_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.partner_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.partner_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.partner_name));
			if (ndr_get_array_length(ndr, &r->in.partner_name) > ndr_get_array_size(ndr, &r->in.partner_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.partner_name), ndr_get_array_length(ndr, &r->in.partner_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.partner_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.partner_name, ndr_get_array_length(ndr, &r->in.partner_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partner_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partner_princ_name));
		if (_ptr_partner_princ_name) {
			NDR_PULL_ALLOC(ndr, r->in.partner_princ_name);
		} else {
			r->in.partner_princ_name = NULL;
		}
		if (r->in.partner_princ_name) {
			_mem_save_partner_princ_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.partner_princ_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.partner_princ_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.partner_princ_name));
			if (ndr_get_array_length(ndr, &r->in.partner_princ_name) > ndr_get_array_size(ndr, &r->in.partner_princ_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.partner_princ_name), ndr_get_array_length(ndr, &r->in.partner_princ_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.partner_princ_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.partner_princ_name, ndr_get_array_length(ndr, &r->in.partner_princ_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partner_princ_name_0, 0);
		}
		NDR_CHECK(ndr_pull_frsrpc_PartnerAuthLevel(ndr, NDR_SCALARS, &r->in.partner_auth_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.__ndr_guid_size));
		if (r->in.__ndr_guid_size < 16 || r->in.__ndr_guid_size > 16) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_connection_guid));
		if (_ptr_connection_guid) {
			NDR_PULL_ALLOC(ndr, r->in.connection_guid);
		} else {
			r->in.connection_guid = NULL;
		}
		if (r->in.connection_guid) {
			_mem_save_connection_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.connection_guid, 0);
			{
				struct ndr_pull *_ndr_connection_guid;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_connection_guid, 4, 16));
				NDR_CHECK(ndr_pull_GUID(_ndr_connection_guid, NDR_SCALARS, r->in.connection_guid));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_connection_guid, 4, 16));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connection_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partner_guid));
		if (_ptr_partner_guid) {
			NDR_PULL_ALLOC(ndr, r->in.partner_guid);
		} else {
			r->in.partner_guid = NULL;
		}
		if (r->in.partner_guid) {
			_mem_save_partner_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.partner_guid, 0);
			{
				struct ndr_pull *_ndr_partner_guid;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_partner_guid, 4, 16));
				NDR_CHECK(ndr_pull_GUID(_ndr_partner_guid, NDR_SCALARS, r->in.partner_guid));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_partner_guid, 4, 16));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partner_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_guid));
		if (_ptr_parent_guid) {
			NDR_PULL_ALLOC(ndr, r->in.parent_guid);
		} else {
			r->in.parent_guid = NULL;
		}
		if (r->in.parent_guid) {
			_mem_save_parent_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.parent_guid, 0);
			{
				struct ndr_pull *_ndr_parent_guid;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_parent_guid, 4, 16));
				NDR_CHECK(ndr_pull_GUID(_ndr_parent_guid, NDR_SCALARS, r->in.parent_guid));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_parent_guid, 4, 16));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_guid_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_guid));
		if (_ptr_parent_guid) {
			NDR_PULL_ALLOC(ndr, r->out.parent_guid);
		} else {
			r->out.parent_guid = NULL;
		}
		if (r->out.parent_guid) {
			_mem_save_parent_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.parent_guid, 0);
			{
				struct ndr_pull *_ndr_parent_guid;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_parent_guid, 4, 16));
				NDR_CHECK(ndr_pull_GUID(_ndr_parent_guid, NDR_SCALARS, r->out.parent_guid));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_parent_guid, 4, 16));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_FrsStartPromotionParent(struct ndr_print *ndr, const char *name, int flags, const struct frsrpc_FrsStartPromotionParent *r)
{
	ndr_print_struct(ndr, name, "frsrpc_FrsStartPromotionParent");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frsrpc_FrsStartPromotionParent");
		ndr->depth++;
		ndr_print_ptr(ndr, "parent_account", r->in.parent_account);
		ndr->depth++;
		if (r->in.parent_account) {
			ndr_print_string(ndr, "parent_account", r->in.parent_account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "parent_password", r->in.parent_password);
		ndr->depth++;
		if (r->in.parent_password) {
			ndr_print_string(ndr, "parent_password", r->in.parent_password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "replica_set_name", r->in.replica_set_name);
		ndr->depth++;
		if (r->in.replica_set_name) {
			ndr_print_string(ndr, "replica_set_name", r->in.replica_set_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "replica_set_type", r->in.replica_set_type);
		ndr->depth++;
		if (r->in.replica_set_type) {
			ndr_print_string(ndr, "replica_set_type", r->in.replica_set_type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "connection_name", r->in.connection_name);
		ndr->depth++;
		if (r->in.connection_name) {
			ndr_print_string(ndr, "connection_name", r->in.connection_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "partner_name", r->in.partner_name);
		ndr->depth++;
		if (r->in.partner_name) {
			ndr_print_string(ndr, "partner_name", r->in.partner_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "partner_princ_name", r->in.partner_princ_name);
		ndr->depth++;
		if (r->in.partner_princ_name) {
			ndr_print_string(ndr, "partner_princ_name", r->in.partner_princ_name);
		}
		ndr->depth--;
		ndr_print_frsrpc_PartnerAuthLevel(ndr, "partner_auth_level", r->in.partner_auth_level);
		ndr_print_uint32(ndr, "__ndr_guid_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?16:r->in.__ndr_guid_size);
		ndr_print_ptr(ndr, "connection_guid", r->in.connection_guid);
		ndr->depth++;
		if (r->in.connection_guid) {
			ndr_print_GUID(ndr, "connection_guid", r->in.connection_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "partner_guid", r->in.partner_guid);
		ndr->depth++;
		if (r->in.partner_guid) {
			ndr_print_GUID(ndr, "partner_guid", r->in.partner_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "parent_guid", r->in.parent_guid);
		ndr->depth++;
		if (r->in.parent_guid) {
			ndr_print_GUID(ndr, "parent_guid", r->in.parent_guid);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frsrpc_FrsStartPromotionParent");
		ndr->depth++;
		ndr_print_ptr(ndr, "parent_guid", r->out.parent_guid);
		ndr->depth++;
		if (r->out.parent_guid) {
			ndr_print_GUID(ndr, "parent_guid", r->out.parent_guid);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frsrpc_FrsNOP(struct ndr_push *ndr, int flags, const struct frsrpc_FrsNOP *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frsrpc_FrsNOP(struct ndr_pull *ndr, int flags, struct frsrpc_FrsNOP *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frsrpc_FrsNOP(struct ndr_print *ndr, const char *name, int flags, const struct frsrpc_FrsNOP *r)
{
	ndr_print_struct(ndr, name, "frsrpc_FrsNOP");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frsrpc_FrsNOP");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frsrpc_FrsNOP");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_BACKUP_COMPLETE(struct ndr_push *ndr, int flags, const struct FRSRPC_BACKUP_COMPLETE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_BACKUP_COMPLETE(struct ndr_pull *ndr, int flags, struct FRSRPC_BACKUP_COMPLETE *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_BACKUP_COMPLETE(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_BACKUP_COMPLETE *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_BACKUP_COMPLETE");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_BACKUP_COMPLETE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_BACKUP_COMPLETE");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_BACKUP_COMPLETE_5(struct ndr_push *ndr, int flags, const struct FRSRPC_BACKUP_COMPLETE_5 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_BACKUP_COMPLETE_5(struct ndr_pull *ndr, int flags, struct FRSRPC_BACKUP_COMPLETE_5 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_BACKUP_COMPLETE_5(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_BACKUP_COMPLETE_5 *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_BACKUP_COMPLETE_5");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_BACKUP_COMPLETE_5");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_BACKUP_COMPLETE_5");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_BACKUP_COMPLETE_6(struct ndr_push *ndr, int flags, const struct FRSRPC_BACKUP_COMPLETE_6 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_BACKUP_COMPLETE_6(struct ndr_pull *ndr, int flags, struct FRSRPC_BACKUP_COMPLETE_6 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_BACKUP_COMPLETE_6(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_BACKUP_COMPLETE_6 *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_BACKUP_COMPLETE_6");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_BACKUP_COMPLETE_6");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_BACKUP_COMPLETE_6");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_BACKUP_COMPLETE_7(struct ndr_push *ndr, int flags, const struct FRSRPC_BACKUP_COMPLETE_7 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_BACKUP_COMPLETE_7(struct ndr_pull *ndr, int flags, struct FRSRPC_BACKUP_COMPLETE_7 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_BACKUP_COMPLETE_7(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_BACKUP_COMPLETE_7 *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_BACKUP_COMPLETE_7");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_BACKUP_COMPLETE_7");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_BACKUP_COMPLETE_7");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_BACKUP_COMPLETE_8(struct ndr_push *ndr, int flags, const struct FRSRPC_BACKUP_COMPLETE_8 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_BACKUP_COMPLETE_8(struct ndr_pull *ndr, int flags, struct FRSRPC_BACKUP_COMPLETE_8 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_BACKUP_COMPLETE_8(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_BACKUP_COMPLETE_8 *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_BACKUP_COMPLETE_8");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_BACKUP_COMPLETE_8");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_BACKUP_COMPLETE_8");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_BACKUP_COMPLETE_9(struct ndr_push *ndr, int flags, const struct FRSRPC_BACKUP_COMPLETE_9 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_BACKUP_COMPLETE_9(struct ndr_pull *ndr, int flags, struct FRSRPC_BACKUP_COMPLETE_9 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_BACKUP_COMPLETE_9(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_BACKUP_COMPLETE_9 *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_BACKUP_COMPLETE_9");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_BACKUP_COMPLETE_9");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_BACKUP_COMPLETE_9");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSRPC_VERIFY_PROMOTION_PARENT_EX(struct ndr_push *ndr, int flags, const struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSRPC_VERIFY_PROMOTION_PARENT_EX(struct ndr_pull *ndr, int flags, struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSRPC_VERIFY_PROMOTION_PARENT_EX(struct ndr_print *ndr, const char *name, int flags, const struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *r)
{
	ndr_print_struct(ndr, name, "FRSRPC_VERIFY_PROMOTION_PARENT_EX");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSRPC_VERIFY_PROMOTION_PARENT_EX");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSRPC_VERIFY_PROMOTION_PARENT_EX");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call frsrpc_calls[] = {
	{
		"frsrpc_FrsSendCommPkt",
		sizeof(struct frsrpc_FrsSendCommPkt),
		(ndr_push_flags_fn_t) ndr_push_frsrpc_FrsSendCommPkt,
		(ndr_pull_flags_fn_t) ndr_pull_frsrpc_FrsSendCommPkt,
		(ndr_print_function_t) ndr_print_frsrpc_FrsSendCommPkt,
		false,
	},
	{
		"frsrpc_FrsVerifyPromotionParent",
		sizeof(struct frsrpc_FrsVerifyPromotionParent),
		(ndr_push_flags_fn_t) ndr_push_frsrpc_FrsVerifyPromotionParent,
		(ndr_pull_flags_fn_t) ndr_pull_frsrpc_FrsVerifyPromotionParent,
		(ndr_print_function_t) ndr_print_frsrpc_FrsVerifyPromotionParent,
		false,
	},
	{
		"frsrpc_FrsStartPromotionParent",
		sizeof(struct frsrpc_FrsStartPromotionParent),
		(ndr_push_flags_fn_t) ndr_push_frsrpc_FrsStartPromotionParent,
		(ndr_pull_flags_fn_t) ndr_pull_frsrpc_FrsStartPromotionParent,
		(ndr_print_function_t) ndr_print_frsrpc_FrsStartPromotionParent,
		false,
	},
	{
		"frsrpc_FrsNOP",
		sizeof(struct frsrpc_FrsNOP),
		(ndr_push_flags_fn_t) ndr_push_frsrpc_FrsNOP,
		(ndr_pull_flags_fn_t) ndr_pull_frsrpc_FrsNOP,
		(ndr_print_function_t) ndr_print_frsrpc_FrsNOP,
		false,
	},
	{
		"FRSRPC_BACKUP_COMPLETE",
		sizeof(struct FRSRPC_BACKUP_COMPLETE),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_BACKUP_COMPLETE,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_BACKUP_COMPLETE,
		(ndr_print_function_t) ndr_print_FRSRPC_BACKUP_COMPLETE,
		false,
	},
	{
		"FRSRPC_BACKUP_COMPLETE_5",
		sizeof(struct FRSRPC_BACKUP_COMPLETE_5),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_BACKUP_COMPLETE_5,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_BACKUP_COMPLETE_5,
		(ndr_print_function_t) ndr_print_FRSRPC_BACKUP_COMPLETE_5,
		false,
	},
	{
		"FRSRPC_BACKUP_COMPLETE_6",
		sizeof(struct FRSRPC_BACKUP_COMPLETE_6),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_BACKUP_COMPLETE_6,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_BACKUP_COMPLETE_6,
		(ndr_print_function_t) ndr_print_FRSRPC_BACKUP_COMPLETE_6,
		false,
	},
	{
		"FRSRPC_BACKUP_COMPLETE_7",
		sizeof(struct FRSRPC_BACKUP_COMPLETE_7),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_BACKUP_COMPLETE_7,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_BACKUP_COMPLETE_7,
		(ndr_print_function_t) ndr_print_FRSRPC_BACKUP_COMPLETE_7,
		false,
	},
	{
		"FRSRPC_BACKUP_COMPLETE_8",
		sizeof(struct FRSRPC_BACKUP_COMPLETE_8),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_BACKUP_COMPLETE_8,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_BACKUP_COMPLETE_8,
		(ndr_print_function_t) ndr_print_FRSRPC_BACKUP_COMPLETE_8,
		false,
	},
	{
		"FRSRPC_BACKUP_COMPLETE_9",
		sizeof(struct FRSRPC_BACKUP_COMPLETE_9),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_BACKUP_COMPLETE_9,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_BACKUP_COMPLETE_9,
		(ndr_print_function_t) ndr_print_FRSRPC_BACKUP_COMPLETE_9,
		false,
	},
	{
		"FRSRPC_VERIFY_PROMOTION_PARENT_EX",
		sizeof(struct FRSRPC_VERIFY_PROMOTION_PARENT_EX),
		(ndr_push_flags_fn_t) ndr_push_FRSRPC_VERIFY_PROMOTION_PARENT_EX,
		(ndr_pull_flags_fn_t) ndr_pull_FRSRPC_VERIFY_PROMOTION_PARENT_EX,
		(ndr_print_function_t) ndr_print_FRSRPC_VERIFY_PROMOTION_PARENT_EX,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const frsrpc_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array frsrpc_endpoints = {
	.count	= 2,
	.names	= frsrpc_endpoint_strings
};

static const char * const frsrpc_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array frsrpc_authservices = {
	.count	= 1,
	.names	= frsrpc_authservice_strings
};


const struct ndr_interface_table ndr_table_frsrpc = {
	.name		= "frsrpc",
	.syntax_id	= {
		{0xf5cc59b4,0x4264,0x101a,{0x8c,0x59},{0x08,0x00,0x2b,0x2f,0x84,0x26}},
		NDR_FRSRPC_VERSION
	},
	.helpstring	= NDR_FRSRPC_HELPSTRING,
	.num_calls	= 11,
	.calls		= frsrpc_calls,
	.endpoints	= &frsrpc_endpoints,
	.authservices	= &frsrpc_authservices
};

