#include "../librpc/gen_ndr/ndr_wmi.h"
#ifndef __CLI_IWBEMCLASSOBJECT__
#define __CLI_IWBEMCLASSOBJECT__
struct tevent_req *rpccli_Delete_send(TALLOC_CTX *mem_ctx,
				      struct tevent_context *ev,
				      struct rpc_pipe_client *cli,
				      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS _ORPCthis /* [in]  */,
				      const char *_wszName /* [in] [ref,charset(UTF16)] */);
NTSTATUS rpccli_Delete_recv(struct tevent_req *req,
			    TALLOC_CTX *mem_ctx,
			    WERROR *result);
NTSTATUS rpccli_Delete(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */,
		       const char *wszName /* [in] [ref,charset(UTF16)] */,
		       WERROR *werror);
#endif /* __CLI_IWBEMCLASSOBJECT__ */
#ifndef __CLI_IWBEMSERVICES__
#define __CLI_IWBEMSERVICES__
struct tevent_req *rpccli_OpenNamespace_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct BSTR _strNamespace /* [in]  */,
					     int32_t _lFlags /* [in]  */,
					     struct MInterfacePointer *_pCtx /* [in] [ref] */,
					     struct MInterfacePointer **_ppWorkingNamespace /* [in,out] [unique] */,
					     struct MInterfacePointer **_ppResult /* [in,out] [unique] */);
NTSTATUS rpccli_OpenNamespace_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result);
NTSTATUS rpccli_OpenNamespace(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct BSTR strNamespace /* [in]  */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer **ppWorkingNamespace /* [in,out] [unique] */,
			      struct MInterfacePointer **ppResult /* [in,out] [unique] */,
			      WERROR *werror);
struct tevent_req *rpccli_CancelAsyncCall_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct MInterfacePointer *_pSink /* [in] [ref] */);
NTSTATUS rpccli_CancelAsyncCall_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_CancelAsyncCall(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct MInterfacePointer *pSink /* [in] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_QueryObjectSink_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lFlags /* [in]  */,
					       struct MInterfacePointer **_ppResponseHandler /* [out] [ref] */);
NTSTATUS rpccli_QueryObjectSink_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_QueryObjectSink(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer **ppResponseHandler /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_GetObject_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 struct BSTR _strObjectPath /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [ref] */,
					 struct MInterfacePointer **_ppObject /* [in,out] [unique] */,
					 struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */);
NTSTATUS rpccli_GetObject_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_GetObject(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strObjectPath /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppObject /* [in,out] [unique] */,
			  struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			  WERROR *werror);
struct tevent_req *rpccli_GetObjectAsync_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strObjectPath /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_GetObjectAsync_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_GetObjectAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror);
struct tevent_req *rpccli_PutClass_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					struct MInterfacePointer *_pObject /* [in] [ref] */,
					int32_t _lFlags /* [in]  */,
					struct MInterfacePointer *_pCtx /* [in] [ref] */,
					struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */);
NTSTATUS rpccli_PutClass_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result);
NTSTATUS rpccli_PutClass(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 struct MInterfacePointer *pObject /* [in] [ref] */,
			 int32_t lFlags /* [in]  */,
			 struct MInterfacePointer *pCtx /* [in] [ref] */,
			 struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			 WERROR *werror);
struct tevent_req *rpccli_PutClassAsync_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct MInterfacePointer *_pObject /* [in] [ref] */,
					     int32_t _lFlags /* [in]  */,
					     struct MInterfacePointer *_pCtx /* [in] [ref] */,
					     struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_PutClassAsync_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result);
NTSTATUS rpccli_PutClassAsync(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct MInterfacePointer *pObject /* [in] [ref] */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			      WERROR *werror);
struct tevent_req *rpccli_DeleteClass_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct BSTR _strClass /* [in]  */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */);
NTSTATUS rpccli_DeleteClass_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result);
NTSTATUS rpccli_DeleteClass(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct BSTR strClass /* [in]  */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror);
struct tevent_req *rpccli_DeleteClassAsync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						struct BSTR _strClass /* [in]  */,
						int32_t _lFlags /* [in]  */,
						struct MInterfacePointer *_pCtx /* [in] [ref] */,
						struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_DeleteClassAsync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_DeleteClassAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct BSTR strClass /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror);
struct tevent_req *rpccli_CreateClassEnum_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct BSTR _strSuperclass /* [in]  */,
					       int32_t _lFlags /* [in]  */,
					       struct MInterfacePointer *_pCtx /* [in] [ref] */,
					       struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_CreateClassEnum_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_CreateClassEnum(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strSuperclass /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer **ppEnum /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_CreateClassEnumAsync_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						    struct ORPCTHIS _ORPCthis /* [in]  */,
						    struct BSTR _strSuperclass /* [in]  */,
						    int32_t _lFlags /* [in]  */,
						    struct MInterfacePointer *_pCtx /* [in] [ref] */,
						    struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_CreateClassEnumAsync_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result);
NTSTATUS rpccli_CreateClassEnumAsync(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS ORPCthis /* [in]  */,
				     struct BSTR strSuperclass /* [in]  */,
				     int32_t lFlags /* [in]  */,
				     struct MInterfacePointer *pCtx /* [in] [ref] */,
				     struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				     WERROR *werror);
struct tevent_req *rpccli_PutInstance_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct MInterfacePointer *_pInst /* [in] [ref] */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */);
NTSTATUS rpccli_PutInstance_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result);
NTSTATUS rpccli_PutInstance(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct MInterfacePointer *pInst /* [in] [ref] */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror);
struct tevent_req *rpccli_PutInstanceAsync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						struct MInterfacePointer *_pInst /* [in] [ref] */,
						int32_t _lFlags /* [in]  */,
						struct MInterfacePointer *_pCtx /* [in] [ref] */,
						struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_PutInstanceAsync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_PutInstanceAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct MInterfacePointer *pInst /* [in] [ref] */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror);
struct tevent_req *rpccli_DeleteInstance_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strObjectPath /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */);
NTSTATUS rpccli_DeleteInstance_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_DeleteInstance(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			       WERROR *werror);
struct tevent_req *rpccli_DeleteInstanceAsync_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						   struct ORPCTHIS _ORPCthis /* [in]  */,
						   struct BSTR _strObjectPath /* [in]  */,
						   int32_t _lFlags /* [in]  */,
						   struct MInterfacePointer *_pCtx /* [in] [ref] */,
						   struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_DeleteInstanceAsync_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_DeleteInstanceAsync(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS ORPCthis /* [in]  */,
				    struct BSTR strObjectPath /* [in]  */,
				    int32_t lFlags /* [in]  */,
				    struct MInterfacePointer *pCtx /* [in] [ref] */,
				    struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				    WERROR *werror);
struct tevent_req *rpccli_CreateInstanceEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS _ORPCthis /* [in]  */,
						  struct BSTR _strFilter /* [in]  */,
						  int32_t _lFlags /* [in]  */,
						  struct MInterfacePointer *_pCtx /* [in] [unique] */,
						  struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_CreateInstanceEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result);
NTSTATUS rpccli_CreateInstanceEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   struct BSTR strFilter /* [in]  */,
				   int32_t lFlags /* [in]  */,
				   struct MInterfacePointer *pCtx /* [in] [unique] */,
				   struct MInterfacePointer **ppEnum /* [out] [ref] */,
				   WERROR *werror);
struct tevent_req *rpccli_CreateInstanceEnumAsync_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						       struct ORPCTHIS _ORPCthis /* [in]  */,
						       struct BSTR _strSuperClass /* [in]  */,
						       int32_t _lFlags /* [in]  */,
						       struct MInterfacePointer *_pCtx /* [in] [ref] */,
						       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_CreateInstanceEnumAsync_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result);
NTSTATUS rpccli_CreateInstanceEnumAsync(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					struct ORPCTHIS ORPCthis /* [in]  */,
					struct BSTR strSuperClass /* [in]  */,
					int32_t lFlags /* [in]  */,
					struct MInterfacePointer *pCtx /* [in] [ref] */,
					struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					WERROR *werror);
struct tevent_req *rpccli_ExecQuery_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 struct BSTR _strQueryLanguage /* [in]  */,
					 struct BSTR _strQuery /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [unique] */,
					 struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_ExecQuery_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_ExecQuery(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strQueryLanguage /* [in]  */,
			  struct BSTR strQuery /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppEnum /* [out] [ref] */,
			  WERROR *werror);
struct tevent_req *rpccli_ExecQueryAsync_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strQueryLanguage /* [in]  */,
					      struct BSTR _strQuery /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_ExecQueryAsync_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_ExecQueryAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strQueryLanguage /* [in]  */,
			       struct BSTR strQuery /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror);
struct tevent_req *rpccli_ExecNotificationQuery_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						     struct ORPCTHIS _ORPCthis /* [in]  */,
						     struct BSTR _strQueryLanguage /* [in]  */,
						     struct BSTR _strQuery /* [in]  */,
						     int32_t _lFlags /* [in]  */,
						     struct MInterfacePointer *_pCtx /* [in] [unique] */,
						     struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_ExecNotificationQuery_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_ExecNotificationQuery(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS ORPCthis /* [in]  */,
				      struct BSTR strQueryLanguage /* [in]  */,
				      struct BSTR strQuery /* [in]  */,
				      int32_t lFlags /* [in]  */,
				      struct MInterfacePointer *pCtx /* [in] [unique] */,
				      struct MInterfacePointer **ppEnum /* [out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_ExecNotificationQueryAsync_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							  struct ORPCTHIS _ORPCthis /* [in]  */,
							  struct BSTR _strQueryLanguage /* [in]  */,
							  struct BSTR _strQuery /* [in]  */,
							  int32_t _lFlags /* [in]  */,
							  struct MInterfacePointer *_pCtx /* [in] [ref] */,
							  struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_ExecNotificationQueryAsync_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_ExecNotificationQueryAsync(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct BSTR strQueryLanguage /* [in]  */,
					   struct BSTR strQuery /* [in]  */,
					   int32_t lFlags /* [in]  */,
					   struct MInterfacePointer *pCtx /* [in] [ref] */,
					   struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					   WERROR *werror);
struct tevent_req *rpccli_ExecMethod_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  struct BSTR _strObjectPath /* [in]  */,
					  struct BSTR _strMethodName /* [in]  */,
					  int32_t _lFlags /* [in]  */,
					  struct MInterfacePointer *_pCtx /* [in] [unique] */,
					  struct MInterfacePointer *_pInParams /* [in] [unique] */,
					  struct MInterfacePointer **_ppOutParams /* [in,out] [unique] */,
					  struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */);
NTSTATUS rpccli_ExecMethod_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result);
NTSTATUS rpccli_ExecMethod(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   struct BSTR strObjectPath /* [in]  */,
			   struct BSTR strMethodName /* [in]  */,
			   int32_t lFlags /* [in]  */,
			   struct MInterfacePointer *pCtx /* [in] [unique] */,
			   struct MInterfacePointer *pInParams /* [in] [unique] */,
			   struct MInterfacePointer **ppOutParams /* [in,out] [unique] */,
			   struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			   WERROR *werror);
struct tevent_req *rpccli_ExecMethodAsync_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct BSTR _strObjectPath /* [in]  */,
					       struct BSTR _strMethodName /* [in]  */,
					       uint32_t _lFlags /* [in]  */,
					       struct MInterfacePointer *_pCtx /* [in] [ref] */,
					       struct MInterfacePointer *_pInParams /* [in] [ref] */,
					       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */);
NTSTATUS rpccli_ExecMethodAsync_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_ExecMethodAsync(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strObjectPath /* [in]  */,
				struct BSTR strMethodName /* [in]  */,
				uint32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer *pInParams /* [in] [ref] */,
				struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				WERROR *werror);
#endif /* __CLI_IWBEMSERVICES__ */
#ifndef __CLI_IENUMWBEMCLASSOBJECT__
#define __CLI_IENUMWBEMCLASSOBJECT__
struct tevent_req *rpccli_Reset_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_Reset_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result);
NTSTATUS rpccli_Reset(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      WERROR *werror);
struct tevent_req *rpccli_IEnumWbemClassObject_Next_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							 struct ORPCTHIS _ORPCthis /* [in]  */,
							 int32_t _lTimeout /* [in]  */,
							 uint32_t _uCount /* [in]  */,
							 struct MInterfacePointer **_apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
							 uint32_t *_puReturned /* [out] [ref] */);
NTSTATUS rpccli_IEnumWbemClassObject_Next_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result);
NTSTATUS rpccli_IEnumWbemClassObject_Next(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS ORPCthis /* [in]  */,
					  int32_t lTimeout /* [in]  */,
					  uint32_t uCount /* [in]  */,
					  struct MInterfacePointer **apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
					  uint32_t *puReturned /* [out] [ref] */,
					  WERROR *werror);
struct tevent_req *rpccli_NextAsync_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 uint32_t _uCount /* [in]  */,
					 struct MInterfacePointer *_pSink /* [in] [ref] */);
NTSTATUS rpccli_NextAsync_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_NextAsync(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  uint32_t uCount /* [in]  */,
			  struct MInterfacePointer *pSink /* [in] [ref] */,
			  WERROR *werror);
struct tevent_req *rpccli_IEnumWbemClassObject_Clone_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							  struct ORPCTHIS _ORPCthis /* [in]  */,
							  struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_IEnumWbemClassObject_Clone_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_IEnumWbemClassObject_Clone(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct MInterfacePointer **ppEnum /* [out] [ref] */,
					   WERROR *werror);
struct tevent_req *rpccli_Skip_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    int32_t _lTimeout /* [in]  */,
				    uint32_t _nCount /* [in]  */);
NTSTATUS rpccli_Skip_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result);
NTSTATUS rpccli_Skip(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     int32_t lTimeout /* [in]  */,
		     uint32_t nCount /* [in]  */,
		     WERROR *werror);
#endif /* __CLI_IENUMWBEMCLASSOBJECT__ */
#ifndef __CLI_IWBEMCONTEXT__
#define __CLI_IWBEMCONTEXT__
struct tevent_req *rpccli_Clone_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct MInterfacePointer **_ppNewCopy /* [out] [ref] */);
NTSTATUS rpccli_Clone_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result);
NTSTATUS rpccli_Clone(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppNewCopy /* [out] [ref] */,
		      WERROR *werror);
struct tevent_req *rpccli_GetNames_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_GetNames_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result);
NTSTATUS rpccli_GetNames(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror);
struct tevent_req *rpccli_BeginEnumeration_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						int32_t _lFlags /* [in]  */);
NTSTATUS rpccli_BeginEnumeration_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_BeginEnumeration(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 WERROR *werror);
struct tevent_req *rpccli_Next_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_Next_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result);
NTSTATUS rpccli_Next(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     WERROR *werror);
struct tevent_req *rpccli_EndEnumeration_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_EndEnumeration_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result);
NTSTATUS rpccli_EndEnumeration(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       WERROR *werror);
struct tevent_req *rpccli_SetValue_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_SetValue_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result);
NTSTATUS rpccli_SetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror);
struct tevent_req *rpccli_GetValue_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_GetValue_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result);
NTSTATUS rpccli_GetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror);
struct tevent_req *rpccli_DeleteValue_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_DeleteValue_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result);
NTSTATUS rpccli_DeleteValue(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    WERROR *werror);
struct tevent_req *rpccli_DeleteAll_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */);
NTSTATUS rpccli_DeleteAll_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_DeleteAll(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  WERROR *werror);
#endif /* __CLI_IWBEMCONTEXT__ */
#ifndef __CLI_IWBEMLEVEL1LOGIN__
#define __CLI_IWBEMLEVEL1LOGIN__
struct tevent_req *rpccli_EstablishPosition_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 const char *_wszLocaleList /* [in] [unique,charset(UTF16)] */,
						 uint32_t _dwNumLocales /* [in]  */,
						 uint32_t *_reserved /* [out] [ref] */);
NTSTATUS rpccli_EstablishPosition_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_EstablishPosition(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  const char *wszLocaleList /* [in] [unique,charset(UTF16)] */,
				  uint32_t dwNumLocales /* [in]  */,
				  uint32_t *reserved /* [out] [ref] */,
				  WERROR *werror);
struct tevent_req *rpccli_RequestChallenge_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						const char *_wszNetworkResource /* [in] [unique,charset(UTF16)] */,
						const char *_wszUser /* [in] [unique,charset(UTF16)] */,
						uint8_t *_Nonce /* [out] [ref,length_is(16),size_is(16)] */);
NTSTATUS rpccli_RequestChallenge_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result);
NTSTATUS rpccli_RequestChallenge(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
				 const char *wszUser /* [in] [unique,charset(UTF16)] */,
				 uint8_t *Nonce /* [out] [ref,length_is(16),size_is(16)] */,
				 WERROR *werror);
struct tevent_req *rpccli_WBEMLogin_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 const char *_wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
					 uint8_t *_AccessToken /* [in] [unique,length_is(16),size_is(16)] */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [ref] */,
					 struct MInterfacePointer **_ppNamespace /* [out] [ref] */);
NTSTATUS rpccli_WBEMLogin_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_WBEMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  uint8_t *AccessToken /* [in] [unique,length_is(16),size_is(16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror);
struct tevent_req *rpccli_NTLMLogin_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 const char *_wszNetworkResource /* [in] [unique,charset(UTF16)] */,
					 const char *_wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [unique] */,
					 struct MInterfacePointer **_ppNamespace /* [out] [ref] */);
NTSTATUS rpccli_NTLMLogin_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_NTLMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror);
#endif /* __CLI_IWBEMLEVEL1LOGIN__ */
#ifndef __CLI_IWBEMWCOSMARTENUM__
#define __CLI_IWBEMWCOSMARTENUM__
struct tevent_req *rpccli_IWbemWCOSmartEnum_Next_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						      struct ORPCTHIS _ORPCthis /* [in]  */,
						      struct GUID *_gEWCO /* [in] [ref] */,
						      uint32_t _lTimeOut /* [in]  */,
						      uint32_t _uCount /* [in]  */,
						      uint32_t _unknown /* [in]  */,
						      struct GUID *_gWCO /* [in] [ref] */,
						      uint32_t *_puReturned /* [out] [ref] */,
						      uint32_t *_pSize /* [out] [ref] */,
						      uint8_t **_pData /* [out] [noprint,ref,size_is(,*pSize)] */);
NTSTATUS rpccli_IWbemWCOSmartEnum_Next_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result);
NTSTATUS rpccli_IWbemWCOSmartEnum_Next(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				       struct ORPCTHIS ORPCthis /* [in]  */,
				       struct GUID *gEWCO /* [in] [ref] */,
				       uint32_t lTimeOut /* [in]  */,
				       uint32_t uCount /* [in]  */,
				       uint32_t unknown /* [in]  */,
				       struct GUID *gWCO /* [in] [ref] */,
				       uint32_t *puReturned /* [out] [ref] */,
				       uint32_t *pSize /* [out] [ref] */,
				       uint8_t **pData /* [out] [noprint,ref,size_is(,*pSize)] */,
				       WERROR *werror);
#endif /* __CLI_IWBEMWCOSMARTENUM__ */
#ifndef __CLI_IWBEMFETCHSMARTENUM__
#define __CLI_IWBEMFETCHSMARTENUM__
struct tevent_req *rpccli_Fetch_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_Fetch_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result);
NTSTATUS rpccli_Fetch(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppEnum /* [out] [ref] */,
		      WERROR *werror);
struct tevent_req *rpccli_Test_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    struct MInterfacePointer **_ppEnum /* [out] [ref] */);
NTSTATUS rpccli_Test_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result);
NTSTATUS rpccli_Test(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     struct MInterfacePointer **ppEnum /* [out] [ref] */,
		     WERROR *werror);
#endif /* __CLI_IWBEMFETCHSMARTENUM__ */
#ifndef __CLI_IWBEMCALLRESULT__
#define __CLI_IWBEMCALLRESULT__
struct tevent_req *rpccli_GetResultObject_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lTimeout /* [in]  */,
					       struct MInterfacePointer **_ppResultObject /* [out] [ref] */);
NTSTATUS rpccli_GetResultObject_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_GetResultObject(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct MInterfacePointer **ppResultObject /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_GetResultString_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lTimeout /* [in]  */,
					       struct BSTR *_pstrResultString /* [out] [ref] */);
NTSTATUS rpccli_GetResultString_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result);
NTSTATUS rpccli_GetResultString(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct BSTR *pstrResultString /* [out] [ref] */,
				WERROR *werror);
struct tevent_req *rpccli_GetResultServices_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 int32_t _lTimeout /* [in]  */,
						 struct MInterfacePointer **_ppServices /* [out] [ref] */);
NTSTATUS rpccli_GetResultServices_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result);
NTSTATUS rpccli_GetResultServices(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  int32_t lTimeout /* [in]  */,
				  struct MInterfacePointer **ppServices /* [out] [ref] */,
				  WERROR *werror);
struct tevent_req *rpccli_GetCallStatus_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     int32_t _lTimeout /* [in]  */,
					     int32_t *_plStatus /* [out] [ref] */);
NTSTATUS rpccli_GetCallStatus_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result);
NTSTATUS rpccli_GetCallStatus(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      int32_t lTimeout /* [in]  */,
			      int32_t *plStatus /* [out] [ref] */,
			      WERROR *werror);
#endif /* __CLI_IWBEMCALLRESULT__ */
#ifndef __CLI_IWBEMOBJECTSINK__
#define __CLI_IWBEMOBJECTSINK__
struct tevent_req *rpccli_SetStatus_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 WERROR _hResult /* [in]  */,
					 struct BSTR _strParam /* [in]  */,
					 struct MInterfacePointer *_pObjParam /* [in] [ref] */);
NTSTATUS rpccli_SetStatus_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result);
NTSTATUS rpccli_SetStatus(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  WERROR hResult /* [in]  */,
			  struct BSTR strParam /* [in]  */,
			  struct MInterfacePointer *pObjParam /* [in] [ref] */,
			  WERROR *werror);
struct tevent_req *rpccli_Indicate_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					int32_t _lObjectCount /* [in]  */,
					struct MInterfacePointer **_apObjArray /* [in] [ref,size_is(lObjectCount)] */);
NTSTATUS rpccli_Indicate_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result);
NTSTATUS rpccli_Indicate(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 int32_t lObjectCount /* [in]  */,
			 struct MInterfacePointer **apObjArray /* [in] [ref,size_is(lObjectCount)] */,
			 WERROR *werror);
#endif /* __CLI_IWBEMOBJECTSINK__ */
