/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_dcom.h"

struct rpccli_UseProtSeq_state {
	struct UseProtSeq orig;
	struct UseProtSeq tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_UseProtSeq_done(struct tevent_req *subreq);

struct tevent_req *rpccli_UseProtSeq_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_UseProtSeq_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_UseProtSeq_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_dcom_Unknown,
				    NDR_USEPROTSEQ,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_UseProtSeq_done, req);
	return req;
}

static void rpccli_UseProtSeq_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_UseProtSeq_state *state = tevent_req_data(
		req, struct rpccli_UseProtSeq_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_UseProtSeq_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx)
{
	struct rpccli_UseProtSeq_state *state = tevent_req_data(
		req, struct rpccli_UseProtSeq_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_UseProtSeq(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx)
{
	struct UseProtSeq r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_dcom_Unknown,
				NDR_USEPROTSEQ,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_GetCustomProtseqInfo_state {
	struct GetCustomProtseqInfo orig;
	struct GetCustomProtseqInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetCustomProtseqInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetCustomProtseqInfo_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_GetCustomProtseqInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetCustomProtseqInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_dcom_Unknown,
				    NDR_GETCUSTOMPROTSEQINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetCustomProtseqInfo_done, req);
	return req;
}

static void rpccli_GetCustomProtseqInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetCustomProtseqInfo_state *state = tevent_req_data(
		req, struct rpccli_GetCustomProtseqInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetCustomProtseqInfo_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct rpccli_GetCustomProtseqInfo_state *state = tevent_req_data(
		req, struct rpccli_GetCustomProtseqInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetCustomProtseqInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx)
{
	struct GetCustomProtseqInfo r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_dcom_Unknown,
				NDR_GETCUSTOMPROTSEQINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_UpdateResolverBindings_state {
	struct UpdateResolverBindings orig;
	struct UpdateResolverBindings tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_UpdateResolverBindings_done(struct tevent_req *subreq);

struct tevent_req *rpccli_UpdateResolverBindings_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_UpdateResolverBindings_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_UpdateResolverBindings_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_dcom_Unknown,
				    NDR_UPDATERESOLVERBINDINGS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_UpdateResolverBindings_done, req);
	return req;
}

static void rpccli_UpdateResolverBindings_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_UpdateResolverBindings_state *state = tevent_req_data(
		req, struct rpccli_UpdateResolverBindings_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_UpdateResolverBindings_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx)
{
	struct rpccli_UpdateResolverBindings_state *state = tevent_req_data(
		req, struct rpccli_UpdateResolverBindings_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_UpdateResolverBindings(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct UpdateResolverBindings r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_dcom_Unknown,
				NDR_UPDATERESOLVERBINDINGS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_QueryInterface_state {
	struct QueryInterface orig;
	struct QueryInterface tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_QueryInterface_done(struct tevent_req *subreq);

struct tevent_req *rpccli_QueryInterface_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct GUID *_iid /* [in] [unique] */,
					      struct MInterfacePointer **_data /* [out] [ref,iid_is(riid)] */)
{
	struct tevent_req *req;
	struct rpccli_QueryInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_QueryInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.iid = _iid;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.data = _data;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_QueryInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IUnknown,
				    NDR_QUERYINTERFACE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_QueryInterface_done, req);
	return req;
}

static void rpccli_QueryInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_QueryInterface_state *state = tevent_req_data(
		req, struct rpccli_QueryInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.data = *state->tmp.out.data;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_QueryInterface_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_QueryInterface_state *state = tevent_req_data(
		req, struct rpccli_QueryInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_QueryInterface(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct GUID *iid /* [in] [unique] */,
			       struct MInterfacePointer **data /* [out] [ref,iid_is(riid)] */,
			       WERROR *werror)
{
	struct QueryInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.iid = iid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IUnknown,
				NDR_QUERYINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*data = *r.out.data;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_AddRef_state {
	struct AddRef orig;
	struct AddRef tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_AddRef_done(struct tevent_req *subreq);

struct tevent_req *rpccli_AddRef_send(TALLOC_CTX *mem_ctx,
				      struct tevent_context *ev,
				      struct rpc_pipe_client *cli,
				      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_AddRef_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_AddRef_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_AddRef_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IUnknown,
				    NDR_ADDREF,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_AddRef_done, req);
	return req;
}

static void rpccli_AddRef_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_AddRef_state *state = tevent_req_data(
		req, struct rpccli_AddRef_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_AddRef_recv(struct tevent_req *req,
			    TALLOC_CTX *mem_ctx,
			    uint32 *result)
{
	struct rpccli_AddRef_state *state = tevent_req_data(
		req, struct rpccli_AddRef_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_AddRef(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */)
{
	struct AddRef r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IUnknown,
				NDR_ADDREF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_Release_state {
	struct Release orig;
	struct Release tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Release_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Release_send(TALLOC_CTX *mem_ctx,
				       struct tevent_context *ev,
				       struct rpc_pipe_client *cli,
				       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				       struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_Release_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Release_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Release_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IUnknown,
				    NDR_RELEASE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Release_done, req);
	return req;
}

static void rpccli_Release_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Release_state *state = tevent_req_data(
		req, struct rpccli_Release_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Release_recv(struct tevent_req *req,
			     TALLOC_CTX *mem_ctx,
			     uint32 *result)
{
	struct rpccli_Release_state *state = tevent_req_data(
		req, struct rpccli_Release_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Release(struct rpc_pipe_client *cli,
			TALLOC_CTX *mem_ctx,
			struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			struct ORPCTHIS ORPCthis /* [in]  */)
{
	struct Release r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IUnknown,
				NDR_RELEASE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_CreateInstance_state {
	struct CreateInstance orig;
	struct CreateInstance tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_CreateInstance_done(struct tevent_req *subreq);

struct tevent_req *rpccli_CreateInstance_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct MInterfacePointer *_pUnknown /* [in] [unique] */,
					      struct GUID *_iid /* [in] [unique] */,
					      struct MInterfacePointer *_ppv /* [out] [unique,iid_is(riid)] */)
{
	struct tevent_req *req;
	struct rpccli_CreateInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_CreateInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pUnknown = _pUnknown;
	state->orig.in.iid = _iid;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppv = _ppv;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_CreateInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IClassFactory,
				    NDR_CREATEINSTANCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_CreateInstance_done, req);
	return req;
}

static void rpccli_CreateInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_CreateInstance_state *state = tevent_req_data(
		req, struct rpccli_CreateInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppv && state->tmp.out.ppv) {
		*state->orig.out.ppv = *state->tmp.out.ppv;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_CreateInstance_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_CreateInstance_state *state = tevent_req_data(
		req, struct rpccli_CreateInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_CreateInstance(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct MInterfacePointer *pUnknown /* [in] [unique] */,
			       struct GUID *iid /* [in] [unique] */,
			       struct MInterfacePointer *ppv /* [out] [unique,iid_is(riid)] */,
			       WERROR *werror)
{
	struct CreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.pUnknown = pUnknown;
	r.in.iid = iid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_CREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppv && r.out.ppv) {
		*ppv = *r.out.ppv;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RemoteCreateInstance_state {
	struct RemoteCreateInstance orig;
	struct RemoteCreateInstance tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RemoteCreateInstance_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RemoteCreateInstance_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						    struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_RemoteCreateInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RemoteCreateInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RemoteCreateInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IClassFactory,
				    NDR_REMOTECREATEINSTANCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RemoteCreateInstance_done, req);
	return req;
}

static void rpccli_RemoteCreateInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RemoteCreateInstance_state *state = tevent_req_data(
		req, struct rpccli_RemoteCreateInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RemoteCreateInstance_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_RemoteCreateInstance_state *state = tevent_req_data(
		req, struct rpccli_RemoteCreateInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RemoteCreateInstance(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS ORPCthis /* [in]  */,
				     WERROR *werror)
{
	struct RemoteCreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_REMOTECREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_LockServer_state {
	struct LockServer orig;
	struct LockServer tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_LockServer_done(struct tevent_req *subreq);

struct tevent_req *rpccli_LockServer_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  uint8_t _lock /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_LockServer_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_LockServer_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lock = _lock;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_LockServer_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IClassFactory,
				    NDR_LOCKSERVER,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_LockServer_done, req);
	return req;
}

static void rpccli_LockServer_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_LockServer_state *state = tevent_req_data(
		req, struct rpccli_LockServer_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_LockServer_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_LockServer_state *state = tevent_req_data(
		req, struct rpccli_LockServer_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_LockServer(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   uint8_t lock /* [in]  */,
			   WERROR *werror)
{
	struct LockServer r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.lock = lock;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_LOCKSERVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RemoteLockServer_state {
	struct RemoteLockServer orig;
	struct RemoteLockServer tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RemoteLockServer_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RemoteLockServer_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_RemoteLockServer_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RemoteLockServer_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RemoteLockServer_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IClassFactory,
				    NDR_REMOTELOCKSERVER,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RemoteLockServer_done, req);
	return req;
}

static void rpccli_RemoteLockServer_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RemoteLockServer_state *state = tevent_req_data(
		req, struct rpccli_RemoteLockServer_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RemoteLockServer_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_RemoteLockServer_state *state = tevent_req_data(
		req, struct rpccli_RemoteLockServer_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RemoteLockServer(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 WERROR *werror)
{
	struct RemoteLockServer r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassFactory,
				NDR_REMOTELOCKSERVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RemQueryInterface_state {
	struct RemQueryInterface orig;
	struct RemQueryInterface tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RemQueryInterface_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RemQueryInterface_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 struct GUID *_ripid /* [in] [unique] */,
						 uint32_t _cRefs /* [in]  */,
						 uint16_t _cIids /* [in]  */,
						 struct GUID *_iids /* [in] [unique,size_is(cIids)] */,
						 struct MInterfacePointer *_ip /* [out] [unique,size_is(cIids)] */)
{
	struct tevent_req *req;
	struct rpccli_RemQueryInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RemQueryInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.ripid = _ripid;
	state->orig.in.cRefs = _cRefs;
	state->orig.in.cIids = _cIids;
	state->orig.in.iids = _iids;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ip = _ip;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RemQueryInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IRemUnknown,
				    NDR_REMQUERYINTERFACE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RemQueryInterface_done, req);
	return req;
}

static void rpccli_RemQueryInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RemQueryInterface_state *state = tevent_req_data(
		req, struct rpccli_RemQueryInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ip && state->tmp.out.ip) {
		memcpy(state->orig.out.ip, state->tmp.out.ip, (state->tmp.in.cIids) * sizeof(*state->orig.out.ip));
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RemQueryInterface_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_RemQueryInterface_state *state = tevent_req_data(
		req, struct rpccli_RemQueryInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RemQueryInterface(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  struct GUID *ripid /* [in] [unique] */,
				  uint32_t cRefs /* [in]  */,
				  uint16_t cIids /* [in]  */,
				  struct GUID *iids /* [in] [unique,size_is(cIids)] */,
				  struct MInterfacePointer *ip /* [out] [unique,size_is(cIids)] */,
				  WERROR *werror)
{
	struct RemQueryInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.ripid = ripid;
	r.in.cRefs = cRefs;
	r.in.cIids = cIids;
	r.in.iids = iids;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown,
				NDR_REMQUERYINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ip && r.out.ip) {
		memcpy(ip, r.out.ip, (r.in.cIids) * sizeof(*ip));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RemAddRef_state {
	struct RemAddRef orig;
	struct RemAddRef tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RemAddRef_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RemAddRef_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 uint16_t _cInterfaceRefs /* [in]  */,
					 struct REMINTERFACEREF *_InterfaceRefs /* [in] [size_is(cInterfaceRefs)] */,
					 WERROR *_pResults /* [out] [unique,size_is(cInterfaceRefs)] */)
{
	struct tevent_req *req;
	struct rpccli_RemAddRef_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RemAddRef_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.cInterfaceRefs = _cInterfaceRefs;
	state->orig.in.InterfaceRefs = _InterfaceRefs;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.pResults = _pResults;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RemAddRef_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IRemUnknown,
				    NDR_REMADDREF,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RemAddRef_done, req);
	return req;
}

static void rpccli_RemAddRef_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RemAddRef_state *state = tevent_req_data(
		req, struct rpccli_RemAddRef_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.pResults && state->tmp.out.pResults) {
		memcpy(state->orig.out.pResults, state->tmp.out.pResults, (state->tmp.in.cInterfaceRefs) * sizeof(*state->orig.out.pResults));
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RemAddRef_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct rpccli_RemAddRef_state *state = tevent_req_data(
		req, struct rpccli_RemAddRef_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RemAddRef(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  uint16_t cInterfaceRefs /* [in]  */,
			  struct REMINTERFACEREF *InterfaceRefs /* [in] [size_is(cInterfaceRefs)] */,
			  WERROR *pResults /* [out] [unique,size_is(cInterfaceRefs)] */,
			  WERROR *werror)
{
	struct RemAddRef r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.cInterfaceRefs = cInterfaceRefs;
	r.in.InterfaceRefs = InterfaceRefs;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown,
				NDR_REMADDREF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (pResults && r.out.pResults) {
		memcpy(pResults, r.out.pResults, (r.in.cInterfaceRefs) * sizeof(*pResults));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RemRelease_state {
	struct RemRelease orig;
	struct RemRelease tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RemRelease_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RemRelease_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  uint16_t _cInterfaceRefs /* [in]  */,
					  struct REMINTERFACEREF *_InterfaceRefs /* [in] [size_is(cInterfaceRefs)] */)
{
	struct tevent_req *req;
	struct rpccli_RemRelease_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RemRelease_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.cInterfaceRefs = _cInterfaceRefs;
	state->orig.in.InterfaceRefs = _InterfaceRefs;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RemRelease_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IRemUnknown,
				    NDR_REMRELEASE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RemRelease_done, req);
	return req;
}

static void rpccli_RemRelease_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RemRelease_state *state = tevent_req_data(
		req, struct rpccli_RemRelease_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RemRelease_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_RemRelease_state *state = tevent_req_data(
		req, struct rpccli_RemRelease_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RemRelease(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   uint16_t cInterfaceRefs /* [in]  */,
			   struct REMINTERFACEREF *InterfaceRefs /* [in] [size_is(cInterfaceRefs)] */,
			   WERROR *werror)
{
	struct RemRelease r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.cInterfaceRefs = cInterfaceRefs;
	r.in.InterfaceRefs = InterfaceRefs;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown,
				NDR_REMRELEASE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetClassObject_state {
	struct GetClassObject orig;
	struct GetClassObject tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetClassObject_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetClassObject_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct GUID _clsid /* [in]  */,
					      uint32_t _context /* [in]  */,
					      uint32_t _locale /* [in]  */,
					      struct GUID _iid /* [in]  */,
					      struct MInterfacePointer *_data /* [out] [ref,iid_is(iid)] */)
{
	struct tevent_req *req;
	struct rpccli_GetClassObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetClassObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.clsid = _clsid;
	state->orig.in.context = _context;
	state->orig.in.locale = _locale;
	state->orig.in.iid = _iid;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.data = _data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetClassObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IClassActivator,
				    NDR_GETCLASSOBJECT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetClassObject_done, req);
	return req;
}

static void rpccli_GetClassObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetClassObject_state *state = tevent_req_data(
		req, struct rpccli_GetClassObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.data = *state->tmp.out.data;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetClassObject_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx)
{
	struct rpccli_GetClassObject_state *state = tevent_req_data(
		req, struct rpccli_GetClassObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetClassObject(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct GUID clsid /* [in]  */,
			       uint32_t context /* [in]  */,
			       uint32_t locale /* [in]  */,
			       struct GUID iid /* [in]  */,
			       struct MInterfacePointer *data /* [out] [ref,iid_is(iid)] */)
{
	struct GetClassObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.clsid = clsid;
	r.in.context = context;
	r.in.locale = locale;
	r.in.iid = iid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IClassActivator,
				NDR_GETCLASSOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*data = *r.out.data;

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_ISCMLocalActivator_CreateInstance_state {
	struct ISCMLocalActivator_CreateInstance orig;
	struct ISCMLocalActivator_CreateInstance tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ISCMLocalActivator_CreateInstance_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ISCMLocalActivator_CreateInstance_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli,
								 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
								 struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_ISCMLocalActivator_CreateInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ISCMLocalActivator_CreateInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ISCMLocalActivator_CreateInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_ISCMLocalActivator,
				    NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ISCMLocalActivator_CreateInstance_done, req);
	return req;
}

static void rpccli_ISCMLocalActivator_CreateInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ISCMLocalActivator_CreateInstance_state *state = tevent_req_data(
		req, struct rpccli_ISCMLocalActivator_CreateInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ISCMLocalActivator_CreateInstance_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct rpccli_ISCMLocalActivator_CreateInstance_state *state = tevent_req_data(
		req, struct rpccli_ISCMLocalActivator_CreateInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ISCMLocalActivator_CreateInstance(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS ORPCthis /* [in]  */,
						  WERROR *werror)
{
	struct ISCMLocalActivator_CreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ISCMLocalActivator,
				NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_IMachineLocalActivator_foo_state {
	struct IMachineLocalActivator_foo orig;
	struct IMachineLocalActivator_foo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_IMachineLocalActivator_foo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_IMachineLocalActivator_foo_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_IMachineLocalActivator_foo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_IMachineLocalActivator_foo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IMachineLocalActivator,
				    NDR_IMACHINELOCALACTIVATOR_FOO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_IMachineLocalActivator_foo_done, req);
	return req;
}

static void rpccli_IMachineLocalActivator_foo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_IMachineLocalActivator_foo_state *state = tevent_req_data(
		req, struct rpccli_IMachineLocalActivator_foo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_IMachineLocalActivator_foo_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct rpccli_IMachineLocalActivator_foo_state *state = tevent_req_data(
		req, struct rpccli_IMachineLocalActivator_foo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_IMachineLocalActivator_foo(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror)
{
	struct IMachineLocalActivator_foo r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IMachineLocalActivator,
				NDR_IMACHINELOCALACTIVATOR_FOO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ILocalObjectExporter_Foo_state {
	struct ILocalObjectExporter_Foo orig;
	struct ILocalObjectExporter_Foo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ILocalObjectExporter_Foo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ILocalObjectExporter_Foo_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_ILocalObjectExporter_Foo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ILocalObjectExporter_Foo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_ILocalObjectExporter,
				    NDR_ILOCALOBJECTEXPORTER_FOO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ILocalObjectExporter_Foo_done, req);
	return req;
}

static void rpccli_ILocalObjectExporter_Foo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ILocalObjectExporter_Foo_state *state = tevent_req_data(
		req, struct rpccli_ILocalObjectExporter_Foo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ILocalObjectExporter_Foo_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct rpccli_ILocalObjectExporter_Foo_state *state = tevent_req_data(
		req, struct rpccli_ILocalObjectExporter_Foo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ILocalObjectExporter_Foo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct ILocalObjectExporter_Foo r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ILocalObjectExporter,
				NDR_ILOCALOBJECTEXPORTER_FOO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_ISystemActivatorRemoteCreateInstance_state {
	struct ISystemActivatorRemoteCreateInstance orig;
	struct ISystemActivatorRemoteCreateInstance tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_ISystemActivatorRemoteCreateInstance_done(struct tevent_req *subreq);

struct tevent_req *rpccli_ISystemActivatorRemoteCreateInstance_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct rpc_pipe_client *cli,
								    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
								    struct ORPCTHIS _ORPCthis /* [in]  */,
								    uint64_t _unknown1 /* [in]  */,
								    struct MInterfacePointer _iface1 /* [in]  */,
								    uint64_t _unknown2 /* [in]  */,
								    uint32_t *_unknown3 /* [out] [ref] */,
								    struct MInterfacePointer *_iface2 /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_ISystemActivatorRemoteCreateInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_ISystemActivatorRemoteCreateInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.unknown1 = _unknown1;
	state->orig.in.iface1 = _iface1;
	state->orig.in.unknown2 = _unknown2;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.unknown3 = _unknown3;
	state->orig.out.iface2 = _iface2;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_ISystemActivatorRemoteCreateInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_ISystemActivator,
				    NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_ISystemActivatorRemoteCreateInstance_done, req);
	return req;
}

static void rpccli_ISystemActivatorRemoteCreateInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_ISystemActivatorRemoteCreateInstance_state *state = tevent_req_data(
		req, struct rpccli_ISystemActivatorRemoteCreateInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.unknown3 = *state->tmp.out.unknown3;
	*state->orig.out.iface2 = *state->tmp.out.iface2;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_ISystemActivatorRemoteCreateInstance_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct rpccli_ISystemActivatorRemoteCreateInstance_state *state = tevent_req_data(
		req, struct rpccli_ISystemActivatorRemoteCreateInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_ISystemActivatorRemoteCreateInstance(struct rpc_pipe_client *cli,
						     TALLOC_CTX *mem_ctx,
						     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
						     struct ORPCTHIS ORPCthis /* [in]  */,
						     uint64_t unknown1 /* [in]  */,
						     struct MInterfacePointer iface1 /* [in]  */,
						     uint64_t unknown2 /* [in]  */,
						     uint32_t *unknown3 /* [out] [ref] */,
						     struct MInterfacePointer *iface2 /* [out] [ref] */,
						     WERROR *werror)
{
	struct ISystemActivatorRemoteCreateInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.unknown1 = unknown1;
	r.in.iface1 = iface1;
	r.in.unknown2 = unknown2;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ISystemActivator,
				NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*unknown3 = *r.out.unknown3;
	*iface2 = *r.out.iface2;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_RemQueryInterface2_state {
	struct RemQueryInterface2 orig;
	struct RemQueryInterface2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_RemQueryInterface2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_RemQueryInterface2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS _ORPCthis /* [in]  */,
						  struct GUID *_ripid /* [in] [unique] */,
						  uint16_t _cIids /* [in]  */,
						  struct GUID *_iids /* [in] [unique,size_is(cIids)] */,
						  WERROR *_phr /* [out] [unique,size_is(cIids)] */,
						  struct MInterfacePointer *_ppMIF /* [out] [unique,size_is(cIids)] */)
{
	struct tevent_req *req;
	struct rpccli_RemQueryInterface2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_RemQueryInterface2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.ripid = _ripid;
	state->orig.in.cIids = _cIids;
	state->orig.in.iids = _iids;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.phr = _phr;
	state->orig.out.ppMIF = _ppMIF;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_RemQueryInterface2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IRemUnknown2,
				    NDR_REMQUERYINTERFACE2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_RemQueryInterface2_done, req);
	return req;
}

static void rpccli_RemQueryInterface2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_RemQueryInterface2_state *state = tevent_req_data(
		req, struct rpccli_RemQueryInterface2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.phr && state->tmp.out.phr) {
		memcpy(state->orig.out.phr, state->tmp.out.phr, (state->tmp.in.cIids) * sizeof(*state->orig.out.phr));
	}
	if (state->orig.out.ppMIF && state->tmp.out.ppMIF) {
		memcpy(state->orig.out.ppMIF, state->tmp.out.ppMIF, (state->tmp.in.cIids) * sizeof(*state->orig.out.ppMIF));
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_RemQueryInterface2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_RemQueryInterface2_state *state = tevent_req_data(
		req, struct rpccli_RemQueryInterface2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_RemQueryInterface2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   struct GUID *ripid /* [in] [unique] */,
				   uint16_t cIids /* [in]  */,
				   struct GUID *iids /* [in] [unique,size_is(cIids)] */,
				   WERROR *phr /* [out] [unique,size_is(cIids)] */,
				   struct MInterfacePointer *ppMIF /* [out] [unique,size_is(cIids)] */,
				   WERROR *werror)
{
	struct RemQueryInterface2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.ripid = ripid;
	r.in.cIids = cIids;
	r.in.iids = iids;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IRemUnknown2,
				NDR_REMQUERYINTERFACE2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (phr && r.out.phr) {
		memcpy(phr, r.out.phr, (r.in.cIids) * sizeof(*phr));
	}
	if (ppMIF && r.out.ppMIF) {
		memcpy(ppMIF, r.out.ppMIF, (r.in.cIids) * sizeof(*ppMIF));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetTypeInfoCount_state {
	struct GetTypeInfoCount orig;
	struct GetTypeInfoCount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetTypeInfoCount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetTypeInfoCount_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						uint16_t *_pctinfo /* [out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_GetTypeInfoCount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetTypeInfoCount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.pctinfo = _pctinfo;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetTypeInfoCount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IDispatch,
				    NDR_GETTYPEINFOCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetTypeInfoCount_done, req);
	return req;
}

static void rpccli_GetTypeInfoCount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetTypeInfoCount_state *state = tevent_req_data(
		req, struct rpccli_GetTypeInfoCount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.pctinfo && state->tmp.out.pctinfo) {
		*state->orig.out.pctinfo = *state->tmp.out.pctinfo;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetTypeInfoCount_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_GetTypeInfoCount_state *state = tevent_req_data(
		req, struct rpccli_GetTypeInfoCount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetTypeInfoCount(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 uint16_t *pctinfo /* [out] [unique] */,
				 WERROR *werror)
{
	struct GetTypeInfoCount r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_GETTYPEINFOCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (pctinfo && r.out.pctinfo) {
		*pctinfo = *r.out.pctinfo;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetTypeInfo_state {
	struct GetTypeInfo orig;
	struct GetTypeInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetTypeInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetTypeInfo_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   uint16_t _iTInfo /* [in]  */,
					   uint32_t _lcid /* [in]  */,
					   struct REF_ITypeInfo *_ppTInfo /* [out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_GetTypeInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetTypeInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.iTInfo = _iTInfo;
	state->orig.in.lcid = _lcid;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppTInfo = _ppTInfo;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetTypeInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IDispatch,
				    NDR_GETTYPEINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetTypeInfo_done, req);
	return req;
}

static void rpccli_GetTypeInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetTypeInfo_state *state = tevent_req_data(
		req, struct rpccli_GetTypeInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppTInfo && state->tmp.out.ppTInfo) {
		*state->orig.out.ppTInfo = *state->tmp.out.ppTInfo;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetTypeInfo_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_GetTypeInfo_state *state = tevent_req_data(
		req, struct rpccli_GetTypeInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetTypeInfo(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    uint16_t iTInfo /* [in]  */,
			    uint32_t lcid /* [in]  */,
			    struct REF_ITypeInfo *ppTInfo /* [out] [unique] */,
			    WERROR *werror)
{
	struct GetTypeInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.iTInfo = iTInfo;
	r.in.lcid = lcid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_GETTYPEINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (ppTInfo && r.out.ppTInfo) {
		*ppTInfo = *r.out.ppTInfo;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_GetIDsOfNames_state {
	struct GetIDsOfNames orig;
	struct GetIDsOfNames tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_GetIDsOfNames_done(struct tevent_req *subreq);

struct tevent_req *rpccli_GetIDsOfNames_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct GUID *_riid /* [in] [unique] */,
					     uint16_t _cNames /* [in]  */,
					     uint32_t _lcid /* [in]  */,
					     uint32_t *_rgDispId /* [out] [unique,size_is(cNames)] */)
{
	struct tevent_req *req;
	struct rpccli_GetIDsOfNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_GetIDsOfNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.riid = _riid;
	state->orig.in.cNames = _cNames;
	state->orig.in.lcid = _lcid;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.rgDispId = _rgDispId;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_GetIDsOfNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IDispatch,
				    NDR_GETIDSOFNAMES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_GetIDsOfNames_done, req);
	return req;
}

static void rpccli_GetIDsOfNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_GetIDsOfNames_state *state = tevent_req_data(
		req, struct rpccli_GetIDsOfNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.rgDispId && state->tmp.out.rgDispId) {
		memcpy(state->orig.out.rgDispId, state->tmp.out.rgDispId, (state->tmp.in.cNames) * sizeof(*state->orig.out.rgDispId));
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_GetIDsOfNames_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct rpccli_GetIDsOfNames_state *state = tevent_req_data(
		req, struct rpccli_GetIDsOfNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_GetIDsOfNames(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct GUID *riid /* [in] [unique] */,
			      uint16_t cNames /* [in]  */,
			      uint32_t lcid /* [in]  */,
			      uint32_t *rgDispId /* [out] [unique,size_is(cNames)] */,
			      WERROR *werror)
{
	struct GetIDsOfNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.riid = riid;
	r.in.cNames = cNames;
	r.in.lcid = lcid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_GETIDSOFNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (rgDispId && r.out.rgDispId) {
		memcpy(rgDispId, r.out.rgDispId, (r.in.cNames) * sizeof(*rgDispId));
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Invoke_state {
	struct Invoke orig;
	struct Invoke tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Invoke_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Invoke_send(TALLOC_CTX *mem_ctx,
				      struct tevent_context *ev,
				      struct rpc_pipe_client *cli,
				      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS _ORPCthis /* [in]  */,
				      uint32_t _dispIdMember /* [in]  */,
				      struct GUID *_riid /* [in] [unique] */,
				      uint32_t _lcid /* [in]  */,
				      uint16_t _wFlags /* [in]  */,
				      struct DISPPARAMS *_pDispParams /* [in,out] [unique] */,
				      struct VARIANT *_pVarResult /* [out] [unique] */,
				      struct EXCEPINFO *_pExcepInfo /* [out] [unique] */,
				      uint16_t *_puArgErr /* [out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_Invoke_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Invoke_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.dispIdMember = _dispIdMember;
	state->orig.in.riid = _riid;
	state->orig.in.lcid = _lcid;
	state->orig.in.wFlags = _wFlags;
	state->orig.in.pDispParams = _pDispParams;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.pDispParams = _pDispParams;
	state->orig.out.pVarResult = _pVarResult;
	state->orig.out.pExcepInfo = _pExcepInfo;
	state->orig.out.puArgErr = _puArgErr;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Invoke_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IDispatch,
				    NDR_INVOKE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Invoke_done, req);
	return req;
}

static void rpccli_Invoke_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Invoke_state *state = tevent_req_data(
		req, struct rpccli_Invoke_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.pDispParams && state->tmp.out.pDispParams) {
		*state->orig.out.pDispParams = *state->tmp.out.pDispParams;
	}
	if (state->orig.out.pVarResult && state->tmp.out.pVarResult) {
		*state->orig.out.pVarResult = *state->tmp.out.pVarResult;
	}
	if (state->orig.out.pExcepInfo && state->tmp.out.pExcepInfo) {
		*state->orig.out.pExcepInfo = *state->tmp.out.pExcepInfo;
	}
	if (state->orig.out.puArgErr && state->tmp.out.puArgErr) {
		*state->orig.out.puArgErr = *state->tmp.out.puArgErr;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Invoke_recv(struct tevent_req *req,
			    TALLOC_CTX *mem_ctx,
			    WERROR *result)
{
	struct rpccli_Invoke_state *state = tevent_req_data(
		req, struct rpccli_Invoke_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Invoke(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */,
		       uint32_t dispIdMember /* [in]  */,
		       struct GUID *riid /* [in] [unique] */,
		       uint32_t lcid /* [in]  */,
		       uint16_t wFlags /* [in]  */,
		       struct DISPPARAMS *pDispParams /* [in,out] [unique] */,
		       struct VARIANT *pVarResult /* [out] [unique] */,
		       struct EXCEPINFO *pExcepInfo /* [out] [unique] */,
		       uint16_t *puArgErr /* [out] [unique] */,
		       WERROR *werror)
{
	struct Invoke r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.dispIdMember = dispIdMember;
	r.in.riid = riid;
	r.in.lcid = lcid;
	r.in.wFlags = wFlags;
	r.in.pDispParams = pDispParams;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IDispatch,
				NDR_INVOKE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	if (pDispParams && r.out.pDispParams) {
		*pDispParams = *r.out.pDispParams;
	}
	if (pVarResult && r.out.pVarResult) {
		*pVarResult = *r.out.pVarResult;
	}
	if (pExcepInfo && r.out.pExcepInfo) {
		*pExcepInfo = *r.out.pExcepInfo;
	}
	if (puArgErr && r.out.puArgErr) {
		*puArgErr = *r.out.puArgErr;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_MarshalInterface_state {
	struct MarshalInterface orig;
	struct MarshalInterface tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_MarshalInterface_done(struct tevent_req *subreq);

struct tevent_req *rpccli_MarshalInterface_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_MarshalInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_MarshalInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_MarshalInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IMarshal,
				    NDR_MARSHALINTERFACE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_MarshalInterface_done, req);
	return req;
}

static void rpccli_MarshalInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_MarshalInterface_state *state = tevent_req_data(
		req, struct rpccli_MarshalInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_MarshalInterface_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_MarshalInterface_state *state = tevent_req_data(
		req, struct rpccli_MarshalInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_MarshalInterface(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 WERROR *werror)
{
	struct MarshalInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IMarshal,
				NDR_MARSHALINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_UnMarshalInterface_state {
	struct UnMarshalInterface orig;
	struct UnMarshalInterface tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_UnMarshalInterface_done(struct tevent_req *subreq);

struct tevent_req *rpccli_UnMarshalInterface_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_UnMarshalInterface_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_UnMarshalInterface_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_UnMarshalInterface_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IMarshal,
				    NDR_UNMARSHALINTERFACE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_UnMarshalInterface_done, req);
	return req;
}

static void rpccli_UnMarshalInterface_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_UnMarshalInterface_state *state = tevent_req_data(
		req, struct rpccli_UnMarshalInterface_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_UnMarshalInterface_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct rpccli_UnMarshalInterface_state *state = tevent_req_data(
		req, struct rpccli_UnMarshalInterface_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_UnMarshalInterface(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   WERROR *werror)
{
	struct UnMarshalInterface r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IMarshal,
				NDR_UNMARSHALINTERFACE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_MakeCoffee_state {
	struct MakeCoffee orig;
	struct MakeCoffee tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_MakeCoffee_done(struct tevent_req *subreq);

struct tevent_req *rpccli_MakeCoffee_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  const char *_flavor /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_MakeCoffee_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_MakeCoffee_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.flavor = _flavor;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_MakeCoffee_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_ICoffeeMachine,
				    NDR_MAKECOFFEE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_MakeCoffee_done, req);
	return req;
}

static void rpccli_MakeCoffee_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_MakeCoffee_state *state = tevent_req_data(
		req, struct rpccli_MakeCoffee_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_MakeCoffee_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_MakeCoffee_state *state = tevent_req_data(
		req, struct rpccli_MakeCoffee_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_MakeCoffee(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   const char *flavor /* [in] [ref,charset(UTF16)] */,
			   WERROR *werror)
{
	struct MakeCoffee r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.flavor = flavor;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_ICoffeeMachine,
				NDR_MAKECOFFEE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Read_state {
	struct Read orig;
	struct Read tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Read_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Read_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct rpc_pipe_client *cli,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    uint8_t *_pv /* [out] [length_is(*num_read),size_is(num_requested)] */,
				    uint32_t _num_requested /* [in]  */,
				    uint32_t *_num_readx /* [in] [unique] */,
				    uint32_t *_num_read /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_Read_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Read_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.num_requested = _num_requested;
	state->orig.in.num_readx = _num_readx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.pv = _pv;
	state->orig.out.num_read = _num_read;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Read_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IStream,
				    NDR_READ,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Read_done, req);
	return req;
}

static void rpccli_Read_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Read_state *state = tevent_req_data(
		req, struct rpccli_Read_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	memcpy(state->orig.out.pv, state->tmp.out.pv, (state->tmp.in.num_requested) * sizeof(*state->orig.out.pv));
	*state->orig.out.num_read = *state->tmp.out.num_read;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Read_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct rpccli_Read_state *state = tevent_req_data(
		req, struct rpccli_Read_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Read(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     uint8_t *pv /* [out] [length_is(*num_read),size_is(num_requested)] */,
		     uint32_t num_requested /* [in]  */,
		     uint32_t *num_readx /* [in] [unique] */,
		     uint32_t *num_read /* [out] [ref] */,
		     WERROR *werror)
{
	struct Read r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.num_requested = num_requested;
	r.in.num_readx = num_readx;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IStream,
				NDR_READ,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	memcpy(pv, r.out.pv, (r.in.num_requested) * sizeof(*pv));
	*num_read = *r.out.num_read;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_Write_state {
	struct Write orig;
	struct Write tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_Write_done(struct tevent_req *subreq);

struct tevent_req *rpccli_Write_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct rpc_pipe_client *cli,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     uint8_t *_data /* [in] [unique,size_is(num_requested)] */,
				     uint32_t _num_requested /* [in]  */,
				     uint32_t *_num_written /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_Write_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_Write_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.data = _data;
	state->orig.in.num_requested = _num_requested;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.num_written = _num_written;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_Write_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_IStream,
				    NDR_WRITE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_Write_done, req);
	return req;
}

static void rpccli_Write_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_Write_state *state = tevent_req_data(
		req, struct rpccli_Write_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.num_written = *state->tmp.out.num_written;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_Write_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct rpccli_Write_state *state = tevent_req_data(
		req, struct rpccli_Write_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_Write(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      uint8_t *data /* [in] [unique,size_is(num_requested)] */,
		      uint32_t num_requested /* [in]  */,
		      uint32_t *num_written /* [out] [ref] */,
		      WERROR *werror)
{
	struct Write r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = ORPCthis;
	r.in.data = data;
	r.in.num_requested = num_requested;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_IStream,
				NDR_WRITE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ORPCthat = *r.out.ORPCthat;
	*num_written = *r.out.num_written;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

