/* map_conv.c
   Converts from Samba username=DOMAIN\user style domain user maps for NT 
   and pam_smb username maps

   (c) David Airlie 1998
   
   released under GNU GPL.

   */


#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
  FILE *fl, *fout;
  char buf[255];
  struct user {
    char uxuser[80];
    char ntuser[80];
    char ntdomain[80];
  } users;
  char *p1, *p2, *p3;
  if (argc<3)
    {
      fprintf(stderr,"map_conv <infile> <outfile>\n");
      exit(0);
    }
  
  fl=fopen(argv[1], "r");
  
  fout=fopen(argv[2], "w");

  if (fl==NULL || fout==NULL)

    {
     perror("open");
     exit(-1);
    }
  while (!feof(fl) && fgets(buf,255, fl))
    {
      
      /*  printf("Buf: %s\n", buf);  */
      
      p1=strchr(buf, '=');
      if (p1!=NULL) 
	{
	  memcpy(users.uxuser, buf, p1-buf);
	  users.uxuser[p1-buf]='\0';
	  
	  p2=strchr(buf, '\\');
	  
	  if (p2==NULL)
	    {
	      strcpy(users.ntuser, p1+1);
	      if (users.ntuser[strlen(users.ntuser)-1]==10)
		users.ntuser[strlen(users.ntuser)-1]='\0';
	      strcpy(users.ntdomain, "");
	    }
	  else
	    {
	      memcpy(users.ntdomain, p1+1, p2-p1-1);
	      users.ntdomain[p2-p1-1]='\0';
	      strcpy(users.ntuser, p2+1);
	      if (users.ntuser[strlen(users.ntuser)-1]==10)
		users.ntuser[strlen(users.ntuser)-1]='\0';
	      
	    }
	 /*  printf("%s : %s : %s\n", users.uxuser, users.ntuser, users.ntdomain);  */
	  if (strlen(users.ntdomain)==0)
	    {
	      
	      fprintf(fout,"nt2unix.%s\t%s\n", users.ntuser, users.uxuser);
	      fprintf(fout,"unix2nt.%s\t%s\n", users.uxuser, users.ntuser);
	    }
	  else
	    {
	      fprintf(fout,"nt2unix.%s\t%s,%s\n", users.ntuser, users.uxuser, users.ntdomain);
	      fprintf(fout,"unix2nt.%s\t%s,%s\n", users.uxuser, users.ntuser, users.ntdomain);
	    }
	}
    }
  fclose(fl);

 
}
