#ifndef _CACHE_H_
#define _CACHE_H_

#define MAX_SERVERS 8
#define MAX_DOMAINS 10

typedef enum { UNK, SMB, PDC } sertype;

typedef struct {
  char sername[40];
  sertype type;
} serv;

typedef struct {
  int numservers;
  serv servers[MAX_SERVERS];
  char domain[40];
} domain_ctls;

typedef struct {
	int numdomains;
	int last_check_time;
	domain_ctls controllers[MAX_DOMAINS];
} domain_list;


typedef struct 
{
  char nt_user[22];
  char ux_user[22]; /* This is the UNIX equivalent */
  char password[40]; /* This is the password for the NT domain */
  char mx_domain[20]; /* This is the NT domain or default */
  char nt_domain[20]; /* this is the NT domain (no default) */
  char pdc_nbname[20]; /* This is the Netbios name of the NT PDC*/
  char bdc_nbname[20]; /* This is the Netbios name of the NT BDC */
  char pdc_hostname[20]; /* This is the IP address of the NT PDC */
  char bdc_hostname[20]; /* This is the IP Address of the NT BDC */
  long usertimeout; /* This is the cache timeout value */
} usercache_data;

int Valid_MapUser(usercache_data *user);

#define CACHE_OK 0
#define CACHE_ENOENT 1
#define CACHE_ETIME 2

/* Check cache every CACHE_CHECK minutes -- default every 5 mins */
#ifndef CACHE_CHECK
#define CACHE_CHECK 300 
#endif

/* How long should the system cache the password for ?? -- default every 10 mins */
#ifndef CACHE_TIMEOUT
#define CACHE_TIMEOUT 600
#endif

/* Cache management function prototypes */
int serv_initcachedb(void);
int add_entry_to_cache(usercache_data *entry);
int check_entry_in_cache(usercache_data *entry);
void sigalrm_handler(int);

#endif
