#ifndef _RPC_CLIENT_PROTO_H_
#define _RPC_CLIENT_PROTO_H_
/* This file is automatically generated with "make proto". DO NOT EDIT */


/*The following definitions come from  lib/util_list.c  */

BOOL copy_policy_hnd (POLICY_HND *dest, const POLICY_HND *src);
BOOL compare_rpc_hnd_node(const RPC_HND_NODE *x, 
			  const RPC_HND_NODE *y);
BOOL RpcHndList_set_connection(const POLICY_HND *hnd, 
		  	       struct cli_connection *con);
BOOL RpcHndList_del_connection(const POLICY_HND *hnd);
struct cli_connection* RpcHndList_get_connection(const POLICY_HND *hnd);

/*The following definitions come from  rpc_client/cli_connect.c  */

void init_connections(void);
void free_connections(void);
void cli_connection_free(struct cli_connection *con);
void cli_connection_unlink(struct cli_connection *con);
BOOL cli_connection_init(const char *srv_name, char *pipe_name,
                         struct cli_connection **con);
BOOL cli_connection_init_auth(const char *srv_name, char *pipe_name,
                              struct cli_connection **con,
                              cli_auth_fns * auth, void *auth_creds);
struct _cli_auth_fns *cli_conn_get_authfns(struct cli_connection *con);
void *cli_conn_get_auth_creds(struct cli_connection *con);
BOOL rpc_hnd_pipe_req(const POLICY_HND * hnd, uint8 op_num,
                      prs_struct * data, prs_struct * rdata);
BOOL rpc_con_pipe_req(struct cli_connection *con, uint8 op_num,
                      prs_struct * data, prs_struct * rdata);
BOOL rpc_con_ok(struct cli_connection *con);

/*The following definitions come from  rpc_client/cli_login.c  */

BOOL cli_nt_setup_creds(struct cli_state *cli, unsigned char mach_pwd[16]);
BOOL cli_nt_srv_pwset(struct cli_state *cli, unsigned char *new_hashof_mach_pwd);
BOOL cli_nt_login_interactive(struct cli_state *cli, char *domain, char *username, 
                              uint32 smb_userid_low, char *password,
                              NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3);
BOOL cli_nt_login_network(struct cli_state *cli, char *domain, char *username, 
                          uint32 smb_userid_low, char lm_chal[8], 
			  char *lm_chal_resp, char *nt_chal_resp,
                          NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3);
BOOL cli_nt_logoff(struct cli_state *cli, NET_ID_INFO_CTR *ctr);

/*The following definitions come from  rpc_client/cli_lsarpc.c  */

BOOL do_lsa_open_policy(struct cli_state *cli,
			char *system_name, POLICY_HND *hnd,
			BOOL sec_qos);
BOOL do_lsa_query_info_pol(struct cli_state *cli,
			POLICY_HND *hnd, uint16 info_class,
			fstring domain_name, DOM_SID *domain_sid);
BOOL do_lsa_close(struct cli_state *cli, POLICY_HND *hnd);
BOOL cli_lsa_get_domain_sid(struct cli_state *cli, char *server);
uint32 lsa_open_policy(const char *system_name, POLICY_HND *hnd,
		       BOOL sec_qos, uint32 des_access);
uint32 lsa_close(POLICY_HND *hnd);
uint32 lsa_lookup_sids(POLICY_HND *hnd, int num_sids, DOM_SID *sids,
		       char ***names, uint32 **types, int *num_names);
uint32 lsa_lookup_names(POLICY_HND *hnd, int num_names, char **names,
			DOM_SID **sids, uint32 **types, int *num_sids);

/*The following definitions come from  rpc_client/cli_netlogon.c  */

BOOL cli_net_logon_ctrl2(struct cli_state *cli, uint32 status_level);
BOOL cli_net_auth2(struct cli_state *cli, uint16 sec_chan, 
                   uint32 neg_flags, DOM_CHAL *srv_chal);
BOOL cli_net_req_chal(struct cli_state *cli, DOM_CHAL *clnt_chal, DOM_CHAL *srv_chal);
BOOL cli_net_srv_pwset(struct cli_state *cli, uint8 hashed_mach_pwd[16]);
BOOL cli_net_sam_logon(struct cli_state *cli, NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3);
BOOL cli_net_sam_logoff(struct cli_state *cli, NET_ID_INFO_CTR *ctr);
BOOL change_trust_account_password( char *domain, char *remote_machine_list);

/*The following definitions come from  rpc_client/cli_pipe.c  */

BOOL rpc_api_pipe_req(struct cli_state *cli, uint8 op_num,
                      prs_struct *data, prs_struct *rdata);
BOOL rpc_pipe_bind(struct cli_state *cli, char *pipe_name, char *my_name);
void cli_nt_set_ntlmssp_flgs(struct cli_state *cli, uint32 ntlmssp_flgs);
BOOL cli_nt_session_open(struct cli_state *cli, char *pipe_name);
void cli_nt_session_close(struct cli_state *cli);

/*The following definitions come from  rpc_client/cli_reg.c  */

BOOL do_reg_connect(struct cli_state *cli, char *full_keyname, char *key_name,
				POLICY_HND *reg_hnd);
BOOL do_reg_open_hklm(struct cli_state *cli, uint16 unknown_0, uint32 level,
				POLICY_HND *hnd);
BOOL do_reg_open_hku(struct cli_state *cli, uint16 unknown_0, uint32 level,
				POLICY_HND *hnd);
BOOL do_reg_flush_key(struct cli_state *cli, POLICY_HND *hnd);
BOOL do_reg_query_key(struct cli_state *cli, POLICY_HND *hnd,
				char *class, uint32 *class_len,
				uint32 *num_subkeys, uint32 *max_subkeylen,
				uint32 *max_subkeysize, uint32 *num_values,
				uint32 *max_valnamelen, uint32 *max_valbufsize,
				uint32 *sec_desc, NTTIME *mod_time);
BOOL do_reg_unknown_1a(struct cli_state *cli, POLICY_HND *hnd, uint32 *unk);
BOOL do_reg_query_info(struct cli_state *cli, POLICY_HND *hnd,
				char *key_value, uint32* key_type);
BOOL do_reg_set_key_sec(struct cli_state *cli, POLICY_HND *hnd, SEC_DESC_BUF *sec_desc_buf);
BOOL do_reg_get_key_sec(struct cli_state *cli, POLICY_HND *hnd, uint32 *sec_buf_size, SEC_DESC_BUF **ppsec_desc_buf);
BOOL do_reg_delete_val(struct cli_state *cli, POLICY_HND *hnd, char *val_name);
BOOL do_reg_delete_key(struct cli_state *cli, POLICY_HND *hnd, char *key_name);
BOOL do_reg_create_key(struct cli_state *cli, POLICY_HND *hnd,
				char *key_name, char *key_class,
				SEC_ACCESS *sam_access,
				POLICY_HND *key);
BOOL do_reg_enum_key(struct cli_state *cli, POLICY_HND *hnd,
				int key_index, char *key_name,
				uint32 *unk_1, uint32 *unk_2,
				time_t *mod_time);
BOOL do_reg_create_val(struct cli_state *cli, POLICY_HND *hnd,
				char *val_name, uint32 type, BUFFER3 *data);
BOOL do_reg_enum_val(struct cli_state *cli, POLICY_HND *hnd,
				int val_index, int max_valnamelen, int max_valbufsize,
				fstring val_name,
				uint32 *val_type, BUFFER2 *value);
BOOL do_reg_open_entry(struct cli_state *cli, POLICY_HND *hnd,
				char *key_name, uint32 unk_0,
				POLICY_HND *key_hnd);
BOOL do_reg_close(struct cli_state *cli, POLICY_HND *hnd);

/*The following definitions come from  rpc_client/cli_samr.c  */

BOOL get_samr_query_usergroups(struct cli_state *cli, 
				POLICY_HND *pol_open_domain, uint32 user_rid,
				uint32 *num_groups, DOM_GID *gid);
BOOL get_samr_query_userinfo(struct cli_state *cli, 
				POLICY_HND *pol_open_domain,
				uint32 info_level,
				uint32 user_rid, SAM_USER_INFO_21 *usr);
BOOL do_samr_chgpasswd_user(struct cli_state *cli,
		char *srv_name, char *user_name,
		char nt_newpass[516], uchar nt_oldhash[16],
		char lm_newpass[516], uchar lm_oldhash[16]);
BOOL do_samr_unknown_38(struct cli_state *cli, char *srv_name);
BOOL do_samr_query_dom_info(struct cli_state *cli, 
				POLICY_HND *domain_pol, uint16 switch_value);
BOOL do_samr_enum_dom_users(struct cli_state *cli, 
				POLICY_HND *pol, uint16 num_entries, uint16 unk_0,
				uint16 acb_mask, uint16 unk_1, uint32 size,
				struct acct_info **sam,
				int *num_sam_users);
BOOL do_samr_connect(struct cli_state *cli, 
				char *srv_name, uint32 unknown_0,
				POLICY_HND *connect_pol);
BOOL do_samr_open_user(struct cli_state *cli, 
				POLICY_HND *pol, uint32 unk_0, uint32 rid, 
				POLICY_HND *user_pol);
BOOL do_samr_open_domain(struct cli_state *cli, 
				POLICY_HND *connect_pol, uint32 rid, DOM_SID *sid,
				POLICY_HND *domain_pol);
BOOL do_samr_query_unknown_12(struct cli_state *cli, 
				POLICY_HND *pol, uint32 rid, uint32 num_gids, uint32 *gids,
				uint32 *num_aliases,
				fstring als_names    [MAX_LOOKUP_SIDS],
				uint32  num_als_users[MAX_LOOKUP_SIDS]);
BOOL do_samr_query_usergroups(struct cli_state *cli, 
				POLICY_HND *pol, uint32 *num_groups, DOM_GID *gid);
BOOL do_samr_query_userinfo(struct cli_state *cli, 
				POLICY_HND *pol, uint16 switch_value, void* usr);
BOOL do_samr_close(struct cli_state *cli, POLICY_HND *hnd);

/*The following definitions come from  rpc_client/cli_spoolss_notify.c  */

BOOL spoolss_disconnect_from_client( struct cli_state *cli);
BOOL spoolss_connect_to_client( struct cli_state *cli, char *remote_machine);
BOOL cli_spoolss_reply_open_printer(struct cli_state *cli, char *printer, uint32 localprinter, uint32 type, uint32 *status, POLICY_HND *handle);
BOOL cli_spoolss_reply_rrpcn(struct cli_state *cli, POLICY_HND *handle, 
			     uint32 change_low, uint32 change_high, uint32 *status);
BOOL cli_spoolss_reply_close_printer(struct cli_state *cli, POLICY_HND *handle, uint32 *status);

/*The following definitions come from  rpc_client/cli_srvsvc.c  */

BOOL do_srv_net_srv_conn_enum(struct cli_state *cli,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_CONN_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_sess_enum(struct cli_state *cli,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_SESS_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_share_enum(struct cli_state *cli,
			char *server_name, 
			uint32 switch_value, SRV_R_NET_SHARE_ENUM *r_o,
			uint32 preferred_len, ENUM_HND *hnd);
BOOL do_srv_net_srv_file_enum(struct cli_state *cli,
			char *server_name, char *qual_name,
			uint32 switch_value, SRV_FILE_INFO_CTR *ctr,
			uint32 preferred_len,
			ENUM_HND *hnd);
BOOL do_srv_net_srv_get_info(struct cli_state *cli,
			char *server_name, uint32 switch_value, SRV_INFO_CTR *ctr);

/*The following definitions come from  rpc_client/cli_use.c  */

void init_cli_use(void);
void free_cli_use(void);
struct cli_state *cli_net_use_add(const char *srv_name,
				  const struct ntuser_creds *usr_creds,
				  BOOL reuse, BOOL *is_new);
BOOL cli_net_use_del(const char *srv_name,
		     const struct ntuser_creds *usr_creds,
		     BOOL force_close, BOOL *connection_closed);
void cli_net_use_enum(uint32 *num_cons, struct use_info ***use);
void cli_use_wait_keyboard(void);

/*The following definitions come from  rpc_client/cli_wkssvc.c  */

BOOL do_wks_query_info(struct cli_state *cli, 
			char *server_name, uint32 switch_value,
			WKS_INFO_100 *wks100);

/*The following definitions come from  rpc_client/ncacn_np_use.c  */

BOOL ncacn_np_use_del(const char *srv_name, const char *pipe_name,
                      const vuser_key * key,
                      BOOL force_close, BOOL *connection_closed);
struct ncacn_np *ncacn_np_initialise(struct ncacn_np *msrpc,
                                     const vuser_key * key);
struct ncacn_np *ncacn_np_use_add(const char *pipe_name,
                                  const vuser_key * key,
                                  const char *srv_name,
                                  const struct ntuser_creds *ntc,
                                  BOOL reuse, BOOL *is_new_connection);
#endif /* _PROTO_H_ */
