/* local definitions for file server */
#ifndef _LOCAL_H
#define _LOCAL_H

/* This defines the section name in the configuration file that will contain */
/* global parameters - that is, parameters relating to the whole server, not */
/* just services. This name is then reserved, and may not be used as a       */
/* a service name. It will default to "global" if not defined here.          */
#define GLOBAL_NAME "global"
#define GLOBAL_NAME2 "globals"

/* This defines the section name in the configuration file that will
   refer to the special "homes" service */
#define HOMES_NAME "homes"

/* This defines the section name in the configuration file that will
   refer to the special "printers" service */
#define PRINTERS_NAME "printers"

/* This defines the name of the printcap file. It is MOST UNLIKELY that
   this will change BUT! Specifying a file with the format of a printcap
   file but containing only a subset of the printers actualy in your real 
   printcap file is a quick-n-dirty way to allow dynamic access to a subset
   of available printers.
*/
#define PRINTCAP_NAME "/etc/printcap"

/* set these to define the limits of the server. NOTE These are on a
   per-client basis. Thus any one machine can't connect to more than
   MAX_CONNECTIONS services, but any number of machines may connect at
   one time. */
#define MAX_CONNECTIONS 127
#define MAX_OPEN_FILES 100

/* the max number of connections that the smbstatus program will show */
#define MAXSTATUS 1000

/* max number of directories open at once */
#define MAXDIR 20

#define WORDMAX 0xFFFF


/* separators for lists */
#define LIST_SEP " \t,;:\n\r"

#ifndef LOCKDIR
#define LOCKDIR "/tmp/samba"
#endif

/* the print command on the server, %s is replaced with the filename  */
/* note that the -r removes the file after printing - you'll run out  */
/* of disk pretty quickly if you don't. This command is only used as  */
/* the default - it can be overridden in the configuration file.      */
#define PRINT_COMMAND "lpr -r %s"

/* the lpq command on the server. the printername is passed as an argument */
#ifndef LPQ_COMMAND
#define LPQ_COMMAND "lpq -P"
#endif

/* the threshold at which we will read the whole of the packet */
#define PARTIAL_THRESHOLD 200

/* define this if you want to stop spoofing with .. and soft links
   NOTE: This also slows down the server considerably */
#define REDUCE_PATHS

/* we have two time standards - local and GMT. This will try to sort them out.
 */

#define LOCAL_TO_GMT 1
#define GMT_TO_LOCAL (-1)

#endif
