#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <nss_dbdefs.h>
#include <stdio.h>
#include <string.h>
#include "nss_wins.h"
#include "wins_resolve.h"
#include "includes.h"

extern int DEBUGLEVEL;

#define _PATH_RESCONF "/etc/resolv.conf"
/* #define DEBUG(l,m) (l <= DEBUGLEVEL) && printf m */

nss_status_t _nss_wins_gethostbyname(wins_backend_ptr_t backend, void *data)
{
  nss_XbyY_args_t *what = (nss_XbyY_args_t *) data;
  unsigned long host_addr;
  char *name;

  DEBUG(3,("gethostbyname request for %s\n",what->key.name));
  name = (char *) what->key.name;
  backend->host.h_name = strdup(what->key.name);
  backend->host.h_aliases = (char **) malloc(sizeof (char *));
  backend->host.h_aliases[0] = NULL;
  backend->host.h_addrtype = AF_INET;
  backend->host.h_length = 4;
  backend->host.h_addr_list = (char **) malloc (sizeof (char *) * 2);
  if ((host_addr = inet_addr(name)) == -1) {
    host_addr = wins_gethostbyname(backend,name);
    if (!host_addr) return NSS_NOTFOUND;
  }
  backend->host.h_addr_list[0] = (char *) malloc(sizeof host_addr);
  memcpy(backend->host.h_addr_list[0],&host_addr,sizeof(host_addr));
  backend->host.h_addr_list[1] = NULL;
  *((struct hostent *) what->buf.result) = backend->host;
  what->returnval = &(backend->host);
  DEBUG(3,("gethostbyname returning\n"));
  return NSS_SUCCESS;
}

nss_status_t _nss_wins_gethostbyaddr(wins_backend_ptr_t backend, void *data)
{
  nss_XbyY_args_t *what = (nss_XbyY_args_t *) data;
  unsigned long host_addr;
  struct in_addr in;

  memcpy(&in,what->key.hostaddr.addr,what->key.hostaddr.len);
  DEBUG(3,("gethostbyaddr request for %s\n",inet_ntoa(in)));
  backend->host.h_name = NULL;
  backend->host.h_aliases = (char **) malloc(sizeof (char *));
  backend->host.h_aliases[0] = NULL;
  backend->host.h_addrtype = AF_INET;
  backend->host.h_length = 4;
  backend->host.h_addr_list = (char **) malloc (sizeof (char *) * 2);
  backend->host.h_addr_list[0] = (char *) malloc(sizeof host_addr);
  memcpy(backend->host.h_addr_list[0],&in,sizeof(in));
  backend->host.h_addr_list[1] = NULL;
  DEBUG(3,("calling wins_gethostbyaddr\n"));
  wins_gethostbyaddr(backend,what->key.hostaddr.addr);
  what->returnval = NULL;
  DEBUG(3,("gethostbyaddr returning\n"));
  if (!backend->host.h_name)
    return NSS_NOTFOUND;
  *((struct hostent *) what->buf.result) = backend->host;
  what->returnval = &(backend->host);
  return NSS_SUCCESS;
}

nss_status_t _nss_wins_hosts_destr(wins_backend_ptr_t backend, void *x)
{
  int h;
  DEBUG(3,("Destructor called\n"));
  free(backend->host.h_name);
  /*
  if (backend->wins_server.S_un.S_addr)
    free(backend->wins_server);
  */
  if (backend->host.h_aliases)
    for(h = 0; backend->host.h_aliases[h]; h++)
      free(backend->host.h_aliases[h]);
  if (backend->host.h_addr_list)
    for(h = 0; backend->host.h_addr_list[h]; h++)
      free(backend->host.h_addr_list[h]);
  free(backend);
  DEBUG(3,("Destructor returning\n"));
  return NSS_SUCCESS;
}

static wins_backend_op_t hosts_ops[] =
{
  _nss_wins_hosts_destr,
  NULL,
  NULL,
  NULL,
  _nss_wins_gethostbyname,
  _nss_wins_gethostbyaddr
};

nss_backend_t *_nss_wins_hosts_constr(const char *x1, const char *x2, const char *x3)
{
  FILE *f;
  char l[80];
  char *c,*c2;

  wins_backend_ptr_t backend;
  DEBUG(3,("Constructor called\n"));
  backend = (wins_backend_ptr_t) malloc(sizeof (*backend));
  backend->ops = hosts_ops;
  backend->n_ops = (sizeof (hosts_ops) / sizeof (hosts_ops[0]));
  backend->wins_server.S_un.S_addr = 0;
  DEBUG(3,("Checking for a wins_server line in %s\n",_PATH_RESCONF));
  f = fopen(_PATH_RESCONF,"r");
  if (f) {
    while(fgets(l,79,f)) {
      if (!strncasecmp(l,"wins_server",11) && isspace(l[11])) {
	for(c = l+11; isspace(*c); c++);
	for(c2 = c; *c2 && !isspace(*c2); c2++);
	*c2 = '\0';
	DEBUG(3,("WINS Server: %s\n",c));
	backend->wins_server.S_un.S_addr = inet_addr(c);
	break;
      }
    }
    fclose(f);
  }
  DEBUG(3,("Constructor returning\n"));
  return ((nss_backend_t *) backend);
}
