/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>



/*DEFINE */
#define DATA_FILE "/tmp/linpopup.dat"
#define DATA_PERM S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH	//0666
#define RC_PERM S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH	//0644



/* == global ( widget ) == */
GtkWidget *window;
GtkWidget *main_statusbar[4];
guint main_context_id[4];
guint main_message_id[4];
guint32 check_for_new_message_timeout;
char wrote[20];

/* == global (DEBUG) == */
FILE *debug_log;

/* == global ( others) == */
char processing_new_message;
int total_number_of_messages;
int new_messages;
int first_new_message;
int current_showed_message;
char is_it_a_reply;
struct linpopup_message
  {
    char sender[100];
    char host[100];
    char text[1700];
    char is_new;
  };



/* == main.c == */
void iconify_window (GtkWidget * widget, GtkWidget * this_window);
void deiconify_window (GtkWidget * this_window);

/* == menu.c == */
void create_menu (GtkWidget * vbox);

/* == toolbar.c == */
GtkWidget *create_toolbar (GtkWidget * window, GtkWidget * vbox);
GtkWidget *new_pixmap (GtkWidget * widget, char **data);

/* == text.c == */
GtkWidget *create_text (GtkWidget * vbox);
void clear_text (GtkWidget * text);
void realize_text (GtkWidget * text, gpointer data);
void main_copy_to_clipboard (GtkWidget * widget, gpointer data);
void main_select_all (GtkWidget * widget, gpointer data);

/* == dialog.c == */
int alert_dialog (gchar * title, gchar * string, gchar * first_button, gchar * second_button, int selected);
void alert_ok (gchar * title, gchar * alert_message, gchar * alert_button_label);
void alert_ok_text (gchar * message);
void about_dialog (void);
void doc_dialog (GtkWidget * widget, int index);

/* == send.c == */
void send_message (void);
void reply_message (void);

/* == recept.c == */
void trap_message (int argc, char *argv[]);
int are_there_new_messages_in_data_file (void);
gint check_for_new_message (gpointer data);
int count_total_number_of_messages (void);
void show_no_message (void);
void show_message (int message_number);
void show_next_message (gpointer * data);
void show_previous_message (gpointer * data);
void delete_showed_message (void);
void delete_all_messages (void);
void read_message (int message_number, struct linpopup_message *this_message);

/* == io.c == */
void fatal_error (int code, char *data);
void vital_check_for_read_access (char *filename);

/*== custom.c ==*/
struct linpopup_custom
  {
    char version[6];
    GtkToolbarStyle toolbar_style;
    guint32 message_check_interval;
    char hcolors;
    char quote;
  }
user_rc;

void rc_init (void);
void custom_notebook (void);

/* == version.c == */
char *many_version_infos (char *buf);
char *a_little_version_infos (char *buf);
char *what_is_this_stupid_programm_that_have_crashed (char *buf);
char *version (char *buf);
