H27594
s 00003/00003/00203
d D 1.7 03/09/08 19:01:20 stevef 8 7
c Fix spinlock usage for SMP safety
cC
cHstevef95.austin.ibm.com
cK41319
cZ-07:00
e
s 00006/00001/00200
d D 1.6 03/08/15 06:18:47 stevef 7 6
c oplock break not signed
cC
cHsteveft21.austin.ibm.com
cK41577
cZ-05:00
e
s 00032/00022/00169
d D 1.5 03/07/09 23:14:07 stevef 6 5
c More NTLMv2
cC
cHlinux.local
cK31137
e
s 00053/00002/00138
d D 1.4 03/07/07 17:27:52 stevef 5 4
c NTLMv2 password support and NTLMSSP signing part 1
cC
cHstevef95.austin.ibm.com
cK43048
e
s 00049/00008/00091
d D 1.3 03/07/06 18:24:42 stevef 4 3
c Signing fixes part 4 of 4
cC
cK03302
e
s 00023/00007/00076
d D 1.2 03/07/05 11:19:53 stevef 3 2
c Signing fixes part 3
cC
cK29358
e
s 00083/00000/00000
d D 1.1 03/07/04 15:07:26 stevef 2 1
cC
cF1
cK38128
cO-rwxrwxr-x
e
s 00000/00000/00000
d D 1.0 03/07/04 15:07:26 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5cifs/fs/cifs/cifsencrypt.c
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHlinux.local
cK39403
cPfs/cifs/cifsencrypt.c
cRc5cf24d2f529e04
cV4
cX0x821
cZ-07:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *   fs/cifs/cifsencrypt.c
 *
D 8
 *   Copyright (c) International Business Machines  Corp., 2003
E 8
I 8
 *   Copyright (C) International Business Machines  Corp., 2003
E 8
 *   Author(s): Steve French (sfrench@us.ibm.com)
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <linux/fs.h>
#include "cifspdu.h"
#include "cifsglob.h" 
#include "cifs_debug.h"
I 3
#include "md5.h"
I 5
#include "cifs_unicode.h"
E 5
E 3

/* Calculate and return the CIFS signature based on the mac key and the smb pdu */
D 3
/* the eight byte signature must be allocated by the caller. */
E 3
I 3
/* the 16 byte signature must be allocated by the caller  */
/* Note we only use the 1st eight bytes */
E 3
/* Note that the smb header signature field on input contains the  
	sequence number before this function is called */
I 4

extern void mdfour(unsigned char *out, unsigned char *in, int n);
extern void E_md4hash(const unsigned char *passwd, unsigned char *p16);
E 4
	
D 3
static int cifs_calculate_signature(const struct smb_hdr * cifs_pdu, const char * mac_key, char * signature)
E 3
I 3
static int cifs_calculate_signature(const struct smb_hdr * cifs_pdu, const char * key, char * signature)
E 3
{
I 3
	struct	MD5Context context;
E 3

	if((cifs_pdu == NULL) || (signature == NULL))
		return -EINVAL;

D 3
	/* MD5(mac_key, text) */
	/* return 1st eight bytes in signature */

E 3
I 3
	MD5Init(&context);
D 4
	MD5Update(&context,key,CIFS_SESSION_KEY_SIZE);
E 4
I 4
	MD5Update(&context,key,CIFS_SESSION_KEY_SIZE+16);
E 4
	MD5Update(&context,cifs_pdu->Protocol,cifs_pdu->smb_buf_length);
	MD5Final(signature,&context);
D 4
	cifs_dump_mem("signature: ",signature,16); /* BB remove BB */
E 4
E 3
	return 0;
}

D 3
int cifs_sign_smb(struct smb_hdr * cifs_pdu, struct cifsSesInfo * ses)
E 3
I 3
int cifs_sign_smb(struct smb_hdr * cifs_pdu, struct cifsSesInfo * ses,
	__u32 * pexpected_response_sequence_number)
E 3
{
	int rc = 0;
D 3
	char smb_signature[8];
E 3
I 3
	char smb_signature[20];
E 3

	/* BB remember to initialize sequence number elsewhere and initialize mac_signing key elsewhere BB */
	/* BB remember to add code to save expected sequence number in midQ entry BB */

	if((cifs_pdu == NULL) || (ses == NULL))
		return -EINVAL;

	if((le32_to_cpu(cifs_pdu->Flags2) & SMBFLG2_SECURITY_SIGNATURE) == 0) 
		return rc;

I 3
D 8
	write_lock(&GlobalMid_Lock);
E 8
I 8
	spin_lock(&GlobalMid_Lock);
E 8
E 3
D 4
	cifs_pdu->Signature.Sequence.SequenceNumber = ses->sequence_number;
E 4
I 4
	cifs_pdu->Signature.Sequence.SequenceNumber = cpu_to_le32(ses->sequence_number);
E 4
	cifs_pdu->Signature.Sequence.Reserved = 0;
I 3
	
	*pexpected_response_sequence_number = ses->sequence_number++;
	ses->sequence_number++;
D 8
	write_unlock(&GlobalMid_Lock);
E 8
I 8
	spin_unlock(&GlobalMid_Lock);
E 8

E 3
	rc = cifs_calculate_signature(cifs_pdu, ses->mac_signing_key,smb_signature);
	if(rc)
                memset(cifs_pdu->Signature.SecuritySignature, 0, 8);
	else
		memcpy(cifs_pdu->Signature.SecuritySignature, smb_signature, 8);

	return rc;
}

D 4
int cifs_verify_signature(const struct smb_hdr * cifs_pdu, const char * mac_key,
E 4
I 4
int cifs_verify_signature(struct smb_hdr * cifs_pdu, const char * mac_key,
E 4
	__u32 expected_sequence_number)
{
D 4
	unsigned int rc = 0;
E 4
I 4
	unsigned int rc;
	char server_response_sig[8];
	char what_we_think_sig_should_be[20];
E 4

        if((cifs_pdu == NULL) || (mac_key == NULL))
                return -EINVAL;
D 4
	
	/* BB no need to verify negprot or if flag is not on for session (or for frame?? */
E 4
I 4

	if (cifs_pdu->Command == SMB_COM_NEGOTIATE)
		return 0;

I 7
	if (cifs_pdu->Command == SMB_COM_LOCKING_ANDX) {
		struct smb_com_lock_req * pSMB = (struct smb_com_lock_req *)cifs_pdu;
	        if(pSMB->LockType & LOCKING_ANDX_OPLOCK_RELEASE)
			return 0;
	}

E 7
E 4
	/* BB what if signatures are supposed to be on for session but server does not
		send one? BB */
D 7
	/* BB also do not verify oplock breaks for signature */
E 7
I 3
	
	/* Do not need to verify session setups with signature "BSRSPYL "  */
	if(memcmp(cifs_pdu->Signature.SecuritySignature,"BSRSPYL ",8)==0)
		cFYI(1,("dummy signature received for smb command 0x%x",cifs_pdu->Command));
E 3

D 4
	return rc;
E 4
I 4
	expected_sequence_number = cpu_to_le32(expected_sequence_number);

	/* save off the origiginal signature so we can modify the smb and check
		its signature against what the server sent */
	memcpy(server_response_sig,cifs_pdu->Signature.SecuritySignature,8);

        cifs_pdu->Signature.Sequence.SequenceNumber = expected_sequence_number;
        cifs_pdu->Signature.Sequence.Reserved = 0;

        rc = cifs_calculate_signature(cifs_pdu, mac_key,
		what_we_think_sig_should_be);

	if(rc)
		return rc;

	
/*	cifs_dump_mem("what we think it should be: ",what_we_think_sig_should_be,16); */

	if(memcmp(server_response_sig, what_we_think_sig_should_be, 8))
		return -EACCES;
	else
		return 0;

}

/* We fill in key by putting in 40 byte array which was allocated by caller */
int cifs_calculate_mac_key(char * key, const char * rn, const char * password)
{
	char temp_key[16];
	if ((key == NULL) || (rn == NULL) || (password == NULL))
		return -EINVAL;

D 5
	E_md4hash(password, temp_key);  /* BB may have to do another md4 of it */
E 5
I 5
	E_md4hash(password, temp_key);
E 5
	mdfour(key,temp_key,16);
	memcpy(key+16,rn, CIFS_SESSION_KEY_SIZE);
	return 0;
E 4
D 5
} 
E 5
I 5
}

int CalcNTLMv2_partial_mac_key(struct cifsSesInfo * ses, struct nls_table * nls_info)
{
D 6
	char temp_key[16];
E 6
I 6
	char temp_hash[16];
E 6
	struct HMACMD5Context ctx;
	char * ucase_buf;
	wchar_t * unicode_buf;
D 6
	unsigned int i,user_len,dom_len;
E 6
I 6
	unsigned int i,user_name_len,dom_name_len;
E 6

	if(ses)
		return -EINVAL;

D 6
	E_md4hash(ses->password_with_pad, temp_key);
E 6
I 6
	E_md4hash(ses->password_with_pad, temp_hash);
E 6

D 6
	hmac_md5_init_limK_to_64(temp_key, 16, &ctx);
	user_len = strlen(ses->userName);
	if(user_len > MAX_USERNAME_SIZE)
E 6
I 6
	hmac_md5_init_limK_to_64(temp_hash, 16, &ctx);
	user_name_len = strlen(ses->userName);
	if(user_name_len > MAX_USERNAME_SIZE)
E 6
		return -EINVAL;
D 6
	dom_len = strlen(ses->domainName);
	if(dom_len > MAX_USERNAME_SIZE)
E 6
I 6
	dom_name_len = strlen(ses->domainName);
	if(dom_name_len > MAX_USERNAME_SIZE)
E 6
		return -EINVAL;

	
	ucase_buf = kmalloc((MAX_USERNAME_SIZE+1), GFP_KERNEL);
D 6
        unicode_buf = kmalloc((MAX_USERNAME_SIZE+1)*2, GFP_KERNEL);
E 6
I 6
        unicode_buf = kmalloc((MAX_USERNAME_SIZE+1)*4, GFP_KERNEL);
E 6
	
D 6
	for(i=0;i<user_len;i++)
E 6
I 6
	for(i=0;i<user_name_len;i++)
E 6
		ucase_buf[i] = nls_info->charset2upper[(int)ses->userName[i]];
	ucase_buf[i] = 0;
D 6
        user_len = cifs_strtoUCS(unicode_buf, ucase_buf, MAX_USERNAME_SIZE*2, nls_info);
	/* BB inc user_len + 2 or 2 for trailing nulls? */
E 6
I 6
        user_name_len = cifs_strtoUCS(unicode_buf, ucase_buf, MAX_USERNAME_SIZE*2, nls_info);
	unicode_buf[user_name_len] = 0;
	user_name_len++;
E 6

D 6
	/* Add call to hmac md5 user BB */

        for(i=0;i<dom_len;i++)
E 6
I 6
        for(i=0;i<dom_name_len;i++)
E 6
                ucase_buf[i] = nls_info->charset2upper[(int)ses->domainName[i]];
        ucase_buf[i] = 0;
D 6
        dom_len = cifs_strtoUCS(unicode_buf, ucase_buf, MAX_USERNAME_SIZE*2, nls_info);

	/* BB inc dom_len + 1 or 2 for trailing nulls? */
E 6
I 6
        dom_name_len = cifs_strtoUCS(unicode_buf+user_name_len, ucase_buf, MAX_USERNAME_SIZE*2, nls_info);
E 6

D 6
	/* Add call to hmac md5 domain */

	/* BB add hmac md5 final BB */
E 6
I 6
	unicode_buf[user_name_len + dom_name_len] = 0;
	hmac_md5_update((const unsigned char *) unicode_buf,
		(user_name_len+dom_name_len)*2,&ctx);
E 6

I 6
	hmac_md5_final(ses->mac_signing_key,&ctx);
E 6
	kfree(ucase_buf);
	kfree(unicode_buf);
	return 0;
}
D 6
 
E 6
I 6
void CalcNTLMv2_response(const struct cifsSesInfo * ses,char * v2_session_response)
{
	struct HMACMD5Context context;
	memcpy(v2_session_response + 8, ses->server->cryptKey,8);
	/* gen_blob(v2_session_response + 16); */
	hmac_md5_init_limK_to_64(ses->mac_signing_key, 16, &context);

	hmac_md5_update(ses->server->cryptKey,8,&context);
/*	hmac_md5_update(v2_session_response+16)client thing,8,&context); */ /* BB fix */


	hmac_md5_final(v2_session_response,&context);
}
E 6
E 5
E 2
I 1
E 1
