#ifndef MD5_H
#define MD5_H
#ifndef HEADER_MD5_H
/* Try to avoid clashes with OpenSSL */
#define HEADER_MD5_H
#endif

struct MD5Context {
	__u32 buf[4];
	__u32 bits[2];
	unsigned char in[64];
};

/*
 * This is needed to make RSAREF happy on some MS-DOS compilers.
 */
typedef struct MD5Context MD5_CTX;

#endif				/* !MD5_H */

#ifndef _HMAC_MD5_H
typedef struct {
	struct MD5Context ctx;
	unsigned char k_ipad[65];
	unsigned char k_opad[65];
} HMACMD5Context;
#endif				/* _HMAC_MD5_H */

void MD5Init(struct MD5Context *context);
void MD5Update(struct MD5Context *context, unsigned char const *buf,
	       unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *context);

/* The following definitions come from lib/hmacmd5.c  */

void hmac_md5_init_rfc2104(unsigned char *key, int key_len,
			   HMACMD5Context * ctx);
void hmac_md5_init_limK_to_64(const unsigned char *key, int key_len,
			      HMACMD5Context * ctx);
void hmac_md5_update(const unsigned char *text, int text_len,
		     HMACMD5Context * ctx);
void hmac_md5_final(unsigned char *digest, HMACMD5Context * ctx);
void hmac_md5(unsigned char key[16], unsigned char *data, int data_len,
	      unsigned char *digest);
