/*
 *   fs/cifs/cifsglob.h
 *
 *   Copyright (c) International Business Machines  Corp., 2002
 *   Author(s): Steve French (sfrench@us.ibm.com)
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 * 
 */
#include <linux/in.h>
/*
 *****************************************************************
 * All typedefs and structs go here
 *****************************************************************/
/*
 * The sizes of various internal tables and strings
 */
#define MAX_UID_INFO 16
#define MAX_SES_INFO 2
#define MAX_TCON_INFO 4

#define MAX_TREE_SIZE 2 + MAX_SERVER_SIZE + 1 + MAX_SHARE_SIZE + 1
#define MAX_SERVER_SIZE 15
#define MAX_SHARE_SIZE  64	/* used to be 20 - this should still be enough */
#define MAX_USERNAME_SIZE 22	/* 22 is to allow for 10 char names + null
				   termination then *2 for unicode versions */
#define MAX_PASSWORD_SIZE 16

/*
 * MAX_REQ is the maximum number of requests that WE will send
 * on one NetBIOS handle concurently.
 */
#define MAX_REQ (10)


#define SERVER_NAME_LENGTH 15
#define SERVER_NAME_LEN_WITH_NULL     (SERVER_NAME_LENGTH + 1)

/* used to define string lengths for reversing unicode strings */
/*         (256+1)*2 = 514                                     */
/*           (max path length + 1 for null) * 2 for unicode    */
#define MAX_NAME 514


#include "cifspdu.h"

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

/*
 * This information is kept on every Server we know about.
 *
 * Some things to note:
 *
 */
#define SERVER_NAME_LEN_WITH_NULL	(SERVER_NAME_LENGTH + 1)

/*
 * CIFS vfs client Status information (based on what we know.)
 */
enum statusEnum {
	CifsNew = 0,
	CifsGood,
	CifsDying
};

enum failureFlagval {
	FailNone,		/* No failure    */
	FailDying,		/* Failure - hangup required */
	FailDead		/* Failure - no hangup required */
};


/*
 *****************************************************************
 * All typedefs and structs go here
 *****************************************************************
 */


struct DirChild {
	struct DirChild *next1;
	struct vnode *vp;
	int fid;
};


struct TCP_Server_Info {
	struct DirChild dirInfo;
	char server_Name[SERVER_NAME_LEN_WITH_NULL];	/* 15 chars + X'20'in 16th */
	char unicode_server_Name[SERVER_NAME_LEN_WITH_NULL * 2];	/* Unicode version of server_Name */
	struct socket *ssocket;
	struct sockaddr_in sockAddr;
	wait_queue_head_t response_q;
	struct list_head pending_mid_q;
	enum statusEnum fsStatus;	/* what WE think the status is           */
	void *Server_NlsInfo;	/* BB - placeholder for future NLS info  */
	unsigned short server_codepage;	/* codepage for the server    */
	unsigned long ip_address;	/* IP addr for the server if known     */
	unsigned long svType;	/* computer type                       */
	char versionMajor;
	char versionMinor;
	int svStatus:1;		/* server Status: 1 is good                            */
	/* nothing ever gets deleted from the server list once */
	/* its added since there could be sessions that have a */
	/* pointer to this data.   So, they just get marked bad */
	int svNewStatus:1;	/* NewStatus on refresh server list: 1 is good       */
	int svlocal:1;		/* local server or remote                            */
	int socketUseCount;	/* indicates if the server has any open              */
	/* sessions on it                                    */
	struct task_struct *tsk;
};

/*
 * The following is our shortcut to user information.  We surface the uid,
 * and name. We always get the password on the fly in case it
 * has changed. We also hang a list of sessions owned by this user off here. 
 */
struct smbUidInfo {
	struct smbUidInfo *next1;	/* BB replace with list and atomicize */
	struct smbSesInfo *ses;	/* list of sessions *//* BB replace with list and atomicize */
	struct srSesInfo *sesSR;	/* Save/Restore session list @D2 */
/*    MutexT sesLock;  *//* session lsit lock *//* BB fix consistent with other structs */
	unsigned int id;	/* uid */
	char user[MAX_USERNAME_SIZE + 1];	/* ascii name of user */
	/* BB eventually need ptr into PAM or WinBind info */
};

/*
 * Session structure.  One of these for each uid session with a particular host
 */
struct smbSesInfo {
	struct list_head smbSessionList;
	struct semaphore sesSem;
	struct smbUidInfo *uidInfo;	/* pointer to user info */
	struct TCP_Server_Info *server;	/* pointer to server info */
	atomic_t inUse;		/* # of CURRENT users of this ses */
	enum failureFlagval failureFlag;	/* If this session has failed */
	int dialectIndex;	/* the negotiated dialect index */
	char secMode;
	int maxReq;		/* Clients should submit no more */
	/* than maxReq distinct unanswered */
	/* SMBs to the server when using  */
	/* multiplexed reads or writes */
	int maxBuf;		/* maxBuf specifies the maximum */
	/* message size the server can */
	/* send or receive for non-raw SMBs */
	int maxRw;		/* maxRw specifies the maximum */
	/* message size the server can */
	/* send or receive for */
	/* SMB_COM_WRITE_RAW or */
	/* SMB_COM_READ_RAW. */
	char sessid[4];		/* unique token id for this session */
	/* (returned on Negotiate */
	int capabilities;
	__u16 timeZone;
	char *serverOS;		/* name of operating system underlying the server */
	char *serverNOS;	/* name of network operating system that the server is running */
	char *serverDomain;	/* security realm of server */
	int Suid;		/* needed for user level security */
	char serverName[SERVER_NAME_LEN_WITH_NULL * 2];	/* BB make bigger for tcp names - will ipv6 and sctp addresses fit here?? */
	char userName[MAX_USERNAME_SIZE + 1];	/* BB remove and replace with list of smbUidInfo structures */
};

/*
 * there is one of these for each connection to a resource on a particular
 * session 
 */
struct smbTconInfo {
	struct list_head smbConnectionList;
	struct semaphore tconSem;
	struct smbSesInfo *ses;	/* pointer to session associated with */
	char treeName[MAX_TREE_SIZE + 1];	/* The ascii or unicode name of this resource depending on the ses->capabilities *//* BB fill in this field */
	char *nativeFileSystem;
	__u16 tid;		/* The 2 byte transaction id */
	__u16 Flags;		/* optional support bits */
	atomic_t useCount;	/* how many mounts (explicit or implicit refer to this share */
	FILE_SYSTEM_DEVICE_INFO fsDevInfo;
	FILE_SYSTEM_ATTRIBUTE_INFO fsAttrInfo;	/* note file system name may be truncated - but very unlikely */
	FILE_SYSTEM_UNIX_INFO fsUnixInfo;
	/* BB add field for back pointer to sb struct? */
};

/*
 * This info hangs off the smbFileInfo structure.  This is used to track
 * byte stream locks on the file
 */
struct smbLockInfo {
	struct smbLockInfo *next;
	int start;
	int length;
};

/*
 * One of these for each open instance of a file
 */
struct smbFileInfo {
	struct smbTconInfo *tcon;	/* pointer to owning TCON */
	struct smbFileInfo *tlist;	/* pointer to next fid owned by tcon *//* BB replace with list, atomicize */
	struct smbFileInfo *nfip;	/* next fip associated with file *//* BB replace with list and atomicize */
	struct smbLockInfo *lockList;	/* BB replace with list and atomicize */
	int mode;		/* Mode with which file was opened */
	unsigned int uid;	/* allows you to find which FileInfo structure */
	/* to use for i/o  filled in by msgOpen */
	unsigned int pid;	/* process id who opened file */
	__u16 netfid;		/* file id from remote */
	/* BB add lock scope info here if needed */ ;
	/* lock scope id (0 if none) */
	atomic_t inUse;		/* concurrent users of this open instance */
	int endOfSearch:1;	/* we have reached end of search */
	int closePend:1;	/* file is marked to close */
};

struct mid_q_entry {
	struct list_head qhead;	/* mids waiting on reply from this server */
	__u16 mid;		/* multiplex id */
	__u16 pid;		/* process id */
	__u16 command;		/* smb command code */
	struct timeval when_sent;	/* time when smb sent */
	struct smbSesInfo *ses;	/* smb was sent to this server */
	struct task_struct *tsk;	/* task waiting for response */
	struct smb_hdr *resp_buf;	/* response buffer */
};


struct servers_not_supported {	/* @z4a */
	struct servers_not_supported *next1;	/* @z4a */
	char server_Name[SERVER_NAME_LEN_WITH_NULL];	/* @z4a */
	/* Server Names in SMB protocol are 15 chars + X'20'  */
	/*   in 16th byte...                      @z4a        */
};


/*
 *****************************************************************
 * All constants go here
 *****************************************************************
 */

#define UID_HASH (16)

/*
 * Note that ONE module should define _DECLARE_GLOBALS_HERE to cause the
 * following to be declared.
 */

/* BB Every global should have an associated mutex for safe update BB */

#ifdef DECLARE_GLOBALS_HERE
#define GLOBAL_EXTERN
#else
#define GLOBAL_EXTERN extern
#endif

/*
 * The list of servers that did not respond with NT LM 0.12.
 * This list helps improve performance and eliminate the messages indicating
 * that we had a communications error talking to the server in this list. 
 */
GLOBAL_EXTERN struct servers_not_supported *NotSuppList;	/*@z4a */

/*
 * The following is a hash table of all the users we know about.
 */
GLOBAL_EXTERN struct smbUidInfo *GlobalUidList[UID_HASH];


GLOBAL_EXTERN struct list_head GlobalServerList;	/* BB this one is not implemented yet */
GLOBAL_EXTERN struct list_head GlobalSMBSessionList;
GLOBAL_EXTERN struct list_head GlobalTreeConnectionList;
/*
 * Global list of free SMB structures
 */
GLOBAL_EXTERN void *GlobalFreeSMB;


/*
 * Global transaction id (XID) information
 */
GLOBAL_EXTERN unsigned int GlobalCurrentXid;	/* protected by GlobalMid_Sem */
GLOBAL_EXTERN unsigned int GlobalTotalActiveXid;	/* prot by GlobalMid_Sem */
GLOBAL_EXTERN unsigned int GlobalMaxActiveXid;	/* prot by GlobalMid_Sem */

GLOBAL_EXTERN char Local_System_Name[15];

/*
 *  Global counters, updated atomically
 */
GLOBAL_EXTERN atomic_t sesInfoAllocCount;
GLOBAL_EXTERN atomic_t tconInfoAllocCount;

/* Various Debug counters to remove someday (BB) */
GLOBAL_EXTERN atomic_t bufAllocCount;
GLOBAL_EXTERN atomic_t midCount;

/* Misc globals */
GLOBAL_EXTERN unsigned int multiuser_mount;	/* if enabled allows new sessions to be established on existing mount if we */
					    /* have the uid/password or Kerberos credential or equivalent for current user */
