
#include "yodlfixlabels.h"

void handleline (char *buf, int pass)
{
    char
        *tagstart,
	*tagend,
        *tagcopy;

    if (! (tagstart = strstr (buf, TAGSTART)) )     /* no tag */
    {
        handlenotag (buf, pass);
        return;
    }
                                                    /* found tag(s) here */
    while ( (tagstart = strstr (buf, TAGSTART)) )   /* process them all */
    {
        if (pass && tagstart > buf)                 /* dump leading info */
        {
            *tagstart = '\0';
            output (outf, "%s", buf);
            *tagstart = TAGSTART [0];
        }
        
	buf = tagstart;                             /* set buffer start */
        
        if (! (tagend = strstr (buf, TAGEND)) )     /* find matching endtag */
        {
            if (pass)
            {
                warning ("near line %d: no matching endtag", 
                         lineno);
                output (outf, "%s", buf);
            }
            return;
        }
        
        tagcopy = xstrdup (buf);                    /* make copy of tag */
        *(strlen (TAGEND) + 
	    strstr (tagcopy, TAGEND)) = '\0';       /* cut off trailer */
        buf = tagend + strlen (TAGEND);             /* reset buffer */

        handletag (tagcopy, pass);                  /* process sequence */
        free (tagcopy);
    }
    
    if (pass && *buf)                               /* dump trailing info */
        output (outf, "%s", buf);
}
