
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include "../lib/lib.h"

#ifndef EXTERN                              /* EXTERN variables will be */
#   define EXTERN extern                    /* either declared or defined */
#else
#   define DEFINE_DATA
#endif

typedef enum                                /* lexical analyzer tokens */
{
    tok_eof,
    tok_space,
    tok_symbol,
    tok_string,
    tok_anychar,
    tok_newline,
    tok_openpar,
    tok_closepar,
} TOKEN;

EXTERN TOKEN
    lextok;                                 /* current lexer token */
EXTERN char       
    *lexbuf,                                /* buffer for lexical analyzer */
    *lexer_pushed,                          /* pre-pushed input */
    *lexer_pushedp;                         /* ptr into lexer_pushed */
    
/* NOTE NOTE NOTE ***********************************************************
 * When adding to this list, or when modifying it:
 *  --> edit init.c that holds the macro names
 *  --> edit gramsymbol.c that activates the right gram_..() function
 *  --> edit Makefile and put the right .o file in the OBJ list, create
 *      the corresponding .c file
 *  --> edit below and put the prototype in
 * When modifying the order in this list:  also adapt init.c and
 * gramsymbol.c, then recompile with "make clean" and "make prog"
 ****************************************************************************/
typedef enum                                /* built-in macros */
{
    mac_starter = -1,                       /* dummy starter of list */

    mac_definesymbol,
    mac_includefile,
    mac_noexpand,
    mac_renamemacro,
    mac_undefinesymbol,
    mac_ifdef,
    mac_definemacro,
    mac_char,
    mac_comment,
    mac_typeout,                            
    mac_definechartable,
    mac_usechartable,
    mac_atexit,
    mac_dummy,
    mac_startdef,
    mac_enddef,
    mac_ifempty,
    mac_undefinemacro,
    mac_newcounter,
    mac_countervalue,
    mac_setcounter,
    mac_addtocounter,
    mac_usecounter,
    mac_error,
    mac_ifzero,
    mac_paragraph,
    mac_subst,
    mac_notrans, 
    mac_chdir,
    mac_ifstrequal,
    mac_ifstrsub,
    mac_warning,
    mac_nousermacro,
    mac_system,
    mac_pipethrough,
    mac_uppercase,
    mac_includeliteral,
    mac_pushchartable,
    mac_popchartable,

    mac_stopper,                            /* dummy terminator of list */
} BUILTIN_INDEX;

EXTERN char                                 
    **builtin;                              /* table of builtin macros */
EXTERN int
    nbuiltin;                               /* size of table */
    
typedef char *CHARTAB[256];                 /* one table: 256 char->string */

EXTERN CHARTAB
    *chartab,                               /* the char tables themselves */
    *curchartab;                            /* currently used char table */
EXTERN int
    nchartab;                               /* # of defined char tables */
EXTERN char
    **chartabname;                          /* names of char tables */

EXTERN CHARTAB
    **chartabstack;                         /* char table stack */
EXTERN int
    nchartabstack;                          /* size of char table stack */
    
EXTERN char
    **userdef,                              /* table of user-defined macros */
    **definition;                           /* and the redef */
EXTERN int
    *narg;                                  /* # of args in the macro */
EXTERN int
    nuserdef;                               /* size of table */
    
EXTERN char                                 /* storage of defined symbols */
    **define;
EXTERN int
    ndefine;

EXTERN FILE                                 
    *inf,                                   /* input file */
    *outf                                   /* where the output goes */
#       ifdef DEFINE_DATA
        = stdout
#   endif
    ;

EXTERN char                                 
    *outfname;                              /* name of final output file */
EXTERN int
    last_written_char;                      /* last written character */
    
EXTERN char
    *cur_input_file;                        /* name of input file */
EXTERN int
    cur_lineno;                             /* and linenumber in it */

                                            /* macros to access last two */
EXTERN int  
    verbose,                                /* verbosity level, 0-4 */
    maxpass                                 /* max nr of allowed passes */
#       ifdef DEFINE_DATA
        = DEFAULT_MAXPASS
#       endif
        ;
        
EXTERN char
    *stdinclude;                            /* directory for includes */
    
EXTERN char
    **atexit_strings;                       /* strings to parse at exit */
EXTERN int
    natexit_strings;
    
EXTERN char
    **subst,                                /* sources for SUBST commands */
    **subst_redef;                          /* redefinitions */
EXTERN int
    nsubst;                                 /* size of subst tables */
    
typedef struct Flags                        /* general working flags */
{
    int
        trace_output: 1,                    /* trace generated output? */
        warn: 1;                            /* generate warnings? */
} FLAGS;

EXTERN FLAGS
    flags;
    
EXTERN int
    in_def;                                     /* inside START/ENDDEF()? */
    
EXTERN char
    **countername;                              /* table of counter names */
EXTERN int
    ncountername;                               /* table size */
EXTERN int
    *counterval;                                /* counter values */
    
EXTERN char
    **nousermacro;                              /* table of no-user-macro's */
EXTERN int
    nnousermacro;

EXTERN int
    livedata;                                   /* live data policy */

extern int  check_live_data (char const *macro, char const *cmd);
extern void error_gram (char const *gramrule, char const *msg, ...);
extern void error_no_memory (void);
extern void error_output_write (void);
extern void file_close (FILE *f);
extern char *file_expandname (char const *barename);
extern int  file_isfile (char const *fname);
extern void gram_addtocounter (void);
extern void gram_atexit (void);
extern void gram_char (void);
extern void gram_chdir (void);
extern void gram_comment (void);
extern void gram_countervalue (void);
extern void gram_dummy (void);
extern void gram_definechartable (void);
extern void gram_definesymbol (void);
extern void gram_definemacro (void);
extern void gram_enddef (void);
extern void gram_error (void);
extern int  gram_expand (void);
extern int  gram_findcounter (char const *rule, char const *name);
extern int  gram_getchar (void);
extern int  gram_hasident (char const *buf);
extern void gram_ifdef (void);
extern void gram_ifempty (void);
extern void gram_ifstrequal (void);
extern void gram_ifstrsub (void);
extern void gram_ifzero (void);
extern void gram_includefile (void);
extern void gram_includelit (void);
extern void gram_newcounter (void);
extern void gram_noexpand (void);
extern void gram_notrans (void);
extern void gram_nousermacro (void);
extern void gram_onename (char const *gramsym, char const *parlist);
extern int  gram_onenumber (char const *gramsym, char const *parlist); 
extern void gram_paragraph (char const *lbuf);
extern char *gram_parlist (char const *gramsym, int expand_char);
extern void gram_pipethrough (void);
extern void gram_popchartable (void);
extern void gram_pushchartable (void);
extern void gram_renamemacro (void);
extern void gram_setcounter (void);
extern void gram_subst (void);
extern void gram_startdef (void);
extern void gram_symbol (void);
extern void gram_system (void);
extern void gram_typeout (void);
extern void gram_undefinemacro (void);
extern void gram_undefinesymbol (void);
extern void gram_uppercase (void);
extern void gram_usechartable (void);
extern void gram_usecounter (void);
extern void gram_warn (char const *symbol, char const *msg, ...);
extern void gram_warning (void);
extern int  isIdentChar(int ch);
extern void init (void);
extern void lexer (void);
extern int  lexer_eof (void);
extern int  lexer_getc (void);
extern int  lexer_peek (void);
extern void lexer_pushchar (int ch);
extern void lexer_pushstr (char const *s);
extern void lexer_preread (void);
extern void message (int lev, char const *fmt, ...);
extern void output_string (char const *s);
extern void output_symbol (char const *sym);
extern void parse (void);
extern void parse_cycle (void);
extern void parse_flags (int ac, char **av);
extern void showchildstatus (int status, char const *cmd);
extern int  subst_mightbe (char const *buf);
extern void symbol_add (char const *symname);
extern void usage ();
extern int userconfirm (char const *msg);
extern void sighandler (int sig);

/* Here's for systems that don't have sterror(): */
#ifdef NEEDSTRERROR
    extern int errno;
    extern char *strerror(int err_number);
#endif

/* Same for systems that don't have optind, optarg, etc.. */
#ifdef NEEDOPT
    extern int optind, opterr;
    extern char *optarg;
#endif
