
#include "yodl.h"
#include "../../config.h"

/* Make sure that compilation succeeds even when no VER or YEARS
 * are defined.
 */

#ifndef VER
#    define VER         "unknown"
#endif

#ifndef YEARS
#    define YEARS       "1912-2099"
#endif

void usage ()
{
    fprintf (stderr,
"\n"
"Yet Oneother Document Language  V" VER "\n"
"Copyright (c) K. Kubat (ICCE) " YEARS ". All rights reserved.\n"
"Another MegaHard Production!\n"
"\n"
"Usage: yodl [flags] inputfile [inputfile...]\n"
"where:\n"
"    flags may be:\n"
"        -DNAME: defines NAME as symbol, similar to DEFINESYMBOL(NAME)\n"
"        -IDIR: defines the directory for system-wide include files,\n"
"           default " STD_INCLUDE "\n"
"        -lNR: defines the \"live data\" policy; 0 (default) is never\n"
"           allow, 1 is allow when confirmed, 2 is allow but warn, 3 is\n"
"           allow always\n"
"        -oFILE: output goes to FILE instead of stdout\n"
"        -PCMD: preloads CMD, as if CMD were the 0'th line of the input\n"
"        -pPASS: defines the maximum number of parsing passes, default %d\n"
"        -t: trace generated output to stderr during each parsing pass\n"
"        -v: increases verbosity, -vv even more etc.\n"
"        -w: program will warn about redefinitions etc.\n"
"        -h, -?: this message\n"
"    inputfiles are files to process, similar to INCLUDEFILE(FILE)\n"
"        use - to read from stdin\n"
"\n", DEFAULT_MAXPASS);

    exit (1);
}
