
#include "yodl.h"

void output_string (char const *s)
{
    char const
        *cp;                                        /* tmp var */
    char
        *conv = 0;                                  /* converted string */
    int
        is_ws;                                      /* flag: is string all */
                                                    /* whitespace? */
                                                    
    if (! s || ! *s)                                /* no string, nogo */
        return;
        
    if (! curchartab)                               /* convert strings with */
        conv = xstrdup (s);                         /* character table */
    else
        for (cp = s; *cp; cp++)
            conv = str_concat (conv, (*curchartab) [(unsigned char) *cp]);
            /* BIG NOTE: have to cast *cp to unsigned char, or
             * indexing will go haywire! This is relevant when
             * high-ascii chars such as umlauts are used!
             * Other compilers may fuck up this construction,
             * in that case I'll have to use a temp variable 
             * for indexing.
             */

    if (flags.trace_output)                         /* trace on output */
        fputs (conv, stderr);    

    if (in_def)                                     /* inside STARTDEF()? */
    {
        is_ws = 1;                                  /* assume white space */
        for (cp = conv; *cp; cp++)
            if (! isspace (*cp))
            {                   
                is_ws = 0;
                break;
            }
        if (is_ws)                                  /* if all whitespace: */
            return;                                 /* done here */
        else                                        /* not all ws: warn */
            gram_warn (builtin [mac_startdef],
                       "generated output inside DEF code");
    }
          
    output (outf, "%s", conv);
                
    last_written_char = conv [strlen (conv) - 1];
}
