
#include "yodl.h"

void gram_renamemacro ()
{
    char
        *macname,
	*newname;
    int
        index;

    macname = gram_parlist (builtin [mac_renamemacro], 0);
    gram_onename (builtin [mac_renamemacro], macname);
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    newname = gram_parlist (builtin [mac_renamemacro], 0);
    gram_onename (builtin [mac_renamemacro], newname);
    
    message (3, "%s %s %s\n", builtin [mac_renamemacro], macname, newname);

    if ( (index = strtab_find (builtin, nbuiltin, macname)) >= 0 )
    {
        free (builtin [index]);
        builtin [index] = newname;
    }
    else if ( (index = strtab_find (userdef, nuserdef, macname)) >= 0 )
    {
        free (userdef [index]);
        userdef [index] = newname;
    }
    else
        error_gram (builtin [mac_renamemacro], 
                    "cannot find macro named %s", macname);

    free (macname);
}
