
#include "yodl.h"

char *gram_parlist (char const *sym, int        /* read in 1 parameter list */
    expand_char)                                /* and return it */
{                
    int
        thisline,                               /* storage for starting line */
        bracedepth = 1;                         /* braces nesting */
    char
        *list = 0;                              /* parsed input */
        
    if (lextok != tok_openpar)                  /* must have start of list */
        error_gram (sym, "( expected");         /* now */

    thisline = cur_lineno;                      /* here the parlist starts */

    lexer ();                                   /* prepare symbol after */
						/* open parenthesis */
    while (1)
    {
        switch (lextok)
        {
            case tok_openpar:                   /* one more nesting */
                list = str_concat (list, lexbuf);
                bracedepth++;
                lexer ();
                break;

            case tok_closepar:                  /* one less nesting */
                bracedepth--;
                if (! bracedepth)
                {
                    lexer ();
                    return (list);
                }
                list = str_concat (list, lexbuf);
                lexer ();
                break;

            case tok_eof:                       /* oops.. */
                error_gram (sym, "end of parlist cannot be found, "
		            "eof encountered\n"
			    "start of scanned parlist at line %d", thisline);
                break;
            
            case tok_symbol:                    /* some grammar symbol */
                if (expand_char && 		/* expand CHAR() ?! */
		    ! strcmp (lexbuf, builtin [mac_char])
		   )
                {
                    lexer ();
                    list = str_addchar (list, gram_getchar ());
                }
                else
                {
                    if ( (gram_hasident (lexbuf)) &&
                    	 (list && *list && 
			  (isalnum (list [strlen (list) - 1]) ||
                           list [strlen (list) - 1] == '+')
			 )
		       )
                        list = str_addchar (list, '+');
                    list = str_concat (list, lexbuf);
                    lexer ();
                }
                break;
                

       	    default:                            /* any other */
                list = str_concat (list, lexbuf);
                lexer ();
        }
    }
}
