/*
    gramincludelit.c Piet W. Plomp 10-Feb-97
    Implements the builtin macro INCLUDELITERAL

    Note: no attempt is made to qualify the filename.
*/

#include "yodl.h"

void gram_includelit ()
{
    char
        *name,
        *old_cur_input_file,
        buf[513];
    FILE
        *old_inf;
        
    name = gram_parlist (builtin [mac_includeliteral], 0);
    gram_onename (builtin [mac_includeliteral], name);

    message (2, "including literal file: %s\n", name);

    old_cur_input_file = cur_input_file;
    cur_input_file = name;

    old_inf = inf;
    inf = open_file (name, "r");

    while(fgets(buf, 512, inf))
        output_string (buf);
    
    close_file (inf);

    inf = old_inf;

    cur_input_file = old_cur_input_file;

    message (2, "done with literally included file: %s\n", name);
}
