
#include "yodl.h"

void gram_ifempty ()
{
    char
        *symbol,
	*truelist,
	*falselist;
                                             /* get symbol, true-, falselist */
    symbol = gram_parlist (builtin [mac_ifempty], 0); 
    message (3, "%s %s\n", builtin [mac_ifempty], str_short (symbol));
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    truelist = gram_parlist (builtin [mac_ifempty], 0);
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    falselist = gram_parlist (builtin [mac_ifempty], 0);
    
    lexer_pushstr (lexbuf);                 /* push back beyond parlist */
    
    if (symbol && *symbol)                  /* push back expansion */
        lexer_pushstr (falselist);
    else
        lexer_pushstr (truelist);
        
    lexer ();                               /* prepare next */

    free (symbol);                          /* return used memory */
    free (truelist);
    free (falselist);
}
