
#include "yodl.h"

void gram_ifdef ()
{
    char
        *symbol,
	*truelist,
	*falselist;
                                             /* get symbol, true-, falselist */
    symbol = gram_parlist (builtin [mac_ifdef], 0); 
    gram_onename (builtin [mac_ifdef], symbol);
    
    message (3, "%s %s\n", builtin [mac_ifdef], str_short (symbol));
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    truelist = gram_parlist (builtin [mac_ifdef], 0);
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    falselist = gram_parlist (builtin [mac_ifdef], 0);
    
    lexer_pushstr (lexbuf);                 /* push back beyond parlist */

    if (strtab_find (define, ndefine, symbol) > -1          ||    
        strtab_find (builtin, nbuiltin, symbol) > -1        ||    
        strtab_find (userdef, nuserdef, symbol) > -1        ||    
        strtab_find (countername, ncountername, symbol) > -1    
       )    
        lexer_pushstr (truelist);
    else
        lexer_pushstr (falselist);
        
    lexer ();                               /* prepare next symbol */

    free (symbol);                          /* return used memory */
    free (truelist);
    free (falselist);
}
