
#include "yodl.h"

void error_gram (char const *rule, char const *msg, ...)
{
    va_list
        args;
        
    if (! lexbuf || ! *lexbuf)
        lexbuf = "<empty>";
    else if (*lexbuf == '\n')
        lexbuf = "<newline>";
        
    va_start (args, msg);
    fprintf (stderr, "yodl: %s [near %d],\n"
                     "during %s:\n", 
             cur_input_file, cur_lineno, rule);
    vfprintf (stderr, msg, args);
    fprintf (stderr, "\n(last parsed symbol: `%s')\n", lexbuf);

    exit (1);
}