
#include "lib.h"

FILE *open_file (char const *name, char const *mode)
{
    FILE
        *ret;
        
    if (! strcmp (name, "-"))                       /* stdin/out? */
        ret = (*mode == 'r') ? stdin : stdout;
    else                                            /* real filename ? */
        if (! (ret = fopen (name, mode)) )
            error ("cannot open input file %s for %s",
                    name, 
                    *mode == 'r' ? "reading" : "writing");
                
    return (ret);
}
