/* striproff (read as: strip roff)
 *
 * Just a quick hack. Program strips roff's control characters from files. 
 * E.g, if you have a file "whatever.txt" that comes from a *roff -Tascii 
 * command, "striproff whatever.txt" will remove the control chars from it.
 * 
 * Alternatively, use it in a pipe as in "striproff < whatever.txt > new.txt".
 *  
 * If you have Yodl, then the following will work:
 *  
 * yold2manless file.yo | striproff > stripped         (for manpages)
 * yodl2msless file.yo | striproff > stripped          (for other docs)
 */

#include <stdio.h>

#define TMPNAME "STRIPROFF.TMP"

void cleanup (FILE *inf, FILE *outf)
{
    char
        ch;
        
    while (1)
    {
        ch = fgetc (inf);
        if (feof (inf))
            break;
            
        if (ch == '_')
        {
            if ( (ch = fgetc (inf)) != '\b')
                fprintf (outf, "_%c", ch);
        }    
        else if (ch == '\b')
            fgetc (inf);
        else
            fputc (ch, outf);
    }
}

int main (int argc, char **argv)
{
    FILE
        *inf,
	*outf;
    int
        i;
        
    if (argc == 1)
        cleanup (stdin, stdout);
    else
        for (i = 1; i < argc; i++)
        {
            if (! (inf = fopen (argv [i], "r")) )
            {
                perror (argv [i]);
                exit (1);
            }
            if (! (outf = fopen (TMPNAME, "w")) )
            {
                perror (TMPNAME);
                exit (1);
            }
            cleanup (inf, outf);
            fclose (inf);
	    fclose (outf);
            if (rename (TMPNAME, argv [i]))
            {
                perror (argv [i]);
                exit (1);
            }
        }
        
    return (0);
}
