/*
   Unix SMB/Netbios implementation.
   Version 2.0
   SMB wrapper functions - definitions
   Copyright (C) Andrew Tridgell 1998

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"

#if HAVE___XSTAT

#define __KERNEL__
#define new_stat	stat
#include <asm/stat.h>
#include "smbw_xstat.h"

void kernel_xstat_convert(void *kbuf, void *xbuf)
{
	struct smbw_xstat *xst;
	struct stat *st;

	xst = (struct smbw_xstat *)xbuf;
	st = (struct stat *)kbuf;

	xst->xst_dev = st->st_dev;
	xst->xst_ino = st->st_ino;
	xst->xst_mode = st->st_mode;
	xst->xst_nlink = st->st_nlink;
	xst->xst_uid = st->st_uid;
	xst->xst_gid = st->st_gid;
	xst->xst_rdev = st->st_rdev;
	xst->xst_size = st->st_size;
	xst->xst_blksize = st->st_blksize;
	xst->xst_blocks = st->st_blocks;
	xst->xst_atime = st->st_atime;
	xst->xst_mtime = st->st_mtime;
	xst->xst_ctime = st->st_ctime;
}
#else
 void xstat_dummy_function(void);
 void xstat_dummy_function(void) { } /* stop some compilers complaining */
#endif
