#!/usr/bin/sh
PRODUCT=Samba
DEPOT=samba.depot
PSF=samba.psf
export PRODUCT
export DEPOT
export PSF

if [ -d /opt/ansic ]; then
  PATH=/opt/ansic/bin:${PATH}
  export PATH
  echo Using ANSI-C
elif [ -d /opt/gcc -a -d /opt/binutils ]; then
  PATH=/opt/gcc/bin:/opt/binutils/bin:${PATH}
  export PATH
  echo Using gcc
fi

(cd ../../source; ./configure --prefix=/opt/samba \
    --localstatedir=/var/opt/samba \
    --with-automount --with-pam \
    --with-syslog --with-profile \
    --with-quotas --with-netatalk \
    --with-utmp --with-i18n-swat ;
make
)

mkdir codepage >/dev/null 2>&1
mkdir man >/dev/null 2>&1
mkdir textdocs >/dev/null 2>&1
mkdir locale >/dev/null 2>&1
mkdir memos >/dev/null 2>&1

./gen_psf.sh $PRODUCT

echo "Creating software depot ($DEPOT) for product $PRODUCT"

env -i /usr/sbin/swpackage -vv -s samba.psf -x target_type=tape -d `pwd`/$DEPOT $PRODUCT 

#- clean-up temporary directories
rm -r codepage
rm -r man
rm -r textdocs
rm -r locale
rm -r memos

