#!/usr/bin/sh
#- Below variables are editable.
#-  VERSION     Script tries to set the version automatically if it's empty
#-              string. The version number is assumed to be in
#-              ../../source/include/version.h. Should this fail to find correct
#-              version, set it manually to override automatic search.
#-  BIN         List of binaries from ../../source/bin. Note: do not include
#-              swat here for it is a part of Samba.swat fileset
#-  SCRIPT      List of scripts
#-  OS_REVISION The regular expression to determine the supported OS version.
#-              The default versions are HP-UX 10.10 or later as well as 11.*.
#-              You can modify this to reflect the OS you compile on. For
#-              instance, to support any 10.? and 11.? releases, use the
#-              following string:
#-                  '?.10.*|?.11.*
    VERSION=""

        BIN="smbd nmbd smbclient testparm testprns smbstatus\
             rpcclient smbpasswd make_smbcodepage make_unicodemap\
             nmblookup make_printerdef smbspool make_nftable"

     SCRIPT="smbtar addtosmbpass convert_smbpasswd"

 OS_RELEASE='?.10.[2-9]?|?.11.*'


#- Below variables should be exported from create_package.sh

if [ -z "$PSF" ]
then
  PSF=samba.psf
fi

if [ -z "$DEPOT" ]
then
  DEPOT=samba.depot
fi

if [ -z "$PRODUCT" ]
then
  PRODUCT=Samba
fi

#--------------------------------------------------------------------------
CODEPAGES=""
if [ -z "$VERSION" ]
then
  echo "Deducing Samba version from version.h ... \c"
  VERSION=`grep VERSION ../../source/include/version.h | awk '{print $3}' |\
           tr -d '"'`
  if [ $? -ne 0 -o -z "$VERSION" ]
  then
    echo "failed."
    echo "Cannot find Samba version. Edit gen_psf.sh and set VERSION"
    echo "variable manually."
    exit 1
  else
    echo "$VERSION"
  fi
fi

echo "Creating list of codepage definitions ..."

## This is the original procedure:
#- create codepages from definition and add them to PSF file
#for a in ../../source/codepages/codepage_def.[0-9][0-9][0-9]
#do
#  b=${a##../../source/codepages/codepage_def.}
#  CODEPAGES="$CODEPAGES $b"
#done
## This is another way to provide CODEPAGES in Makefile:
# CODEPAGES="437 737 775 850 852 861 932 866 949 950 936 1251 ISO8859-1 ISO8859-2 ISO8859-5 ISO8859-7 KOI8-R"
## I picked up original soul and activated it with latter if clauses.
CODEPAGES=`(
cd ../../source/codepages
ls codepage_def.* | cut -f2- -d\.
ls CP*.TXT | cut -c3- | sed 's/.TXT$//'
) | sort -u | tr "\012" " "`
echo "\t$CODEPAGES"

echo "Running make_smbcodepage on codepage definitions ... \c"

mkdir codepage >/dev/null 2>&1
for a in $CODEPAGES
do
## This if clause skips if codepage_def.$a does not exist.
if [ -f ../../source/codepages/codepage_def.$a ]
then
../../source/bin/make_smbcodepage c $a ../../source/codepages/codepage_def.$a\
                                    codepage/codepage.$a
fi
done
echo "done."

echo "Running make_unicodemap on codepage definitions ... \c"

for a in $CODEPAGES
do
## This if clause skips if CP${a}.TXT does not exist.
if [ -f ../../source/codepages/CP${a}.TXT ]
then
../../source/bin/make_unicodemap $a ../../source/codepages/CP${a}.TXT\
                                    codepage/unicode_map.$a
  ## This if clause skips if CP${a}.TXT does not exist.
  if [ -f ../../source/codepages/NormalizationTest.txt ]
  then
    ../../source/bin/make_nftable $a \
    ../../source/codepages/NormalizationTest.txt \
    ../../source/codepages/NFD2MacOSX.txt \
    ../../source/codepages/CP${a}.TXT \
    codepage/nftable.$a
  fi
fi
done
echo "done."

#- HP-UX uses slightly different section numbers for man pages. The following
#- compares to "normal" sections:
#-
#-             Section        HP-UX section
#-                 1          1                user commands
#-                 5          4                files
#-                 7          5                concepts
#-                 8          1m               administration commands
#- NOTE:
#- Sed expressions used in below loops replaces original section references
#- inside man page with HP-UX section references. Assumption is that
#- only numbers in brackets are section references and nothing else.
#- So far I did not see the man pages corrupted by replacing anything
#- else but section references.

mkdir man >/dev/null 2>&1
mkdir man/ja_JP.eucJP >/dev/null 2>&1
mkdir man/ja_JP.SJIS >/dev/null 2>&1
echo "Coverting man pages to HP-UX numbering ..."
echo "\t Sections 1 \c"
for a in ../../docs/manpages/*.1
do
  sed -e 's/^[.]TH \([^ ][^ ]*\) .*/.TH \1 1/'\
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/`basename $a`
done
for a in ../../docs/ja/manpages/*.1.man
do
  b=`basename $a`
  c=${b%.1.man}
  sed -e 's/^[.]TH.*$/.TH '$c' 1/' \
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/ja_JP.eucJP/$c.1
done

echo "1m \c"
for a in ../../docs/manpages/*.8
do
  b=`basename $a`
  c=${b%.8}
  sed -e 's/^[.]TH \([^ ][^ ]*\) .*/.TH \1 1M/'\
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/$c.1m
done
for a in ../../docs/ja/manpages/*.8.man
do
  b=`basename $a`
  c=${b%.8.man}
  sed -e 's/^[.]TH.*$/.TH '$c' 1M/' \
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/ja_JP.eucJP/$c.1m
done

echo "4 \c"
for a in ../../docs/manpages/*.5
do
  b=`basename $a`
  c=${b%.5}
  sed -e 's/^[.]TH \([^ ][^ ]*\) .*/.TH \1 4/'\
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/$c.4
done
for a in ../../docs/ja/manpages/*.5.man
do
  b=`basename $a`
  c=${b%.5.man}
  sed -e 's/^[.]TH.*$/.TH '$c' 4/' \
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/ja_JP.eucJP/$c.4
done

echo "5"
for a in ../../docs/manpages/*.7
do
  b=`basename $a`
  c=${b%.7}
  sed -e 's/^[.]TH \([^ ][^ ]*\) .*/.TH \1 5/'\
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/$c.5
done
for a in ../../docs/ja/manpages/*.7.man
do
  b=`basename $a`
  c=${b%.7.man}
  sed -e 's/^[.]TH.*$/.TH '$c' 5/' \
      -e '1a\
.ds )H Samba Team'\
      -e "1a\\
.ds ]W $VERSION"\
      -e 's/(8)/(1m)/g' \
      -e 's/(5)/(4)/g' \
      -e 's/(7)/(5)/g' \
      $a >man/ja_JP.eucJP/$c.5
done

for a in man/ja_JP.eucJP/*
do
    /usr/bin/iconv -f eucJP -t sjis $a >man/ja_JP.SJIS/`basename $a`
done

echo "Creating product specification file:"
echo "\tVendor and product description"
#- vendor and header of product definition
cat <<_EOF_ >$PSF
vendor
	tag   	Samba
	title 	Samba Team
	description <vendor_description
end

product
  tag   	$PRODUCT
  title		Samba Server
  description	< ../../WHATSNEW.txt
  copyright	"Copyright (c) 1998 Samba Team. See COPYING for details."
  readme	< ../../README
  revision	$VERSION
  machine_type	*
  os_name	HP-UX
  os_release	$OS_RELEASE
  os_version	*
  directory	/
  is_locatable	false
  vendor_tag	Samba

_EOF_

echo "\tFileset $PRODUCT.core"

cat <<_EOF_ >>$PSF
  fileset
    tag			core
    title		Samba server core components
    revision		$VERSION
    is_kernel		false
    is_reboot		false
    is_secure		false
    configure		configure.bin
    unconfigure		unconfigure.bin

    file    -m 0755 -o root -g sys / /opt/samba/
    file    -m 0755 -o root -g sys / /opt/samba/bin/
    file    -m 0755 -o root -g sys / /opt/samba/lib/
    file    -m 0755 -o root -g sys / /opt/samba/lib/codepages/
    file    -m 0755 -o root -g sys / /opt/samba/newconfig/
    file    -m 0755 -o root -g sys / /opt/samba/newconfig/examples/
    file    -m 0700 -o root -g sys / /opt/samba/private/
    file    -m 0755 -o root -g sys / /var/opt/samba/
    file    -m 0755 -o root -g sys / /var/opt/samba/locks/

    file    -m 0444 -o root -g sys ../../ANNOUNCE.ja /opt/samba/ANNOUNCE.ja
    file    -m 0444 -o root -g sys ../../COPYING /opt/samba/COPYING
    file    -m 0444 -o root -g sys ../../README /opt/samba/README
    file    -m 0444 -o root -g sys ../../README-smbmount /opt/samba/README-smbmount
    file    -m 0444 -o root -g sys ../../RELNOTE.en /opt/samba/RELNOTE.en
    file    -m 0444 -o root -g sys ../../RELNOTE.ja /opt/samba/RELNOTE.ja
    file    -m 0444 -o root -g sys ../../Roadmap /opt/samba/Roadmap
    file    -m 0444 -o root -g sys ../../WHATSNEW.txt /opt/samba/WHATSNEW.txt
    file    -m 0444 -o root -g sys ./Instructions /opt/samba/Instructions
    file    -m 0444 -o root -g sys ./Instructions.ja /opt/samba/Instructions.ja_JP.eucJP
    file    -m 0555 -o root -g sys ./samba.boot /sbin/init.d/samba
    file    -m 0444 -o root -g sys ./samba.config /opt/samba/newconfig/samba.config

    file    -m 0444 -o root -g sys ../../examples/smb.conf.default /opt/samba/newconfig/examples/smb.conf.default
    file    -m 0444 -o root -g sys ../../examples/smb.conf.default.ja /opt/samba/newconfig/examples/smb.conf.default.ja
    file    -m 0444 -o root -g sys ../../examples/simple/smb.conf /opt/samba/newconfig/examples/smb.conf.simple
    file    -m 0444 -o root -g sys ../../examples/dce-dfs/smb.conf /opt/samba/newconfig/examples/smb.conf.dce-dfs
_EOF_

if [ ! -d memos ]
then
  mkdir memos
fi
for memo in ../../ANNOUNCE.ja ../../RELNOTE.ja ./Instructions.ja
do
  b=`basename $memo`
  c=${b%.ja}.ja_JP.SJIS
  /usr/bin/iconv -f eucJP -t sjis <$memo >memos/$c
  echo "    file    -m 0444 -o root -g sys memos/$c /opt/samba/$c" >> $PSF
done

  echo "    directory ../../source/bin=/opt/samba/bin" >> $PSF
  for a in $BIN
  do
    echo "    file    -m 0555 -o root -g sys $a" >>$PSF
  done

  echo "    directory ../../source/script=/opt/samba/bin" >>$PSF

  for a in $SCRIPT
  do
    echo "    file    -m 0555 -o root -g sys $a" >>$PSF
  done

  echo "    directory ./codepage=/opt/samba/lib/codepages" >> $PSF

  for a in $CODEPAGES
  do
    if [ -f ./codepage/codepage.$a ]
    then
      echo "    file    -m 0444 -o root -g sys codepage.$a" >>$PSF
    fi
  done

  for a in $CODEPAGES
  do
    if [ -f ./codepage/unicode_map.$a ]
    then
      echo "    file    -m 0444 -o root -g sys unicode_map.$a" >>$PSF
    fi
  done

  for a in $CODEPAGES
  do
    if [ -f ./codepage/nftable.$a ]
    then
      echo "    file    -m 0444 -o root -g sys nftable.$a" >>$PSF
    fi
  done

  echo "  end" >>$PSF
#- end of fileset CORE

echo "\tFileset $PRODUCT.man"
#- Man pages
cat <<_EOF_ >>$PSF
  fileset
    tag             man
    title           Samba server man pages
    revision        $VERSION
    is_kernel       false
    is_reboot       false
    is_secure       false
    configure       configure.man

    file    -m 0755 -o root -g sys / /opt/samba/man/
    file    -m 0755 -o root -g sys / /opt/samba/man/man1/
    file    -m 0755 -o root -g sys / /opt/samba/man/man1m/
    file    -m 0755 -o root -g sys / /opt/samba/man/man4/
    file    -m 0755 -o root -g sys / /opt/samba/man/man5/

_EOF_

#- HP-UX uses slightly different section numbers for man pages. The following
#- compares to "normal" sections:
#-
#-             Section        HP-UX section
#-                 1          1                user commands
#-                 5          4                files
#-                 7          5                concepts
#-                 8          1m               administration commands

  for a in man/*.1
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $a /opt/samba/man/man1/$b" >>$PSF
  done

  for a in man/*.1m
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $a /opt/samba/man/man1m/$b" >>$PSF
  done

  for a in man/*.4
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $a /opt/samba/man/man4/$b" >>$PSF
  done

  for a in man/*.5
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $a /opt/samba/man/man5/$b" >>$PSF
  done

  for s in 1 1m 4 5
  do
    for l in ja_JP.SJIS ja_JP.eucJP
    do
      for a in man/$l/*.$s
      do
        b=`basename $a`
        echo "    file    -m 0444 -o root -g sys $a /opt/samba/man/$l/man$s/$b" >>$PSF
      done
    done
  done

  echo "  end" >>$PSF

echo "\tFileset $PRODUCT.swat"

cat <<_EOF_ >>$PSF

  fileset
    tag             swat
    title           Samba Web-based administration tool
    revision        $VERSION
    is_kernel       false
    is_reboot       false
    is_secure       false
    prerequisite    Samba.core
    configure       configure.swat
    unconfigure     unconfigure.swat

    file    -m 0755 -o root -g sys / /opt/samba/swat/
    file    -m 0755 -o root -g sys / /opt/samba/swat/help/
    file    -m 0755 -o root -g sys / /opt/samba/swat/images/
    file    -m 0755 -o root -g sys / /opt/samba/swat/include/
    file    -m 0755 -o root -g sys / /opt/samba/swat/using_samba/
    file    -m 0755 -o root -g sys / /opt/samba/swat/using_samba/ja/
    file    -m 0755 -o root -g sys / /opt/samba/swat/using_samba/ja/figs/
    file    -m 0755 -o root -g sys / /opt/samba/swat/using_samba/ja/gifs/
    file    -m 0755 -o root -g sys / /opt/samba/swat/using_samba/figs/
    file    -m 0755 -o root -g sys / /opt/samba/swat/using_samba/gifs/
    file    -m 0755 -o root -g sys / /opt/samba/swat/ja/
    file    -m 0755 -o root -g sys / /opt/samba/swat/ja/help/
    file    -m 0755 -o root -g sys / /opt/samba/swat/ja/help/HowToUseSamba/
    file    -m 0755 -o root -g sys / /opt/samba/swat/ja/images/
    file    -m 0755 -o root -g sys / /opt/samba/swat/ja/include/
    file    -m 0755 -o root -g sys / /opt/samba/share/
    file    -m 0755 -o root -g sys / /opt/samba/share/locale/
    file    -m 0755 -o root -g sys / /opt/samba/share/locale/en/
    file    -m 0755 -o root -g sys / /opt/samba/share/locale/en/LC_MESSAGES/
    file    -m 0755 -o root -g sys / /opt/samba/share/locale/ja/
    file    -m 0755 -o root -g sys / /opt/samba/share/locale/ja/LC_MESSAGES/

    directory ../../swat=/opt/samba/swat
    file    -m 0444 -o root -g sys README

    directory ../../source/bin=/opt/samba/bin
    file    -m 0555 -o root -g sys swat

    directory ../../swat/images=/opt/samba/swat/images
_EOF_

  for a in ../../swat/images/*.gif
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done

  echo "    directory ../../swat/ja/images=/opt/samba/swat/ja/images" >>$PSF

  for a in ../../swat/ja/images/*.gif
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done

  echo "    directory ../../swat/help=/opt/samba/swat/help" >>$PSF

  for a in ../../swat/help/*.html
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done

  echo "    directory ../../swat/ja/help=/opt/samba/swat/ja/help" >>$PSF

  for a in ../../swat/ja/help/*.html
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done

  echo "    directory ../../docs/htmldocs=/opt/samba/swat/help" >>$PSF

  for a in ../../docs/htmldocs/*.html
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done
  
  echo "    directory ../../docs/ja/htmldocs=/opt/samba/swat/ja/help" >>$PSF

  for a in ../../docs/ja/htmldocs/*.html
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done
  
  echo "    directory ../../swat/include=/opt/samba/swat/include" >>$PSF

  for a in ../../swat/include/*.html
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done

  echo "    directory ../../swat/ja/include=/opt/samba/swat/ja/include" >>$PSF

  for a in ../../swat/ja/include/*.html
  do
    b=`basename $a`
    echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
  done

  for ln in . ja
  do
    if test "a$ln" = "a."
    then
      USING_SRC1=../../docs/htmldocs/using_samba
      USING_SRC2=../../docs/htmldocs/using_samba
      USING_DES=/opt/samba/swat/using_samba
    else
      USING_SRC1=../../docs/$ln/htmldocs/using_samba
      USING_SRC2=../../docs/htmldocs/using_samba
      USING_DES=/opt/samba/swat/using_samba/$ln
    fi
    echo "    directory $USING_SRC1=$USING_DES" >>$PSF
    for a in $USING_SRC1/*.html
    do
      b=`basename $a`
      echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
    done
#     echo "    directory $USING_SRC1/figs=$USING_DES/figs" >>$PSF
    echo "    directory $USING_SRC2/figs=$USING_DES/figs" >>$PSF
#     for a in $USING_SRC1/figs/*.gif
    for a in $USING_SRC2/figs/*.gif
    do
      b=`basename $a`
      echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
    done
#     echo "    directory $USING_SRC1/gifs=$USING_DES/gifs" >>$PSF
    echo "    directory $USING_SRC2/gifs=$USING_DES/gifs" >>$PSF
#     for a in $USING_SRC1/*.gif
    for a in $USING_SRC2/gifs/*.gif
    do
      b=`basename $a`
      echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
    done
  done
  for ln in ja
  do
    echo "    directory ../../docs/$ln/htmldocs/HowToUseSamba=/opt/samba/swat/$ln/help/HowToUseSamba" >>$PSF
    for a in ../../docs/$ln/htmldocs/HowToUseSamba/*.html
    do
      b=`basename $a`
      echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
    done
    for a in ../../docs/$ln/htmldocs/HowToUseSamba/*.gif
    do
      b=`basename $a`
      echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
    done
    for a in ../../docs/$ln/htmldocs/HowToUseSamba/*.GIF
    do
      b=`basename $a`
      echo "    file    -m 0444 -o root -g sys $b" >>$PSF   
    done
    mkdir textdocs/$ln >/dev/null 2>&1
    echo "    directory textdocs/$ln=/opt/samba/swat/$ln/help" >>$PSF
    for a in ../../docs/$ln/textdocs/*.txt
    do
      b=`basename $a`
      d=`dirname $a`
      cat  $d/header.html $a $d/footer.html > textdocs/$ln/$b.html
      echo "    file    -m 0444 -o root -g sys $b.html" >>$PSF   
    done
  done
  mkdir locale >/dev/null 2>&1
  for la in en ja
  do
    mkdir locale/$la >/dev/null 2>&1
    cp ../../source/po/$la.gmo locale/$la/i18n_swat.mo
    echo "    directory locale/$la=/opt/samba/share/locale/$la/LC_MESSAGES/" >> $PSF
    echo "    file    -m 0444 -o root -g sys i18n_swat.mo" >>$PSF   
  done
cat <<_EOF_ >>$PSF
  end

end
_EOF_

