/*
   Unix SMB/Netbios implementation.
   Version 1.9.
   Kanji Extensions
   Copyright (C) Andrew Tridgell 1992-1998
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Adding for Japanese language by <fujita@ainix.isac.co.jp> 1994.9.5
     and extend coding system to EUC/SJIS/JIS/HEX at 1994.10.11
     and add all jis codes sequence at 1995.8.16
     Notes: Hexadecimal code by <ohki@gssm.otuka.tsukuba.ac.jp>
     and add upper/lower case conversion 1997.8.21
*/
#ifndef _KANJI_H_
#define _KANJI_H_

/*
#define KANJI_WIN95_COMPATIBILITY
*/

#ifdef _KANJI_C_
#define K_EXTERN
#define K_INIT
#else
#define K_EXTERN		extern
#endif

#define B_0			( 1 <<  0 )
#define B_1			( 1 <<  1 )
#define B_2			( 1 <<  2 )
#define B_3			( 1 <<  3 )
#define B_4			( 1 <<  4 )
#define B_5			( 1 <<  5 )
#define B_6			( 1 <<  6 )
#define B_7			( 1 <<  7 )
#define B_8			( 1 <<  8 )
#define B_9			( 1 <<  9 )
#define B_A			( 1 << 10 )
#define B_B			( 1 << 11 )
#define B_C			( 1 << 12 )
#define B_D			( 1 << 13 )
#define B_E			( 1 << 14 )
#define B_F			( 1 << 15 )

#define KC_SHIFT_JIS		B_0
#define KC_SHIFT_JIS2		B_1
#define KC_KANA			B_2
#define KC_SJ_UPPER2		B_3
#define KC_SJ_LOWER2		B_4
#define KC_SJ_GR_UPPER2		B_5
#define KC_SJ_GR_LOWER2		B_6
#define KC_SJ_RU_UPPER2		B_7
#define KC_SJ_RU_LOWER2		B_8
#define KC_SJ_RO_UPPER2		B_9
#define KC_SJ_RO_LOWER2		B_A
#define KC_SJ_RO2_UPPER2	B_B
#define KC_SJ_RO2_LOWER2	B_C
#define IS_KCTYPE(c, t)		(kctype_table[(unsigned char)(c)] & (t))
#define KC_EUC_JP		B_0
#define KC_JIS_SO2		B_1
#define KC_JIS_SI2		B_2
#define KC_HANGUL		B_3
#define KC_BIG5_C1		B_4
#define KC_SIMPCH_C1		B_5
#define KC_JIS_G1_UDC		B_6
#define KC_JIS_G3_UDC		B_7
#define KC_SJIS_G1_UDC		B_8
#define KC_SJIS_G3_UDC		B_9
#define KC_SJIS_IBM		B_A
#define KC_SJIS_NEC		B_B
#define IS_KCTYPE2(c, t)	(kctype_table2[(unsigned char)(c)] & (t))
#define HC_HEX 			B_0
#define HC_CAP			B_1
#define IS_HCTYPE(c, t)		(hctype_table[(unsigned char)(c)] & (t))

/* For SHIFT JIS CODE */
#define is_shift_jis(c)		IS_KCTYPE(c, KC_SHIFT_JIS)
#define is_shift_jis2(c)	IS_KCTYPE(c, KC_SHIFT_JIS2)
#define is_kana(c)		IS_KCTYPE(c, KC_KANA)

/* case conversion */
#define is_sj_upper2(c)		IS_KCTYPE(c, KC_SJ_UPPER2)
#define is_sj_lower2(c)		IS_KCTYPE(c, KC_SJ_LOWER2)
#define sjis_alph		0x82
#define is_sj_alph(c)		((unsigned char)(c) == sjis_alph)
#define is_sj_upper(c1, c2)	(is_sj_alph(c1) && is_sj_upper2(c2))
#define is_sj_lower(c1, c2)	(is_sj_alph(c1) && is_sj_lower2(c2))
#define sj_toupper(c)		sj_toupper_table[(unsigned char)(c)]
#define sj_tolower(c)		sj_tolower_table[(unsigned char)(c)]
#define sj_toupper2(c)		sj_toupper_table[(unsigned char)(c)]
#define sj_tolower2(c)		sj_tolower_table[(unsigned char)(c)]

#define is_sj_gr_upper2(c)	IS_KCTYPE(c, KC_SJ_GR_UPPER2)
#define is_sj_gr_lower2(c)	IS_KCTYPE(c, KC_SJ_GR_LOWER2)
#define sjis_greek		0x83
#define is_sj_greek(c)		((unsigned char)(c) == sjis_greek)
#define is_sj_gr_upper(c1, c2)	(is_sj_greek(c1) && is_sj_gr_upper2(c2))
#define is_sj_gr_lower(c1, c2)	(is_sj_greek(c1) && is_sj_gr_lower2(c2))
#define sj_gr_toupper(c)	sj_gr_toupper_table[(unsigned char)(c)]
#define sj_gr_toupper2(c)	sj_gr_toupper_table[(unsigned char)(c)]
#define sj_gr_tolower(c)	sj_gr_tolower_table[(unsigned char)(c)]
#define sj_gr_tolower2(c)	sj_gr_tolower_table[(unsigned char)(c)]

#define is_sj_ru_upper2(c)	IS_KCTYPE(c, KC_SJ_RU_UPPER2)
#define is_sj_ru_lower2(c)	IS_KCTYPE(c, KC_SJ_RU_LOWER2)
#define sjis_russian		0x84
#define is_sj_russian(c)	((unsigned char)(c) == sjis_russian)
#define is_sj_ru_upper(c1, c2)	(is_sj_russian(c1) && is_sj_ru_upper2(c2))
#define is_sj_ru_lower(c1, c2)	(is_sj_russian(c1) && is_sj_ru_lower2(c2))
#define sj_ru_toupper(c)	sj_ru_toupper_table[(unsigned char)(c)]
#define sj_ru_toupper2(c)	sj_ru_toupper_table[(unsigned char)(c)]
#define sj_ru_tolower(c)	sj_ru_tolower_table[(unsigned char)(c)]
#define sj_ru_tolower2(c)	sj_ru_tolower_table[(unsigned char)(c)]

#define is_sj_ro_upper2(c)	IS_KCTYPE(c, KC_SJ_RO_UPPER2)
#define is_sj_ro_lower2(c)	IS_KCTYPE(c, KC_SJ_RO_LOWER2)
#define sjis_roman		0xfa
#define is_sj_roman(c)		((unsigned char)(c) == sjis_roman)
#define is_sj_ro_upper(c1, c2)	(is_sj_roman(c1) && is_sj_ro_upper2(c2))
#define is_sj_ro_lower(c1, c2)	(is_sj_roman(c1) && is_sj_ro_lower2(c2))
#define sj_ro_toupper(c)	sj_ro_toupper_table[(unsigned char)(c)]
#define sj_ro_toupper2(c)	sj_ro_toupper_table[(unsigned char)(c)]
#define sj_ro_tolower(c)	sj_ro_tolower_table[(unsigned char)(c)]
#define sj_ro_tolower2(c)	sj_ro_tolower_table[(unsigned char)(c)]

K_EXTERN unsigned short kctype_table[256]
#ifdef K_INIT
= {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00-0x0f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10-0x1f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x20-0x2f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x30-0x3f */
/*+---------------------------------------------------- KC_SHIFT_JIS
 *|   +------------------------------------------------ KC_SHIFT_JIS2
 *|   |   +-------------------------------------------- KC_KANA
 *|   |   |   +---------------------------------------- KC_SJ_UPPER2
 *|   |   |   |   +------------------------------------ KC_SJ_LOWER2
 *|   |   |   |   |   +-------------------------------- KC_SJ_GR_UPPER2
 *|   |   |   |   |   |   +---------------------------- KC_SJ_GR_LOWER2
 *|   |   |   |   |   |   |   +------------------------ KC_SJ_RU_UPPER2
 *|   |   |   |   |   |   |   |   +-------------------- KC_SJ_RU_LOWER2
 *|   |   |   |   |   |   |   |   |   +---------------- KC_SJ_RO_UPPER2
 *|   |   |   |   |   |   |   |   |   |   +------------ KC_SJ_RO_LOWER2
 *|   |   |   |   |   |   |   |   |   |   |   +-------- KC_SJ_RO2_UPPER2
 *|   |   |   |   |   |   |   |   |   |   |   |   +---- KC_SJ_RO2_LOWER2
 *|   |   |   |   |   |   |   |   |   |   |   |   | */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x40 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x41 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x42 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x43 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x44 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x45 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x46 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x47 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x48 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0x49 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x4a */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x4b */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x4c */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x4d */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x4e */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x4f */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x50 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x51 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x52 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0x53 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x54 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x55 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x56 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x57 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x58 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x59 */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x5a */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x5b */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x5c */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0x5d */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5e */
  0|B_1|  0|  0|  0|  0|  0|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5f */
  0|B_1|  0|B_3|  0|  0|  0|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x60 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x61 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x62 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x63 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x64 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x65 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x66 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x67 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x68 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x69 */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6a */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6b */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6c */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6d */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6e */
  0|B_1|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6f */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x70 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x71 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x72 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x73 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x74 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x75 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x76 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x77 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x78 */
  0|B_1|  0|B_3|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x79 */
  0|B_1|  0|  0|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x7a */
  0|B_1|  0|  0|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x7b */
  0|B_1|  0|  0|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x7c */
  0|B_1|  0|  0|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x7d */
  0|B_1|  0|  0|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x7e */
                                                              0, /* 0x7f */
  0|B_1|  0|  0|  0|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x80 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x81 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x82 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x83 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x84 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x85 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x86 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x87 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x88 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x89 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x8a */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x8b */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x8c */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x8d */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x8e */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x8f */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x90 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0x91 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x92 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x93 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x94 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x95 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x96 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x97 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x98 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x99 */
B_0|B_1|  0|  0|B_4|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9a */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9b */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9c */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9d */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9e */
B_0|B_1|  0|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9f */
  0|B_1|  0|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa0 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa1 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa2 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa3 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa4 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa5 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa6 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa7 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa8 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa9 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xaa */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xab */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xac */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xad */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xae */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xaf */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb0 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb1 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb2 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb3 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb4 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb5 */
  0|B_1|B_2|  0|  0|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb6 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb7 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb8 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb9 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xba */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbb */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbc */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbd */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbe */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbf */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc0 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc1 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc2 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc3 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc4 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc5 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc6 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc7 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc8 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc9 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xca */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcb */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcc */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcd */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xce */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcf */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd0 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd1 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd2 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd3 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd4 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd5 */
  0|B_1|B_2|  0|  0|  0|B_6|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd6 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd7 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd8 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd9 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xda */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdb */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdc */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdd */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xde */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdf */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe0 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe1 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe2 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe3 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe4 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe5 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe6 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe7 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe8 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe9 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xea */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xeb */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xec */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xed */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xee */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xef */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf0 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf1 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf2 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf3 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf4 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf5 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf6 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf7 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|B_C|  0|  0|  0, /* 0xf8 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xf9 */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xfa */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xfb */
B_0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xfc */
                                                              0, /* 0xfd */
                                                              0, /* 0xfe */
                                                              0, /* 0xff */
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_toupper_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_tolower_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_gr_toupper_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_gr_tolower_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_ru_toupper_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78, 127,
 79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,
 95,  96, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_ru_tolower_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128,
129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
145,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_ro_toupper_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;
K_EXTERN unsigned char sj_ro_tolower_table[256]
#ifdef K_INIT
= {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  64,  65,  66,  67,  68,  69,
 70,  71,  72,  73,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
 96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
}
#endif /* K_INIT */
;


#ifdef _KANJI_C_
/* For EUC CODE */
#define euc_kana (0x8e)
#define is_euc_kana(c) (((unsigned char) (c)) == euc_kana)
#define is_euc(c)		IS_KCTYPE2(c, KC_EUC_JP)

/* For EUC3 CODE */
#define euc_sup (0x8f)
#define is_euc_sup(c) (((unsigned char ) (c)) == euc_sup)

#define is_jis_g1_udc(c)	IS_KCTYPE2(c, KC_JIS_G1_UDC)
#define is_jis_g3_udc(c)	IS_KCTYPE2(c, KC_JIS_G3_UDC)
#define is_sjis_g1_udc(c)	IS_KCTYPE2(c, KC_SJIS_G1_UDC)
#define is_sjis_g3_udc(c)	IS_KCTYPE2(c, KC_SJIS_G3_UDC)
#define is_sjis_ibm(c)		IS_KCTYPE2(c, KC_SJIS_IBM)
#define is_sjis_nec(c)		IS_KCTYPE2(c, KC_SJIS_NEC)

/* For JIS CODE */
/* default jis third shift code, use for output */
#ifndef JIS_KSO
#define JIS_KSO 'B'
#endif
#ifndef JIS_KSI
#define JIS_KSI 'J'
#endif
/* in: \E$B or \E$@ */
/* out: \E(J or \E(B or \E(H */
#define jis_esc (0x1b)
#define jis_so (0x0e)
#define jis_so1 ('$')
#define jis_so2 ('B')
#define jis_si (0x0f)
#define jis_si1 ('(')
#define jis_si2 ('J')
#define is_esc(c) (((unsigned char) (c)) == jis_esc)
#define is_so1(c) (((unsigned char) (c)) == jis_so1)
#define is_so2(c)		IS_KCTYPE2(c, KC_JIS_SO2)
#define is_si1(c) (((unsigned char) (c)) == jis_si1)
#define is_si2(c)		IS_KCTYPE2(c, KC_JIS_SI2)
#define is_so(c) (((unsigned char) (c)) == jis_so)
#define is_si(c) (((unsigned char) (c)) == jis_si)
#define junet_kana1 ('(')
#define junet_kana2 ('I')
#define is_juk1(c) (((unsigned char) (c)) == junet_kana1)
#define is_juk2(c) (((unsigned char) (c)) == junet_kana2)

#define _KJ_ROMAN (0)
#define _KJ_KANJI (1)
#define _KJ_KANA (2)

/* For HEX */
#define HEXTAG ':'
#define hex2bin(c)		hex2bin_table[(unsigned char)(c)]
#define bin2hex(c)		bin2hex_table[(unsigned char)(c)]
#define is_hex(s)		(((s)[0] == hex_tag) \
				&& IS_HCTYPE((s)[1], HC_HEX) \
				&& IS_HCTYPE((s)[2], HC_HEX))
#define is_cap(s)		(((s)[0] == hex_tag) \
				&& IS_HCTYPE((s)[1], HC_CAP) \
				&& IS_HCTYPE((s)[2], HC_HEX))

/* For Hangul (Korean - code page 949). */
#define is_hangul(c)		IS_KCTYPE2(c, KC_HANGUL)

/* For traditional Chinese (known as Big5 encoding - code page 950). */
#define is_big5_c1(c)		IS_KCTYPE2(c, KC_BIG5_C1)

/* For simplified Chinese (code page - 936). */
#define is_simpch_c1(c)		IS_KCTYPE2(c, KC_SIMPCH_C1)

#else /* not _KANJI_C_ */

/*
 * The following is needed for AIX systems that have
 * their own #defines for strchr, strrchr, strstr
 * and strtok.
 */

#ifdef strchr
#undef strchr
#endif /* strchr */

#ifdef strrchr
#undef strrchr
#endif /* strrchr */

#ifdef strstr
#undef strstr
#endif /* strstr */

#ifdef strtok
#undef strtok
#endif /* strtok */

/* Ensure we use our definitions in all other files than kanji.c. */

/* Function pointers we will replace. */
extern char *(*multibyte_strchr)(const char *s, int c);
extern char *(*multibyte_strrchr)(const char *s, int c);
extern char *(*multibyte_strstr)(const char *s1, const char *s2);
extern char *(*multibyte_strtok)(char *s1, const char *s2);
extern char *(*_dos_to_unix)(char *dst, const char *src);
extern char *(*_unix_to_dos)(char *dst, const char *src);
extern BOOL (*is_multibyte_char)(char c);
extern int (*_skip_multibyte_char)(char c);

extern int regularize_sjis(int);

#define strchr(s1, c) ((*multibyte_strchr)((s1), (c)))
#define strrchr(s1, c) ((*multibyte_strrchr)((s1), (c)))
#define strstr(s1, s2) ((*multibyte_strstr)((s1), (s2)))
#define strtok(s1, s2) ((*multibyte_strtok)((s1), (s2)))
#define dos_to_unix(x,y) ((*_dos_to_unix)((x), (y)))
#define unix_to_dos(x,y) ((*_unix_to_dos)((x), (y)))
#define skip_multibyte_char(c) ((*_skip_multibyte_char)((c)))

#endif /* _KANJI_C_ */

#define UNKNOWN_CODE (-1)
#define SJIS_CODE (0)
#define EUC_CODE (1)
#define JIS7_CODE (2)
#define JIS8_CODE (3)
#define JUNET_CODE (4)
#define HEX_CODE (5)
#define CAP_CODE (6)
#define DOSV_CODE SJIS_CODE
#define EUC3_CODE (7)
#define UTF8_CODE (8)

#ifdef _KANJI_C_

/* For conversion */

#define EXTSJISC(c)   (0xf0 <= ((unsigned char)(c)) \
		       && ((unsigned char)(c) <= 0xfc))
#define GETAHI (0x81)
#define GETALO (0xac)

typedef struct _sjis_conv_t {
	int start;
	int end;
	int rstart;
} sjis_conv_t;

/*  When Converting to EUC and JIS,  there is no room for
 *  these SJIS codes whose hi byte is larger than 0xf0.
 *  
 *  So we must drop or convert it to harmless code.
 *  This is not standard way, so it is ad hoc but practical.
 *  It is also thought of backward and future compatibility.
 * 
 *      Miura.
 */

static sjis_conv_t sconv_reg[] = {
{0x8754, 0x875d, 0xfa4a},
{0x8782, 0x8782, 0xfa59},
{0x8784, 0x8784, 0xfa5a},
{0x878a, 0x878a, 0xfa58},
{0x8790, 0x8790, 0x81e0},
{0x8791, 0x8791, 0x81df},
{0x8792, 0x8792, 0x81e7},
{0x8795, 0x8795, 0x81e3},
{0x8796, 0x8796, 0x81db},
{0x8797, 0x8797, 0x81da},
{0x879a, 0x879a, 0x81e6},
{0x879b, 0x879b, 0x81bf},
{0x879c, 0x879c, 0x81be},
{0xed40, 0xed62, 0xfa5c},
{0xed63, 0xed7e, 0xfa80},
{0xed80, 0xede0, 0xfa9c},
{0xede1, 0xedfc, 0xfb40},
{0xee40, 0xee62, 0xfb5c},
{0xee63, 0xee7e, 0xfb80},
{0xee80, 0xeee0, 0xfb9c},
{0xeee1, 0xeeec, 0xfc40},
{0xeeef, 0xeef8, 0xfa40},
{0xeef9, 0xeef9, 0x81ca},
{0xeefa, 0xeefc, 0xfa55},
{0xfa54, 0xfa54, 0x81ca},
{0xfa5b, 0xfa5b, 0x81e6}
};
#define SCONVREGSIZ	(sizeof(sconv_reg) / sizeof(sjis_conv_t))

static sjis_conv_t sconv_jis[] = {
{0x8790, 0x8790, 0x81e0},
{0x8791, 0x8791, 0x81df},
{0x8792, 0x8792, 0x81e7},
{0x8795, 0x8795, 0x81e3},
{0x8796, 0x8796, 0x81db},
{0x8797, 0x8797, 0x81da},
{0x879a, 0x879a, 0x81e6},
{0x879b, 0x879b, 0x81bf},
{0x879c, 0x879c, 0x81be},
{0xeef9, 0xeef9, 0x81ca},
{0xfa40, 0xfa49, 0xeeef},
{0xfa4a, 0xfa53, 0x8754},
{0xfa54, 0xfa54, 0x81ca},
{0xfa55, 0xfa57, 0xeefa},
{0xfa58, 0xfa58, 0x878a},
{0xfa59, 0xfa59, 0x8782},
{0xfa5a, 0xfa5a, 0x8784},
{0xfa5b, 0xfa5b, 0x81e6},
{0xfa5c, 0xfa7e, 0xed40},
{0xfa80, 0xfa9b, 0xed63},
{0xfa9c, 0xfafc, 0xed80},
{0xfb40, 0xfb5b, 0xede1},
{0xfb5c, 0xfb7e, 0xee40},
{0xfb80, 0xfb9b, 0xee63},
{0xfb9c, 0xfbfc, 0xee80},
{0xfc40, 0xfc4b, 0xeee1}
};
#define SCONVJISSIZ	(sizeof(sconv_jis) / sizeof(sjis_conv_t))

static sjis_conv_t sconv_nec2ibm[] = {
{0xed40, 0xed62, 0xfa5c},
{0xed63, 0xed7e, 0xfa80},
{0xed80, 0xede0, 0xfa9c},
{0xede1, 0xedfc, 0xfb40},
{0xee40, 0xee62, 0xfb5c},
{0xee63, 0xee7e, 0xfb80},
{0xee80, 0xeee0, 0xfb9c},
{0xeee1, 0xeeec, 0xfc40},
{0xeeef, 0xeef8, 0xfa40},
{0xeefa, 0xeefc, 0xfa55}
};
#define SCONVNEC2IBMSIZ	(sizeof(sconv_nec2ibm) / sizeof(sjis_conv_t))

/* EUC3BYTE DEFINITIONS */

typedef struct _sjis_euc_map_t {
  int  sjis;
  int  euc;
} sjis_euc_map_t;

static sjis_euc_map_t euc3conv2[] = {
{0x8754 , 0xf3fd},
{0x8755 , 0xf3fe},
{0x8756 , 0xf4a1},
{0x8757 , 0xf4a2},
{0x8758 , 0xf4a3},
{0x8759 , 0xf4a4},
{0x875a , 0xf4a5},
{0x875b , 0xf4a6},
{0x875c , 0xf4a7},
{0x875d , 0xf4a8},
{0x8782 , 0xf4ac},
{0x8784 , 0xf4ad},
{0x878a , 0xf4ab}
};
#define EUC3CONV2TBLSIZ	(sizeof(euc3conv2) / sizeof(sjis_euc_map_t))


/* IBM Kanji to EUC 3byte */
static int euc3conv[] = {
/* 0xfa40 */
0xf3f3, 0xf3f4, 0xf3f5, 0xf3f6, 0xf3f7, 0xf3f8, 0xf3f9, 0xf3fa, 0xf3fb, 0xf3fc, 0xf3fd, 0xf3fe, 0xf4a1, 0xf4a2, 0xf4a3, 0xf4a4,
/* 0xfa50 */
0xf4a5, 0xf4a6, 0xf4a7, 0xf4a8, 0, 0xa2c3, 0xf4a9, 0xf4aa, 0xf4ab, 0xf4ac, 0xf4ad, 0, 0xd4e3, 0xdcdf, 0xe4e9, 0xe3f8,
/* 0xfa60 */
0xd9a1, 0xb1bb, 0xf4ae, 0xc2ad, 0xc3fc, 0xe4d0, 0xc2bf, 0xbcf4, 0xb0a9, 0xb0c8, 0xf4af, 0xb0d2, 0xb0d4, 0xb0e3, 0xb0ee, 0xb1a7,
/* 0xfa70 */
0xb1a3, 0xb1ac, 0xb1a9, 0xb1be, 0xb1df, 0xb1d8, 0xb1c8, 0xb1d7, 0xb1e3, 0xb1f4, 0xb1e1, 0xb2a3, 0xf4b0, 0xb2bb, 0xb2e6,
/* 0xfa80 */
0xb2ed, 0xb2f5, 0xb2fc, 0xf4b1, 0xb3b5, 0xb3d8, 0xb3db, 0xb3e5, 0xb3ee, 0xb3fb, 0xf4b2, 0xf4b3, 0xb4c0, 0xb4c7, 0xb4d0, 0xb4de,
/* 0xfa90 */
0xf4b4, 0xb5aa, 0xf4b5, 0xb5af, 0xb5c4, 0xb5e8, 0xf4b6, 0xb7c2, 0xb7e4, 0xb7e8, 0xb7e7, 0xf4b7, 0xf4b8, 0xf4b9, 0xb8ce, 0xb8e1,
/* 0xfaa0 */
0xb8f5, 0xb8f7, 0xb8f8, 0xb8fc, 0xb9af, 0xb9b7, 0xbabe, 0xbadb, 0xcdaa, 0xbae1, 0xf4ba, 0xbaeb, 0xbbb3, 0xbbb8, 0xf4bb, 0xbbca,
/* 0xfab0 */
0xf4bc, 0xf4bd, 0xbbd0, 0xbbde, 0xbbf4, 0xbbf5, 0xbbf9, 0xbce4, 0xbced, 0xbcfe, 0xf4be, 0xbdc2, 0xbde7, 0xf4bf, 0xbdf0, 0xbeb0,
/* 0xfac0 */
0xbeac, 0xf4c0, 0xbeb3, 0xbebd, 0xbecd, 0xbec9, 0xbee4, 0xbfa8, 0xbfc9, 0xc0c4, 0xc0e4, 0xc0f4, 0xc1a6, 0xf4c1, 0xc1f5, 0xc1fc,
/* 0xfad0 */
0xf4c2, 0xc1f8, 0xc2ab, 0xc2a1, 0xc2a5, 0xf4c3, 0xc2b8, 0xc2ba, 0xf4c4, 0xc2c4, 0xc2d2, 0xc2d7, 0xc2db, 0xc2de, 0xc2ed, 0xc2f0,
/* 0xfae0 */
0xf4c5, 0xc3a1, 0xc3b5, 0xc3c9, 0xc3b9, 0xf4c6, 0xc3d8, 0xc3fe, 0xf4c7, 0xc4cc, 0xf4c8, 0xc4d9, 0xc4ea, 0xc4fd, 0xf4c9, 0xc5a7,
/* 0xfaf0 */
 0xc5b5, 0xc5b6, 0xf4ca, 0xc5d5, 0xc6b8, 0xc6d7, 0xc6e0, 0xc6ea, 0xc6e3, 0xc7a1, 0xc7ab, 0xc7c7, 0xc7c3,
/* 0xfb40 */
 0xc7cb, 0xc7cf, 0xc7d9, 0xf4cb, 0xf4cc, 0xc7e6, 0xc7ee, 0xc7fc, 0xc7eb, 0xc7f0, 0xc8b1, 0xc8e5, 0xc8f8, 0xc9a6, 0xc9ab, 0xc9ad,
/* 0xfb50 */
 0xf4cd, 0xc9ca, 0xc9d3, 0xc9e9, 0xc9e3, 0xc9fc, 0xc9f4, 0xc9f5, 0xf4ce, 0xcab3, 0xcabd, 0xcaef, 0xcaf1, 0xcbae, 0xf4cf, 0xcbca,
/* 0xfb60 */
 0xcbe6, 0xcbea, 0xcbf0, 0xcbf4, 0xcbee, 0xcca5, 0xcbf9, 0xccab, 0xccae, 0xccad, 0xccb2, 0xccc2, 0xccd0, 0xccd9, 0xf4d0, 0xcdbb,
/* 0xfb70 */
0xf4d1, 0xcebb, 0xf4d2, 0xceba, 0xcec3, 0xf4d3, 0xcef2, 0xb3dd, 0xcfd5, 0xcfe2, 0xcfe9, 0xcfed, 0xf4d4, 0xf4d5, 0xf4d6,
/* 0xfb80 */
 0xf4d7, 0xd0e5, 0xf4d8, 0xd0e9, 0xd1e8, 0xf4d9, 0xf4da, 0xd1ec, 0xd2bb, 0xf4db, 0xd3e1, 0xd3e8, 0xd4a7, 0xf4dc, 0xf4dd, 0xd4d4,
/* 0xfb90 */
 0xd4f2, 0xd5ae, 0xf4de, 0xd7de, 0xf4df, 0xd8a2, 0xd8b7, 0xd8c1, 0xd8d1, 0xd8f4, 0xd9c6, 0xd9c8, 0xd9d1, 0xf4e0, 0xf4e1, 0xf4e2,
/* 0xfba0 */
 0xf4e3, 0xf4e4, 0xdcd3, 0xddc8, 0xddd4, 0xddea, 0xddfa, 0xdea4, 0xdeb0, 0xf4e5, 0xdeb5, 0xdecb, 0xf4e6, 0xdfb9, 0xf4e7, 0xdfc3,
/* 0xfbb0 */
 0xf4e8, 0xf4e9, 0xe0d9, 0xf4ea, 0xf4eb, 0xe1e2, 0xf4ec, 0xf4ed, 0xf4ee, 0xe2c7, 0xe3a8, 0xe3a6, 0xe3a9, 0xe3af, 0xe3b0, 0xe3aa,
/* 0xfbc0 */
 0xe3ab, 0xe3bc, 0xe3c1, 0xe3bf, 0xe3d5, 0xe3d8, 0xe3d6, 0xe3df, 0xe3e3, 0xe3e1, 0xe3d4, 0xe3e9, 0xe4a6, 0xe3f1, 0xe3f2, 0xe4cb,
/* 0xfbd0 */
 0xe4c1, 0xe4c3, 0xe4be, 0xf4ef, 0xe4c0, 0xe4c7, 0xe4bf, 0xe4e0, 0xe4de, 0xe4d1, 0xf4f0, 0xe4dc, 0xe4d2, 0xe4db, 0xe4d4, 0xe4fa,
/* 0xfbe0 */
 0xe4ef, 0xe5b3, 0xe5bf, 0xe5c9, 0xe5d0, 0xe5e2, 0xe5ea, 0xe5eb, 0xf4f1, 0xf4f2, 0xf4f3, 0xe6e8, 0xe6ef, 0xe7ac, 0xf4f4, 0xe7ae,
/* 0xfbf0 */
 0xf4f5, 0xe7b1, 0xf4f6, 0xe7b2, 0xe8b1, 0xe8b6, 0xf4f7, 0xf4f8, 0xe8dd, 0xf4f9, 0xf4fa, 0xe9d1, 0xf4fb,
/* 0xfc40 */
 0xe9ed, 0xeacd, 0xf4fc, 0xeadb, 0xeae6, 0xeaea, 0xeba5, 0xebfb, 0xebfa, 0xf4fd, 0xecd6, 0xf4fe
};

#define EUC3CONVTBLSIZ	(sizeof(euc3conv) / sizeof(int))

/* EUC3byte to SJIS Code */

typedef struct _sjis_euc_revmap_t {
  int  euc;
  int  sjis;
} sjis_euc_revmap_t;

static sjis_euc_revmap_t euc3rev[] = {
{0xa2c3, 0xfa55},
{0xb0a9, 0xfa68},
{0xb0c8, 0xfa69},
{0xb0d2, 0xfa6b},
{0xb0d4, 0xfa6c},
{0xb0e3, 0xfa6d},
{0xb0ee, 0xfa6e},
{0xb1a3, 0xfa70},
{0xb1a7, 0xfa6f},
{0xb1a9, 0xfa72},
{0xb1ac, 0xfa71},
{0xb1bb, 0xfa61},
{0xb1be, 0xfa73},
{0xb1c8, 0xfa76},
{0xb1d7, 0xfa77},
{0xb1d8, 0xfa75},
{0xb1df, 0xfa74},
{0xb1e1, 0xfa7a},
{0xb1e3, 0xfa78},
{0xb1f4, 0xfa79},
{0xb2a3, 0xfa7b},
{0xb2bb, 0xfa7d},
{0xb2e6, 0xfa7e},
{0xb2ed, 0xfa80},
{0xb2f5, 0xfa81},
{0xb2fc, 0xfa82},
{0xb3b5, 0xfa84},
{0xb3d8, 0xfa85},
{0xb3db, 0xfa86},
{0xb3dd, 0xfb77},
{0xb3e5, 0xfa87},
{0xb3ee, 0xfa88},
{0xb3fb, 0xfa89},
{0xb4c0, 0xfa8c},
{0xb4c7, 0xfa8d},
{0xb4d0, 0xfa8e},
{0xb4de, 0xfa8f},
{0xb5aa, 0xfa91},
{0xb5af, 0xfa93},
{0xb5c4, 0xfa94},
{0xb5e8, 0xfa95},
{0xb7c2, 0xfa97},
{0xb7e4, 0xfa98},
{0xb7e7, 0xfa9a},
{0xb7e8, 0xfa99},
{0xb8ce, 0xfa9e},
{0xb8e1, 0xfa9f},
{0xb8f5, 0xfaa0},
{0xb8f7, 0xfaa1},
{0xb8f8, 0xfaa2},
{0xb8fc, 0xfaa3},
{0xb9af, 0xfaa4},
{0xb9b7, 0xfaa5},
{0xbabe, 0xfaa6},
{0xbadb, 0xfaa7},
{0xbae1, 0xfaa9},
{0xbaeb, 0xfaab},
{0xbbb3, 0xfaac},
{0xbbb8, 0xfaad},
{0xbbca, 0xfaaf},
{0xbbd0, 0xfab2},
{0xbbde, 0xfab3},
{0xbbf4, 0xfab4},
{0xbbf5, 0xfab5},
{0xbbf9, 0xfab6},
{0xbce4, 0xfab7},
{0xbced, 0xfab8},
{0xbcf4, 0xfa67},
{0xbcfe, 0xfab9},
{0xbdc2, 0xfabb},
{0xbde7, 0xfabc},
{0xbdf0, 0xfabe},
{0xbeac, 0xfac0},
{0xbeb0, 0xfabf},
{0xbeb3, 0xfac2},
{0xbebd, 0xfac3},
{0xbec9, 0xfac5},
{0xbecd, 0xfac4},
{0xbee4, 0xfac6},
{0xbfa8, 0xfac7},
{0xbfc9, 0xfac8},
{0xc0c4, 0xfac9},
{0xc0e4, 0xfaca},
{0xc0f4, 0xfacb},
{0xc1a6, 0xfacc},
{0xc1f5, 0xface},
{0xc1f8, 0xfad1},
{0xc1fc, 0xfacf},
{0xc2a1, 0xfad3},
{0xc2a5, 0xfad4},
{0xc2ab, 0xfad2},
{0xc2ad, 0xfa63},
{0xc2b8, 0xfad6},
{0xc2ba, 0xfad7},
{0xc2bf, 0xfa66},
{0xc2c4, 0xfad9},
{0xc2d2, 0xfada},
{0xc2d7, 0xfadb},
{0xc2db, 0xfadc},
{0xc2de, 0xfadd},
{0xc2ed, 0xfade},
{0xc2f0, 0xfadf},
{0xc3a1, 0xfae1},
{0xc3b5, 0xfae2},
{0xc3b9, 0xfae4},
{0xc3c9, 0xfae3},
{0xc3d8, 0xfae6},
{0xc3fc, 0xfa64},
{0xc3fe, 0xfae7},
{0xc4cc, 0xfae9},
{0xc4d9, 0xfaeb},
{0xc4ea, 0xfaec},
{0xc4fd, 0xfaed},
{0xc5a7, 0xfaef},
{0xc5b5, 0xfaf0},
{0xc5b6, 0xfaf1},
{0xc5d5, 0xfaf3},
{0xc6b8, 0xfaf4},
{0xc6d7, 0xfaf5},
{0xc6e0, 0xfaf6},
{0xc6e3, 0xfaf8},
{0xc6ea, 0xfaf7},
{0xc7a1, 0xfaf9},
{0xc7ab, 0xfafa},
{0xc7c3, 0xfafc},
{0xc7c7, 0xfafb},
{0xc7cb, 0xfb40},
{0xc7cf, 0xfb41},
{0xc7d9, 0xfb42},
{0xc7e6, 0xfb45},
{0xc7eb, 0xfb48},
{0xc7ee, 0xfb46},
{0xc7f0, 0xfb49},
{0xc7fc, 0xfb47},
{0xc8b1, 0xfb4a},
{0xc8e5, 0xfb4b},
{0xc8f8, 0xfb4c},
{0xc9a6, 0xfb4d},
{0xc9ab, 0xfb4e},
{0xc9ad, 0xfb4f},
{0xc9ca, 0xfb51},
{0xc9d3, 0xfb52},
{0xc9e3, 0xfb54},
{0xc9e9, 0xfb53},
{0xc9f4, 0xfb56},
{0xc9f5, 0xfb57},
{0xc9fc, 0xfb55},
{0xcab3, 0xfb59},
{0xcabd, 0xfb5a},
{0xcaef, 0xfb5b},
{0xcaf1, 0xfb5c},
{0xcbae, 0xfb5d},
{0xcbca, 0xfb5f},
{0xcbe6, 0xfb60},
{0xcbea, 0xfb61},
{0xcbee, 0xfb64},
{0xcbf0, 0xfb62},
{0xcbf4, 0xfb63},
{0xcbf9, 0xfb66},
{0xcca5, 0xfb65},
{0xccab, 0xfb67},
{0xccad, 0xfb69},
{0xccae, 0xfb68},
{0xccb2, 0xfb6a},
{0xccc2, 0xfb6b},
{0xccd0, 0xfb6c},
{0xccd9, 0xfb6d},
{0xcdaa, 0xfaa8},
{0xcdbb, 0xfb6f},
{0xceba, 0xfb73},
{0xcebb, 0xfb71},
{0xcec3, 0xfb74},
{0xcef2, 0xfb76},
{0xcfd5, 0xfb78},
{0xcfe2, 0xfb79},
{0xcfe9, 0xfb7a},
{0xcfed, 0xfb7b},
{0xd0e5, 0xfb81},
{0xd0e9, 0xfb83},
{0xd1e8, 0xfb84},
{0xd1ec, 0xfb87},
{0xd2bb, 0xfb88},
{0xd3e1, 0xfb8a},
{0xd3e8, 0xfb8b},
{0xd4a7, 0xfb8c},
{0xd4d4, 0xfb8f},
{0xd4e3, 0xfa5c},
{0xd4f2, 0xfb90},
{0xd5ae, 0xfb91},
{0xd7de, 0xfb93},
{0xd8a2, 0xfb95},
{0xd8b7, 0xfb96},
{0xd8c1, 0xfb97},
{0xd8d1, 0xfb98},
{0xd8f4, 0xfb99},
{0xd9a1, 0xfa60},
{0xd9c6, 0xfb9a},
{0xd9c8, 0xfb9b},
{0xd9d1, 0xfb9c},
{0xdcd3, 0xfba2},
{0xdcdf, 0xfa5d},
{0xddc8, 0xfba3},
{0xddd4, 0xfba4},
{0xddea, 0xfba5},
{0xddfa, 0xfba6},
{0xdea4, 0xfba7},
{0xdeb0, 0xfba8},
{0xdeb5, 0xfbaa},
{0xdecb, 0xfbab},
{0xdfb9, 0xfbad},
{0xdfc3, 0xfbaf},
{0xe0d9, 0xfbb2},
{0xe1e2, 0xfbb5},
{0xe2c7, 0xfbb9},
{0xe3a6, 0xfbbb},
{0xe3a8, 0xfbba},
{0xe3a9, 0xfbbc},
{0xe3aa, 0xfbbf},
{0xe3ab, 0xfbc0},
{0xe3af, 0xfbbd},
{0xe3b0, 0xfbbe},
{0xe3bc, 0xfbc1},
{0xe3bf, 0xfbc3},
{0xe3c1, 0xfbc2},
{0xe3d4, 0xfbca},
{0xe3d5, 0xfbc4},
{0xe3d6, 0xfbc6},
{0xe3d8, 0xfbc5},
{0xe3df, 0xfbc7},
{0xe3e1, 0xfbc9},
{0xe3e3, 0xfbc8},
{0xe3e9, 0xfbcb},
{0xe3f1, 0xfbcd},
{0xe3f2, 0xfbce},
{0xe3f8, 0xfa5f},
{0xe4a6, 0xfbcc},
{0xe4be, 0xfbd2},
{0xe4bf, 0xfbd6},
{0xe4c0, 0xfbd4},
{0xe4c1, 0xfbd0},
{0xe4c3, 0xfbd1},
{0xe4c7, 0xfbd5},
{0xe4cb, 0xfbcf},
{0xe4d0, 0xfa65},
{0xe4d1, 0xfbd9},
{0xe4d2, 0xfbdc},
{0xe4d4, 0xfbde},
{0xe4db, 0xfbdd},
{0xe4dc, 0xfbdb},
{0xe4de, 0xfbd8},
{0xe4e0, 0xfbd7},
{0xe4e9, 0xfa5e},
{0xe4ef, 0xfbe0},
{0xe4fa, 0xfbdf},
{0xe5b3, 0xfbe1},
{0xe5bf, 0xfbe2},
{0xe5c9, 0xfbe3},
{0xe5d0, 0xfbe4},
{0xe5e2, 0xfbe5},
{0xe5ea, 0xfbe6},
{0xe5eb, 0xfbe7},
{0xe6e8, 0xfbeb},
{0xe6ef, 0xfbec},
{0xe7ac, 0xfbed},
{0xe7ae, 0xfbef},
{0xe7b1, 0xfbf1},
{0xe7b2, 0xfbf3},
{0xe8b1, 0xfbf4},
{0xe8b6, 0xfbf5},
{0xe8dd, 0xfbf8},
{0xe9d1, 0xfbfb},
{0xe9ed, 0xfc40},
{0xeacd, 0xfc41},
{0xeadb, 0xfc43},
{0xeae6, 0xfc44},
{0xeaea, 0xfc45},
{0xeba5, 0xfc46},
{0xebfa, 0xfc48},
{0xebfb, 0xfc47},
{0xecd6, 0xfc4a},
{0xf3f3, 0xfa40},
{0xf3f4, 0xfa41},
{0xf3f5, 0xfa42},
{0xf3f6, 0xfa43},
{0xf3f7, 0xfa44},
{0xf3f8, 0xfa45},
{0xf3f9, 0xfa46},
{0xf3fa, 0xfa47},
{0xf3fb, 0xfa48},
{0xf3fc, 0xfa49},
{0xf3fd, 0xfa4a},
{0xf3fe, 0xfa4b},
{0xf4a1, 0xfa4c},
{0xf4a2, 0xfa4d},
{0xf4a3, 0xfa4e},
{0xf4a4, 0xfa4f},
{0xf4a5, 0xfa50},
{0xf4a6, 0xfa51},
{0xf4a7, 0xfa52},
{0xf4a8, 0xfa53},
{0xf4a9, 0xfa56},
{0xf4aa, 0xfa57},
{0xf4ab, 0xfa58},
{0xf4ac, 0xfa59},
{0xf4ad, 0xfa5a},
{0xf4ae, 0xfa62},
{0xf4af, 0xfa6a},
{0xf4b0, 0xfa7c},
{0xf4b1, 0xfa83},
{0xf4b2, 0xfa8a},
{0xf4b3, 0xfa8b},
{0xf4b4, 0xfa90},
{0xf4b5, 0xfa92},
{0xf4b6, 0xfa96},
{0xf4b7, 0xfa9b},
{0xf4b8, 0xfa9c},
{0xf4b9, 0xfa9d},
{0xf4ba, 0xfaaa},
{0xf4bb, 0xfaae},
{0xf4bc, 0xfab0},
{0xf4bd, 0xfab1},
{0xf4be, 0xfaba},
{0xf4bf, 0xfabd},
{0xf4c0, 0xfac1},
{0xf4c1, 0xfacd},
{0xf4c2, 0xfad0},
{0xf4c3, 0xfad5},
{0xf4c4, 0xfad8},
{0xf4c5, 0xfae0},
{0xf4c6, 0xfae5},
{0xf4c7, 0xfae8},
{0xf4c8, 0xfaea},
{0xf4c9, 0xfaee},
{0xf4ca, 0xfaf2},
{0xf4cb, 0xfb43},
{0xf4cc, 0xfb44},
{0xf4cd, 0xfb50},
{0xf4ce, 0xfb58},
{0xf4cf, 0xfb5e},
{0xf4d0, 0xfb6e},
{0xf4d1, 0xfb70},
{0xf4d2, 0xfb72},
{0xf4d3, 0xfb75},
{0xf4d4, 0xfb7c},
{0xf4d5, 0xfb7d},
{0xf4d6, 0xfb7e},
{0xf4d7, 0xfb80},
{0xf4d8, 0xfb82},
{0xf4d9, 0xfb85},
{0xf4da, 0xfb86},
{0xf4db, 0xfb89},
{0xf4dc, 0xfb8d},
{0xf4dd, 0xfb8e},
{0xf4de, 0xfb92},
{0xf4df, 0xfb94},
{0xf4e0, 0xfb9d},
{0xf4e1, 0xfb9e},
{0xf4e2, 0xfb9f},
{0xf4e3, 0xfba0},
{0xf4e4, 0xfba1},
{0xf4e5, 0xfba9},
{0xf4e6, 0xfbac},
{0xf4e7, 0xfbae},
{0xf4e8, 0xfbb0},
{0xf4e9, 0xfbb1},
{0xf4ea, 0xfbb3},
{0xf4eb, 0xfbb4},
{0xf4ec, 0xfbb6},
{0xf4ed, 0xfbb7},
{0xf4ee, 0xfbb8},
{0xf4ef, 0xfbd3},
{0xf4f0, 0xfbda},
{0xf4f1, 0xfbe8},
{0xf4f2, 0xfbe9},
{0xf4f3, 0xfbea},
{0xf4f4, 0xfbee},
{0xf4f5, 0xfbf0},
{0xf4f6, 0xfbf2},
{0xf4f7, 0xfbf6},
{0xf4f8, 0xfbf7},
{0xf4f9, 0xfbf9},
{0xf4fa, 0xfbfa},
{0xf4fb, 0xfbfc},
{0xf4fc, 0xfc42},
{0xf4fd, 0xfc49},
{0xf4fe, 0xfc4b},
};

#define EUC3REVTBLSIZ	(sizeof(euc3rev) / sizeof(sjis_euc_revmap_t))

static unsigned short kctype_table2[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00-0x0f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10-0x1f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x20-0x2f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x30-0x3f */
/*+------------------------------------------------ KC_EUC_JP
 *|   +-------------------------------------------- KC_JIS_SO2
 *|   |   +---------------------------------------- KC_JIS_SI2
 *|   |   |   +------------------------------------ KC_HANGLE
 *|   |   |   |   +-------------------------------- KC_BIG5_C1
 *|   |   |   |   |   +---------------------------- KC_SIMPCH_C1
 *|   |   |   |   |   |   +------------------------ KC_JIS_G1_UDC
 *|   |   |   |   |   |   |   +-------------------- KC_JIS_G3_UDC
 *|   |   |   |   |   |   |   |   +---------------- KC_SJIS_G1_UDC
 *|   |   |   |   |   |   |   |   |   +------------ KC_SJIS_G3_UDC
 *|   |   |   |   |   |   |   |   |   |   +-------- KC_SJIS_IBM
 *|   |   |   |   |   |   |   |   |   |   |   +---- KC_SJIS_NEC
 *|   |   |   |   |   |   |   |   |   |   |   | */
  0|B_1|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x40 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x41 */
  0|B_1|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x42 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x43 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x44 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x45 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x46 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x47 */
  0|  0|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x48 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x49 */
  0|  0|B_2|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x4a */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x4b */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x4c */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x4d */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x4e */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x4f */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x50 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x51 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x52 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x53 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x54 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x55 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x56 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x57 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x58 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x59 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5a */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5b */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5c */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5d */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5e */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x5f */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x60 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x61 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x62 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x63 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x64 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x65 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x66 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x67 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x68 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x69 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6a */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6b */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6c */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6d */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6e */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x6f */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x70 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x71 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x72 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x73 */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x74 */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x75 */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x76 */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x77 */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x78 */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x79 */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x7a */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x7b */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x7c */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x7d */
  0|  0|  0|  0|  0|  0|B_6|B_7|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x7e */
                                                              0, /* 0x7f */
  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x80 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x81 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x82 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x83 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x84 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x85 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x86 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x87 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x88 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x89 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x8a */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x8b */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x8c */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x8d */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x8e */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x8f */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x90 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x91 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x92 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x93 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x94 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x95 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x96 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x97 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x98 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x99 */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9a */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9b */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9c */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9d */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9e */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0x9f */
  0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa0 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa1 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa2 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa3 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa4 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa5 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa6 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa7 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa8 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xa9 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xaa */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xab */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xac */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xad */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xae */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xaf */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb0 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb1 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb2 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb3 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb4 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb5 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb6 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb7 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb8 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xb9 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xba */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbb */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbc */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbd */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbe */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xbf */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc0 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc1 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc2 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc3 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc4 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc5 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc6 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc7 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc8 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xc9 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xca */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcb */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcc */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcd */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xce */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xcf */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd0 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd1 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd2 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd3 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd4 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd5 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd6 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd7 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd8 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xd9 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xda */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdb */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdc */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdd */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xde */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xdf */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe0 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe1 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe2 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe3 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe4 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe5 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe6 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe7 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe8 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xe9 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xea */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xeb */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xec */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0xed */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|B_B|  0|  0|  0|  0, /* 0xee */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xef */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0xf0 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0xf1 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0xf2 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0xf3 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|B_8|  0|  0|  0|  0|  0|  0|  0, /* 0xf4 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0xf5 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0xf6 */
B_0|  0|  0|B_3|B_4|B_5|  0|  0|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0xf7 */
B_0|  0|  0|B_3|B_4|  0|  0|  0|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0xf8 */
B_0|  0|  0|B_3|B_4|  0|  0|  0|  0|B_9|  0|  0|  0|  0|  0|  0, /* 0xf9 */
B_0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0xfa */
B_0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0xfb */
B_0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|B_A|  0|  0|  0|  0|  0, /* 0xfc */
B_0|  0|  0|B_3|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xfd */
B_0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0|  0, /* 0xfe */
                                                              0, /* 0xff */
};

/* For JIS */
static unsigned char sjis2jis_table1[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x20 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x30 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x40 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x50 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x60 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x70 */
   0, 0x21, 0x23, 0x25, 0x27, 0x29, 0x2b, 0x2d, /* 0x80 */
0x2f, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3b, 0x3d,
0x3f, 0x41, 0x43, 0x45, 0x47, 0x49, 0x4b, 0x4d, /* 0x90 */
0x4f, 0x51, 0x53, 0x55, 0x57, 0x59, 0x5b, 0x5d,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xa0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xb0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xc0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xd0 */
0x5f, 0x61, 0x63, 0x65, 0x67, 0x69, 0x6b, 0x6d, /* 0xe0 */
0x6f, 0x71, 0x73, 0x75, 0x77, 0x79, 0x7b, 0x7d,
0x7f, 0x81, 0x83, 0x85, 0x87, 0x89, 0x8b, 0x8d, /* 0xf0 */
0x8f, 0x91, 0x93, 0x95, 0x97,    0,    0,    0
};
static unsigned short sjis2jis_table2[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x20 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x30 */
0x021, 0x022, 0x023, 0x024, 0x025, 0x026, 0x027, 0x028, /* 0x40 */
0x029, 0x02a, 0x02b, 0x02c, 0x02d, 0x02e, 0x02f, 0x030,
0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037, 0x038, /* 0x50 */
0x039, 0x03a, 0x03b, 0x03c, 0x03d, 0x03e, 0x03f, 0x040,
0x041, 0x042, 0x043, 0x044, 0x045, 0x046, 0x047, 0x048, /* 0x60 */
0x049, 0x04a, 0x04b, 0x04c, 0x04d, 0x04e, 0x04f, 0x050,
0x051, 0x052, 0x053, 0x054, 0x055, 0x056, 0x057, 0x058, /* 0x70 */
0x059, 0x05a, 0x05b, 0x05c, 0x05d, 0x05e, 0x05f, 0x060,
0x060, 0x061, 0x062, 0x063, 0x064, 0x065, 0x066, 0x067, /* 0x80 */
0x068, 0x069, 0x06a, 0x06b, 0x06c, 0x06d, 0x06e, 0x06f,
0x070, 0x071, 0x072, 0x073, 0x074, 0x075, 0x076, 0x077, /* 0x90 */
0x078, 0x079, 0x07a, 0x07b, 0x07c, 0x07d, 0x07e, 0x121,
0x122, 0x123, 0x124, 0x125, 0x126, 0x127, 0x128, 0x129, /* 0xa0 */
0x12a, 0x12b, 0x12c, 0x12d, 0x12e, 0x12f, 0x130, 0x131,
0x132, 0x133, 0x134, 0x135, 0x136, 0x137, 0x138, 0x139, /* 0xb0 */
0x13a, 0x13b, 0x13c, 0x13d, 0x13e, 0x13f, 0x140, 0x141,
0x142, 0x143, 0x144, 0x145, 0x146, 0x147, 0x148, 0x149, /* 0xc0 */
0x14a, 0x14b, 0x14c, 0x14d, 0x14e, 0x14f, 0x150, 0x151,
0x152, 0x153, 0x154, 0x155, 0x156, 0x157, 0x158, 0x159, /* 0xd0 */
0x15a, 0x15b, 0x15c, 0x15d, 0x15e, 0x15f, 0x160, 0x161,
0x162, 0x163, 0x164, 0x165, 0x166, 0x167, 0x168, 0x169, /* 0xe0 */
0x16a, 0x16b, 0x16c, 0x16d, 0x16e, 0x16f, 0x170, 0x171,
0x172, 0x173, 0x174, 0x175, 0x176, 0x177, 0x178, 0x179, /* 0xf0 */
0x17a, 0x17b, 0x17c, 0x17d, 0x17e,    0,    0,    0
};
static unsigned char jis2sjis_table1[128] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10 */
   0, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, /* 0x20 */
0x84, 0x85, 0x85, 0x86, 0x86, 0x87, 0x87, 0x88,
0x88, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8b, 0x8c, /* 0x30 */
0x8c, 0x8d, 0x8d, 0x8e, 0x8e, 0x8f, 0x8f, 0x90,
0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x93, 0x94, /* 0x40 */
0x94, 0x95, 0x95, 0x96, 0x96, 0x97, 0x97, 0x98,
0x98, 0x99, 0x99, 0x9a, 0x9a, 0x9b, 0x9b, 0x9c, /* 0x50 */
0x9c, 0x9d, 0x9d, 0x9e, 0x9e, 0x9f, 0x9f, 0xe0,
0xe0, 0xe1, 0xe1, 0xe2, 0xe2, 0xe3, 0xe3, 0xe4, /* 0x60 */
0xe4, 0xe5, 0xe5, 0xe6, 0xe6, 0xe7, 0xe7, 0xe8,
0xe8, 0xe9, 0xe9, 0xea, 0xea, 0xeb, 0xeb, 0xec, /* 0x70 */
0xec, 0xed, 0xed, 0xee, 0xee, 0xef, 0xef,    0
};
static unsigned char jis2sjis_table2[128] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10 */
   0, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 0x20 */
0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e,
0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, /* 0x30 */
0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e,
0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, /* 0x40 */
0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e,
0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, /* 0x50 */
0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e,
0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, /* 0x60 */
0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, /* 0x70 */
0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e,    0
};

static unsigned char hctype_table[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x20 */
/*+-------- HC_HEX
 *|   +---- HC_CAP
 *|   | */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x30 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x31 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x32 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x33 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x34 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x35 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x36 */
B_0|  0|  0|  0|  0|  0|  0|  0, /* 0x37 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x38 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x39 */
                              0, /* 0x3a */
                              0, /* 0x3b */
                              0, /* 0x3c */
                              0, /* 0x3d */
                              0, /* 0x3e */
                              0, /* 0x3f */
                              0, /* 0x40 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x41 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x42 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x43 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x44 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x45 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x46 */
                              0, /* 0x47 */
                              0, /* 0x48 */
                              0, /* 0x49 */
                              0, /* 0x4a */
                              0, /* 0x4b */
                              0, /* 0x4c */
                              0, /* 0x4d */
                              0, /* 0x4e */
                              0, /* 0x4f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x50 */
                              0, /* 0x60 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x61 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x62 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x63 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x64 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x65 */
B_0|B_1|  0|  0|  0|  0|  0|  0, /* 0x66 */
                              0, /* 0x67 */
                              0, /* 0x68 */
                              0, /* 0x69 */
                              0, /* 0x6a */
                              0, /* 0x6b */
                              0, /* 0x6c */
                              0, /* 0x6d */
                              0, /* 0x6e */
                              0, /* 0x6f */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x70 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x80 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x90 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xa0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xb0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xc0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xd0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xe0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0  /* 0xf0 */
};
static unsigned char hex2bin_table[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x00 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x10 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x20 */
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, /* 0x30 */
0000, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0000, /* 0x40 */
0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x50 */
0000, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0000, /* 0x60 */
0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x70 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x80 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0x90 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xa0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xb0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xc0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xd0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* 0xe0 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0  /* 0xf0 */
};
static unsigned char bin2hex_table[256] = "0123456789abcdef";

#endif /* _KANJI_C_ */
#endif /* _KANJI_H_ */
