/* -*- c -*-
 *
 * Author:      James A. Brister <brister@vix.com> -- berkeley-unix --
 * Start Date:  Sun, 28 Jan 1996 18:37:49 +1100
 * Project:     INN -- innfeed
 * File:        msgs.h
 * RCSId:       $Id: msgs.h,v 1.11 1996/04/13 02:51:33 brister Exp $
 *
 * Copyright:   Copyright (c) 1996 by Internet Software Consortium
 *
 *              Permission to use, copy, modify, and distribute this
 *              software for any purpose with or without fee is hereby
 *              granted, provided that the above copyright notice and this
 *              permission notice appear in all copies.
 *
 *              THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE
 *              CONSORTIUM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *              SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *              MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET
 *              SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
 *              INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *              WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *              WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 *              TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
 *              USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Description: 
 * 
 */

#if ! defined ( msgs_h__ )
#define msgs_h__

/* Messages used in connection.c */

#define DELETE_LOCKED_CXN       "%s:%d trying to delete locked connection"
#define ARTICLE_FILE_INVALID    "%s:%d article (%s) file no longer valid: %s"
#define ARTICLE_TIMEOUT_MSG     "%s:%d tearing down idle connection"
#define ARTICLE_TIMEOUT_W_Q_MSG "%s:%d idle connection that still has articles"

#define BAD_MODE_RESPONSE       "%s:%d malformed response to MODE STREAM: %s"
#define BANNER_READ_FAILED      "%s:%d banner read failed from remote: %m"
#define COMMAND_WRITE_FAILED    "%s:%d failed to write command to remote: %m"
#define CONNECT_ERROR           "%s:%d connect: %m"
#define CONNECTED               "%s:%d connected"
#define CXN_BUFFER_EXPAND_ERROR "%s:%d error expanding input buffer"
#define CXN_PERIODIC_CLOSE      "%s:%d periodic close"
#define CXN_DROPPING            "%s:%d remote returned unexpected response 205"
#define CXN_CLOSED              "%s:%d closed"
#define FCNTL_ERROR             "%s:%d can't set socket non-blocking: %m"
#define FILE_MISSING            "%s:%d file for %s (%s) no longer exists"
#define HOST_RESOLV_ERROR       "%s:%d can't resolve hostname: %s: %s"
#define IHAVE_WRITE_FAILED      "%s:%d failed to write IHAVE article body to remote: %m"
#define INVALID_MSGID           "%s:%d received an invalid message-id (%s) in reponse code %d"
#define INVALID_RESP_FORMAT     "%s:%d badly formatted reponse: %s"
#define MAX_ARTTOUT_BIG         "%s:%d max article timeout value too big: %d"
#define MAX_CHECK_BIG           "%s:%d max check value too big: %d"
#define MAX_RESPTOUT_BIG        "%s:%d response timeout value to big: %d"
#define MODE_STREAM_FAILED	"%s:%d couldn't write MODE STREAM command: %s"
#define NOCR_MSG                "%s:%d remote not giving out CR characters"
#define NOMSGID                 "%s:%d no message id in reponse code %d: %s"
#define PREPARE_READ_FAILED     "%s:%d prepare read failed"
#define PREPARE_WRITE_FAILED    "%s:%d prepare write failed"
#define QUIT_WHILE_WRITING      "%s:%d trying to QUIT while write pending"
#define QUIT_WRITE_FAILED       "%s:%d failed to write QUIT command: %m"
#define RESPONSE_BAD_FORMAT     "%s:%d badly formatted response: %s"
#define RESPONSE_READ_FAILED    "%s:%d failed to read response from remote: %m"
#define RESPONSE_TIMEOUT        "%s:%d tearing down non-responsive connection"
#define SOCKET_CREATE_ERROR     "%s:%d can't get a socket: %m"
#define STREAMING_MODE_SWITCH   "%s:%d switching to TAKETHIS-only mode"
#define STREAMING_MODE_UNDO     "%s:%d dropping out of TAKETHIS-only mode"
#define UNKNOWN_MODE_RESPONSE   "%s:%d unknown response to MODE STREAM: %s"
#define UNKNOWN_RESPONSE        "%s:%d unknown response code: %d: %s"
#define CXN_BLOCKED             "%s:%d remote cannot accept articles: %s"
#define CXN_REF_ARTICLE         "%s:%d new connection refused article"
#define STATS_MSG               "%s:%d %s %ld seconds offered %d accepted %d refused %d rejected %d"
#define GETSOCKOPT_FAILED       "%s:%d getsockopt: %m"
#define CONNECTION_FAILURE      "%s:%d connect: %m"
#define IO_FAILED               "%s:%d i/o failed: %m"
#define UNKNOWN_BANNER          "%s:%s %d: %s"



  /* messages used in hosts.c */

#define ARTICLE_MISSING         "%s article (%s) file no longer valid: %s"
#define HOST_STATS_MSG          "%s %s seconds %ld offered %d accepted %d refused %d rejected %d missing %d spooled %d"
#define HOST_SPOOL_STATS        "%s %s seconds %ld spooled %d"
#define REMOTE_BLOCKED          "%s remote cannot accept articles: %s"
#define CHANGED_REMOTE_BLOCKED  "%s now says it can't accept articles: %s"
#define SPOOLING                "%s no active connections. Spooling."
#define BACKED_UP               "%s getting backed up (%d connections)"
#define UNBACKED_UP             "%s backlog decreasing"
#define REMOTE_DOES_STREAMING   "%s remote supports MODE STREAM"
#define REMOTE_NO_STREAMING     "%s remote does not support MODE STREAM"
#define BACKLOG_TO_TAPE         "%s spooling some backlog."
#define SPOOL_DEFERRED          "%s spooling deferred articles"
#define TOSSING_ARTICLES        "%s discarding articles"
#define STREAMING_CHANGE        "%s running in STREAMING and non-STREAMING mode both at once."
#define NO_POST_PERMISSION      "%s says no permission to send articles (201)."
#define CHANGED_POST_PERMISSION "%s now says we can't post (201)."


/* messages used in innlistener.c */

#define INN_GONE                "article input source (innd) is gone. Exiting"
#define INN_IO_ERROR            "error on read from input source: %m"
#define INN_BAD_CMD             "malformed inn input command: %s"
#define TOO_MANY_HOSTS          "too may hosts. (max is %d)"
#define DYNAMIC_PEER            "adding peer dynamically (%s)"


/* messages used in commander.c */
#define CMDR_PREP_RD_FAILED     "commander connection listen failed"
#define NO_CONNECT              "Commander connections from other hosts disallowed"
#define COMMANDER_CONNECT       "commander connection from %s"


/* endpoint.c */
#define BAD_SELECT              "select failed: %d %m"
#define GETSOCKOPT_FAILURE      "exception: getsockopt (%d): %m"
#define EXCEPTION_NOTICE        "exception: file descriptor %d: %m"
#define UNKNOWN_EXCEPTION       "exception: file descriptor %d. Unknown error."


#define CXN_RESTABISH           "%s connection restablished"


#define BAD_ART_READ            "Error reading article from file %s: %m"
#define BAD_ART_READ_SIZE       "Error reading article from file %s: (%d/%d)"


#define TAPE_OPEN_FAILED        "failed to open tape file (%s) %s: %m"
#define STARTING_PROGRAM        "starting %s at %s"
#define STOPPING_PROGRAM        "finishing at %s"

#define UNKNOWN_PEER            "unknown peer name: %s"

#define NO_DEFAULT              "no default entry in config file."


/* article.c */
#define NO_ARTICLE              "Article file no longer exists: %s: %s"
#define OPEN_FAILURE            "open (%s): %m"
#define FSTAT_FAILURE           "fstat (%s): %m"
#define REGFILE_FAILURE         "file %s not a regular file"
#define PREPARED_NEWLINES       "newline to file size ratio: %0.2f (%d/%d)"
#define PREPARE_FAILED          "failed to prepare buffer for NNTP"
#define ACTIVE_ARTICLES         "articles active %d bytes %d"
#define ARTICLE_ALLOCS          "articles total %d bytes %d"
#define MAX_BYTES_LIMIT         "exceeding maximum article byte limit: %d (max), %d (cur)"

/* main.c */
#define NO_HOST			"Cannot setup host peer %s"
#define NOSUCH_CONFIG           "No such config file: %s"
#define NOT_A_DIR               "Not a directory: %s"
#define NO_X_AND_S              "Can't have '-s' and '-x' together"
#define PIPE_FAILURE            "fatal: pipe: %m"
#define FORK_FAILURE            "fatal: fork: %m"
#define FOPEN_FAILURE           "fopen (%s): %m"
#define PARSE_FAILURE           "Error parsing config file"
#define CD_FAILED               "fatal: chdir (%s): %m"

/* misc.c */
#define NO_OPEN_LOCK            "Can't open lock file: %s: %m"
#define NO_UNLINK_LOCK          "Can't unlink lock file: %s: %m"
#define NO_LINK_LOCK            "Can't link lock file: %s: %m"
#define BAD_PID                 "Bad pid info in lock file %s: %s"
#define NO_WRITE_LOCK_PID       "Can't write pid to lock file: %m"
#define LOCK_EXISTS		"lock file in use already: %s"

/* tape.c */
#define FILE_SHORT              "tell pos is past end of file: %s %ld %ld"
#define NO_LOCK_TAPE            "can't lock the host: %s"
#define TAPE_INPUT_ERROR        "input error on tape file: %s:  %m"
#define FILE_VANISHED           "backlog file has disappeared(?): %s: %m"
#define FCLOSE_FAILED           "fclose (%s): %m"
#define UNLINK_FAILED           "unlink (%s): %m"
#define RENAME_FAILED           "rename (%s,%s): %m"
#define FTELL_FAILED            "ftell (%s): %m"
#define FGETS_FAILED            "fgets (%s): %m"
#define FSEEK_FAILED            "fseek (%s,%ld,SEEK_SET): %m"
#define CHECKPOINT_OPEN         "failed to open checkpoint file: %s %m"
#define BAD_CHECKPOINT          "checkpoint file had bad value."

#endif /* msgs_h__ */

