#!/usr/bin/perl -w
#
# 14all.cgi v0.2
#
# create html pages and graphics with rrdtool for mrtg + rrdtool
#
# (c) Rainer.Bawidamann@informatik.uni-ulm.de
#
# use freely, but: NO WARRANTY - USE AT YOUR OWN RISK!
#
use strict;
use CGI;

sub print_error(@);
sub read_mrtg_config();

my ($q, %targets, @sorted, %config, $cfgfile);
my ($cgidir);

### where the mrtg.cfg file is
#$cfgfile = '/home/mrtg/mrtg.cfg';
$cfgfile = '/home/rb1/public_html/mrtg/mrtg.cfg';
###

$q = new CGI;
$q->import_names('CGI');
my $meurl = $q->url();
$meurl =~ m|^[^/]+//([^/]+)(/[^/]+)*(/[^/])$|;
my ($mehost, $mepath, $mefile) = ($1, $2, $3);

$targets{_}{directory} = './';
read_mrtg_config();
my $footer = <<"EOT";
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
  <TR>
    <TD WIDTH=63><A ALT="MRTG"
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-l.gif"></A></TD>
    <TD WIDTH=25><A ALT=""
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-m.gif"></A></TD>
    <TD WIDTH=388><A ALT=""
    HREF="http://ee-staff.ethz.ch/~oetiker/webtools/mrtg/mrtg.html"><IMG
    BORDER=0 SRC="$config{icondir}mrtg-r.gif"></A></TD>
  </TR>
</TABLE>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
  <TR VALIGN=top>
  <TD WIDTH=88 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>Version 2.8.5-rrd<br>14all.cgi v0.2</FONT></TD>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE="Arial,Helvetica" SIZE=2>
  <A HREF="http://ee-staff.ethz.ch/~oetiker/">Tobias Oetiker</A>
  <A HREF="mailto:oetiker\@ee.ethz.ch">&lt;oetiker\@ee.ethz.ch&gt;</A> and
  <A HREF="http://www.bungi.com">Dave&nbsp;Rand</A>&nbsp;
  <A HREF="mailto:dlr\@bungi.com">&lt;dlr\@bungi.com&gt;</A><br>14all.cgi/RRD-patch by
  <A HREF="http://www.uni-ulm.de/~rbawidam/">Rainer&nbsp;Bawidamann</A></FONT>
  </TD>
</TR>
</TABLE>
EOT
	$footer .= $q->end_html;

if (!$q->param) {
	print $q->header, $q->start_html(
	-title => 'MRTG/RRD Index.cgi',
	-author => 'Rainer.Bawidamann@informatik.uni-ulm.de',
	-bgcolor => $config{background},
	-expires => '+10m');
	my (@dirs, %dirs, @logs);
	foreach my $tar (@sorted) {
		next if $tar eq '_';
		if (exists $targets{$tar}{directory} && ($targets{$tar}{directory} ne '.')) {
			next if exists $dirs{$targets{$tar}{directory}};
			$dirs{$targets{$tar}{directory}} = $tar;
			push @dirs, $targets{$tar}{directory};
		} else {
			push @logs, $tar;
		}
	}
	print $q->h1("Available Targets"),"\n";
	if ($#dirs > -1) {
		print $q->h2("Directories"),"\<ul>\n";
		foreach my $tar (@dirs) {
			print $q->li($q->a({href => "$meurl?dir=$tar"},
				"Group $tar")),"\n";
		}
		print '</ul><hr>';
	}
	if ($#logs > -1) {
		print $q->h2("Targets"),"\n\<table>\n";
		foreach my $tar (@logs) {
			next if $tar eq '_';
			next if $targets{$tar}{directory} ne $CGI::dir;
			print '<tr><td>',$q->a({href => "$meurl?log=$tar"},
				"$targets{$tar}{title}"),'<td>',
				$q->img({src => "$meurl?log=$tar&png=daily&small=1", alt => "daily-graph"}),
				"\n";
		}
		print '</table>';
	}
	print $footer;
} elsif (defined $CGI::dir) {
	print $q->header, $q->start_html(
		-title => "MRTG/RRD - Group $CGI::dir",
		-author => 'Rainer.Bawidamann@informatik.uni-ulm.de',
		-bgcolor => $config{background},
		-expires => '+10m');
	print $q->h1("Available Targets"),"\n\<table>\n";
	foreach my $tar (@sorted) {
		next if $tar eq '_';
		next if $targets{$tar}{directory} ne $CGI::dir;
		print '<tr><td>',$q->a({href => "$meurl?log=$tar"},
			"$targets{$tar}{title}"),'<td>',
			$q->a({href => "$meurl?log=$tar"},
			$q->img({src => "$meurl?log=$tar&png=daily&small=1", alt => "daily-graph"})),
			"\n";
	}
	print '</table>', $footer;
} elsif (defined $CGI::png) {
	print_error("CGI call error") if (!defined $CGI::log);	
	my $workdir = "$config{workdir}/$targets{$CGI::log}{directory}/";
	my $rrd = "$workdir$CGI::log.rrd";
	my $pngfile = "$workdir$CGI::log-$CGI::png.png";
	if (!-w $workdir) {
		$pngfile = "/tmp/$CGI::log-$CGI::png.png";
	}
	$pngfile .= '-s' if (defined $CGI::small);
	my %expire = qw/daily +300s weekly +1800s monthly +2h yearly +1d/;
	my %start = qw/daily -86400 weekly -604800 monthly -2593000 yearly -31536000/;
	use RRDs;
	my @args = ($pngfile, '-s', $start{$CGI::png}, '-a', 'PNG');
	my ($l1,$l2,$l3,$l4,$li,$lo) = ('','','','','','');
	if (!defined $CGI::small) {
		if (exists $targets{$CGI::log}{ylegend}) {
			push @args, '-v', $targets{$CGI::log}{ylegend}; }
		if (exists $targets{$CGI::log}{xsize}) {
			push @args, '-w', $targets{$CGI::log}{xsize}; }
		if (exists $targets{$CGI::log}{ysize}) {
			push @args, '-h', $targets{$CGI::log}{ysize}; }
		if (exists $targets{$CGI::log}{legend1}) {
			$l1 = ":".$targets{$CGI::log}{legend1}; }
		if (exists $targets{$CGI::log}{legend2}) {
			$l2 = ":".$targets{$CGI::log}{legend2}."\\l"; }
		if (exists $targets{$CGI::log}{legend3}) {
			$l3 = ":".$targets{$CGI::log}{legend3}; }
		if (exists $targets{$CGI::log}{legend4}) {
			$l4 = ":".$targets{$CGI::log}{legend4}."\\l"; }
		if (exists $targets{$CGI::log}{legendi}) {
			$li = $targets{$CGI::log}{legendi}; }
		else {	$li = "In:"; }
		$li =~ s':'\\:'; # '
		if (exists $targets{$CGI::log}{legendo}) {
			$lo = $targets{$CGI::log}{legendo}; }
		else {	$lo = "Out:"; }
		$lo =~ s':'\\:'; # '
		if ($targets{$CGI::log}{options}{integer}) {
			$li = $li . ' %.0lf';
			$lo = $lo . ' %.0lf';
		} else {
			$li = $li . ' %.3lf';
			$lo = $lo . ' %.3lf';
		}
		if ($targets{$CGI::log}{kmg}) {
			$li = $li . ' %s';
			$lo = $lo . ' %s';
		}
	} else {
		push @args, '-w',250,'-h',100;
	}
	push @args,'--alt-y-grid','--lazy','-c','MGRID#cc0000';
	if ($targets{$CGI::log}{options}{perminute}) {
		push @args, "DEF:in0=$rrd:ds0:AVERAGE", "DEF:out0=$rrd:ds1:AVERAGE",
			"CDEF:in=in0,60,*","CDEF:out=out0,60,*";
	} elsif ($targets{$CGI::log}{options}{perhour}) {
		push @args, "DEF:in0=$rrd:ds0:AVERAGE", "DEF:out0=$rrd:ds1:AVERAGE",
			"CDEF:in=in0,3600,*","CDEF:out=out0,3600,*";
	} else {
		push @args, "DEF:in=$rrd:ds0:AVERAGE", "DEF:out=$rrd:ds1:AVERAGE";
	}
	push @args, "AREA:in#00cc00$l1", "LINE1:out#0000ff$l2";
	push (@args,"DEF:min=$rrd:ds0:MAX", "DEF:mout=$rrd:ds1:MAX",
		"LINE1:min#006600$l3", "LINE1:mout#ff00ff$l4")
		if (!defined $CGI::small && (substr($CGI::png,0,1) =~ /[$targets{$CGI::log}{withpeak} ]/));
	push @args, "GPRINT:out:MAX:Max $lo",
		"GPRINT:out:AVERAGE:Average $lo",
		"GPRINT:out:LAST:Current $lo\\l",
		"GPRINT:in:MAX:Max $li",
		"GPRINT:in:AVERAGE:Average $li",
		"GPRINT:in:LAST:Current $li\\l" if (!defined $CGI::small);
	my $vtime = time;
	$vtime = $vtime - ($vtime % abs($start{$CGI::png})) - 3600 * 2;
	push @args, "VRULE:$vtime#cc0000" if $CGI::png eq 'daily';
	RRDs::graph @args;
	my $e = $RRDs::error;
	print_error("Cannot create graph: $e") if $e;
	open(PNG, "<$pngfile") || print_error("Cannot read graph file");
	print $q->header(-type => "image/png", -expires => "$expire{$CGI::png}");
	my $buf;
	while(sysread PNG,$buf,4096) {
		print STDOUT $buf;
	}
	close PNG;
} elsif (defined $CGI::log) {
	print_error ("Target $CGI::log unknown") if (!exists $targets{$CGI::log});
	print $q->header, $q->start_html(
		-title => "MRTG/RRD - Target $CGI::log",
		-author => 'Rainer.Bawidamann@informatik.uni-ulm.de',
		-bgcolor => $config{background},
		-expires => '+10m');
	if (exists $targets{$CGI::log}{pagetop}) {
		print $targets{$CGI::log}{pagetop},"\n";
	} else {
		print $q->h1("Target $targets{$CGI::log}{title}"),"\n";
	}
	my $sup = $targets{$CGI::log}{suppress};
	my $url = "$meurl?log=$CGI::log&png";
	if ($sup !~ /d/) {
		print $q->h2("'Daily' graph (5 Minute Average)"),"\n",
			$q->img({src => "$url=daily", alt => "daily-graph"}),
			"\n";
	}
	if ($sup !~ /w/) {
		print $q->h2("'Weekly' graph (30 Minute Average)"),"\n",
			$q->img({src => "$url=weekly", alt => "weekly-graph"}),
			"\n";
	}
	if ($sup !~ /m/) {
		print $q->h2("'Monthly' graph (2 Hour Average)"),"\n",
			$q->img({src => "$url=monthly", alt => "monthly-graph"}),
			"\n";
	}
	if ($sup !~ /y/) {
		print $q->h2("'Yearly' graph (1 Day Average)"),"\n",
			$q->img({src => "$url=yearly", alt => "yearly-graph"}),
			"\n";
	}
	print $footer;
} else {
	print_error("hae?");
}
exit 0;

sub read_mrtg_config()
{
	my ($opt, $tar, $val);
	my $line = '';
	my @lines;
	open(CFG, "<$cfgfile") || print_error("Cannot open config file");
	while(<CFG>) {
		chomp;
		s/\s+$//g;
		s/\s/ /g;
		next if /^ *\#/;
		next if /^ *$/;
		if (/^ +(.*)$/) {
			$lines[$#lines] .= " ".$1;
		} else {
			push @lines, $_;
		}
	}
	close CFG;
	# set some defaults
	%{$targets{_}} = (
		suppress => '',
		xsize => 400,
		ysize => 100,
		withpeak => '',
		ylegend => 'Bytes per Second',
		legend1 => 'Incoming Traffic in Bytes per Second',
		legend2 => 'Outgoing Traffic in Bytes per Second',
		legend3 => 'Maximal 5 Minute Incoming Traffic',
		legend4 => 'Maximal 5 Minute Outgoing Traffic',
		kmg => ',k,M,G,T,P'
		);
	%config = (
		writeexpires => 'No',
		background => '#ffffff'
		);
	foreach (@lines) {
		if (/^([\d\w]+)\[(\S*)\] *: *(.*)$/) {
			($tar, $opt, $val) = (lc($2), lc($1), $3);
			$3 = '' if !defined $3;
			if (!exists $targets{$tar}{target}) {
				# don't need to check for '_' as this exists in any case
				push @sorted, $tar;
				%{$targets{$tar}} = %{$targets{_}};
			}
			if ($opt eq 'options') {
				$val = lc($val);
				map {$targets{$tar}{options}{$_} = 1} ($val =~ m/([a-z]+)/g);
			} else {
				$targets{$tar}{$opt} = $val;
			}
			next;
		} elsif (/^([\d\w]+) *: *(\S*)$/) {
			($tar, $opt, $val) = (undef, lc($1), lc($2));
			$config{$opt} = $val;
			next;
		}
		$_ =~ s/</&gt;/g;
		print STDERR localtime()," MRTG/RRD index.cgi: unknown field in mrtg.conf '$_'\n";
	}
	foreach $tar (keys %targets) {
		foreach $opt (qw/legend1 legend2 legend3 legend4 legend5 legendi legendo ylegend shortlegend/) {
			$targets{$tar}{$opt} =~ s'&nbsp;' ' # '
				if exists $targets{$tar}{$opt};
		}
	}
}

sub print_error(@)
{
	print $q->header, $q->start_html(
		-title => 'MRTG/RRD index.cgi - Skript error',
		-author => 'Rainer.Bawidamann@informatik.uni-ulm.de',
		-bgcolor => "#ffffff"),
		$q->h1('Skript Error'),
		@_, $q->end_html;
	exit 0;
}
